/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ClassLoaderUtil;
import android.icu.impl.ICUDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class URLHandler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String PROPNAME = "urlhandler.props";
    private static Map<String, Method> handlers;
    private static boolean DEBUG;

    private void $$robo$$android_icu_impl_URLHandler$__constructor__() {
    }

    private static final URLHandler $$robo$$android_icu_impl_URLHandler$get(URL url) {
        block9: {
            Method m;
            if (url == null) {
                return null;
            }
            String protocol = url.getProtocol();
            if (handlers != null && (m = handlers.get(protocol)) != null) {
                try {
                    URLHandler handler = (URLHandler)m.invoke(null, url);
                    if (handler != null) {
                        return handler;
                    }
                }
                catch (IllegalAccessException e) {
                    if (DEBUG) {
                        System.err.println(e);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (DEBUG) {
                        System.err.println(e);
                    }
                }
                catch (InvocationTargetException e) {
                    if (!DEBUG) break block9;
                    System.err.println(e);
                }
            }
        }
        return URLHandler.getDefault(url);
    }

    private static final URLHandler $$robo$$android_icu_impl_URLHandler$getDefault(URL url) {
        URLHandler handler = null;
        String protocol = url.getProtocol();
        try {
            if (protocol.equals("file")) {
                handler = new FileURLHandler(url);
            } else if (protocol.equals("jar") || protocol.equals("wsjar")) {
                handler = new JarURLHandler(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler;
    }

    private final void $$robo$$android_icu_impl_URLHandler$guide(URLVisitor visitor, boolean recurse) {
        this.guide(visitor, recurse, true);
    }

    public abstract void guide(URLVisitor var1, boolean var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void __staticInitializer__() {
        HashMap<String, Method> h;
        block23: {
            DEBUG = ICUDebug.enabled("URLHandler");
            h = null;
            BufferedReader br = null;
            try {
                ClassLoader loader = ClassLoaderUtil.getClassLoader(URLHandler.class);
                InputStream is = loader.getResourceAsStream("urlhandler.props");
                if (is == null) break block23;
                Class[] params = new Class[]{URL.class};
                br = new BufferedReader(new InputStreamReader(is));
                String line = br.readLine();
                while (line != null) {
                    block24: {
                        if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                            int ix = line.indexOf(61);
                            if (ix == -1) {
                                if (!DEBUG) break;
                                System.err.println("bad urlhandler line: '" + line + "'");
                                break;
                            }
                            String key = line.substring(0, ix).trim();
                            String value = line.substring(ix + 1).trim();
                            try {
                                Class<?> cl = Class.forName(value);
                                Method m = cl.getDeclaredMethod("get", params);
                                if (h == null) {
                                    h = new HashMap<String, Method>();
                                }
                                h.put(key, m);
                            }
                            catch (ClassNotFoundException e) {
                                if (DEBUG) {
                                    System.err.println(e);
                                }
                            }
                            catch (NoSuchMethodException e) {
                                if (DEBUG) {
                                    System.err.println(e);
                                }
                            }
                            catch (SecurityException e) {
                                if (!DEBUG) break block24;
                                System.err.println(e);
                            }
                        }
                    }
                    line = br.readLine();
                }
                br.close();
            }
            catch (Throwable t) {
                if (DEBUG) {
                    System.err.println(t);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException loader) {}
                }
            }
        }
        handlers = h;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_URLHandler$__constructor__();
    }

    public URLHandler() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_URLHandler$__constructor__(), 0, this);
    }

    public static URLHandler get(URL uRL) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_icu_impl_URLHandler$get(java.net.URL ), 0, (URL)uRL);
    }

    protected static URLHandler getDefault(URL uRL) {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_icu_impl_URLHandler$getDefault(java.net.URL ), 0, (URL)uRL);
    }

    public void guide(URLVisitor uRLVisitor, boolean bl) {
        InvokeDynamicSupport.bootstrap("guide", $$robo$$android_icu_impl_URLHandler$guide(android.icu.impl.URLHandler$URLVisitor boolean ), 0, this, uRLVisitor, bl);
    }

    static {
        RobolectricInternals.classInitializing(URLHandler.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (URLHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface URLVisitor
    extends InstrumentedInterface {
        public void visit(String var1);
    }

    private static class JarURLHandler
    extends URLHandler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        JarFile jarFile;
        String prefix;

        private void $$robo$$android_icu_impl_URLHandler_JarURLHandler$__constructor__(URL url) {
            try {
                String urlStr;
                int idx;
                String protocol;
                this.prefix = url.getPath();
                int ix = this.prefix.lastIndexOf("!/");
                if (ix >= 0) {
                    this.prefix = this.prefix.substring(ix + 2);
                }
                if (!(protocol = url.getProtocol()).equals("jar") && (idx = (urlStr = url.toString()).indexOf(":")) != -1) {
                    url = new URL("jar" + urlStr.substring(idx));
                }
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                this.jarFile = conn.getJarFile();
            }
            catch (Exception e) {
                if (DEBUG) {
                    System.err.println("icurb jar error: " + e);
                }
                throw new IllegalArgumentException("jar error: " + e.getMessage());
            }
        }

        private final void $$robo$$android_icu_impl_URLHandler_JarURLHandler$guide(URLVisitor v, boolean recurse, boolean strip) {
            block4: {
                try {
                    Enumeration<JarEntry> entries = this.jarFile.entries();
                    while (entries.hasMoreElements()) {
                        int ix;
                        String name;
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !(name = entry.getName()).startsWith(this.prefix) || (ix = (name = name.substring(this.prefix.length())).lastIndexOf(47)) > 0 && !recurse) continue;
                        if (strip && ix != -1) {
                            name = name.substring(ix + 1);
                        }
                        v.visit(name);
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    System.err.println("icurb jar error: " + e);
                }
            }
        }

        private void __constructor__(URL uRL) {
            this.$$robo$$android_icu_impl_URLHandler_JarURLHandler$__constructor__(uRL);
        }

        JarURLHandler(URL uRL) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_URLHandler_JarURLHandler$__constructor__(java.net.URL ), 0, this, uRL);
        }

        @Override
        public void guide(URLVisitor uRLVisitor, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("guide", $$robo$$android_icu_impl_URLHandler_JarURLHandler$guide(android.icu.impl.URLHandler$URLVisitor boolean boolean ), 0, this, uRLVisitor, bl, bl2);
        }

        public /* synthetic */ JarURLHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JarURLHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class FileURLHandler
    extends URLHandler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        File file;

        private void $$robo$$android_icu_impl_URLHandler_FileURLHandler$__constructor__(URL url) {
            try {
                this.file = new File(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (this.file == null || !this.file.exists()) {
                if (DEBUG) {
                    System.err.println("file does not exist - " + url.toString());
                }
                throw new IllegalArgumentException();
            }
        }

        private final void $$robo$$android_icu_impl_URLHandler_FileURLHandler$guide(URLVisitor v, boolean recurse, boolean strip) {
            if (this.file.isDirectory()) {
                this.process(v, recurse, strip, "/", this.file.listFiles());
            } else {
                v.visit(this.file.getName());
            }
        }

        private final void $$robo$$android_icu_impl_URLHandler_FileURLHandler$process(URLVisitor v, boolean recurse, boolean strip, String path, File[] files) {
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File f = files[i];
                    if (f.isDirectory()) {
                        if (!recurse) continue;
                        this.process(v, recurse, strip, path + f.getName() + '/', f.listFiles());
                        continue;
                    }
                    v.visit(strip ? f.getName() : path + f.getName());
                }
            }
        }

        private void __constructor__(URL uRL) {
            this.$$robo$$android_icu_impl_URLHandler_FileURLHandler$__constructor__(uRL);
        }

        FileURLHandler(URL uRL) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_URLHandler_FileURLHandler$__constructor__(java.net.URL ), 0, this, uRL);
        }

        @Override
        public void guide(URLVisitor uRLVisitor, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("guide", $$robo$$android_icu_impl_URLHandler_FileURLHandler$guide(android.icu.impl.URLHandler$URLVisitor boolean boolean ), 0, this, uRLVisitor, bl, bl2);
        }

        private void process(URLVisitor uRLVisitor, boolean bl, boolean bl2, String string2, File[] fileArray) {
            InvokeDynamicSupport.bootstrap("process", $$robo$$android_icu_impl_URLHandler_FileURLHandler$process(android.icu.impl.URLHandler$URLVisitor boolean boolean java.lang.String java.io.File[] ), 0, this, uRLVisitor, bl, bl2, string2, fileArray);
        }

        public /* synthetic */ FileURLHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileURLHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

