/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.Normalizer2Impl;
import android.icu.impl.Trie2;
import android.icu.impl.Utility;
import android.icu.impl.coll.Collation;
import android.icu.impl.coll.CollationData;
import android.icu.text.UnicodeSet;
import android.icu.util.CharsTrie;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Iterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TailoredSet
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CollationData data;
    private CollationData baseData;
    private UnicodeSet tailored;
    private StringBuilder unreversedPrefix;
    private String suffix;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_coll_TailoredSet$__constructor__(UnicodeSet t) {
        this.unreversedPrefix = new StringBuilder();
        this.tailored = t;
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$forData(CollationData d) {
        this.data = d;
        this.baseData = d.base;
        if (!$assertionsDisabled && this.baseData == null) {
            throw new AssertionError();
        }
        for (Trie2.Range range : this.data.trie) {
            if (range.leadSurrogate) break;
            this.enumTailoredRange(range.startCodePoint, range.endCodePoint, range.value, this);
        }
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$enumTailoredRange(int start, int end, int ce32, TailoredSet ts) {
        if (ce32 == 192) {
            return;
        }
        ts.handleCE32(start, end, ce32);
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$handleCE32(int start, int end, int ce32) {
        if (!$assertionsDisabled && ce32 == 192) {
            throw new AssertionError();
        }
        if (Collation.isSpecialCE32(ce32) && (ce32 = this.data.getIndirectCE32(ce32)) == 192) {
            return;
        }
        do {
            int baseCE32 = this.baseData.getFinalCE32(this.baseData.getCE32(start));
            if (Collation.isSelfContainedCE32(ce32) && Collation.isSelfContainedCE32(baseCE32)) {
                if (ce32 == baseCE32) continue;
                this.tailored.add(start);
                continue;
            }
            this.compare(start, ce32, baseCE32);
        } while (++start <= end);
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$compare(int c, int ce32, int baseCE32) {
        int baseTag;
        int tag;
        int baseIndex;
        int baseIndex2;
        int dataIndex;
        if (Collation.isPrefixCE32(ce32)) {
            dataIndex = Collation.indexFromCE32(ce32);
            ce32 = this.data.getFinalCE32(this.data.getCE32FromContexts(dataIndex));
            if (Collation.isPrefixCE32(baseCE32)) {
                baseIndex2 = Collation.indexFromCE32(baseCE32);
                baseCE32 = this.baseData.getFinalCE32(this.baseData.getCE32FromContexts(baseIndex2));
                this.comparePrefixes(c, this.data.contexts, dataIndex + 2, this.baseData.contexts, baseIndex2 + 2);
            } else {
                this.addPrefixes(this.data, c, this.data.contexts, dataIndex + 2);
            }
        } else if (Collation.isPrefixCE32(baseCE32)) {
            baseIndex = Collation.indexFromCE32(baseCE32);
            baseCE32 = this.baseData.getFinalCE32(this.baseData.getCE32FromContexts(baseIndex));
            this.addPrefixes(this.baseData, c, this.baseData.contexts, baseIndex + 2);
        }
        if (Collation.isContractionCE32(ce32)) {
            dataIndex = Collation.indexFromCE32(ce32);
            ce32 = (ce32 & 0x100) != 0 ? 1 : this.data.getFinalCE32(this.data.getCE32FromContexts(dataIndex));
            if (Collation.isContractionCE32(baseCE32)) {
                baseIndex2 = Collation.indexFromCE32(baseCE32);
                baseCE32 = (baseCE32 & 0x100) != 0 ? 1 : this.baseData.getFinalCE32(this.baseData.getCE32FromContexts(baseIndex2));
                this.compareContractions(c, this.data.contexts, dataIndex + 2, this.baseData.contexts, baseIndex2 + 2);
            } else {
                this.addContractions(c, this.data.contexts, dataIndex + 2);
            }
        } else if (Collation.isContractionCE32(baseCE32)) {
            baseIndex = Collation.indexFromCE32(baseCE32);
            baseCE32 = this.baseData.getFinalCE32(this.baseData.getCE32FromContexts(baseIndex));
            this.addContractions(c, this.baseData.contexts, baseIndex + 2);
        }
        if (Collation.isSpecialCE32(ce32)) {
            tag = Collation.tagFromCE32(ce32);
            if (!$assertionsDisabled && tag == 8) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && tag == 9) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && tag == 14) {
                throw new AssertionError();
            }
        } else {
            tag = -1;
        }
        if (Collation.isSpecialCE32(baseCE32)) {
            baseTag = Collation.tagFromCE32(baseCE32);
            if (!$assertionsDisabled && baseTag == 8) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && baseTag == 9) {
                throw new AssertionError();
            }
        } else {
            baseTag = -1;
        }
        if (baseTag == 14) {
            if (!Collation.isLongPrimaryCE32(ce32)) {
                this.add(c);
                return;
            }
            long dataCE = this.baseData.ces[Collation.indexFromCE32(baseCE32)];
            long p = Collation.getThreeBytePrimaryForOffsetData(c, dataCE);
            if (Collation.primaryFromLongPrimaryCE32(ce32) != p) {
                this.add(c);
                return;
            }
        }
        if (tag != baseTag) {
            this.add(c);
            return;
        }
        if (tag == 5) {
            int baseLength;
            int length = Collation.lengthFromCE32(ce32);
            if (length != (baseLength = Collation.lengthFromCE32(baseCE32))) {
                this.add(c);
                return;
            }
            int idx0 = Collation.indexFromCE32(ce32);
            int idx1 = Collation.indexFromCE32(baseCE32);
            for (int i = 0; i < length; ++i) {
                if (this.data.ce32s[idx0 + i] == this.baseData.ce32s[idx1 + i]) continue;
                this.add(c);
                break;
            }
        } else if (tag == 6) {
            int baseLength;
            int length = Collation.lengthFromCE32(ce32);
            if (length != (baseLength = Collation.lengthFromCE32(baseCE32))) {
                this.add(c);
                return;
            }
            int idx0 = Collation.indexFromCE32(ce32);
            int idx1 = Collation.indexFromCE32(baseCE32);
            for (int i = 0; i < length; ++i) {
                if (this.data.ces[idx0 + i] == this.baseData.ces[idx1 + i]) continue;
                this.add(c);
                break;
            }
        } else if (tag == 12) {
            StringBuilder jamos = new StringBuilder();
            int length = Normalizer2Impl.Hangul.decompose(c, jamos);
            if (this.tailored.contains(jamos.charAt(0)) || this.tailored.contains(jamos.charAt(1)) || length == 3 && this.tailored.contains(jamos.charAt(2))) {
                this.add(c);
            }
        } else if (ce32 != baseCE32) {
            this.add(c);
        }
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$comparePrefixes(int c, CharSequence p, int pidx, CharSequence q, int qidx) {
        Iterator prefixes = new CharsTrie(p, pidx).iterator();
        Iterator basePrefixes = new CharsTrie(q, qidx).iterator();
        String tp = null;
        String bp = null;
        String none = "\uffff";
        Object te = null;
        Object be = null;
        while (true) {
            if (tp == null) {
                if (((CharsTrie.Iterator)prefixes).hasNext()) {
                    te = ((CharsTrie.Iterator)prefixes).next();
                    tp = ((CharsTrie.Entry)te).chars.toString();
                } else {
                    te = null;
                    tp = none;
                }
            }
            if (bp == null) {
                if (((CharsTrie.Iterator)basePrefixes).hasNext()) {
                    be = ((CharsTrie.Iterator)basePrefixes).next();
                    bp = ((CharsTrie.Entry)be).chars.toString();
                } else {
                    be = null;
                    bp = none;
                }
            }
            if (Utility.sameObjects(tp, none) && Utility.sameObjects(bp, none)) break;
            int cmp = tp.compareTo(bp);
            if (cmp < 0) {
                if (!$assertionsDisabled && te == null) {
                    throw new AssertionError();
                }
                this.addPrefix(this.data, tp, c, ((CharsTrie.Entry)te).value);
                te = null;
                tp = null;
                continue;
            }
            if (cmp > 0) {
                if (!$assertionsDisabled && be == null) {
                    throw new AssertionError();
                }
                this.addPrefix(this.baseData, bp, c, ((CharsTrie.Entry)be).value);
                be = null;
                bp = null;
                continue;
            }
            this.setPrefix(tp);
            if (!($assertionsDisabled || te != null && be != null)) {
                throw new AssertionError();
            }
            this.compare(c, ((CharsTrie.Entry)te).value, ((CharsTrie.Entry)be).value);
            this.resetPrefix();
            be = null;
            te = null;
            bp = null;
            tp = null;
        }
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$compareContractions(int c, CharSequence p, int pidx, CharSequence q, int qidx) {
        Iterator suffixes = new CharsTrie(p, pidx).iterator();
        Iterator baseSuffixes = new CharsTrie(q, qidx).iterator();
        String ts = null;
        String bs = null;
        String none = "\uffff\uffff";
        Object te = null;
        Object be = null;
        while (true) {
            if (ts == null) {
                if (((CharsTrie.Iterator)suffixes).hasNext()) {
                    te = ((CharsTrie.Iterator)suffixes).next();
                    ts = ((CharsTrie.Entry)te).chars.toString();
                } else {
                    te = null;
                    ts = none;
                }
            }
            if (bs == null) {
                if (((CharsTrie.Iterator)baseSuffixes).hasNext()) {
                    be = ((CharsTrie.Iterator)baseSuffixes).next();
                    bs = ((CharsTrie.Entry)be).chars.toString();
                } else {
                    be = null;
                    bs = none;
                }
            }
            if (Utility.sameObjects(ts, none) && Utility.sameObjects(bs, none)) break;
            int cmp = ts.compareTo(bs);
            if (cmp < 0) {
                this.addSuffix(c, ts);
                te = null;
                ts = null;
                continue;
            }
            if (cmp > 0) {
                this.addSuffix(c, bs);
                be = null;
                bs = null;
                continue;
            }
            this.suffix = ts;
            this.compare(c, ((CharsTrie.Entry)te).value, ((CharsTrie.Entry)be).value);
            this.suffix = null;
            be = null;
            te = null;
            bs = null;
            ts = null;
        }
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$addPrefixes(CollationData d, int c, CharSequence p, int pidx) {
        for (Object e : new CharsTrie(p, pidx)) {
            this.addPrefix(d, ((CharsTrie.Entry)e).chars, c, ((CharsTrie.Entry)e).value);
        }
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$addPrefix(CollationData d, CharSequence pfx, int c, int ce32) {
        this.setPrefix(pfx);
        ce32 = d.getFinalCE32(ce32);
        if (Collation.isContractionCE32(ce32)) {
            int idx = Collation.indexFromCE32(ce32);
            this.addContractions(c, d.contexts, idx + 2);
        }
        this.tailored.add(new StringBuilder(this.unreversedPrefix.appendCodePoint(c)));
        this.resetPrefix();
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$addContractions(int c, CharSequence p, int pidx) {
        for (Object e : new CharsTrie(p, pidx)) {
            this.addSuffix(c, ((CharsTrie.Entry)e).chars);
        }
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$addSuffix(int c, CharSequence sfx) {
        this.tailored.add(new StringBuilder(this.unreversedPrefix).appendCodePoint(c).append(sfx));
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$add(int c) {
        if (this.unreversedPrefix.length() == 0 && this.suffix == null) {
            this.tailored.add(c);
        } else {
            StringBuilder s = new StringBuilder(this.unreversedPrefix);
            s.appendCodePoint(c);
            if (this.suffix != null) {
                s.append(this.suffix);
            }
            this.tailored.add(s);
        }
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$setPrefix(CharSequence pfx) {
        this.unreversedPrefix.setLength(0);
        this.unreversedPrefix.append(pfx).reverse();
    }

    private final void $$robo$$android_icu_impl_coll_TailoredSet$resetPrefix() {
        this.unreversedPrefix.setLength(0);
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !TailoredSet.class.desiredAssertionStatus();
    }

    private void __constructor__(UnicodeSet unicodeSet) {
        this.$$robo$$android_icu_impl_coll_TailoredSet$__constructor__(unicodeSet);
    }

    public TailoredSet(UnicodeSet unicodeSet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_TailoredSet$__constructor__(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public void forData(CollationData collationData) {
        InvokeDynamicSupport.bootstrap("forData", $$robo$$android_icu_impl_coll_TailoredSet$forData(android.icu.impl.coll.CollationData ), 0, this, collationData);
    }

    private void enumTailoredRange(int n, int n2, int n3, TailoredSet tailoredSet) {
        InvokeDynamicSupport.bootstrap("enumTailoredRange", $$robo$$android_icu_impl_coll_TailoredSet$enumTailoredRange(int int int android.icu.impl.coll.TailoredSet ), 0, this, n, n2, n3, tailoredSet);
    }

    private void handleCE32(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("handleCE32", $$robo$$android_icu_impl_coll_TailoredSet$handleCE32(int int int ), 0, this, n, n2, n3);
    }

    private void compare(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_impl_coll_TailoredSet$compare(int int int ), 0, this, n, n2, n3);
    }

    private void comparePrefixes(int n, CharSequence charSequence, int n2, CharSequence charSequence2, int n3) {
        InvokeDynamicSupport.bootstrap("comparePrefixes", $$robo$$android_icu_impl_coll_TailoredSet$comparePrefixes(int java.lang.CharSequence int java.lang.CharSequence int ), 0, this, n, charSequence, n2, charSequence2, n3);
    }

    private void compareContractions(int n, CharSequence charSequence, int n2, CharSequence charSequence2, int n3) {
        InvokeDynamicSupport.bootstrap("compareContractions", $$robo$$android_icu_impl_coll_TailoredSet$compareContractions(int java.lang.CharSequence int java.lang.CharSequence int ), 0, this, n, charSequence, n2, charSequence2, n3);
    }

    private void addPrefixes(CollationData collationData, int n, CharSequence charSequence, int n2) {
        InvokeDynamicSupport.bootstrap("addPrefixes", $$robo$$android_icu_impl_coll_TailoredSet$addPrefixes(android.icu.impl.coll.CollationData int java.lang.CharSequence int ), 0, this, collationData, n, charSequence, n2);
    }

    private void addPrefix(CollationData collationData, CharSequence charSequence, int n, int n2) {
        InvokeDynamicSupport.bootstrap("addPrefix", $$robo$$android_icu_impl_coll_TailoredSet$addPrefix(android.icu.impl.coll.CollationData java.lang.CharSequence int int ), 0, this, collationData, charSequence, n, n2);
    }

    private void addContractions(int n, CharSequence charSequence, int n2) {
        InvokeDynamicSupport.bootstrap("addContractions", $$robo$$android_icu_impl_coll_TailoredSet$addContractions(int java.lang.CharSequence int ), 0, this, n, charSequence, n2);
    }

    private void addSuffix(int n, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("addSuffix", $$robo$$android_icu_impl_coll_TailoredSet$addSuffix(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    private void add(int n) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_impl_coll_TailoredSet$add(int ), 0, this, n);
    }

    private void setPrefix(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setPrefix", $$robo$$android_icu_impl_coll_TailoredSet$setPrefix(java.lang.CharSequence ), 0, this, charSequence);
    }

    private void resetPrefix() {
        InvokeDynamicSupport.bootstrap("resetPrefix", $$robo$$android_icu_impl_coll_TailoredSet$resetPrefix(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(TailoredSet.class);
    }

    public /* synthetic */ TailoredSet() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TailoredSet)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

