/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.data;

import android.icu.impl.PatternProps;
import android.icu.impl.Utility;
import android.icu.impl.data.ResourceReader;
import android.icu.text.UTF16;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TokenIterator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ResourceReader reader;
    private String line;
    private StringBuffer buf;
    private boolean done;
    private int pos;
    private int lastpos;

    private void $$robo$$android_icu_impl_data_TokenIterator$__constructor__(ResourceReader r) {
        this.reader = r;
        this.line = null;
        this.done = false;
        this.buf = new StringBuffer();
        this.lastpos = -1;
        this.pos = -1;
    }

    private final String $$robo$$android_icu_impl_data_TokenIterator$next() throws IOException {
        if (this.done) {
            return null;
        }
        while (true) {
            if (this.line == null) {
                this.line = this.reader.readLineSkippingComments();
                if (this.line == null) {
                    this.done = true;
                    return null;
                }
                this.pos = 0;
            }
            this.buf.setLength(0);
            this.lastpos = this.pos;
            this.pos = this.nextToken(this.pos);
            if (this.pos >= 0) break;
            this.line = null;
        }
        return this.buf.toString();
    }

    private final int $$robo$$android_icu_impl_data_TokenIterator$getLineNumber() {
        return this.reader.getLineNumber();
    }

    private final String $$robo$$android_icu_impl_data_TokenIterator$describePosition() {
        return this.reader.describePosition() + ':' + (this.lastpos + 1);
    }

    private final int $$robo$$android_icu_impl_data_TokenIterator$nextToken(int position) {
        if ((position = PatternProps.skipWhiteSpace(this.line, position)) == this.line.length()) {
            return -1;
        }
        int startpos = position;
        char c = this.line.charAt(position++);
        char quote = '\u0000';
        switch (c) {
            case '\"': 
            case '\'': {
                quote = c;
                break;
            }
            case '#': {
                return -1;
            }
            default: {
                this.buf.append(c);
            }
        }
        int[] posref = null;
        while (position < this.line.length()) {
            c = this.line.charAt(position);
            if (c == '\\') {
                int c32;
                if (posref == null) {
                    posref = new int[]{position + 1};
                }
                if ((c32 = Utility.unescapeAt(this.line, posref)) < 0) {
                    throw new RuntimeException("Invalid escape at " + this.reader.describePosition() + ':' + position);
                }
                UTF16.append(this.buf, c32);
                position = posref[0];
                continue;
            }
            if (quote != '\u0000' && c == quote || quote == '\u0000' && PatternProps.isWhiteSpace(c)) {
                return ++position;
            }
            if (quote == '\u0000' && c == '#') {
                return position;
            }
            this.buf.append(c);
            ++position;
        }
        if (quote != '\u0000') {
            throw new RuntimeException("Unterminated quote at " + this.reader.describePosition() + ':' + startpos);
        }
        return position;
    }

    private void __constructor__(ResourceReader resourceReader) {
        this.$$robo$$android_icu_impl_data_TokenIterator$__constructor__(resourceReader);
    }

    public TokenIterator(ResourceReader resourceReader) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_data_TokenIterator$__constructor__(android.icu.impl.data.ResourceReader ), 0, this, resourceReader);
    }

    public String next() throws IOException {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_impl_data_TokenIterator$next(), 0, this);
    }

    public int getLineNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getLineNumber", $$robo$$android_icu_impl_data_TokenIterator$getLineNumber(), 0, this);
    }

    public String describePosition() {
        return InvokeDynamicSupport.bootstrap("describePosition", $$robo$$android_icu_impl_data_TokenIterator$describePosition(), 0, this);
    }

    private int nextToken(int n) {
        return (int)InvokeDynamicSupport.bootstrap("nextToken", $$robo$$android_icu_impl_data_TokenIterator$nextToken(int ), 0, this, n);
    }

    public /* synthetic */ TokenIterator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TokenIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

