/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CharacterIteratorWrapper;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.CollationIterator;
import android.icu.impl.coll.ContractionsAndExpansions;
import android.icu.impl.coll.FCDIterCollationIterator;
import android.icu.impl.coll.FCDUTF16CollationIterator;
import android.icu.impl.coll.IterCollationIterator;
import android.icu.impl.coll.UTF16CollationIterator;
import android.icu.impl.coll.UVector32;
import android.icu.text.RuleBasedCollator;
import android.icu.text.UCharacterIterator;
import com.google.errorprone.annotations.DoNotMock;
import java.text.CharacterIterator;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class CollationElementIterator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CollationIterator iter_;
    private RuleBasedCollator rbc_;
    private int otherHalf_;
    private byte dir_;
    private UVector32 offsets_;
    private String string_;
    public static int NULLORDER = -1;
    public static int IGNORABLE = 0;
    static /* synthetic */ boolean $assertionsDisabled;

    private static final int $$robo$$android_icu_text_CollationElementIterator$primaryOrder(int ce) {
        return ce >>> 16 & 0xFFFF;
    }

    private static final int $$robo$$android_icu_text_CollationElementIterator$secondaryOrder(int ce) {
        return ce >>> 8 & 0xFF;
    }

    private static final int $$robo$$android_icu_text_CollationElementIterator$tertiaryOrder(int ce) {
        return ce & 0xFF;
    }

    private static final int $$robo$$android_icu_text_CollationElementIterator$getFirstHalf(long p, int lower32) {
        return (int)p & 0xFFFF0000 | lower32 >> 16 & 0xFF00 | lower32 >> 8 & 0xFF;
    }

    private static final int $$robo$$android_icu_text_CollationElementIterator$getSecondHalf(long p, int lower32) {
        return (int)p << 16 | lower32 >> 8 & 0xFF00 | lower32 & 0x3F;
    }

    private static final boolean $$robo$$android_icu_text_CollationElementIterator$ceNeedsTwoParts(long ce) {
        return (ce & 0xFFFF00FF003FL) != 0L;
    }

    private void $$robo$$android_icu_text_CollationElementIterator$__constructor__(RuleBasedCollator collator) {
        this.iter_ = null;
        this.rbc_ = collator;
        this.otherHalf_ = 0;
        this.dir_ = 0;
        this.offsets_ = null;
    }

    private void $$robo$$android_icu_text_CollationElementIterator$__constructor__(String source, RuleBasedCollator collator) {
        this.setText(source);
    }

    private void $$robo$$android_icu_text_CollationElementIterator$__constructor__(CharacterIterator source, RuleBasedCollator collator) {
        this.setText(source);
    }

    private void $$robo$$android_icu_text_CollationElementIterator$__constructor__(UCharacterIterator source, RuleBasedCollator collator) {
        this.setText(source);
    }

    private final int $$robo$$android_icu_text_CollationElementIterator$getOffset() {
        if (this.dir_ < 0 && this.offsets_ != null && !this.offsets_.isEmpty()) {
            int i = this.iter_.getCEsLength();
            if (this.otherHalf_ != 0) {
                ++i;
            }
            if (!$assertionsDisabled && i >= this.offsets_.size()) {
                throw new AssertionError();
            }
            return this.offsets_.elementAti(i);
        }
        return this.iter_.getOffset();
    }

    private final int $$robo$$android_icu_text_CollationElementIterator$next() {
        if (this.dir_ > 1) {
            if (this.otherHalf_ != 0) {
                int oh = this.otherHalf_;
                this.otherHalf_ = 0;
                return oh;
            }
        } else if (this.dir_ == 1) {
            this.dir_ = (byte)2;
        } else if (this.dir_ == 0) {
            this.dir_ = (byte)2;
        } else {
            throw new IllegalStateException("Illegal change of direction");
        }
        this.iter_.clearCEsIfNoneRemaining();
        long ce = this.iter_.nextCE();
        if (ce == 0x101000100L) {
            return -1;
        }
        long p = ce >>> 32;
        int lower32 = (int)ce;
        int firstHalf = CollationElementIterator.getFirstHalf(p, lower32);
        int secondHalf = CollationElementIterator.getSecondHalf(p, lower32);
        if (secondHalf != 0) {
            this.otherHalf_ = secondHalf | 0xC0;
        }
        return firstHalf;
    }

    private final int $$robo$$android_icu_text_CollationElementIterator$previous() {
        if (this.dir_ < 0) {
            if (this.otherHalf_ != 0) {
                int oh = this.otherHalf_;
                this.otherHalf_ = 0;
                return oh;
            }
        } else if (this.dir_ == 0) {
            this.iter_.resetToOffset(this.string_.length());
            this.dir_ = (byte)-1;
        } else if (this.dir_ == 1) {
            this.dir_ = (byte)-1;
        } else {
            throw new IllegalStateException("Illegal change of direction");
        }
        if (this.offsets_ == null) {
            this.offsets_ = new UVector32();
        }
        int limitOffset = this.iter_.getCEsLength() == 0 ? this.iter_.getOffset() : 0;
        long ce = this.iter_.previousCE(this.offsets_);
        if (ce == 0x101000100L) {
            return -1;
        }
        long p = ce >>> 32;
        int lower32 = (int)ce;
        int firstHalf = CollationElementIterator.getFirstHalf(p, lower32);
        int secondHalf = CollationElementIterator.getSecondHalf(p, lower32);
        if (secondHalf != 0) {
            if (this.offsets_.isEmpty()) {
                this.offsets_.addElement(this.iter_.getOffset());
                this.offsets_.addElement(limitOffset);
            }
            this.otherHalf_ = firstHalf;
            return secondHalf | 0xC0;
        }
        return firstHalf;
    }

    private final void $$robo$$android_icu_text_CollationElementIterator$reset() {
        this.iter_.resetToOffset(0);
        this.otherHalf_ = 0;
        this.dir_ = 0;
    }

    private final void $$robo$$android_icu_text_CollationElementIterator$setOffset(int newOffset) {
        if (0 < newOffset && newOffset < this.string_.length()) {
            char c;
            int offset = newOffset;
            while (this.rbc_.isUnsafe(c = this.string_.charAt(offset)) && (!Character.isHighSurrogate(c) || this.rbc_.isUnsafe(this.string_.codePointAt(offset))) && --offset > 0) {
            }
            if (offset < newOffset) {
                int lastSafeOffset = offset;
                do {
                    this.iter_.resetToOffset(lastSafeOffset);
                    do {
                        this.iter_.nextCE();
                    } while ((offset = this.iter_.getOffset()) == lastSafeOffset);
                    if (offset > newOffset) continue;
                    lastSafeOffset = offset;
                } while (offset < newOffset);
                newOffset = lastSafeOffset;
            }
        }
        this.iter_.resetToOffset(newOffset);
        this.otherHalf_ = 0;
        this.dir_ = 1;
    }

    private final void $$robo$$android_icu_text_CollationElementIterator$setText(String source) {
        this.string_ = source;
        boolean numeric = this.rbc_.settings.readOnly().isNumeric();
        UTF16CollationIterator newIter = this.rbc_.settings.readOnly().dontCheckFCD() ? new UTF16CollationIterator(this.rbc_.data, numeric, this.string_, 0) : new FCDUTF16CollationIterator(this.rbc_.data, numeric, this.string_, 0);
        this.iter_ = newIter;
        this.otherHalf_ = 0;
        this.dir_ = 0;
    }

    private final void $$robo$$android_icu_text_CollationElementIterator$setText(UCharacterIterator source) {
        UCharacterIterator src;
        this.string_ = source.getText();
        try {
            src = (UCharacterIterator)source.clone();
        }
        catch (CloneNotSupportedException e) {
            this.setText(source.getText());
            return;
        }
        src.setToStart();
        boolean numeric = this.rbc_.settings.readOnly().isNumeric();
        IterCollationIterator newIter = this.rbc_.settings.readOnly().dontCheckFCD() ? new IterCollationIterator(this.rbc_.data, numeric, src) : new FCDIterCollationIterator(this.rbc_.data, numeric, src, 0);
        this.iter_ = newIter;
        this.otherHalf_ = 0;
        this.dir_ = 0;
    }

    private final void $$robo$$android_icu_text_CollationElementIterator$setText(CharacterIterator source) {
        CharacterIteratorWrapper src = new CharacterIteratorWrapper(source);
        src.setToStart();
        this.string_ = src.getText();
        boolean numeric = this.rbc_.settings.readOnly().isNumeric();
        IterCollationIterator newIter = this.rbc_.settings.readOnly().dontCheckFCD() ? new IterCollationIterator(this.rbc_.data, numeric, src) : new FCDIterCollationIterator(this.rbc_.data, numeric, src, 0);
        this.iter_ = newIter;
        this.otherHalf_ = 0;
        this.dir_ = 0;
    }

    private static final Map<Integer, Integer> $$robo$$android_icu_text_CollationElementIterator$computeMaxExpansions(CollationData data) {
        HashMap<Integer, Integer> maxExpansions = new HashMap<Integer, Integer>();
        MaxExpSink sink = new MaxExpSink(maxExpansions);
        new ContractionsAndExpansions(null, null, sink, true).forData(data);
        return maxExpansions;
    }

    private final int $$robo$$android_icu_text_CollationElementIterator$getMaxExpansion(int ce) {
        return CollationElementIterator.getMaxExpansion(this.rbc_.tailoring.maxExpansions, ce);
    }

    private static final int $$robo$$android_icu_text_CollationElementIterator$getMaxExpansion(Map<Integer, Integer> maxExpansions, int order) {
        Integer max;
        if (order == 0) {
            return 1;
        }
        if (maxExpansions != null && (max = maxExpansions.get(order)) != null) {
            return max;
        }
        if ((order & 0xC0) == 192) {
            return 2;
        }
        return 1;
    }

    private final byte $$robo$$android_icu_text_CollationElementIterator$normalizeDir() {
        return this.dir_ == 1 ? (byte)0 : this.dir_;
    }

    private final boolean $$robo$$android_icu_text_CollationElementIterator$equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof CollationElementIterator) {
            CollationElementIterator thatceiter = (CollationElementIterator)that;
            return this.rbc_.equals(thatceiter.rbc_) && this.otherHalf_ == thatceiter.otherHalf_ && this.normalizeDir() == thatceiter.normalizeDir() && this.string_.equals(thatceiter.string_) && this.iter_.equals(thatceiter.iter_);
        }
        return false;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_CollationElementIterator$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    @Deprecated
    private final RuleBasedCollator $$robo$$android_icu_text_CollationElementIterator$getRuleBasedCollator() {
        return this.rbc_;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CollationElementIterator.class.desiredAssertionStatus();
    }

    public static int primaryOrder(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("primaryOrder", $$robo$$android_icu_text_CollationElementIterator$primaryOrder(int ), 0, (int)n);
    }

    public static int secondaryOrder(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("secondaryOrder", $$robo$$android_icu_text_CollationElementIterator$secondaryOrder(int ), 0, (int)n);
    }

    public static int tertiaryOrder(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("tertiaryOrder", $$robo$$android_icu_text_CollationElementIterator$tertiaryOrder(int ), 0, (int)n);
    }

    private static int getFirstHalf(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getFirstHalf", $$robo$$android_icu_text_CollationElementIterator$getFirstHalf(long int ), 0, (long)l, (int)n);
    }

    private static int getSecondHalf(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSecondHalf", $$robo$$android_icu_text_CollationElementIterator$getSecondHalf(long int ), 0, (long)l, (int)n);
    }

    private static boolean ceNeedsTwoParts(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("ceNeedsTwoParts", $$robo$$android_icu_text_CollationElementIterator$ceNeedsTwoParts(long ), 0, (long)l);
    }

    private void __constructor__(RuleBasedCollator ruleBasedCollator) {
        this.$$robo$$android_icu_text_CollationElementIterator$__constructor__(ruleBasedCollator);
    }

    private CollationElementIterator(RuleBasedCollator ruleBasedCollator) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CollationElementIterator$__constructor__(android.icu.text.RuleBasedCollator ), 0, this, ruleBasedCollator);
    }

    private void __constructor__(String string2, RuleBasedCollator ruleBasedCollator) {
        this.$$robo$$android_icu_text_CollationElementIterator$__constructor__(string2, ruleBasedCollator);
    }

    CollationElementIterator(String string2, RuleBasedCollator ruleBasedCollator) {
        this(ruleBasedCollator);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CollationElementIterator$__constructor__(java.lang.String android.icu.text.RuleBasedCollator ), 0, this, string2, ruleBasedCollator);
    }

    private void __constructor__(CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this.$$robo$$android_icu_text_CollationElementIterator$__constructor__(characterIterator, ruleBasedCollator);
    }

    CollationElementIterator(CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this(ruleBasedCollator);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CollationElementIterator$__constructor__(java.text.CharacterIterator android.icu.text.RuleBasedCollator ), 0, this, characterIterator, ruleBasedCollator);
    }

    private void __constructor__(UCharacterIterator uCharacterIterator, RuleBasedCollator ruleBasedCollator) {
        this.$$robo$$android_icu_text_CollationElementIterator$__constructor__(uCharacterIterator, ruleBasedCollator);
    }

    CollationElementIterator(UCharacterIterator uCharacterIterator, RuleBasedCollator ruleBasedCollator) {
        this(ruleBasedCollator);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CollationElementIterator$__constructor__(android.icu.text.UCharacterIterator android.icu.text.RuleBasedCollator ), 0, this, uCharacterIterator, ruleBasedCollator);
    }

    public int getOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_text_CollationElementIterator$getOffset(), 0, this);
    }

    public int next() {
        return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_CollationElementIterator$next(), 0, this);
    }

    public int previous() {
        return (int)InvokeDynamicSupport.bootstrap("previous", $$robo$$android_icu_text_CollationElementIterator$previous(), 0, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_CollationElementIterator$reset(), 0, this);
    }

    public void setOffset(int n) {
        InvokeDynamicSupport.bootstrap("setOffset", $$robo$$android_icu_text_CollationElementIterator$setOffset(int ), 0, this, n);
    }

    public void setText(String string2) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_CollationElementIterator$setText(java.lang.String ), 0, this, string2);
    }

    public void setText(UCharacterIterator uCharacterIterator) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_CollationElementIterator$setText(android.icu.text.UCharacterIterator ), 0, this, uCharacterIterator);
    }

    public void setText(CharacterIterator characterIterator) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_CollationElementIterator$setText(java.text.CharacterIterator ), 0, this, characterIterator);
    }

    static Map<Integer, Integer> computeMaxExpansions(CollationData collationData) {
        return InvokeDynamicSupport.bootstrapStatic("computeMaxExpansions", $$robo$$android_icu_text_CollationElementIterator$computeMaxExpansions(android.icu.impl.coll.CollationData ), 0, (CollationData)collationData);
    }

    public int getMaxExpansion(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMaxExpansion", $$robo$$android_icu_text_CollationElementIterator$getMaxExpansion(int ), 0, this, n);
    }

    static int getMaxExpansion(Map<Integer, Integer> map, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxExpansion", $$robo$$android_icu_text_CollationElementIterator$getMaxExpansion(java.util.Map<java.lang.Integer, java.lang.Integer> int ), 0, map, (int)n);
    }

    private byte normalizeDir() {
        return (byte)InvokeDynamicSupport.bootstrap("normalizeDir", $$robo$$android_icu_text_CollationElementIterator$normalizeDir(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_CollationElementIterator$equals(java.lang.Object ), 0, this, object);
    }

    @Deprecated
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_CollationElementIterator$hashCode(), 0, this);
    }

    @Deprecated
    public RuleBasedCollator getRuleBasedCollator() {
        return InvokeDynamicSupport.bootstrap("getRuleBasedCollator", $$robo$$android_icu_text_CollationElementIterator$getRuleBasedCollator(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(CollationElementIterator.class);
    }

    public /* synthetic */ CollationElementIterator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationElementIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class MaxExpSink
    implements ContractionsAndExpansions.CESink,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Map<Integer, Integer> maxExpansions;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_text_CollationElementIterator_MaxExpSink$__constructor__(Map<Integer, Integer> h) {
            this.maxExpansions = h;
        }

        private final void $$robo$$android_icu_text_CollationElementIterator_MaxExpSink$handleCE(long ce) {
        }

        private final void $$robo$$android_icu_text_CollationElementIterator_MaxExpSink$handleExpansion(long[] ces, int start, int length) {
            Integer oldCount;
            if (length <= 1) {
                return;
            }
            int count = 0;
            for (int i = 0; i < length; ++i) {
                count += CollationElementIterator.ceNeedsTwoParts(ces[start + i]) ? 2 : 1;
            }
            long ce = ces[start + length - 1];
            long p = ce >>> 32;
            int lower32 = (int)ce;
            int lastHalf = CollationElementIterator.getSecondHalf(p, lower32);
            if (lastHalf == 0) {
                lastHalf = CollationElementIterator.getFirstHalf(p, lower32);
                if (!$assertionsDisabled && lastHalf == 0) {
                    throw new AssertionError();
                }
            } else {
                lastHalf |= 0xC0;
            }
            if ((oldCount = this.maxExpansions.get(lastHalf)) == null || count > oldCount) {
                this.maxExpansions.put(lastHalf, count);
            }
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !CollationElementIterator.class.desiredAssertionStatus();
        }

        private void __constructor__(Map<Integer, Integer> map) {
            this.$$robo$$android_icu_text_CollationElementIterator_MaxExpSink$__constructor__(map);
        }

        MaxExpSink(Map<Integer, Integer> map) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CollationElementIterator_MaxExpSink$__constructor__(java.util.Map<java.lang.Integer, java.lang.Integer> ), 0, this, map);
        }

        @Override
        public void handleCE(long l) {
            InvokeDynamicSupport.bootstrap("handleCE", $$robo$$android_icu_text_CollationElementIterator_MaxExpSink$handleCE(long ), 0, this, l);
        }

        @Override
        public void handleExpansion(long[] lArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("handleExpansion", $$robo$$android_icu_text_CollationElementIterator_MaxExpSink$handleExpansion(long[] int int ), 0, this, lArray, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(MaxExpSink.class);
        }

        public /* synthetic */ MaxExpSink() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MaxExpSink)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

