/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.PatternTokenizer;
import android.icu.impl.SimpleCache;
import android.icu.impl.SimpleFormatterImpl;
import android.icu.impl.UResource;
import android.icu.text.DateFormat;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.SimpleDateFormat;
import android.icu.text.UnicodeSet;
import android.icu.util.Calendar;
import android.icu.util.Freezable;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DateTimePatternGenerator
implements Freezable<DateTimePatternGenerator>,
Cloneable {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String[] LAST_RESORT_ALLOWED_HOUR_FORMAT;
    static Map<String, String[]> LOCALE_TO_ALLOWED_HOUR;
    public static int ERA = 0;
    public static int YEAR = 1;
    public static int QUARTER = 2;
    public static int MONTH = 3;
    public static int WEEK_OF_YEAR = 4;
    public static int WEEK_OF_MONTH = 5;
    public static int WEEKDAY = 6;
    public static int DAY = 7;
    public static int DAY_OF_YEAR = 8;
    public static int DAY_OF_WEEK_IN_MONTH = 9;
    public static int DAYPERIOD = 10;
    public static int HOUR = 11;
    public static int MINUTE = 12;
    public static int SECOND = 13;
    public static int FRACTIONAL_SECOND = 14;
    public static int ZONE = 15;
    @Deprecated
    public static int TYPE_LIMIT = 16;
    public static int MATCH_NO_OPTIONS = 0;
    public static int MATCH_HOUR_FIELD_LENGTH = 2048;
    @Deprecated
    public static int MATCH_MINUTE_FIELD_LENGTH = 4096;
    @Deprecated
    public static int MATCH_SECOND_FIELD_LENGTH = 8192;
    public static int MATCH_ALL_FIELDS_LENGTH = 65535;
    private TreeMap<DateTimeMatcher, PatternWithSkeletonFlag> skeleton2pattern;
    private TreeMap<String, PatternWithSkeletonFlag> basePattern_pattern;
    private String decimal;
    private String dateTimeFormat;
    private String[] appendItemFormats;
    private String[] appendItemNames;
    private char defaultHourFormatChar;
    private volatile boolean frozen;
    private transient DateTimeMatcher current;
    private transient FormatParser fp;
    private transient DistanceInfo _distanceInfo;
    private String[] allowedHourFormats;
    private static int FRACTIONAL_MASK = 16384;
    private static int SECOND_AND_FRACTIONAL_MASK = 24576;
    private static ICUCache<String, DateTimePatternGenerator> DTPNG_CACHE;
    private static String[] CLDR_FIELD_APPEND;
    private static String[] CLDR_FIELD_NAME;
    private static String[] FIELD_NAME;
    private static String[] CANONICAL_ITEMS;
    private static Set<String> CANONICAL_SET;
    private Set<String> cldrAvailableFormatKeys;
    private static int DATE_MASK = 1023;
    private static int TIME_MASK = 64512;
    private static int DELTA = 16;
    private static int NUMERIC = 256;
    private static int NONE = 0;
    private static int NARROW = -257;
    private static int SHORT = -258;
    private static int LONG = -259;
    private static int EXTRA_FIELD = 65536;
    private static int MISSING_FIELD = 4096;
    private static int[][] types;

    private static final DateTimePatternGenerator $$robo$$android_icu_text_DateTimePatternGenerator$getEmptyInstance() {
        DateTimePatternGenerator instance = new DateTimePatternGenerator();
        instance.addCanonicalItems();
        instance.fillInMissing();
        return instance;
    }

    private void $$robo$$android_icu_text_DateTimePatternGenerator$__constructor__() {
        this.skeleton2pattern = new TreeMap();
        this.basePattern_pattern = new TreeMap();
        this.decimal = "?";
        this.dateTimeFormat = "{1} {0}";
        this.appendItemFormats = new String[16];
        this.appendItemNames = new String[16];
        this.defaultHourFormatChar = (char)72;
        this.frozen = false;
        this.current = new DateTimeMatcher();
        this.fp = new FormatParser();
        this._distanceInfo = new DistanceInfo();
        this.cldrAvailableFormatKeys = new HashSet<String>(20);
    }

    private static final DateTimePatternGenerator $$robo$$android_icu_text_DateTimePatternGenerator$getInstance() {
        return DateTimePatternGenerator.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static final DateTimePatternGenerator $$robo$$android_icu_text_DateTimePatternGenerator$getInstance(ULocale uLocale) {
        return DateTimePatternGenerator.getFrozenInstance(uLocale).cloneAsThawed();
    }

    private static final DateTimePatternGenerator $$robo$$android_icu_text_DateTimePatternGenerator$getInstance(Locale locale) {
        return DateTimePatternGenerator.getInstance(ULocale.forLocale(locale));
    }

    @Deprecated
    private static final DateTimePatternGenerator $$robo$$android_icu_text_DateTimePatternGenerator$getFrozenInstance(ULocale uLocale) {
        String localeKey = uLocale.toString();
        DateTimePatternGenerator result = DTPNG_CACHE.get(localeKey);
        if (result != null) {
            return result;
        }
        result = new DateTimePatternGenerator();
        result.initData(uLocale);
        result.freeze();
        DTPNG_CACHE.put(localeKey, result);
        return result;
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$initData(ULocale uLocale) {
        PatternInfo returnInfo = new PatternInfo();
        this.addCanonicalItems();
        this.addICUPatterns(returnInfo, uLocale);
        this.addCLDRData(returnInfo, uLocale);
        this.setDateTimeFromCalendar(uLocale);
        this.setDecimalSymbols(uLocale);
        this.getAllowedHourFormats(uLocale);
        this.fillInMissing();
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$addICUPatterns(PatternInfo returnInfo, ULocale uLocale) {
        for (int i = 0; i <= 3; ++i) {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(i, uLocale);
            this.addPattern(df.toPattern(), false, returnInfo);
            df = (SimpleDateFormat)DateFormat.getTimeInstance(i, uLocale);
            this.addPattern(df.toPattern(), false, returnInfo);
            if (i != 3) continue;
            this.consumeShortTimePattern(df.toPattern(), returnInfo);
        }
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getCalendarTypeToUse(ULocale uLocale) {
        String calendarTypeToUse = uLocale.getKeywordValue("calendar");
        if (calendarTypeToUse == null) {
            String[] preferredCalendarTypes = Calendar.getKeywordValuesForLocale("calendar", uLocale, true);
            calendarTypeToUse = preferredCalendarTypes[0];
        }
        if (calendarTypeToUse == null) {
            calendarTypeToUse = "gregorian";
        }
        return calendarTypeToUse;
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$consumeShortTimePattern(String shortTimePattern, PatternInfo returnInfo) {
        FormatParser fp = new FormatParser();
        fp.set(shortTimePattern);
        List<Object> items = fp.getItems();
        for (int idx = 0; idx < items.size(); ++idx) {
            VariableField fld;
            Object item = items.get(idx);
            if (!(item instanceof VariableField) || (fld = (VariableField)item).getType() != 11) continue;
            this.defaultHourFormatChar = fld.toString().charAt(0);
            break;
        }
        this.hackTimes(returnInfo, shortTimePattern);
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$fillInMissing() {
        for (int i = 0; i < 16; ++i) {
            if (this.getAppendItemFormat(i) == null) {
                this.setAppendItemFormat(i, "{0} \u251c{2}: {1}\u2524");
            }
            if (this.getAppendItemName(i) != null) continue;
            this.setAppendItemName(i, "F" + i);
        }
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$addCLDRData(PatternInfo returnInfo, ULocale uLocale) {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", uLocale);
        String calendarTypeToUse = this.getCalendarTypeToUse(uLocale);
        AppendItemFormatsSink appendItemFormatsSink = new AppendItemFormatsSink(this);
        try {
            rb.getAllItemsWithFallback("calendar/" + calendarTypeToUse + "/appendItems", appendItemFormatsSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AppendItemNamesSink appendItemNamesSink = new AppendItemNamesSink(this);
        try {
            rb.getAllItemsWithFallback("fields", appendItemNamesSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AvailableFormatsSink availableFormatsSink = new AvailableFormatsSink(this, returnInfo);
        try {
            rb.getAllItemsWithFallback("calendar/" + calendarTypeToUse + "/availableFormats", availableFormatsSink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$setDateTimeFromCalendar(ULocale uLocale) {
        String dateTimeFormat = Calendar.getDateTimePattern(Calendar.getInstance(uLocale), uLocale, 2);
        this.setDateTimeFormat(dateTimeFormat);
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$setDecimalSymbols(ULocale uLocale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(uLocale);
        this.setDecimal(String.valueOf(dfs.getDecimalSeparator()));
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$getAllowedHourFormats(ULocale uLocale) {
        String langCountry;
        String[] list;
        ULocale max = ULocale.addLikelySubtags(uLocale);
        String country = max.getCountry();
        if (country.isEmpty()) {
            country = "001";
        }
        if ((list = LOCALE_TO_ALLOWED_HOUR.get(langCountry = max.getLanguage() + "_" + country)) == null && (list = LOCALE_TO_ALLOWED_HOUR.get(country)) == null) {
            list = LAST_RESORT_ALLOWED_HOUR_FORMAT;
        }
        this.allowedHourFormats = list;
    }

    @Deprecated
    private final char $$robo$$android_icu_text_DateTimePatternGenerator$getDefaultHourFormatChar() {
        return this.defaultHourFormatChar;
    }

    @Deprecated
    private final void $$robo$$android_icu_text_DateTimePatternGenerator$setDefaultHourFormatChar(char defaultHourFormatChar) {
        this.defaultHourFormatChar = defaultHourFormatChar;
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$hackTimes(PatternInfo returnInfo, String shortTimePattern) {
        this.fp.set(shortTimePattern);
        StringBuilder mmss = new StringBuilder();
        boolean gotMm = false;
        for (int i = 0; i < this.fp.items.size(); ++i) {
            Object item = this.fp.items.get(i);
            if (item instanceof String) {
                if (!gotMm) continue;
                mmss.append(this.fp.quoteLiteral(item.toString()));
                continue;
            }
            char ch = item.toString().charAt(0);
            if (ch == 'm') {
                gotMm = true;
                mmss.append(item);
                continue;
            }
            if (ch == 's') {
                if (!gotMm) break;
                mmss.append(item);
                this.addPattern(mmss.toString(), false, returnInfo);
                break;
            }
            if (gotMm || ch == 'z' || ch == 'Z' || ch == 'v' || ch == 'V') break;
        }
        BitSet variables = new BitSet();
        BitSet nuke = new BitSet();
        for (int i = 0; i < this.fp.items.size(); ++i) {
            Object item = this.fp.items.get(i);
            if (!(item instanceof VariableField)) continue;
            variables.set(i);
            char ch = item.toString().charAt(0);
            if (ch != 's' && ch != 'S') continue;
            nuke.set(i);
            for (int j = i - 1; j >= 0 && !variables.get(j); ++j) {
                nuke.set(i);
            }
        }
        String hhmm = DateTimePatternGenerator.getFilteredPattern(this.fp, nuke);
        this.addPattern(hhmm, false, returnInfo);
    }

    private static final String $$robo$$android_icu_text_DateTimePatternGenerator$getFilteredPattern(FormatParser fp, BitSet nuke) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < fp.items.size(); ++i) {
            if (nuke.get(i)) continue;
            Object item = fp.items.get(i);
            if (item instanceof String) {
                result.append(fp.quoteLiteral(item.toString()));
                continue;
            }
            result.append(item.toString());
        }
        return result.toString();
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_DateTimePatternGenerator$getAppendFormatNumber(UResource.Key key) {
        for (int i = 0; i < CLDR_FIELD_APPEND.length; ++i) {
            if (!key.contentEquals(CLDR_FIELD_APPEND[i])) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_DateTimePatternGenerator$getAppendFormatNumber(String string2) {
        for (int i = 0; i < CLDR_FIELD_APPEND.length; ++i) {
            if (!CLDR_FIELD_APPEND[i].equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private static final int $$robo$$android_icu_text_DateTimePatternGenerator$getCLDRFieldNumber(UResource.Key key) {
        for (int i = 0; i < CLDR_FIELD_NAME.length; ++i) {
            if (!key.contentEquals(CLDR_FIELD_NAME[i])) continue;
            return i;
        }
        return -1;
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getBestPattern(String skeleton) {
        return this.getBestPattern(skeleton, null, 0);
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getBestPattern(String skeleton, int options) {
        return this.getBestPattern(skeleton, null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getBestPattern(String skeleton, DateTimeMatcher skipMatcher, int options) {
        String timePattern;
        String datePattern;
        EnumSet<DTPGflags> flags = EnumSet.noneOf(DTPGflags.class);
        StringBuilder skeletonCopy = new StringBuilder(skeleton);
        boolean inQuoted = false;
        for (int patPos = 0; patPos < skeleton.length(); ++patPos) {
            char patChr = skeleton.charAt(patPos);
            if (patChr == '\'') {
                inQuoted = !inQuoted;
                continue;
            }
            if (inQuoted) continue;
            if (patChr == 'j') {
                skeletonCopy.setCharAt(patPos, this.defaultHourFormatChar);
                continue;
            }
            if (patChr == 'C') {
                String preferred = this.allowedHourFormats[0];
                skeletonCopy.setCharAt(patPos, preferred.charAt(0));
                DTPGflags alt = DTPGflags.getFlag(preferred);
                if (alt == null) continue;
                flags.add(alt);
                continue;
            }
            if (patChr != 'J') continue;
            skeletonCopy.setCharAt(patPos, 'H');
            flags.add(DTPGflags.SKELETON_USES_CAP_J);
        }
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(skeletonCopy.toString(), this.fp, false);
            PatternWithMatcher bestWithMatcher = this.getBestRaw(this.current, -1, this._distanceInfo, skipMatcher);
            if (this._distanceInfo.missingFieldMask == 0 && this._distanceInfo.extraFieldMask == 0) {
                return this.adjustFieldTypes(bestWithMatcher, this.current, flags, options);
            }
            int neededFields = this.current.getFieldMask();
            datePattern = this.getBestAppending(this.current, neededFields & 0x3FF, this._distanceInfo, skipMatcher, flags, options);
            timePattern = this.getBestAppending(this.current, neededFields & 0xFC00, this._distanceInfo, skipMatcher, flags, options);
        }
        if (datePattern == null) {
            return timePattern == null ? "" : timePattern;
        }
        if (timePattern == null) {
            return datePattern;
        }
        return SimpleFormatterImpl.formatRawPattern(this.getDateTimeFormat(), 2, 2, timePattern, datePattern);
    }

    private final DateTimePatternGenerator $$robo$$android_icu_text_DateTimePatternGenerator$addPattern(String pattern, boolean override, PatternInfo returnInfo) {
        return this.addPatternWithSkeleton(pattern, null, override, returnInfo);
    }

    @Deprecated
    private final DateTimePatternGenerator $$robo$$android_icu_text_DateTimePatternGenerator$addPatternWithSkeleton(String pattern, String skeletonToUse, boolean override, PatternInfo returnInfo) {
        PatternWithSkeletonFlag previousValue;
        this.checkFrozen();
        DateTimeMatcher matcher = skeletonToUse == null ? new DateTimeMatcher().set(pattern, this.fp, false) : new DateTimeMatcher().set(skeletonToUse, this.fp, false);
        String basePattern = matcher.getBasePattern();
        PatternWithSkeletonFlag previousPatternWithSameBase = this.basePattern_pattern.get(basePattern);
        if (previousPatternWithSameBase != null && (!previousPatternWithSameBase.skeletonWasSpecified || skeletonToUse != null && !override)) {
            returnInfo.status = 1;
            returnInfo.conflictingPattern = previousPatternWithSameBase.pattern;
            if (!override) {
                return this;
            }
        }
        if ((previousValue = this.skeleton2pattern.get(matcher)) != null) {
            returnInfo.status = 2;
            returnInfo.conflictingPattern = previousValue.pattern;
            if (!override || skeletonToUse != null && previousValue.skeletonWasSpecified) {
                return this;
            }
        }
        returnInfo.status = 0;
        returnInfo.conflictingPattern = "";
        PatternWithSkeletonFlag patWithSkelFlag = new PatternWithSkeletonFlag(pattern, skeletonToUse != null);
        this.skeleton2pattern.put(matcher, patWithSkelFlag);
        this.basePattern_pattern.put(basePattern, patWithSkelFlag);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, false);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getSkeletonAllowingDuplicates(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, true);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getCanonicalSkeletonAllowingDuplicates(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, true);
            return this.current.toCanonicalString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getBaseSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp, false);
            return this.current.getBasePattern();
        }
    }

    private final Map<String, String> $$robo$$android_icu_text_DateTimePatternGenerator$getSkeletons(Map<String, String> result) {
        if (result == null) {
            result = new LinkedHashMap<String, String>();
        }
        for (DateTimeMatcher item : this.skeleton2pattern.keySet()) {
            PatternWithSkeletonFlag patternWithSkelFlag = this.skeleton2pattern.get(item);
            String pattern = patternWithSkelFlag.pattern;
            if (CANONICAL_SET.contains(pattern)) continue;
            result.put(item.toString(), pattern);
        }
        return result;
    }

    private final Set<String> $$robo$$android_icu_text_DateTimePatternGenerator$getBaseSkeletons(Set<String> result) {
        if (result == null) {
            result = new HashSet<String>();
        }
        result.addAll(this.basePattern_pattern.keySet());
        return result;
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$replaceFieldTypes(String pattern, String skeleton) {
        return this.replaceFieldTypes(pattern, skeleton, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_text_DateTimePatternGenerator$replaceFieldTypes(String pattern, String skeleton, int options) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            PatternWithMatcher patternNoMatcher = new PatternWithMatcher(pattern, null);
            return this.adjustFieldTypes(patternNoMatcher, this.current.set(skeleton, this.fp, false), EnumSet.noneOf(DTPGflags.class), options);
        }
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$setDateTimeFormat(String dateTimeFormat) {
        this.checkFrozen();
        this.dateTimeFormat = dateTimeFormat;
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$setDecimal(String decimal) {
        this.checkFrozen();
        this.decimal = decimal;
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getDecimal() {
        return this.decimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final Collection<String> $$robo$$android_icu_text_DateTimePatternGenerator$getRedundants(Collection<String> output) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            if (output == null) {
                output = new LinkedHashSet<String>();
            }
            for (DateTimeMatcher cur : this.skeleton2pattern.keySet()) {
                String trial;
                PatternWithSkeletonFlag patternWithSkelFlag = this.skeleton2pattern.get(cur);
                String pattern = patternWithSkelFlag.pattern;
                if (CANONICAL_SET.contains(pattern) || !(trial = this.getBestPattern(cur.toString(), cur, 0)).equals(pattern)) continue;
                output.add(pattern);
            }
            return output;
        }
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$setAppendItemFormat(int field, String value) {
        this.checkFrozen();
        this.appendItemFormats[field] = value;
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getAppendItemFormat(int field) {
        return this.appendItemFormats[field];
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$setAppendItemName(int field, String value) {
        this.checkFrozen();
        this.appendItemNames[field] = value;
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getAppendItemName(int field) {
        return this.appendItemNames[field];
    }

    @Deprecated
    private static final boolean $$robo$$android_icu_text_DateTimePatternGenerator$isSingleField(String skeleton) {
        char first = skeleton.charAt(0);
        for (int i = 1; i < skeleton.length(); ++i) {
            if (skeleton.charAt(i) == first) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$setAvailableFormat(String key) {
        this.checkFrozen();
        this.cldrAvailableFormatKeys.add(key);
    }

    private final boolean $$robo$$android_icu_text_DateTimePatternGenerator$isAvailableFormatSet(String key) {
        return this.cldrAvailableFormatKeys.contains(key);
    }

    private final boolean $$robo$$android_icu_text_DateTimePatternGenerator$isFrozen() {
        return this.frozen;
    }

    private final DateTimePatternGenerator $$robo$$android_icu_text_DateTimePatternGenerator$freeze() {
        this.frozen = true;
        return this;
    }

    private final DateTimePatternGenerator $$robo$$android_icu_text_DateTimePatternGenerator$cloneAsThawed() {
        DateTimePatternGenerator result = (DateTimePatternGenerator)this.clone();
        this.frozen = false;
        return result;
    }

    private final Object $$robo$$android_icu_text_DateTimePatternGenerator$clone() {
        try {
            DateTimePatternGenerator result = (DateTimePatternGenerator)super.clone();
            result.skeleton2pattern = (TreeMap)this.skeleton2pattern.clone();
            result.basePattern_pattern = (TreeMap)this.basePattern_pattern.clone();
            result.appendItemFormats = (String[])this.appendItemFormats.clone();
            result.appendItemNames = (String[])this.appendItemNames.clone();
            result.current = new DateTimeMatcher();
            result.fp = new FormatParser();
            result._distanceInfo = new DistanceInfo();
            result.frozen = false;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException("Internal Error", e);
        }
    }

    @Deprecated
    private final boolean $$robo$$android_icu_text_DateTimePatternGenerator$skeletonsAreSimilar(String id2, String skeleton) {
        if (id2.equals(skeleton)) {
            return true;
        }
        TreeSet<String> parser1 = this.getSet(id2);
        TreeSet<String> parser2 = this.getSet(skeleton);
        if (parser1.size() != parser2.size()) {
            return false;
        }
        Iterator<String> it2 = parser2.iterator();
        for (String item : parser1) {
            String item2;
            int index2;
            int index1 = DateTimePatternGenerator.getCanonicalIndex(item, false);
            if (types[index1][1] == types[index2 = DateTimePatternGenerator.getCanonicalIndex(item2 = it2.next(), false)][1]) continue;
            return false;
        }
        return true;
    }

    private final TreeSet<String> $$robo$$android_icu_text_DateTimePatternGenerator$getSet(String id2) {
        List<Object> items = this.fp.set(id2).getItems();
        TreeSet<String> result = new TreeSet<String>();
        for (Object obj : items) {
            String item = obj.toString();
            if (item.startsWith("G") || item.startsWith("a")) continue;
            result.add(item);
        }
        return result;
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$checkFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getBestAppending(DateTimeMatcher source, int missingFields, DistanceInfo distInfo, DateTimeMatcher skipMatcher, EnumSet<DTPGflags> flags, int options) {
        String resultPattern = null;
        if (missingFields != 0) {
            PatternWithMatcher resultPatternWithMatcher = this.getBestRaw(source, missingFields, distInfo, skipMatcher);
            resultPattern = this.adjustFieldTypes(resultPatternWithMatcher, source, flags, options);
            while (distInfo.missingFieldMask != 0) {
                if ((distInfo.missingFieldMask & 0x6000) == 16384 && (missingFields & 0x6000) == 24576) {
                    resultPatternWithMatcher.pattern = resultPattern;
                    flags = EnumSet.copyOf(flags);
                    flags.add(DTPGflags.FIX_FRACTIONAL_SECONDS);
                    resultPattern = this.adjustFieldTypes(resultPatternWithMatcher, source, flags, options);
                    distInfo.missingFieldMask &= 0xFFFFBFFF;
                    continue;
                }
                int startingMask = distInfo.missingFieldMask;
                PatternWithMatcher tempWithMatcher = this.getBestRaw(source, distInfo.missingFieldMask, distInfo, skipMatcher);
                String temp = this.adjustFieldTypes(tempWithMatcher, source, flags, options);
                int foundMask = startingMask & ~distInfo.missingFieldMask;
                int topField = this.getTopBitNumber(foundMask);
                resultPattern = SimpleFormatterImpl.formatRawPattern(this.getAppendFormat(topField), 2, 3, resultPattern, temp, this.getAppendName(topField));
            }
        }
        return resultPattern;
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getAppendName(int foundMask) {
        return "'" + this.appendItemNames[foundMask] + "'";
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getAppendFormat(int foundMask) {
        return this.appendItemFormats[foundMask];
    }

    private final int $$robo$$android_icu_text_DateTimePatternGenerator$getTopBitNumber(int foundMask) {
        int i = 0;
        while (foundMask != 0) {
            foundMask >>>= 1;
            ++i;
        }
        return i - 1;
    }

    private final void $$robo$$android_icu_text_DateTimePatternGenerator$addCanonicalItems() {
        PatternInfo patternInfo = new PatternInfo();
        for (int i = 0; i < CANONICAL_ITEMS.length; ++i) {
            this.addPattern(String.valueOf(CANONICAL_ITEMS[i]), false, patternInfo);
        }
    }

    private final PatternWithMatcher $$robo$$android_icu_text_DateTimePatternGenerator$getBestRaw(DateTimeMatcher source, int includeMask, DistanceInfo missingFields, DateTimeMatcher skipMatcher) {
        int bestDistance = Integer.MAX_VALUE;
        PatternWithMatcher bestPatternWithMatcher = new PatternWithMatcher("", null);
        DistanceInfo tempInfo = new DistanceInfo();
        for (DateTimeMatcher trial : this.skeleton2pattern.keySet()) {
            int distance;
            if (trial.equals(skipMatcher) || (distance = source.getDistance(trial, includeMask, tempInfo)) >= bestDistance) continue;
            bestDistance = distance;
            PatternWithSkeletonFlag patternWithSkelFlag = this.skeleton2pattern.get(trial);
            bestPatternWithMatcher.pattern = patternWithSkelFlag.pattern;
            bestPatternWithMatcher.matcherWithSkeleton = patternWithSkelFlag.skeletonWasSpecified ? trial : null;
            missingFields.setTo(tempInfo);
            if (distance != 0) continue;
            break;
        }
        return bestPatternWithMatcher;
    }

    private final String $$robo$$android_icu_text_DateTimePatternGenerator$adjustFieldTypes(PatternWithMatcher patternWithMatcher, DateTimeMatcher inputRequest, EnumSet<DTPGflags> flags, int options) {
        this.fp.set(patternWithMatcher.pattern);
        StringBuilder newPattern = new StringBuilder();
        for (Object item : this.fp.getItems()) {
            if (item instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item));
                continue;
            }
            VariableField variableField = (VariableField)item;
            StringBuilder fieldBuilder = new StringBuilder(variableField.toString());
            int type = variableField.getType();
            if (type == 10 && !flags.isEmpty()) {
                char c;
                char c2 = flags.contains((Object)DTPGflags.SKELETON_USES_b) ? (char)'b' : (c = flags.contains((Object)DTPGflags.SKELETON_USES_B) ? (char)'B' : '0');
                if (c != '0') {
                    int len = fieldBuilder.length();
                    fieldBuilder.setLength(0);
                    for (int i = len; i > 0; --i) {
                        fieldBuilder.append(c);
                    }
                }
            }
            if (flags.contains((Object)DTPGflags.FIX_FRACTIONAL_SECONDS) && type == 13) {
                fieldBuilder.append(this.decimal);
                inputRequest.original.appendFieldTo(14, fieldBuilder);
            } else if (inputRequest.type[type] != 0) {
                char c;
                char reqFieldChar = inputRequest.original.getFieldChar(type);
                int reqFieldLen = inputRequest.original.getFieldLength(type);
                if (reqFieldChar == 'E' && reqFieldLen < 3) {
                    reqFieldLen = 3;
                }
                int adjFieldLen = reqFieldLen;
                DateTimeMatcher matcherWithSkeleton = patternWithMatcher.matcherWithSkeleton;
                if (type == 11 && (options & 0x800) == 0 || type == 12 && (options & 0x1000) == 0 || type == 13 && (options & 0x2000) == 0) {
                    adjFieldLen = fieldBuilder.length();
                } else if (matcherWithSkeleton != null) {
                    int skelFieldLen = matcherWithSkeleton.original.getFieldLength(type);
                    boolean patFieldIsNumeric = variableField.isNumeric();
                    boolean skelFieldIsNumeric = matcherWithSkeleton.fieldIsNumeric(type);
                    if (skelFieldLen == reqFieldLen || patFieldIsNumeric && !skelFieldIsNumeric || skelFieldIsNumeric && !patFieldIsNumeric) {
                        adjFieldLen = fieldBuilder.length();
                    }
                }
                char c3 = c = type != 11 && type != 3 && type != 6 && (type != 1 || reqFieldChar == 'Y') ? reqFieldChar : fieldBuilder.charAt(0);
                if (type == 11 && flags.contains((Object)DTPGflags.SKELETON_USES_CAP_J)) {
                    c = this.defaultHourFormatChar;
                }
                fieldBuilder = new StringBuilder();
                for (int i = adjFieldLen; i > 0; --i) {
                    fieldBuilder.append(c);
                }
            }
            newPattern.append((CharSequence)fieldBuilder);
        }
        return newPattern.toString();
    }

    @Deprecated
    private final String $$robo$$android_icu_text_DateTimePatternGenerator$getFields(String pattern) {
        this.fp.set(pattern);
        StringBuilder newPattern = new StringBuilder();
        for (Object item : this.fp.getItems()) {
            if (item instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item));
                continue;
            }
            newPattern.append("{" + DateTimePatternGenerator.getName(item.toString()) + "}");
        }
        return newPattern.toString();
    }

    private static final String $$robo$$android_icu_text_DateTimePatternGenerator$showMask(int mask) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if ((mask & 1 << i) == 0) continue;
            if (result.length() != 0) {
                result.append(" | ");
            }
            result.append(FIELD_NAME[i]);
            result.append(" ");
        }
        return result.toString();
    }

    private static final String $$robo$$android_icu_text_DateTimePatternGenerator$getName(String s) {
        int i = DateTimePatternGenerator.getCanonicalIndex(s, true);
        String name = FIELD_NAME[types[i][1]];
        name = types[i][2] < 0 ? name + ":S" : name + ":N";
        return name;
    }

    private static final int $$robo$$android_icu_text_DateTimePatternGenerator$getCanonicalIndex(String s, boolean strict) {
        int len = s.length();
        if (len == 0) {
            return -1;
        }
        char ch = s.charAt(0);
        for (int i = 1; i < len; ++i) {
            if (s.charAt(i) == ch) continue;
            return -1;
        }
        int bestRow = -1;
        for (int i = 0; i < types.length; ++i) {
            int[] row = types[i];
            if (row[0] != ch) continue;
            bestRow = i;
            if (row[3] > len || row[row.length - 1] < len) continue;
            return i;
        }
        return strict ? -1 : bestRow;
    }

    private static final char $$robo$$android_icu_text_DateTimePatternGenerator$getCanonicalChar(int field, char reference) {
        if (reference == 'h' || reference == 'K') {
            return 'h';
        }
        for (int i = 0; i < types.length; ++i) {
            int[] row = types[i];
            if (row[1] != field) continue;
            return (char)row[0];
        }
        throw new IllegalArgumentException("Could not find field " + field);
    }

    static void __staticInitializer__() {
        LAST_RESORT_ALLOWED_HOUR_FORMAT = new String[]{"H"};
        HashMap temp = new HashMap();
        ICUResourceBundle suppData = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        DayPeriodAllowedHoursSink allowedHoursSink = new DayPeriodAllowedHoursSink(temp);
        suppData.getAllItemsWithFallback("timeData", allowedHoursSink);
        LOCALE_TO_ALLOWED_HOUR = Collections.unmodifiableMap(temp);
        DTPNG_CACHE = new SimpleCache<String, DateTimePatternGenerator>();
        CLDR_FIELD_APPEND = new String[]{"Era", "Year", "Quarter", "Month", "Week", "*", "Day-Of-Week", "Day", "*", "*", "*", "Hour", "Minute", "Second", "*", "Timezone"};
        CLDR_FIELD_NAME = new String[]{"era", "year", "*", "month", "week", "*", "weekday", "day", "*", "*", "dayperiod", "hour", "minute", "second", "*", "zone"};
        FIELD_NAME = new String[]{"Era", "Year", "Quarter", "Month", "Week_in_Year", "Week_in_Month", "Weekday", "Day", "Day_Of_Year", "Day_of_Week_in_Month", "Dayperiod", "Hour", "Minute", "Second", "Fractional_Second", "Zone"};
        CANONICAL_ITEMS = new String[]{"G", "y", "Q", "M", "w", "W", "E", "d", "D", "F", "H", "m", "s", "S", "v"};
        CANONICAL_SET = new HashSet<String>(Arrays.asList(CANONICAL_ITEMS));
        types = new int[][]{{71, 0, -258, 1, 3}, {71, 0, -259, 4}, {121, 1, 256, 1, 20}, {89, 1, 272, 1, 20}, {117, 1, 288, 1, 20}, {114, 1, 304, 1, 20}, {85, 1, -258, 1, 3}, {85, 1, -259, 4}, {85, 1, -257, 5}, {81, 2, 256, 1, 2}, {81, 2, -258, 3}, {81, 2, -259, 4}, {113, 2, 272, 1, 2}, {113, 2, -242, 3}, {113, 2, -243, 4}, {77, 3, 256, 1, 2}, {77, 3, -258, 3}, {77, 3, -259, 4}, {77, 3, -257, 5}, {76, 3, 272, 1, 2}, {76, 3, -274, 3}, {76, 3, -275, 4}, {76, 3, -273, 5}, {108, 3, 272, 1, 1}, {119, 4, 256, 1, 2}, {87, 5, 272, 1}, {69, 6, -258, 1, 3}, {69, 6, -259, 4}, {69, 6, -257, 5}, {99, 6, 288, 1, 2}, {99, 6, -290, 3}, {99, 6, -291, 4}, {99, 6, -289, 5}, {101, 6, 272, 1, 2}, {101, 6, -274, 3}, {101, 6, -275, 4}, {101, 6, -273, 5}, {100, 7, 256, 1, 2}, {68, 8, 272, 1, 3}, {70, 9, 288, 1}, {103, 7, 304, 1, 20}, {97, 10, -258, 1}, {72, 11, 416, 1, 2}, {107, 11, 432, 1, 2}, {104, 11, 256, 1, 2}, {75, 11, 272, 1, 2}, {109, 12, 256, 1, 2}, {115, 13, 256, 1, 2}, {83, 14, 272, 1, 1000}, {65, 13, 288, 1, 1000}, {118, 15, -290, 1}, {118, 15, -291, 4}, {122, 15, -258, 1, 3}, {122, 15, -259, 4}, {90, 15, -273, 1, 3}, {90, 15, -275, 4}, {90, 15, -274, 5}, {79, 15, -274, 1}, {79, 15, -275, 4}, {86, 15, -274, 1}, {86, 15, -275, 2}, {88, 15, -273, 1}, {88, 15, -274, 2}, {88, 15, -275, 4}, {120, 15, -273, 1}, {120, 15, -274, 2}, {120, 15, -275, 4}};
    }

    public static DateTimePatternGenerator getEmptyInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getEmptyInstance", $$robo$$android_icu_text_DateTimePatternGenerator$getEmptyInstance(), 0);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_DateTimePatternGenerator$__constructor__();
    }

    protected DateTimePatternGenerator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator$__constructor__(), 0, this);
    }

    public static DateTimePatternGenerator getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateTimePatternGenerator$getInstance(), 0);
    }

    public static DateTimePatternGenerator getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateTimePatternGenerator$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static DateTimePatternGenerator getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateTimePatternGenerator$getInstance(java.util.Locale ), 0, (Locale)locale);
    }

    @Deprecated
    public static DateTimePatternGenerator getFrozenInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getFrozenInstance", $$robo$$android_icu_text_DateTimePatternGenerator$getFrozenInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private void initData(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("initData", $$robo$$android_icu_text_DateTimePatternGenerator$initData(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void addICUPatterns(PatternInfo patternInfo, ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("addICUPatterns", $$robo$$android_icu_text_DateTimePatternGenerator$addICUPatterns(android.icu.text.DateTimePatternGenerator$PatternInfo android.icu.util.ULocale ), 0, this, patternInfo, uLocale);
    }

    private String getCalendarTypeToUse(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getCalendarTypeToUse", $$robo$$android_icu_text_DateTimePatternGenerator$getCalendarTypeToUse(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void consumeShortTimePattern(String string2, PatternInfo patternInfo) {
        InvokeDynamicSupport.bootstrap("consumeShortTimePattern", $$robo$$android_icu_text_DateTimePatternGenerator$consumeShortTimePattern(java.lang.String android.icu.text.DateTimePatternGenerator$PatternInfo ), 0, this, string2, patternInfo);
    }

    private void fillInMissing() {
        InvokeDynamicSupport.bootstrap("fillInMissing", $$robo$$android_icu_text_DateTimePatternGenerator$fillInMissing(), 0, this);
    }

    private void addCLDRData(PatternInfo patternInfo, ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("addCLDRData", $$robo$$android_icu_text_DateTimePatternGenerator$addCLDRData(android.icu.text.DateTimePatternGenerator$PatternInfo android.icu.util.ULocale ), 0, this, patternInfo, uLocale);
    }

    private void setDateTimeFromCalendar(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("setDateTimeFromCalendar", $$robo$$android_icu_text_DateTimePatternGenerator$setDateTimeFromCalendar(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void setDecimalSymbols(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("setDecimalSymbols", $$robo$$android_icu_text_DateTimePatternGenerator$setDecimalSymbols(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void getAllowedHourFormats(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("getAllowedHourFormats", $$robo$$android_icu_text_DateTimePatternGenerator$getAllowedHourFormats(android.icu.util.ULocale ), 0, this, uLocale);
    }

    @Deprecated
    public char getDefaultHourFormatChar() {
        return (char)InvokeDynamicSupport.bootstrap("getDefaultHourFormatChar", $$robo$$android_icu_text_DateTimePatternGenerator$getDefaultHourFormatChar(), 0, this);
    }

    @Deprecated
    public void setDefaultHourFormatChar(char c) {
        InvokeDynamicSupport.bootstrap("setDefaultHourFormatChar", $$robo$$android_icu_text_DateTimePatternGenerator$setDefaultHourFormatChar(char ), 0, this, c);
    }

    private void hackTimes(PatternInfo patternInfo, String string2) {
        InvokeDynamicSupport.bootstrap("hackTimes", $$robo$$android_icu_text_DateTimePatternGenerator$hackTimes(android.icu.text.DateTimePatternGenerator$PatternInfo java.lang.String ), 0, this, patternInfo, string2);
    }

    private static String getFilteredPattern(FormatParser formatParser, BitSet bitSet) {
        return InvokeDynamicSupport.bootstrapStatic("getFilteredPattern", $$robo$$android_icu_text_DateTimePatternGenerator$getFilteredPattern(android.icu.text.DateTimePatternGenerator$FormatParser java.util.BitSet ), 0, (FormatParser)formatParser, (BitSet)bitSet);
    }

    @Deprecated
    public static int getAppendFormatNumber(UResource.Key key) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAppendFormatNumber", $$robo$$android_icu_text_DateTimePatternGenerator$getAppendFormatNumber(android.icu.impl.UResource$Key ), 0, (UResource.Key)key);
    }

    @Deprecated
    public static int getAppendFormatNumber(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAppendFormatNumber", $$robo$$android_icu_text_DateTimePatternGenerator$getAppendFormatNumber(java.lang.String ), 0, (String)string2);
    }

    private static int getCLDRFieldNumber(UResource.Key key) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCLDRFieldNumber", $$robo$$android_icu_text_DateTimePatternGenerator$getCLDRFieldNumber(android.icu.impl.UResource$Key ), 0, (UResource.Key)key);
    }

    public String getBestPattern(String string2) {
        return InvokeDynamicSupport.bootstrap("getBestPattern", $$robo$$android_icu_text_DateTimePatternGenerator$getBestPattern(java.lang.String ), 0, this, string2);
    }

    public String getBestPattern(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getBestPattern", $$robo$$android_icu_text_DateTimePatternGenerator$getBestPattern(java.lang.String int ), 0, this, string2, n);
    }

    private String getBestPattern(String string2, DateTimeMatcher dateTimeMatcher, int n) {
        return InvokeDynamicSupport.bootstrap("getBestPattern", $$robo$$android_icu_text_DateTimePatternGenerator$getBestPattern(java.lang.String android.icu.text.DateTimePatternGenerator$DateTimeMatcher int ), 0, this, string2, dateTimeMatcher, n);
    }

    public DateTimePatternGenerator addPattern(String string2, boolean bl, PatternInfo patternInfo) {
        return InvokeDynamicSupport.bootstrap("addPattern", $$robo$$android_icu_text_DateTimePatternGenerator$addPattern(java.lang.String boolean android.icu.text.DateTimePatternGenerator$PatternInfo ), 0, this, string2, bl, patternInfo);
    }

    @Deprecated
    public DateTimePatternGenerator addPatternWithSkeleton(String string2, String string3, boolean bl, PatternInfo patternInfo) {
        return InvokeDynamicSupport.bootstrap("addPatternWithSkeleton", $$robo$$android_icu_text_DateTimePatternGenerator$addPatternWithSkeleton(java.lang.String java.lang.String boolean android.icu.text.DateTimePatternGenerator$PatternInfo ), 0, this, string2, string3, bl, patternInfo);
    }

    public String getSkeleton(String string2) {
        return InvokeDynamicSupport.bootstrap("getSkeleton", $$robo$$android_icu_text_DateTimePatternGenerator$getSkeleton(java.lang.String ), 0, this, string2);
    }

    @Deprecated
    public String getSkeletonAllowingDuplicates(String string2) {
        return InvokeDynamicSupport.bootstrap("getSkeletonAllowingDuplicates", $$robo$$android_icu_text_DateTimePatternGenerator$getSkeletonAllowingDuplicates(java.lang.String ), 0, this, string2);
    }

    @Deprecated
    public String getCanonicalSkeletonAllowingDuplicates(String string2) {
        return InvokeDynamicSupport.bootstrap("getCanonicalSkeletonAllowingDuplicates", $$robo$$android_icu_text_DateTimePatternGenerator$getCanonicalSkeletonAllowingDuplicates(java.lang.String ), 0, this, string2);
    }

    public String getBaseSkeleton(String string2) {
        return InvokeDynamicSupport.bootstrap("getBaseSkeleton", $$robo$$android_icu_text_DateTimePatternGenerator$getBaseSkeleton(java.lang.String ), 0, this, string2);
    }

    public Map<String, String> getSkeletons(Map<String, String> map) {
        return InvokeDynamicSupport.bootstrap("getSkeletons", $$robo$$android_icu_text_DateTimePatternGenerator$getSkeletons(java.util.Map<java.lang.String, java.lang.String> ), 0, this, map);
    }

    public Set<String> getBaseSkeletons(Set<String> set) {
        return InvokeDynamicSupport.bootstrap("getBaseSkeletons", $$robo$$android_icu_text_DateTimePatternGenerator$getBaseSkeletons(java.util.Set<java.lang.String> ), 0, this, set);
    }

    public String replaceFieldTypes(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("replaceFieldTypes", $$robo$$android_icu_text_DateTimePatternGenerator$replaceFieldTypes(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String replaceFieldTypes(String string2, String string3, int n) {
        return InvokeDynamicSupport.bootstrap("replaceFieldTypes", $$robo$$android_icu_text_DateTimePatternGenerator$replaceFieldTypes(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    public void setDateTimeFormat(String string2) {
        InvokeDynamicSupport.bootstrap("setDateTimeFormat", $$robo$$android_icu_text_DateTimePatternGenerator$setDateTimeFormat(java.lang.String ), 0, this, string2);
    }

    public String getDateTimeFormat() {
        return InvokeDynamicSupport.bootstrap("getDateTimeFormat", $$robo$$android_icu_text_DateTimePatternGenerator$getDateTimeFormat(), 0, this);
    }

    public void setDecimal(String string2) {
        InvokeDynamicSupport.bootstrap("setDecimal", $$robo$$android_icu_text_DateTimePatternGenerator$setDecimal(java.lang.String ), 0, this, string2);
    }

    public String getDecimal() {
        return InvokeDynamicSupport.bootstrap("getDecimal", $$robo$$android_icu_text_DateTimePatternGenerator$getDecimal(), 0, this);
    }

    @Deprecated
    public Collection<String> getRedundants(Collection<String> collection) {
        return InvokeDynamicSupport.bootstrap("getRedundants", $$robo$$android_icu_text_DateTimePatternGenerator$getRedundants(java.util.Collection<java.lang.String> ), 0, this, collection);
    }

    public void setAppendItemFormat(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setAppendItemFormat", $$robo$$android_icu_text_DateTimePatternGenerator$setAppendItemFormat(int java.lang.String ), 0, this, n, string2);
    }

    public String getAppendItemFormat(int n) {
        return InvokeDynamicSupport.bootstrap("getAppendItemFormat", $$robo$$android_icu_text_DateTimePatternGenerator$getAppendItemFormat(int ), 0, this, n);
    }

    public void setAppendItemName(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setAppendItemName", $$robo$$android_icu_text_DateTimePatternGenerator$setAppendItemName(int java.lang.String ), 0, this, n, string2);
    }

    public String getAppendItemName(int n) {
        return InvokeDynamicSupport.bootstrap("getAppendItemName", $$robo$$android_icu_text_DateTimePatternGenerator$getAppendItemName(int ), 0, this, n);
    }

    @Deprecated
    public static boolean isSingleField(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSingleField", $$robo$$android_icu_text_DateTimePatternGenerator$isSingleField(java.lang.String ), 0, (String)string2);
    }

    private void setAvailableFormat(String string2) {
        InvokeDynamicSupport.bootstrap("setAvailableFormat", $$robo$$android_icu_text_DateTimePatternGenerator$setAvailableFormat(java.lang.String ), 0, this, string2);
    }

    private boolean isAvailableFormatSet(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAvailableFormatSet", $$robo$$android_icu_text_DateTimePatternGenerator$isAvailableFormatSet(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_text_DateTimePatternGenerator$isFrozen(), 0, this);
    }

    @Override
    public DateTimePatternGenerator freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_DateTimePatternGenerator$freeze(), 0, this);
    }

    @Override
    public DateTimePatternGenerator cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_text_DateTimePatternGenerator$cloneAsThawed(), 0, this);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_DateTimePatternGenerator$clone(), 0, this);
    }

    @Deprecated
    public boolean skeletonsAreSimilar(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("skeletonsAreSimilar", $$robo$$android_icu_text_DateTimePatternGenerator$skeletonsAreSimilar(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private TreeSet<String> getSet(String string2) {
        return InvokeDynamicSupport.bootstrap("getSet", $$robo$$android_icu_text_DateTimePatternGenerator$getSet(java.lang.String ), 0, this, string2);
    }

    private void checkFrozen() {
        InvokeDynamicSupport.bootstrap("checkFrozen", $$robo$$android_icu_text_DateTimePatternGenerator$checkFrozen(), 0, this);
    }

    private String getBestAppending(DateTimeMatcher dateTimeMatcher, int n, DistanceInfo distanceInfo, DateTimeMatcher dateTimeMatcher2, EnumSet<DTPGflags> enumSet, int n2) {
        return InvokeDynamicSupport.bootstrap("getBestAppending", $$robo$$android_icu_text_DateTimePatternGenerator$getBestAppending(android.icu.text.DateTimePatternGenerator$DateTimeMatcher int android.icu.text.DateTimePatternGenerator$DistanceInfo android.icu.text.DateTimePatternGenerator$DateTimeMatcher java.util.EnumSet<android.icu.text.DateTimePatternGenerator$DTPGflags> int ), 0, this, dateTimeMatcher, n, distanceInfo, dateTimeMatcher2, enumSet, n2);
    }

    private String getAppendName(int n) {
        return InvokeDynamicSupport.bootstrap("getAppendName", $$robo$$android_icu_text_DateTimePatternGenerator$getAppendName(int ), 0, this, n);
    }

    private String getAppendFormat(int n) {
        return InvokeDynamicSupport.bootstrap("getAppendFormat", $$robo$$android_icu_text_DateTimePatternGenerator$getAppendFormat(int ), 0, this, n);
    }

    private int getTopBitNumber(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getTopBitNumber", $$robo$$android_icu_text_DateTimePatternGenerator$getTopBitNumber(int ), 0, this, n);
    }

    private void addCanonicalItems() {
        InvokeDynamicSupport.bootstrap("addCanonicalItems", $$robo$$android_icu_text_DateTimePatternGenerator$addCanonicalItems(), 0, this);
    }

    private PatternWithMatcher getBestRaw(DateTimeMatcher dateTimeMatcher, int n, DistanceInfo distanceInfo, DateTimeMatcher dateTimeMatcher2) {
        return InvokeDynamicSupport.bootstrap("getBestRaw", $$robo$$android_icu_text_DateTimePatternGenerator$getBestRaw(android.icu.text.DateTimePatternGenerator$DateTimeMatcher int android.icu.text.DateTimePatternGenerator$DistanceInfo android.icu.text.DateTimePatternGenerator$DateTimeMatcher ), 0, this, dateTimeMatcher, n, distanceInfo, dateTimeMatcher2);
    }

    private String adjustFieldTypes(PatternWithMatcher patternWithMatcher, DateTimeMatcher dateTimeMatcher, EnumSet<DTPGflags> enumSet, int n) {
        return InvokeDynamicSupport.bootstrap("adjustFieldTypes", $$robo$$android_icu_text_DateTimePatternGenerator$adjustFieldTypes(android.icu.text.DateTimePatternGenerator$PatternWithMatcher android.icu.text.DateTimePatternGenerator$DateTimeMatcher java.util.EnumSet<android.icu.text.DateTimePatternGenerator$DTPGflags> int ), 0, this, patternWithMatcher, dateTimeMatcher, enumSet, n);
    }

    @Deprecated
    public String getFields(String string2) {
        return InvokeDynamicSupport.bootstrap("getFields", $$robo$$android_icu_text_DateTimePatternGenerator$getFields(java.lang.String ), 0, this, string2);
    }

    private static String showMask(int n) {
        return InvokeDynamicSupport.bootstrapStatic("showMask", $$robo$$android_icu_text_DateTimePatternGenerator$showMask(int ), 0, (int)n);
    }

    private static String getName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getName", $$robo$$android_icu_text_DateTimePatternGenerator$getName(java.lang.String ), 0, (String)string2);
    }

    private static int getCanonicalIndex(String string2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCanonicalIndex", $$robo$$android_icu_text_DateTimePatternGenerator$getCanonicalIndex(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static char getCanonicalChar(int n, char c) {
        return (char)InvokeDynamicSupport.bootstrapStatic("getCanonicalChar", $$robo$$android_icu_text_DateTimePatternGenerator$getCanonicalChar(int char ), 0, (int)n, (char)c);
    }

    static {
        RobolectricInternals.classInitializing(DateTimePatternGenerator.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateTimePatternGenerator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DistanceInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int missingFieldMask;
        int extraFieldMask;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$__constructor__() {
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$clear() {
            this.extraFieldMask = 0;
            this.missingFieldMask = 0;
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$setTo(DistanceInfo other) {
            this.missingFieldMask = other.missingFieldMask;
            this.extraFieldMask = other.extraFieldMask;
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$addMissing(int field) {
            this.missingFieldMask |= 1 << field;
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$addExtra(int field) {
            this.extraFieldMask |= 1 << field;
        }

        private final String $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$toString() {
            return "missingFieldMask: " + DateTimePatternGenerator.showMask(this.missingFieldMask) + ", extraFieldMask: " + DateTimePatternGenerator.showMask(this.extraFieldMask);
        }

        private /* synthetic */ void $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$__constructor__();
        }

        private DistanceInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$__constructor__(), 0, this);
        }

        void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$clear(), 0, this);
        }

        void setTo(DistanceInfo distanceInfo) {
            InvokeDynamicSupport.bootstrap("setTo", $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$setTo(android.icu.text.DateTimePatternGenerator$DistanceInfo ), 0, this, distanceInfo);
        }

        void addMissing(int n) {
            InvokeDynamicSupport.bootstrap("addMissing", $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$addMissing(int ), 0, this, n);
        }

        void addExtra(int n) {
            InvokeDynamicSupport.bootstrap("addExtra", $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$addExtra(int ), 0, this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_DistanceInfo$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DistanceInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DateTimeMatcher
    implements Comparable<DateTimeMatcher> {
        public transient /* synthetic */ Object __robo_data__;
        private int[] type;
        private SkeletonFields original;
        private SkeletonFields baseOriginal;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$__constructor__() {
            this.type = new int[16];
            this.original = new SkeletonFields();
            this.baseOriginal = new SkeletonFields();
        }

        private final boolean $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$fieldIsNumeric(int field) {
            return this.type[field] > 0;
        }

        private final String $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$toString() {
            return this.original.toString();
        }

        private final String $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$toCanonicalString() {
            return this.original.toCanonicalString();
        }

        private final String $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$getBasePattern() {
            return this.baseOriginal.toString();
        }

        private final DateTimeMatcher $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$set(String pattern, FormatParser fp, boolean allowDuplicateFields) {
            Arrays.fill(this.type, 0);
            this.original.clear();
            this.baseOriginal.clear();
            fp.set(pattern);
            for (Object obj : fp.getItems()) {
                VariableField item;
                String value;
                if (!(obj instanceof VariableField) || (value = (item = (VariableField)obj).toString()).charAt(0) == 'a') continue;
                int canonicalIndex = item.getCanonicalIndex();
                int[] row = types[canonicalIndex];
                int field = row[1];
                if (!this.original.isFieldEmpty(field)) {
                    char ch1 = this.original.getFieldChar(field);
                    char ch2 = value.charAt(0);
                    if (allowDuplicateFields || ch1 == 'r' && ch2 == 'U' || ch1 == 'U' && ch2 == 'r') continue;
                    throw new IllegalArgumentException("Conflicting fields:\t" + ch1 + ", " + value + "\t in " + pattern);
                }
                this.original.populate(field, value);
                char repeatChar = (char)row[0];
                int repeatCount = row[3];
                if ("GEzvQ".indexOf(repeatChar) >= 0) {
                    repeatCount = 1;
                }
                this.baseOriginal.populate(field, repeatChar, repeatCount);
                int subField = row[2];
                if (subField > 0) {
                    subField += value.length();
                }
                this.type[field] = subField;
            }
            return this;
        }

        private final int $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$getFieldMask() {
            int result = 0;
            for (int i = 0; i < this.type.length; ++i) {
                if (this.type[i] == 0) continue;
                result |= 1 << i;
            }
            return result;
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$extractFrom(DateTimeMatcher source, int fieldMask) {
            for (int i = 0; i < this.type.length; ++i) {
                if ((fieldMask & 1 << i) != 0) {
                    this.type[i] = source.type[i];
                    this.original.copyFieldFrom(source.original, i);
                    continue;
                }
                this.type[i] = 0;
                this.original.clearField(i);
            }
        }

        private final int $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$getDistance(DateTimeMatcher other, int includeMask, DistanceInfo distanceInfo) {
            int result = 0;
            distanceInfo.clear();
            for (int i = 0; i < 16; ++i) {
                int otherType;
                int myType = (includeMask & 1 << i) == 0 ? 0 : this.type[i];
                if (myType == (otherType = other.type[i])) continue;
                if (myType == 0) {
                    result += 65536;
                    distanceInfo.addExtra(i);
                    continue;
                }
                if (otherType == 0) {
                    result += 4096;
                    distanceInfo.addMissing(i);
                    continue;
                }
                result += Math.abs(myType - otherType);
            }
            return result;
        }

        private final int $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$compareTo(DateTimeMatcher that) {
            int result = this.original.compareTo(that.original);
            return result > 0 ? -1 : (result < 0 ? 1 : 0);
        }

        private final boolean $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$equals(Object other) {
            return this == other || other != null && other instanceof DateTimeMatcher && this.original.equals(((DateTimeMatcher)other).original);
        }

        private final int $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$hashCode() {
            return this.original.hashCode();
        }

        private /* synthetic */ void $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$__constructor__();
        }

        private DateTimeMatcher() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$__constructor__(), 0, this);
        }

        public boolean fieldIsNumeric(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("fieldIsNumeric", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$fieldIsNumeric(int ), 0, this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$toString(), 0, this);
        }

        public String toCanonicalString() {
            return InvokeDynamicSupport.bootstrap("toCanonicalString", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$toCanonicalString(), 0, this);
        }

        String getBasePattern() {
            return InvokeDynamicSupport.bootstrap("getBasePattern", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$getBasePattern(), 0, this);
        }

        DateTimeMatcher set(String string2, FormatParser formatParser, boolean bl) {
            return InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$set(java.lang.String android.icu.text.DateTimePatternGenerator$FormatParser boolean ), 0, this, string2, formatParser, bl);
        }

        int getFieldMask() {
            return (int)InvokeDynamicSupport.bootstrap("getFieldMask", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$getFieldMask(), 0, this);
        }

        void extractFrom(DateTimeMatcher dateTimeMatcher, int n) {
            InvokeDynamicSupport.bootstrap("extractFrom", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$extractFrom(android.icu.text.DateTimePatternGenerator$DateTimeMatcher int ), 0, this, dateTimeMatcher, n);
        }

        int getDistance(DateTimeMatcher dateTimeMatcher, int n, DistanceInfo distanceInfo) {
            return (int)InvokeDynamicSupport.bootstrap("getDistance", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$getDistance(android.icu.text.DateTimePatternGenerator$DateTimeMatcher int android.icu.text.DateTimePatternGenerator$DistanceInfo ), 0, this, dateTimeMatcher, n, distanceInfo);
        }

        @Override
        public int compareTo(DateTimeMatcher dateTimeMatcher) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$compareTo(android.icu.text.DateTimePatternGenerator$DateTimeMatcher ), 0, this, dateTimeMatcher);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$hashCode(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_DateTimeMatcher$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateTimeMatcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SkeletonFields
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] chars;
        private byte[] lengths;
        private static byte DEFAULT_CHAR = 0;
        private static byte DEFAULT_LENGTH = 0;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$__constructor__() {
            this.chars = new byte[16];
            this.lengths = new byte[16];
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$clear() {
            Arrays.fill(this.chars, (byte)0);
            Arrays.fill(this.lengths, (byte)0);
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$copyFieldFrom(SkeletonFields other, int field) {
            this.chars[field] = other.chars[field];
            this.lengths[field] = other.lengths[field];
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$clearField(int field) {
            this.chars[field] = 0;
            this.lengths[field] = 0;
        }

        private final char $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$getFieldChar(int field) {
            return (char)this.chars[field];
        }

        private final int $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$getFieldLength(int field) {
            return this.lengths[field];
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$populate(int field, String value) {
            for (char ch : value.toCharArray()) {
                if (!$assertionsDisabled && ch != value.charAt(0)) {
                    throw new AssertionError();
                }
            }
            this.populate(field, value.charAt(0), value.length());
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$populate(int field, char ch, int length) {
            if (!$assertionsDisabled && ch > '\u007f') {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && length > 127) {
                throw new AssertionError();
            }
            this.chars[field] = (byte)ch;
            this.lengths[field] = (byte)length;
        }

        private final boolean $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$isFieldEmpty(int field) {
            return this.lengths[field] == 0;
        }

        private final String $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$toString() {
            return this.appendTo(new StringBuilder()).toString();
        }

        private final String $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$toCanonicalString() {
            return this.appendTo(new StringBuilder(), true).toString();
        }

        private final StringBuilder $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$appendTo(StringBuilder sb) {
            return this.appendTo(sb, false);
        }

        private final StringBuilder $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$appendTo(StringBuilder sb, boolean canonical) {
            for (int i = 0; i < 16; ++i) {
                this.appendFieldTo(i, sb, canonical);
            }
            return sb;
        }

        private final StringBuilder $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$appendFieldTo(int field, StringBuilder sb) {
            return this.appendFieldTo(field, sb, false);
        }

        private final StringBuilder $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$appendFieldTo(int field, StringBuilder sb, boolean canonical) {
            char ch = (char)this.chars[field];
            int length = this.lengths[field];
            if (canonical) {
                ch = DateTimePatternGenerator.getCanonicalChar(field, ch);
            }
            for (int i = 0; i < length; ++i) {
                sb.append(ch);
            }
            return sb;
        }

        private final int $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$compareTo(SkeletonFields other) {
            for (int i = 0; i < 16; ++i) {
                int charDiff = this.chars[i] - other.chars[i];
                if (charDiff != 0) {
                    return charDiff;
                }
                int lengthDiff = this.lengths[i] - other.lengths[i];
                if (lengthDiff == 0) continue;
                return lengthDiff;
            }
            return 0;
        }

        private final boolean $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$equals(Object other) {
            return this == other || other != null && other instanceof SkeletonFields && this.compareTo((SkeletonFields)other) == 0;
        }

        private final int $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$hashCode() {
            return Arrays.hashCode(this.chars) ^ Arrays.hashCode(this.lengths);
        }

        private /* synthetic */ void $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$__constructor__(1 x0) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !DateTimePatternGenerator.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$__constructor__();
        }

        private SkeletonFields() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$__constructor__(), 0, this);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$clear(), 0, this);
        }

        void copyFieldFrom(SkeletonFields skeletonFields, int n) {
            InvokeDynamicSupport.bootstrap("copyFieldFrom", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$copyFieldFrom(android.icu.text.DateTimePatternGenerator$SkeletonFields int ), 0, this, skeletonFields, n);
        }

        void clearField(int n) {
            InvokeDynamicSupport.bootstrap("clearField", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$clearField(int ), 0, this, n);
        }

        char getFieldChar(int n) {
            return (char)InvokeDynamicSupport.bootstrap("getFieldChar", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$getFieldChar(int ), 0, this, n);
        }

        int getFieldLength(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getFieldLength", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$getFieldLength(int ), 0, this, n);
        }

        void populate(int n, String string2) {
            InvokeDynamicSupport.bootstrap("populate", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$populate(int java.lang.String ), 0, this, n, string2);
        }

        void populate(int n, char c, int n2) {
            InvokeDynamicSupport.bootstrap("populate", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$populate(int char int ), 0, this, n, c, n2);
        }

        public boolean isFieldEmpty(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFieldEmpty", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$isFieldEmpty(int ), 0, this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$toString(), 0, this);
        }

        public String toCanonicalString() {
            return InvokeDynamicSupport.bootstrap("toCanonicalString", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$toCanonicalString(), 0, this);
        }

        public StringBuilder appendTo(StringBuilder stringBuilder) {
            return InvokeDynamicSupport.bootstrap("appendTo", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$appendTo(java.lang.StringBuilder ), 0, this, stringBuilder);
        }

        private StringBuilder appendTo(StringBuilder stringBuilder, boolean bl) {
            return InvokeDynamicSupport.bootstrap("appendTo", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$appendTo(java.lang.StringBuilder boolean ), 0, this, stringBuilder, bl);
        }

        public StringBuilder appendFieldTo(int n, StringBuilder stringBuilder) {
            return InvokeDynamicSupport.bootstrap("appendFieldTo", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$appendFieldTo(int java.lang.StringBuilder ), 0, this, n, stringBuilder);
        }

        private StringBuilder appendFieldTo(int n, StringBuilder stringBuilder, boolean bl) {
            return InvokeDynamicSupport.bootstrap("appendFieldTo", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$appendFieldTo(int java.lang.StringBuilder boolean ), 0, this, n, stringBuilder, bl);
        }

        public int compareTo(SkeletonFields skeletonFields) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$compareTo(android.icu.text.DateTimePatternGenerator$SkeletonFields ), 0, this, skeletonFields);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$hashCode(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_SkeletonFields$__constructor__(var1_1);
        }

        static {
            RobolectricInternals.classInitializing(SkeletonFields.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SkeletonFields)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class DTPGflags
    extends Enum<DTPGflags> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ DTPGflags FIX_FRACTIONAL_SECONDS;
        public static /* enum */ DTPGflags SKELETON_USES_CAP_J;
        public static /* enum */ DTPGflags SKELETON_USES_b;
        public static /* enum */ DTPGflags SKELETON_USES_B;
        private static /* synthetic */ DTPGflags[] $VALUES;

        private static final DTPGflags[] $$robo$$android_icu_text_DateTimePatternGenerator_DTPGflags$values() {
            return (DTPGflags[])$VALUES.clone();
        }

        private static final DTPGflags $$robo$$android_icu_text_DateTimePatternGenerator_DTPGflags$valueOf(String name) {
            return Enum.valueOf(DTPGflags.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_DateTimePatternGenerator_DTPGflags$__constructor__(String string2, int n) {
        }

        private static final DTPGflags $$robo$$android_icu_text_DateTimePatternGenerator_DTPGflags$getFlag(String preferred) {
            char last = preferred.charAt(preferred.length() - 1);
            switch (last) {
                case 'b': {
                    return SKELETON_USES_b;
                }
                case 'B': {
                    return SKELETON_USES_B;
                }
            }
            return null;
        }

        static void __staticInitializer__() {
            FIX_FRACTIONAL_SECONDS = new DTPGflags();
            SKELETON_USES_CAP_J = new DTPGflags();
            SKELETON_USES_b = new DTPGflags();
            SKELETON_USES_B = new DTPGflags();
            $VALUES = new DTPGflags[]{FIX_FRACTIONAL_SECONDS, SKELETON_USES_CAP_J, SKELETON_USES_b, SKELETON_USES_B};
        }

        public static DTPGflags[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_DateTimePatternGenerator_DTPGflags$values(), 0);
        }

        public static DTPGflags valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_DateTimePatternGenerator_DTPGflags$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_DTPGflags$__constructor__(string2, n);
        }

        private DTPGflags() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_DTPGflags$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public static DTPGflags getFlag(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getFlag", $$robo$$android_icu_text_DateTimePatternGenerator_DTPGflags$getFlag(java.lang.String ), 0, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(DTPGflags.class);
        }

        public /* synthetic */ DTPGflags() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DTPGflags)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class PatternWithSkeletonFlag
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String pattern;
        public boolean skeletonWasSpecified;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_PatternWithSkeletonFlag$__constructor__(String pat, boolean skelSpecified) {
            this.pattern = pat;
            this.skeletonWasSpecified = skelSpecified;
        }

        private final String $$robo$$android_icu_text_DateTimePatternGenerator_PatternWithSkeletonFlag$toString() {
            return this.pattern + "," + this.skeletonWasSpecified;
        }

        private void __constructor__(String string2, boolean bl) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_PatternWithSkeletonFlag$__constructor__(string2, bl);
        }

        public PatternWithSkeletonFlag(String string2, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_PatternWithSkeletonFlag$__constructor__(java.lang.String boolean ), 0, this, string2, bl);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DateTimePatternGenerator_PatternWithSkeletonFlag$toString(), 0, this);
        }

        public /* synthetic */ PatternWithSkeletonFlag() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternWithSkeletonFlag)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class PatternWithMatcher
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String pattern;
        public DateTimeMatcher matcherWithSkeleton;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_PatternWithMatcher$__constructor__(String pat, DateTimeMatcher matcher) {
            this.pattern = pat;
            this.matcherWithSkeleton = matcher;
        }

        private void __constructor__(String string2, DateTimeMatcher dateTimeMatcher) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_PatternWithMatcher$__constructor__(string2, dateTimeMatcher);
        }

        public PatternWithMatcher(String string2, DateTimeMatcher dateTimeMatcher) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_PatternWithMatcher$__constructor__(java.lang.String android.icu.text.DateTimePatternGenerator$DateTimeMatcher ), 0, this, string2, dateTimeMatcher);
        }

        public /* synthetic */ PatternWithMatcher() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternWithMatcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class FormatParser
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static UnicodeSet SYNTAX_CHARS;
        private static UnicodeSet QUOTING_CHARS;
        private transient PatternTokenizer tokenizer;
        private List<Object> items;

        @Deprecated
        private void $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$__constructor__() {
            this.tokenizer = new PatternTokenizer().setSyntaxCharacters(SYNTAX_CHARS).setExtraQuotingCharacters(QUOTING_CHARS).setUsingQuote(true);
            this.items = new ArrayList<Object>();
        }

        @Deprecated
        private final FormatParser $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$set(String string2) {
            return this.set(string2, false);
        }

        @Deprecated
        private final FormatParser $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$set(String string2, boolean strict) {
            this.items.clear();
            if (string2.length() == 0) {
                return this;
            }
            this.tokenizer.setPattern(string2);
            StringBuffer buffer = new StringBuffer();
            StringBuffer variable = new StringBuffer();
            while (true) {
                buffer.setLength(0);
                int status = this.tokenizer.next(buffer);
                if (status == 0) break;
                if (status == 1) {
                    if (variable.length() != 0 && buffer.charAt(0) != variable.charAt(0)) {
                        this.addVariable(variable, false);
                    }
                    variable.append(buffer);
                    continue;
                }
                this.addVariable(variable, false);
                this.items.add(buffer.toString());
            }
            this.addVariable(variable, false);
            return this;
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$addVariable(StringBuffer variable, boolean strict) {
            if (variable.length() != 0) {
                this.items.add(new VariableField(variable.toString(), strict));
                variable.setLength(0);
            }
        }

        @Deprecated
        private final List<Object> $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$getItems() {
            return this.items;
        }

        @Deprecated
        private final String $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$toString() {
            return this.toString(0, this.items.size());
        }

        @Deprecated
        private final String $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$toString(int start, int limit) {
            StringBuilder result = new StringBuilder();
            for (int i = start; i < limit; ++i) {
                Object item = this.items.get(i);
                if (item instanceof String) {
                    String itemString = (String)item;
                    result.append(this.tokenizer.quoteLiteral(itemString));
                    continue;
                }
                result.append(this.items.get(i).toString());
            }
            return result.toString();
        }

        @Deprecated
        private final boolean $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$hasDateAndTimeFields() {
            int foundMask = 0;
            for (Object item : this.items) {
                if (!(item instanceof VariableField)) continue;
                int type = ((VariableField)item).getType();
                foundMask |= 1 << type;
            }
            boolean isDate = (foundMask & 0x3FF) != 0;
            boolean isTime = (foundMask & 0xFC00) != 0;
            return isDate && isTime;
        }

        @Deprecated
        private final Object $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$quoteLiteral(String string2) {
            return this.tokenizer.quoteLiteral(string2);
        }

        static void __staticInitializer__() {
            SYNTAX_CHARS = new UnicodeSet("[a-zA-Z]").freeze();
            QUOTING_CHARS = new UnicodeSet("[[[:script=Latn:][:script=Cyrl:]]&[[:L:][:M:]]]").freeze();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$__constructor__();
        }

        public FormatParser() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$__constructor__(), 0, this);
        }

        @Deprecated
        public FormatParser set(String string2) {
            return InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$set(java.lang.String ), 0, this, string2);
        }

        @Deprecated
        public FormatParser set(String string2, boolean bl) {
            return InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$set(java.lang.String boolean ), 0, this, string2, bl);
        }

        private void addVariable(StringBuffer stringBuffer, boolean bl) {
            InvokeDynamicSupport.bootstrap("addVariable", $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$addVariable(java.lang.StringBuffer boolean ), 0, this, stringBuffer, bl);
        }

        @Deprecated
        public List<Object> getItems() {
            return InvokeDynamicSupport.bootstrap("getItems", $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$getItems(), 0, this);
        }

        @Deprecated
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$toString(), 0, this);
        }

        @Deprecated
        public String toString(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$toString(int int ), 0, this, n, n2);
        }

        @Deprecated
        public boolean hasDateAndTimeFields() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasDateAndTimeFields", $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$hasDateAndTimeFields(), 0, this);
        }

        @Deprecated
        public Object quoteLiteral(String string2) {
            return InvokeDynamicSupport.bootstrap("quoteLiteral", $$robo$$android_icu_text_DateTimePatternGenerator_FormatParser$quoteLiteral(java.lang.String ), 0, this, string2);
        }

        static {
            RobolectricInternals.classInitializing(FormatParser.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FormatParser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class VariableField
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String string;
        private int canonicalIndex;

        @Deprecated
        private void $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$__constructor__(String string2) {
        }

        @Deprecated
        private void $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$__constructor__(String string2, boolean strict) {
            this.canonicalIndex = DateTimePatternGenerator.getCanonicalIndex(string2, strict);
            if (this.canonicalIndex < 0) {
                throw new IllegalArgumentException("Illegal datetime field:\t" + string2);
            }
            this.string = string2;
        }

        @Deprecated
        private final int $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$getType() {
            return types[this.canonicalIndex][1];
        }

        @Deprecated
        private static final String $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$getCanonicalCode(int type) {
            try {
                return CANONICAL_ITEMS[type];
            }
            catch (Exception e) {
                return String.valueOf(type);
            }
        }

        @Deprecated
        private final boolean $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$isNumeric() {
            return types[this.canonicalIndex][2] > 0;
        }

        private final int $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$getCanonicalIndex() {
            return this.canonicalIndex;
        }

        @Deprecated
        private final String $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$toString() {
            return this.string;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_VariableField$__constructor__(string2);
        }

        public VariableField(String string2) {
            this(string2, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(String string2, boolean bl) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_VariableField$__constructor__(string2, bl);
        }

        public VariableField(String string2, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$__constructor__(java.lang.String boolean ), 0, this, string2, bl);
        }

        @Deprecated
        public int getType() {
            return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$getType(), 0, this);
        }

        @Deprecated
        public static String getCanonicalCode(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getCanonicalCode", $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$getCanonicalCode(int ), 0, (int)n);
        }

        @Deprecated
        public boolean isNumeric() {
            return (boolean)InvokeDynamicSupport.bootstrap("isNumeric", $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$isNumeric(), 0, this);
        }

        private int getCanonicalIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getCanonicalIndex", $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$getCanonicalIndex(), 0, this);
        }

        @Deprecated
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DateTimePatternGenerator_VariableField$toString(), 0, this);
        }

        public /* synthetic */ VariableField() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VariableField)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PatternInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int OK = 0;
        public static int BASE_CONFLICT = 1;
        public static int CONFLICT = 2;
        public int status;
        public String conflictingPattern;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_PatternInfo$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_PatternInfo$__constructor__();
        }

        public PatternInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_PatternInfo$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DayPeriodAllowedHoursSink
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        HashMap<String, String[]> tempMap;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_DayPeriodAllowedHoursSink$__constructor__(HashMap<String, String[]> tempMap) {
            this.tempMap = tempMap;
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_DayPeriodAllowedHoursSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table timeData = value.getTable();
            int i = 0;
            while (timeData.getKeyAndValue(i, key, value)) {
                String regionOrLocale = key.toString();
                UResource.Table formatList = value.getTable();
                int j = 0;
                while (formatList.getKeyAndValue(j, key, value)) {
                    if (key.contentEquals("allowed")) {
                        this.tempMap.put(regionOrLocale, value.getStringArrayOrStringAsArray());
                    }
                    ++j;
                }
                ++i;
            }
        }

        private /* synthetic */ void $$robo$$android_icu_text_DateTimePatternGenerator_DayPeriodAllowedHoursSink$__constructor__(HashMap x0, 1 x1) {
        }

        private void __constructor__(HashMap<String, String[]> hashMap) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_DayPeriodAllowedHoursSink$__constructor__(hashMap);
        }

        private DayPeriodAllowedHoursSink(HashMap<String, String[]> hashMap) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_DayPeriodAllowedHoursSink$__constructor__(java.util.HashMap<java.lang.String, java.lang.String[]> ), 0, this, hashMap);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_DateTimePatternGenerator_DayPeriodAllowedHoursSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        private /* synthetic */ void __constructor__(HashMap hashMap, 1 var2_2) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_DayPeriodAllowedHoursSink$__constructor__(hashMap, var2_2);
        }

        public /* synthetic */ DayPeriodAllowedHoursSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DayPeriodAllowedHoursSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AvailableFormatsSink
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        PatternInfo returnInfo;
        /* synthetic */ DateTimePatternGenerator this$0;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_AvailableFormatsSink$__constructor__(DateTimePatternGenerator dateTimePatternGenerator, PatternInfo returnInfo) {
            this.returnInfo = returnInfo;
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_AvailableFormatsSink$put(UResource.Key key, UResource.Value value, boolean isRoot) {
            UResource.Table formatsTable = value.getTable();
            int i = 0;
            while (formatsTable.getKeyAndValue(i, key, value)) {
                String formatKey = key.toString();
                if (!this.this$0.isAvailableFormatSet(formatKey)) {
                    this.this$0.setAvailableFormat(formatKey);
                    String formatValue = value.toString();
                    this.this$0.addPatternWithSkeleton(formatValue, formatKey, !isRoot, this.returnInfo);
                }
                ++i;
            }
        }

        private void __constructor__(DateTimePatternGenerator dateTimePatternGenerator, PatternInfo patternInfo) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_AvailableFormatsSink$__constructor__(dateTimePatternGenerator, patternInfo);
        }

        public AvailableFormatsSink(DateTimePatternGenerator dateTimePatternGenerator, PatternInfo patternInfo) {
            this.this$0 = dateTimePatternGenerator;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_AvailableFormatsSink$__constructor__(android.icu.text.DateTimePatternGenerator android.icu.text.DateTimePatternGenerator$PatternInfo ), 0, this, dateTimePatternGenerator, patternInfo);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_DateTimePatternGenerator_AvailableFormatsSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        public /* synthetic */ AvailableFormatsSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AvailableFormatsSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AppendItemNamesSink
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DateTimePatternGenerator this$0;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemNamesSink$__constructor__(DateTimePatternGenerator dateTimePatternGenerator) {
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemNamesSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table itemsTable = value.getTable();
            int i = 0;
            while (itemsTable.getKeyAndValue(i, key, value)) {
                int field = DateTimePatternGenerator.getCLDRFieldNumber(key);
                if (field != -1) {
                    UResource.Table detailsTable = value.getTable();
                    int j = 0;
                    while (detailsTable.getKeyAndValue(j, key, value)) {
                        if (key.contentEquals("dn")) {
                            if (this.this$0.getAppendItemName(field) != null) break;
                            this.this$0.setAppendItemName(field, value.toString());
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        private /* synthetic */ void $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemNamesSink$__constructor__(DateTimePatternGenerator x0, 1 x1) {
        }

        private void __constructor__(DateTimePatternGenerator dateTimePatternGenerator) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_AppendItemNamesSink$__constructor__(dateTimePatternGenerator);
        }

        private AppendItemNamesSink(DateTimePatternGenerator dateTimePatternGenerator) {
            this.this$0 = dateTimePatternGenerator;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemNamesSink$__constructor__(android.icu.text.DateTimePatternGenerator ), 0, this, dateTimePatternGenerator);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemNamesSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        private /* synthetic */ void __constructor__(DateTimePatternGenerator dateTimePatternGenerator, 1 var2_2) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_AppendItemNamesSink$__constructor__(dateTimePatternGenerator, var2_2);
        }

        public /* synthetic */ AppendItemNamesSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppendItemNamesSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AppendItemFormatsSink
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ boolean $assertionsDisabled;
        /* synthetic */ DateTimePatternGenerator this$0;

        private void $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemFormatsSink$__constructor__(DateTimePatternGenerator dateTimePatternGenerator) {
        }

        private final void $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemFormatsSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table itemsTable = value.getTable();
            int i = 0;
            while (itemsTable.getKeyAndValue(i, key, value)) {
                int field = DateTimePatternGenerator.getAppendFormatNumber(key);
                if (!$assertionsDisabled && field == -1) {
                    throw new AssertionError();
                }
                if (this.this$0.getAppendItemFormat(field) == null) {
                    this.this$0.setAppendItemFormat(field, value.toString());
                }
                ++i;
            }
        }

        private /* synthetic */ void $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemFormatsSink$__constructor__(DateTimePatternGenerator x0, 1 x1) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !DateTimePatternGenerator.class.desiredAssertionStatus();
        }

        private void __constructor__(DateTimePatternGenerator dateTimePatternGenerator) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_AppendItemFormatsSink$__constructor__(dateTimePatternGenerator);
        }

        private AppendItemFormatsSink(DateTimePatternGenerator dateTimePatternGenerator) {
            this.this$0 = dateTimePatternGenerator;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemFormatsSink$__constructor__(android.icu.text.DateTimePatternGenerator ), 0, this, dateTimePatternGenerator);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_DateTimePatternGenerator_AppendItemFormatsSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        private /* synthetic */ void __constructor__(DateTimePatternGenerator dateTimePatternGenerator, 1 var2_2) {
            this.$$robo$$android_icu_text_DateTimePatternGenerator_AppendItemFormatsSink$__constructor__(dateTimePatternGenerator, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(AppendItemFormatsSink.class);
        }

        public /* synthetic */ AppendItemFormatsSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppendItemFormatsSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

