/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUConfig;
import android.icu.impl.PatternProps;
import android.icu.util.Freezable;
import android.icu.util.ICUCloneNotSupportedException;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MessagePattern
implements Cloneable,
Freezable<MessagePattern> {
    public transient /* synthetic */ Object __robo_data__;
    public static int ARG_NAME_NOT_NUMBER = -1;
    public static int ARG_NAME_NOT_VALID = -2;
    public static double NO_NUMERIC_VALUE = -1.23456789E8;
    private static int MAX_PREFIX_LENGTH = 24;
    private ApostropheMode aposMode;
    private String msg;
    private ArrayList<Part> parts;
    private ArrayList<Double> numericValues;
    private boolean hasArgNames;
    private boolean hasArgNumbers;
    private boolean needsAutoQuoting;
    private volatile boolean frozen;
    private static ApostropheMode defaultAposMode;
    private static ArgType[] argTypes;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_MessagePattern$__constructor__() {
        this.parts = new ArrayList();
        this.aposMode = defaultAposMode;
    }

    private void $$robo$$android_icu_text_MessagePattern$__constructor__(ApostropheMode mode) {
        this.parts = new ArrayList();
        this.aposMode = mode;
    }

    private void $$robo$$android_icu_text_MessagePattern$__constructor__(String pattern) {
        this.parts = new ArrayList();
        this.aposMode = defaultAposMode;
        this.parse(pattern);
    }

    private final MessagePattern $$robo$$android_icu_text_MessagePattern$parse(String pattern) {
        this.preParse(pattern);
        this.parseMessage(0, 0, 0, ArgType.NONE);
        this.postParse();
        return this;
    }

    private final MessagePattern $$robo$$android_icu_text_MessagePattern$parseChoiceStyle(String pattern) {
        this.preParse(pattern);
        this.parseChoiceStyle(0, 0);
        this.postParse();
        return this;
    }

    private final MessagePattern $$robo$$android_icu_text_MessagePattern$parsePluralStyle(String pattern) {
        this.preParse(pattern);
        this.parsePluralOrSelectStyle(ArgType.PLURAL, 0, 0);
        this.postParse();
        return this;
    }

    private final MessagePattern $$robo$$android_icu_text_MessagePattern$parseSelectStyle(String pattern) {
        this.preParse(pattern);
        this.parsePluralOrSelectStyle(ArgType.SELECT, 0, 0);
        this.postParse();
        return this;
    }

    private final void $$robo$$android_icu_text_MessagePattern$clear() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to clear() a frozen MessagePattern instance.");
        }
        this.msg = null;
        this.hasArgNumbers = false;
        this.hasArgNames = false;
        this.needsAutoQuoting = false;
        this.parts.clear();
        if (this.numericValues != null) {
            this.numericValues.clear();
        }
    }

    private final void $$robo$$android_icu_text_MessagePattern$clearPatternAndSetApostropheMode(ApostropheMode mode) {
        this.clear();
        this.aposMode = mode;
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MessagePattern o = (MessagePattern)other;
        return this.aposMode.equals((Object)o.aposMode) && (this.msg == null ? o.msg == null : this.msg.equals(o.msg)) && this.parts.equals(o.parts);
    }

    private final int $$robo$$android_icu_text_MessagePattern$hashCode() {
        return (this.aposMode.hashCode() * 37 + (this.msg != null ? this.msg.hashCode() : 0)) * 37 + this.parts.hashCode();
    }

    private final ApostropheMode $$robo$$android_icu_text_MessagePattern$getApostropheMode() {
        return this.aposMode;
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$jdkAposMode() {
        return this.aposMode == ApostropheMode.DOUBLE_REQUIRED;
    }

    private final String $$robo$$android_icu_text_MessagePattern$getPatternString() {
        return this.msg;
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$hasNamedArguments() {
        return this.hasArgNames;
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$hasNumberedArguments() {
        return this.hasArgNumbers;
    }

    private final String $$robo$$android_icu_text_MessagePattern$toString() {
        return this.msg;
    }

    private static final int $$robo$$android_icu_text_MessagePattern$validateArgumentName(String name) {
        if (!PatternProps.isIdentifier(name)) {
            return -2;
        }
        return MessagePattern.parseArgNumber(name, 0, name.length());
    }

    private final String $$robo$$android_icu_text_MessagePattern$autoQuoteApostropheDeep() {
        int count;
        if (!this.needsAutoQuoting) {
            return this.msg;
        }
        StringBuilder modified = null;
        int i = count = this.countParts();
        while (i > 0) {
            Part part;
            if ((part = this.getPart(--i)).getType() != Part.Type.INSERT_CHAR) continue;
            if (modified == null) {
                modified = new StringBuilder(this.msg.length() + 10).append(this.msg);
            }
            modified.insert(part.index, (char)part.value);
        }
        if (modified == null) {
            return this.msg;
        }
        return modified.toString();
    }

    private final int $$robo$$android_icu_text_MessagePattern$countParts() {
        return this.parts.size();
    }

    private final Part $$robo$$android_icu_text_MessagePattern$getPart(int i) {
        return this.parts.get(i);
    }

    private final Part.Type $$robo$$android_icu_text_MessagePattern$getPartType(int i) {
        return this.parts.get(i).type;
    }

    private final int $$robo$$android_icu_text_MessagePattern$getPatternIndex(int partIndex) {
        return this.parts.get(partIndex).index;
    }

    private final String $$robo$$android_icu_text_MessagePattern$getSubstring(Part part) {
        int index = part.index;
        return this.msg.substring(index, index + part.length);
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$partSubstringMatches(Part part, String s) {
        return part.length == s.length() && this.msg.regionMatches(part.index, s, 0, part.length);
    }

    private final double $$robo$$android_icu_text_MessagePattern$getNumericValue(Part part) {
        Part.Type type = part.type;
        if (type == Part.Type.ARG_INT) {
            return part.value;
        }
        if (type == Part.Type.ARG_DOUBLE) {
            return this.numericValues.get(part.value);
        }
        return -1.23456789E8;
    }

    private final double $$robo$$android_icu_text_MessagePattern$getPluralOffset(int pluralStart) {
        Part part = this.parts.get(pluralStart);
        if (part.type.hasNumericValue()) {
            return this.getNumericValue(part);
        }
        return 0.0;
    }

    private final int $$robo$$android_icu_text_MessagePattern$getLimitPartIndex(int start) {
        int limit = this.parts.get(start).limitPartIndex;
        if (limit < start) {
            return start;
        }
        return limit;
    }

    private final Object $$robo$$android_icu_text_MessagePattern$clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    private final MessagePattern $$robo$$android_icu_text_MessagePattern$cloneAsThawed() {
        MessagePattern newMsg;
        try {
            newMsg = (MessagePattern)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
        newMsg.parts = (ArrayList)this.parts.clone();
        if (this.numericValues != null) {
            newMsg.numericValues = (ArrayList)this.numericValues.clone();
        }
        newMsg.frozen = false;
        return newMsg;
    }

    private final MessagePattern $$robo$$android_icu_text_MessagePattern$freeze() {
        this.frozen = true;
        return this;
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$isFrozen() {
        return this.frozen;
    }

    private final void $$robo$$android_icu_text_MessagePattern$preParse(String pattern) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to parse(" + MessagePattern.prefix(pattern) + ") on frozen MessagePattern instance.");
        }
        this.msg = pattern;
        this.hasArgNumbers = false;
        this.hasArgNames = false;
        this.needsAutoQuoting = false;
        this.parts.clear();
        if (this.numericValues != null) {
            this.numericValues.clear();
        }
    }

    private final void $$robo$$android_icu_text_MessagePattern$postParse() {
    }

    private final int $$robo$$android_icu_text_MessagePattern$parseMessage(int index, int msgStartLength, int nestingLevel, ArgType parentType) {
        if (nestingLevel > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        int msgStart = this.parts.size();
        this.addPart(Part.Type.MSG_START, index, msgStartLength, nestingLevel);
        index += msgStartLength;
        block0: while (index < this.msg.length()) {
            char c;
            if ((c = this.msg.charAt(index++)) == '\'') {
                if (index == this.msg.length()) {
                    this.addPart(Part.Type.INSERT_CHAR, index, 0, 39);
                    this.needsAutoQuoting = true;
                    continue;
                }
                c = this.msg.charAt(index);
                if (c == '\'') {
                    this.addPart(Part.Type.SKIP_SYNTAX, index++, 1, 0);
                    continue;
                }
                if (this.aposMode == ApostropheMode.DOUBLE_REQUIRED || c == '{' || c == '}' || parentType == ArgType.CHOICE && c == '|' || parentType.hasPluralStyle() && c == '#') {
                    this.addPart(Part.Type.SKIP_SYNTAX, index - 1, 1, 0);
                    while ((index = this.msg.indexOf(39, index + 1)) >= 0) {
                        if (index + 1 < this.msg.length() && this.msg.charAt(index + 1) == '\'') {
                            this.addPart(Part.Type.SKIP_SYNTAX, ++index, 1, 0);
                            continue;
                        }
                        this.addPart(Part.Type.SKIP_SYNTAX, index++, 1, 0);
                        continue block0;
                    }
                    index = this.msg.length();
                    this.addPart(Part.Type.INSERT_CHAR, index, 0, 39);
                    this.needsAutoQuoting = true;
                    continue;
                }
                this.addPart(Part.Type.INSERT_CHAR, index, 0, 39);
                this.needsAutoQuoting = true;
                continue;
            }
            if (parentType.hasPluralStyle() && c == '#') {
                this.addPart(Part.Type.REPLACE_NUMBER, index - 1, 1, 0);
                continue;
            }
            if (c == '{') {
                index = this.parseArg(index - 1, 1, nestingLevel);
                continue;
            }
            if ((nestingLevel <= 0 || c != '}') && (parentType != ArgType.CHOICE || c != '|')) continue;
            int limitLength = parentType == ArgType.CHOICE && c == '}' ? 0 : 1;
            this.addLimitPart(msgStart, Part.Type.MSG_LIMIT, index - 1, limitLength, nestingLevel);
            if (parentType == ArgType.CHOICE) {
                return index - 1;
            }
            return index;
        }
        if (nestingLevel > 0 && !this.inTopLevelChoiceMessage(nestingLevel, parentType)) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        this.addLimitPart(msgStart, Part.Type.MSG_LIMIT, index, 0, nestingLevel);
        return index;
    }

    private final int $$robo$$android_icu_text_MessagePattern$parseArg(int index, int argStartLength, int nestingLevel) {
        int length;
        int argStart = this.parts.size();
        ArgType argType = ArgType.NONE;
        this.addPart(Part.Type.ARG_START, index, argStartLength, argType.ordinal());
        int nameIndex = index = this.skipWhiteSpace(index + argStartLength);
        if (index == this.msg.length()) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        int number = this.parseArgNumber(nameIndex, index = this.skipIdentifier(index));
        if (number >= 0) {
            length = index - nameIndex;
            if (length > 65535 || number > Short.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Argument number too large: " + this.prefix(nameIndex));
            }
            this.hasArgNumbers = true;
            this.addPart(Part.Type.ARG_NUMBER, nameIndex, length, number);
        } else if (number == -1) {
            length = index - nameIndex;
            if (length > 65535) {
                throw new IndexOutOfBoundsException("Argument name too long: " + this.prefix(nameIndex));
            }
            this.hasArgNames = true;
            this.addPart(Part.Type.ARG_NAME, nameIndex, length, 0);
        } else {
            throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(nameIndex));
        }
        index = this.skipWhiteSpace(index);
        if (index == this.msg.length()) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        char c = this.msg.charAt(index);
        if (c != '}') {
            if (c != ',') {
                throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(nameIndex));
            }
            int typeIndex = index = this.skipWhiteSpace(index + 1);
            while (index < this.msg.length() && MessagePattern.isArgTypeChar(this.msg.charAt(index))) {
                ++index;
            }
            int length2 = index - typeIndex;
            if ((index = this.skipWhiteSpace(index)) == this.msg.length()) {
                throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
            }
            if (length2 == 0 || (c = this.msg.charAt(index)) != ',' && c != '}') {
                throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(nameIndex));
            }
            if (length2 > 65535) {
                throw new IndexOutOfBoundsException("Argument type name too long: " + this.prefix(nameIndex));
            }
            argType = ArgType.SIMPLE;
            if (length2 == 6) {
                if (this.isChoice(typeIndex)) {
                    argType = ArgType.CHOICE;
                } else if (this.isPlural(typeIndex)) {
                    argType = ArgType.PLURAL;
                } else if (this.isSelect(typeIndex)) {
                    argType = ArgType.SELECT;
                }
            } else if (length2 == 13 && this.isSelect(typeIndex) && this.isOrdinal(typeIndex + 6)) {
                argType = ArgType.SELECTORDINAL;
            }
            this.parts.get(argStart).value = (short)argType.ordinal();
            if (argType == ArgType.SIMPLE) {
                this.addPart(Part.Type.ARG_TYPE, typeIndex, length2, 0);
            }
            if (c == '}') {
                if (argType != ArgType.SIMPLE) {
                    throw new IllegalArgumentException("No style field for complex argument: " + this.prefix(nameIndex));
                }
            } else {
                ++index;
                index = argType == ArgType.SIMPLE ? this.parseSimpleStyle(index) : (argType == ArgType.CHOICE ? this.parseChoiceStyle(index, nestingLevel) : this.parsePluralOrSelectStyle(argType, index, nestingLevel));
            }
        }
        this.addLimitPart(argStart, Part.Type.ARG_LIMIT, index, 1, argType.ordinal());
        return index + 1;
    }

    private final int $$robo$$android_icu_text_MessagePattern$parseSimpleStyle(int index) {
        int start = index;
        int nestedBraces = 0;
        while (index < this.msg.length()) {
            int length;
            char c;
            if ((c = this.msg.charAt(index++)) == '\'') {
                if ((index = this.msg.indexOf(39, index)) < 0) {
                    throw new IllegalArgumentException("Quoted literal argument style text reaches to the end of the message: " + this.prefix(start));
                }
                ++index;
                continue;
            }
            if (c == '{') {
                ++nestedBraces;
                continue;
            }
            if (c != '}') continue;
            if (nestedBraces > 0) {
                --nestedBraces;
                continue;
            }
            if ((length = --index - start) > 65535) {
                throw new IndexOutOfBoundsException("Argument style text too long: " + this.prefix(start));
            }
            this.addPart(Part.Type.ARG_STYLE, start, length, 0);
            return index;
        }
        throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
    }

    private final int $$robo$$android_icu_text_MessagePattern$parseChoiceStyle(int index, int nestingLevel) {
        int start = index;
        if ((index = this.skipWhiteSpace(index)) == this.msg.length() || this.msg.charAt(index) == '}') {
            throw new IllegalArgumentException("Missing choice argument pattern in " + this.prefix());
        }
        while (true) {
            int numberIndex = index;
            int length = (index = this.skipDouble(index)) - numberIndex;
            if (length == 0) {
                throw new IllegalArgumentException("Bad choice pattern syntax: " + this.prefix(start));
            }
            if (length > 65535) {
                throw new IndexOutOfBoundsException("Choice number too long: " + this.prefix(numberIndex));
            }
            this.parseDouble(numberIndex, index, true);
            index = this.skipWhiteSpace(index);
            if (index == this.msg.length()) {
                throw new IllegalArgumentException("Bad choice pattern syntax: " + this.prefix(start));
            }
            char c = this.msg.charAt(index);
            if (c != '#' && c != '<' && c != '\u2264') {
                throw new IllegalArgumentException("Expected choice separator (#<\u2264) instead of '" + c + "' in choice pattern " + this.prefix(start));
            }
            this.addPart(Part.Type.ARG_SELECTOR, index, 1, 0);
            ++index;
            index = this.parseMessage(index, 0, nestingLevel + 1, ArgType.CHOICE);
            if (index == this.msg.length()) {
                return index;
            }
            if (this.msg.charAt(index) == '}') {
                if (!this.inMessageFormatPattern(nestingLevel)) {
                    throw new IllegalArgumentException("Bad choice pattern syntax: " + this.prefix(start));
                }
                return index;
            }
            index = this.skipWhiteSpace(index + 1);
        }
    }

    private final int $$robo$$android_icu_text_MessagePattern$parsePluralOrSelectStyle(ArgType argType, int index, int nestingLevel) {
        int start = index;
        boolean isEmpty = true;
        boolean hasOther = false;
        while (true) {
            int length;
            boolean eos;
            boolean bl = eos = (index = this.skipWhiteSpace(index)) == this.msg.length();
            if (eos || this.msg.charAt(index) == '}') {
                if (eos == this.inMessageFormatPattern(nestingLevel)) {
                    throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(start));
                }
                if (!hasOther) {
                    throw new IllegalArgumentException("Missing 'other' keyword in " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern in " + this.prefix());
                }
                return index;
            }
            int selectorIndex = index;
            if (argType.hasPluralStyle() && this.msg.charAt(selectorIndex) == '=') {
                length = (index = this.skipDouble(index + 1)) - selectorIndex;
                if (length == 1) {
                    throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(start));
                }
                if (length > 65535) {
                    throw new IndexOutOfBoundsException("Argument selector too long: " + this.prefix(selectorIndex));
                }
                this.addPart(Part.Type.ARG_SELECTOR, selectorIndex, length, 0);
                this.parseDouble(selectorIndex + 1, index, false);
            } else {
                length = (index = this.skipIdentifier(index)) - selectorIndex;
                if (length == 0) {
                    throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(start));
                }
                if (argType.hasPluralStyle() && length == 6 && index < this.msg.length() && this.msg.regionMatches(selectorIndex, "offset:", 0, 7)) {
                    if (!isEmpty) {
                        throw new IllegalArgumentException("Plural argument 'offset:' (if present) must precede key-message pairs: " + this.prefix(start));
                    }
                    int valueIndex = this.skipWhiteSpace(index + 1);
                    if ((index = this.skipDouble(valueIndex)) == valueIndex) {
                        throw new IllegalArgumentException("Missing value for plural 'offset:' " + this.prefix(start));
                    }
                    if (index - valueIndex > 65535) {
                        throw new IndexOutOfBoundsException("Plural offset value too long: " + this.prefix(valueIndex));
                    }
                    this.parseDouble(valueIndex, index, false);
                    isEmpty = false;
                    continue;
                }
                if (length > 65535) {
                    throw new IndexOutOfBoundsException("Argument selector too long: " + this.prefix(selectorIndex));
                }
                this.addPart(Part.Type.ARG_SELECTOR, selectorIndex, length, 0);
                if (this.msg.regionMatches(selectorIndex, "other", 0, length)) {
                    hasOther = true;
                }
            }
            index = this.skipWhiteSpace(index);
            if (index == this.msg.length() || this.msg.charAt(index) != '{') {
                throw new IllegalArgumentException("No message fragment after " + argType.toString().toLowerCase(Locale.ENGLISH) + " selector: " + this.prefix(selectorIndex));
            }
            index = this.parseMessage(index, 1, nestingLevel + 1, argType);
            isEmpty = false;
        }
    }

    private static final int $$robo$$android_icu_text_MessagePattern$parseArgNumber(CharSequence s, int start, int limit) {
        boolean badNumber;
        int number;
        char c;
        if (start >= limit) {
            return -2;
        }
        if ((c = s.charAt(start++)) == '0') {
            if (start == limit) {
                return 0;
            }
            number = 0;
            badNumber = true;
        } else if ('1' <= c && c <= '9') {
            number = c - 48;
            badNumber = false;
        } else {
            return -1;
        }
        while (start < limit) {
            if ('0' <= (c = s.charAt(start++)) && c <= '9') {
                if (number >= 0xCCCCCCC) {
                    badNumber = true;
                }
                number = number * 10 + (c - 48);
                continue;
            }
            return -1;
        }
        if (badNumber) {
            return -2;
        }
        return number;
    }

    private final int $$robo$$android_icu_text_MessagePattern$parseArgNumber(int start, int limit) {
        return MessagePattern.parseArgNumber(this.msg, start, limit);
    }

    private final void $$robo$$android_icu_text_MessagePattern$parseDouble(int start, int limit, boolean allowInfinity) {
        block10: {
            char c;
            int index;
            int isNegative;
            int value;
            block11: {
                block9: {
                    if (!$assertionsDisabled && start >= limit) {
                        throw new AssertionError();
                    }
                    value = 0;
                    isNegative = 0;
                    index = start;
                    if ((c = this.msg.charAt(index++)) != '-') break block9;
                    isNegative = 1;
                    if (index == limit) break block10;
                    c = this.msg.charAt(index++);
                    break block11;
                }
                if (c != '+') break block11;
                if (index == limit) break block10;
                c = this.msg.charAt(index++);
            }
            if (c == '\u221e') {
                if (allowInfinity && index == limit) {
                    this.addArgDoublePart(isNegative != 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY, start, limit - start);
                    return;
                }
            } else {
                while ('0' <= c && c <= '9' && (value = value * 10 + (c - 48)) <= Short.MAX_VALUE + isNegative) {
                    if (index == limit) {
                        this.addPart(Part.Type.ARG_INT, start, limit - start, isNegative != 0 ? -value : value);
                        return;
                    }
                    c = this.msg.charAt(index++);
                }
                double numericValue = Double.parseDouble(this.msg.substring(start, limit));
                this.addArgDoublePart(numericValue, start, limit - start);
                return;
            }
        }
        throw new NumberFormatException("Bad syntax for numeric value: " + this.msg.substring(start, limit));
    }

    private static final void $$robo$$android_icu_text_MessagePattern$appendReducedApostrophes(String s, int start, int limit, StringBuilder sb) {
        int doubleApos = -1;
        while (true) {
            int i;
            if ((i = s.indexOf(39, start)) < 0 || i >= limit) break;
            if (i == doubleApos) {
                sb.append('\'');
                ++start;
                doubleApos = -1;
                continue;
            }
            sb.append(s, start, i);
            doubleApos = start = i + 1;
        }
        sb.append(s, start, limit);
    }

    private final int $$robo$$android_icu_text_MessagePattern$skipWhiteSpace(int index) {
        return PatternProps.skipWhiteSpace(this.msg, index);
    }

    private final int $$robo$$android_icu_text_MessagePattern$skipIdentifier(int index) {
        return PatternProps.skipIdentifier(this.msg, index);
    }

    private final int $$robo$$android_icu_text_MessagePattern$skipDouble(int index) {
        char c;
        while (!(index >= this.msg.length() || (c = this.msg.charAt(index)) < '0' && "+-.".indexOf(c) < 0 || c > '9' && c != 'e' && c != 'E' && c != '\u221e')) {
            ++index;
        }
        return index;
    }

    private static final boolean $$robo$$android_icu_text_MessagePattern$isArgTypeChar(int c) {
        return 97 <= c && c <= 122 || 65 <= c && c <= 90;
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$isChoice(int index) {
        char c;
        return !((c = this.msg.charAt(index++)) != 'c' && c != 'C' || (c = this.msg.charAt(index++)) != 'h' && c != 'H' || (c = this.msg.charAt(index++)) != 'o' && c != 'O' || (c = this.msg.charAt(index++)) != 'i' && c != 'I' || (c = this.msg.charAt(index++)) != 'c' && c != 'C' || (c = this.msg.charAt(index)) != 'e' && c != 'E');
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$isPlural(int index) {
        char c;
        return !((c = this.msg.charAt(index++)) != 'p' && c != 'P' || (c = this.msg.charAt(index++)) != 'l' && c != 'L' || (c = this.msg.charAt(index++)) != 'u' && c != 'U' || (c = this.msg.charAt(index++)) != 'r' && c != 'R' || (c = this.msg.charAt(index++)) != 'a' && c != 'A' || (c = this.msg.charAt(index)) != 'l' && c != 'L');
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$isSelect(int index) {
        char c;
        return !((c = this.msg.charAt(index++)) != 's' && c != 'S' || (c = this.msg.charAt(index++)) != 'e' && c != 'E' || (c = this.msg.charAt(index++)) != 'l' && c != 'L' || (c = this.msg.charAt(index++)) != 'e' && c != 'E' || (c = this.msg.charAt(index++)) != 'c' && c != 'C' || (c = this.msg.charAt(index)) != 't' && c != 'T');
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$isOrdinal(int index) {
        char c;
        return !((c = this.msg.charAt(index++)) != 'o' && c != 'O' || (c = this.msg.charAt(index++)) != 'r' && c != 'R' || (c = this.msg.charAt(index++)) != 'd' && c != 'D' || (c = this.msg.charAt(index++)) != 'i' && c != 'I' || (c = this.msg.charAt(index++)) != 'n' && c != 'N' || (c = this.msg.charAt(index++)) != 'a' && c != 'A' || (c = this.msg.charAt(index)) != 'l' && c != 'L');
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$inMessageFormatPattern(int nestingLevel) {
        return nestingLevel > 0 || this.parts.get(0).type == Part.Type.MSG_START;
    }

    private final boolean $$robo$$android_icu_text_MessagePattern$inTopLevelChoiceMessage(int nestingLevel, ArgType parentType) {
        return nestingLevel == 1 && parentType == ArgType.CHOICE && this.parts.get(0).type != Part.Type.MSG_START;
    }

    private final void $$robo$$android_icu_text_MessagePattern$addPart(Part.Type type, int index, int length, int value) {
        this.parts.add(new Part(type, index, length, value));
    }

    private final void $$robo$$android_icu_text_MessagePattern$addLimitPart(int start, Part.Type type, int index, int length, int value) {
        this.parts.get(start).limitPartIndex = this.parts.size();
        this.addPart(type, index, length, value);
    }

    private final void $$robo$$android_icu_text_MessagePattern$addArgDoublePart(double numericValue, int start, int length) {
        int numericIndex;
        if (this.numericValues == null) {
            this.numericValues = new ArrayList();
            numericIndex = 0;
        } else {
            numericIndex = this.numericValues.size();
            if (numericIndex > Short.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Too many numeric values");
            }
        }
        this.numericValues.add(numericValue);
        this.addPart(Part.Type.ARG_DOUBLE, start, length, numericIndex);
    }

    private static final String $$robo$$android_icu_text_MessagePattern$prefix(String s, int start) {
        StringBuilder prefix = new StringBuilder(44);
        if (start == 0) {
            prefix.append("\"");
        } else {
            prefix.append("[at pattern index ").append(start).append("] \"");
        }
        int substringLength = s.length() - start;
        if (substringLength <= 24) {
            prefix.append(start == 0 ? s : s.substring(start));
        } else {
            int limit = start + 24 - 4;
            if (Character.isHighSurrogate(s.charAt(limit - 1))) {
                --limit;
            }
            prefix.append(s, start, limit).append(" ...");
        }
        return prefix.append("\"").toString();
    }

    private static final String $$robo$$android_icu_text_MessagePattern$prefix(String s) {
        return MessagePattern.prefix(s, 0);
    }

    private final String $$robo$$android_icu_text_MessagePattern$prefix(int start) {
        return MessagePattern.prefix(this.msg, start);
    }

    private final String $$robo$$android_icu_text_MessagePattern$prefix() {
        return MessagePattern.prefix(this.msg, 0);
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !MessagePattern.class.desiredAssertionStatus();
        defaultAposMode = ApostropheMode.valueOf(ICUConfig.get("android.icu.text.MessagePattern.ApostropheMode", "DOUBLE_OPTIONAL"));
        argTypes = ArgType.values();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_MessagePattern$__constructor__();
    }

    public MessagePattern() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePattern$__constructor__(), 0, this);
    }

    private void __constructor__(ApostropheMode apostropheMode) {
        this.$$robo$$android_icu_text_MessagePattern$__constructor__(apostropheMode);
    }

    public MessagePattern(ApostropheMode apostropheMode) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePattern$__constructor__(android.icu.text.MessagePattern$ApostropheMode ), 0, this, apostropheMode);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_text_MessagePattern$__constructor__(string2);
    }

    public MessagePattern(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePattern$__constructor__(java.lang.String ), 0, this, string2);
    }

    public MessagePattern parse(String string2) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_MessagePattern$parse(java.lang.String ), 0, this, string2);
    }

    public MessagePattern parseChoiceStyle(String string2) {
        return InvokeDynamicSupport.bootstrap("parseChoiceStyle", $$robo$$android_icu_text_MessagePattern$parseChoiceStyle(java.lang.String ), 0, this, string2);
    }

    public MessagePattern parsePluralStyle(String string2) {
        return InvokeDynamicSupport.bootstrap("parsePluralStyle", $$robo$$android_icu_text_MessagePattern$parsePluralStyle(java.lang.String ), 0, this, string2);
    }

    public MessagePattern parseSelectStyle(String string2) {
        return InvokeDynamicSupport.bootstrap("parseSelectStyle", $$robo$$android_icu_text_MessagePattern$parseSelectStyle(java.lang.String ), 0, this, string2);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_text_MessagePattern$clear(), 0, this);
    }

    public void clearPatternAndSetApostropheMode(ApostropheMode apostropheMode) {
        InvokeDynamicSupport.bootstrap("clearPatternAndSetApostropheMode", $$robo$$android_icu_text_MessagePattern$clearPatternAndSetApostropheMode(android.icu.text.MessagePattern$ApostropheMode ), 0, this, apostropheMode);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_MessagePattern$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_MessagePattern$hashCode(), 0, this);
    }

    public ApostropheMode getApostropheMode() {
        return InvokeDynamicSupport.bootstrap("getApostropheMode", $$robo$$android_icu_text_MessagePattern$getApostropheMode(), 0, this);
    }

    boolean jdkAposMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("jdkAposMode", $$robo$$android_icu_text_MessagePattern$jdkAposMode(), 0, this);
    }

    public String getPatternString() {
        return InvokeDynamicSupport.bootstrap("getPatternString", $$robo$$android_icu_text_MessagePattern$getPatternString(), 0, this);
    }

    public boolean hasNamedArguments() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNamedArguments", $$robo$$android_icu_text_MessagePattern$hasNamedArguments(), 0, this);
    }

    public boolean hasNumberedArguments() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNumberedArguments", $$robo$$android_icu_text_MessagePattern$hasNumberedArguments(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MessagePattern$toString(), 0, this);
    }

    public static int validateArgumentName(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("validateArgumentName", $$robo$$android_icu_text_MessagePattern$validateArgumentName(java.lang.String ), 0, (String)string2);
    }

    public String autoQuoteApostropheDeep() {
        return InvokeDynamicSupport.bootstrap("autoQuoteApostropheDeep", $$robo$$android_icu_text_MessagePattern$autoQuoteApostropheDeep(), 0, this);
    }

    public int countParts() {
        return (int)InvokeDynamicSupport.bootstrap("countParts", $$robo$$android_icu_text_MessagePattern$countParts(), 0, this);
    }

    public Part getPart(int n) {
        return InvokeDynamicSupport.bootstrap("getPart", $$robo$$android_icu_text_MessagePattern$getPart(int ), 0, this, n);
    }

    public Part.Type getPartType(int n) {
        return InvokeDynamicSupport.bootstrap("getPartType", $$robo$$android_icu_text_MessagePattern$getPartType(int ), 0, this, n);
    }

    public int getPatternIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPatternIndex", $$robo$$android_icu_text_MessagePattern$getPatternIndex(int ), 0, this, n);
    }

    public String getSubstring(Part part) {
        return InvokeDynamicSupport.bootstrap("getSubstring", $$robo$$android_icu_text_MessagePattern$getSubstring(android.icu.text.MessagePattern$Part ), 0, this, part);
    }

    public boolean partSubstringMatches(Part part, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("partSubstringMatches", $$robo$$android_icu_text_MessagePattern$partSubstringMatches(android.icu.text.MessagePattern$Part java.lang.String ), 0, this, part, string2);
    }

    public double getNumericValue(Part part) {
        return (double)InvokeDynamicSupport.bootstrap("getNumericValue", $$robo$$android_icu_text_MessagePattern$getNumericValue(android.icu.text.MessagePattern$Part ), 0, this, part);
    }

    public double getPluralOffset(int n) {
        return (double)InvokeDynamicSupport.bootstrap("getPluralOffset", $$robo$$android_icu_text_MessagePattern$getPluralOffset(int ), 0, this, n);
    }

    public int getLimitPartIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLimitPartIndex", $$robo$$android_icu_text_MessagePattern$getLimitPartIndex(int ), 0, this, n);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_MessagePattern$clone(), 0, this);
    }

    @Override
    public MessagePattern cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_text_MessagePattern$cloneAsThawed(), 0, this);
    }

    @Override
    public MessagePattern freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_MessagePattern$freeze(), 0, this);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_text_MessagePattern$isFrozen(), 0, this);
    }

    private void preParse(String string2) {
        InvokeDynamicSupport.bootstrap("preParse", $$robo$$android_icu_text_MessagePattern$preParse(java.lang.String ), 0, this, string2);
    }

    private void postParse() {
        InvokeDynamicSupport.bootstrap("postParse", $$robo$$android_icu_text_MessagePattern$postParse(), 0, this);
    }

    private int parseMessage(int n, int n2, int n3, ArgType argType) {
        return (int)InvokeDynamicSupport.bootstrap("parseMessage", $$robo$$android_icu_text_MessagePattern$parseMessage(int int int android.icu.text.MessagePattern$ArgType ), 0, this, n, n2, n3, argType);
    }

    private int parseArg(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("parseArg", $$robo$$android_icu_text_MessagePattern$parseArg(int int int ), 0, this, n, n2, n3);
    }

    private int parseSimpleStyle(int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseSimpleStyle", $$robo$$android_icu_text_MessagePattern$parseSimpleStyle(int ), 0, this, n);
    }

    private int parseChoiceStyle(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("parseChoiceStyle", $$robo$$android_icu_text_MessagePattern$parseChoiceStyle(int int ), 0, this, n, n2);
    }

    private int parsePluralOrSelectStyle(ArgType argType, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("parsePluralOrSelectStyle", $$robo$$android_icu_text_MessagePattern$parsePluralOrSelectStyle(android.icu.text.MessagePattern$ArgType int int ), 0, this, argType, n, n2);
    }

    private static int parseArgNumber(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseArgNumber", $$robo$$android_icu_text_MessagePattern$parseArgNumber(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    private int parseArgNumber(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("parseArgNumber", $$robo$$android_icu_text_MessagePattern$parseArgNumber(int int ), 0, this, n, n2);
    }

    private void parseDouble(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("parseDouble", $$robo$$android_icu_text_MessagePattern$parseDouble(int int boolean ), 0, this, n, n2, bl);
    }

    static void appendReducedApostrophes(String string2, int n, int n2, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("appendReducedApostrophes", $$robo$$android_icu_text_MessagePattern$appendReducedApostrophes(java.lang.String int int java.lang.StringBuilder ), 0, (String)string2, (int)n, (int)n2, (StringBuilder)stringBuilder);
    }

    private int skipWhiteSpace(int n) {
        return (int)InvokeDynamicSupport.bootstrap("skipWhiteSpace", $$robo$$android_icu_text_MessagePattern$skipWhiteSpace(int ), 0, this, n);
    }

    private int skipIdentifier(int n) {
        return (int)InvokeDynamicSupport.bootstrap("skipIdentifier", $$robo$$android_icu_text_MessagePattern$skipIdentifier(int ), 0, this, n);
    }

    private int skipDouble(int n) {
        return (int)InvokeDynamicSupport.bootstrap("skipDouble", $$robo$$android_icu_text_MessagePattern$skipDouble(int ), 0, this, n);
    }

    private static boolean isArgTypeChar(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isArgTypeChar", $$robo$$android_icu_text_MessagePattern$isArgTypeChar(int ), 0, (int)n);
    }

    private boolean isChoice(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isChoice", $$robo$$android_icu_text_MessagePattern$isChoice(int ), 0, this, n);
    }

    private boolean isPlural(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPlural", $$robo$$android_icu_text_MessagePattern$isPlural(int ), 0, this, n);
    }

    private boolean isSelect(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSelect", $$robo$$android_icu_text_MessagePattern$isSelect(int ), 0, this, n);
    }

    private boolean isOrdinal(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOrdinal", $$robo$$android_icu_text_MessagePattern$isOrdinal(int ), 0, this, n);
    }

    private boolean inMessageFormatPattern(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("inMessageFormatPattern", $$robo$$android_icu_text_MessagePattern$inMessageFormatPattern(int ), 0, this, n);
    }

    private boolean inTopLevelChoiceMessage(int n, ArgType argType) {
        return (boolean)InvokeDynamicSupport.bootstrap("inTopLevelChoiceMessage", $$robo$$android_icu_text_MessagePattern$inTopLevelChoiceMessage(int android.icu.text.MessagePattern$ArgType ), 0, this, n, argType);
    }

    private void addPart(Part.Type type, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("addPart", $$robo$$android_icu_text_MessagePattern$addPart(android.icu.text.MessagePattern$Part$Type int int int ), 0, this, type, n, n2, n3);
    }

    private void addLimitPart(int n, Part.Type type, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("addLimitPart", $$robo$$android_icu_text_MessagePattern$addLimitPart(int android.icu.text.MessagePattern$Part$Type int int int ), 0, this, n, type, n2, n3, n4);
    }

    private void addArgDoublePart(double d, int n, int n2) {
        InvokeDynamicSupport.bootstrap("addArgDoublePart", $$robo$$android_icu_text_MessagePattern$addArgDoublePart(double int int ), 0, this, d, n, n2);
    }

    private static String prefix(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("prefix", $$robo$$android_icu_text_MessagePattern$prefix(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static String prefix(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("prefix", $$robo$$android_icu_text_MessagePattern$prefix(java.lang.String ), 0, (String)string2);
    }

    private String prefix(int n) {
        return InvokeDynamicSupport.bootstrap("prefix", $$robo$$android_icu_text_MessagePattern$prefix(int ), 0, this, n);
    }

    private String prefix() {
        return InvokeDynamicSupport.bootstrap("prefix", $$robo$$android_icu_text_MessagePattern$prefix(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MessagePattern.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessagePattern)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ArgType
    extends Enum<ArgType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ArgType NONE;
        public static /* enum */ ArgType SIMPLE;
        public static /* enum */ ArgType CHOICE;
        public static /* enum */ ArgType PLURAL;
        public static /* enum */ ArgType SELECT;
        public static /* enum */ ArgType SELECTORDINAL;
        private static /* synthetic */ ArgType[] $VALUES;

        private static final ArgType[] $$robo$$android_icu_text_MessagePattern_ArgType$values() {
            return (ArgType[])$VALUES.clone();
        }

        private static final ArgType $$robo$$android_icu_text_MessagePattern_ArgType$valueOf(String name) {
            return Enum.valueOf(ArgType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_MessagePattern_ArgType$__constructor__(String string2, int n) {
        }

        private final boolean $$robo$$android_icu_text_MessagePattern_ArgType$hasPluralStyle() {
            return this == PLURAL || this == SELECTORDINAL;
        }

        static void __staticInitializer__() {
            NONE = new ArgType();
            SIMPLE = new ArgType();
            CHOICE = new ArgType();
            PLURAL = new ArgType();
            SELECT = new ArgType();
            SELECTORDINAL = new ArgType();
            $VALUES = new ArgType[]{NONE, SIMPLE, CHOICE, PLURAL, SELECT, SELECTORDINAL};
        }

        public static ArgType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_MessagePattern_ArgType$values(), 0);
        }

        public static ArgType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_MessagePattern_ArgType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_MessagePattern_ArgType$__constructor__(string2, n);
        }

        private ArgType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePattern_ArgType$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public boolean hasPluralStyle() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasPluralStyle", $$robo$$android_icu_text_MessagePattern_ArgType$hasPluralStyle(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ArgType.class);
        }

        public /* synthetic */ ArgType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ArgType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Part
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_LENGTH = 65535;
        private static int MAX_VALUE = Short.MAX_VALUE;
        private Type type;
        private int index;
        private char length;
        private short value;
        private int limitPartIndex;

        private void $$robo$$android_icu_text_MessagePattern_Part$__constructor__(Type t, int i, int l, int v) {
            this.type = t;
            this.index = i;
            this.length = (char)l;
            this.value = (short)v;
        }

        private final Type $$robo$$android_icu_text_MessagePattern_Part$getType() {
            return this.type;
        }

        private final int $$robo$$android_icu_text_MessagePattern_Part$getIndex() {
            return this.index;
        }

        private final int $$robo$$android_icu_text_MessagePattern_Part$getLength() {
            return this.length;
        }

        private final int $$robo$$android_icu_text_MessagePattern_Part$getLimit() {
            return this.index + this.length;
        }

        private final int $$robo$$android_icu_text_MessagePattern_Part$getValue() {
            return this.value;
        }

        private final ArgType $$robo$$android_icu_text_MessagePattern_Part$getArgType() {
            Type type = this.getType();
            if (type == Type.ARG_START || type == Type.ARG_LIMIT) {
                return argTypes[this.value];
            }
            return ArgType.NONE;
        }

        private final String $$robo$$android_icu_text_MessagePattern_Part$toString() {
            String valueString = this.type == Type.ARG_START || this.type == Type.ARG_LIMIT ? this.getArgType().name() : Integer.toString(this.value);
            return this.type.name() + "(" + valueString + ")@" + this.index;
        }

        private final boolean $$robo$$android_icu_text_MessagePattern_Part$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Part o = (Part)other;
            return this.type.equals((Object)o.type) && this.index == o.index && this.length == o.length && this.value == o.value && this.limitPartIndex == o.limitPartIndex;
        }

        private final int $$robo$$android_icu_text_MessagePattern_Part$hashCode() {
            return ((this.type.hashCode() * 37 + this.index) * 37 + this.length) * 37 + this.value;
        }

        private /* synthetic */ void $$robo$$android_icu_text_MessagePattern_Part$__constructor__(Type x0, int x1, int x2, int x3, 1 x4) {
        }

        private void __constructor__(Type type, int n, int n2, int n3) {
            this.$$robo$$android_icu_text_MessagePattern_Part$__constructor__(type, n, n2, n3);
        }

        private Part(Type type, int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePattern_Part$__constructor__(android.icu.text.MessagePattern$Part$Type int int int ), 0, this, type, n, n2, n3);
        }

        public Type getType() {
            return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_text_MessagePattern_Part$getType(), 0, this);
        }

        public int getIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$android_icu_text_MessagePattern_Part$getIndex(), 0, this);
        }

        public int getLength() {
            return (int)InvokeDynamicSupport.bootstrap("getLength", $$robo$$android_icu_text_MessagePattern_Part$getLength(), 0, this);
        }

        public int getLimit() {
            return (int)InvokeDynamicSupport.bootstrap("getLimit", $$robo$$android_icu_text_MessagePattern_Part$getLimit(), 0, this);
        }

        public int getValue() {
            return (int)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_icu_text_MessagePattern_Part$getValue(), 0, this);
        }

        public ArgType getArgType() {
            return InvokeDynamicSupport.bootstrap("getArgType", $$robo$$android_icu_text_MessagePattern_Part$getArgType(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MessagePattern_Part$toString(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_MessagePattern_Part$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_MessagePattern_Part$hashCode(), 0, this);
        }

        private /* synthetic */ void __constructor__(Type type, int n, int n2, int n3, 1 var5_5) {
            this.$$robo$$android_icu_text_MessagePattern_Part$__constructor__(type, n, n2, n3, var5_5);
        }

        public /* synthetic */ Part() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Part)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Type
        extends Enum<Type> {
            public transient /* synthetic */ Object __robo_data__;
            public static /* enum */ Type MSG_START;
            public static /* enum */ Type MSG_LIMIT;
            public static /* enum */ Type SKIP_SYNTAX;
            public static /* enum */ Type INSERT_CHAR;
            public static /* enum */ Type REPLACE_NUMBER;
            public static /* enum */ Type ARG_START;
            public static /* enum */ Type ARG_LIMIT;
            public static /* enum */ Type ARG_NUMBER;
            public static /* enum */ Type ARG_NAME;
            public static /* enum */ Type ARG_TYPE;
            public static /* enum */ Type ARG_STYLE;
            public static /* enum */ Type ARG_SELECTOR;
            public static /* enum */ Type ARG_INT;
            public static /* enum */ Type ARG_DOUBLE;
            private static /* synthetic */ Type[] $VALUES;

            private static final Type[] $$robo$$android_icu_text_MessagePattern_Part_Type$values() {
                return (Type[])$VALUES.clone();
            }

            private static final Type $$robo$$android_icu_text_MessagePattern_Part_Type$valueOf(String name) {
                return Enum.valueOf(Type.class, name);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void $$robo$$android_icu_text_MessagePattern_Part_Type$__constructor__(String string2, int n) {
            }

            private final boolean $$robo$$android_icu_text_MessagePattern_Part_Type$hasNumericValue() {
                return this == ARG_INT || this == ARG_DOUBLE;
            }

            static void __staticInitializer__() {
                MSG_START = new Type();
                MSG_LIMIT = new Type();
                SKIP_SYNTAX = new Type();
                INSERT_CHAR = new Type();
                REPLACE_NUMBER = new Type();
                ARG_START = new Type();
                ARG_LIMIT = new Type();
                ARG_NUMBER = new Type();
                ARG_NAME = new Type();
                ARG_TYPE = new Type();
                ARG_STYLE = new Type();
                ARG_SELECTOR = new Type();
                ARG_INT = new Type();
                ARG_DOUBLE = new Type();
                $VALUES = new Type[]{MSG_START, MSG_LIMIT, SKIP_SYNTAX, INSERT_CHAR, REPLACE_NUMBER, ARG_START, ARG_LIMIT, ARG_NUMBER, ARG_NAME, ARG_TYPE, ARG_STYLE, ARG_SELECTOR, ARG_INT, ARG_DOUBLE};
            }

            public static Type[] values() {
                return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_MessagePattern_Part_Type$values(), 0);
            }

            public static Type valueOf(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_MessagePattern_Part_Type$valueOf(java.lang.String ), 0, (String)string2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void __constructor__(String string2, int n) {
                this.$$robo$$android_icu_text_MessagePattern_Part_Type$__constructor__(string2, n);
            }

            private Type() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePattern_Part_Type$__constructor__(java.lang.String int ), 0, this, string2, n);
            }

            public boolean hasNumericValue() {
                return (boolean)InvokeDynamicSupport.bootstrap("hasNumericValue", $$robo$$android_icu_text_MessagePattern_Part_Type$hasNumericValue(), 0, this);
            }

            static {
                RobolectricInternals.classInitializing(Type.class);
            }

            public /* synthetic */ Type() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Type)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ApostropheMode
    extends Enum<ApostropheMode> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ApostropheMode DOUBLE_OPTIONAL;
        public static /* enum */ ApostropheMode DOUBLE_REQUIRED;
        private static /* synthetic */ ApostropheMode[] $VALUES;

        private static final ApostropheMode[] $$robo$$android_icu_text_MessagePattern_ApostropheMode$values() {
            return (ApostropheMode[])$VALUES.clone();
        }

        private static final ApostropheMode $$robo$$android_icu_text_MessagePattern_ApostropheMode$valueOf(String name) {
            return Enum.valueOf(ApostropheMode.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_MessagePattern_ApostropheMode$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            DOUBLE_OPTIONAL = new ApostropheMode();
            DOUBLE_REQUIRED = new ApostropheMode();
            $VALUES = new ApostropheMode[]{DOUBLE_OPTIONAL, DOUBLE_REQUIRED};
        }

        public static ApostropheMode[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_MessagePattern_ApostropheMode$values(), 0);
        }

        public static ApostropheMode valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_MessagePattern_ApostropheMode$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_MessagePattern_ApostropheMode$__constructor__(string2, n);
        }

        private ApostropheMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePattern_ApostropheMode$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ApostropheMode.class);
        }

        public /* synthetic */ ApostropheMode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApostropheMode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

