/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.PatternProps;
import android.icu.impl.Utility;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.NFRule;
import android.icu.text.RuleBasedNumberFormat;
import com.google.errorprone.annotations.DoNotMock;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.LinkedList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class NFRuleSet
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String name;
    private NFRule[] rules;
    NFRule[] nonNumericalRules;
    LinkedList<NFRule> fractionRules;
    static int NEGATIVE_RULE_INDEX = 0;
    static int IMPROPER_FRACTION_RULE_INDEX = 1;
    static int PROPER_FRACTION_RULE_INDEX = 2;
    static int MASTER_RULE_INDEX = 3;
    static int INFINITY_RULE_INDEX = 4;
    static int NAN_RULE_INDEX = 5;
    RuleBasedNumberFormat owner;
    private boolean isFractionRuleSet;
    private boolean isParseable;
    private static int RECURSION_LIMIT = 64;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_NFRuleSet$__constructor__(RuleBasedNumberFormat owner, String[] descriptions, int index) throws IllegalArgumentException {
        this.nonNumericalRules = new NFRule[6];
        this.isFractionRuleSet = false;
        this.owner = owner;
        String description = descriptions[index];
        if (description.length() == 0) {
            throw new IllegalArgumentException("Empty rule set description");
        }
        if (description.charAt(0) == '%') {
            int pos = description.indexOf(58);
            if (pos == -1) {
                throw new IllegalArgumentException("Rule set name doesn't end in colon");
            }
            String name = description.substring(0, pos);
            boolean bl = this.isParseable = !name.endsWith("@noparse");
            if (!this.isParseable) {
                name = name.substring(0, name.length() - 8);
            }
            this.name = name;
            while (pos < description.length() && PatternProps.isWhiteSpace(description.charAt(++pos))) {
            }
            descriptions[index] = description = description.substring(pos);
        } else {
            this.name = "%default";
            this.isParseable = true;
        }
        if (description.length() == 0) {
            throw new IllegalArgumentException("Empty rule set description");
        }
    }

    private final void $$robo$$android_icu_text_NFRuleSet$parseRules(String description) {
        int p;
        ArrayList<NFRule> tempRules = new ArrayList<NFRule>();
        NFRule predecessor = null;
        int oldP = 0;
        int descriptionLen = description.length();
        do {
            if ((p = description.indexOf(59, oldP)) < 0) {
                p = descriptionLen;
            }
            NFRule.makeRules(description.substring(oldP, p), this, predecessor, this.owner, tempRules);
            if (tempRules.isEmpty()) continue;
            predecessor = (NFRule)tempRules.get(tempRules.size() - 1);
        } while ((oldP = p + 1) < descriptionLen);
        long defaultBaseValue = 0L;
        for (NFRule rule : tempRules) {
            long baseValue = rule.getBaseValue();
            if (baseValue == 0L) {
                rule.setBaseValue(defaultBaseValue);
            } else {
                if (baseValue < defaultBaseValue) {
                    throw new IllegalArgumentException("Rules are not in order, base: " + baseValue + " < " + defaultBaseValue);
                }
                defaultBaseValue = baseValue;
            }
            if (this.isFractionRuleSet) continue;
            ++defaultBaseValue;
        }
        this.rules = new NFRule[tempRules.size()];
        tempRules.toArray(this.rules);
    }

    private final void $$robo$$android_icu_text_NFRuleSet$setNonNumericalRule(NFRule rule) {
        long baseValue = rule.getBaseValue();
        if (baseValue == -1L) {
            this.nonNumericalRules[0] = rule;
        } else if (baseValue == -2L) {
            this.setBestFractionRule(1, rule, true);
        } else if (baseValue == -3L) {
            this.setBestFractionRule(2, rule, true);
        } else if (baseValue == -4L) {
            this.setBestFractionRule(3, rule, true);
        } else if (baseValue == -5L) {
            this.nonNumericalRules[4] = rule;
        } else if (baseValue == -6L) {
            this.nonNumericalRules[5] = rule;
        }
    }

    private final void $$robo$$android_icu_text_NFRuleSet$setBestFractionRule(int originalIndex, NFRule newRule, boolean rememberRule) {
        NFRule bestResult;
        if (rememberRule) {
            if (this.fractionRules == null) {
                this.fractionRules = new LinkedList();
            }
            this.fractionRules.add(newRule);
        }
        if ((bestResult = this.nonNumericalRules[originalIndex]) == null) {
            this.nonNumericalRules[originalIndex] = newRule;
        } else {
            DecimalFormatSymbols decimalFormatSymbols = this.owner.getDecimalFormatSymbols();
            if (decimalFormatSymbols.getDecimalSeparator() == newRule.getDecimalPoint()) {
                this.nonNumericalRules[originalIndex] = newRule;
            }
        }
    }

    private final void $$robo$$android_icu_text_NFRuleSet$makeIntoFractionRuleSet() {
        this.isFractionRuleSet = true;
    }

    private final boolean $$robo$$android_icu_text_NFRuleSet$equals(Object that) {
        int i;
        if (!(that instanceof NFRuleSet)) {
            return false;
        }
        NFRuleSet that2 = (NFRuleSet)that;
        if (!this.name.equals(that2.name) || this.rules.length != that2.rules.length || this.isFractionRuleSet != that2.isFractionRuleSet) {
            return false;
        }
        for (i = 0; i < this.nonNumericalRules.length; ++i) {
            if (Utility.objectEquals(this.nonNumericalRules[i], that2.nonNumericalRules[i])) continue;
            return false;
        }
        for (i = 0; i < this.rules.length; ++i) {
            if (this.rules[i].equals(that2.rules[i])) continue;
            return false;
        }
        return true;
    }

    private final int $$robo$$android_icu_text_NFRuleSet$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    private final String $$robo$$android_icu_text_NFRuleSet$toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name).append(":\n");
        for (NFRule rule : this.rules) {
            result.append(rule.toString()).append("\n");
        }
        for (NFRule rule : this.nonNumericalRules) {
            if (rule == null) continue;
            if (rule.getBaseValue() == -2L || rule.getBaseValue() == -3L || rule.getBaseValue() == -4L) {
                for (NFRule fractionRule : this.fractionRules) {
                    if (fractionRule.getBaseValue() != rule.getBaseValue()) continue;
                    result.append(fractionRule.toString()).append("\n");
                }
                continue;
            }
            result.append(rule.toString()).append("\n");
        }
        return result.toString();
    }

    private final boolean $$robo$$android_icu_text_NFRuleSet$isFractionSet() {
        return this.isFractionRuleSet;
    }

    private final String $$robo$$android_icu_text_NFRuleSet$getName() {
        return this.name;
    }

    private final boolean $$robo$$android_icu_text_NFRuleSet$isPublic() {
        return !this.name.startsWith("%%");
    }

    private final boolean $$robo$$android_icu_text_NFRuleSet$isParseable() {
        return this.isParseable;
    }

    private final void $$robo$$android_icu_text_NFRuleSet$format(long number, StringBuilder toInsertInto, int pos, int recursionCount) {
        if (recursionCount >= 64) {
            throw new IllegalStateException("Recursion limit exceeded when applying ruleSet " + this.name);
        }
        NFRule applicableRule = this.findNormalRule(number);
        applicableRule.doFormat(number, toInsertInto, pos, ++recursionCount);
    }

    private final void $$robo$$android_icu_text_NFRuleSet$format(double number, StringBuilder toInsertInto, int pos, int recursionCount) {
        if (recursionCount >= 64) {
            throw new IllegalStateException("Recursion limit exceeded when applying ruleSet " + this.name);
        }
        NFRule applicableRule = this.findRule(number);
        applicableRule.doFormat(number, toInsertInto, pos, ++recursionCount);
    }

    private final NFRule $$robo$$android_icu_text_NFRuleSet$findRule(double number) {
        if (this.isFractionRuleSet) {
            return this.findFractionRuleSetRule(number);
        }
        if (Double.isNaN(number)) {
            NFRule rule = this.nonNumericalRules[5];
            if (rule == null) {
                rule = this.owner.getDefaultNaNRule();
            }
            return rule;
        }
        if (number < 0.0) {
            if (this.nonNumericalRules[0] != null) {
                return this.nonNumericalRules[0];
            }
            number = -number;
        }
        if (Double.isInfinite(number)) {
            NFRule rule = this.nonNumericalRules[4];
            if (rule == null) {
                rule = this.owner.getDefaultInfinityRule();
            }
            return rule;
        }
        if (number != Math.floor(number)) {
            if (number < 1.0 && this.nonNumericalRules[2] != null) {
                return this.nonNumericalRules[2];
            }
            if (this.nonNumericalRules[1] != null) {
                return this.nonNumericalRules[1];
            }
        }
        if (this.nonNumericalRules[3] != null) {
            return this.nonNumericalRules[3];
        }
        return this.findNormalRule(Math.round(number));
    }

    private final NFRule $$robo$$android_icu_text_NFRuleSet$findNormalRule(long number) {
        if (this.isFractionRuleSet) {
            return this.findFractionRuleSetRule(number);
        }
        if (number < 0L) {
            if (this.nonNumericalRules[0] != null) {
                return this.nonNumericalRules[0];
            }
            number = -number;
        }
        int lo = 0;
        int hi = this.rules.length;
        if (hi > 0) {
            while (lo < hi) {
                int mid = lo + hi >>> 1;
                long ruleBaseValue = this.rules[mid].getBaseValue();
                if (ruleBaseValue == number) {
                    return this.rules[mid];
                }
                if (ruleBaseValue > number) {
                    hi = mid;
                    continue;
                }
                lo = mid + 1;
            }
            if (hi == 0) {
                throw new IllegalStateException("The rule set " + this.name + " cannot format the value " + number);
            }
            NFRule result = this.rules[hi - 1];
            if (result.shouldRollBack(number)) {
                if (hi == 1) {
                    throw new IllegalStateException("The rule set " + this.name + " cannot roll back from the rule '" + result + "'");
                }
                result = this.rules[hi - 2];
            }
            return result;
        }
        return this.nonNumericalRules[3];
    }

    private final NFRule $$robo$$android_icu_text_NFRuleSet$findFractionRuleSetRule(double number) {
        long leastCommonMultiple = this.rules[0].getBaseValue();
        for (int i = 1; i < this.rules.length; ++i) {
            leastCommonMultiple = NFRuleSet.lcm(leastCommonMultiple, this.rules[i].getBaseValue());
        }
        long numerator = Math.round(number * (double)leastCommonMultiple);
        long difference = Long.MAX_VALUE;
        int winner = 0;
        for (int i = 0; i < this.rules.length; ++i) {
            long tempDifference = numerator * this.rules[i].getBaseValue() % leastCommonMultiple;
            if (leastCommonMultiple - tempDifference < tempDifference) {
                tempDifference = leastCommonMultiple - tempDifference;
            }
            if (tempDifference >= difference) continue;
            difference = tempDifference;
            winner = i;
            if (difference == 0L) break;
        }
        if (winner + 1 < this.rules.length && this.rules[winner + 1].getBaseValue() == this.rules[winner].getBaseValue() && (Math.round(number * (double)this.rules[winner].getBaseValue()) < 1L || Math.round(number * (double)this.rules[winner].getBaseValue()) >= 2L)) {
            ++winner;
        }
        return this.rules[winner];
    }

    private static final long $$robo$$android_icu_text_NFRuleSet$lcm(long x, long y) {
        long x1 = x;
        long y1 = y;
        int p2 = 0;
        while ((x1 & 1L) == 0L && (y1 & 1L) == 0L) {
            ++p2;
            x1 >>= 1;
            y1 >>= 1;
        }
        long t = (x1 & 1L) == 1L ? -y1 : x1;
        while (t != 0L) {
            while ((t & 1L) == 0L) {
                t >>= 1;
            }
            if (t > 0L) {
                x1 = t;
            } else {
                y1 = -t;
            }
            t = x1 - y1;
        }
        long gcd = x1 << p2;
        return x / gcd * y;
    }

    private final Number $$robo$$android_icu_text_NFRuleSet$parse(String text, ParsePosition parsePosition, double upperBound) {
        Number tempResult;
        ParsePosition highWaterMark = new ParsePosition(0);
        Number result = NFRule.ZERO;
        if (text.length() == 0) {
            return result;
        }
        for (NFRule fractionRule : this.nonNumericalRules) {
            if (fractionRule == null) continue;
            tempResult = fractionRule.doParse(text, parsePosition, false, upperBound);
            if (parsePosition.getIndex() > highWaterMark.getIndex()) {
                result = tempResult;
                highWaterMark.setIndex(parsePosition.getIndex());
            }
            parsePosition.setIndex(0);
        }
        for (int i = this.rules.length - 1; i >= 0 && highWaterMark.getIndex() < text.length(); --i) {
            if (!this.isFractionRuleSet && (double)this.rules[i].getBaseValue() >= upperBound) continue;
            tempResult = this.rules[i].doParse(text, parsePosition, this.isFractionRuleSet, upperBound);
            if (parsePosition.getIndex() > highWaterMark.getIndex()) {
                result = tempResult;
                highWaterMark.setIndex(parsePosition.getIndex());
            }
            parsePosition.setIndex(0);
        }
        parsePosition.setIndex(highWaterMark.getIndex());
        return result;
    }

    private final void $$robo$$android_icu_text_NFRuleSet$setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        for (NFRule rule : this.rules) {
            rule.setDecimalFormatSymbols(newSymbols);
        }
        if (this.fractionRules != null) {
            for (int nonNumericalIdx = 1; nonNumericalIdx <= 3; ++nonNumericalIdx) {
                if (this.nonNumericalRules[nonNumericalIdx] == null) continue;
                for (NFRule rule : this.fractionRules) {
                    if (this.nonNumericalRules[nonNumericalIdx].getBaseValue() != rule.getBaseValue()) continue;
                    this.setBestFractionRule(nonNumericalIdx, rule, false);
                }
            }
        }
        for (NFRule rule : this.nonNumericalRules) {
            if (rule == null) continue;
            rule.setDecimalFormatSymbols(newSymbols);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !NFRuleSet.class.desiredAssertionStatus();
    }

    private void __constructor__(RuleBasedNumberFormat ruleBasedNumberFormat, String[] stringArray, int n) throws IllegalArgumentException {
        this.$$robo$$android_icu_text_NFRuleSet$__constructor__(ruleBasedNumberFormat, stringArray, n);
    }

    public NFRuleSet(RuleBasedNumberFormat ruleBasedNumberFormat, String[] stringArray, int n) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NFRuleSet$__constructor__(android.icu.text.RuleBasedNumberFormat java.lang.String[] int ), 0, this, ruleBasedNumberFormat, stringArray, n);
    }

    public void parseRules(String string2) {
        InvokeDynamicSupport.bootstrap("parseRules", $$robo$$android_icu_text_NFRuleSet$parseRules(java.lang.String ), 0, this, string2);
    }

    void setNonNumericalRule(NFRule nFRule) {
        InvokeDynamicSupport.bootstrap("setNonNumericalRule", $$robo$$android_icu_text_NFRuleSet$setNonNumericalRule(android.icu.text.NFRule ), 0, this, nFRule);
    }

    private void setBestFractionRule(int n, NFRule nFRule, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBestFractionRule", $$robo$$android_icu_text_NFRuleSet$setBestFractionRule(int android.icu.text.NFRule boolean ), 0, this, n, nFRule, bl);
    }

    public void makeIntoFractionRuleSet() {
        InvokeDynamicSupport.bootstrap("makeIntoFractionRuleSet", $$robo$$android_icu_text_NFRuleSet$makeIntoFractionRuleSet(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_NFRuleSet$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_NFRuleSet$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_NFRuleSet$toString(), 0, this);
    }

    public boolean isFractionSet() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFractionSet", $$robo$$android_icu_text_NFRuleSet$isFractionSet(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_text_NFRuleSet$getName(), 0, this);
    }

    public boolean isPublic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPublic", $$robo$$android_icu_text_NFRuleSet$isPublic(), 0, this);
    }

    public boolean isParseable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isParseable", $$robo$$android_icu_text_NFRuleSet$isParseable(), 0, this);
    }

    public void format(long l, StringBuilder stringBuilder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NFRuleSet$format(long java.lang.StringBuilder int int ), 0, this, l, stringBuilder, n, n2);
    }

    public void format(double d, StringBuilder stringBuilder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NFRuleSet$format(double java.lang.StringBuilder int int ), 0, this, d, stringBuilder, n, n2);
    }

    NFRule findRule(double d) {
        return InvokeDynamicSupport.bootstrap("findRule", $$robo$$android_icu_text_NFRuleSet$findRule(double ), 0, this, d);
    }

    private NFRule findNormalRule(long l) {
        return InvokeDynamicSupport.bootstrap("findNormalRule", $$robo$$android_icu_text_NFRuleSet$findNormalRule(long ), 0, this, l);
    }

    private NFRule findFractionRuleSetRule(double d) {
        return InvokeDynamicSupport.bootstrap("findFractionRuleSetRule", $$robo$$android_icu_text_NFRuleSet$findFractionRuleSetRule(double ), 0, this, d);
    }

    private static long lcm(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("lcm", $$robo$$android_icu_text_NFRuleSet$lcm(long long ), 0, (long)l, (long)l2);
    }

    public Number parse(String string2, ParsePosition parsePosition, double d) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_NFRuleSet$parse(java.lang.String java.text.ParsePosition double ), 0, this, string2, parsePosition, d);
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        InvokeDynamicSupport.bootstrap("setDecimalFormatSymbols", $$robo$$android_icu_text_NFRuleSet$setDecimalFormatSymbols(android.icu.text.DecimalFormatSymbols ), 0, this, decimalFormatSymbols);
    }

    static {
        RobolectricInternals.classInitializing(NFRuleSet.class);
    }

    public /* synthetic */ NFRuleSet() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFRuleSet)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

