/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.text.BreakIterator;
import com.google.errorprone.annotations.DoNotMock;
import java.text.CharacterIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SearchIterator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected BreakIterator breakIterator;
    protected CharacterIterator targetText;
    protected int matchLength;
    Search search_;
    public static int DONE = -1;

    private final void $$robo$$android_icu_text_SearchIterator$setIndex(int position) {
        if (position < this.search_.beginIndex() || position > this.search_.endIndex()) {
            throw new IndexOutOfBoundsException("setIndex(int) expected position to be between " + this.search_.beginIndex() + " and " + this.search_.endIndex());
        }
        this.search_.reset_ = false;
        this.search_.setMatchedLength(0);
        this.search_.matchedIndex_ = -1;
    }

    private final void $$robo$$android_icu_text_SearchIterator$setOverlapping(boolean allowOverlap) {
        this.search_.isOverlap_ = allowOverlap;
    }

    private final void $$robo$$android_icu_text_SearchIterator$setBreakIterator(BreakIterator breakiter) {
        this.search_.setBreakIter(breakiter);
        if (this.search_.breakIter() != null && this.search_.text() != null) {
            this.search_.breakIter().setText((CharacterIterator)this.search_.text().clone());
        }
    }

    private final void $$robo$$android_icu_text_SearchIterator$setTarget(CharacterIterator text) {
        if (text == null || text.getEndIndex() == text.getIndex()) {
            throw new IllegalArgumentException("Illegal null or empty text");
        }
        text.setIndex(text.getBeginIndex());
        this.search_.setTarget(text);
        this.search_.matchedIndex_ = -1;
        this.search_.setMatchedLength(0);
        this.search_.reset_ = true;
        this.search_.isForwardSearching_ = true;
        if (this.search_.breakIter() != null) {
            this.search_.breakIter().setText((CharacterIterator)text.clone());
        }
        if (this.search_.internalBreakIter_ != null) {
            this.search_.internalBreakIter_.setText((CharacterIterator)text.clone());
        }
    }

    private final int $$robo$$android_icu_text_SearchIterator$getMatchStart() {
        return this.search_.matchedIndex_;
    }

    public abstract int getIndex();

    private final int $$robo$$android_icu_text_SearchIterator$getMatchLength() {
        return this.search_.matchedLength();
    }

    private final BreakIterator $$robo$$android_icu_text_SearchIterator$getBreakIterator() {
        return this.search_.breakIter();
    }

    private final CharacterIterator $$robo$$android_icu_text_SearchIterator$getTarget() {
        return this.search_.text();
    }

    private final String $$robo$$android_icu_text_SearchIterator$getMatchedText() {
        if (this.search_.matchedLength() > 0) {
            int limit = this.search_.matchedIndex_ + this.search_.matchedLength();
            StringBuilder result = new StringBuilder(this.search_.matchedLength());
            CharacterIterator it = this.search_.text();
            it.setIndex(this.search_.matchedIndex_);
            while (it.getIndex() < limit) {
                result.append(it.current());
                it.next();
            }
            it.setIndex(this.search_.matchedIndex_);
            return result.toString();
        }
        return null;
    }

    private final int $$robo$$android_icu_text_SearchIterator$next() {
        int index = this.getIndex();
        int matchindex = this.search_.matchedIndex_;
        int matchlength = this.search_.matchedLength();
        this.search_.reset_ = false;
        if (this.search_.isForwardSearching_) {
            int endIdx = this.search_.endIndex();
            if (index == endIdx || matchindex == endIdx || matchindex != -1 && matchindex + matchlength >= endIdx) {
                this.setMatchNotFound();
                return -1;
            }
        } else {
            this.search_.isForwardSearching_ = true;
            if (this.search_.matchedIndex_ != -1) {
                return matchindex;
            }
        }
        if (matchlength > 0) {
            index = this.search_.isOverlap_ ? ++index : (index += matchlength);
        }
        return this.handleNext(index);
    }

    private final int $$robo$$android_icu_text_SearchIterator$previous() {
        int index;
        if (this.search_.reset_) {
            index = this.search_.endIndex();
            this.search_.isForwardSearching_ = false;
            this.search_.reset_ = false;
            this.setIndex(index);
        } else {
            index = this.getIndex();
        }
        int matchindex = this.search_.matchedIndex_;
        if (this.search_.isForwardSearching_) {
            this.search_.isForwardSearching_ = false;
            if (matchindex != -1) {
                return matchindex;
            }
        } else {
            int startIdx = this.search_.beginIndex();
            if (index == startIdx || matchindex == startIdx) {
                this.setMatchNotFound();
                return -1;
            }
        }
        if (matchindex != -1) {
            if (this.search_.isOverlap_) {
                matchindex += this.search_.matchedLength() - 2;
            }
            return this.handlePrevious(matchindex);
        }
        return this.handlePrevious(index);
    }

    private final boolean $$robo$$android_icu_text_SearchIterator$isOverlapping() {
        return this.search_.isOverlap_;
    }

    private final void $$robo$$android_icu_text_SearchIterator$reset() {
        this.setMatchNotFound();
        this.setIndex(this.search_.beginIndex());
        this.search_.isOverlap_ = false;
        this.search_.isCanonicalMatch_ = false;
        this.search_.elementComparisonType_ = ElementComparisonType.STANDARD_ELEMENT_COMPARISON;
        this.search_.isForwardSearching_ = true;
        this.search_.reset_ = true;
    }

    private final int $$robo$$android_icu_text_SearchIterator$first() {
        int startIdx = this.search_.beginIndex();
        this.setIndex(startIdx);
        return this.handleNext(startIdx);
    }

    private final int $$robo$$android_icu_text_SearchIterator$following(int position) {
        this.setIndex(position);
        return this.handleNext(position);
    }

    private final int $$robo$$android_icu_text_SearchIterator$last() {
        int endIdx = this.search_.endIndex();
        this.setIndex(endIdx);
        return this.handlePrevious(endIdx);
    }

    private final int $$robo$$android_icu_text_SearchIterator$preceding(int position) {
        this.setIndex(position);
        return this.handlePrevious(position);
    }

    private void $$robo$$android_icu_text_SearchIterator$__constructor__(CharacterIterator target, BreakIterator breaker) {
        this.search_ = new Search(this);
        if (target == null || target.getEndIndex() - target.getBeginIndex() == 0) {
            throw new IllegalArgumentException("Illegal argument target.  Argument can not be null or of length 0");
        }
        this.search_.setTarget(target);
        this.search_.setBreakIter(breaker);
        if (this.search_.breakIter() != null) {
            this.search_.breakIter().setText((CharacterIterator)target.clone());
        }
        this.search_.isOverlap_ = false;
        this.search_.isCanonicalMatch_ = false;
        this.search_.elementComparisonType_ = ElementComparisonType.STANDARD_ELEMENT_COMPARISON;
        this.search_.isForwardSearching_ = true;
        this.search_.reset_ = true;
        this.search_.matchedIndex_ = -1;
        this.search_.setMatchedLength(0);
    }

    private final void $$robo$$android_icu_text_SearchIterator$setMatchLength(int length) {
        this.search_.setMatchedLength(length);
    }

    protected abstract int handleNext(int var1);

    protected abstract int handlePrevious(int var1);

    @Deprecated
    private final void $$robo$$android_icu_text_SearchIterator$setMatchNotFound() {
        this.search_.matchedIndex_ = -1;
        this.search_.setMatchedLength(0);
    }

    private final void $$robo$$android_icu_text_SearchIterator$setElementComparisonType(ElementComparisonType type) {
        this.search_.elementComparisonType_ = type;
    }

    private final ElementComparisonType $$robo$$android_icu_text_SearchIterator$getElementComparisonType() {
        return this.search_.elementComparisonType_;
    }

    public void setIndex(int n) {
        InvokeDynamicSupport.bootstrap("setIndex", $$robo$$android_icu_text_SearchIterator$setIndex(int ), 0, this, n);
    }

    public void setOverlapping(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOverlapping", $$robo$$android_icu_text_SearchIterator$setOverlapping(boolean ), 0, this, bl);
    }

    public void setBreakIterator(BreakIterator breakIterator) {
        InvokeDynamicSupport.bootstrap("setBreakIterator", $$robo$$android_icu_text_SearchIterator$setBreakIterator(android.icu.text.BreakIterator ), 0, this, breakIterator);
    }

    public void setTarget(CharacterIterator characterIterator) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_icu_text_SearchIterator$setTarget(java.text.CharacterIterator ), 0, this, characterIterator);
    }

    public int getMatchStart() {
        return (int)InvokeDynamicSupport.bootstrap("getMatchStart", $$robo$$android_icu_text_SearchIterator$getMatchStart(), 0, this);
    }

    public int getMatchLength() {
        return (int)InvokeDynamicSupport.bootstrap("getMatchLength", $$robo$$android_icu_text_SearchIterator$getMatchLength(), 0, this);
    }

    public BreakIterator getBreakIterator() {
        return InvokeDynamicSupport.bootstrap("getBreakIterator", $$robo$$android_icu_text_SearchIterator$getBreakIterator(), 0, this);
    }

    public CharacterIterator getTarget() {
        return InvokeDynamicSupport.bootstrap("getTarget", $$robo$$android_icu_text_SearchIterator$getTarget(), 0, this);
    }

    public String getMatchedText() {
        return InvokeDynamicSupport.bootstrap("getMatchedText", $$robo$$android_icu_text_SearchIterator$getMatchedText(), 0, this);
    }

    public int next() {
        return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_SearchIterator$next(), 0, this);
    }

    public int previous() {
        return (int)InvokeDynamicSupport.bootstrap("previous", $$robo$$android_icu_text_SearchIterator$previous(), 0, this);
    }

    public boolean isOverlapping() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverlapping", $$robo$$android_icu_text_SearchIterator$isOverlapping(), 0, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_SearchIterator$reset(), 0, this);
    }

    public int first() {
        return (int)InvokeDynamicSupport.bootstrap("first", $$robo$$android_icu_text_SearchIterator$first(), 0, this);
    }

    public int following(int n) {
        return (int)InvokeDynamicSupport.bootstrap("following", $$robo$$android_icu_text_SearchIterator$following(int ), 0, this, n);
    }

    public int last() {
        return (int)InvokeDynamicSupport.bootstrap("last", $$robo$$android_icu_text_SearchIterator$last(), 0, this);
    }

    public int preceding(int n) {
        return (int)InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_icu_text_SearchIterator$preceding(int ), 0, this, n);
    }

    private void __constructor__(CharacterIterator characterIterator, BreakIterator breakIterator) {
        this.$$robo$$android_icu_text_SearchIterator$__constructor__(characterIterator, breakIterator);
    }

    protected SearchIterator(CharacterIterator characterIterator, BreakIterator breakIterator) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SearchIterator$__constructor__(java.text.CharacterIterator android.icu.text.BreakIterator ), 0, this, characterIterator, breakIterator);
    }

    protected void setMatchLength(int n) {
        InvokeDynamicSupport.bootstrap("setMatchLength", $$robo$$android_icu_text_SearchIterator$setMatchLength(int ), 0, this, n);
    }

    @Deprecated
    protected void setMatchNotFound() {
        InvokeDynamicSupport.bootstrap("setMatchNotFound", $$robo$$android_icu_text_SearchIterator$setMatchNotFound(), 0, this);
    }

    public void setElementComparisonType(ElementComparisonType elementComparisonType) {
        InvokeDynamicSupport.bootstrap("setElementComparisonType", $$robo$$android_icu_text_SearchIterator$setElementComparisonType(android.icu.text.SearchIterator$ElementComparisonType ), 0, this, elementComparisonType);
    }

    public ElementComparisonType getElementComparisonType() {
        return InvokeDynamicSupport.bootstrap("getElementComparisonType", $$robo$$android_icu_text_SearchIterator$getElementComparisonType(), 0, this);
    }

    public /* synthetic */ SearchIterator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SearchIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ElementComparisonType
    extends Enum<ElementComparisonType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ElementComparisonType STANDARD_ELEMENT_COMPARISON;
        public static /* enum */ ElementComparisonType PATTERN_BASE_WEIGHT_IS_WILDCARD;
        public static /* enum */ ElementComparisonType ANY_BASE_WEIGHT_IS_WILDCARD;
        private static /* synthetic */ ElementComparisonType[] $VALUES;

        private static final ElementComparisonType[] $$robo$$android_icu_text_SearchIterator_ElementComparisonType$values() {
            return (ElementComparisonType[])$VALUES.clone();
        }

        private static final ElementComparisonType $$robo$$android_icu_text_SearchIterator_ElementComparisonType$valueOf(String name) {
            return Enum.valueOf(ElementComparisonType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_SearchIterator_ElementComparisonType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            STANDARD_ELEMENT_COMPARISON = new ElementComparisonType();
            PATTERN_BASE_WEIGHT_IS_WILDCARD = new ElementComparisonType();
            ANY_BASE_WEIGHT_IS_WILDCARD = new ElementComparisonType();
            $VALUES = new ElementComparisonType[]{STANDARD_ELEMENT_COMPARISON, PATTERN_BASE_WEIGHT_IS_WILDCARD, ANY_BASE_WEIGHT_IS_WILDCARD};
        }

        public static ElementComparisonType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_SearchIterator_ElementComparisonType$values(), 0);
        }

        public static ElementComparisonType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_SearchIterator_ElementComparisonType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_SearchIterator_ElementComparisonType$__constructor__(string2, n);
        }

        private ElementComparisonType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SearchIterator_ElementComparisonType$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ElementComparisonType.class);
        }

        public /* synthetic */ ElementComparisonType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ElementComparisonType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public final class Search
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean isOverlap_;
        boolean isCanonicalMatch_;
        ElementComparisonType elementComparisonType_;
        BreakIterator internalBreakIter_;
        int matchedIndex_;
        boolean isForwardSearching_;
        boolean reset_;
        /* synthetic */ SearchIterator this$0;

        private void $$robo$$android_icu_text_SearchIterator_Search$__constructor__(SearchIterator this$0) {
        }

        private final CharacterIterator $$robo$$android_icu_text_SearchIterator_Search$text() {
            return this.this$0.targetText;
        }

        private final void $$robo$$android_icu_text_SearchIterator_Search$setTarget(CharacterIterator text) {
            this.this$0.targetText = text;
        }

        private final BreakIterator $$robo$$android_icu_text_SearchIterator_Search$breakIter() {
            return this.this$0.breakIterator;
        }

        private final void $$robo$$android_icu_text_SearchIterator_Search$setBreakIter(BreakIterator breakIter) {
            this.this$0.breakIterator = breakIter;
        }

        private final int $$robo$$android_icu_text_SearchIterator_Search$matchedLength() {
            return this.this$0.matchLength;
        }

        private final void $$robo$$android_icu_text_SearchIterator_Search$setMatchedLength(int matchedLength) {
            this.this$0.matchLength = matchedLength;
        }

        private final int $$robo$$android_icu_text_SearchIterator_Search$beginIndex() {
            if (this.this$0.targetText == null) {
                return 0;
            }
            return this.this$0.targetText.getBeginIndex();
        }

        private final int $$robo$$android_icu_text_SearchIterator_Search$endIndex() {
            if (this.this$0.targetText == null) {
                return 0;
            }
            return this.this$0.targetText.getEndIndex();
        }

        private void __constructor__(SearchIterator searchIterator) {
            this.$$robo$$android_icu_text_SearchIterator_Search$__constructor__(searchIterator);
        }

        Search(SearchIterator searchIterator) {
            this.this$0 = searchIterator;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SearchIterator_Search$__constructor__(android.icu.text.SearchIterator ), 0, this, searchIterator);
        }

        CharacterIterator text() {
            return InvokeDynamicSupport.bootstrap("text", $$robo$$android_icu_text_SearchIterator_Search$text(), 0, this);
        }

        void setTarget(CharacterIterator characterIterator) {
            InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_icu_text_SearchIterator_Search$setTarget(java.text.CharacterIterator ), 0, this, characterIterator);
        }

        BreakIterator breakIter() {
            return InvokeDynamicSupport.bootstrap("breakIter", $$robo$$android_icu_text_SearchIterator_Search$breakIter(), 0, this);
        }

        void setBreakIter(BreakIterator breakIterator) {
            InvokeDynamicSupport.bootstrap("setBreakIter", $$robo$$android_icu_text_SearchIterator_Search$setBreakIter(android.icu.text.BreakIterator ), 0, this, breakIterator);
        }

        int matchedLength() {
            return (int)InvokeDynamicSupport.bootstrap("matchedLength", $$robo$$android_icu_text_SearchIterator_Search$matchedLength(), 0, this);
        }

        void setMatchedLength(int n) {
            InvokeDynamicSupport.bootstrap("setMatchedLength", $$robo$$android_icu_text_SearchIterator_Search$setMatchedLength(int ), 0, this, n);
        }

        int beginIndex() {
            return (int)InvokeDynamicSupport.bootstrap("beginIndex", $$robo$$android_icu_text_SearchIterator_Search$beginIndex(), 0, this);
        }

        int endIndex() {
            return (int)InvokeDynamicSupport.bootstrap("endIndex", $$robo$$android_icu_text_SearchIterator_Search$endIndex(), 0, this);
        }

        public /* synthetic */ Search() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Search)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

