/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.CalendarAstronomer;
import android.icu.impl.CalendarCache;
import android.icu.impl.CalendarUtil;
import android.icu.util.Calendar;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IslamicCalendar
extends Calendar
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = -6253365474073869325L;
    public static int MUHARRAM = 0;
    public static int SAFAR = 1;
    public static int RABI_1 = 2;
    public static int RABI_2 = 3;
    public static int JUMADA_1 = 4;
    public static int JUMADA_2 = 5;
    public static int RAJAB = 6;
    public static int SHABAN = 7;
    public static int RAMADAN = 8;
    public static int SHAWWAL = 9;
    public static int DHU_AL_QIDAH = 10;
    public static int DHU_AL_HIJJAH = 11;
    private static long HIJRA_MILLIS = -42521587200000L;
    private static long CIVIL_EPOC = 1948440L;
    private static long ASTRONOMICAL_EPOC = 1948439L;
    private static int[][] LIMITS;
    private static int[] UMALQURA_MONTHLENGTH;
    private static int UMALQURA_YEAR_START = 1300;
    private static int UMALQURA_YEAR_END = 1600;
    private static byte[] UMALQURA_YEAR_START_ESTIMATE_FIX;
    private static CalendarAstronomer astro;
    private static CalendarCache cache;
    private boolean civil;
    private CalculationType cType;

    private void $$robo$$android_icu_util_IslamicCalendar$__constructor__() {
    }

    private void $$robo$$android_icu_util_IslamicCalendar$__constructor__(TimeZone zone) {
    }

    private void $$robo$$android_icu_util_IslamicCalendar$__constructor__(Locale aLocale) {
    }

    private void $$robo$$android_icu_util_IslamicCalendar$__constructor__(ULocale locale) {
    }

    private void $$robo$$android_icu_util_IslamicCalendar$__constructor__(TimeZone zone, Locale aLocale) {
    }

    private void $$robo$$android_icu_util_IslamicCalendar$__constructor__(TimeZone zone, ULocale locale) {
        this.civil = true;
        this.cType = CalculationType.ISLAMIC_CIVIL;
        this.setCalcTypeForLocale(locale);
        this.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private void $$robo$$android_icu_util_IslamicCalendar$__constructor__(Date date) {
        this.civil = true;
        this.cType = CalculationType.ISLAMIC_CIVIL;
        this.setTime(date);
    }

    private void $$robo$$android_icu_util_IslamicCalendar$__constructor__(int year, int month, int date) {
        this.civil = true;
        this.cType = CalculationType.ISLAMIC_CIVIL;
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
    }

    private void $$robo$$android_icu_util_IslamicCalendar$__constructor__(int year, int month, int date, int hour, int minute, int second) {
        this.civil = true;
        this.cType = CalculationType.ISLAMIC_CIVIL;
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    private final void $$robo$$android_icu_util_IslamicCalendar$setCivil(boolean beCivil) {
        this.civil = beCivil;
        if (beCivil && this.cType != CalculationType.ISLAMIC_CIVIL) {
            long m = this.getTimeInMillis();
            this.cType = CalculationType.ISLAMIC_CIVIL;
            this.clear();
            this.setTimeInMillis(m);
        } else if (!beCivil && this.cType != CalculationType.ISLAMIC) {
            long m = this.getTimeInMillis();
            this.cType = CalculationType.ISLAMIC;
            this.clear();
            this.setTimeInMillis(m);
        }
    }

    private final boolean $$robo$$android_icu_util_IslamicCalendar$isCivil() {
        return this.cType == CalculationType.ISLAMIC_CIVIL;
    }

    private final int $$robo$$android_icu_util_IslamicCalendar$handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    private static final boolean $$robo$$android_icu_util_IslamicCalendar$civilLeapYear(int year) {
        return (14 + 11 * year) % 30 < 11;
    }

    private final long $$robo$$android_icu_util_IslamicCalendar$yearStart(int year) {
        long ys = 0L;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA || this.cType == CalculationType.ISLAMIC_UMALQURA && (year < 1300 || year > 1600)) {
            ys = (long)((year - 1) * 354) + (long)Math.floor((double)(3 + 11 * year) / 30.0);
        } else if (this.cType == CalculationType.ISLAMIC) {
            ys = IslamicCalendar.trueMonthStart(12 * (year - 1));
        } else if (this.cType == CalculationType.ISLAMIC_UMALQURA) {
            int yrStartLinearEstimate = (int)(354.3672 * (double)(year -= 1300) + 460322.05 + 0.5);
            ys = yrStartLinearEstimate + UMALQURA_YEAR_START_ESTIMATE_FIX[year];
        }
        return ys;
    }

    private final long $$robo$$android_icu_util_IslamicCalendar$monthStart(int year, int month) {
        int realYear = year + month / 12;
        int realMonth = month % 12;
        long ms = 0L;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA || this.cType == CalculationType.ISLAMIC_UMALQURA && year < 1300) {
            ms = (long)Math.ceil(29.5 * (double)realMonth) + (long)((realYear - 1) * 354) + (long)Math.floor((double)(3 + 11 * realYear) / 30.0);
        } else if (this.cType == CalculationType.ISLAMIC) {
            ms = IslamicCalendar.trueMonthStart(12 * (realYear - 1) + realMonth);
        } else if (this.cType == CalculationType.ISLAMIC_UMALQURA) {
            ms = this.yearStart(year);
            for (int i = 0; i < month; ++i) {
                ms += (long)this.handleGetMonthLength(year, i);
            }
        }
        return ms;
    }

    private static final long $$robo$$android_icu_util_IslamicCalendar$trueMonthStart(long month) {
        long start = cache.get(month);
        if (start == CalendarCache.EMPTY) {
            long origin = -42521587200000L + (long)Math.floor((double)month * 29.530588853) * 86400000L;
            double age = IslamicCalendar.moonAge(origin);
            if (IslamicCalendar.moonAge(origin) >= 0.0) {
                while ((age = IslamicCalendar.moonAge(origin -= 86400000L)) >= 0.0) {
                }
            } else {
                while ((age = IslamicCalendar.moonAge(origin += 86400000L)) < 0.0) {
                }
            }
            start = (origin - -42521587200000L) / 86400000L + 1L;
            cache.put(month, start);
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final double $$robo$$android_icu_util_IslamicCalendar$moonAge(long time) {
        double age = 0.0;
        CalendarAstronomer calendarAstronomer = astro;
        synchronized (calendarAstronomer) {
            astro.setTime(time);
            age = astro.getMoonAge();
        }
        age = age * 180.0 / Math.PI;
        if (age > 180.0) {
            age -= 360.0;
        }
        return age;
    }

    private final int $$robo$$android_icu_util_IslamicCalendar$handleGetMonthLength(int extendedYear, int month) {
        int length;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA || this.cType == CalculationType.ISLAMIC_UMALQURA && (extendedYear < 1300 || extendedYear > 1600)) {
            length = 29 + (month + 1) % 2;
            if (month == 11 && IslamicCalendar.civilLeapYear(extendedYear)) {
                ++length;
            }
        } else if (this.cType == CalculationType.ISLAMIC) {
            month = 12 * (extendedYear - 1) + month;
            length = (int)(IslamicCalendar.trueMonthStart(month + 1) - IslamicCalendar.trueMonthStart(month));
        } else {
            int idx = extendedYear - 1300;
            int mask = 1 << 11 - month;
            length = (UMALQURA_MONTHLENGTH[idx] & mask) == 0 ? 29 : 30;
        }
        return length;
    }

    private final int $$robo$$android_icu_util_IslamicCalendar$handleGetYearLength(int extendedYear) {
        int length = 0;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA || this.cType == CalculationType.ISLAMIC_UMALQURA && (extendedYear < 1300 || extendedYear > 1600)) {
            length = 354 + (IslamicCalendar.civilLeapYear(extendedYear) ? 1 : 0);
        } else if (this.cType == CalculationType.ISLAMIC) {
            int month = 12 * (extendedYear - 1);
            length = (int)(IslamicCalendar.trueMonthStart(month + 12) - IslamicCalendar.trueMonthStart(month));
        } else if (this.cType == CalculationType.ISLAMIC_UMALQURA) {
            for (int i = 0; i < 12; ++i) {
                length += this.handleGetMonthLength(extendedYear, i);
            }
        }
        return length;
    }

    private final int $$robo$$android_icu_util_IslamicCalendar$handleComputeMonthStart(int eyear, int month, boolean useMonth) {
        return (int)(this.monthStart(eyear, month) + (this.cType == CalculationType.ISLAMIC_TBLA ? 1948439L : 1948440L) - 1L);
    }

    private final int $$robo$$android_icu_util_IslamicCalendar$handleGetExtendedYear() {
        int year = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return year;
    }

    private final void $$robo$$android_icu_util_IslamicCalendar$handleComputeFields(int julianDay) {
        int year = 0;
        int month = 0;
        int dayOfMonth = 0;
        int dayOfYear = 0;
        long days = (long)julianDay - 1948440L;
        if (this.cType == CalculationType.ISLAMIC_CIVIL || this.cType == CalculationType.ISLAMIC_TBLA) {
            if (this.cType == CalculationType.ISLAMIC_TBLA) {
                days = (long)julianDay - 1948439L;
            }
            year = (int)Math.floor((double)(30L * days + 10646L) / 10631.0);
            month = (int)Math.ceil((double)(days - 29L - this.yearStart(year)) / 29.5);
            month = Math.min(month, 11);
        } else if (this.cType == CalculationType.ISLAMIC) {
            int months = (int)Math.floor((double)days / 29.530588853);
            long monthStart = (long)Math.floor((double)months * 29.530588853 - 1.0);
            if (days - monthStart >= 25L && IslamicCalendar.moonAge(this.internalGetTimeInMillis()) > 0.0) {
                ++months;
            }
            while ((monthStart = IslamicCalendar.trueMonthStart(months)) > days) {
                --months;
            }
            year = months / 12 + 1;
            month = months % 12;
        } else if (this.cType == CalculationType.ISLAMIC_UMALQURA) {
            long umalquraStartdays = this.yearStart(1300);
            if (days < umalquraStartdays) {
                year = (int)Math.floor((double)(30L * days + 10646L) / 10631.0);
                month = (int)Math.ceil((double)(days - 29L - this.yearStart(year)) / 29.5);
                month = Math.min(month, 11);
            } else {
                int y = 1299;
                int m = 0;
                long d = 1L;
                while (d > 0L) {
                    if ((d = days - this.yearStart(++y) + 1L) == (long)this.handleGetYearLength(y)) {
                        m = 11;
                        break;
                    }
                    if (d >= (long)this.handleGetYearLength(y)) continue;
                    int monthLen = this.handleGetMonthLength(y, m);
                    m = 0;
                    while (d > (long)monthLen) {
                        d -= (long)monthLen;
                        monthLen = this.handleGetMonthLength(y, ++m);
                    }
                    break block1;
                }
                year = y;
                month = m;
            }
        }
        dayOfMonth = (int)(days - this.monthStart(year, month)) + 1;
        dayOfYear = (int)(days - this.monthStart(year, 0) + 1L);
        this.internalSet(0, 0);
        this.internalSet(1, year);
        this.internalSet(19, year);
        this.internalSet(2, month);
        this.internalSet(5, dayOfMonth);
        this.internalSet(6, dayOfYear);
    }

    private final void $$robo$$android_icu_util_IslamicCalendar$setCalculationType(CalculationType type) {
        this.cType = type;
        this.civil = this.cType == CalculationType.ISLAMIC_CIVIL;
    }

    private final CalculationType $$robo$$android_icu_util_IslamicCalendar$getCalculationType() {
        return this.cType;
    }

    private final void $$robo$$android_icu_util_IslamicCalendar$setCalcTypeForLocale(ULocale locale) {
        String localeCalType = CalendarUtil.getCalendarType(locale);
        if ("islamic-civil".equals(localeCalType)) {
            this.setCalculationType(CalculationType.ISLAMIC_CIVIL);
        } else if ("islamic-umalqura".equals(localeCalType)) {
            this.setCalculationType(CalculationType.ISLAMIC_UMALQURA);
        } else if ("islamic-tbla".equals(localeCalType)) {
            this.setCalculationType(CalculationType.ISLAMIC_TBLA);
        } else if (localeCalType.startsWith("islamic")) {
            this.setCalculationType(CalculationType.ISLAMIC);
        } else {
            this.setCalculationType(CalculationType.ISLAMIC_CIVIL);
        }
    }

    private final String $$robo$$android_icu_util_IslamicCalendar$getType() {
        if (this.cType == null) {
            return "islamic";
        }
        return this.cType.bcpType();
    }

    private final void $$robo$$android_icu_util_IslamicCalendar$readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.cType == null) {
            this.cType = this.civil ? CalculationType.ISLAMIC_CIVIL : CalculationType.ISLAMIC;
        } else {
            this.civil = this.cType == CalculationType.ISLAMIC_CIVIL;
        }
    }

    static void __staticInitializer__() {
        LIMITS = new int[][]{{0, 0, 0, 0}, {1, 1, 5000000, 5000000}, {0, 0, 11, 11}, {1, 1, 50, 51}, new int[0], {1, 1, 29, 30}, {1, 1, 354, 355}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {1, 1, 5000000, 5000000}, new int[0], {1, 1, 5000000, 5000000}, new int[0], new int[0]};
        UMALQURA_MONTHLENGTH = new int[]{2730, 3412, 3785, 1748, 1770, 876, 2733, 1365, 1705, 1938, 2985, 1492, 2778, 1372, 3373, 1685, 1866, 2900, 2922, 1453, 1198, 2639, 1303, 1675, 1701, 2773, 726, 2395, 1181, 2637, 3366, 3477, 1452, 2486, 698, 2651, 1323, 2709, 1738, 2793, 756, 2422, 694, 2390, 2762, 2980, 3026, 1497, 732, 2413, 1357, 2725, 2898, 2981, 1460, 2486, 1367, 663, 1355, 1699, 1874, 2917, 1386, 2731, 1323, 3221, 3402, 3493, 1482, 2774, 2391, 1195, 2379, 2725, 2898, 2922, 1397, 630, 2231, 1115, 1365, 1449, 1460, 2522, 1245, 622, 2358, 2730, 3412, 3506, 1493, 730, 2395, 1195, 2645, 2889, 2916, 2929, 1460, 2741, 2645, 3365, 3730, 3785, 1748, 2793, 2411, 1195, 2707, 3401, 3492, 3506, 2745, 1210, 2651, 1323, 2709, 2858, 2901, 1372, 1213, 573, 2333, 2709, 2890, 2906, 1389, 694, 2363, 1179, 1621, 1705, 1876, 2922, 1388, 2733, 1365, 2857, 2962, 2985, 1492, 2778, 1370, 2731, 1429, 1865, 1892, 2986, 1461, 694, 2646, 3661, 2853, 2898, 2922, 1453, 686, 2351, 1175, 1611, 1701, 1708, 2774, 1373, 1181, 2637, 3350, 3477, 1450, 1461, 730, 2395, 1197, 1429, 1738, 1764, 2794, 1269, 694, 2390, 2730, 2900, 3026, 1497, 746, 2413, 1197, 2709, 2890, 2981, 1458, 2485, 1238, 2711, 1351, 1683, 1865, 2901, 1386, 2667, 1323, 2699, 3398, 3491, 1482, 2774, 1243, 619, 2379, 2725, 2898, 2921, 1397, 374, 2231, 603, 1323, 1381, 1460, 2522, 1261, 365, 2230, 2726, 3410, 3497, 1492, 2778, 2395, 1195, 1619, 1833, 1890, 2985, 1458, 2741, 1365, 2853, 3474, 3785, 1746, 2793, 1387, 1195, 2645, 3369, 3412, 3498, 2485, 1210, 2619, 1179, 2637, 2730, 2773, 730, 2397, 1118, 2606, 3226, 3413, 1714, 1721, 1210, 2653, 1325, 2709, 2898, 2984, 2996, 1465, 730, 2394, 2890, 3492, 3793, 1768, 2922, 1389, 1333, 1685, 3402, 3496, 3540, 1754, 1371, 669, 1579, 2837, 2890, 2965, 1450, 2734, 2350, 3215, 1319, 1685, 1706, 2774, 1373, 669};
        UMALQURA_YEAR_START_ESTIMATE_FIX = new byte[]{0, 0, -1, 0, -1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 1, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, -1, 0, 1, 0, 0, 0, -1, 0, 1, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 0, -1, 0, 1, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, -1, -1, 0, -1, 0, 0, -1, -1, 0, -1, 0, -1, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, -1, 0, 1, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 1, 1, 0, 0, -1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0, -1, 0, 1, 0, 0, 0, -1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 0, -1, 0, 1, 0, 0, -1, -1, 0, 0, 1, 1, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1};
        astro = new CalendarAstronomer();
        cache = new CalendarCache();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_IslamicCalendar$__constructor__();
    }

    public IslamicCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar$__constructor__(), 0, this);
    }

    private void __constructor__(TimeZone timeZone) {
        this.$$robo$$android_icu_util_IslamicCalendar$__constructor__(timeZone);
    }

    public IslamicCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar$__constructor__(android.icu.util.TimeZone ), 0, this, timeZone);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_util_IslamicCalendar$__constructor__(locale);
    }

    public IslamicCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar$__constructor__(java.util.Locale ), 0, this, locale);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_util_IslamicCalendar$__constructor__(uLocale);
    }

    public IslamicCalendar(ULocale uLocale) {
        this(TimeZone.getDefault(), uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void __constructor__(TimeZone timeZone, Locale locale) {
        this.$$robo$$android_icu_util_IslamicCalendar$__constructor__(timeZone, locale);
    }

    public IslamicCalendar(TimeZone timeZone, Locale locale) {
        this(timeZone, ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar$__constructor__(android.icu.util.TimeZone java.util.Locale ), 0, this, timeZone, locale);
    }

    private void __constructor__(TimeZone timeZone, ULocale uLocale) {
        this.$$robo$$android_icu_util_IslamicCalendar$__constructor__(timeZone, uLocale);
    }

    public IslamicCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar$__constructor__(android.icu.util.TimeZone android.icu.util.ULocale ), 0, this, timeZone, uLocale);
    }

    private void __constructor__(Date date) {
        this.$$robo$$android_icu_util_IslamicCalendar$__constructor__(date);
    }

    public IslamicCalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar$__constructor__(java.util.Date ), 0, this, date);
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_icu_util_IslamicCalendar$__constructor__(n, n2, n3);
    }

    public IslamicCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar$__constructor__(int int int ), 0, this, n, n2, n3);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$$android_icu_util_IslamicCalendar$__constructor__(n, n2, n3, n4, n5, n6);
    }

    public IslamicCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar$__constructor__(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    public void setCivil(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCivil", $$robo$$android_icu_util_IslamicCalendar$setCivil(boolean ), 0, this, bl);
    }

    public boolean isCivil() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCivil", $$robo$$android_icu_util_IslamicCalendar$isCivil(), 0, this);
    }

    @Override
    protected int handleGetLimit(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetLimit", $$robo$$android_icu_util_IslamicCalendar$handleGetLimit(int int ), 0, this, n, n2);
    }

    private static boolean civilLeapYear(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("civilLeapYear", $$robo$$android_icu_util_IslamicCalendar$civilLeapYear(int ), 0, (int)n);
    }

    private long yearStart(int n) {
        return (long)InvokeDynamicSupport.bootstrap("yearStart", $$robo$$android_icu_util_IslamicCalendar$yearStart(int ), 0, this, n);
    }

    private long monthStart(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("monthStart", $$robo$$android_icu_util_IslamicCalendar$monthStart(int int ), 0, this, n, n2);
    }

    private static long trueMonthStart(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("trueMonthStart", $$robo$$android_icu_util_IslamicCalendar$trueMonthStart(long ), 0, (long)l);
    }

    static double moonAge(long l) {
        return (double)InvokeDynamicSupport.bootstrapStatic("moonAge", $$robo$$android_icu_util_IslamicCalendar$moonAge(long ), 0, (long)l);
    }

    @Override
    protected int handleGetMonthLength(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetMonthLength", $$robo$$android_icu_util_IslamicCalendar$handleGetMonthLength(int int ), 0, this, n, n2);
    }

    @Override
    protected int handleGetYearLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetYearLength", $$robo$$android_icu_util_IslamicCalendar$handleGetYearLength(int ), 0, this, n);
    }

    @Override
    protected int handleComputeMonthStart(int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("handleComputeMonthStart", $$robo$$android_icu_util_IslamicCalendar$handleComputeMonthStart(int int boolean ), 0, this, n, n2, bl);
    }

    @Override
    protected int handleGetExtendedYear() {
        return (int)InvokeDynamicSupport.bootstrap("handleGetExtendedYear", $$robo$$android_icu_util_IslamicCalendar$handleGetExtendedYear(), 0, this);
    }

    @Override
    protected void handleComputeFields(int n) {
        InvokeDynamicSupport.bootstrap("handleComputeFields", $$robo$$android_icu_util_IslamicCalendar$handleComputeFields(int ), 0, this, n);
    }

    public void setCalculationType(CalculationType calculationType) {
        InvokeDynamicSupport.bootstrap("setCalculationType", $$robo$$android_icu_util_IslamicCalendar$setCalculationType(android.icu.util.IslamicCalendar$CalculationType ), 0, this, calculationType);
    }

    public CalculationType getCalculationType() {
        return InvokeDynamicSupport.bootstrap("getCalculationType", $$robo$$android_icu_util_IslamicCalendar$getCalculationType(), 0, this);
    }

    private void setCalcTypeForLocale(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("setCalcTypeForLocale", $$robo$$android_icu_util_IslamicCalendar$setCalcTypeForLocale(android.icu.util.ULocale ), 0, this, uLocale);
    }

    @Override
    public String getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_util_IslamicCalendar$getType(), 0, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_util_IslamicCalendar$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    static {
        RobolectricInternals.classInitializing(IslamicCalendar.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IslamicCalendar)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CalculationType
    extends Enum<CalculationType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ CalculationType ISLAMIC;
        public static /* enum */ CalculationType ISLAMIC_CIVIL;
        public static /* enum */ CalculationType ISLAMIC_UMALQURA;
        public static /* enum */ CalculationType ISLAMIC_TBLA;
        private String bcpType;
        private static /* synthetic */ CalculationType[] $VALUES;

        private static final CalculationType[] $$robo$$android_icu_util_IslamicCalendar_CalculationType$values() {
            return (CalculationType[])$VALUES.clone();
        }

        private static final CalculationType $$robo$$android_icu_util_IslamicCalendar_CalculationType$valueOf(String name) {
            return Enum.valueOf(CalculationType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_IslamicCalendar_CalculationType$__constructor__(String string2, int n, String bcpType) {
            this.bcpType = bcpType;
        }

        private final String $$robo$$android_icu_util_IslamicCalendar_CalculationType$bcpType() {
            return this.bcpType;
        }

        static void __staticInitializer__() {
            ISLAMIC = new CalculationType("islamic");
            ISLAMIC_CIVIL = new CalculationType("islamic-civil");
            ISLAMIC_UMALQURA = new CalculationType("islamic-umalqura");
            ISLAMIC_TBLA = new CalculationType("islamic-tbla");
            $VALUES = new CalculationType[]{ISLAMIC, ISLAMIC_CIVIL, ISLAMIC_UMALQURA, ISLAMIC_TBLA};
        }

        public static CalculationType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_IslamicCalendar_CalculationType$values(), 0);
        }

        public static CalculationType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_IslamicCalendar_CalculationType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, String string3) {
            this.$$robo$$android_icu_util_IslamicCalendar_CalculationType$__constructor__(string2, n, string3);
        }

        private CalculationType(String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IslamicCalendar_CalculationType$__constructor__(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
        }

        String bcpType() {
            return InvokeDynamicSupport.bootstrap("bcpType", $$robo$$android_icu_util_IslamicCalendar_CalculationType$bcpType(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(CalculationType.class);
        }

        public /* synthetic */ CalculationType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalculationType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

