/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.Relation;
import android.icu.impl.Row;
import android.icu.impl.Utility;
import android.icu.util.Freezable;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.ICUException;
import android.icu.util.LocalePriorityList;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.UResourceBundleIterator;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocaleMatcher
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @Deprecated
    public static boolean DEBUG = false;
    private static ULocale UNKNOWN_LOCALE;
    private static double DEFAULT_THRESHOLD = 0.5;
    private ULocale defaultLanguage;
    private double threshold;
    Set<Row.R3<ULocale, ULocale, Double>> localeToMaxLocaleAndWeight;
    Map<String, Set<Row.R3<ULocale, ULocale, Double>>> desiredLanguageToPossibleLocalesToMaxLocaleToData;
    LanguageMatcherData matcherData;
    private static LanguageMatcherData defaultWritten;
    private static HashMap<String, String> canonicalMap;

    private void $$robo$$android_icu_util_LocaleMatcher$__constructor__(LocalePriorityList languagePriorityList) {
    }

    private void $$robo$$android_icu_util_LocaleMatcher$__constructor__(String languagePriorityListString) {
    }

    @Deprecated
    private void $$robo$$android_icu_util_LocaleMatcher$__constructor__(LocalePriorityList languagePriorityList, LanguageMatcherData matcherData) {
    }

    @Deprecated
    private void $$robo$$android_icu_util_LocaleMatcher$__constructor__(LocalePriorityList languagePriorityList, LanguageMatcherData matcherData, double threshold) {
        this.localeToMaxLocaleAndWeight = new LinkedHashSet<Row.R3<ULocale, ULocale, Double>>();
        this.desiredLanguageToPossibleLocalesToMaxLocaleToData = new LinkedHashMap<String, Set<Row.R3<ULocale, ULocale, Double>>>();
        this.matcherData = matcherData == null ? defaultWritten : matcherData.freeze();
        for (ULocale language : languagePriorityList) {
            this.add(language, languagePriorityList.getWeight(language));
        }
        this.processMapping();
        Iterator<ULocale> it = languagePriorityList.iterator();
        this.defaultLanguage = it.hasNext() ? it.next() : null;
        this.threshold = threshold;
    }

    private final double $$robo$$android_icu_util_LocaleMatcher$match(ULocale desired, ULocale desiredMax, ULocale supported, ULocale supportedMax) {
        return this.matcherData.match(desired, desiredMax, supported, supportedMax);
    }

    private final ULocale $$robo$$android_icu_util_LocaleMatcher$canonicalize(ULocale ulocale) {
        String lang = ulocale.getLanguage();
        String lang2 = canonicalMap.get(lang);
        String script = ulocale.getScript();
        String script2 = canonicalMap.get(script);
        String region = ulocale.getCountry();
        String region2 = canonicalMap.get(region);
        if (lang2 != null || script2 != null || region2 != null) {
            return new ULocale(lang2 == null ? lang : lang2, script2 == null ? script : script2, region2 == null ? region : region2);
        }
        return ulocale;
    }

    private final ULocale $$robo$$android_icu_util_LocaleMatcher$getBestMatch(LocalePriorityList languageList) {
        double bestWeight = 0.0;
        ULocale bestTableMatch = null;
        double penalty = 0.0;
        OutputDouble matchWeight = new OutputDouble();
        for (ULocale language : languageList) {
            ULocale matchLocale = this.getBestMatchInternal(language, matchWeight);
            double weight = matchWeight.value * languageList.getWeight(language) - penalty;
            if (weight > bestWeight) {
                bestWeight = weight;
                bestTableMatch = matchLocale;
            }
            penalty += 0.07000001;
        }
        if (bestWeight < this.threshold) {
            bestTableMatch = this.defaultLanguage;
        }
        return bestTableMatch;
    }

    private final ULocale $$robo$$android_icu_util_LocaleMatcher$getBestMatch(String languageList) {
        return this.getBestMatch(LocalePriorityList.add(languageList).build());
    }

    private final ULocale $$robo$$android_icu_util_LocaleMatcher$getBestMatch(ULocale ulocale) {
        return this.getBestMatchInternal(ulocale, null);
    }

    @Deprecated
    private final ULocale $$robo$$android_icu_util_LocaleMatcher$getBestMatch(ULocale ... ulocales) {
        return this.getBestMatch(LocalePriorityList.add(ulocales).build());
    }

    private final String $$robo$$android_icu_util_LocaleMatcher$toString() {
        return "{" + this.defaultLanguage + ", " + this.localeToMaxLocaleAndWeight + "}";
    }

    private final ULocale $$robo$$android_icu_util_LocaleMatcher$getBestMatchInternal(ULocale languageCode, OutputDouble outputWeight) {
        languageCode = this.canonicalize(languageCode);
        ULocale maximized = this.addLikelySubtags(languageCode);
        double bestWeight = 0.0;
        ULocale bestTableMatch = null;
        String baseLanguage = maximized.getLanguage();
        Set<Row.R3<ULocale, ULocale, Double>> searchTable = this.desiredLanguageToPossibleLocalesToMaxLocaleToData.get(baseLanguage);
        if (searchTable != null) {
            for (Row.R3<ULocale, ULocale, Double> tableKeyValue : searchTable) {
                ULocale tableKey = (ULocale)tableKeyValue.get0();
                ULocale maxLocale = (ULocale)tableKeyValue.get1();
                Double matchedWeight = (Double)tableKeyValue.get2();
                double match = this.match(languageCode, maximized, tableKey, maxLocale);
                double weight = match * matchedWeight;
                if (!(weight > bestWeight)) continue;
                bestWeight = weight;
                bestTableMatch = tableKey;
                if (!(weight > 0.999)) continue;
                break;
            }
        }
        if (bestWeight < this.threshold) {
            bestTableMatch = this.defaultLanguage;
        }
        if (outputWeight != null) {
            outputWeight.value = bestWeight;
        }
        return bestTableMatch;
    }

    private final void $$robo$$android_icu_util_LocaleMatcher$add(ULocale language, Double weight) {
        language = this.canonicalize(language);
        Row.R3<ULocale, ULocale, Double> row = Row.of(language, this.addLikelySubtags(language), weight);
        row.freeze();
        this.localeToMaxLocaleAndWeight.add(row);
    }

    private final void $$robo$$android_icu_util_LocaleMatcher$processMapping() {
        for (Map.Entry<String, Set<String>> entry : this.matcherData.matchingLanguages().keyValuesSet()) {
            String desired = entry.getKey();
            Set<String> supported = entry.getValue();
            for (Row.R3<ULocale, ULocale, Double> localeToMaxAndWeight : this.localeToMaxLocaleAndWeight) {
                ULocale key = (ULocale)localeToMaxAndWeight.get0();
                String lang = key.getLanguage();
                if (!supported.contains(lang)) continue;
                this.addFiltered(desired, localeToMaxAndWeight);
            }
        }
        for (Row.R3 r3 : this.localeToMaxLocaleAndWeight) {
            ULocale key = (ULocale)r3.get0();
            String lang = key.getLanguage();
            this.addFiltered(lang, r3);
        }
    }

    private final void $$robo$$android_icu_util_LocaleMatcher$addFiltered(String desired, Row.R3<ULocale, ULocale, Double> localeToMaxAndWeight) {
        Set<Row.R3<ULocale, ULocale, Double>> map = this.desiredLanguageToPossibleLocalesToMaxLocaleToData.get(desired);
        if (map == null) {
            map = new LinkedHashSet<Row.R3<ULocale, ULocale, Double>>();
            this.desiredLanguageToPossibleLocalesToMaxLocaleToData.put(desired, map);
        }
        map.add(localeToMaxAndWeight);
    }

    private final ULocale $$robo$$android_icu_util_LocaleMatcher$addLikelySubtags(ULocale languageCode) {
        if (languageCode.equals(UNKNOWN_LOCALE)) {
            return UNKNOWN_LOCALE;
        }
        ULocale result = ULocale.addLikelySubtags(languageCode);
        if (result == null || result.equals(languageCode)) {
            String language = languageCode.getLanguage();
            String script = languageCode.getScript();
            String region = languageCode.getCountry();
            return new ULocale((language.length() == 0 ? "und" : language) + "_" + (script.length() == 0 ? "Zzzz" : script) + "_" + (region.length() == 0 ? "ZZ" : region));
        }
        return result;
    }

    @Deprecated
    private static final ICUResourceBundle $$robo$$android_icu_util_LocaleMatcher$getICUSupplementalData() {
        ICUResourceBundle suppData = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        return suppData;
    }

    @Deprecated
    private static final double $$robo$$android_icu_util_LocaleMatcher$match(ULocale a, ULocale b) {
        LocaleMatcher matcher = new LocaleMatcher("");
        return matcher.match(a, matcher.addLikelySubtags(a), b, matcher.addLikelySubtags(b));
    }

    static void __staticInitializer__() {
        UNKNOWN_LOCALE = new ULocale("und");
        canonicalMap = new HashMap();
        canonicalMap.put("iw", "he");
        canonicalMap.put("mo", "ro");
        canonicalMap.put("tl", "fil");
        ICUResourceBundle suppData = LocaleMatcher.getICUSupplementalData();
        UResourceBundle languageMatching = suppData.findTopLevel("languageMatching");
        ICUResourceBundle written = (ICUResourceBundle)languageMatching.get("written");
        defaultWritten = new LanguageMatcherData();
        UResourceBundleIterator iter = written.getIterator();
        while (iter.hasNext()) {
            ICUResourceBundle item = (ICUResourceBundle)iter.next();
            boolean oneway = item.getSize() > 3 && "1".equals(item.getString(3));
            defaultWritten.addDistance(item.getString(0), item.getString(1), Integer.parseInt(item.getString(2)), oneway);
        }
        defaultWritten.freeze();
    }

    private void __constructor__(LocalePriorityList localePriorityList) {
        this.$$robo$$android_icu_util_LocaleMatcher$__constructor__(localePriorityList);
    }

    public LocaleMatcher(LocalePriorityList localePriorityList) {
        this(localePriorityList, defaultWritten);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleMatcher$__constructor__(android.icu.util.LocalePriorityList ), 0, this, localePriorityList);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_util_LocaleMatcher$__constructor__(string2);
    }

    public LocaleMatcher(String string2) {
        this(LocalePriorityList.add(string2).build());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleMatcher$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(LocalePriorityList localePriorityList, LanguageMatcherData languageMatcherData) {
        this.$$robo$$android_icu_util_LocaleMatcher$__constructor__(localePriorityList, languageMatcherData);
    }

    public LocaleMatcher(LocalePriorityList localePriorityList, LanguageMatcherData languageMatcherData) {
        this(localePriorityList, languageMatcherData, 0.5);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleMatcher$__constructor__(android.icu.util.LocalePriorityList android.icu.util.LocaleMatcher$LanguageMatcherData ), 0, this, localePriorityList, languageMatcherData);
    }

    private void __constructor__(LocalePriorityList localePriorityList, LanguageMatcherData languageMatcherData, double d) {
        this.$$robo$$android_icu_util_LocaleMatcher$__constructor__(localePriorityList, languageMatcherData, d);
    }

    public LocaleMatcher(LocalePriorityList localePriorityList, LanguageMatcherData languageMatcherData, double d) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleMatcher$__constructor__(android.icu.util.LocalePriorityList android.icu.util.LocaleMatcher$LanguageMatcherData double ), 0, this, localePriorityList, languageMatcherData, d);
    }

    public double match(ULocale uLocale, ULocale uLocale2, ULocale uLocale3, ULocale uLocale4) {
        return (double)InvokeDynamicSupport.bootstrap("match", $$robo$$android_icu_util_LocaleMatcher$match(android.icu.util.ULocale android.icu.util.ULocale android.icu.util.ULocale android.icu.util.ULocale ), 0, this, uLocale, uLocale2, uLocale3, uLocale4);
    }

    public ULocale canonicalize(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("canonicalize", $$robo$$android_icu_util_LocaleMatcher$canonicalize(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public ULocale getBestMatch(LocalePriorityList localePriorityList) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_util_LocaleMatcher$getBestMatch(android.icu.util.LocalePriorityList ), 0, this, localePriorityList);
    }

    public ULocale getBestMatch(String string2) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_util_LocaleMatcher$getBestMatch(java.lang.String ), 0, this, string2);
    }

    public ULocale getBestMatch(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_util_LocaleMatcher$getBestMatch(android.icu.util.ULocale ), 0, this, uLocale);
    }

    @Deprecated
    public ULocale getBestMatch(ULocale ... uLocaleArray) {
        return InvokeDynamicSupport.bootstrap("getBestMatch", $$robo$$android_icu_util_LocaleMatcher$getBestMatch(android.icu.util.ULocale[] ), 0, this, uLocaleArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_LocaleMatcher$toString(), 0, this);
    }

    private ULocale getBestMatchInternal(ULocale uLocale, OutputDouble outputDouble) {
        return InvokeDynamicSupport.bootstrap("getBestMatchInternal", $$robo$$android_icu_util_LocaleMatcher$getBestMatchInternal(android.icu.util.ULocale android.icu.util.LocaleMatcher$OutputDouble ), 0, this, uLocale, outputDouble);
    }

    private void add(ULocale uLocale, Double d) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_LocaleMatcher$add(android.icu.util.ULocale java.lang.Double ), 0, this, uLocale, d);
    }

    private void processMapping() {
        InvokeDynamicSupport.bootstrap("processMapping", $$robo$$android_icu_util_LocaleMatcher$processMapping(), 0, this);
    }

    private void addFiltered(String string2, Row.R3<ULocale, ULocale, Double> r3) {
        InvokeDynamicSupport.bootstrap("addFiltered", $$robo$$android_icu_util_LocaleMatcher$addFiltered(java.lang.String android.icu.impl.Row$R3<android.icu.util.ULocale, android.icu.util.ULocale, java.lang.Double> ), 0, this, string2, r3);
    }

    private ULocale addLikelySubtags(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("addLikelySubtags", $$robo$$android_icu_util_LocaleMatcher$addLikelySubtags(android.icu.util.ULocale ), 0, this, uLocale);
    }

    @Deprecated
    public static ICUResourceBundle getICUSupplementalData() {
        return InvokeDynamicSupport.bootstrapStatic("getICUSupplementalData", $$robo$$android_icu_util_LocaleMatcher$getICUSupplementalData(), 0);
    }

    @Deprecated
    public static double match(ULocale uLocale, ULocale uLocale2) {
        return (double)InvokeDynamicSupport.bootstrapStatic("match", $$robo$$android_icu_util_LocaleMatcher$match(android.icu.util.ULocale android.icu.util.ULocale ), 0, (ULocale)uLocale, (ULocale)uLocale2);
    }

    static {
        RobolectricInternals.classInitializing(LocaleMatcher.class);
    }

    public /* synthetic */ LocaleMatcher() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleMatcher)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Deprecated
    public static class LanguageMatcherData
    implements Freezable<LanguageMatcherData> {
        public transient /* synthetic */ Object __robo_data__;
        private ScoreData languageScores;
        private ScoreData scriptScores;
        private ScoreData regionScores;
        private Relation<String, String> matchingLanguages;
        private volatile boolean frozen;

        @Deprecated
        private void $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$__constructor__() {
            this.languageScores = new ScoreData(Level.language);
            this.scriptScores = new ScoreData(Level.script);
            this.regionScores = new ScoreData(Level.region);
            this.frozen = false;
        }

        @Deprecated
        private final Relation<String, String> $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$matchingLanguages() {
            return this.matchingLanguages;
        }

        @Deprecated
        private final String $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$toString() {
            return this.languageScores + "\n\t" + this.scriptScores + "\n\t" + this.regionScores;
        }

        @Deprecated
        private final double $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$match(ULocale a, ULocale aMax, ULocale b, ULocale bMax) {
            double diff = 0.0;
            if ((diff += this.languageScores.getScore(aMax, a.getLanguage(), aMax.getLanguage(), bMax, b.getLanguage(), bMax.getLanguage())) > 0.999) {
                return 0.0;
            }
            diff += this.scriptScores.getScore(aMax, a.getScript(), aMax.getScript(), bMax, b.getScript(), bMax.getScript());
            diff += this.regionScores.getScore(aMax, a.getCountry(), aMax.getCountry(), bMax, b.getCountry(), bMax.getCountry());
            if (!a.getVariant().equals(b.getVariant())) {
                diff += 0.01;
            }
            if (diff < 0.0) {
                diff = 0.0;
            } else if (diff > 1.0) {
                diff = 1.0;
            }
            return 1.0 - diff;
        }

        @Deprecated
        private final LanguageMatcherData $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$addDistance(String desired, String supported, int percent, String comment) {
            return this.addDistance(desired, supported, percent, false, comment);
        }

        @Deprecated
        private final LanguageMatcherData $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$addDistance(String desired, String supported, int percent, boolean oneway) {
            return this.addDistance(desired, supported, percent, oneway, null);
        }

        private final LanguageMatcherData $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$addDistance(String desired, String supported, int percent, boolean oneway, String comment) {
            LocalePatternMatcher supportedMatcher;
            Level supportedLen;
            double score = 1.0 - (double)percent / 100.0;
            LocalePatternMatcher desiredMatcher = new LocalePatternMatcher(desired);
            Level desiredLen = desiredMatcher.getLevel();
            if (desiredLen != (supportedLen = (supportedMatcher = new LocalePatternMatcher(supported)).getLevel())) {
                throw new IllegalArgumentException("Lengths unequal: " + desired + ", " + supported);
            }
            Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data = Row.of(desiredMatcher, supportedMatcher, score);
            Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data2 = oneway ? null : Row.of(supportedMatcher, desiredMatcher, score);
            boolean desiredEqualsSupported = desiredMatcher.equals(supportedMatcher);
            switch (1.$SwitchMap$android$icu$util$LocaleMatcher$Level[desiredLen.ordinal()]) {
                case 1: {
                    String dlanguage = desiredMatcher.getLanguage();
                    String slanguage = supportedMatcher.getLanguage();
                    this.languageScores.addDataToScores(dlanguage, slanguage, data);
                    if (oneway || desiredEqualsSupported) break;
                    this.languageScores.addDataToScores(slanguage, dlanguage, data2);
                    break;
                }
                case 2: {
                    String dscript = desiredMatcher.getScript();
                    String sscript = supportedMatcher.getScript();
                    this.scriptScores.addDataToScores(dscript, sscript, data);
                    if (oneway || desiredEqualsSupported) break;
                    this.scriptScores.addDataToScores(sscript, dscript, data2);
                    break;
                }
                case 3: {
                    String dregion = desiredMatcher.getRegion();
                    String sregion = supportedMatcher.getRegion();
                    this.regionScores.addDataToScores(dregion, sregion, data);
                    if (oneway || desiredEqualsSupported) break;
                    this.regionScores.addDataToScores(sregion, dregion, data2);
                }
            }
            return this;
        }

        @Deprecated
        private final LanguageMatcherData $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$cloneAsThawed() {
            try {
                LanguageMatcherData result = (LanguageMatcherData)this.clone();
                result.languageScores = this.languageScores.cloneAsThawed();
                result.scriptScores = this.scriptScores.cloneAsThawed();
                result.regionScores = this.regionScores.cloneAsThawed();
                result.frozen = false;
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new ICUCloneNotSupportedException(e);
            }
        }

        @Deprecated
        private final LanguageMatcherData $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$freeze() {
            this.languageScores.freeze();
            this.regionScores.freeze();
            this.scriptScores.freeze();
            this.matchingLanguages = this.languageScores.getMatchingLanguages();
            this.frozen = true;
            return this;
        }

        @Deprecated
        private final boolean $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$isFrozen() {
            return this.frozen;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$__constructor__();
        }

        public LanguageMatcherData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$__constructor__(), 0, this);
        }

        @Deprecated
        public Relation<String, String> matchingLanguages() {
            return InvokeDynamicSupport.bootstrap("matchingLanguages", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$matchingLanguages(), 0, this);
        }

        @Deprecated
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$toString(), 0, this);
        }

        @Deprecated
        public double match(ULocale uLocale, ULocale uLocale2, ULocale uLocale3, ULocale uLocale4) {
            return (double)InvokeDynamicSupport.bootstrap("match", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$match(android.icu.util.ULocale android.icu.util.ULocale android.icu.util.ULocale android.icu.util.ULocale ), 0, this, uLocale, uLocale2, uLocale3, uLocale4);
        }

        @Deprecated
        public LanguageMatcherData addDistance(String string2, String string3, int n, String string4) {
            return InvokeDynamicSupport.bootstrap("addDistance", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$addDistance(java.lang.String java.lang.String int java.lang.String ), 0, this, string2, string3, n, string4);
        }

        @Deprecated
        public LanguageMatcherData addDistance(String string2, String string3, int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("addDistance", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$addDistance(java.lang.String java.lang.String int boolean ), 0, this, string2, string3, n, bl);
        }

        private LanguageMatcherData addDistance(String string2, String string3, int n, boolean bl, String string4) {
            return InvokeDynamicSupport.bootstrap("addDistance", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$addDistance(java.lang.String java.lang.String int boolean java.lang.String ), 0, this, string2, string3, n, bl, string4);
        }

        @Override
        @Deprecated
        public LanguageMatcherData cloneAsThawed() {
            return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$cloneAsThawed(), 0, this);
        }

        @Override
        @Deprecated
        public LanguageMatcherData freeze() {
            return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$freeze(), 0, this);
        }

        @Override
        @Deprecated
        public boolean isFrozen() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_util_LocaleMatcher_LanguageMatcherData$isFrozen(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LanguageMatcherData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ScoreData
    implements Freezable<ScoreData> {
        public transient /* synthetic */ Object __robo_data__;
        private static double maxUnequal_changeD_sameS = 0.5;
        private static double maxUnequal_changeEqual = 0.75;
        LinkedHashSet<Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double>> scores;
        Level level;
        private volatile boolean frozen;

        private void $$robo$$android_icu_util_LocaleMatcher_ScoreData$__constructor__(Level level) {
            this.scores = new LinkedHashSet();
            this.frozen = false;
            this.level = level;
        }

        private final void $$robo$$android_icu_util_LocaleMatcher_ScoreData$addDataToScores(String desired, String supported, Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> data) {
            boolean added = this.scores.add(data);
            if (!added) {
                throw new ICUException("trying to add duplicate data: " + data);
            }
        }

        private final double $$robo$$android_icu_util_LocaleMatcher_ScoreData$getScore(ULocale dMax, String desiredRaw, String desiredMax, ULocale sMax, String supportedRaw, String supportedMax) {
            double distance = 0.0;
            if (!desiredMax.equals(supportedMax)) {
                distance = this.getRawScore(dMax, sMax);
            } else if (!desiredRaw.equals(supportedRaw)) {
                distance += 0.001;
            }
            return distance;
        }

        private final double $$robo$$android_icu_util_LocaleMatcher_ScoreData$getRawScore(ULocale desiredLocale, ULocale supportedLocale) {
            for (Row.R3 r3 : this.scores) {
                if (!((LocalePatternMatcher)r3.get0()).matches(desiredLocale) || !((LocalePatternMatcher)r3.get1()).matches(supportedLocale)) continue;
                return (Double)r3.get2();
            }
            return this.level.worst;
        }

        private final String $$robo$$android_icu_util_LocaleMatcher_ScoreData$toString() {
            StringBuilder result = new StringBuilder().append((Object)this.level);
            for (Row.R3 r3 : this.scores) {
                result.append("\n\t\t").append(r3);
            }
            return result.toString();
        }

        private final ScoreData $$robo$$android_icu_util_LocaleMatcher_ScoreData$cloneAsThawed() {
            try {
                ScoreData result = (ScoreData)this.clone();
                result.scores = (LinkedHashSet)result.scores.clone();
                result.frozen = false;
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new ICUCloneNotSupportedException(e);
            }
        }

        private final ScoreData $$robo$$android_icu_util_LocaleMatcher_ScoreData$freeze() {
            return this;
        }

        private final boolean $$robo$$android_icu_util_LocaleMatcher_ScoreData$isFrozen() {
            return this.frozen;
        }

        private final Relation<String, String> $$robo$$android_icu_util_LocaleMatcher_ScoreData$getMatchingLanguages() {
            Relation<String, String> desiredToSupported = Relation.of(new LinkedHashMap(), HashSet.class);
            for (Row.R3 r3 : this.scores) {
                LocalePatternMatcher desired = (LocalePatternMatcher)r3.get0();
                LocalePatternMatcher supported = (LocalePatternMatcher)r3.get1();
                if (desired.lang == null || supported.lang == null) continue;
                desiredToSupported.put(desired.lang, supported.lang);
            }
            desiredToSupported.freeze();
            return desiredToSupported;
        }

        private void __constructor__(Level level) {
            this.$$robo$$android_icu_util_LocaleMatcher_ScoreData$__constructor__(level);
        }

        public ScoreData(Level level) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleMatcher_ScoreData$__constructor__(android.icu.util.LocaleMatcher$Level ), 0, this, level);
        }

        void addDataToScores(String string2, String string3, Row.R3<LocalePatternMatcher, LocalePatternMatcher, Double> r3) {
            InvokeDynamicSupport.bootstrap("addDataToScores", $$robo$$android_icu_util_LocaleMatcher_ScoreData$addDataToScores(java.lang.String java.lang.String android.icu.impl.Row$R3<android.icu.util.LocaleMatcher$LocalePatternMatcher, android.icu.util.LocaleMatcher$LocalePatternMatcher, java.lang.Double> ), 0, this, string2, string3, r3);
        }

        double getScore(ULocale uLocale, String string2, String string3, ULocale uLocale2, String string4, String string5) {
            return (double)InvokeDynamicSupport.bootstrap("getScore", $$robo$$android_icu_util_LocaleMatcher_ScoreData$getScore(android.icu.util.ULocale java.lang.String java.lang.String android.icu.util.ULocale java.lang.String java.lang.String ), 0, this, uLocale, string2, string3, uLocale2, string4, string5);
        }

        private double getRawScore(ULocale uLocale, ULocale uLocale2) {
            return (double)InvokeDynamicSupport.bootstrap("getRawScore", $$robo$$android_icu_util_LocaleMatcher_ScoreData$getRawScore(android.icu.util.ULocale android.icu.util.ULocale ), 0, this, uLocale, uLocale2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_LocaleMatcher_ScoreData$toString(), 0, this);
        }

        @Override
        public ScoreData cloneAsThawed() {
            return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_util_LocaleMatcher_ScoreData$cloneAsThawed(), 0, this);
        }

        @Override
        public ScoreData freeze() {
            return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_util_LocaleMatcher_ScoreData$freeze(), 0, this);
        }

        @Override
        public boolean isFrozen() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_util_LocaleMatcher_ScoreData$isFrozen(), 0, this);
        }

        public Relation<String, String> getMatchingLanguages() {
            return InvokeDynamicSupport.bootstrap("getMatchingLanguages", $$robo$$android_icu_util_LocaleMatcher_ScoreData$getMatchingLanguages(), 0, this);
        }

        public /* synthetic */ ScoreData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScoreData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Level
    extends Enum<Level> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Level language;
        public static /* enum */ Level script;
        public static /* enum */ Level region;
        double worst;
        private static /* synthetic */ Level[] $VALUES;

        private static final Level[] $$robo$$android_icu_util_LocaleMatcher_Level$values() {
            return (Level[])$VALUES.clone();
        }

        private static final Level $$robo$$android_icu_util_LocaleMatcher_Level$valueOf(String name) {
            return Enum.valueOf(Level.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_LocaleMatcher_Level$__constructor__(String string2, int n, double d) {
            this.worst = d;
        }

        static void __staticInitializer__() {
            language = new Level(0.99);
            script = new Level(0.2);
            region = new Level(0.04);
            $VALUES = new Level[]{language, script, region};
        }

        public static Level[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_LocaleMatcher_Level$values(), 0);
        }

        public static Level valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_LocaleMatcher_Level$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, double d) {
            this.$$robo$$android_icu_util_LocaleMatcher_Level$__constructor__(string2, n, d);
        }

        private Level(double d) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleMatcher_Level$__constructor__(java.lang.String int double ), 0, this, string2, n, d);
        }

        static {
            RobolectricInternals.classInitializing(Level.class);
        }

        public /* synthetic */ Level() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Level)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class LocalePatternMatcher
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String lang;
        private String script;
        private String region;
        private Level level;
        static Pattern pattern;

        private void $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$__constructor__(String toMatch) {
            Matcher matcher = pattern.matcher(toMatch);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Bad pattern: " + toMatch);
            }
            this.lang = matcher.group(1);
            this.script = matcher.group(2);
            this.region = matcher.group(3);
            Level level = this.region != null ? Level.region : (this.level = this.script != null ? Level.script : Level.language);
            if (this.lang.equals("*")) {
                this.lang = null;
            }
            if (this.script != null && this.script.equals("*")) {
                this.script = null;
            }
            if (this.region != null && this.region.equals("*")) {
                this.region = null;
            }
        }

        private final boolean $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$matches(ULocale ulocale) {
            if (this.lang != null && !this.lang.equals(ulocale.getLanguage())) {
                return false;
            }
            if (this.script != null && !this.script.equals(ulocale.getScript())) {
                return false;
            }
            return this.region == null || this.region.equals(ulocale.getCountry());
        }

        private final Level $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$getLevel() {
            return this.level;
        }

        private final String $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$getLanguage() {
            return this.lang == null ? "*" : this.lang;
        }

        private final String $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$getScript() {
            return this.script == null ? "*" : this.script;
        }

        private final String $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$getRegion() {
            return this.region == null ? "*" : this.region;
        }

        private final String $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$toString() {
            String result = this.getLanguage();
            if (this.level != Level.language) {
                result = result + "-" + this.getScript();
                if (this.level != Level.script) {
                    result = result + "-" + this.getRegion();
                }
            }
            return result;
        }

        private final boolean $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof LocalePatternMatcher)) {
                return false;
            }
            LocalePatternMatcher other = (LocalePatternMatcher)obj;
            return Utility.objectEquals((Object)this.level, (Object)other.level) && Utility.objectEquals(this.lang, other.lang) && Utility.objectEquals(this.script, other.script) && Utility.objectEquals(this.region, other.region);
        }

        private final int $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$hashCode() {
            return this.level.ordinal() ^ (this.lang == null ? 0 : this.lang.hashCode()) ^ (this.script == null ? 0 : this.script.hashCode()) ^ (this.region == null ? 0 : this.region.hashCode());
        }

        static void __staticInitializer__() {
            pattern = Pattern.compile("([a-z]{1,8}|\\*)(?:[_-]([A-Z][a-z]{3}|\\*))?(?:[_-]([A-Z]{2}|[0-9]{3}|\\*))?");
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$__constructor__(string2);
        }

        public LocalePatternMatcher(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$__constructor__(java.lang.String ), 0, this, string2);
        }

        boolean matches(ULocale uLocale) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$matches(android.icu.util.ULocale ), 0, this, uLocale);
        }

        public Level getLevel() {
            return InvokeDynamicSupport.bootstrap("getLevel", $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$getLevel(), 0, this);
        }

        public String getLanguage() {
            return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$getLanguage(), 0, this);
        }

        public String getScript() {
            return InvokeDynamicSupport.bootstrap("getScript", $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$getScript(), 0, this);
        }

        public String getRegion() {
            return InvokeDynamicSupport.bootstrap("getRegion", $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$getRegion(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$toString(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_LocaleMatcher_LocalePatternMatcher$hashCode(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(LocalePatternMatcher.class);
        }

        public /* synthetic */ LocalePatternMatcher() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalePatternMatcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    private static class OutputDouble
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        double value;

        private void $$robo$$android_icu_util_LocaleMatcher_OutputDouble$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_icu_util_LocaleMatcher_OutputDouble$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_LocaleMatcher_OutputDouble$__constructor__();
        }

        private OutputDouble() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleMatcher_OutputDouble$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_util_LocaleMatcher_OutputDouble$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OutputDouble)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

