/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.CacheBase;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.ICUResourceTableAccess;
import android.icu.impl.LocaleIDParser;
import android.icu.impl.LocaleIDs;
import android.icu.impl.LocaleUtility;
import android.icu.impl.SoftCache;
import android.icu.impl.locale.AsciiUtil;
import android.icu.impl.locale.BaseLocale;
import android.icu.impl.locale.Extension;
import android.icu.impl.locale.InternalLocaleBuilder;
import android.icu.impl.locale.KeyTypeData;
import android.icu.impl.locale.LanguageTag;
import android.icu.impl.locale.LocaleExtensions;
import android.icu.impl.locale.LocaleSyntaxException;
import android.icu.impl.locale.ParseStatus;
import android.icu.impl.locale.UnicodeLocaleExtension;
import android.icu.lang.UScript;
import android.icu.text.LocaleDisplayNames;
import android.icu.util.IllformedLocaleException;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ULocale
implements Serializable,
Comparable<ULocale> {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 3715177670352309217L;
    private static CacheBase<String, String, Void> nameCache;
    public static ULocale ENGLISH;
    public static ULocale FRENCH;
    public static ULocale GERMAN;
    public static ULocale ITALIAN;
    public static ULocale JAPANESE;
    public static ULocale KOREAN;
    public static ULocale CHINESE;
    public static ULocale SIMPLIFIED_CHINESE;
    public static ULocale TRADITIONAL_CHINESE;
    public static ULocale FRANCE;
    public static ULocale GERMANY;
    public static ULocale ITALY;
    public static ULocale JAPAN;
    public static ULocale KOREA;
    public static ULocale CHINA;
    public static ULocale PRC;
    public static ULocale TAIWAN;
    public static ULocale UK;
    public static ULocale US;
    public static ULocale CANADA;
    public static ULocale CANADA_FRENCH;
    private static String EMPTY_STRING = "";
    private static char UNDERSCORE = '_';
    private static Locale EMPTY_LOCALE;
    private static String LOCALE_ATTRIBUTE_KEY = "attribute";
    public static ULocale ROOT;
    private static SoftCache<Locale, ULocale, Void> CACHE;
    private volatile transient Locale locale;
    private String localeID;
    private volatile transient BaseLocale baseLocale;
    private volatile transient LocaleExtensions extensions;
    private static String[][] CANONICALIZE_MAP;
    private static String[][] variantsToKeywords;
    private static Locale defaultLocale;
    private static ULocale defaultULocale;
    private static Locale[] defaultCategoryLocales;
    private static ULocale[] defaultCategoryULocales;
    private static String LANG_DIR_STRING = "root-en-es-pt-zh-ja-ko-de-fr-it-ar+he+fa+ru-nl-pl-th-tr-";
    public static Type ACTUAL_LOCALE;
    public static Type VALID_LOCALE;
    private static String UNDEFINED_LANGUAGE = "und";
    private static String UNDEFINED_SCRIPT = "Zzzz";
    private static String UNDEFINED_REGION = "ZZ";
    public static char PRIVATE_USE_EXTENSION = 'x';
    public static char UNICODE_LOCALE_EXTENSION = 'u';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static final void $$robo$$android_icu_util_ULocale$initCANONICALIZE_MAP() {
        Class<ULocale> clazz;
        if (CANONICALIZE_MAP == null) {
            String[][] tempCANONICALIZE_MAP = new String[][]{{"C", "en_US_POSIX", null, null}, {"art_LOJBAN", "jbo", null, null}, {"az_AZ_CYRL", "az_Cyrl_AZ", null, null}, {"az_AZ_LATN", "az_Latn_AZ", null, null}, {"ca_ES_PREEURO", "ca_ES", "currency", "ESP"}, {"cel_GAULISH", "cel__GAULISH", null, null}, {"de_1901", "de__1901", null, null}, {"de_1906", "de__1906", null, null}, {"de__PHONEBOOK", "de", "collation", "phonebook"}, {"de_AT_PREEURO", "de_AT", "currency", "ATS"}, {"de_DE_PREEURO", "de_DE", "currency", "DEM"}, {"de_LU_PREEURO", "de_LU", "currency", "EUR"}, {"el_GR_PREEURO", "el_GR", "currency", "GRD"}, {"en_BOONT", "en__BOONT", null, null}, {"en_SCOUSE", "en__SCOUSE", null, null}, {"en_BE_PREEURO", "en_BE", "currency", "BEF"}, {"en_IE_PREEURO", "en_IE", "currency", "IEP"}, {"es__TRADITIONAL", "es", "collation", "traditional"}, {"es_ES_PREEURO", "es_ES", "currency", "ESP"}, {"eu_ES_PREEURO", "eu_ES", "currency", "ESP"}, {"fi_FI_PREEURO", "fi_FI", "currency", "FIM"}, {"fr_BE_PREEURO", "fr_BE", "currency", "BEF"}, {"fr_FR_PREEURO", "fr_FR", "currency", "FRF"}, {"fr_LU_PREEURO", "fr_LU", "currency", "LUF"}, {"ga_IE_PREEURO", "ga_IE", "currency", "IEP"}, {"gl_ES_PREEURO", "gl_ES", "currency", "ESP"}, {"hi__DIRECT", "hi", "collation", "direct"}, {"it_IT_PREEURO", "it_IT", "currency", "ITL"}, {"ja_JP_TRADITIONAL", "ja_JP", "calendar", "japanese"}, {"nl_BE_PREEURO", "nl_BE", "currency", "BEF"}, {"nl_NL_PREEURO", "nl_NL", "currency", "NLG"}, {"pt_PT_PREEURO", "pt_PT", "currency", "PTE"}, {"sl_ROZAJ", "sl__ROZAJ", null, null}, {"sr_SP_CYRL", "sr_Cyrl_RS", null, null}, {"sr_SP_LATN", "sr_Latn_RS", null, null}, {"sr_YU_CYRILLIC", "sr_Cyrl_RS", null, null}, {"th_TH_TRADITIONAL", "th_TH", "calendar", "buddhist"}, {"uz_UZ_CYRILLIC", "uz_Cyrl_UZ", null, null}, {"uz_UZ_CYRL", "uz_Cyrl_UZ", null, null}, {"uz_UZ_LATN", "uz_Latn_UZ", null, null}, {"zh_CHS", "zh_Hans", null, null}, {"zh_CHT", "zh_Hant", null, null}, {"zh_GAN", "zh__GAN", null, null}, {"zh_GUOYU", "zh", null, null}, {"zh_HAKKA", "zh__HAKKA", null, null}, {"zh_MIN", "zh__MIN", null, null}, {"zh_MIN_NAN", "zh__MINNAN", null, null}, {"zh_WUU", "zh__WUU", null, null}, {"zh_XIANG", "zh__XIANG", null, null}, {"zh_YUE", "zh__YUE", null, null}};
            clazz = ULocale.class;
            // MONITORENTER : android.icu.util.ULocale.class
            if (CANONICALIZE_MAP == null) {
                CANONICALIZE_MAP = tempCANONICALIZE_MAP;
            }
            // MONITOREXIT : clazz
        }
        if (variantsToKeywords != null) return;
        String[][] tempVariantsToKeywords = new String[][]{{"EURO", "currency", "EUR"}, {"PINYIN", "collation", "pinyin"}, {"STROKE", "collation", "stroke"}};
        clazz = ULocale.class;
        // MONITORENTER : android.icu.util.ULocale.class
        if (variantsToKeywords == null) {
            variantsToKeywords = tempVariantsToKeywords;
        }
        // MONITOREXIT : clazz
    }

    private void $$robo$$android_icu_util_ULocale$__constructor__(String localeID, Locale locale) {
        this.localeID = localeID;
        this.locale = locale;
    }

    private void $$robo$$android_icu_util_ULocale$__constructor__(Locale loc) {
        this.localeID = ULocale.getName(ULocale.forLocale(loc).toString());
        this.locale = loc;
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$forLocale(Locale loc) {
        if (loc == null) {
            return null;
        }
        return CACHE.getInstance(loc, null);
    }

    private void $$robo$$android_icu_util_ULocale$__constructor__(String localeID) {
        this.localeID = ULocale.getName(localeID);
    }

    private void $$robo$$android_icu_util_ULocale$__constructor__(String a, String b) {
    }

    private void $$robo$$android_icu_util_ULocale$__constructor__(String a, String b, String c) {
        this.localeID = ULocale.getName(ULocale.lscvToID(a, b, c, ""));
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$createCanonical(String nonCanonicalID) {
        return new ULocale(ULocale.canonicalize(nonCanonicalID), (Locale)null);
    }

    private static final String $$robo$$android_icu_util_ULocale$lscvToID(String lang, String script, String country, String variant) {
        StringBuilder buf = new StringBuilder();
        if (lang != null && lang.length() > 0) {
            buf.append(lang);
        }
        if (script != null && script.length() > 0) {
            buf.append('_');
            buf.append(script);
        }
        if (country != null && country.length() > 0) {
            buf.append('_');
            buf.append(country);
        }
        if (variant != null && variant.length() > 0) {
            if (country == null || country.length() == 0) {
                buf.append('_');
            }
            buf.append('_');
            buf.append(variant);
        }
        return buf.toString();
    }

    private final Locale $$robo$$android_icu_util_ULocale$toLocale() {
        if (this.locale == null) {
            this.locale = JDKLocaleHelper.toLocale(this);
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ULocale $$robo$$android_icu_util_ULocale$getDefault() {
        Class<ULocale> clazz = ULocale.class;
        synchronized (ULocale.class) {
            if (defaultULocale == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ROOT;
            }
            Locale currentDefault = Locale.getDefault();
            if (!defaultLocale.equals(currentDefault)) {
                defaultLocale = currentDefault;
                defaultULocale = ULocale.forLocale(currentDefault);
                if (!JDKLocaleHelper.hasLocaleCategories()) {
                    for (Category cat : Category.values()) {
                        int idx = cat.ordinal();
                        ULocale.defaultCategoryLocales[idx] = currentDefault;
                        ULocale.defaultCategoryULocales[idx] = ULocale.forLocale(currentDefault);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultULocale;
        }
    }

    private static final synchronized void $$robo$$android_icu_util_ULocale$setDefault(ULocale newLocale) {
        defaultLocale = newLocale.toLocale();
        Locale.setDefault(defaultLocale);
        defaultULocale = newLocale;
        for (Category cat : Category.values()) {
            ULocale.setDefault(cat, newLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ULocale $$robo$$android_icu_util_ULocale$getDefault(Category category) {
        Class<ULocale> clazz = ULocale.class;
        synchronized (ULocale.class) {
            int idx = category.ordinal();
            if (defaultCategoryULocales[idx] == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ROOT;
            }
            if (JDKLocaleHelper.hasLocaleCategories()) {
                Locale currentCategoryDefault = JDKLocaleHelper.getDefault(category);
                if (!defaultCategoryLocales[idx].equals(currentCategoryDefault)) {
                    ULocale.defaultCategoryLocales[idx] = currentCategoryDefault;
                    ULocale.defaultCategoryULocales[idx] = ULocale.forLocale(currentCategoryDefault);
                }
            } else {
                Locale currentDefault = Locale.getDefault();
                if (!defaultLocale.equals(currentDefault)) {
                    defaultLocale = currentDefault;
                    defaultULocale = ULocale.forLocale(currentDefault);
                    for (Category cat : Category.values()) {
                        int tmpIdx = cat.ordinal();
                        ULocale.defaultCategoryLocales[tmpIdx] = currentDefault;
                        ULocale.defaultCategoryULocales[tmpIdx] = ULocale.forLocale(currentDefault);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultCategoryULocales[idx];
        }
    }

    private static final synchronized void $$robo$$android_icu_util_ULocale$setDefault(Category category, ULocale newLocale) {
        Locale newJavaDefault = newLocale.toLocale();
        int idx = category.ordinal();
        ULocale.defaultCategoryULocales[idx] = newLocale;
        ULocale.defaultCategoryLocales[idx] = newJavaDefault;
        JDKLocaleHelper.setDefault(category, newJavaDefault);
    }

    private final Object $$robo$$android_icu_util_ULocale$clone() {
        return this;
    }

    private final int $$robo$$android_icu_util_ULocale$hashCode() {
        return this.localeID.hashCode();
    }

    private final boolean $$robo$$android_icu_util_ULocale$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ULocale) {
            return this.localeID.equals(((ULocale)obj).localeID);
        }
        return false;
    }

    private final int $$robo$$android_icu_util_ULocale$compareTo(ULocale other) {
        if (this == other) {
            return 0;
        }
        int cmp = 0;
        cmp = this.getLanguage().compareTo(other.getLanguage());
        if (cmp == 0 && (cmp = this.getScript().compareTo(other.getScript())) == 0 && (cmp = this.getCountry().compareTo(other.getCountry())) == 0 && (cmp = this.getVariant().compareTo(other.getVariant())) == 0) {
            Iterator<String> thisKwdItr = this.getKeywords();
            Iterator<String> otherKwdItr = other.getKeywords();
            if (thisKwdItr == null) {
                cmp = otherKwdItr == null ? 0 : -1;
            } else if (otherKwdItr == null) {
                cmp = 1;
            } else {
                while (cmp == 0 && thisKwdItr.hasNext()) {
                    String otherKey;
                    if (!otherKwdItr.hasNext()) {
                        cmp = 1;
                        break;
                    }
                    String thisKey = thisKwdItr.next();
                    cmp = thisKey.compareTo(otherKey = otherKwdItr.next());
                    if (cmp != 0) continue;
                    String thisVal = this.getKeywordValue(thisKey);
                    String otherVal = other.getKeywordValue(otherKey);
                    if (thisVal == null) {
                        cmp = otherVal == null ? 0 : -1;
                        continue;
                    }
                    if (otherVal == null) {
                        cmp = 1;
                        continue;
                    }
                    cmp = thisVal.compareTo(otherVal);
                }
                if (cmp == 0 && otherKwdItr.hasNext()) {
                    cmp = -1;
                }
            }
        }
        return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
    }

    private static final ULocale[] $$robo$$android_icu_util_ULocale$getAvailableLocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    private static final String[] $$robo$$android_icu_util_ULocale$getISOCountries() {
        return LocaleIDs.getISOCountries();
    }

    private static final String[] $$robo$$android_icu_util_ULocale$getISOLanguages() {
        return LocaleIDs.getISOLanguages();
    }

    private final String $$robo$$android_icu_util_ULocale$getLanguage() {
        return this.base().getLanguage();
    }

    private static final String $$robo$$android_icu_util_ULocale$getLanguage(String localeID) {
        return new LocaleIDParser(localeID).getLanguage();
    }

    private final String $$robo$$android_icu_util_ULocale$getScript() {
        return this.base().getScript();
    }

    private static final String $$robo$$android_icu_util_ULocale$getScript(String localeID) {
        return new LocaleIDParser(localeID).getScript();
    }

    private final String $$robo$$android_icu_util_ULocale$getCountry() {
        return this.base().getRegion();
    }

    private static final String $$robo$$android_icu_util_ULocale$getCountry(String localeID) {
        return new LocaleIDParser(localeID).getCountry();
    }

    @Deprecated
    private static final String $$robo$$android_icu_util_ULocale$getRegionForSupplementalData(ULocale locale, boolean inferRegion) {
        String regionUpper;
        String region = locale.getKeywordValue("rg");
        if (region != null && region.length() == 6 && (regionUpper = AsciiUtil.toUpperString(region)).endsWith("ZZZZ")) {
            return regionUpper.substring(0, 2);
        }
        region = locale.getCountry();
        if (region.length() == 0 && inferRegion) {
            ULocale maximized = ULocale.addLikelySubtags(locale);
            region = maximized.getCountry();
        }
        return region;
    }

    private final String $$robo$$android_icu_util_ULocale$getVariant() {
        return this.base().getVariant();
    }

    private static final String $$robo$$android_icu_util_ULocale$getVariant(String localeID) {
        return new LocaleIDParser(localeID).getVariant();
    }

    private static final String $$robo$$android_icu_util_ULocale$getFallback(String localeID) {
        return ULocale.getFallbackString(ULocale.getName(localeID));
    }

    private final ULocale $$robo$$android_icu_util_ULocale$getFallback() {
        if (this.localeID.length() == 0 || this.localeID.charAt(0) == '@') {
            return null;
        }
        return new ULocale(ULocale.getFallbackString(this.localeID), (Locale)null);
    }

    private static final String $$robo$$android_icu_util_ULocale$getFallbackString(String fallback) {
        int last;
        int extStart = fallback.indexOf(64);
        if (extStart == -1) {
            extStart = fallback.length();
        }
        if ((last = fallback.lastIndexOf(95, extStart)) == -1) {
            last = 0;
        } else {
            while (last > 0 && fallback.charAt(last - 1) == '_') {
                --last;
            }
        }
        return fallback.substring(0, last) + fallback.substring(extStart);
    }

    private final String $$robo$$android_icu_util_ULocale$getBaseName() {
        return ULocale.getBaseName(this.localeID);
    }

    private static final String $$robo$$android_icu_util_ULocale$getBaseName(String localeID) {
        if (localeID.indexOf(64) == -1) {
            return localeID;
        }
        return new LocaleIDParser(localeID).getBaseName();
    }

    private final String $$robo$$android_icu_util_ULocale$getName() {
        return this.localeID;
    }

    private static final int $$robo$$android_icu_util_ULocale$getShortestSubtagLength(String localeID) {
        int localeIDLength;
        int length = localeIDLength = localeID.length();
        boolean reset = true;
        int tmpLength = 0;
        for (int i = 0; i < localeIDLength; ++i) {
            if (localeID.charAt(i) != '_' && localeID.charAt(i) != '-') {
                if (reset) {
                    reset = false;
                    tmpLength = 0;
                }
                ++tmpLength;
                continue;
            }
            if (tmpLength != 0 && tmpLength < length) {
                length = tmpLength;
            }
            reset = true;
        }
        return length;
    }

    private static final String $$robo$$android_icu_util_ULocale$getName(String localeID) {
        String tmpLocaleID;
        if (localeID != null && !localeID.contains("@") && ULocale.getShortestSubtagLength(localeID) == 1) {
            tmpLocaleID = ULocale.forLanguageTag(localeID).getName();
            if (tmpLocaleID.length() == 0) {
                tmpLocaleID = localeID;
            }
        } else {
            tmpLocaleID = localeID;
        }
        return nameCache.getInstance(tmpLocaleID, null);
    }

    private final String $$robo$$android_icu_util_ULocale$toString() {
        return this.localeID;
    }

    private final Iterator<String> $$robo$$android_icu_util_ULocale$getKeywords() {
        return ULocale.getKeywords(this.localeID);
    }

    private static final Iterator<String> $$robo$$android_icu_util_ULocale$getKeywords(String localeID) {
        return new LocaleIDParser(localeID).getKeywords();
    }

    private final String $$robo$$android_icu_util_ULocale$getKeywordValue(String keywordName) {
        return ULocale.getKeywordValue(this.localeID, keywordName);
    }

    private static final String $$robo$$android_icu_util_ULocale$getKeywordValue(String localeID, String keywordName) {
        return new LocaleIDParser(localeID).getKeywordValue(keywordName);
    }

    private static final String $$robo$$android_icu_util_ULocale$canonicalize(String localeID) {
        String[] vals;
        int i;
        LocaleIDParser parser = new LocaleIDParser(localeID, true);
        String baseName = parser.getBaseName();
        boolean foundVariant = false;
        if (localeID.equals("")) {
            return "";
        }
        ULocale.initCANONICALIZE_MAP();
        for (i = 0; i < variantsToKeywords.length; ++i) {
            vals = variantsToKeywords[i];
            int idx = baseName.lastIndexOf("_" + vals[0]);
            if (idx <= -1) continue;
            foundVariant = true;
            if ((baseName = baseName.substring(0, idx)).endsWith("_")) {
                baseName = baseName.substring(0, --idx);
            }
            parser.setBaseName(baseName);
            parser.defaultKeywordValue(vals[1], vals[2]);
            break;
        }
        for (i = 0; i < CANONICALIZE_MAP.length; ++i) {
            if (!CANONICALIZE_MAP[i][0].equals(baseName)) continue;
            foundVariant = true;
            vals = CANONICALIZE_MAP[i];
            parser.setBaseName(vals[1]);
            if (vals[2] == null) break;
            parser.defaultKeywordValue(vals[2], vals[3]);
            break;
        }
        if (!foundVariant && parser.getLanguage().equals("nb") && parser.getVariant().equals("NY")) {
            parser.setBaseName(ULocale.lscvToID("nn", parser.getScript(), parser.getCountry(), null));
        }
        return parser.getName();
    }

    private final ULocale $$robo$$android_icu_util_ULocale$setKeywordValue(String keyword, String value) {
        return new ULocale(ULocale.setKeywordValue(this.localeID, keyword, value), (Locale)null);
    }

    private static final String $$robo$$android_icu_util_ULocale$setKeywordValue(String localeID, String keyword, String value) {
        LocaleIDParser parser = new LocaleIDParser(localeID);
        parser.setKeywordValue(keyword, value);
        return parser.getName();
    }

    private final String $$robo$$android_icu_util_ULocale$getISO3Language() {
        return ULocale.getISO3Language(this.localeID);
    }

    private static final String $$robo$$android_icu_util_ULocale$getISO3Language(String localeID) {
        return LocaleIDs.getISO3Language(ULocale.getLanguage(localeID));
    }

    private final String $$robo$$android_icu_util_ULocale$getISO3Country() {
        return ULocale.getISO3Country(this.localeID);
    }

    private static final String $$robo$$android_icu_util_ULocale$getISO3Country(String localeID) {
        return LocaleIDs.getISO3Country(ULocale.getCountry(localeID));
    }

    private final boolean $$robo$$android_icu_util_ULocale$isRightToLeft() {
        String script = this.getScript();
        if (script.length() == 0) {
            ULocale likely;
            String lang = this.getLanguage();
            if (lang.length() == 0) {
                return false;
            }
            int langIndex = "root-en-es-pt-zh-ja-ko-de-fr-it-ar+he+fa+ru-nl-pl-th-tr-".indexOf(lang);
            if (langIndex >= 0) {
                switch ("root-en-es-pt-zh-ja-ko-de-fr-it-ar+he+fa+ru-nl-pl-th-tr-".charAt(langIndex + lang.length())) {
                    case '-': {
                        return false;
                    }
                    case '+': {
                        return true;
                    }
                }
            }
            if ((script = (likely = ULocale.addLikelySubtags(this)).getScript()).length() == 0) {
                return false;
            }
        }
        int scriptCode = UScript.getCodeFromName(script);
        return UScript.isRightToLeft(scriptCode);
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayLanguage() {
        return ULocale.getDisplayLanguageInternal(this, ULocale.getDefault(Category.DISPLAY), false);
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayLanguage(ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(this, displayLocale, false);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayLanguage(String localeID, String displayLocaleID) {
        return ULocale.getDisplayLanguageInternal(new ULocale(localeID), new ULocale(displayLocaleID), false);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayLanguage(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(new ULocale(localeID), displayLocale, false);
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayLanguageWithDialect() {
        return ULocale.getDisplayLanguageInternal(this, ULocale.getDefault(Category.DISPLAY), true);
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayLanguageWithDialect(ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(this, displayLocale, true);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayLanguageWithDialect(String localeID, String displayLocaleID) {
        return ULocale.getDisplayLanguageInternal(new ULocale(localeID), new ULocale(displayLocaleID), true);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayLanguageWithDialect(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(new ULocale(localeID), displayLocale, true);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayLanguageInternal(ULocale locale, ULocale displayLocale, boolean useDialect) {
        String lang = useDialect ? locale.getBaseName() : locale.getLanguage();
        return LocaleDisplayNames.getInstance(displayLocale).languageDisplayName(lang);
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayScript() {
        return ULocale.getDisplayScriptInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    @Deprecated
    private final String $$robo$$android_icu_util_ULocale$getDisplayScriptInContext() {
        return ULocale.getDisplayScriptInContextInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayScript(ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(this, displayLocale);
    }

    @Deprecated
    private final String $$robo$$android_icu_util_ULocale$getDisplayScriptInContext(ULocale displayLocale) {
        return ULocale.getDisplayScriptInContextInternal(this, displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayScript(String localeID, String displayLocaleID) {
        return ULocale.getDisplayScriptInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    @Deprecated
    private static final String $$robo$$android_icu_util_ULocale$getDisplayScriptInContext(String localeID, String displayLocaleID) {
        return ULocale.getDisplayScriptInContextInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayScript(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(new ULocale(localeID), displayLocale);
    }

    @Deprecated
    private static final String $$robo$$android_icu_util_ULocale$getDisplayScriptInContext(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayScriptInContextInternal(new ULocale(localeID), displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayScriptInternal(ULocale locale, ULocale displayLocale) {
        return LocaleDisplayNames.getInstance(displayLocale).scriptDisplayName(locale.getScript());
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayScriptInContextInternal(ULocale locale, ULocale displayLocale) {
        return LocaleDisplayNames.getInstance(displayLocale).scriptDisplayNameInContext(locale.getScript());
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayCountry() {
        return ULocale.getDisplayCountryInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayCountry(ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(this, displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayCountry(String localeID, String displayLocaleID) {
        return ULocale.getDisplayCountryInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayCountry(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(new ULocale(localeID), displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayCountryInternal(ULocale locale, ULocale displayLocale) {
        return LocaleDisplayNames.getInstance(displayLocale).regionDisplayName(locale.getCountry());
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayVariant() {
        return ULocale.getDisplayVariantInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayVariant(ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(this, displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayVariant(String localeID, String displayLocaleID) {
        return ULocale.getDisplayVariantInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayVariant(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(new ULocale(localeID), displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayVariantInternal(ULocale locale, ULocale displayLocale) {
        return LocaleDisplayNames.getInstance(displayLocale).variantDisplayName(locale.getVariant());
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayKeyword(String keyword) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getDefault(Category.DISPLAY));
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayKeyword(String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordInternal(keyword, new ULocale(displayLocaleID));
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayKeyword(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordInternal(keyword, displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayKeywordInternal(String keyword, ULocale displayLocale) {
        return LocaleDisplayNames.getInstance(displayLocale).keyDisplayName(keyword);
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayKeywordValue(String keyword) {
        return ULocale.getDisplayKeywordValueInternal(this, keyword, ULocale.getDefault(Category.DISPLAY));
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayKeywordValue(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(this, keyword, displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayKeywordValue(String localeID, String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordValueInternal(new ULocale(localeID), keyword, new ULocale(displayLocaleID));
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayKeywordValue(String localeID, String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(new ULocale(localeID), keyword, displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayKeywordValueInternal(ULocale locale, String keyword, ULocale displayLocale) {
        keyword = AsciiUtil.toLowerString(keyword.trim());
        String value = locale.getKeywordValue(keyword);
        return LocaleDisplayNames.getInstance(displayLocale).keyValueDisplayName(keyword, value);
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayName() {
        return ULocale.getDisplayNameInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayName(ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(this, displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayName(String localeID, String displayLocaleID) {
        return ULocale.getDisplayNameInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayName(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(new ULocale(localeID), displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayNameInternal(ULocale locale, ULocale displayLocale) {
        return LocaleDisplayNames.getInstance(displayLocale).localeDisplayName(locale);
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayNameWithDialect() {
        return ULocale.getDisplayNameWithDialectInternal(this, ULocale.getDefault(Category.DISPLAY));
    }

    private final String $$robo$$android_icu_util_ULocale$getDisplayNameWithDialect(ULocale displayLocale) {
        return ULocale.getDisplayNameWithDialectInternal(this, displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayNameWithDialect(String localeID, String displayLocaleID) {
        return ULocale.getDisplayNameWithDialectInternal(new ULocale(localeID), new ULocale(displayLocaleID));
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayNameWithDialect(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayNameWithDialectInternal(new ULocale(localeID), displayLocale);
    }

    private static final String $$robo$$android_icu_util_ULocale$getDisplayNameWithDialectInternal(ULocale locale, ULocale displayLocale) {
        return LocaleDisplayNames.getInstance(displayLocale, LocaleDisplayNames.DialectHandling.DIALECT_NAMES).localeDisplayName(locale);
    }

    private final String $$robo$$android_icu_util_ULocale$getCharacterOrientation() {
        return ICUResourceTableAccess.getTableString("android/icu/impl/data/icudt58b", this, "layout", "characters", "characters");
    }

    private final String $$robo$$android_icu_util_ULocale$getLineOrientation() {
        return ICUResourceTableAccess.getTableString("android/icu/impl/data/icudt58b", this, "layout", "lines", "lines");
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$acceptLanguage(String acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        if (acceptLanguageList == null) {
            throw new NullPointerException();
        }
        ULocale[] acceptList = null;
        try {
            acceptList = ULocale.parseAcceptLanguage(acceptLanguageList, true);
        }
        catch (ParseException pe) {
            acceptList = null;
        }
        if (acceptList == null) {
            return null;
        }
        return ULocale.acceptLanguage(acceptList, availableLocales, fallback);
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$acceptLanguage(ULocale[] acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        if (fallback != null) {
            fallback[0] = true;
        }
        for (int i = 0; i < acceptLanguageList.length; ++i) {
            ULocale aLocale = acceptLanguageList[i];
            boolean[] setFallback = fallback;
            do {
                for (int j = 0; j < availableLocales.length; ++j) {
                    ULocale minAvail;
                    if (availableLocales[j].equals(aLocale)) {
                        if (setFallback != null) {
                            setFallback[0] = false;
                        }
                        return availableLocales[j];
                    }
                    if (aLocale.getScript().length() != 0 || availableLocales[j].getScript().length() <= 0 || !availableLocales[j].getLanguage().equals(aLocale.getLanguage()) || !availableLocales[j].getCountry().equals(aLocale.getCountry()) || !availableLocales[j].getVariant().equals(aLocale.getVariant()) || (minAvail = ULocale.minimizeSubtags(availableLocales[j])).getScript().length() != 0) continue;
                    if (setFallback != null) {
                        setFallback[0] = false;
                    }
                    return aLocale;
                }
                Locale loc = aLocale.toLocale();
                Locale parent = LocaleUtility.fallback(loc);
                aLocale = parent != null ? new ULocale(parent) : null;
                setFallback = null;
            } while (aLocale != null);
        }
        return null;
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$acceptLanguage(String acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$acceptLanguage(ULocale[] acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    private static final ULocale[] $$robo$$android_icu_util_ULocale$parseAcceptLanguage(String acceptLanguage, boolean isLenient) throws ParseException {
        int n;
        public class ULocaleAcceptLanguageQ
        implements Comparable<ULocaleAcceptLanguageQ> {
            public transient /* synthetic */ Object __robo_data__;
            private double q;
            private double serial;

            private void $$robo$$android_icu_util_ULocale_1ULocaleAcceptLanguageQ$__constructor__(double theq, int theserial) {
                this.q = theq;
                this.serial = theserial;
            }

            private final int $$robo$$android_icu_util_ULocale_1ULocaleAcceptLanguageQ$compareTo(ULocaleAcceptLanguageQ other) {
                if (this.q > other.q) {
                    return -1;
                }
                if (this.q < other.q) {
                    return 1;
                }
                if (this.serial < other.serial) {
                    return -1;
                }
                if (this.serial > other.serial) {
                    return 1;
                }
                return 0;
            }

            private void __constructor__(double d, int n) {
                this.$$robo$$android_icu_util_ULocale_1ULocaleAcceptLanguageQ$__constructor__(d, n);
            }

            public ULocaleAcceptLanguageQ(double d, int n) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale_1ULocaleAcceptLanguageQ$__constructor__(double int ), 0, this, d, n);
            }

            @Override
            public int compareTo(ULocaleAcceptLanguageQ uLocaleAcceptLanguageQ) {
                return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_util_ULocale_1ULocaleAcceptLanguageQ$compareTo(android.icu.util.ULocale$1ULocaleAcceptLanguageQ ), 0, this, uLocaleAcceptLanguageQ);
            }

            public /* synthetic */ ULocaleAcceptLanguageQ() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ULocaleAcceptLanguageQ)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
        TreeMap<ULocaleAcceptLanguageQ, ULocale> map = new TreeMap<ULocaleAcceptLanguageQ, ULocale>();
        StringBuilder languageRangeBuf = new StringBuilder();
        StringBuilder qvalBuf = new StringBuilder();
        int state = 0;
        acceptLanguage = acceptLanguage + ",";
        boolean subTag = false;
        boolean q1 = false;
        for (n = 0; n < acceptLanguage.length(); ++n) {
            boolean gotLanguageQ = false;
            char c = acceptLanguage.charAt(n);
            switch (state) {
                case 0: {
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        languageRangeBuf.append(c);
                        state = 1;
                        subTag = false;
                        break;
                    }
                    if (c == '*') {
                        languageRangeBuf.append(c);
                        state = 2;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 1: {
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        languageRangeBuf.append(c);
                        break;
                    }
                    if (c == '-') {
                        subTag = true;
                        languageRangeBuf.append(c);
                        break;
                    }
                    if (c == '_') {
                        if (isLenient) {
                            subTag = true;
                            languageRangeBuf.append(c);
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if ('0' <= c && c <= '9') {
                        if (subTag) {
                            languageRangeBuf.append(c);
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 3;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 3;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 4: {
                    if (c == 'q') {
                        state = 5;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 5: {
                    if (c == '=') {
                        state = 6;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 6: {
                    if (c == '0') {
                        q1 = false;
                        qvalBuf.append(c);
                        state = 7;
                        break;
                    }
                    if (c == '1') {
                        qvalBuf.append(c);
                        state = 7;
                        break;
                    }
                    if (c == '.') {
                        if (isLenient) {
                            qvalBuf.append(c);
                            state = 8;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 7: {
                    if (c == '.') {
                        qvalBuf.append(c);
                        state = 8;
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 10;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 8: {
                    if ('0' <= c && c <= '9') {
                        if (q1 && c != '0' && !isLenient) {
                            state = -1;
                            break;
                        }
                        qvalBuf.append(c);
                        state = 9;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 9: {
                    if ('0' <= c && c <= '9') {
                        if (q1 && c != '0') {
                            state = -1;
                            break;
                        }
                        qvalBuf.append(c);
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 10;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 10: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                }
            }
            if (state == -1) {
                throw new ParseException("Invalid Accept-Language", n);
            }
            if (!gotLanguageQ) continue;
            double q = 1.0;
            if (qvalBuf.length() != 0) {
                try {
                    q = Double.parseDouble(qvalBuf.toString());
                }
                catch (NumberFormatException nfe) {
                    q = 1.0;
                }
                if (q > 1.0) {
                    q = 1.0;
                }
            }
            if (languageRangeBuf.charAt(0) != '*') {
                int serial = map.size();
                ULocaleAcceptLanguageQ entry = new ULocaleAcceptLanguageQ(q, serial);
                map.put(entry, new ULocale(ULocale.canonicalize(languageRangeBuf.toString())));
            }
            languageRangeBuf.setLength(0);
            qvalBuf.setLength(0);
            state = 0;
        }
        if (state != 0) {
            throw new ParseException("Invalid AcceptlLanguage", n);
        }
        ULocale[] acceptList = map.values().toArray(new ULocale[map.size()]);
        return acceptList;
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$addLikelySubtags(ULocale loc) {
        String newLocaleID;
        String[] tags = new String[3];
        String trailing = null;
        int trailingIndex = ULocale.parseTagString(loc.localeID, tags);
        if (trailingIndex < loc.localeID.length()) {
            trailing = loc.localeID.substring(trailingIndex);
        }
        return (newLocaleID = ULocale.createLikelySubtagsString(tags[0], tags[1], tags[2], trailing)) == null ? loc : new ULocale(newLocaleID);
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$minimizeSubtags(ULocale loc) {
        return ULocale.minimizeSubtags(loc, Minimize.FAVOR_REGION);
    }

    @Deprecated
    private static final ULocale $$robo$$android_icu_util_ULocale$minimizeSubtags(ULocale loc, Minimize fieldToFavor) {
        String maximizedLocaleID;
        String[] tags = new String[3];
        int trailingIndex = ULocale.parseTagString(loc.localeID, tags);
        String originalLang = tags[0];
        String originalScript = tags[1];
        String originalRegion = tags[2];
        String originalTrailing = null;
        if (trailingIndex < loc.localeID.length()) {
            originalTrailing = loc.localeID.substring(trailingIndex);
        }
        if (ULocale.isEmptyString(maximizedLocaleID = ULocale.createLikelySubtagsString(originalLang, originalScript, originalRegion, null))) {
            return loc;
        }
        String tag = ULocale.createLikelySubtagsString(originalLang, null, null, null);
        if (tag.equals(maximizedLocaleID)) {
            String newLocaleID = ULocale.createTagString(originalLang, null, null, originalTrailing);
            return new ULocale(newLocaleID);
        }
        if (fieldToFavor == Minimize.FAVOR_REGION) {
            if (originalRegion.length() != 0 && (tag = ULocale.createLikelySubtagsString(originalLang, null, originalRegion, null)).equals(maximizedLocaleID)) {
                String newLocaleID = ULocale.createTagString(originalLang, null, originalRegion, originalTrailing);
                return new ULocale(newLocaleID);
            }
            if (originalScript.length() != 0 && (tag = ULocale.createLikelySubtagsString(originalLang, originalScript, null, null)).equals(maximizedLocaleID)) {
                String newLocaleID = ULocale.createTagString(originalLang, originalScript, null, originalTrailing);
                return new ULocale(newLocaleID);
            }
        } else {
            if (originalScript.length() != 0 && (tag = ULocale.createLikelySubtagsString(originalLang, originalScript, null, null)).equals(maximizedLocaleID)) {
                String newLocaleID = ULocale.createTagString(originalLang, originalScript, null, originalTrailing);
                return new ULocale(newLocaleID);
            }
            if (originalRegion.length() != 0 && (tag = ULocale.createLikelySubtagsString(originalLang, null, originalRegion, null)).equals(maximizedLocaleID)) {
                String newLocaleID = ULocale.createTagString(originalLang, null, originalRegion, originalTrailing);
                return new ULocale(newLocaleID);
            }
        }
        return loc;
    }

    private static final boolean $$robo$$android_icu_util_ULocale$isEmptyString(String string2) {
        return string2 == null || string2.length() == 0;
    }

    private static final void $$robo$$android_icu_util_ULocale$appendTag(String tag, StringBuilder buffer) {
        if (buffer.length() != 0) {
            buffer.append('_');
        }
        buffer.append(tag);
    }

    private static final String $$robo$$android_icu_util_ULocale$createTagString(String lang, String script, String region, String trailing, String alternateTags) {
        LocaleIDParser parser = null;
        boolean regionAppended = false;
        StringBuilder tag = new StringBuilder();
        if (!ULocale.isEmptyString(lang)) {
            ULocale.appendTag(lang, tag);
        } else if (ULocale.isEmptyString(alternateTags)) {
            ULocale.appendTag("und", tag);
        } else {
            parser = new LocaleIDParser(alternateTags);
            String alternateLang = parser.getLanguage();
            ULocale.appendTag(!ULocale.isEmptyString(alternateLang) ? alternateLang : UNDEFINED_LANGUAGE, tag);
        }
        if (!ULocale.isEmptyString(script)) {
            ULocale.appendTag(script, tag);
        } else if (!ULocale.isEmptyString(alternateTags)) {
            String alternateScript;
            if (parser == null) {
                parser = new LocaleIDParser(alternateTags);
            }
            if (!ULocale.isEmptyString(alternateScript = parser.getScript())) {
                ULocale.appendTag(alternateScript, tag);
            }
        }
        if (!ULocale.isEmptyString(region)) {
            ULocale.appendTag(region, tag);
            regionAppended = true;
        } else if (!ULocale.isEmptyString(alternateTags)) {
            String alternateRegion;
            if (parser == null) {
                parser = new LocaleIDParser(alternateTags);
            }
            if (!ULocale.isEmptyString(alternateRegion = parser.getCountry())) {
                ULocale.appendTag(alternateRegion, tag);
                regionAppended = true;
            }
        }
        if (trailing != null && trailing.length() > 1) {
            int separators = 0;
            if (trailing.charAt(0) == '_') {
                if (trailing.charAt(1) == '_') {
                    separators = 2;
                }
            } else {
                separators = 1;
            }
            if (regionAppended) {
                if (separators == 2) {
                    tag.append(trailing.substring(1));
                } else {
                    tag.append(trailing);
                }
            } else {
                if (separators == 1) {
                    tag.append('_');
                }
                tag.append(trailing);
            }
        }
        return tag.toString();
    }

    private static final String $$robo$$android_icu_util_ULocale$createTagString(String lang, String script, String region, String trailing) {
        return ULocale.createTagString(lang, script, region, trailing, null);
    }

    private static final int $$robo$$android_icu_util_ULocale$parseTagString(String localeID, String[] tags) {
        LocaleIDParser parser = new LocaleIDParser(localeID);
        String lang = parser.getLanguage();
        String script = parser.getScript();
        String region = parser.getCountry();
        tags[0] = ULocale.isEmptyString(lang) ? "und" : lang;
        tags[1] = script.equals("Zzzz") ? "" : script;
        tags[2] = region.equals("ZZ") ? "" : region;
        String variant = parser.getVariant();
        if (!ULocale.isEmptyString(variant)) {
            int index = localeID.indexOf(variant);
            return index > 0 ? index - 1 : index;
        }
        int index = localeID.indexOf(64);
        return index == -1 ? localeID.length() : index;
    }

    private static final String $$robo$$android_icu_util_ULocale$lookupLikelySubtags(String localeId) {
        UResourceBundle bundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "likelySubtags");
        try {
            return bundle.getString(localeId);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static final String $$robo$$android_icu_util_ULocale$createLikelySubtagsString(String lang, String script, String region, String variants) {
        String searchTag;
        String likelySubtags;
        if (!ULocale.isEmptyString(script) && !ULocale.isEmptyString(region) && (likelySubtags = ULocale.lookupLikelySubtags(searchTag = ULocale.createTagString(lang, script, region, null))) != null) {
            return ULocale.createTagString(null, null, null, variants, likelySubtags);
        }
        if (!ULocale.isEmptyString(script) && (likelySubtags = ULocale.lookupLikelySubtags(searchTag = ULocale.createTagString(lang, script, null, null))) != null) {
            return ULocale.createTagString(null, null, region, variants, likelySubtags);
        }
        if (!ULocale.isEmptyString(region) && (likelySubtags = ULocale.lookupLikelySubtags(searchTag = ULocale.createTagString(lang, null, region, null))) != null) {
            return ULocale.createTagString(null, script, null, variants, likelySubtags);
        }
        searchTag = ULocale.createTagString(lang, null, null, null);
        likelySubtags = ULocale.lookupLikelySubtags(searchTag);
        if (likelySubtags != null) {
            return ULocale.createTagString(null, script, region, variants, likelySubtags);
        }
        return null;
    }

    private final String $$robo$$android_icu_util_ULocale$getExtension(char key) {
        if (!LocaleExtensions.isValidKey(key)) {
            throw new IllegalArgumentException("Invalid extension key: " + key);
        }
        return this.extensions().getExtensionValue(Character.valueOf(key));
    }

    private final Set<Character> $$robo$$android_icu_util_ULocale$getExtensionKeys() {
        return this.extensions().getKeys();
    }

    private final Set<String> $$robo$$android_icu_util_ULocale$getUnicodeLocaleAttributes() {
        return this.extensions().getUnicodeLocaleAttributes();
    }

    private final String $$robo$$android_icu_util_ULocale$getUnicodeLocaleType(String key) {
        if (!LocaleExtensions.isValidUnicodeLocaleKey(key)) {
            throw new IllegalArgumentException("Invalid Unicode locale key: " + key);
        }
        return this.extensions().getUnicodeLocaleType(key);
    }

    private final Set<String> $$robo$$android_icu_util_ULocale$getUnicodeLocaleKeys() {
        return this.extensions().getUnicodeLocaleKeys();
    }

    private final String $$robo$$android_icu_util_ULocale$toLanguageTag() {
        BaseLocale base = this.base();
        LocaleExtensions exts = this.extensions();
        if (base.getVariant().equalsIgnoreCase("POSIX")) {
            base = BaseLocale.getInstance(base.getLanguage(), base.getScript(), base.getRegion(), "");
            if (exts.getUnicodeLocaleType("va") == null) {
                InternalLocaleBuilder ilocbld = new InternalLocaleBuilder();
                try {
                    ilocbld.setLocale(BaseLocale.ROOT, exts);
                    ilocbld.setUnicodeLocaleKeyword("va", "posix");
                    exts = ilocbld.getLocaleExtensions();
                }
                catch (LocaleSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        LanguageTag tag = LanguageTag.parseLocale(base, exts);
        StringBuilder buf = new StringBuilder();
        String subtag = tag.getLanguage();
        if (subtag.length() > 0) {
            buf.append(LanguageTag.canonicalizeLanguage(subtag));
        }
        if ((subtag = tag.getScript()).length() > 0) {
            buf.append("-");
            buf.append(LanguageTag.canonicalizeScript(subtag));
        }
        if ((subtag = tag.getRegion()).length() > 0) {
            buf.append("-");
            buf.append(LanguageTag.canonicalizeRegion(subtag));
        }
        List<String> subtags = tag.getVariants();
        for (String s : subtags) {
            buf.append("-");
            buf.append(LanguageTag.canonicalizeVariant(s));
        }
        subtags = tag.getExtensions();
        for (String s : subtags) {
            buf.append("-");
            buf.append(LanguageTag.canonicalizeExtension(s));
        }
        subtag = tag.getPrivateuse();
        if (subtag.length() > 0) {
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append("x").append("-");
            buf.append(LanguageTag.canonicalizePrivateuse(subtag));
        }
        return buf.toString();
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$forLanguageTag(String languageTag) {
        LanguageTag tag = LanguageTag.parse(languageTag, null);
        InternalLocaleBuilder bldr = new InternalLocaleBuilder();
        bldr.setLanguageTag(tag);
        return ULocale.getInstance(bldr.getBaseLocale(), bldr.getLocaleExtensions());
    }

    private static final String $$robo$$android_icu_util_ULocale$toUnicodeLocaleKey(String keyword) {
        String bcpKey = KeyTypeData.toBcpKey(keyword);
        if (bcpKey == null && UnicodeLocaleExtension.isKey(keyword)) {
            bcpKey = AsciiUtil.toLowerString(keyword);
        }
        return bcpKey;
    }

    private static final String $$robo$$android_icu_util_ULocale$toUnicodeLocaleType(String keyword, String value) {
        String bcpType = KeyTypeData.toBcpType(keyword, value, null, null);
        if (bcpType == null && UnicodeLocaleExtension.isType(value)) {
            bcpType = AsciiUtil.toLowerString(value);
        }
        return bcpType;
    }

    private static final String $$robo$$android_icu_util_ULocale$toLegacyKey(String keyword) {
        String legacyKey = KeyTypeData.toLegacyKey(keyword);
        if (legacyKey == null && keyword.matches("[0-9a-zA-Z]+")) {
            legacyKey = AsciiUtil.toLowerString(keyword);
        }
        return legacyKey;
    }

    private static final String $$robo$$android_icu_util_ULocale$toLegacyType(String keyword, String value) {
        String legacyType = KeyTypeData.toLegacyType(keyword, value, null, null);
        if (legacyType == null && value.matches("[0-9a-zA-Z]+([_/\\-][0-9a-zA-Z]+)*")) {
            legacyType = AsciiUtil.toLowerString(value);
        }
        return legacyType;
    }

    private static final ULocale $$robo$$android_icu_util_ULocale$getInstance(BaseLocale base, LocaleExtensions exts) {
        String id2 = ULocale.lscvToID(base.getLanguage(), base.getScript(), base.getRegion(), base.getVariant());
        Set<Character> extKeys = exts.getKeys();
        if (!extKeys.isEmpty()) {
            TreeMap<String, String> kwds = new TreeMap<String, String>();
            for (Character key : extKeys) {
                Extension ext = exts.getExtension(key);
                if (ext instanceof UnicodeLocaleExtension) {
                    UnicodeLocaleExtension uext = (UnicodeLocaleExtension)ext;
                    Set<String> ukeys = uext.getUnicodeLocaleKeys();
                    for (String bcpKey : ukeys) {
                        String bcpType = uext.getUnicodeLocaleType(bcpKey);
                        String lkey = ULocale.toLegacyKey(bcpKey);
                        String ltype = ULocale.toLegacyType(bcpKey, bcpType.length() == 0 ? "yes" : bcpType);
                        if (lkey.equals("va") && ltype.equals("posix") && base.getVariant().length() == 0) {
                            id2 = id2 + "_POSIX";
                            continue;
                        }
                        kwds.put(lkey, ltype);
                    }
                    Set<String> uattributes = uext.getUnicodeLocaleAttributes();
                    if (uattributes.size() <= 0) continue;
                    StringBuilder attrbuf = new StringBuilder();
                    for (String attr2 : uattributes) {
                        if (attrbuf.length() > 0) {
                            attrbuf.append('-');
                        }
                        attrbuf.append(attr2);
                    }
                    kwds.put("attribute", attrbuf.toString());
                    continue;
                }
                kwds.put(String.valueOf(key), ext.getValue());
            }
            if (!kwds.isEmpty()) {
                StringBuilder buf = new StringBuilder(id2);
                buf.append("@");
                Set kset = kwds.entrySet();
                boolean insertSep = false;
                for (Map.Entry kwd : kset) {
                    if (insertSep) {
                        buf.append(";");
                    } else {
                        insertSep = true;
                    }
                    buf.append((String)kwd.getKey());
                    buf.append("=");
                    buf.append((String)kwd.getValue());
                }
                id2 = buf.toString();
            }
        }
        return new ULocale(id2);
    }

    private final BaseLocale $$robo$$android_icu_util_ULocale$base() {
        if (this.baseLocale == null) {
            String variant = "";
            String region = "";
            String script = "";
            String language = "";
            if (!this.equals(ROOT)) {
                LocaleIDParser lp = new LocaleIDParser(this.localeID);
                language = lp.getLanguage();
                script = lp.getScript();
                region = lp.getCountry();
                variant = lp.getVariant();
            }
            this.baseLocale = BaseLocale.getInstance(language, script, region, variant);
        }
        return this.baseLocale;
    }

    private final LocaleExtensions $$robo$$android_icu_util_ULocale$extensions() {
        if (this.extensions == null) {
            Iterator<String> kwitr = this.getKeywords();
            if (kwitr == null) {
                this.extensions = LocaleExtensions.EMPTY_EXTENSIONS;
            } else {
                InternalLocaleBuilder intbld = new InternalLocaleBuilder();
                while (kwitr.hasNext()) {
                    String key = kwitr.next();
                    if (key.equals("attribute")) {
                        String[] uattributes;
                        for (String uattr : uattributes = this.getKeywordValue(key).split("[-_]")) {
                            try {
                                intbld.addUnicodeLocaleAttribute(uattr);
                            }
                            catch (LocaleSyntaxException localeSyntaxException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (key.length() >= 2) {
                        String bcpKey = ULocale.toUnicodeLocaleKey(key);
                        String bcpType = ULocale.toUnicodeLocaleType(key, this.getKeywordValue(key));
                        if (bcpKey == null || bcpType == null) continue;
                        try {
                            intbld.setUnicodeLocaleKeyword(bcpKey, bcpType);
                        }
                        catch (LocaleSyntaxException localeSyntaxException) {}
                        continue;
                    }
                    if (key.length() != 1 || key.charAt(0) == 'u') continue;
                    try {
                        intbld.setExtension(key.charAt(0), this.getKeywordValue(key).replace("_", "-"));
                    }
                    catch (LocaleSyntaxException localeSyntaxException) {
                    }
                }
                this.extensions = intbld.getLocaleExtensions();
            }
        }
        return this.extensions;
    }

    private /* synthetic */ void $$robo$$android_icu_util_ULocale$__constructor__(String x0, Locale x1, 1 x2) {
    }

    static void __staticInitializer__() {
        nameCache = new SoftCache<String, String, Void>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_util_ULocale_1$__constructor__() {
            }

            private final String $$robo$$android_icu_util_ULocale_1$createInstance(String tmpLocaleID, Void unused) {
                return new LocaleIDParser(tmpLocaleID).getName();
            }

            private void __constructor__() {
                this.$$robo$$android_icu_util_ULocale_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale_1$__constructor__(), 0, this);
            }

            @Override
            protected String createInstance(String string2, Void void_) {
                return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_util_ULocale_1$createInstance(java.lang.String java.lang.Void ), 0, this, string2, void_);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        ENGLISH = new ULocale("en", Locale.ENGLISH);
        FRENCH = new ULocale("fr", Locale.FRENCH);
        GERMAN = new ULocale("de", Locale.GERMAN);
        ITALIAN = new ULocale("it", Locale.ITALIAN);
        JAPANESE = new ULocale("ja", Locale.JAPANESE);
        KOREAN = new ULocale("ko", Locale.KOREAN);
        CHINESE = new ULocale("zh", Locale.CHINESE);
        SIMPLIFIED_CHINESE = new ULocale("zh_Hans");
        TRADITIONAL_CHINESE = new ULocale("zh_Hant");
        FRANCE = new ULocale("fr_FR", Locale.FRANCE);
        GERMANY = new ULocale("de_DE", Locale.GERMANY);
        ITALY = new ULocale("it_IT", Locale.ITALY);
        JAPAN = new ULocale("ja_JP", Locale.JAPAN);
        KOREA = new ULocale("ko_KR", Locale.KOREA);
        PRC = CHINA = new ULocale("zh_Hans_CN");
        TAIWAN = new ULocale("zh_Hant_TW");
        UK = new ULocale("en_GB", Locale.UK);
        US = new ULocale("en_US", Locale.US);
        CANADA = new ULocale("en_CA", Locale.CANADA);
        CANADA_FRENCH = new ULocale("fr_CA", Locale.CANADA_FRENCH);
        EMPTY_LOCALE = new Locale("", "");
        ROOT = new ULocale("", EMPTY_LOCALE);
        CACHE = new SoftCache<Locale, ULocale, Void>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_util_ULocale_2$__constructor__() {
            }

            private final ULocale $$robo$$android_icu_util_ULocale_2$createInstance(Locale key, Void unused) {
                return JDKLocaleHelper.toULocale(key);
            }

            private void __constructor__() {
                this.$$robo$$android_icu_util_ULocale_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale_2$__constructor__(), 0, this);
            }

            @Override
            protected ULocale createInstance(Locale locale, Void void_) {
                return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_util_ULocale_2$createInstance(java.util.Locale java.lang.Void ), 0, this, locale, void_);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        defaultLocale = Locale.getDefault();
        defaultCategoryLocales = new Locale[Category.values().length];
        defaultCategoryULocales = new ULocale[Category.values().length];
        defaultULocale = ULocale.forLocale(defaultLocale);
        if (JDKLocaleHelper.hasLocaleCategories()) {
            for (Category cat : Category.values()) {
                int idx = cat.ordinal();
                ULocale.defaultCategoryLocales[idx] = JDKLocaleHelper.getDefault(cat);
                ULocale.defaultCategoryULocales[idx] = ULocale.forLocale(defaultCategoryLocales[idx]);
            }
        } else {
            String userScript;
            if (JDKLocaleHelper.isOriginalDefaultLocale(defaultLocale) && (userScript = JDKLocaleHelper.getSystemProperty("user.script")) != null && LanguageTag.isScript(userScript)) {
                BaseLocale base = defaultULocale.base();
                BaseLocale newBase = BaseLocale.getInstance(base.getLanguage(), userScript, base.getRegion(), base.getVariant());
                defaultULocale = ULocale.getInstance(newBase, defaultULocale.extensions());
            }
            for (Category cat : Category.values()) {
                int idx = cat.ordinal();
                ULocale.defaultCategoryLocales[idx] = defaultLocale;
                ULocale.defaultCategoryULocales[idx] = defaultULocale;
            }
        }
        ACTUAL_LOCALE = new Type();
        VALID_LOCALE = new Type();
    }

    private static void initCANONICALIZE_MAP() {
        InvokeDynamicSupport.bootstrapStatic("initCANONICALIZE_MAP", $$robo$$android_icu_util_ULocale$initCANONICALIZE_MAP(), 0);
    }

    private void __constructor__(String string2, Locale locale) {
        this.$$robo$$android_icu_util_ULocale$__constructor__(string2, locale);
    }

    private ULocale(String string2, Locale locale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale$__constructor__(java.lang.String java.util.Locale ), 0, this, string2, locale);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_util_ULocale$__constructor__(locale);
    }

    private ULocale(Locale locale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale$__constructor__(java.util.Locale ), 0, this, locale);
    }

    public static ULocale forLocale(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("forLocale", $$robo$$android_icu_util_ULocale$forLocale(java.util.Locale ), 0, (Locale)locale);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_util_ULocale$__constructor__(string2);
    }

    public ULocale(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(String string2, String string3) {
        this.$$robo$$android_icu_util_ULocale$__constructor__(string2, string3);
    }

    public ULocale(String string2, String string3) {
        this(string2, string3, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void __constructor__(String string2, String string3, String string4) {
        this.$$robo$$android_icu_util_ULocale$__constructor__(string2, string3, string4);
    }

    public ULocale(String string2, String string3, String string4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale$__constructor__(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public static ULocale createCanonical(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createCanonical", $$robo$$android_icu_util_ULocale$createCanonical(java.lang.String ), 0, (String)string2);
    }

    private static String lscvToID(String string2, String string3, String string4, String string5) {
        return InvokeDynamicSupport.bootstrapStatic("lscvToID", $$robo$$android_icu_util_ULocale$lscvToID(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    public Locale toLocale() {
        return InvokeDynamicSupport.bootstrap("toLocale", $$robo$$android_icu_util_ULocale$toLocale(), 0, this);
    }

    public static ULocale getDefault() {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_icu_util_ULocale$getDefault(), 0);
    }

    public static synchronized void setDefault(ULocale uLocale) {
        InvokeDynamicSupport.bootstrapStatic("setDefault", $$robo$$android_icu_util_ULocale$setDefault(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static ULocale getDefault(Category category) {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_icu_util_ULocale$getDefault(android.icu.util.ULocale$Category ), 0, (Category)category);
    }

    public static synchronized void setDefault(Category category, ULocale uLocale) {
        InvokeDynamicSupport.bootstrapStatic("setDefault", $$robo$$android_icu_util_ULocale$setDefault(android.icu.util.ULocale$Category android.icu.util.ULocale ), 0, (Category)category, (ULocale)uLocale);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_util_ULocale$clone(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_ULocale$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_ULocale$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public int compareTo(ULocale uLocale) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_util_ULocale$compareTo(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static ULocale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_util_ULocale$getAvailableLocales(), 0);
    }

    public static String[] getISOCountries() {
        return InvokeDynamicSupport.bootstrapStatic("getISOCountries", $$robo$$android_icu_util_ULocale$getISOCountries(), 0);
    }

    public static String[] getISOLanguages() {
        return InvokeDynamicSupport.bootstrapStatic("getISOLanguages", $$robo$$android_icu_util_ULocale$getISOLanguages(), 0);
    }

    public String getLanguage() {
        return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_icu_util_ULocale$getLanguage(), 0, this);
    }

    public static String getLanguage(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getLanguage", $$robo$$android_icu_util_ULocale$getLanguage(java.lang.String ), 0, (String)string2);
    }

    public String getScript() {
        return InvokeDynamicSupport.bootstrap("getScript", $$robo$$android_icu_util_ULocale$getScript(), 0, this);
    }

    public static String getScript(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getScript", $$robo$$android_icu_util_ULocale$getScript(java.lang.String ), 0, (String)string2);
    }

    public String getCountry() {
        return InvokeDynamicSupport.bootstrap("getCountry", $$robo$$android_icu_util_ULocale$getCountry(), 0, this);
    }

    public static String getCountry(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCountry", $$robo$$android_icu_util_ULocale$getCountry(java.lang.String ), 0, (String)string2);
    }

    @Deprecated
    public static String getRegionForSupplementalData(ULocale uLocale, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getRegionForSupplementalData", $$robo$$android_icu_util_ULocale$getRegionForSupplementalData(android.icu.util.ULocale boolean ), 0, (ULocale)uLocale, (boolean)bl);
    }

    public String getVariant() {
        return InvokeDynamicSupport.bootstrap("getVariant", $$robo$$android_icu_util_ULocale$getVariant(), 0, this);
    }

    public static String getVariant(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getVariant", $$robo$$android_icu_util_ULocale$getVariant(java.lang.String ), 0, (String)string2);
    }

    public static String getFallback(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getFallback", $$robo$$android_icu_util_ULocale$getFallback(java.lang.String ), 0, (String)string2);
    }

    public ULocale getFallback() {
        return InvokeDynamicSupport.bootstrap("getFallback", $$robo$$android_icu_util_ULocale$getFallback(), 0, this);
    }

    private static String getFallbackString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getFallbackString", $$robo$$android_icu_util_ULocale$getFallbackString(java.lang.String ), 0, (String)string2);
    }

    public String getBaseName() {
        return InvokeDynamicSupport.bootstrap("getBaseName", $$robo$$android_icu_util_ULocale$getBaseName(), 0, this);
    }

    public static String getBaseName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getBaseName", $$robo$$android_icu_util_ULocale$getBaseName(java.lang.String ), 0, (String)string2);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_util_ULocale$getName(), 0, this);
    }

    private static int getShortestSubtagLength(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getShortestSubtagLength", $$robo$$android_icu_util_ULocale$getShortestSubtagLength(java.lang.String ), 0, (String)string2);
    }

    public static String getName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getName", $$robo$$android_icu_util_ULocale$getName(java.lang.String ), 0, (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_ULocale$toString(), 0, this);
    }

    public Iterator<String> getKeywords() {
        return InvokeDynamicSupport.bootstrap("getKeywords", $$robo$$android_icu_util_ULocale$getKeywords(), 0, this);
    }

    public static Iterator<String> getKeywords(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getKeywords", $$robo$$android_icu_util_ULocale$getKeywords(java.lang.String ), 0, (String)string2);
    }

    public String getKeywordValue(String string2) {
        return InvokeDynamicSupport.bootstrap("getKeywordValue", $$robo$$android_icu_util_ULocale$getKeywordValue(java.lang.String ), 0, this, string2);
    }

    public static String getKeywordValue(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getKeywordValue", $$robo$$android_icu_util_ULocale$getKeywordValue(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String canonicalize(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalize", $$robo$$android_icu_util_ULocale$canonicalize(java.lang.String ), 0, (String)string2);
    }

    public ULocale setKeywordValue(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("setKeywordValue", $$robo$$android_icu_util_ULocale$setKeywordValue(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public static String setKeywordValue(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("setKeywordValue", $$robo$$android_icu_util_ULocale$setKeywordValue(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    public String getISO3Language() {
        return InvokeDynamicSupport.bootstrap("getISO3Language", $$robo$$android_icu_util_ULocale$getISO3Language(), 0, this);
    }

    public static String getISO3Language(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getISO3Language", $$robo$$android_icu_util_ULocale$getISO3Language(java.lang.String ), 0, (String)string2);
    }

    public String getISO3Country() {
        return InvokeDynamicSupport.bootstrap("getISO3Country", $$robo$$android_icu_util_ULocale$getISO3Country(), 0, this);
    }

    public static String getISO3Country(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getISO3Country", $$robo$$android_icu_util_ULocale$getISO3Country(java.lang.String ), 0, (String)string2);
    }

    public boolean isRightToLeft() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRightToLeft", $$robo$$android_icu_util_ULocale$isRightToLeft(), 0, this);
    }

    public String getDisplayLanguage() {
        return InvokeDynamicSupport.bootstrap("getDisplayLanguage", $$robo$$android_icu_util_ULocale$getDisplayLanguage(), 0, this);
    }

    public String getDisplayLanguage(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayLanguage", $$robo$$android_icu_util_ULocale$getDisplayLanguage(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static String getDisplayLanguage(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayLanguage", $$robo$$android_icu_util_ULocale$getDisplayLanguage(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getDisplayLanguage(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayLanguage", $$robo$$android_icu_util_ULocale$getDisplayLanguage(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    public String getDisplayLanguageWithDialect() {
        return InvokeDynamicSupport.bootstrap("getDisplayLanguageWithDialect", $$robo$$android_icu_util_ULocale$getDisplayLanguageWithDialect(), 0, this);
    }

    public String getDisplayLanguageWithDialect(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayLanguageWithDialect", $$robo$$android_icu_util_ULocale$getDisplayLanguageWithDialect(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static String getDisplayLanguageWithDialect(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayLanguageWithDialect", $$robo$$android_icu_util_ULocale$getDisplayLanguageWithDialect(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getDisplayLanguageWithDialect(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayLanguageWithDialect", $$robo$$android_icu_util_ULocale$getDisplayLanguageWithDialect(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    private static String getDisplayLanguageInternal(ULocale uLocale, ULocale uLocale2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayLanguageInternal", $$robo$$android_icu_util_ULocale$getDisplayLanguageInternal(android.icu.util.ULocale android.icu.util.ULocale boolean ), 0, (ULocale)uLocale, (ULocale)uLocale2, (boolean)bl);
    }

    public String getDisplayScript() {
        return InvokeDynamicSupport.bootstrap("getDisplayScript", $$robo$$android_icu_util_ULocale$getDisplayScript(), 0, this);
    }

    @Deprecated
    public String getDisplayScriptInContext() {
        return InvokeDynamicSupport.bootstrap("getDisplayScriptInContext", $$robo$$android_icu_util_ULocale$getDisplayScriptInContext(), 0, this);
    }

    public String getDisplayScript(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayScript", $$robo$$android_icu_util_ULocale$getDisplayScript(android.icu.util.ULocale ), 0, this, uLocale);
    }

    @Deprecated
    public String getDisplayScriptInContext(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayScriptInContext", $$robo$$android_icu_util_ULocale$getDisplayScriptInContext(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static String getDisplayScript(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayScript", $$robo$$android_icu_util_ULocale$getDisplayScript(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    @Deprecated
    public static String getDisplayScriptInContext(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayScriptInContext", $$robo$$android_icu_util_ULocale$getDisplayScriptInContext(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getDisplayScript(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayScript", $$robo$$android_icu_util_ULocale$getDisplayScript(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    @Deprecated
    public static String getDisplayScriptInContext(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayScriptInContext", $$robo$$android_icu_util_ULocale$getDisplayScriptInContext(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    private static String getDisplayScriptInternal(ULocale uLocale, ULocale uLocale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayScriptInternal", $$robo$$android_icu_util_ULocale$getDisplayScriptInternal(android.icu.util.ULocale android.icu.util.ULocale ), 0, (ULocale)uLocale, (ULocale)uLocale2);
    }

    private static String getDisplayScriptInContextInternal(ULocale uLocale, ULocale uLocale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayScriptInContextInternal", $$robo$$android_icu_util_ULocale$getDisplayScriptInContextInternal(android.icu.util.ULocale android.icu.util.ULocale ), 0, (ULocale)uLocale, (ULocale)uLocale2);
    }

    public String getDisplayCountry() {
        return InvokeDynamicSupport.bootstrap("getDisplayCountry", $$robo$$android_icu_util_ULocale$getDisplayCountry(), 0, this);
    }

    public String getDisplayCountry(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayCountry", $$robo$$android_icu_util_ULocale$getDisplayCountry(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static String getDisplayCountry(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayCountry", $$robo$$android_icu_util_ULocale$getDisplayCountry(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getDisplayCountry(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayCountry", $$robo$$android_icu_util_ULocale$getDisplayCountry(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    private static String getDisplayCountryInternal(ULocale uLocale, ULocale uLocale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayCountryInternal", $$robo$$android_icu_util_ULocale$getDisplayCountryInternal(android.icu.util.ULocale android.icu.util.ULocale ), 0, (ULocale)uLocale, (ULocale)uLocale2);
    }

    public String getDisplayVariant() {
        return InvokeDynamicSupport.bootstrap("getDisplayVariant", $$robo$$android_icu_util_ULocale$getDisplayVariant(), 0, this);
    }

    public String getDisplayVariant(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayVariant", $$robo$$android_icu_util_ULocale$getDisplayVariant(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static String getDisplayVariant(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayVariant", $$robo$$android_icu_util_ULocale$getDisplayVariant(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getDisplayVariant(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayVariant", $$robo$$android_icu_util_ULocale$getDisplayVariant(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    private static String getDisplayVariantInternal(ULocale uLocale, ULocale uLocale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayVariantInternal", $$robo$$android_icu_util_ULocale$getDisplayVariantInternal(android.icu.util.ULocale android.icu.util.ULocale ), 0, (ULocale)uLocale, (ULocale)uLocale2);
    }

    public static String getDisplayKeyword(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayKeyword", $$robo$$android_icu_util_ULocale$getDisplayKeyword(java.lang.String ), 0, (String)string2);
    }

    public static String getDisplayKeyword(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayKeyword", $$robo$$android_icu_util_ULocale$getDisplayKeyword(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getDisplayKeyword(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayKeyword", $$robo$$android_icu_util_ULocale$getDisplayKeyword(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    private static String getDisplayKeywordInternal(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayKeywordInternal", $$robo$$android_icu_util_ULocale$getDisplayKeywordInternal(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    public String getDisplayKeywordValue(String string2) {
        return InvokeDynamicSupport.bootstrap("getDisplayKeywordValue", $$robo$$android_icu_util_ULocale$getDisplayKeywordValue(java.lang.String ), 0, this, string2);
    }

    public String getDisplayKeywordValue(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayKeywordValue", $$robo$$android_icu_util_ULocale$getDisplayKeywordValue(java.lang.String android.icu.util.ULocale ), 0, this, string2, uLocale);
    }

    public static String getDisplayKeywordValue(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayKeywordValue", $$robo$$android_icu_util_ULocale$getDisplayKeywordValue(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    public static String getDisplayKeywordValue(String string2, String string3, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayKeywordValue", $$robo$$android_icu_util_ULocale$getDisplayKeywordValue(java.lang.String java.lang.String android.icu.util.ULocale ), 0, (String)string2, (String)string3, (ULocale)uLocale);
    }

    private static String getDisplayKeywordValueInternal(ULocale uLocale, String string2, ULocale uLocale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayKeywordValueInternal", $$robo$$android_icu_util_ULocale$getDisplayKeywordValueInternal(android.icu.util.ULocale java.lang.String android.icu.util.ULocale ), 0, (ULocale)uLocale, (String)string2, (ULocale)uLocale2);
    }

    public String getDisplayName() {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_ULocale$getDisplayName(), 0, this);
    }

    public String getDisplayName(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_ULocale$getDisplayName(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static String getDisplayName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$android_icu_util_ULocale$getDisplayName(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getDisplayName(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$android_icu_util_ULocale$getDisplayName(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    private static String getDisplayNameInternal(ULocale uLocale, ULocale uLocale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayNameInternal", $$robo$$android_icu_util_ULocale$getDisplayNameInternal(android.icu.util.ULocale android.icu.util.ULocale ), 0, (ULocale)uLocale, (ULocale)uLocale2);
    }

    public String getDisplayNameWithDialect() {
        return InvokeDynamicSupport.bootstrap("getDisplayNameWithDialect", $$robo$$android_icu_util_ULocale$getDisplayNameWithDialect(), 0, this);
    }

    public String getDisplayNameWithDialect(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayNameWithDialect", $$robo$$android_icu_util_ULocale$getDisplayNameWithDialect(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static String getDisplayNameWithDialect(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayNameWithDialect", $$robo$$android_icu_util_ULocale$getDisplayNameWithDialect(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getDisplayNameWithDialect(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayNameWithDialect", $$robo$$android_icu_util_ULocale$getDisplayNameWithDialect(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    private static String getDisplayNameWithDialectInternal(ULocale uLocale, ULocale uLocale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayNameWithDialectInternal", $$robo$$android_icu_util_ULocale$getDisplayNameWithDialectInternal(android.icu.util.ULocale android.icu.util.ULocale ), 0, (ULocale)uLocale, (ULocale)uLocale2);
    }

    public String getCharacterOrientation() {
        return InvokeDynamicSupport.bootstrap("getCharacterOrientation", $$robo$$android_icu_util_ULocale$getCharacterOrientation(), 0, this);
    }

    public String getLineOrientation() {
        return InvokeDynamicSupport.bootstrap("getLineOrientation", $$robo$$android_icu_util_ULocale$getLineOrientation(), 0, this);
    }

    public static ULocale acceptLanguage(String string2, ULocale[] uLocaleArray, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrapStatic("acceptLanguage", $$robo$$android_icu_util_ULocale$acceptLanguage(java.lang.String android.icu.util.ULocale[] boolean[] ), 0, (String)string2, (ULocale[])uLocaleArray, (boolean[])blArray);
    }

    public static ULocale acceptLanguage(ULocale[] uLocaleArray, ULocale[] uLocaleArray2, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrapStatic("acceptLanguage", $$robo$$android_icu_util_ULocale$acceptLanguage(android.icu.util.ULocale[] android.icu.util.ULocale[] boolean[] ), 0, (ULocale[])uLocaleArray, (ULocale[])uLocaleArray2, (boolean[])blArray);
    }

    public static ULocale acceptLanguage(String string2, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrapStatic("acceptLanguage", $$robo$$android_icu_util_ULocale$acceptLanguage(java.lang.String boolean[] ), 0, (String)string2, (boolean[])blArray);
    }

    public static ULocale acceptLanguage(ULocale[] uLocaleArray, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrapStatic("acceptLanguage", $$robo$$android_icu_util_ULocale$acceptLanguage(android.icu.util.ULocale[] boolean[] ), 0, (ULocale[])uLocaleArray, (boolean[])blArray);
    }

    static ULocale[] parseAcceptLanguage(String string2, boolean bl) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseAcceptLanguage", $$robo$$android_icu_util_ULocale$parseAcceptLanguage(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    public static ULocale addLikelySubtags(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("addLikelySubtags", $$robo$$android_icu_util_ULocale$addLikelySubtags(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static ULocale minimizeSubtags(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("minimizeSubtags", $$robo$$android_icu_util_ULocale$minimizeSubtags(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    @Deprecated
    public static ULocale minimizeSubtags(ULocale uLocale, Minimize minimize) {
        return InvokeDynamicSupport.bootstrapStatic("minimizeSubtags", $$robo$$android_icu_util_ULocale$minimizeSubtags(android.icu.util.ULocale android.icu.util.ULocale$Minimize ), 0, (ULocale)uLocale, (Minimize)minimize);
    }

    private static boolean isEmptyString(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmptyString", $$robo$$android_icu_util_ULocale$isEmptyString(java.lang.String ), 0, (String)string2);
    }

    private static void appendTag(String string2, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("appendTag", $$robo$$android_icu_util_ULocale$appendTag(java.lang.String java.lang.StringBuilder ), 0, (String)string2, (StringBuilder)stringBuilder);
    }

    private static String createTagString(String string2, String string3, String string4, String string5, String string6) {
        return InvokeDynamicSupport.bootstrapStatic("createTagString", $$robo$$android_icu_util_ULocale$createTagString(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4, (String)string5, (String)string6);
    }

    static String createTagString(String string2, String string3, String string4, String string5) {
        return InvokeDynamicSupport.bootstrapStatic("createTagString", $$robo$$android_icu_util_ULocale$createTagString(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    private static int parseTagString(String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseTagString", $$robo$$android_icu_util_ULocale$parseTagString(java.lang.String java.lang.String[] ), 0, (String)string2, (String[])stringArray);
    }

    private static String lookupLikelySubtags(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("lookupLikelySubtags", $$robo$$android_icu_util_ULocale$lookupLikelySubtags(java.lang.String ), 0, (String)string2);
    }

    private static String createLikelySubtagsString(String string2, String string3, String string4, String string5) {
        return InvokeDynamicSupport.bootstrapStatic("createLikelySubtagsString", $$robo$$android_icu_util_ULocale$createLikelySubtagsString(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    public String getExtension(char c) {
        return InvokeDynamicSupport.bootstrap("getExtension", $$robo$$android_icu_util_ULocale$getExtension(char ), 0, this, c);
    }

    public Set<Character> getExtensionKeys() {
        return InvokeDynamicSupport.bootstrap("getExtensionKeys", $$robo$$android_icu_util_ULocale$getExtensionKeys(), 0, this);
    }

    public Set<String> getUnicodeLocaleAttributes() {
        return InvokeDynamicSupport.bootstrap("getUnicodeLocaleAttributes", $$robo$$android_icu_util_ULocale$getUnicodeLocaleAttributes(), 0, this);
    }

    public String getUnicodeLocaleType(String string2) {
        return InvokeDynamicSupport.bootstrap("getUnicodeLocaleType", $$robo$$android_icu_util_ULocale$getUnicodeLocaleType(java.lang.String ), 0, this, string2);
    }

    public Set<String> getUnicodeLocaleKeys() {
        return InvokeDynamicSupport.bootstrap("getUnicodeLocaleKeys", $$robo$$android_icu_util_ULocale$getUnicodeLocaleKeys(), 0, this);
    }

    public String toLanguageTag() {
        return InvokeDynamicSupport.bootstrap("toLanguageTag", $$robo$$android_icu_util_ULocale$toLanguageTag(), 0, this);
    }

    public static ULocale forLanguageTag(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("forLanguageTag", $$robo$$android_icu_util_ULocale$forLanguageTag(java.lang.String ), 0, (String)string2);
    }

    public static String toUnicodeLocaleKey(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toUnicodeLocaleKey", $$robo$$android_icu_util_ULocale$toUnicodeLocaleKey(java.lang.String ), 0, (String)string2);
    }

    public static String toUnicodeLocaleType(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("toUnicodeLocaleType", $$robo$$android_icu_util_ULocale$toUnicodeLocaleType(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String toLegacyKey(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toLegacyKey", $$robo$$android_icu_util_ULocale$toLegacyKey(java.lang.String ), 0, (String)string2);
    }

    public static String toLegacyType(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("toLegacyType", $$robo$$android_icu_util_ULocale$toLegacyType(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static ULocale getInstance(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_ULocale$getInstance(android.icu.impl.locale.BaseLocale android.icu.impl.locale.LocaleExtensions ), 0, (BaseLocale)baseLocale, (LocaleExtensions)localeExtensions);
    }

    private BaseLocale base() {
        return InvokeDynamicSupport.bootstrap("base", $$robo$$android_icu_util_ULocale$base(), 0, this);
    }

    private LocaleExtensions extensions() {
        return InvokeDynamicSupport.bootstrap("extensions", $$robo$$android_icu_util_ULocale$extensions(), 0, this);
    }

    private /* synthetic */ void __constructor__(String string2, Locale locale, 1 var3_3) {
        this.$$robo$$android_icu_util_ULocale$__constructor__(string2, locale, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(ULocale.class);
    }

    public /* synthetic */ ULocale() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ULocale)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class JDKLocaleHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static boolean hasScriptsAndUnicodeExtensions;
        private static boolean hasLocaleCategories;
        private static Method mGetScript;
        private static Method mGetExtensionKeys;
        private static Method mGetExtension;
        private static Method mGetUnicodeLocaleKeys;
        private static Method mGetUnicodeLocaleAttributes;
        private static Method mGetUnicodeLocaleType;
        private static Method mForLanguageTag;
        private static Method mGetDefault;
        private static Method mSetDefault;
        private static Object eDISPLAY;
        private static Object eFORMAT;
        private static String[][] JAVA6_MAPDATA;

        private void $$robo$$android_icu_util_ULocale_JDKLocaleHelper$__constructor__() {
        }

        private static final boolean $$robo$$android_icu_util_ULocale_JDKLocaleHelper$hasLocaleCategories() {
            return hasLocaleCategories;
        }

        private static final ULocale $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toULocale(Locale loc) {
            return hasScriptsAndUnicodeExtensions ? JDKLocaleHelper.toULocale7(loc) : JDKLocaleHelper.toULocale6(loc);
        }

        private static final Locale $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toLocale(ULocale uloc) {
            return hasScriptsAndUnicodeExtensions ? JDKLocaleHelper.toLocale7(uloc) : JDKLocaleHelper.toLocale6(uloc);
        }

        private static final ULocale $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toULocale7(Locale loc) {
            TreeMap<String, String> keywords;
            TreeSet<Object> attributes;
            String variant;
            String country;
            String script;
            String language;
            block25: {
                language = loc.getLanguage();
                script = "";
                country = loc.getCountry();
                variant = loc.getVariant();
                attributes = null;
                keywords = null;
                try {
                    script = (String)mGetScript.invoke((Object)loc, (Object[])null);
                    Set extKeys = (Set)mGetExtensionKeys.invoke((Object)loc, (Object[])null);
                    if (extKeys.isEmpty()) break block25;
                    for (Character extKey : extKeys) {
                        if (extKey.charValue() == 'u') {
                            Object attr222;
                            Set set = (Set)mGetUnicodeLocaleAttributes.invoke((Object)loc, (Object[])null);
                            if (!set.isEmpty()) {
                                attributes = new TreeSet<Object>();
                                for (Object attr222 : set) {
                                    attributes.add(attr222);
                                }
                            }
                            Set uKeys = (Set)mGetUnicodeLocaleKeys.invoke((Object)loc, (Object[])null);
                            attr222 = uKeys.iterator();
                            while (attr222.hasNext()) {
                                String kwKey = (String)attr222.next();
                                String kwVal = (String)mGetUnicodeLocaleType.invoke((Object)loc, kwKey);
                                if (kwVal == null) continue;
                                if (kwKey.equals("va")) {
                                    variant = variant.length() == 0 ? kwVal : kwVal + "_" + variant;
                                    continue;
                                }
                                if (keywords == null) {
                                    keywords = new TreeMap();
                                }
                                keywords.put(kwKey, kwVal);
                            }
                            continue;
                        }
                        String string2 = (String)mGetExtension.invoke((Object)loc, extKey);
                        if (string2 == null) continue;
                        if (keywords == null) {
                            keywords = new TreeMap<String, String>();
                        }
                        keywords.put(String.valueOf(extKey), string2);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (language.equals("no") && country.equals("NO") && variant.equals("NY")) {
                language = "nn";
                variant = "";
            }
            StringBuilder buf = new StringBuilder(language);
            if (script.length() > 0) {
                buf.append('_');
                buf.append(script);
            }
            if (country.length() > 0) {
                buf.append('_');
                buf.append(country);
            }
            if (variant.length() > 0) {
                if (country.length() == 0) {
                    buf.append('_');
                }
                buf.append('_');
                buf.append(variant);
            }
            if (attributes != null) {
                StringBuilder attrBuf = new StringBuilder();
                for (String string3 : attributes) {
                    if (attrBuf.length() != 0) {
                        attrBuf.append('-');
                    }
                    attrBuf.append(string3);
                }
                if (keywords == null) {
                    keywords = new TreeMap();
                }
                keywords.put("attribute", attrBuf.toString());
            }
            if (keywords != null) {
                buf.append('@');
                boolean addSep = false;
                for (Map.Entry entry : keywords.entrySet()) {
                    String kwKey = (String)entry.getKey();
                    String kwVal = (String)entry.getValue();
                    if (kwKey.length() != 1) {
                        kwKey = ULocale.toLegacyKey(kwKey);
                        kwVal = ULocale.toLegacyType(kwKey, kwVal.length() == 0 ? "yes" : kwVal);
                    }
                    if (addSep) {
                        buf.append(';');
                    } else {
                        addSep = true;
                    }
                    buf.append(kwKey);
                    buf.append('=');
                    buf.append(kwVal);
                }
            }
            return new ULocale(ULocale.getName(buf.toString()), loc);
        }

        private static final ULocale $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toULocale6(Locale loc) {
            ULocale uloc = null;
            String locStr = loc.toString();
            if (locStr.length() == 0) {
                uloc = ROOT;
            } else {
                for (int i = 0; i < JAVA6_MAPDATA.length; ++i) {
                    if (!JAVA6_MAPDATA[i][0].equals(locStr)) continue;
                    LocaleIDParser p = new LocaleIDParser(JAVA6_MAPDATA[i][1]);
                    p.setKeywordValue(JAVA6_MAPDATA[i][2], JAVA6_MAPDATA[i][3]);
                    locStr = p.getName();
                    break;
                }
                uloc = new ULocale(ULocale.getName(locStr), loc);
            }
            return uloc;
        }

        private static final Locale $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toLocale7(ULocale uloc) {
            Locale loc = null;
            String ulocStr = uloc.getName();
            if (uloc.getScript().length() > 0 || ulocStr.contains("@")) {
                String tag = uloc.toLanguageTag();
                tag = AsciiUtil.toUpperString(tag);
                try {
                    loc = (Locale)mForLanguageTag.invoke(null, tag);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (loc == null) {
                loc = new Locale(uloc.getLanguage(), uloc.getCountry(), uloc.getVariant());
            }
            return loc;
        }

        private static final Locale $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toLocale6(ULocale uloc) {
            String locstr = uloc.getBaseName();
            for (int i = 0; i < JAVA6_MAPDATA.length; ++i) {
                if (!locstr.equals(JAVA6_MAPDATA[i][1]) && !locstr.equals(JAVA6_MAPDATA[i][4])) continue;
                if (JAVA6_MAPDATA[i][2] != null) {
                    String val = uloc.getKeywordValue(JAVA6_MAPDATA[i][2]);
                    if (val == null || !val.equals(JAVA6_MAPDATA[i][3])) continue;
                    locstr = JAVA6_MAPDATA[i][0];
                    break;
                }
                locstr = JAVA6_MAPDATA[i][0];
                break;
            }
            LocaleIDParser p = new LocaleIDParser(locstr);
            String[] names = p.getLanguageScriptCountryVariant();
            return new Locale(names[0], names[2], names[3]);
        }

        private static final Locale $$robo$$android_icu_util_ULocale_JDKLocaleHelper$getDefault(Category category) {
            Locale loc = Locale.getDefault();
            if (hasLocaleCategories) {
                Object cat = null;
                switch (3.$SwitchMap$android$icu$util$ULocale$Category[category.ordinal()]) {
                    case 1: {
                        cat = eDISPLAY;
                        break;
                    }
                    case 2: {
                        cat = eFORMAT;
                    }
                }
                if (cat != null) {
                    try {
                        loc = (Locale)mGetDefault.invoke(null, cat);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
            return loc;
        }

        private static final void $$robo$$android_icu_util_ULocale_JDKLocaleHelper$setDefault(Category category, Locale newLocale) {
            if (hasLocaleCategories) {
                Object cat = null;
                switch (3.$SwitchMap$android$icu$util$ULocale$Category[category.ordinal()]) {
                    case 1: {
                        cat = eDISPLAY;
                        break;
                    }
                    case 2: {
                        cat = eFORMAT;
                    }
                }
                if (cat != null) {
                    try {
                        mSetDefault.invoke(null, cat, newLocale);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }

        private static final boolean $$robo$$android_icu_util_ULocale_JDKLocaleHelper$isOriginalDefaultLocale(Locale loc) {
            if (hasScriptsAndUnicodeExtensions) {
                String script = "";
                try {
                    script = (String)mGetScript.invoke((Object)loc, (Object[])null);
                }
                catch (Exception e) {
                    return false;
                }
                return loc.getLanguage().equals(JDKLocaleHelper.getSystemProperty("user.language")) && loc.getCountry().equals(JDKLocaleHelper.getSystemProperty("user.country")) && loc.getVariant().equals(JDKLocaleHelper.getSystemProperty("user.variant")) && script.equals(JDKLocaleHelper.getSystemProperty("user.script"));
            }
            return loc.getLanguage().equals(JDKLocaleHelper.getSystemProperty("user.language")) && loc.getCountry().equals(JDKLocaleHelper.getSystemProperty("user.country")) && loc.getVariant().equals(JDKLocaleHelper.getSystemProperty("user.variant"));
        }

        private static final String $$robo$$android_icu_util_ULocale_JDKLocaleHelper$getSystemProperty(String key) {
            String val = null;
            String fkey = key;
            if (System.getSecurityManager() != null) {
                try {
                    val = AccessController.doPrivileged(new PrivilegedAction<String>(fkey){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ String val$fkey;

                        private void $$robo$$android_icu_util_ULocale_JDKLocaleHelper_1$__constructor__(String string2) {
                        }

                        private final String $$robo$$android_icu_util_ULocale_JDKLocaleHelper_1$run() {
                            return System.getProperty(this.val$fkey);
                        }

                        private void __constructor__(String string2) {
                            this.$$robo$$android_icu_util_ULocale_JDKLocaleHelper_1$__constructor__(string2);
                        }
                        {
                            this.val$fkey = string2;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale_JDKLocaleHelper_1$__constructor__(java.lang.String ), 0, this, string2);
                        }

                        @Override
                        public String run() {
                            return InvokeDynamicSupport.bootstrap("run", $$robo$$android_icu_util_ULocale_JDKLocaleHelper_1$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }
                catch (AccessControlException accessControlException) {}
            } else {
                val = System.getProperty(fkey);
            }
            return val;
        }

        static void __staticInitializer__() {
            hasScriptsAndUnicodeExtensions = false;
            hasLocaleCategories = false;
            JAVA6_MAPDATA = new String[][]{{"ja_JP_JP", "ja_JP", "calendar", "japanese", "ja"}, {"no_NO_NY", "nn_NO", null, null, "nn"}, {"th_TH_TH", "th_TH", "numbers", "thai", "th"}};
            try {
                mGetScript = Locale.class.getMethod("getScript", null);
                mGetExtensionKeys = Locale.class.getMethod("getExtensionKeys", null);
                mGetExtension = Locale.class.getMethod("getExtension", Character.TYPE);
                mGetUnicodeLocaleKeys = Locale.class.getMethod("getUnicodeLocaleKeys", null);
                mGetUnicodeLocaleAttributes = Locale.class.getMethod("getUnicodeLocaleAttributes", null);
                mGetUnicodeLocaleType = Locale.class.getMethod("getUnicodeLocaleType", String.class);
                mForLanguageTag = Locale.class.getMethod("forLanguageTag", String.class);
                hasScriptsAndUnicodeExtensions = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                Class<?>[] classes;
                Class<?> cCategory = null;
                for (Class<?> c : classes = Locale.class.getDeclaredClasses()) {
                    if (!c.getName().equals("java.util.Locale$Category")) continue;
                    cCategory = c;
                    break;
                }
                if (cCategory != null) {
                    ?[] enumConstants;
                    mGetDefault = Locale.class.getDeclaredMethod("getDefault", cCategory);
                    mSetDefault = Locale.class.getDeclaredMethod("setDefault", cCategory, Locale.class);
                    Method mName = cCategory.getMethod("name", null);
                    for (Object e : enumConstants = cCategory.getEnumConstants()) {
                        String catVal = (String)mName.invoke(e, (Object[])null);
                        if (catVal.equals("DISPLAY")) {
                            eDISPLAY = e;
                            continue;
                        }
                        if (!catVal.equals("FORMAT")) continue;
                        eFORMAT = e;
                    }
                    if (eDISPLAY != null && eFORMAT != null) {
                        hasLocaleCategories = true;
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_ULocale_JDKLocaleHelper$__constructor__();
        }

        private JDKLocaleHelper() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$__constructor__(), 0, this);
        }

        public static boolean hasLocaleCategories() {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("hasLocaleCategories", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$hasLocaleCategories(), 0);
        }

        public static ULocale toULocale(Locale locale) {
            return InvokeDynamicSupport.bootstrapStatic("toULocale", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toULocale(java.util.Locale ), 0, (Locale)locale);
        }

        public static Locale toLocale(ULocale uLocale) {
            return InvokeDynamicSupport.bootstrapStatic("toLocale", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toLocale(android.icu.util.ULocale ), 0, (ULocale)uLocale);
        }

        private static ULocale toULocale7(Locale locale) {
            return InvokeDynamicSupport.bootstrapStatic("toULocale7", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toULocale7(java.util.Locale ), 0, (Locale)locale);
        }

        private static ULocale toULocale6(Locale locale) {
            return InvokeDynamicSupport.bootstrapStatic("toULocale6", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toULocale6(java.util.Locale ), 0, (Locale)locale);
        }

        private static Locale toLocale7(ULocale uLocale) {
            return InvokeDynamicSupport.bootstrapStatic("toLocale7", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toLocale7(android.icu.util.ULocale ), 0, (ULocale)uLocale);
        }

        private static Locale toLocale6(ULocale uLocale) {
            return InvokeDynamicSupport.bootstrapStatic("toLocale6", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$toLocale6(android.icu.util.ULocale ), 0, (ULocale)uLocale);
        }

        public static Locale getDefault(Category category) {
            return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$getDefault(android.icu.util.ULocale$Category ), 0, (Category)category);
        }

        public static void setDefault(Category category, Locale locale) {
            InvokeDynamicSupport.bootstrapStatic("setDefault", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$setDefault(android.icu.util.ULocale$Category java.util.Locale ), 0, (Category)category, (Locale)locale);
        }

        public static boolean isOriginalDefaultLocale(Locale locale) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isOriginalDefaultLocale", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$isOriginalDefaultLocale(java.util.Locale ), 0, (Locale)locale);
        }

        public static String getSystemProperty(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getSystemProperty", $$robo$$android_icu_util_ULocale_JDKLocaleHelper$getSystemProperty(java.lang.String ), 0, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(JDKLocaleHelper.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JDKLocaleHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private InternalLocaleBuilder _locbld;

        private void $$robo$$android_icu_util_ULocale_Builder$__constructor__() {
            this._locbld = new InternalLocaleBuilder();
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$setLocale(ULocale locale) {
            try {
                this._locbld.setLocale(locale.base(), locale.extensions());
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$setLanguageTag(String languageTag) {
            ParseStatus sts = new ParseStatus();
            LanguageTag tag = LanguageTag.parse(languageTag, sts);
            if (sts.isError()) {
                throw new IllformedLocaleException(sts.getErrorMessage(), sts.getErrorIndex());
            }
            this._locbld.setLanguageTag(tag);
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$setLanguage(String language) {
            try {
                this._locbld.setLanguage(language);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$setScript(String script) {
            try {
                this._locbld.setScript(script);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$setRegion(String region) {
            try {
                this._locbld.setRegion(region);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$setVariant(String variant) {
            try {
                this._locbld.setVariant(variant);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$setExtension(char key, String value) {
            try {
                this._locbld.setExtension(key, value);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$setUnicodeLocaleKeyword(String key, String type) {
            try {
                this._locbld.setUnicodeLocaleKeyword(key, type);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$addUnicodeLocaleAttribute(String attribute) {
            try {
                this._locbld.addUnicodeLocaleAttribute(attribute);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$removeUnicodeLocaleAttribute(String attribute) {
            try {
                this._locbld.removeUnicodeLocaleAttribute(attribute);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$clear() {
            this._locbld.clear();
            return this;
        }

        private final Builder $$robo$$android_icu_util_ULocale_Builder$clearExtensions() {
            this._locbld.clearExtensions();
            return this;
        }

        private final ULocale $$robo$$android_icu_util_ULocale_Builder$build() {
            return ULocale.getInstance(this._locbld.getBaseLocale(), this._locbld.getLocaleExtensions());
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_ULocale_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale_Builder$__constructor__(), 0, this);
        }

        public Builder setLocale(ULocale uLocale) {
            return InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_util_ULocale_Builder$setLocale(android.icu.util.ULocale ), 0, this, uLocale);
        }

        public Builder setLanguageTag(String string2) {
            return InvokeDynamicSupport.bootstrap("setLanguageTag", $$robo$$android_icu_util_ULocale_Builder$setLanguageTag(java.lang.String ), 0, this, string2);
        }

        public Builder setLanguage(String string2) {
            return InvokeDynamicSupport.bootstrap("setLanguage", $$robo$$android_icu_util_ULocale_Builder$setLanguage(java.lang.String ), 0, this, string2);
        }

        public Builder setScript(String string2) {
            return InvokeDynamicSupport.bootstrap("setScript", $$robo$$android_icu_util_ULocale_Builder$setScript(java.lang.String ), 0, this, string2);
        }

        public Builder setRegion(String string2) {
            return InvokeDynamicSupport.bootstrap("setRegion", $$robo$$android_icu_util_ULocale_Builder$setRegion(java.lang.String ), 0, this, string2);
        }

        public Builder setVariant(String string2) {
            return InvokeDynamicSupport.bootstrap("setVariant", $$robo$$android_icu_util_ULocale_Builder$setVariant(java.lang.String ), 0, this, string2);
        }

        public Builder setExtension(char c, String string2) {
            return InvokeDynamicSupport.bootstrap("setExtension", $$robo$$android_icu_util_ULocale_Builder$setExtension(char java.lang.String ), 0, this, c, string2);
        }

        public Builder setUnicodeLocaleKeyword(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("setUnicodeLocaleKeyword", $$robo$$android_icu_util_ULocale_Builder$setUnicodeLocaleKeyword(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public Builder addUnicodeLocaleAttribute(String string2) {
            return InvokeDynamicSupport.bootstrap("addUnicodeLocaleAttribute", $$robo$$android_icu_util_ULocale_Builder$addUnicodeLocaleAttribute(java.lang.String ), 0, this, string2);
        }

        public Builder removeUnicodeLocaleAttribute(String string2) {
            return InvokeDynamicSupport.bootstrap("removeUnicodeLocaleAttribute", $$robo$$android_icu_util_ULocale_Builder$removeUnicodeLocaleAttribute(java.lang.String ), 0, this, string2);
        }

        public Builder clear() {
            return InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_util_ULocale_Builder$clear(), 0, this);
        }

        public Builder clearExtensions() {
            return InvokeDynamicSupport.bootstrap("clearExtensions", $$robo$$android_icu_util_ULocale_Builder$clearExtensions(), 0, this);
        }

        public ULocale build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_icu_util_ULocale_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Minimize
    extends Enum<Minimize> {
        public transient /* synthetic */ Object __robo_data__;
        @Deprecated
        public static /* enum */ Minimize FAVOR_SCRIPT;
        @Deprecated
        public static /* enum */ Minimize FAVOR_REGION;
        private static /* synthetic */ Minimize[] $VALUES;

        private static final Minimize[] $$robo$$android_icu_util_ULocale_Minimize$values() {
            return (Minimize[])$VALUES.clone();
        }

        private static final Minimize $$robo$$android_icu_util_ULocale_Minimize$valueOf(String name) {
            return Enum.valueOf(Minimize.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_ULocale_Minimize$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            FAVOR_SCRIPT = new Minimize();
            FAVOR_REGION = new Minimize();
            $VALUES = new Minimize[]{FAVOR_SCRIPT, FAVOR_REGION};
        }

        public static Minimize[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_ULocale_Minimize$values(), 0);
        }

        public static Minimize valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_ULocale_Minimize$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_util_ULocale_Minimize$__constructor__(string2, n);
        }

        private Minimize() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale_Minimize$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Minimize.class);
        }

        public /* synthetic */ Minimize() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Minimize)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Type
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_util_ULocale_Type$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_icu_util_ULocale_Type$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_ULocale_Type$__constructor__();
        }

        private Type() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale_Type$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_util_ULocale_Type$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Type)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Category
    extends Enum<Category> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Category DISPLAY;
        public static /* enum */ Category FORMAT;
        private static /* synthetic */ Category[] $VALUES;

        private static final Category[] $$robo$$android_icu_util_ULocale_Category$values() {
            return (Category[])$VALUES.clone();
        }

        private static final Category $$robo$$android_icu_util_ULocale_Category$valueOf(String name) {
            return Enum.valueOf(Category.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_ULocale_Category$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            DISPLAY = new Category();
            FORMAT = new Category();
            $VALUES = new Category[]{DISPLAY, FORMAT};
        }

        public static Category[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_ULocale_Category$values(), 0);
        }

        public static Category valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_ULocale_Category$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_util_ULocale_Category$__constructor__(string2, n);
        }

        private Category() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ULocale_Category$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Category.class);
        }

        public /* synthetic */ Category() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Category)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

