/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class GnssMeasurement
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mFlags;
    private int mSvid;
    private int mConstellationType;
    private double mTimeOffsetNanos;
    private int mState;
    private long mReceivedSvTimeNanos;
    private long mReceivedSvTimeUncertaintyNanos;
    private double mCn0DbHz;
    private double mPseudorangeRateMetersPerSecond;
    private double mPseudorangeRateUncertaintyMetersPerSecond;
    private int mAccumulatedDeltaRangeState;
    private double mAccumulatedDeltaRangeMeters;
    private double mAccumulatedDeltaRangeUncertaintyMeters;
    private float mCarrierFrequencyHz;
    private long mCarrierCycles;
    private double mCarrierPhase;
    private double mCarrierPhaseUncertainty;
    private int mMultipathIndicator;
    private double mSnrInDb;
    private double mAutomaticGainControlLevelInDb;
    private static int HAS_NO_FLAGS = 0;
    private static int HAS_SNR = 1;
    private static int HAS_CARRIER_FREQUENCY = 512;
    private static int HAS_CARRIER_CYCLES = 1024;
    private static int HAS_CARRIER_PHASE = 2048;
    private static int HAS_CARRIER_PHASE_UNCERTAINTY = 4096;
    private static int HAS_AUTOMATIC_GAIN_CONTROL = 8192;
    public static int MULTIPATH_INDICATOR_UNKNOWN = 0;
    public static int MULTIPATH_INDICATOR_DETECTED = 1;
    public static int MULTIPATH_INDICATOR_NOT_DETECTED = 2;
    public static int STATE_UNKNOWN = 0;
    public static int STATE_CODE_LOCK = 1;
    public static int STATE_BIT_SYNC = 2;
    public static int STATE_SUBFRAME_SYNC = 4;
    public static int STATE_TOW_DECODED = 8;
    public static int STATE_MSEC_AMBIGUOUS = 16;
    public static int STATE_SYMBOL_SYNC = 32;
    public static int STATE_GLO_STRING_SYNC = 64;
    public static int STATE_GLO_TOD_DECODED = 128;
    public static int STATE_BDS_D2_BIT_SYNC = 256;
    public static int STATE_BDS_D2_SUBFRAME_SYNC = 512;
    public static int STATE_GAL_E1BC_CODE_LOCK = 1024;
    public static int STATE_GAL_E1C_2ND_CODE_LOCK = 2048;
    public static int STATE_GAL_E1B_PAGE_SYNC = 4096;
    public static int STATE_SBAS_SYNC = 8192;
    public static int STATE_TOW_KNOWN = 16384;
    public static int STATE_GLO_TOD_KNOWN = 32768;
    private static int STATE_ALL = 16383;
    public static int ADR_STATE_UNKNOWN = 0;
    public static int ADR_STATE_VALID = 1;
    public static int ADR_STATE_RESET = 2;
    public static int ADR_STATE_CYCLE_SLIP = 4;
    private static int ADR_ALL = 7;
    public static Parcelable.Creator<GnssMeasurement> CREATOR;

    private void $$robo$$android_location_GnssMeasurement$__constructor__() {
        this.initialize();
    }

    private final void $$robo$$android_location_GnssMeasurement$set(GnssMeasurement measurement) {
        this.mFlags = measurement.mFlags;
        this.mSvid = measurement.mSvid;
        this.mConstellationType = measurement.mConstellationType;
        this.mTimeOffsetNanos = measurement.mTimeOffsetNanos;
        this.mState = measurement.mState;
        this.mReceivedSvTimeNanos = measurement.mReceivedSvTimeNanos;
        this.mReceivedSvTimeUncertaintyNanos = measurement.mReceivedSvTimeUncertaintyNanos;
        this.mCn0DbHz = measurement.mCn0DbHz;
        this.mPseudorangeRateMetersPerSecond = measurement.mPseudorangeRateMetersPerSecond;
        this.mPseudorangeRateUncertaintyMetersPerSecond = measurement.mPseudorangeRateUncertaintyMetersPerSecond;
        this.mAccumulatedDeltaRangeState = measurement.mAccumulatedDeltaRangeState;
        this.mAccumulatedDeltaRangeMeters = measurement.mAccumulatedDeltaRangeMeters;
        this.mAccumulatedDeltaRangeUncertaintyMeters = measurement.mAccumulatedDeltaRangeUncertaintyMeters;
        this.mCarrierFrequencyHz = measurement.mCarrierFrequencyHz;
        this.mCarrierCycles = measurement.mCarrierCycles;
        this.mCarrierPhase = measurement.mCarrierPhase;
        this.mCarrierPhaseUncertainty = measurement.mCarrierPhaseUncertainty;
        this.mMultipathIndicator = measurement.mMultipathIndicator;
        this.mSnrInDb = measurement.mSnrInDb;
        this.mAutomaticGainControlLevelInDb = measurement.mAutomaticGainControlLevelInDb;
    }

    private final void $$robo$$android_location_GnssMeasurement$reset() {
        this.initialize();
    }

    private final int $$robo$$android_location_GnssMeasurement$getSvid() {
        return this.mSvid;
    }

    private final void $$robo$$android_location_GnssMeasurement$setSvid(int value) {
        this.mSvid = value;
    }

    private final int $$robo$$android_location_GnssMeasurement$getConstellationType() {
        return this.mConstellationType;
    }

    private final void $$robo$$android_location_GnssMeasurement$setConstellationType(int value) {
        this.mConstellationType = value;
    }

    private final double $$robo$$android_location_GnssMeasurement$getTimeOffsetNanos() {
        return this.mTimeOffsetNanos;
    }

    private final void $$robo$$android_location_GnssMeasurement$setTimeOffsetNanos(double value) {
        this.mTimeOffsetNanos = value;
    }

    private final int $$robo$$android_location_GnssMeasurement$getState() {
        return this.mState;
    }

    private final void $$robo$$android_location_GnssMeasurement$setState(int value) {
        this.mState = value;
    }

    private final String $$robo$$android_location_GnssMeasurement$getStateString() {
        int remainingStates;
        if (this.mState == 0) {
            return "Unknown";
        }
        StringBuilder builder = new StringBuilder();
        if ((this.mState & 1) != 0) {
            builder.append("CodeLock|");
        }
        if ((this.mState & 2) != 0) {
            builder.append("BitSync|");
        }
        if ((this.mState & 4) != 0) {
            builder.append("SubframeSync|");
        }
        if ((this.mState & 8) != 0) {
            builder.append("TowDecoded|");
        }
        if ((this.mState & 0x4000) != 0) {
            builder.append("TowKnown|");
        }
        if ((this.mState & 0x10) != 0) {
            builder.append("MsecAmbiguous|");
        }
        if ((this.mState & 0x20) != 0) {
            builder.append("SymbolSync|");
        }
        if ((this.mState & 0x40) != 0) {
            builder.append("GloStringSync|");
        }
        if ((this.mState & 0x80) != 0) {
            builder.append("GloTodDecoded|");
        }
        if ((this.mState & 0x8000) != 0) {
            builder.append("GloTodKnown|");
        }
        if ((this.mState & 0x100) != 0) {
            builder.append("BdsD2BitSync|");
        }
        if ((this.mState & 0x200) != 0) {
            builder.append("BdsD2SubframeSync|");
        }
        if ((this.mState & 0x400) != 0) {
            builder.append("GalE1bcCodeLock|");
        }
        if ((this.mState & 0x800) != 0) {
            builder.append("E1c2ndCodeLock|");
        }
        if ((this.mState & 0x1000) != 0) {
            builder.append("GalE1bPageSync|");
        }
        if ((this.mState & 0x2000) != 0) {
            builder.append("SbasSync|");
        }
        if ((remainingStates = this.mState & 0xFFFFC000) > 0) {
            builder.append("Other(");
            builder.append(Integer.toBinaryString(remainingStates));
            builder.append(")|");
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private final long $$robo$$android_location_GnssMeasurement$getReceivedSvTimeNanos() {
        return this.mReceivedSvTimeNanos;
    }

    private final void $$robo$$android_location_GnssMeasurement$setReceivedSvTimeNanos(long value) {
        this.mReceivedSvTimeNanos = value;
    }

    private final long $$robo$$android_location_GnssMeasurement$getReceivedSvTimeUncertaintyNanos() {
        return this.mReceivedSvTimeUncertaintyNanos;
    }

    private final void $$robo$$android_location_GnssMeasurement$setReceivedSvTimeUncertaintyNanos(long value) {
        this.mReceivedSvTimeUncertaintyNanos = value;
    }

    private final double $$robo$$android_location_GnssMeasurement$getCn0DbHz() {
        return this.mCn0DbHz;
    }

    private final void $$robo$$android_location_GnssMeasurement$setCn0DbHz(double value) {
        this.mCn0DbHz = value;
    }

    private final double $$robo$$android_location_GnssMeasurement$getPseudorangeRateMetersPerSecond() {
        return this.mPseudorangeRateMetersPerSecond;
    }

    private final void $$robo$$android_location_GnssMeasurement$setPseudorangeRateMetersPerSecond(double value) {
        this.mPseudorangeRateMetersPerSecond = value;
    }

    private final double $$robo$$android_location_GnssMeasurement$getPseudorangeRateUncertaintyMetersPerSecond() {
        return this.mPseudorangeRateUncertaintyMetersPerSecond;
    }

    private final void $$robo$$android_location_GnssMeasurement$setPseudorangeRateUncertaintyMetersPerSecond(double value) {
        this.mPseudorangeRateUncertaintyMetersPerSecond = value;
    }

    private final int $$robo$$android_location_GnssMeasurement$getAccumulatedDeltaRangeState() {
        return this.mAccumulatedDeltaRangeState;
    }

    private final void $$robo$$android_location_GnssMeasurement$setAccumulatedDeltaRangeState(int value) {
        this.mAccumulatedDeltaRangeState = value;
    }

    private final String $$robo$$android_location_GnssMeasurement$getAccumulatedDeltaRangeStateString() {
        int remainingStates;
        if (this.mAccumulatedDeltaRangeState == 0) {
            return "Unknown";
        }
        StringBuilder builder = new StringBuilder();
        if ((this.mAccumulatedDeltaRangeState & 1) == 1) {
            builder.append("Valid|");
        }
        if ((this.mAccumulatedDeltaRangeState & 2) == 2) {
            builder.append("Reset|");
        }
        if ((this.mAccumulatedDeltaRangeState & 4) == 4) {
            builder.append("CycleSlip|");
        }
        if ((remainingStates = this.mAccumulatedDeltaRangeState & 0xFFFFFFF8) > 0) {
            builder.append("Other(");
            builder.append(Integer.toBinaryString(remainingStates));
            builder.append(")|");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private final double $$robo$$android_location_GnssMeasurement$getAccumulatedDeltaRangeMeters() {
        return this.mAccumulatedDeltaRangeMeters;
    }

    private final void $$robo$$android_location_GnssMeasurement$setAccumulatedDeltaRangeMeters(double value) {
        this.mAccumulatedDeltaRangeMeters = value;
    }

    private final double $$robo$$android_location_GnssMeasurement$getAccumulatedDeltaRangeUncertaintyMeters() {
        return this.mAccumulatedDeltaRangeUncertaintyMeters;
    }

    private final void $$robo$$android_location_GnssMeasurement$setAccumulatedDeltaRangeUncertaintyMeters(double value) {
        this.mAccumulatedDeltaRangeUncertaintyMeters = value;
    }

    private final boolean $$robo$$android_location_GnssMeasurement$hasCarrierFrequencyHz() {
        return this.isFlagSet(512);
    }

    private final float $$robo$$android_location_GnssMeasurement$getCarrierFrequencyHz() {
        return this.mCarrierFrequencyHz;
    }

    private final void $$robo$$android_location_GnssMeasurement$setCarrierFrequencyHz(float carrierFrequencyHz) {
        this.setFlag(512);
        this.mCarrierFrequencyHz = carrierFrequencyHz;
    }

    private final void $$robo$$android_location_GnssMeasurement$resetCarrierFrequencyHz() {
        this.resetFlag(512);
        this.mCarrierFrequencyHz = Float.NaN;
    }

    private final boolean $$robo$$android_location_GnssMeasurement$hasCarrierCycles() {
        return this.isFlagSet(1024);
    }

    private final long $$robo$$android_location_GnssMeasurement$getCarrierCycles() {
        return this.mCarrierCycles;
    }

    private final void $$robo$$android_location_GnssMeasurement$setCarrierCycles(long value) {
        this.setFlag(1024);
        this.mCarrierCycles = value;
    }

    private final void $$robo$$android_location_GnssMeasurement$resetCarrierCycles() {
        this.resetFlag(1024);
        this.mCarrierCycles = Long.MIN_VALUE;
    }

    private final boolean $$robo$$android_location_GnssMeasurement$hasCarrierPhase() {
        return this.isFlagSet(2048);
    }

    private final double $$robo$$android_location_GnssMeasurement$getCarrierPhase() {
        return this.mCarrierPhase;
    }

    private final void $$robo$$android_location_GnssMeasurement$setCarrierPhase(double value) {
        this.setFlag(2048);
        this.mCarrierPhase = value;
    }

    private final void $$robo$$android_location_GnssMeasurement$resetCarrierPhase() {
        this.resetFlag(2048);
        this.mCarrierPhase = Double.NaN;
    }

    private final boolean $$robo$$android_location_GnssMeasurement$hasCarrierPhaseUncertainty() {
        return this.isFlagSet(4096);
    }

    private final double $$robo$$android_location_GnssMeasurement$getCarrierPhaseUncertainty() {
        return this.mCarrierPhaseUncertainty;
    }

    private final void $$robo$$android_location_GnssMeasurement$setCarrierPhaseUncertainty(double value) {
        this.setFlag(4096);
        this.mCarrierPhaseUncertainty = value;
    }

    private final void $$robo$$android_location_GnssMeasurement$resetCarrierPhaseUncertainty() {
        this.resetFlag(4096);
        this.mCarrierPhaseUncertainty = Double.NaN;
    }

    private final int $$robo$$android_location_GnssMeasurement$getMultipathIndicator() {
        return this.mMultipathIndicator;
    }

    private final void $$robo$$android_location_GnssMeasurement$setMultipathIndicator(int value) {
        this.mMultipathIndicator = value;
    }

    private final String $$robo$$android_location_GnssMeasurement$getMultipathIndicatorString() {
        switch (this.mMultipathIndicator) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Detected";
            }
            case 2: {
                return "NotDetected";
            }
        }
        return "<Invalid:" + this.mMultipathIndicator + ">";
    }

    private final boolean $$robo$$android_location_GnssMeasurement$hasSnrInDb() {
        return this.isFlagSet(1);
    }

    private final double $$robo$$android_location_GnssMeasurement$getSnrInDb() {
        return this.mSnrInDb;
    }

    private final void $$robo$$android_location_GnssMeasurement$setSnrInDb(double snrInDb) {
        this.setFlag(1);
        this.mSnrInDb = snrInDb;
    }

    private final void $$robo$$android_location_GnssMeasurement$resetSnrInDb() {
        this.resetFlag(1);
        this.mSnrInDb = Double.NaN;
    }

    private final boolean $$robo$$android_location_GnssMeasurement$hasAutomaticGainControlLevelDb() {
        return this.isFlagSet(8192);
    }

    private final double $$robo$$android_location_GnssMeasurement$getAutomaticGainControlLevelDb() {
        return this.mAutomaticGainControlLevelInDb;
    }

    private final void $$robo$$android_location_GnssMeasurement$setAutomaticGainControlLevelInDb(double agcLevelDb) {
        this.setFlag(8192);
        this.mAutomaticGainControlLevelInDb = agcLevelDb;
    }

    private final void $$robo$$android_location_GnssMeasurement$resetAutomaticGainControlLevel() {
        this.resetFlag(8192);
        this.mAutomaticGainControlLevelInDb = Double.NaN;
    }

    private final void $$robo$$android_location_GnssMeasurement$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mFlags);
        parcel.writeInt(this.mSvid);
        parcel.writeInt(this.mConstellationType);
        parcel.writeDouble(this.mTimeOffsetNanos);
        parcel.writeInt(this.mState);
        parcel.writeLong(this.mReceivedSvTimeNanos);
        parcel.writeLong(this.mReceivedSvTimeUncertaintyNanos);
        parcel.writeDouble(this.mCn0DbHz);
        parcel.writeDouble(this.mPseudorangeRateMetersPerSecond);
        parcel.writeDouble(this.mPseudorangeRateUncertaintyMetersPerSecond);
        parcel.writeInt(this.mAccumulatedDeltaRangeState);
        parcel.writeDouble(this.mAccumulatedDeltaRangeMeters);
        parcel.writeDouble(this.mAccumulatedDeltaRangeUncertaintyMeters);
        parcel.writeFloat(this.mCarrierFrequencyHz);
        parcel.writeLong(this.mCarrierCycles);
        parcel.writeDouble(this.mCarrierPhase);
        parcel.writeDouble(this.mCarrierPhaseUncertainty);
        parcel.writeInt(this.mMultipathIndicator);
        parcel.writeDouble(this.mSnrInDb);
        parcel.writeDouble(this.mAutomaticGainControlLevelInDb);
    }

    private final int $$robo$$android_location_GnssMeasurement$describeContents() {
        return 0;
    }

    private final String $$robo$$android_location_GnssMeasurement$toString() {
        String format = "   %-29s = %s\n";
        String formatWithUncertainty = "   %-29s = %-25s   %-40s = %s\n";
        StringBuilder builder = new StringBuilder("GnssMeasurement:\n");
        builder.append(String.format("   %-29s = %s\n", "Svid", this.mSvid));
        builder.append(String.format("   %-29s = %s\n", "ConstellationType", this.mConstellationType));
        builder.append(String.format("   %-29s = %s\n", "TimeOffsetNanos", this.mTimeOffsetNanos));
        builder.append(String.format("   %-29s = %s\n", "State", this.getStateString()));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "ReceivedSvTimeNanos", this.mReceivedSvTimeNanos, "ReceivedSvTimeUncertaintyNanos", this.mReceivedSvTimeUncertaintyNanos));
        builder.append(String.format("   %-29s = %s\n", "Cn0DbHz", this.mCn0DbHz));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "PseudorangeRateMetersPerSecond", this.mPseudorangeRateMetersPerSecond, "PseudorangeRateUncertaintyMetersPerSecond", this.mPseudorangeRateUncertaintyMetersPerSecond));
        builder.append(String.format("   %-29s = %s\n", "AccumulatedDeltaRangeState", this.getAccumulatedDeltaRangeStateString()));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "AccumulatedDeltaRangeMeters", this.mAccumulatedDeltaRangeMeters, "AccumulatedDeltaRangeUncertaintyMeters", this.mAccumulatedDeltaRangeUncertaintyMeters));
        builder.append(String.format("   %-29s = %s\n", "CarrierFrequencyHz", this.hasCarrierFrequencyHz() ? Float.valueOf(this.mCarrierFrequencyHz) : null));
        builder.append(String.format("   %-29s = %s\n", "CarrierCycles", this.hasCarrierCycles() ? Long.valueOf(this.mCarrierCycles) : null));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "CarrierPhase", this.hasCarrierPhase() ? Double.valueOf(this.mCarrierPhase) : null, "CarrierPhaseUncertainty", this.hasCarrierPhaseUncertainty() ? Double.valueOf(this.mCarrierPhaseUncertainty) : null));
        builder.append(String.format("   %-29s = %s\n", "MultipathIndicator", this.getMultipathIndicatorString()));
        builder.append(String.format("   %-29s = %s\n", "SnrInDb", this.hasSnrInDb() ? Double.valueOf(this.mSnrInDb) : null));
        builder.append(String.format("   %-29s = %s\n", "AgcLevelDb", this.hasAutomaticGainControlLevelDb() ? Double.valueOf(this.mAutomaticGainControlLevelInDb) : null));
        return builder.toString();
    }

    private final void $$robo$$android_location_GnssMeasurement$initialize() {
        this.mFlags = 0;
        this.setSvid(0);
        this.setTimeOffsetNanos(-9.223372036854776E18);
        this.setState(0);
        this.setReceivedSvTimeNanos(Long.MIN_VALUE);
        this.setReceivedSvTimeUncertaintyNanos(Long.MAX_VALUE);
        this.setCn0DbHz(Double.MIN_VALUE);
        this.setPseudorangeRateMetersPerSecond(Double.MIN_VALUE);
        this.setPseudorangeRateUncertaintyMetersPerSecond(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeState(0);
        this.setAccumulatedDeltaRangeMeters(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeUncertaintyMeters(Double.MIN_VALUE);
        this.resetCarrierFrequencyHz();
        this.resetCarrierCycles();
        this.resetCarrierPhase();
        this.resetCarrierPhaseUncertainty();
        this.setMultipathIndicator(0);
        this.resetSnrInDb();
        this.resetAutomaticGainControlLevel();
    }

    private final void $$robo$$android_location_GnssMeasurement$setFlag(int flag) {
        this.mFlags |= flag;
    }

    private final void $$robo$$android_location_GnssMeasurement$resetFlag(int flag) {
        this.mFlags &= ~flag;
    }

    private final boolean $$robo$$android_location_GnssMeasurement$isFlagSet(int flag) {
        return (this.mFlags & flag) == flag;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<GnssMeasurement>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_location_GnssMeasurement_1$__constructor__() {
            }

            private final GnssMeasurement $$robo$$android_location_GnssMeasurement_1$createFromParcel(Parcel parcel) {
                GnssMeasurement gnssMeasurement = new GnssMeasurement();
                gnssMeasurement.mFlags = parcel.readInt();
                gnssMeasurement.mSvid = parcel.readInt();
                gnssMeasurement.mConstellationType = parcel.readInt();
                gnssMeasurement.mTimeOffsetNanos = parcel.readDouble();
                gnssMeasurement.mState = parcel.readInt();
                gnssMeasurement.mReceivedSvTimeNanos = parcel.readLong();
                gnssMeasurement.mReceivedSvTimeUncertaintyNanos = parcel.readLong();
                gnssMeasurement.mCn0DbHz = parcel.readDouble();
                gnssMeasurement.mPseudorangeRateMetersPerSecond = parcel.readDouble();
                gnssMeasurement.mPseudorangeRateUncertaintyMetersPerSecond = parcel.readDouble();
                gnssMeasurement.mAccumulatedDeltaRangeState = parcel.readInt();
                gnssMeasurement.mAccumulatedDeltaRangeMeters = parcel.readDouble();
                gnssMeasurement.mAccumulatedDeltaRangeUncertaintyMeters = parcel.readDouble();
                gnssMeasurement.mCarrierFrequencyHz = parcel.readFloat();
                gnssMeasurement.mCarrierCycles = parcel.readLong();
                gnssMeasurement.mCarrierPhase = parcel.readDouble();
                gnssMeasurement.mCarrierPhaseUncertainty = parcel.readDouble();
                gnssMeasurement.mMultipathIndicator = parcel.readInt();
                gnssMeasurement.mSnrInDb = parcel.readDouble();
                gnssMeasurement.mAutomaticGainControlLevelInDb = parcel.readDouble();
                return gnssMeasurement;
            }

            private final GnssMeasurement[] $$robo$$android_location_GnssMeasurement_1$newArray(int i) {
                return new GnssMeasurement[i];
            }

            private void __constructor__() {
                this.$$robo$$android_location_GnssMeasurement_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_GnssMeasurement_1$__constructor__(), 0, this);
            }

            @Override
            public GnssMeasurement createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_location_GnssMeasurement_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public GnssMeasurement[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_location_GnssMeasurement_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_location_GnssMeasurement$__constructor__();
    }

    public GnssMeasurement() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_GnssMeasurement$__constructor__(), 0, this);
    }

    public void set(GnssMeasurement gnssMeasurement) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_location_GnssMeasurement$set(android.location.GnssMeasurement ), 0, this, gnssMeasurement);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_location_GnssMeasurement$reset(), 0, this);
    }

    public int getSvid() {
        return (int)InvokeDynamicSupport.bootstrap("getSvid", $$robo$$android_location_GnssMeasurement$getSvid(), 0, this);
    }

    public void setSvid(int n) {
        InvokeDynamicSupport.bootstrap("setSvid", $$robo$$android_location_GnssMeasurement$setSvid(int ), 0, this, n);
    }

    public int getConstellationType() {
        return (int)InvokeDynamicSupport.bootstrap("getConstellationType", $$robo$$android_location_GnssMeasurement$getConstellationType(), 0, this);
    }

    public void setConstellationType(int n) {
        InvokeDynamicSupport.bootstrap("setConstellationType", $$robo$$android_location_GnssMeasurement$setConstellationType(int ), 0, this, n);
    }

    public double getTimeOffsetNanos() {
        return (double)InvokeDynamicSupport.bootstrap("getTimeOffsetNanos", $$robo$$android_location_GnssMeasurement$getTimeOffsetNanos(), 0, this);
    }

    public void setTimeOffsetNanos(double d) {
        InvokeDynamicSupport.bootstrap("setTimeOffsetNanos", $$robo$$android_location_GnssMeasurement$setTimeOffsetNanos(double ), 0, this, d);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_location_GnssMeasurement$getState(), 0, this);
    }

    public void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_location_GnssMeasurement$setState(int ), 0, this, n);
    }

    private String getStateString() {
        return InvokeDynamicSupport.bootstrap("getStateString", $$robo$$android_location_GnssMeasurement$getStateString(), 0, this);
    }

    public long getReceivedSvTimeNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getReceivedSvTimeNanos", $$robo$$android_location_GnssMeasurement$getReceivedSvTimeNanos(), 0, this);
    }

    public void setReceivedSvTimeNanos(long l) {
        InvokeDynamicSupport.bootstrap("setReceivedSvTimeNanos", $$robo$$android_location_GnssMeasurement$setReceivedSvTimeNanos(long ), 0, this, l);
    }

    public long getReceivedSvTimeUncertaintyNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getReceivedSvTimeUncertaintyNanos", $$robo$$android_location_GnssMeasurement$getReceivedSvTimeUncertaintyNanos(), 0, this);
    }

    public void setReceivedSvTimeUncertaintyNanos(long l) {
        InvokeDynamicSupport.bootstrap("setReceivedSvTimeUncertaintyNanos", $$robo$$android_location_GnssMeasurement$setReceivedSvTimeUncertaintyNanos(long ), 0, this, l);
    }

    public double getCn0DbHz() {
        return (double)InvokeDynamicSupport.bootstrap("getCn0DbHz", $$robo$$android_location_GnssMeasurement$getCn0DbHz(), 0, this);
    }

    public void setCn0DbHz(double d) {
        InvokeDynamicSupport.bootstrap("setCn0DbHz", $$robo$$android_location_GnssMeasurement$setCn0DbHz(double ), 0, this, d);
    }

    public double getPseudorangeRateMetersPerSecond() {
        return (double)InvokeDynamicSupport.bootstrap("getPseudorangeRateMetersPerSecond", $$robo$$android_location_GnssMeasurement$getPseudorangeRateMetersPerSecond(), 0, this);
    }

    public void setPseudorangeRateMetersPerSecond(double d) {
        InvokeDynamicSupport.bootstrap("setPseudorangeRateMetersPerSecond", $$robo$$android_location_GnssMeasurement$setPseudorangeRateMetersPerSecond(double ), 0, this, d);
    }

    public double getPseudorangeRateUncertaintyMetersPerSecond() {
        return (double)InvokeDynamicSupport.bootstrap("getPseudorangeRateUncertaintyMetersPerSecond", $$robo$$android_location_GnssMeasurement$getPseudorangeRateUncertaintyMetersPerSecond(), 0, this);
    }

    public void setPseudorangeRateUncertaintyMetersPerSecond(double d) {
        InvokeDynamicSupport.bootstrap("setPseudorangeRateUncertaintyMetersPerSecond", $$robo$$android_location_GnssMeasurement$setPseudorangeRateUncertaintyMetersPerSecond(double ), 0, this, d);
    }

    public int getAccumulatedDeltaRangeState() {
        return (int)InvokeDynamicSupport.bootstrap("getAccumulatedDeltaRangeState", $$robo$$android_location_GnssMeasurement$getAccumulatedDeltaRangeState(), 0, this);
    }

    public void setAccumulatedDeltaRangeState(int n) {
        InvokeDynamicSupport.bootstrap("setAccumulatedDeltaRangeState", $$robo$$android_location_GnssMeasurement$setAccumulatedDeltaRangeState(int ), 0, this, n);
    }

    private String getAccumulatedDeltaRangeStateString() {
        return InvokeDynamicSupport.bootstrap("getAccumulatedDeltaRangeStateString", $$robo$$android_location_GnssMeasurement$getAccumulatedDeltaRangeStateString(), 0, this);
    }

    public double getAccumulatedDeltaRangeMeters() {
        return (double)InvokeDynamicSupport.bootstrap("getAccumulatedDeltaRangeMeters", $$robo$$android_location_GnssMeasurement$getAccumulatedDeltaRangeMeters(), 0, this);
    }

    public void setAccumulatedDeltaRangeMeters(double d) {
        InvokeDynamicSupport.bootstrap("setAccumulatedDeltaRangeMeters", $$robo$$android_location_GnssMeasurement$setAccumulatedDeltaRangeMeters(double ), 0, this, d);
    }

    public double getAccumulatedDeltaRangeUncertaintyMeters() {
        return (double)InvokeDynamicSupport.bootstrap("getAccumulatedDeltaRangeUncertaintyMeters", $$robo$$android_location_GnssMeasurement$getAccumulatedDeltaRangeUncertaintyMeters(), 0, this);
    }

    public void setAccumulatedDeltaRangeUncertaintyMeters(double d) {
        InvokeDynamicSupport.bootstrap("setAccumulatedDeltaRangeUncertaintyMeters", $$robo$$android_location_GnssMeasurement$setAccumulatedDeltaRangeUncertaintyMeters(double ), 0, this, d);
    }

    public boolean hasCarrierFrequencyHz() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierFrequencyHz", $$robo$$android_location_GnssMeasurement$hasCarrierFrequencyHz(), 0, this);
    }

    public float getCarrierFrequencyHz() {
        return (float)InvokeDynamicSupport.bootstrap("getCarrierFrequencyHz", $$robo$$android_location_GnssMeasurement$getCarrierFrequencyHz(), 0, this);
    }

    public void setCarrierFrequencyHz(float f) {
        InvokeDynamicSupport.bootstrap("setCarrierFrequencyHz", $$robo$$android_location_GnssMeasurement$setCarrierFrequencyHz(float ), 0, this, f);
    }

    public void resetCarrierFrequencyHz() {
        InvokeDynamicSupport.bootstrap("resetCarrierFrequencyHz", $$robo$$android_location_GnssMeasurement$resetCarrierFrequencyHz(), 0, this);
    }

    public boolean hasCarrierCycles() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierCycles", $$robo$$android_location_GnssMeasurement$hasCarrierCycles(), 0, this);
    }

    public long getCarrierCycles() {
        return (long)InvokeDynamicSupport.bootstrap("getCarrierCycles", $$robo$$android_location_GnssMeasurement$getCarrierCycles(), 0, this);
    }

    public void setCarrierCycles(long l) {
        InvokeDynamicSupport.bootstrap("setCarrierCycles", $$robo$$android_location_GnssMeasurement$setCarrierCycles(long ), 0, this, l);
    }

    public void resetCarrierCycles() {
        InvokeDynamicSupport.bootstrap("resetCarrierCycles", $$robo$$android_location_GnssMeasurement$resetCarrierCycles(), 0, this);
    }

    public boolean hasCarrierPhase() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierPhase", $$robo$$android_location_GnssMeasurement$hasCarrierPhase(), 0, this);
    }

    public double getCarrierPhase() {
        return (double)InvokeDynamicSupport.bootstrap("getCarrierPhase", $$robo$$android_location_GnssMeasurement$getCarrierPhase(), 0, this);
    }

    public void setCarrierPhase(double d) {
        InvokeDynamicSupport.bootstrap("setCarrierPhase", $$robo$$android_location_GnssMeasurement$setCarrierPhase(double ), 0, this, d);
    }

    public void resetCarrierPhase() {
        InvokeDynamicSupport.bootstrap("resetCarrierPhase", $$robo$$android_location_GnssMeasurement$resetCarrierPhase(), 0, this);
    }

    public boolean hasCarrierPhaseUncertainty() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierPhaseUncertainty", $$robo$$android_location_GnssMeasurement$hasCarrierPhaseUncertainty(), 0, this);
    }

    public double getCarrierPhaseUncertainty() {
        return (double)InvokeDynamicSupport.bootstrap("getCarrierPhaseUncertainty", $$robo$$android_location_GnssMeasurement$getCarrierPhaseUncertainty(), 0, this);
    }

    public void setCarrierPhaseUncertainty(double d) {
        InvokeDynamicSupport.bootstrap("setCarrierPhaseUncertainty", $$robo$$android_location_GnssMeasurement$setCarrierPhaseUncertainty(double ), 0, this, d);
    }

    public void resetCarrierPhaseUncertainty() {
        InvokeDynamicSupport.bootstrap("resetCarrierPhaseUncertainty", $$robo$$android_location_GnssMeasurement$resetCarrierPhaseUncertainty(), 0, this);
    }

    public int getMultipathIndicator() {
        return (int)InvokeDynamicSupport.bootstrap("getMultipathIndicator", $$robo$$android_location_GnssMeasurement$getMultipathIndicator(), 0, this);
    }

    public void setMultipathIndicator(int n) {
        InvokeDynamicSupport.bootstrap("setMultipathIndicator", $$robo$$android_location_GnssMeasurement$setMultipathIndicator(int ), 0, this, n);
    }

    private String getMultipathIndicatorString() {
        return InvokeDynamicSupport.bootstrap("getMultipathIndicatorString", $$robo$$android_location_GnssMeasurement$getMultipathIndicatorString(), 0, this);
    }

    public boolean hasSnrInDb() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSnrInDb", $$robo$$android_location_GnssMeasurement$hasSnrInDb(), 0, this);
    }

    public double getSnrInDb() {
        return (double)InvokeDynamicSupport.bootstrap("getSnrInDb", $$robo$$android_location_GnssMeasurement$getSnrInDb(), 0, this);
    }

    public void setSnrInDb(double d) {
        InvokeDynamicSupport.bootstrap("setSnrInDb", $$robo$$android_location_GnssMeasurement$setSnrInDb(double ), 0, this, d);
    }

    public void resetSnrInDb() {
        InvokeDynamicSupport.bootstrap("resetSnrInDb", $$robo$$android_location_GnssMeasurement$resetSnrInDb(), 0, this);
    }

    public boolean hasAutomaticGainControlLevelDb() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAutomaticGainControlLevelDb", $$robo$$android_location_GnssMeasurement$hasAutomaticGainControlLevelDb(), 0, this);
    }

    public double getAutomaticGainControlLevelDb() {
        return (double)InvokeDynamicSupport.bootstrap("getAutomaticGainControlLevelDb", $$robo$$android_location_GnssMeasurement$getAutomaticGainControlLevelDb(), 0, this);
    }

    public void setAutomaticGainControlLevelInDb(double d) {
        InvokeDynamicSupport.bootstrap("setAutomaticGainControlLevelInDb", $$robo$$android_location_GnssMeasurement$setAutomaticGainControlLevelInDb(double ), 0, this, d);
    }

    public void resetAutomaticGainControlLevel() {
        InvokeDynamicSupport.bootstrap("resetAutomaticGainControlLevel", $$robo$$android_location_GnssMeasurement$resetAutomaticGainControlLevel(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_location_GnssMeasurement$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_location_GnssMeasurement$describeContents(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_location_GnssMeasurement$toString(), 0, this);
    }

    private void initialize() {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_location_GnssMeasurement$initialize(), 0, this);
    }

    private void setFlag(int n) {
        InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_location_GnssMeasurement$setFlag(int ), 0, this, n);
    }

    private void resetFlag(int n) {
        InvokeDynamicSupport.bootstrap("resetFlag", $$robo$$android_location_GnssMeasurement$resetFlag(int ), 0, this, n);
    }

    private boolean isFlagSet(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFlagSet", $$robo$$android_location_GnssMeasurement$isFlagSet(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(GnssMeasurement.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GnssMeasurement)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MultipathIndicator {
    }
}

