/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.Criteria;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.WorkSource;
import android.util.TimeUtils;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class LocationRequest
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ACCURACY_FINE = 100;
    public static int ACCURACY_BLOCK = 102;
    public static int ACCURACY_CITY = 104;
    public static int POWER_NONE = 200;
    public static int POWER_LOW = 201;
    public static int POWER_HIGH = 203;
    private static double FASTEST_INTERVAL_FACTOR = 6.0;
    private int mQuality;
    private long mInterval;
    private long mFastestInterval;
    private boolean mExplicitFastestInterval;
    private long mExpireAt;
    private int mNumUpdates;
    private float mSmallestDisplacement;
    private WorkSource mWorkSource;
    private boolean mHideFromAppOps;
    private String mProvider;
    public static Parcelable.Creator<LocationRequest> CREATOR;

    private static final LocationRequest $$robo$$android_location_LocationRequest$create() {
        LocationRequest request = new LocationRequest();
        return request;
    }

    private static final LocationRequest $$robo$$android_location_LocationRequest$createFromDeprecatedProvider(String provider, long minTime, float minDistance, boolean singleShot) {
        if (minTime < 0L) {
            minTime = 0L;
        }
        if (minDistance < 0.0f) {
            minDistance = 0.0f;
        }
        int quality = "passive".equals(provider) ? 200 : ("gps".equals(provider) ? 100 : 201);
        LocationRequest request = new LocationRequest().setProvider(provider).setQuality(quality).setInterval(minTime).setFastestInterval(minTime).setSmallestDisplacement(minDistance);
        if (singleShot) {
            request.setNumUpdates(1);
        }
        return request;
    }

    private static final LocationRequest $$robo$$android_location_LocationRequest$createFromDeprecatedCriteria(Criteria criteria, long minTime, float minDistance, boolean singleShot) {
        int quality;
        if (minTime < 0L) {
            minTime = 0L;
        }
        if (minDistance < 0.0f) {
            minDistance = 0.0f;
        }
        block0 : switch (criteria.getAccuracy()) {
            case 2: {
                quality = 102;
                break;
            }
            case 1: {
                quality = 100;
                break;
            }
            default: {
                switch (criteria.getPowerRequirement()) {
                    case 3: {
                        quality = 203;
                        break block0;
                    }
                }
                quality = 201;
            }
        }
        LocationRequest request = new LocationRequest().setQuality(quality).setInterval(minTime).setFastestInterval(minTime).setSmallestDisplacement(minDistance);
        if (singleShot) {
            request.setNumUpdates(1);
        }
        return request;
    }

    private void $$robo$$android_location_LocationRequest$__constructor__() {
        this.mQuality = 201;
        this.mInterval = 3600000L;
        this.mFastestInterval = (long)((double)this.mInterval / 6.0);
        this.mExplicitFastestInterval = false;
        this.mExpireAt = Long.MAX_VALUE;
        this.mNumUpdates = Integer.MAX_VALUE;
        this.mSmallestDisplacement = 0.0f;
        this.mWorkSource = null;
        this.mHideFromAppOps = false;
        this.mProvider = "fused";
    }

    private void $$robo$$android_location_LocationRequest$__constructor__(LocationRequest src) {
        this.mQuality = 201;
        this.mInterval = 3600000L;
        this.mFastestInterval = (long)((double)this.mInterval / 6.0);
        this.mExplicitFastestInterval = false;
        this.mExpireAt = Long.MAX_VALUE;
        this.mNumUpdates = Integer.MAX_VALUE;
        this.mSmallestDisplacement = 0.0f;
        this.mWorkSource = null;
        this.mHideFromAppOps = false;
        this.mProvider = "fused";
        this.mQuality = src.mQuality;
        this.mInterval = src.mInterval;
        this.mFastestInterval = src.mFastestInterval;
        this.mExplicitFastestInterval = src.mExplicitFastestInterval;
        this.mExpireAt = src.mExpireAt;
        this.mNumUpdates = src.mNumUpdates;
        this.mSmallestDisplacement = src.mSmallestDisplacement;
        this.mProvider = src.mProvider;
        this.mWorkSource = src.mWorkSource;
        this.mHideFromAppOps = src.mHideFromAppOps;
    }

    private final LocationRequest $$robo$$android_location_LocationRequest$setQuality(int quality) {
        LocationRequest.checkQuality(quality);
        this.mQuality = quality;
        return this;
    }

    private final int $$robo$$android_location_LocationRequest$getQuality() {
        return this.mQuality;
    }

    private final LocationRequest $$robo$$android_location_LocationRequest$setInterval(long millis) {
        LocationRequest.checkInterval(millis);
        this.mInterval = millis;
        if (!this.mExplicitFastestInterval) {
            this.mFastestInterval = (long)((double)this.mInterval / 6.0);
        }
        return this;
    }

    private final long $$robo$$android_location_LocationRequest$getInterval() {
        return this.mInterval;
    }

    private final LocationRequest $$robo$$android_location_LocationRequest$setFastestInterval(long millis) {
        LocationRequest.checkInterval(millis);
        this.mExplicitFastestInterval = true;
        this.mFastestInterval = millis;
        return this;
    }

    private final long $$robo$$android_location_LocationRequest$getFastestInterval() {
        return this.mFastestInterval;
    }

    private final LocationRequest $$robo$$android_location_LocationRequest$setExpireIn(long millis) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        this.mExpireAt = millis > Long.MAX_VALUE - elapsedRealtime ? Long.MAX_VALUE : millis + elapsedRealtime;
        if (this.mExpireAt < 0L) {
            this.mExpireAt = 0L;
        }
        return this;
    }

    private final LocationRequest $$robo$$android_location_LocationRequest$setExpireAt(long millis) {
        this.mExpireAt = millis;
        if (this.mExpireAt < 0L) {
            this.mExpireAt = 0L;
        }
        return this;
    }

    private final long $$robo$$android_location_LocationRequest$getExpireAt() {
        return this.mExpireAt;
    }

    private final LocationRequest $$robo$$android_location_LocationRequest$setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.mNumUpdates = numUpdates;
        return this;
    }

    private final int $$robo$$android_location_LocationRequest$getNumUpdates() {
        return this.mNumUpdates;
    }

    private final void $$robo$$android_location_LocationRequest$decrementNumUpdates() {
        if (this.mNumUpdates != Integer.MAX_VALUE) {
            --this.mNumUpdates;
        }
        if (this.mNumUpdates < 0) {
            this.mNumUpdates = 0;
        }
    }

    private final LocationRequest $$robo$$android_location_LocationRequest$setProvider(String provider) {
        LocationRequest.checkProvider(provider);
        this.mProvider = provider;
        return this;
    }

    private final String $$robo$$android_location_LocationRequest$getProvider() {
        return this.mProvider;
    }

    private final LocationRequest $$robo$$android_location_LocationRequest$setSmallestDisplacement(float meters) {
        LocationRequest.checkDisplacement(meters);
        this.mSmallestDisplacement = meters;
        return this;
    }

    private final float $$robo$$android_location_LocationRequest$getSmallestDisplacement() {
        return this.mSmallestDisplacement;
    }

    private final void $$robo$$android_location_LocationRequest$setWorkSource(WorkSource workSource) {
        this.mWorkSource = workSource;
    }

    private final WorkSource $$robo$$android_location_LocationRequest$getWorkSource() {
        return this.mWorkSource;
    }

    private final void $$robo$$android_location_LocationRequest$setHideFromAppOps(boolean hideFromAppOps) {
        this.mHideFromAppOps = hideFromAppOps;
    }

    private final boolean $$robo$$android_location_LocationRequest$getHideFromAppOps() {
        return this.mHideFromAppOps;
    }

    private static final void $$robo$$android_location_LocationRequest$checkInterval(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("invalid interval: " + millis);
        }
    }

    private static final void $$robo$$android_location_LocationRequest$checkQuality(int quality) {
        switch (quality) {
            case 100: 
            case 102: 
            case 104: 
            case 200: 
            case 201: 
            case 203: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + quality);
            }
        }
    }

    private static final void $$robo$$android_location_LocationRequest$checkDisplacement(float meters) {
        if (meters < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + meters);
        }
    }

    private static final void $$robo$$android_location_LocationRequest$checkProvider(String name) {
        if (name == null) {
            throw new IllegalArgumentException("invalid provider: " + name);
        }
    }

    private final int $$robo$$android_location_LocationRequest$describeContents() {
        return 0;
    }

    private final void $$robo$$android_location_LocationRequest$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mQuality);
        parcel.writeLong(this.mFastestInterval);
        parcel.writeLong(this.mInterval);
        parcel.writeLong(this.mExpireAt);
        parcel.writeInt(this.mNumUpdates);
        parcel.writeFloat(this.mSmallestDisplacement);
        parcel.writeInt(this.mHideFromAppOps ? 1 : 0);
        parcel.writeString(this.mProvider);
        parcel.writeParcelable(this.mWorkSource, 0);
    }

    private static final String $$robo$$android_location_LocationRequest$qualityToString(int quality) {
        switch (quality) {
            case 100: {
                return "ACCURACY_FINE";
            }
            case 102: {
                return "ACCURACY_BLOCK";
            }
            case 104: {
                return "ACCURACY_CITY";
            }
            case 200: {
                return "POWER_NONE";
            }
            case 201: {
                return "POWER_LOW";
            }
            case 203: {
                return "POWER_HIGH";
            }
        }
        return "???";
    }

    private final String $$robo$$android_location_LocationRequest$toString() {
        StringBuilder s = new StringBuilder();
        s.append("Request[").append(LocationRequest.qualityToString(this.mQuality));
        if (this.mProvider != null) {
            s.append(' ').append(this.mProvider);
        }
        if (this.mQuality != 200) {
            s.append(" requested=");
            TimeUtils.formatDuration(this.mInterval, s);
        }
        s.append(" fastest=");
        TimeUtils.formatDuration(this.mFastestInterval, s);
        if (this.mExpireAt != Long.MAX_VALUE) {
            long expireIn = this.mExpireAt - SystemClock.elapsedRealtime();
            s.append(" expireIn=");
            TimeUtils.formatDuration(expireIn, s);
        }
        if (this.mNumUpdates != Integer.MAX_VALUE) {
            s.append(" num=").append(this.mNumUpdates);
        }
        s.append(']');
        return s.toString();
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<LocationRequest>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_location_LocationRequest_1$__constructor__() {
            }

            private final LocationRequest $$robo$$android_location_LocationRequest_1$createFromParcel(Parcel in) {
                WorkSource workSource;
                LocationRequest request = new LocationRequest();
                request.setQuality(in.readInt());
                request.setFastestInterval(in.readLong());
                request.setInterval(in.readLong());
                request.setExpireAt(in.readLong());
                request.setNumUpdates(in.readInt());
                request.setSmallestDisplacement(in.readFloat());
                request.setHideFromAppOps(in.readInt() != 0);
                String provider = in.readString();
                if (provider != null) {
                    request.setProvider(provider);
                }
                if ((workSource = (WorkSource)in.readParcelable(null)) != null) {
                    request.setWorkSource(workSource);
                }
                return request;
            }

            private final LocationRequest[] $$robo$$android_location_LocationRequest_1$newArray(int size) {
                return new LocationRequest[size];
            }

            private void __constructor__() {
                this.$$robo$$android_location_LocationRequest_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationRequest_1$__constructor__(), 0, this);
            }

            @Override
            public LocationRequest createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_location_LocationRequest_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public LocationRequest[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_location_LocationRequest_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static LocationRequest create() {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_location_LocationRequest$create(), 0);
    }

    public static LocationRequest createFromDeprecatedProvider(String string2, long l, float f, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createFromDeprecatedProvider", $$robo$$android_location_LocationRequest$createFromDeprecatedProvider(java.lang.String long float boolean ), 0, (String)string2, (long)l, (float)f, (boolean)bl);
    }

    public static LocationRequest createFromDeprecatedCriteria(Criteria criteria, long l, float f, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createFromDeprecatedCriteria", $$robo$$android_location_LocationRequest$createFromDeprecatedCriteria(android.location.Criteria long float boolean ), 0, (Criteria)criteria, (long)l, (float)f, (boolean)bl);
    }

    private void __constructor__() {
        this.$$robo$$android_location_LocationRequest$__constructor__();
    }

    public LocationRequest() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationRequest$__constructor__(), 0, this);
    }

    private void __constructor__(LocationRequest locationRequest) {
        this.$$robo$$android_location_LocationRequest$__constructor__(locationRequest);
    }

    public LocationRequest(LocationRequest locationRequest) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationRequest$__constructor__(android.location.LocationRequest ), 0, this, locationRequest);
    }

    public LocationRequest setQuality(int n) {
        return InvokeDynamicSupport.bootstrap("setQuality", $$robo$$android_location_LocationRequest$setQuality(int ), 0, this, n);
    }

    public int getQuality() {
        return (int)InvokeDynamicSupport.bootstrap("getQuality", $$robo$$android_location_LocationRequest$getQuality(), 0, this);
    }

    public LocationRequest setInterval(long l) {
        return InvokeDynamicSupport.bootstrap("setInterval", $$robo$$android_location_LocationRequest$setInterval(long ), 0, this, l);
    }

    public long getInterval() {
        return (long)InvokeDynamicSupport.bootstrap("getInterval", $$robo$$android_location_LocationRequest$getInterval(), 0, this);
    }

    public LocationRequest setFastestInterval(long l) {
        return InvokeDynamicSupport.bootstrap("setFastestInterval", $$robo$$android_location_LocationRequest$setFastestInterval(long ), 0, this, l);
    }

    public long getFastestInterval() {
        return (long)InvokeDynamicSupport.bootstrap("getFastestInterval", $$robo$$android_location_LocationRequest$getFastestInterval(), 0, this);
    }

    public LocationRequest setExpireIn(long l) {
        return InvokeDynamicSupport.bootstrap("setExpireIn", $$robo$$android_location_LocationRequest$setExpireIn(long ), 0, this, l);
    }

    public LocationRequest setExpireAt(long l) {
        return InvokeDynamicSupport.bootstrap("setExpireAt", $$robo$$android_location_LocationRequest$setExpireAt(long ), 0, this, l);
    }

    public long getExpireAt() {
        return (long)InvokeDynamicSupport.bootstrap("getExpireAt", $$robo$$android_location_LocationRequest$getExpireAt(), 0, this);
    }

    public LocationRequest setNumUpdates(int n) {
        return InvokeDynamicSupport.bootstrap("setNumUpdates", $$robo$$android_location_LocationRequest$setNumUpdates(int ), 0, this, n);
    }

    public int getNumUpdates() {
        return (int)InvokeDynamicSupport.bootstrap("getNumUpdates", $$robo$$android_location_LocationRequest$getNumUpdates(), 0, this);
    }

    public void decrementNumUpdates() {
        InvokeDynamicSupport.bootstrap("decrementNumUpdates", $$robo$$android_location_LocationRequest$decrementNumUpdates(), 0, this);
    }

    public LocationRequest setProvider(String string2) {
        return InvokeDynamicSupport.bootstrap("setProvider", $$robo$$android_location_LocationRequest$setProvider(java.lang.String ), 0, this, string2);
    }

    public String getProvider() {
        return InvokeDynamicSupport.bootstrap("getProvider", $$robo$$android_location_LocationRequest$getProvider(), 0, this);
    }

    public LocationRequest setSmallestDisplacement(float f) {
        return InvokeDynamicSupport.bootstrap("setSmallestDisplacement", $$robo$$android_location_LocationRequest$setSmallestDisplacement(float ), 0, this, f);
    }

    public float getSmallestDisplacement() {
        return (float)InvokeDynamicSupport.bootstrap("getSmallestDisplacement", $$robo$$android_location_LocationRequest$getSmallestDisplacement(), 0, this);
    }

    public void setWorkSource(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("setWorkSource", $$robo$$android_location_LocationRequest$setWorkSource(android.os.WorkSource ), 0, this, workSource);
    }

    public WorkSource getWorkSource() {
        return InvokeDynamicSupport.bootstrap("getWorkSource", $$robo$$android_location_LocationRequest$getWorkSource(), 0, this);
    }

    public void setHideFromAppOps(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHideFromAppOps", $$robo$$android_location_LocationRequest$setHideFromAppOps(boolean ), 0, this, bl);
    }

    public boolean getHideFromAppOps() {
        return (boolean)InvokeDynamicSupport.bootstrap("getHideFromAppOps", $$robo$$android_location_LocationRequest$getHideFromAppOps(), 0, this);
    }

    private static void checkInterval(long l) {
        InvokeDynamicSupport.bootstrapStatic("checkInterval", $$robo$$android_location_LocationRequest$checkInterval(long ), 0, (long)l);
    }

    private static void checkQuality(int n) {
        InvokeDynamicSupport.bootstrapStatic("checkQuality", $$robo$$android_location_LocationRequest$checkQuality(int ), 0, (int)n);
    }

    private static void checkDisplacement(float f) {
        InvokeDynamicSupport.bootstrapStatic("checkDisplacement", $$robo$$android_location_LocationRequest$checkDisplacement(float ), 0, (float)f);
    }

    private static void checkProvider(String string2) {
        InvokeDynamicSupport.bootstrapStatic("checkProvider", $$robo$$android_location_LocationRequest$checkProvider(java.lang.String ), 0, (String)string2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_location_LocationRequest$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_location_LocationRequest$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public static String qualityToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("qualityToString", $$robo$$android_location_LocationRequest$qualityToString(int ), 0, (int)n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_location_LocationRequest$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(LocationRequest.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocationRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

