/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPatch;
import android.media.AudioPortConfig;
import android.media.MediaRecorder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AudioRecordingConfiguration
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private int mSessionId;
    private int mClientSource;
    private AudioFormat mDeviceFormat;
    private AudioFormat mClientFormat;
    private String mClientPackageName;
    private int mClientUid;
    private int mPatchHandle;
    public static Parcelable.Creator<AudioRecordingConfiguration> CREATOR;

    private void $$robo$$android_media_AudioRecordingConfiguration$__constructor__(int uid, int session, int source, AudioFormat clientFormat, AudioFormat devFormat, int patchHandle, String packageName) {
        this.mClientUid = uid;
        this.mSessionId = session;
        this.mClientSource = source;
        this.mClientFormat = clientFormat;
        this.mDeviceFormat = devFormat;
        this.mPatchHandle = patchHandle;
        this.mClientPackageName = packageName;
    }

    private final void $$robo$$android_media_AudioRecordingConfiguration$dump(PrintWriter pw) {
        pw.println("  " + AudioRecordingConfiguration.toLogFriendlyString(this));
    }

    private static final String $$robo$$android_media_AudioRecordingConfiguration$toLogFriendlyString(AudioRecordingConfiguration arc) {
        return new String("session:" + arc.mSessionId + " -- source:" + MediaRecorder.toLogFriendlyAudioSource(arc.mClientSource) + " -- uid:" + arc.mClientUid + " -- patch:" + arc.mPatchHandle + " -- pack:" + arc.mClientPackageName + " -- format client=" + arc.mClientFormat.toLogFriendlyString() + ", dev=" + arc.mDeviceFormat.toLogFriendlyString());
    }

    private static final AudioRecordingConfiguration $$robo$$android_media_AudioRecordingConfiguration$anonymizedCopy(AudioRecordingConfiguration in) {
        return new AudioRecordingConfiguration(-1, in.mSessionId, in.mClientSource, in.mClientFormat, in.mDeviceFormat, in.mPatchHandle, "");
    }

    private final int $$robo$$android_media_AudioRecordingConfiguration$getClientAudioSource() {
        return this.mClientSource;
    }

    private final int $$robo$$android_media_AudioRecordingConfiguration$getClientAudioSessionId() {
        return this.mSessionId;
    }

    private final AudioFormat $$robo$$android_media_AudioRecordingConfiguration$getFormat() {
        return this.mDeviceFormat;
    }

    private final AudioFormat $$robo$$android_media_AudioRecordingConfiguration$getClientFormat() {
        return this.mClientFormat;
    }

    private final String $$robo$$android_media_AudioRecordingConfiguration$getClientPackageName() {
        return this.mClientPackageName;
    }

    private final int $$robo$$android_media_AudioRecordingConfiguration$getClientUid() {
        return this.mClientUid;
    }

    private final AudioDeviceInfo $$robo$$android_media_AudioRecordingConfiguration$getAudioDevice() {
        ArrayList<AudioPatch> patches = new ArrayList<AudioPatch>();
        if (AudioManager.listAudioPatches(patches) != 0) {
            Log.e(TAG, "Error retrieving list of audio patches");
            return null;
        }
        for (int i = 0; i < patches.size(); ++i) {
            AudioPatch patch = patches.get(i);
            if (patch.id() != this.mPatchHandle) continue;
            AudioPortConfig[] sources = patch.sources();
            if (sources == null || sources.length <= 0) break;
            int devId = sources[0].port().id();
            AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(1);
            for (int j = 0; j < devices.length; ++j) {
                if (devices[j].getId() != devId) continue;
                return devices[j];
            }
            break;
        }
        Log.e(TAG, "Couldn't find device for recording, did recording end already?");
        return null;
    }

    private final int $$robo$$android_media_AudioRecordingConfiguration$hashCode() {
        return Objects.hash(this.mSessionId, this.mClientSource);
    }

    private final int $$robo$$android_media_AudioRecordingConfiguration$describeContents() {
        return 0;
    }

    private final void $$robo$$android_media_AudioRecordingConfiguration$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSessionId);
        dest.writeInt(this.mClientSource);
        this.mClientFormat.writeToParcel(dest, 0);
        this.mDeviceFormat.writeToParcel(dest, 0);
        dest.writeInt(this.mPatchHandle);
        dest.writeString(this.mClientPackageName);
        dest.writeInt(this.mClientUid);
    }

    private void $$robo$$android_media_AudioRecordingConfiguration$__constructor__(Parcel in) {
        this.mSessionId = in.readInt();
        this.mClientSource = in.readInt();
        this.mClientFormat = AudioFormat.CREATOR.createFromParcel(in);
        this.mDeviceFormat = AudioFormat.CREATOR.createFromParcel(in);
        this.mPatchHandle = in.readInt();
        this.mClientPackageName = in.readString();
        this.mClientUid = in.readInt();
    }

    private final boolean $$robo$$android_media_AudioRecordingConfiguration$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AudioRecordingConfiguration)) {
            return false;
        }
        AudioRecordingConfiguration that = (AudioRecordingConfiguration)o;
        return this.mClientUid == that.mClientUid && this.mSessionId == that.mSessionId && this.mClientSource == that.mClientSource && this.mPatchHandle == that.mPatchHandle && this.mClientFormat.equals(that.mClientFormat) && this.mDeviceFormat.equals(that.mDeviceFormat) && this.mClientPackageName.equals(that.mClientPackageName);
    }

    private /* synthetic */ void $$robo$$android_media_AudioRecordingConfiguration$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        TAG = new String("AudioRecordingConfiguration");
        CREATOR = new Parcelable.Creator<AudioRecordingConfiguration>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_AudioRecordingConfiguration_1$__constructor__() {
            }

            private final AudioRecordingConfiguration $$robo$$android_media_AudioRecordingConfiguration_1$createFromParcel(Parcel p) {
                return new AudioRecordingConfiguration(p);
            }

            private final AudioRecordingConfiguration[] $$robo$$android_media_AudioRecordingConfiguration_1$newArray(int size) {
                return new AudioRecordingConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_AudioRecordingConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecordingConfiguration_1$__constructor__(), 0, this);
            }

            @Override
            public AudioRecordingConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_AudioRecordingConfiguration_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AudioRecordingConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_AudioRecordingConfiguration_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, int n3, AudioFormat audioFormat, AudioFormat audioFormat2, int n4, String string2) {
        this.$$robo$$android_media_AudioRecordingConfiguration$__constructor__(n, n2, n3, audioFormat, audioFormat2, n4, string2);
    }

    public AudioRecordingConfiguration(int n, int n2, int n3, AudioFormat audioFormat, AudioFormat audioFormat2, int n4, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecordingConfiguration$__constructor__(int int int android.media.AudioFormat android.media.AudioFormat int java.lang.String ), 0, this, n, n2, n3, audioFormat, audioFormat2, n4, string2);
    }

    public void dump(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_AudioRecordingConfiguration$dump(java.io.PrintWriter ), 0, this, printWriter);
    }

    public static String toLogFriendlyString(AudioRecordingConfiguration audioRecordingConfiguration) {
        return InvokeDynamicSupport.bootstrapStatic("toLogFriendlyString", $$robo$$android_media_AudioRecordingConfiguration$toLogFriendlyString(android.media.AudioRecordingConfiguration ), 0, (AudioRecordingConfiguration)audioRecordingConfiguration);
    }

    public static AudioRecordingConfiguration anonymizedCopy(AudioRecordingConfiguration audioRecordingConfiguration) {
        return InvokeDynamicSupport.bootstrapStatic("anonymizedCopy", $$robo$$android_media_AudioRecordingConfiguration$anonymizedCopy(android.media.AudioRecordingConfiguration ), 0, (AudioRecordingConfiguration)audioRecordingConfiguration);
    }

    public int getClientAudioSource() {
        return (int)InvokeDynamicSupport.bootstrap("getClientAudioSource", $$robo$$android_media_AudioRecordingConfiguration$getClientAudioSource(), 0, this);
    }

    public int getClientAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getClientAudioSessionId", $$robo$$android_media_AudioRecordingConfiguration$getClientAudioSessionId(), 0, this);
    }

    public AudioFormat getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_AudioRecordingConfiguration$getFormat(), 0, this);
    }

    public AudioFormat getClientFormat() {
        return InvokeDynamicSupport.bootstrap("getClientFormat", $$robo$$android_media_AudioRecordingConfiguration$getClientFormat(), 0, this);
    }

    public String getClientPackageName() {
        return InvokeDynamicSupport.bootstrap("getClientPackageName", $$robo$$android_media_AudioRecordingConfiguration$getClientPackageName(), 0, this);
    }

    public int getClientUid() {
        return (int)InvokeDynamicSupport.bootstrap("getClientUid", $$robo$$android_media_AudioRecordingConfiguration$getClientUid(), 0, this);
    }

    public AudioDeviceInfo getAudioDevice() {
        return InvokeDynamicSupport.bootstrap("getAudioDevice", $$robo$$android_media_AudioRecordingConfiguration$getAudioDevice(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_AudioRecordingConfiguration$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_AudioRecordingConfiguration$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_AudioRecordingConfiguration$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_AudioRecordingConfiguration$__constructor__(parcel);
    }

    private AudioRecordingConfiguration(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecordingConfiguration$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_AudioRecordingConfiguration$equals(java.lang.Object ), 0, this, object);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_AudioRecordingConfiguration$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AudioRecordingConfiguration.class);
    }

    public /* synthetic */ AudioRecordingConfiguration() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioRecordingConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioSource {
    }
}

