/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.AudioPatch;
import android.media.AudioPort;
import android.media.AudioPortConfig;
import android.media.audiopolicy.AudioMix;
import android.util.Log;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioSystem
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AudioSystem";
    public static int STREAM_DEFAULT = -1;
    public static int STREAM_VOICE_CALL = 0;
    public static int STREAM_SYSTEM = 1;
    public static int STREAM_RING = 2;
    public static int STREAM_MUSIC = 3;
    public static int STREAM_ALARM = 4;
    public static int STREAM_NOTIFICATION = 5;
    public static int STREAM_BLUETOOTH_SCO = 6;
    public static int STREAM_SYSTEM_ENFORCED = 7;
    public static int STREAM_DTMF = 8;
    public static int STREAM_TTS = 9;
    public static int STREAM_ACCESSIBILITY = 10;
    public static int NUM_STREAMS = 5;
    private static int NUM_STREAM_TYPES = 11;
    public static String[] STREAM_NAMES;
    public static int MODE_INVALID = -2;
    public static int MODE_CURRENT = -1;
    public static int MODE_NORMAL = 0;
    public static int MODE_RINGTONE = 1;
    public static int MODE_IN_CALL = 2;
    public static int MODE_IN_COMMUNICATION = 3;
    public static int NUM_MODES = 4;
    @Deprecated
    public static int ROUTE_EARPIECE = 1;
    @Deprecated
    public static int ROUTE_SPEAKER = 2;
    @Deprecated
    public static int ROUTE_BLUETOOTH = 4;
    @Deprecated
    public static int ROUTE_BLUETOOTH_SCO = 4;
    @Deprecated
    public static int ROUTE_HEADSET = 8;
    @Deprecated
    public static int ROUTE_BLUETOOTH_A2DP = 16;
    @Deprecated
    public static int ROUTE_ALL = -1;
    public static int AUDIO_SESSION_ALLOCATE = 0;
    public static int AUDIO_STATUS_OK = 0;
    public static int AUDIO_STATUS_ERROR = 1;
    public static int AUDIO_STATUS_SERVER_DIED = 100;
    private static ErrorCallback mErrorCallback;
    private static int DYNAMIC_POLICY_EVENT_MIX_STATE_UPDATE = 0;
    private static DynamicPolicyCallback sDynPolicyCallback;
    private static AudioRecordingCallback sRecordingCallback;
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int BAD_VALUE = -2;
    public static int INVALID_OPERATION = -3;
    public static int PERMISSION_DENIED = -4;
    public static int NO_INIT = -5;
    public static int DEAD_OBJECT = -6;
    public static int WOULD_BLOCK = -7;
    public static int DEVICE_NONE = 0;
    public static int DEVICE_BIT_IN = Integer.MIN_VALUE;
    public static int DEVICE_BIT_DEFAULT = 0x40000000;
    public static int DEVICE_OUT_EARPIECE = 1;
    public static int DEVICE_OUT_SPEAKER = 2;
    public static int DEVICE_OUT_WIRED_HEADSET = 4;
    public static int DEVICE_OUT_WIRED_HEADPHONE = 8;
    public static int DEVICE_OUT_BLUETOOTH_SCO = 16;
    public static int DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    public static int DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    public static int DEVICE_OUT_BLUETOOTH_A2DP = 128;
    public static int DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    public static int DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    public static int DEVICE_OUT_AUX_DIGITAL = 1024;
    public static int DEVICE_OUT_HDMI = 1024;
    public static int DEVICE_OUT_ANLG_DOCK_HEADSET = 2048;
    public static int DEVICE_OUT_DGTL_DOCK_HEADSET = 4096;
    public static int DEVICE_OUT_USB_ACCESSORY = 8192;
    public static int DEVICE_OUT_USB_DEVICE = 16384;
    public static int DEVICE_OUT_REMOTE_SUBMIX = 32768;
    public static int DEVICE_OUT_TELEPHONY_TX = 65536;
    public static int DEVICE_OUT_LINE = 131072;
    public static int DEVICE_OUT_HDMI_ARC = 262144;
    public static int DEVICE_OUT_SPDIF = 524288;
    public static int DEVICE_OUT_FM = 0x100000;
    public static int DEVICE_OUT_AUX_LINE = 0x200000;
    public static int DEVICE_OUT_SPEAKER_SAFE = 0x400000;
    public static int DEVICE_OUT_IP = 0x800000;
    public static int DEVICE_OUT_BUS = 0x1000000;
    public static int DEVICE_OUT_PROXY = 0x2000000;
    public static int DEVICE_OUT_USB_HEADSET = 0x4000000;
    public static int DEVICE_OUT_DEFAULT = 0x40000000;
    public static int DEVICE_OUT_ALL = 0x47FFFFFF;
    public static int DEVICE_OUT_ALL_A2DP = 896;
    public static int DEVICE_OUT_ALL_SCO = 112;
    public static int DEVICE_OUT_ALL_USB = 0x4006000;
    public static int DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO = 0x2C0000;
    public static int DEVICE_ALL_HDMI_SYSTEM_AUDIO_AND_SPEAKER = 0x2C0002;
    public static int DEVICE_IN_COMMUNICATION = -2147483647;
    public static int DEVICE_IN_AMBIENT = -2147483646;
    public static int DEVICE_IN_BUILTIN_MIC = -2147483644;
    public static int DEVICE_IN_BLUETOOTH_SCO_HEADSET = -2147483640;
    public static int DEVICE_IN_WIRED_HEADSET = -2147483632;
    public static int DEVICE_IN_AUX_DIGITAL = -2147483616;
    public static int DEVICE_IN_HDMI = -2147483616;
    public static int DEVICE_IN_VOICE_CALL = -2147483584;
    public static int DEVICE_IN_TELEPHONY_RX = -2147483584;
    public static int DEVICE_IN_BACK_MIC = -2147483520;
    public static int DEVICE_IN_REMOTE_SUBMIX = -2147483392;
    public static int DEVICE_IN_ANLG_DOCK_HEADSET = -2147483136;
    public static int DEVICE_IN_DGTL_DOCK_HEADSET = -2147482624;
    public static int DEVICE_IN_USB_ACCESSORY = -2147481600;
    public static int DEVICE_IN_USB_DEVICE = -2147479552;
    public static int DEVICE_IN_FM_TUNER = -2147475456;
    public static int DEVICE_IN_TV_TUNER = -2147467264;
    public static int DEVICE_IN_LINE = -2147450880;
    public static int DEVICE_IN_SPDIF = -2147418112;
    public static int DEVICE_IN_BLUETOOTH_A2DP = -2147352576;
    public static int DEVICE_IN_LOOPBACK = -2147221504;
    public static int DEVICE_IN_IP = -2146959360;
    public static int DEVICE_IN_BUS = -2146435072;
    public static int DEVICE_IN_PROXY = -2130706432;
    public static int DEVICE_IN_USB_HEADSET = -2113929216;
    public static int DEVICE_IN_DEFAULT = -1073741824;
    public static int DEVICE_IN_ALL = -1021313025;
    public static int DEVICE_IN_ALL_SCO = -2147483640;
    public static int DEVICE_IN_ALL_USB = -2113923072;
    public static int DEVICE_STATE_UNAVAILABLE = 0;
    public static int DEVICE_STATE_AVAILABLE = 1;
    private static int NUM_DEVICE_STATES = 1;
    public static String DEVICE_OUT_EARPIECE_NAME = "earpiece";
    public static String DEVICE_OUT_SPEAKER_NAME = "speaker";
    public static String DEVICE_OUT_WIRED_HEADSET_NAME = "headset";
    public static String DEVICE_OUT_WIRED_HEADPHONE_NAME = "headphone";
    public static String DEVICE_OUT_BLUETOOTH_SCO_NAME = "bt_sco";
    public static String DEVICE_OUT_BLUETOOTH_SCO_HEADSET_NAME = "bt_sco_hs";
    public static String DEVICE_OUT_BLUETOOTH_SCO_CARKIT_NAME = "bt_sco_carkit";
    public static String DEVICE_OUT_BLUETOOTH_A2DP_NAME = "bt_a2dp";
    public static String DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES_NAME = "bt_a2dp_hp";
    public static String DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER_NAME = "bt_a2dp_spk";
    public static String DEVICE_OUT_AUX_DIGITAL_NAME = "aux_digital";
    public static String DEVICE_OUT_HDMI_NAME = "hdmi";
    public static String DEVICE_OUT_ANLG_DOCK_HEADSET_NAME = "analog_dock";
    public static String DEVICE_OUT_DGTL_DOCK_HEADSET_NAME = "digital_dock";
    public static String DEVICE_OUT_USB_ACCESSORY_NAME = "usb_accessory";
    public static String DEVICE_OUT_USB_DEVICE_NAME = "usb_device";
    public static String DEVICE_OUT_REMOTE_SUBMIX_NAME = "remote_submix";
    public static String DEVICE_OUT_TELEPHONY_TX_NAME = "telephony_tx";
    public static String DEVICE_OUT_LINE_NAME = "line";
    public static String DEVICE_OUT_HDMI_ARC_NAME = "hmdi_arc";
    public static String DEVICE_OUT_SPDIF_NAME = "spdif";
    public static String DEVICE_OUT_FM_NAME = "fm_transmitter";
    public static String DEVICE_OUT_AUX_LINE_NAME = "aux_line";
    public static String DEVICE_OUT_SPEAKER_SAFE_NAME = "speaker_safe";
    public static String DEVICE_OUT_IP_NAME = "ip";
    public static String DEVICE_OUT_BUS_NAME = "bus";
    public static String DEVICE_OUT_PROXY_NAME = "proxy";
    public static String DEVICE_OUT_USB_HEADSET_NAME = "usb_headset";
    public static String DEVICE_IN_COMMUNICATION_NAME = "communication";
    public static String DEVICE_IN_AMBIENT_NAME = "ambient";
    public static String DEVICE_IN_BUILTIN_MIC_NAME = "mic";
    public static String DEVICE_IN_BLUETOOTH_SCO_HEADSET_NAME = "bt_sco_hs";
    public static String DEVICE_IN_WIRED_HEADSET_NAME = "headset";
    public static String DEVICE_IN_AUX_DIGITAL_NAME = "aux_digital";
    public static String DEVICE_IN_TELEPHONY_RX_NAME = "telephony_rx";
    public static String DEVICE_IN_BACK_MIC_NAME = "back_mic";
    public static String DEVICE_IN_REMOTE_SUBMIX_NAME = "remote_submix";
    public static String DEVICE_IN_ANLG_DOCK_HEADSET_NAME = "analog_dock";
    public static String DEVICE_IN_DGTL_DOCK_HEADSET_NAME = "digital_dock";
    public static String DEVICE_IN_USB_ACCESSORY_NAME = "usb_accessory";
    public static String DEVICE_IN_USB_DEVICE_NAME = "usb_device";
    public static String DEVICE_IN_FM_TUNER_NAME = "fm_tuner";
    public static String DEVICE_IN_TV_TUNER_NAME = "tv_tuner";
    public static String DEVICE_IN_LINE_NAME = "line";
    public static String DEVICE_IN_SPDIF_NAME = "spdif";
    public static String DEVICE_IN_BLUETOOTH_A2DP_NAME = "bt_a2dp";
    public static String DEVICE_IN_LOOPBACK_NAME = "loopback";
    public static String DEVICE_IN_IP_NAME = "ip";
    public static String DEVICE_IN_BUS_NAME = "bus";
    public static String DEVICE_IN_PROXY_NAME = "proxy";
    public static String DEVICE_IN_USB_HEADSET_NAME = "usb_headset";
    public static int PHONE_STATE_OFFCALL = 0;
    public static int PHONE_STATE_RINGING = 1;
    public static int PHONE_STATE_INCALL = 2;
    public static int FORCE_NONE = 0;
    public static int FORCE_SPEAKER = 1;
    public static int FORCE_HEADPHONES = 2;
    public static int FORCE_BT_SCO = 3;
    public static int FORCE_BT_A2DP = 4;
    public static int FORCE_WIRED_ACCESSORY = 5;
    public static int FORCE_BT_CAR_DOCK = 6;
    public static int FORCE_BT_DESK_DOCK = 7;
    public static int FORCE_ANALOG_DOCK = 8;
    public static int FORCE_DIGITAL_DOCK = 9;
    public static int FORCE_NO_BT_A2DP = 10;
    public static int FORCE_SYSTEM_ENFORCED = 11;
    public static int FORCE_HDMI_SYSTEM_AUDIO_ENFORCED = 12;
    public static int FORCE_ENCODED_SURROUND_NEVER = 13;
    public static int FORCE_ENCODED_SURROUND_ALWAYS = 14;
    public static int NUM_FORCE_CONFIG = 15;
    public static int FORCE_DEFAULT = 0;
    public static int FOR_COMMUNICATION = 0;
    public static int FOR_MEDIA = 1;
    public static int FOR_RECORD = 2;
    public static int FOR_DOCK = 3;
    public static int FOR_SYSTEM = 4;
    public static int FOR_HDMI_SYSTEM_AUDIO = 5;
    public static int FOR_ENCODED_SURROUND = 6;
    private static int NUM_FORCE_USE = 7;
    public static int SYNC_EVENT_NONE = 0;
    public static int SYNC_EVENT_PRESENTATION_COMPLETE = 1;
    public static int AUDIO_HW_SYNC_INVALID = 0;
    public static int PLAY_SOUND_DELAY = 300;
    public static String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    public static int[] DEFAULT_STREAM_VOLUME;
    public static int PLATFORM_DEFAULT = 0;
    public static int PLATFORM_VOICE = 1;
    public static int PLATFORM_TELEVISION = 2;
    public static int DEFAULT_MUTE_STREAMS_AFFECTED = 46;
    static int NATIVE_EVENT_ROUTING_CHANGE = 1000;

    private void $$robo$$android_media_AudioSystem$__constructor__() {
    }

    private static final int $$robo$$android_media_AudioSystem$getNumStreamTypes() {
        return 11;
    }

    private static final int $$robo$$android_media_AudioSystem$muteMicrophone(boolean bl) {
        return 0;
    }

    private static final boolean $$robo$$android_media_AudioSystem$isMicrophoneMuted() {
        return false;
    }

    private static final String $$robo$$android_media_AudioSystem$modeToString(int mode) {
        switch (mode) {
            case -1: {
                return "MODE_CURRENT";
            }
            case 2: {
                return "MODE_IN_CALL";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
            case -2: {
                return "MODE_INVALID";
            }
            case 0: {
                return "MODE_NORMAL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
        }
        return "unknown mode (" + mode + ")";
    }

    private static final boolean $$robo$$android_media_AudioSystem$isStreamActive(int n, int n2) {
        return false;
    }

    private static final boolean $$robo$$android_media_AudioSystem$isStreamActiveRemotely(int n, int n2) {
        return false;
    }

    private static final boolean $$robo$$android_media_AudioSystem$isSourceActive(int n) {
        return false;
    }

    private static final int $$robo$$android_media_AudioSystem$newAudioSessionId() {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$newAudioPlayerId() {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$setParameters(String string2) {
        return 0;
    }

    private static final String $$robo$$android_media_AudioSystem$getParameters(String string2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_AudioSystem$setErrorCallback(ErrorCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            mErrorCallback = cb;
            if (cb != null) {
                cb.onError(AudioSystem.checkAudioFlinger());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_AudioSystem$errorCallbackFromNative(int error) {
        ErrorCallback errorCallback = null;
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            if (mErrorCallback != null) {
                errorCallback = mErrorCallback;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (errorCallback != null) {
                errorCallback.onError(error);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_AudioSystem$setDynamicPolicyCallback(DynamicPolicyCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            sDynPolicyCallback = cb;
            AudioSystem.native_register_dynamic_policy_callback();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_AudioSystem$dynamicPolicyCallbackFromNative(int event, String regId, int val) {
        DynamicPolicyCallback cb = null;
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            if (sDynPolicyCallback != null) {
                cb = sDynPolicyCallback;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (cb != null) {
                switch (event) {
                    case 0: {
                        cb.onDynamicPolicyMixStateUpdate(regId, val);
                        break;
                    }
                    default: {
                        Log.e("AudioSystem", "dynamicPolicyCallbackFromNative: unknown event " + event);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_AudioSystem$setRecordingCallback(AudioRecordingCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            sRecordingCallback = cb;
            AudioSystem.native_register_recording_callback();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_AudioSystem$recordingCallbackFromNative(int event, int uid, int session, int source, int[] recordingFormat) {
        AudioRecordingCallback cb = null;
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            cb = sRecordingCallback;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (cb != null) {
                cb.onRecordingConfigurationChanged(event, uid, session, source, recordingFormat, "");
            }
            return;
        }
    }

    private static final String $$robo$$android_media_AudioSystem$deviceStateToString(int state) {
        switch (state) {
            case 0: {
                return "DEVICE_STATE_UNAVAILABLE";
            }
            case 1: {
                return "DEVICE_STATE_AVAILABLE";
            }
        }
        return "unknown state (" + state + ")";
    }

    private static final String $$robo$$android_media_AudioSystem$getOutputDeviceName(int device) {
        switch (device) {
            case 1: {
                return "earpiece";
            }
            case 2: {
                return "speaker";
            }
            case 4: {
                return "headset";
            }
            case 8: {
                return "headphone";
            }
            case 16: {
                return "bt_sco";
            }
            case 32: {
                return "bt_sco_hs";
            }
            case 64: {
                return "bt_sco_carkit";
            }
            case 128: {
                return "bt_a2dp";
            }
            case 256: {
                return "bt_a2dp_hp";
            }
            case 512: {
                return "bt_a2dp_spk";
            }
            case 1024: {
                return "hdmi";
            }
            case 2048: {
                return "analog_dock";
            }
            case 4096: {
                return "digital_dock";
            }
            case 8192: {
                return "usb_accessory";
            }
            case 16384: {
                return "usb_device";
            }
            case 32768: {
                return "remote_submix";
            }
            case 65536: {
                return "telephony_tx";
            }
            case 131072: {
                return "line";
            }
            case 262144: {
                return "hmdi_arc";
            }
            case 524288: {
                return "spdif";
            }
            case 0x100000: {
                return "fm_transmitter";
            }
            case 0x200000: {
                return "aux_line";
            }
            case 0x400000: {
                return "speaker_safe";
            }
            case 0x800000: {
                return "ip";
            }
            case 0x1000000: {
                return "bus";
            }
            case 0x2000000: {
                return "proxy";
            }
            case 0x4000000: {
                return "usb_headset";
            }
        }
        return Integer.toString(device);
    }

    private static final String $$robo$$android_media_AudioSystem$getInputDeviceName(int device) {
        switch (device) {
            case -2147483647: {
                return "communication";
            }
            case -2147483646: {
                return "ambient";
            }
            case -2147483644: {
                return "mic";
            }
            case -2147483640: {
                return "bt_sco_hs";
            }
            case -2147483632: {
                return "headset";
            }
            case -2147483616: {
                return "aux_digital";
            }
            case -2147483584: {
                return "telephony_rx";
            }
            case -2147483520: {
                return "back_mic";
            }
            case -2147483392: {
                return "remote_submix";
            }
            case -2147483136: {
                return "analog_dock";
            }
            case -2147482624: {
                return "digital_dock";
            }
            case -2147481600: {
                return "usb_accessory";
            }
            case -2147479552: {
                return "usb_device";
            }
            case -2147475456: {
                return "fm_tuner";
            }
            case -2147467264: {
                return "tv_tuner";
            }
            case -2147450880: {
                return "line";
            }
            case -2147418112: {
                return "spdif";
            }
            case -2147352576: {
                return "bt_a2dp";
            }
            case -2147221504: {
                return "loopback";
            }
            case -2146959360: {
                return "ip";
            }
            case -2146435072: {
                return "bus";
            }
            case -2130706432: {
                return "proxy";
            }
            case -2113929216: {
                return "usb_headset";
            }
        }
        return Integer.toString(device);
    }

    private static final String $$robo$$android_media_AudioSystem$forceUseConfigToString(int config) {
        switch (config) {
            case 0: {
                return "FORCE_NONE";
            }
            case 1: {
                return "FORCE_SPEAKER";
            }
            case 2: {
                return "FORCE_HEADPHONES";
            }
            case 3: {
                return "FORCE_BT_SCO";
            }
            case 4: {
                return "FORCE_BT_A2DP";
            }
            case 5: {
                return "FORCE_WIRED_ACCESSORY";
            }
            case 6: {
                return "FORCE_BT_CAR_DOCK";
            }
            case 7: {
                return "FORCE_BT_DESK_DOCK";
            }
            case 8: {
                return "FORCE_ANALOG_DOCK";
            }
            case 9: {
                return "FORCE_DIGITAL_DOCK";
            }
            case 10: {
                return "FORCE_NO_BT_A2DP";
            }
            case 11: {
                return "FORCE_SYSTEM_ENFORCED";
            }
            case 12: {
                return "FORCE_HDMI_SYSTEM_AUDIO_ENFORCED";
            }
            case 13: {
                return "FORCE_ENCODED_SURROUND_NEVER";
            }
            case 14: {
                return "FORCE_ENCODED_SURROUND_ALWAYS";
            }
        }
        return "unknown config (" + config + ")";
    }

    private static final String $$robo$$android_media_AudioSystem$forceUseUsageToString(int usage) {
        switch (usage) {
            case 0: {
                return "FOR_COMMUNICATION";
            }
            case 1: {
                return "FOR_MEDIA";
            }
            case 2: {
                return "FOR_RECORD";
            }
            case 3: {
                return "FOR_DOCK";
            }
            case 4: {
                return "FOR_SYSTEM";
            }
            case 5: {
                return "FOR_HDMI_SYSTEM_AUDIO";
            }
            case 6: {
                return "FOR_ENCODED_SURROUND";
            }
        }
        return "unknown usage (" + usage + ")";
    }

    private static final int $$robo$$android_media_AudioSystem$setDeviceConnectionState(int n, int n2, String string2, String string3) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$getDeviceConnectionState(int n, String string2) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$handleDeviceConfigChange(int n, String string2, String string3) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$setPhoneState(int n) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$setForceUse(int n, int n2) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$getForceUse(int n) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$initStreamVolume(int n, int n2, int n3) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$setStreamVolumeIndex(int n, int n2, int n3) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$getStreamVolumeIndex(int n, int n2) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$setMasterVolume(float f) {
        return 0;
    }

    private static final float $$robo$$android_media_AudioSystem$getMasterVolume() {
        return 0.0f;
    }

    private static final int $$robo$$android_media_AudioSystem$setMasterMute(boolean bl) {
        return 0;
    }

    private static final boolean $$robo$$android_media_AudioSystem$getMasterMute() {
        return false;
    }

    private static final int $$robo$$android_media_AudioSystem$getDevicesForStream(int n) {
        return 0;
    }

    private static final boolean $$robo$$android_media_AudioSystem$getMasterMono() {
        return false;
    }

    private static final int $$robo$$android_media_AudioSystem$setMasterMono(boolean bl) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$getPrimaryOutputSamplingRate() {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$getPrimaryOutputFrameCount() {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$getOutputLatency(int n) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$setLowRamDevice(boolean bl) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$checkAudioFlinger() {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$listAudioPorts(ArrayList<AudioPort> arrayList, int[] nArray) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$createAudioPatch(AudioPatch[] audioPatchArray, AudioPortConfig[] audioPortConfigArray, AudioPortConfig[] audioPortConfigArray2) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$releaseAudioPatch(AudioPatch audioPatch) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$listAudioPatches(ArrayList<AudioPatch> arrayList, int[] nArray) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$setAudioPortConfig(AudioPortConfig audioPortConfig) {
        return 0;
    }

    private static final void $$robo$$android_media_AudioSystem$native_register_dynamic_policy_callback() {
    }

    private static final void $$robo$$android_media_AudioSystem$native_register_recording_callback() {
    }

    private static final int $$robo$$android_media_AudioSystem$getAudioHwSyncForSession(int n) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$registerPolicyMixes(ArrayList<AudioMix> arrayList, boolean bl) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioSystem$systemReady() {
        return 0;
    }

    private static final float $$robo$$android_media_AudioSystem$getStreamVolumeDB(int n, int n2, int n3) {
        return 0.0f;
    }

    private static final int $$robo$$android_media_AudioSystem$getValueForVibrateSetting(int existingValue, int vibrateType, int vibrateSetting) {
        existingValue &= ~(3 << vibrateType * 2);
        return existingValue |= (vibrateSetting & 3) << vibrateType * 2;
    }

    private static final int $$robo$$android_media_AudioSystem$getDefaultStreamVolume(int streamType) {
        return DEFAULT_STREAM_VOLUME[streamType];
    }

    private static final String $$robo$$android_media_AudioSystem$streamToString(int stream) {
        if (stream >= 0 && stream < STREAM_NAMES.length) {
            return STREAM_NAMES[stream];
        }
        if (stream == Integer.MIN_VALUE) {
            return "USE_DEFAULT_STREAM_TYPE";
        }
        return "UNKNOWN_STREAM_" + stream;
    }

    private static final int $$robo$$android_media_AudioSystem$getPlatformType(Context context) {
        if (context.getResources().getBoolean(17957054)) {
            return 1;
        }
        if (context.getPackageManager().hasSystemFeature("android.software.leanback")) {
            return 2;
        }
        return 0;
    }

    private static final boolean $$robo$$android_media_AudioSystem$isSingleVolume(Context context) {
        boolean forceSingleVolume = context.getResources().getBoolean(17957011);
        return AudioSystem.getPlatformType(context) == 2 || forceSingleVolume;
    }

    static void __staticInitializer__() {
        STREAM_NAMES = new String[]{"STREAM_VOICE_CALL", "STREAM_SYSTEM", "STREAM_RING", "STREAM_MUSIC", "STREAM_ALARM", "STREAM_NOTIFICATION", "STREAM_BLUETOOTH_SCO", "STREAM_SYSTEM_ENFORCED", "STREAM_DTMF", "STREAM_TTS", "STREAM_ACCESSIBILITY"};
        DEFAULT_STREAM_VOLUME = new int[]{4, 7, 5, 5, 6, 5, 7, 7, 5, 5, 5};
    }

    private void __constructor__() {
        this.$$robo$$android_media_AudioSystem$__constructor__();
    }

    public AudioSystem() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioSystem$__constructor__(), 0, this);
    }

    public static int getNumStreamTypes() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNumStreamTypes", $$robo$$android_media_AudioSystem$getNumStreamTypes(), 0);
    }

    private static final native /* synthetic */ int $$robo$$muteMicrophone$nativeBinding(boolean var0);

    public static int muteMicrophone(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("muteMicrophone", $$robo$$android_media_AudioSystem$muteMicrophone(boolean ), 1, (boolean)bl);
    }

    private static final native /* synthetic */ boolean $$robo$$isMicrophoneMuted$nativeBinding();

    public static boolean isMicrophoneMuted() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMicrophoneMuted", $$robo$$android_media_AudioSystem$isMicrophoneMuted(), 1);
    }

    public static String modeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("modeToString", $$robo$$android_media_AudioSystem$modeToString(int ), 0, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$isStreamActive$nativeBinding(int var0, int var1);

    public static boolean isStreamActive(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStreamActive", $$robo$$android_media_AudioSystem$isStreamActive(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ boolean $$robo$$isStreamActiveRemotely$nativeBinding(int var0, int var1);

    public static boolean isStreamActiveRemotely(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStreamActiveRemotely", $$robo$$android_media_AudioSystem$isStreamActiveRemotely(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ boolean $$robo$$isSourceActive$nativeBinding(int var0);

    public static boolean isSourceActive(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSourceActive", $$robo$$android_media_AudioSystem$isSourceActive(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$newAudioSessionId$nativeBinding();

    public static int newAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("newAudioSessionId", $$robo$$android_media_AudioSystem$newAudioSessionId(), 1);
    }

    private static final native /* synthetic */ int $$robo$$newAudioPlayerId$nativeBinding();

    public static int newAudioPlayerId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("newAudioPlayerId", $$robo$$android_media_AudioSystem$newAudioPlayerId(), 1);
    }

    private static final native /* synthetic */ int $$robo$$setParameters$nativeBinding(String var0);

    public static int setParameters(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setParameters", $$robo$$android_media_AudioSystem$setParameters(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$getParameters$nativeBinding(String var0);

    public static String getParameters(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getParameters", $$robo$$android_media_AudioSystem$getParameters(java.lang.String ), 1, (String)string2);
    }

    public static void setErrorCallback(ErrorCallback errorCallback) {
        InvokeDynamicSupport.bootstrapStatic("setErrorCallback", $$robo$$android_media_AudioSystem$setErrorCallback(android.media.AudioSystem$ErrorCallback ), 0, (ErrorCallback)errorCallback);
    }

    private static void errorCallbackFromNative(int n) {
        InvokeDynamicSupport.bootstrapStatic("errorCallbackFromNative", $$robo$$android_media_AudioSystem$errorCallbackFromNative(int ), 0, (int)n);
    }

    public static void setDynamicPolicyCallback(DynamicPolicyCallback dynamicPolicyCallback) {
        InvokeDynamicSupport.bootstrapStatic("setDynamicPolicyCallback", $$robo$$android_media_AudioSystem$setDynamicPolicyCallback(android.media.AudioSystem$DynamicPolicyCallback ), 0, (DynamicPolicyCallback)dynamicPolicyCallback);
    }

    private static void dynamicPolicyCallbackFromNative(int n, String string2, int n2) {
        InvokeDynamicSupport.bootstrapStatic("dynamicPolicyCallbackFromNative", $$robo$$android_media_AudioSystem$dynamicPolicyCallbackFromNative(int java.lang.String int ), 0, (int)n, (String)string2, (int)n2);
    }

    public static void setRecordingCallback(AudioRecordingCallback audioRecordingCallback) {
        InvokeDynamicSupport.bootstrapStatic("setRecordingCallback", $$robo$$android_media_AudioSystem$setRecordingCallback(android.media.AudioSystem$AudioRecordingCallback ), 0, (AudioRecordingCallback)audioRecordingCallback);
    }

    private static void recordingCallbackFromNative(int n, int n2, int n3, int n4, int[] nArray) {
        InvokeDynamicSupport.bootstrapStatic("recordingCallbackFromNative", $$robo$$android_media_AudioSystem$recordingCallbackFromNative(int int int int int[] ), 0, (int)n, (int)n2, (int)n3, (int)n4, (int[])nArray);
    }

    public static String deviceStateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("deviceStateToString", $$robo$$android_media_AudioSystem$deviceStateToString(int ), 0, (int)n);
    }

    public static String getOutputDeviceName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getOutputDeviceName", $$robo$$android_media_AudioSystem$getOutputDeviceName(int ), 0, (int)n);
    }

    public static String getInputDeviceName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInputDeviceName", $$robo$$android_media_AudioSystem$getInputDeviceName(int ), 0, (int)n);
    }

    public static String forceUseConfigToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("forceUseConfigToString", $$robo$$android_media_AudioSystem$forceUseConfigToString(int ), 0, (int)n);
    }

    public static String forceUseUsageToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("forceUseUsageToString", $$robo$$android_media_AudioSystem$forceUseUsageToString(int ), 0, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$setDeviceConnectionState$nativeBinding(int var0, int var1, String var2, String var3);

    public static int setDeviceConnectionState(int n, int n2, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setDeviceConnectionState", $$robo$$android_media_AudioSystem$setDeviceConnectionState(int int java.lang.String java.lang.String ), 1, (int)n, (int)n2, (String)string2, (String)string3);
    }

    private static final native /* synthetic */ int $$robo$$getDeviceConnectionState$nativeBinding(int var0, String var1);

    public static int getDeviceConnectionState(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDeviceConnectionState", $$robo$$android_media_AudioSystem$getDeviceConnectionState(int java.lang.String ), 1, (int)n, (String)string2);
    }

    private static final native /* synthetic */ int $$robo$$handleDeviceConfigChange$nativeBinding(int var0, String var1, String var2);

    public static int handleDeviceConfigChange(int n, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("handleDeviceConfigChange", $$robo$$android_media_AudioSystem$handleDeviceConfigChange(int java.lang.String java.lang.String ), 1, (int)n, (String)string2, (String)string3);
    }

    private static final native /* synthetic */ int $$robo$$setPhoneState$nativeBinding(int var0);

    public static int setPhoneState(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setPhoneState", $$robo$$android_media_AudioSystem$setPhoneState(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$setForceUse$nativeBinding(int var0, int var1);

    public static int setForceUse(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setForceUse", $$robo$$android_media_AudioSystem$setForceUse(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$getForceUse$nativeBinding(int var0);

    public static int getForceUse(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getForceUse", $$robo$$android_media_AudioSystem$getForceUse(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$initStreamVolume$nativeBinding(int var0, int var1, int var2);

    public static int initStreamVolume(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("initStreamVolume", $$robo$$android_media_AudioSystem$initStreamVolume(int int int ), 1, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ int $$robo$$setStreamVolumeIndex$nativeBinding(int var0, int var1, int var2);

    public static int setStreamVolumeIndex(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setStreamVolumeIndex", $$robo$$android_media_AudioSystem$setStreamVolumeIndex(int int int ), 1, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ int $$robo$$getStreamVolumeIndex$nativeBinding(int var0, int var1);

    public static int getStreamVolumeIndex(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getStreamVolumeIndex", $$robo$$android_media_AudioSystem$getStreamVolumeIndex(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$setMasterVolume$nativeBinding(float var0);

    public static int setMasterVolume(float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setMasterVolume", $$robo$$android_media_AudioSystem$setMasterVolume(float ), 1, (float)f);
    }

    private static final native /* synthetic */ float $$robo$$getMasterVolume$nativeBinding();

    public static float getMasterVolume() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getMasterVolume", $$robo$$android_media_AudioSystem$getMasterVolume(), 1);
    }

    private static final native /* synthetic */ int $$robo$$setMasterMute$nativeBinding(boolean var0);

    public static int setMasterMute(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setMasterMute", $$robo$$android_media_AudioSystem$setMasterMute(boolean ), 1, (boolean)bl);
    }

    private static final native /* synthetic */ boolean $$robo$$getMasterMute$nativeBinding();

    public static boolean getMasterMute() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getMasterMute", $$robo$$android_media_AudioSystem$getMasterMute(), 1);
    }

    private static final native /* synthetic */ int $$robo$$getDevicesForStream$nativeBinding(int var0);

    public static int getDevicesForStream(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDevicesForStream", $$robo$$android_media_AudioSystem$getDevicesForStream(int ), 1, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$getMasterMono$nativeBinding();

    public static boolean getMasterMono() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getMasterMono", $$robo$$android_media_AudioSystem$getMasterMono(), 1);
    }

    private static final native /* synthetic */ int $$robo$$setMasterMono$nativeBinding(boolean var0);

    public static int setMasterMono(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setMasterMono", $$robo$$android_media_AudioSystem$setMasterMono(boolean ), 1, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$getPrimaryOutputSamplingRate$nativeBinding();

    public static int getPrimaryOutputSamplingRate() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPrimaryOutputSamplingRate", $$robo$$android_media_AudioSystem$getPrimaryOutputSamplingRate(), 1);
    }

    private static final native /* synthetic */ int $$robo$$getPrimaryOutputFrameCount$nativeBinding();

    public static int getPrimaryOutputFrameCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPrimaryOutputFrameCount", $$robo$$android_media_AudioSystem$getPrimaryOutputFrameCount(), 1);
    }

    private static final native /* synthetic */ int $$robo$$getOutputLatency$nativeBinding(int var0);

    public static int getOutputLatency(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getOutputLatency", $$robo$$android_media_AudioSystem$getOutputLatency(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$setLowRamDevice$nativeBinding(boolean var0);

    public static int setLowRamDevice(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setLowRamDevice", $$robo$$android_media_AudioSystem$setLowRamDevice(boolean ), 1, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$checkAudioFlinger$nativeBinding();

    public static int checkAudioFlinger() {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkAudioFlinger", $$robo$$android_media_AudioSystem$checkAudioFlinger(), 1);
    }

    private static final native /* synthetic */ int $$robo$$listAudioPorts$nativeBinding(ArrayList<AudioPort> var0, int[] var1);

    public static int listAudioPorts(ArrayList<AudioPort> arrayList, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("listAudioPorts", $$robo$$android_media_AudioSystem$listAudioPorts(java.util.ArrayList<android.media.AudioPort> int[] ), 1, arrayList, (int[])nArray);
    }

    private static final native /* synthetic */ int $$robo$$createAudioPatch$nativeBinding(AudioPatch[] var0, AudioPortConfig[] var1, AudioPortConfig[] var2);

    public static int createAudioPatch(AudioPatch[] audioPatchArray, AudioPortConfig[] audioPortConfigArray, AudioPortConfig[] audioPortConfigArray2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("createAudioPatch", $$robo$$android_media_AudioSystem$createAudioPatch(android.media.AudioPatch[] android.media.AudioPortConfig[] android.media.AudioPortConfig[] ), 1, (AudioPatch[])audioPatchArray, (AudioPortConfig[])audioPortConfigArray, (AudioPortConfig[])audioPortConfigArray2);
    }

    private static final native /* synthetic */ int $$robo$$releaseAudioPatch$nativeBinding(AudioPatch var0);

    public static int releaseAudioPatch(AudioPatch audioPatch) {
        return (int)InvokeDynamicSupport.bootstrapStatic("releaseAudioPatch", $$robo$$android_media_AudioSystem$releaseAudioPatch(android.media.AudioPatch ), 1, (AudioPatch)audioPatch);
    }

    private static final native /* synthetic */ int $$robo$$listAudioPatches$nativeBinding(ArrayList<AudioPatch> var0, int[] var1);

    public static int listAudioPatches(ArrayList<AudioPatch> arrayList, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("listAudioPatches", $$robo$$android_media_AudioSystem$listAudioPatches(java.util.ArrayList<android.media.AudioPatch> int[] ), 1, arrayList, (int[])nArray);
    }

    private static final native /* synthetic */ int $$robo$$setAudioPortConfig$nativeBinding(AudioPortConfig var0);

    public static int setAudioPortConfig(AudioPortConfig audioPortConfig) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setAudioPortConfig", $$robo$$android_media_AudioSystem$setAudioPortConfig(android.media.AudioPortConfig ), 1, (AudioPortConfig)audioPortConfig);
    }

    private static final native /* synthetic */ void $$robo$$native_register_dynamic_policy_callback$nativeBinding();

    private static void native_register_dynamic_policy_callback() {
        InvokeDynamicSupport.bootstrapStatic("native_register_dynamic_policy_callback", $$robo$$android_media_AudioSystem$native_register_dynamic_policy_callback(), 1);
    }

    private static final native /* synthetic */ void $$robo$$native_register_recording_callback$nativeBinding();

    private static void native_register_recording_callback() {
        InvokeDynamicSupport.bootstrapStatic("native_register_recording_callback", $$robo$$android_media_AudioSystem$native_register_recording_callback(), 1);
    }

    private static final native /* synthetic */ int $$robo$$getAudioHwSyncForSession$nativeBinding(int var0);

    public static int getAudioHwSyncForSession(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAudioHwSyncForSession", $$robo$$android_media_AudioSystem$getAudioHwSyncForSession(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$registerPolicyMixes$nativeBinding(ArrayList<AudioMix> var0, boolean var1);

    public static int registerPolicyMixes(ArrayList<AudioMix> arrayList, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("registerPolicyMixes", $$robo$$android_media_AudioSystem$registerPolicyMixes(java.util.ArrayList<android.media.audiopolicy.AudioMix> boolean ), 1, arrayList, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$systemReady$nativeBinding();

    public static int systemReady() {
        return (int)InvokeDynamicSupport.bootstrapStatic("systemReady", $$robo$$android_media_AudioSystem$systemReady(), 1);
    }

    private static final native /* synthetic */ float $$robo$$getStreamVolumeDB$nativeBinding(int var0, int var1, int var2);

    public static float getStreamVolumeDB(int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getStreamVolumeDB", $$robo$$android_media_AudioSystem$getStreamVolumeDB(int int int ), 1, (int)n, (int)n2, (int)n3);
    }

    public static int getValueForVibrateSetting(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getValueForVibrateSetting", $$robo$$android_media_AudioSystem$getValueForVibrateSetting(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public static int getDefaultStreamVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultStreamVolume", $$robo$$android_media_AudioSystem$getDefaultStreamVolume(int ), 0, (int)n);
    }

    public static String streamToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("streamToString", $$robo$$android_media_AudioSystem$streamToString(int ), 0, (int)n);
    }

    public static int getPlatformType(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPlatformType", $$robo$$android_media_AudioSystem$getPlatformType(android.content.Context ), 0, (Context)context);
    }

    public static boolean isSingleVolume(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSingleVolume", $$robo$$android_media_AudioSystem$isSingleVolume(android.content.Context ), 0, (Context)context);
    }

    static {
        RobolectricInternals.classInitializing(AudioSystem.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioSystem)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface AudioRecordingCallback
    extends InstrumentedInterface {
        public void onRecordingConfigurationChanged(int var1, int var2, int var3, int var4, int[] var5, String var6);
    }

    public static interface DynamicPolicyCallback
    extends InstrumentedInterface {
        public void onDynamicPolicyMixStateUpdate(String var1, int var2);
    }

    public static interface ErrorCallback
    extends InstrumentedInterface {
        public void onError(int var1);
    }
}

