/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.DrmInitData;
import android.media.MediaCas;
import android.media.MediaCodec;
import android.media.MediaDataSource;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.IBinder;
import android.os.IHwBinder;
import android.os.PersistableBundle;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MediaExtractor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int SEEK_TO_PREVIOUS_SYNC = 0;
    public static int SEEK_TO_NEXT_SYNC = 1;
    public static int SEEK_TO_CLOSEST_SYNC = 2;
    public static int SAMPLE_FLAG_SYNC = 1;
    public static int SAMPLE_FLAG_ENCRYPTED = 2;
    public static int SAMPLE_FLAG_PARTIAL_FRAME = 4;
    private MediaCas mMediaCas;
    private long mNativeContext;

    private void $$robo$$android_media_MediaExtractor$__constructor__() {
        this.native_setup();
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(MediaDataSource mediaDataSource) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaExtractor$setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        this.setDataSource(uri.toString(), headers);
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(String path, Map<String, String> headers) throws IOException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, keys, values);
    }

    private final void $$robo$$android_media_MediaExtractor$nativeSetDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IOException {
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(String path) throws IOException {
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, null, null);
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(AssetFileDescriptor afd) throws IOException, IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull(afd);
        if (afd.getDeclaredLength() < 0L) {
            this.setDataSource(afd.getFileDescriptor());
        } else {
            this.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
        }
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(FileDescriptor fd) throws IOException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException {
    }

    private final void $$robo$$android_media_MediaExtractor$setMediaCas(MediaCas mediaCas) {
        this.mMediaCas = mediaCas;
        this.nativeSetMediaCas(mediaCas.getBinder());
    }

    private final void $$robo$$android_media_MediaExtractor$nativeSetMediaCas(IHwBinder iHwBinder) {
    }

    private final ArrayList<Byte> $$robo$$android_media_MediaExtractor$toByteArray(byte[] data) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>(data.length);
        for (int i = 0; i < data.length; ++i) {
            byteArray.add(i, data[i]);
        }
        return byteArray;
    }

    private final CasInfo $$robo$$android_media_MediaExtractor$getCasInfo(int index) {
        Map<String, Object> formatMap = this.getTrackFormatNative(index);
        if (formatMap.containsKey("ca-system-id")) {
            int systemId = (Integer)formatMap.get("ca-system-id");
            MediaCas.Session session = null;
            if (this.mMediaCas != null && formatMap.containsKey("ca-session-id")) {
                ByteBuffer buf = (ByteBuffer)formatMap.get("ca-session-id");
                buf.rewind();
                byte[] sessionId = new byte[buf.remaining()];
                buf.get(sessionId);
                session = this.mMediaCas.createFromSessionId(this.toByteArray(sessionId));
            }
            return new CasInfo(systemId, session);
        }
        return null;
    }

    private final void $$robo$$android_media_MediaExtractor$finalize() {
        this.native_finalize();
    }

    private final void $$robo$$android_media_MediaExtractor$release() {
    }

    private final int $$robo$$android_media_MediaExtractor$getTrackCount() {
        return 0;
    }

    private final DrmInitData $$robo$$android_media_MediaExtractor$getDrmInitData() {
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap == null) {
            return null;
        }
        if (formatMap.containsKey("pssh")) {
            Map<UUID, byte[]> psshMap = this.getPsshInfo();
            HashMap<UUID, DrmInitData.SchemeInitData> initDataMap = new HashMap<UUID, DrmInitData.SchemeInitData>();
            for (Map.Entry<UUID, byte[]> e : psshMap.entrySet()) {
                UUID uuid = e.getKey();
                byte[] data = e.getValue();
                initDataMap.put(uuid, new DrmInitData.SchemeInitData("cenc", data));
            }
            return new ShadowedObject(this, initDataMap){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Map val$initDataMap;
                /* synthetic */ MediaExtractor this$0;

                private void $$robo$$android_media_MediaExtractor_1$__constructor__(MediaExtractor this$0, Map map) {
                }

                private final DrmInitData.SchemeInitData $$robo$$android_media_MediaExtractor_1$get(UUID schemeUuid) {
                    return (DrmInitData.SchemeInitData)this.val$initDataMap.get(schemeUuid);
                }

                private void __constructor__(MediaExtractor mediaExtractor, Map map) {
                    this.$$robo$$android_media_MediaExtractor_1$__constructor__(mediaExtractor, map);
                }
                {
                    this.this$0 = mediaExtractor;
                    this.val$initDataMap = map;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaExtractor_1$__constructor__(android.media.MediaExtractor java.util.Map ), 0, this, mediaExtractor, map);
                }

                @Override
                public DrmInitData.SchemeInitData get(UUID uUID) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_media_MediaExtractor_1$get(java.util.UUID ), 0, this, uUID);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        int numTracks = this.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            Map<String, Object> trackFormatMap = this.getTrackFormatNative(i);
            if (!trackFormatMap.containsKey("crypto-key")) continue;
            ByteBuffer buf = (ByteBuffer)trackFormatMap.get("crypto-key");
            buf.rewind();
            byte[] data = new byte[buf.remaining()];
            buf.get(data);
            return new ShadowedObject(this, data){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ byte[] val$data;
                /* synthetic */ MediaExtractor this$0;

                private void $$robo$$android_media_MediaExtractor_2$__constructor__(MediaExtractor this$0, byte[] byArray) {
                }

                private final DrmInitData.SchemeInitData $$robo$$android_media_MediaExtractor_2$get(UUID schemeUuid) {
                    return new DrmInitData.SchemeInitData("webm", this.val$data);
                }

                private void __constructor__(MediaExtractor mediaExtractor, byte[] byArray) {
                    this.$$robo$$android_media_MediaExtractor_2$__constructor__(mediaExtractor, byArray);
                }
                {
                    this.this$0 = mediaExtractor;
                    this.val$data = byArray;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaExtractor_2$__constructor__(android.media.MediaExtractor byte[] ), 0, this, mediaExtractor, byArray);
                }

                @Override
                public DrmInitData.SchemeInitData get(UUID uUID) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_media_MediaExtractor_2$get(java.util.UUID ), 0, this, uUID);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        return null;
    }

    private final Map<UUID, byte[]> $$robo$$android_media_MediaExtractor$getPsshInfo() {
        HashMap<UUID, byte[]> psshMap = null;
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap != null && formatMap.containsKey("pssh")) {
            ByteBuffer rawpssh = (ByteBuffer)formatMap.get("pssh");
            rawpssh.order(ByteOrder.nativeOrder());
            rawpssh.rewind();
            formatMap.remove("pssh");
            psshMap = new HashMap<UUID, byte[]>();
            while (rawpssh.remaining() > 0) {
                rawpssh.order(ByteOrder.BIG_ENDIAN);
                long msb = rawpssh.getLong();
                long lsb = rawpssh.getLong();
                UUID uuid = new UUID(msb, lsb);
                rawpssh.order(ByteOrder.nativeOrder());
                int datalen = rawpssh.getInt();
                byte[] psshdata = new byte[datalen];
                rawpssh.get(psshdata);
                psshMap.put(uuid, psshdata);
            }
        }
        return psshMap;
    }

    private final Map<String, Object> $$robo$$android_media_MediaExtractor$getFileFormatNative() {
        return null;
    }

    private final MediaFormat $$robo$$android_media_MediaExtractor$getTrackFormat(int index) {
        return new MediaFormat(this.getTrackFormatNative(index));
    }

    private final Map<String, Object> $$robo$$android_media_MediaExtractor$getTrackFormatNative(int n) {
        return null;
    }

    private final void $$robo$$android_media_MediaExtractor$selectTrack(int n) {
    }

    private final void $$robo$$android_media_MediaExtractor$unselectTrack(int n) {
    }

    private final void $$robo$$android_media_MediaExtractor$seekTo(long l, int n) {
    }

    private final boolean $$robo$$android_media_MediaExtractor$advance() {
        return false;
    }

    private final int $$robo$$android_media_MediaExtractor$readSampleData(ByteBuffer byteBuffer, int n) {
        return 0;
    }

    private final int $$robo$$android_media_MediaExtractor$getSampleTrackIndex() {
        return 0;
    }

    private final long $$robo$$android_media_MediaExtractor$getSampleTime() {
        return 0L;
    }

    private final int $$robo$$android_media_MediaExtractor$getSampleFlags() {
        return 0;
    }

    private final boolean $$robo$$android_media_MediaExtractor$getSampleCryptoInfo(MediaCodec.CryptoInfo cryptoInfo) {
        return false;
    }

    private final long $$robo$$android_media_MediaExtractor$getCachedDuration() {
        return 0L;
    }

    private final boolean $$robo$$android_media_MediaExtractor$hasCacheReachedEndOfStream() {
        return false;
    }

    private final PersistableBundle $$robo$$android_media_MediaExtractor$getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private final PersistableBundle $$robo$$android_media_MediaExtractor$native_getMetrics() {
        return null;
    }

    private static final void $$robo$$android_media_MediaExtractor$native_init() {
    }

    private final void $$robo$$android_media_MediaExtractor$native_setup() {
    }

    private final void $$robo$$android_media_MediaExtractor$native_finalize() {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaExtractor.native_init();
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaExtractor$__constructor__();
    }

    public MediaExtractor() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaExtractor$__constructor__(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setDataSource$nativeBinding(MediaDataSource var1) throws IOException;

    public void setDataSource(MediaDataSource mediaDataSource) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(android.media.MediaDataSource ), 1, this, mediaDataSource);
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> map) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(android.content.Context android.net.Uri java.util.Map<java.lang.String, java.lang.String> ), 0, this, context, uri, map);
    }

    public void setDataSource(String string2, Map<String, String> map) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(java.lang.String java.util.Map<java.lang.String, java.lang.String> ), 0, this, string2, map);
    }

    private final native /* synthetic */ void $$robo$$nativeSetDataSource$nativeBinding(IBinder var1, String var2, String[] var3, String[] var4) throws IOException;

    private void nativeSetDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IOException {
        InvokeDynamicSupport.bootstrap("nativeSetDataSource", $$robo$$android_media_MediaExtractor$nativeSetDataSource(android.os.IBinder java.lang.String java.lang.String[] java.lang.String[] ), 1, this, iBinder, string2, stringArray, stringArray2);
    }

    public void setDataSource(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(java.lang.String ), 0, this, string2);
    }

    public void setDataSource(AssetFileDescriptor assetFileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(android.content.res.AssetFileDescriptor ), 0, this, assetFileDescriptor);
    }

    public void setDataSource(FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    private final native /* synthetic */ void $$robo$$setDataSource$nativeBinding(FileDescriptor var1, long var2, long var4) throws IOException;

    public void setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(java.io.FileDescriptor long long ), 1, this, fileDescriptor, l, l2);
    }

    public void setMediaCas(MediaCas mediaCas) {
        InvokeDynamicSupport.bootstrap("setMediaCas", $$robo$$android_media_MediaExtractor$setMediaCas(android.media.MediaCas ), 0, this, mediaCas);
    }

    private final native /* synthetic */ void $$robo$$nativeSetMediaCas$nativeBinding(IHwBinder var1);

    private void nativeSetMediaCas(IHwBinder iHwBinder) {
        InvokeDynamicSupport.bootstrap("nativeSetMediaCas", $$robo$$android_media_MediaExtractor$nativeSetMediaCas(android.os.IHwBinder ), 1, this, iHwBinder);
    }

    private ArrayList<Byte> toByteArray(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_media_MediaExtractor$toByteArray(byte[] ), 0, this, byArray);
    }

    public CasInfo getCasInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getCasInfo", $$robo$$android_media_MediaExtractor$getCasInfo(int ), 0, this, n);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaExtractor$finalize(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$release$nativeBinding();

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaExtractor$release(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getTrackCount$nativeBinding();

    public int getTrackCount() {
        return (int)InvokeDynamicSupport.bootstrap("getTrackCount", $$robo$$android_media_MediaExtractor$getTrackCount(), 1, this);
    }

    public DrmInitData getDrmInitData() {
        return InvokeDynamicSupport.bootstrap("getDrmInitData", $$robo$$android_media_MediaExtractor$getDrmInitData(), 0, this);
    }

    public Map<UUID, byte[]> getPsshInfo() {
        return InvokeDynamicSupport.bootstrap("getPsshInfo", $$robo$$android_media_MediaExtractor$getPsshInfo(), 0, this);
    }

    private final native /* synthetic */ Map<String, Object> $$robo$$getFileFormatNative$nativeBinding();

    private Map<String, Object> getFileFormatNative() {
        return InvokeDynamicSupport.bootstrap("getFileFormatNative", $$robo$$android_media_MediaExtractor$getFileFormatNative(), 1, this);
    }

    public MediaFormat getTrackFormat(int n) {
        return InvokeDynamicSupport.bootstrap("getTrackFormat", $$robo$$android_media_MediaExtractor$getTrackFormat(int ), 0, this, n);
    }

    private final native /* synthetic */ Map<String, Object> $$robo$$getTrackFormatNative$nativeBinding(int var1);

    private Map<String, Object> getTrackFormatNative(int n) {
        return InvokeDynamicSupport.bootstrap("getTrackFormatNative", $$robo$$android_media_MediaExtractor$getTrackFormatNative(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$selectTrack$nativeBinding(int var1);

    public void selectTrack(int n) {
        InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_MediaExtractor$selectTrack(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$unselectTrack$nativeBinding(int var1);

    public void unselectTrack(int n) {
        InvokeDynamicSupport.bootstrap("unselectTrack", $$robo$$android_media_MediaExtractor$unselectTrack(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$seekTo$nativeBinding(long var1, int var3);

    public void seekTo(long l, int n) {
        InvokeDynamicSupport.bootstrap("seekTo", $$robo$$android_media_MediaExtractor$seekTo(long int ), 1, this, l, n);
    }

    private final native /* synthetic */ boolean $$robo$$advance$nativeBinding();

    public boolean advance() {
        return (boolean)InvokeDynamicSupport.bootstrap("advance", $$robo$$android_media_MediaExtractor$advance(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$readSampleData$nativeBinding(ByteBuffer var1, int var2);

    public int readSampleData(ByteBuffer byteBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrap("readSampleData", $$robo$$android_media_MediaExtractor$readSampleData(java.nio.ByteBuffer int ), 1, this, byteBuffer, n);
    }

    private final native /* synthetic */ int $$robo$$getSampleTrackIndex$nativeBinding();

    public int getSampleTrackIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleTrackIndex", $$robo$$android_media_MediaExtractor$getSampleTrackIndex(), 1, this);
    }

    private final native /* synthetic */ long $$robo$$getSampleTime$nativeBinding();

    public long getSampleTime() {
        return (long)InvokeDynamicSupport.bootstrap("getSampleTime", $$robo$$android_media_MediaExtractor$getSampleTime(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getSampleFlags$nativeBinding();

    public int getSampleFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleFlags", $$robo$$android_media_MediaExtractor$getSampleFlags(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$getSampleCryptoInfo$nativeBinding(MediaCodec.CryptoInfo var1);

    public boolean getSampleCryptoInfo(MediaCodec.CryptoInfo cryptoInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("getSampleCryptoInfo", $$robo$$android_media_MediaExtractor$getSampleCryptoInfo(android.media.MediaCodec$CryptoInfo ), 1, this, cryptoInfo);
    }

    private final native /* synthetic */ long $$robo$$getCachedDuration$nativeBinding();

    public long getCachedDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getCachedDuration", $$robo$$android_media_MediaExtractor$getCachedDuration(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$hasCacheReachedEndOfStream$nativeBinding();

    public boolean hasCacheReachedEndOfStream() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCacheReachedEndOfStream", $$robo$$android_media_MediaExtractor$hasCacheReachedEndOfStream(), 1, this);
    }

    public PersistableBundle getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_media_MediaExtractor$getMetrics(), 0, this);
    }

    private final native /* synthetic */ PersistableBundle $$robo$$native_getMetrics$nativeBinding();

    private PersistableBundle native_getMetrics() {
        return InvokeDynamicSupport.bootstrap("native_getMetrics", $$robo$$android_media_MediaExtractor$native_getMetrics(), 1, this);
    }

    private static final native /* synthetic */ void $$robo$$native_init$nativeBinding();

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaExtractor$native_init(), 1);
    }

    private final native /* synthetic */ void $$robo$$native_setup$nativeBinding();

    private void native_setup() {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaExtractor$native_setup(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaExtractor$native_finalize(), 1, this);
    }

    static {
        RobolectricInternals.classInitializing(MediaExtractor.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaExtractor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class MetricsConstants
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String FORMAT = "android.media.mediaextractor.fmt";
        public static String MIME_TYPE = "android.media.mediaextractor.mime";
        public static String TRACKS = "android.media.mediaextractor.ntrk";

        private void $$robo$$android_media_MediaExtractor_MetricsConstants$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaExtractor_MetricsConstants$__constructor__();
        }

        private MetricsConstants() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaExtractor_MetricsConstants$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MetricsConstants)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SampleFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeekMode {
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CasInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mSystemId;
        private MediaCas.Session mSession;

        private void $$robo$$android_media_MediaExtractor_CasInfo$__constructor__(int systemId, MediaCas.Session session) {
            this.mSystemId = systemId;
            this.mSession = session;
        }

        private final int $$robo$$android_media_MediaExtractor_CasInfo$getSystemId() {
            return this.mSystemId;
        }

        private final MediaCas.Session $$robo$$android_media_MediaExtractor_CasInfo$getSession() {
            return this.mSession;
        }

        private void __constructor__(int n, MediaCas.Session session) {
            this.$$robo$$android_media_MediaExtractor_CasInfo$__constructor__(n, session);
        }

        CasInfo(int n, MediaCas.Session session) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaExtractor_CasInfo$__constructor__(int android.media.MediaCas$Session ), 0, this, n, session);
        }

        public int getSystemId() {
            return (int)InvokeDynamicSupport.bootstrap("getSystemId", $$robo$$android_media_MediaExtractor_CasInfo$getSystemId(), 0, this);
        }

        public MediaCas.Session getSession() {
            return InvokeDynamicSupport.bootstrap("getSession", $$robo$$android_media_MediaExtractor_CasInfo$getSession(), 0, this);
        }

        public /* synthetic */ CasInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CasInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

