/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.DecoderCapabilities;
import com.android.internal.util.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaFile
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FILE_TYPE_MP3 = 1;
    public static int FILE_TYPE_M4A = 2;
    public static int FILE_TYPE_WAV = 3;
    public static int FILE_TYPE_AMR = 4;
    public static int FILE_TYPE_AWB = 5;
    public static int FILE_TYPE_WMA = 6;
    public static int FILE_TYPE_OGG = 7;
    public static int FILE_TYPE_AAC = 8;
    public static int FILE_TYPE_MKA = 9;
    public static int FILE_TYPE_FLAC = 10;
    private static int FIRST_AUDIO_FILE_TYPE = 1;
    private static int LAST_AUDIO_FILE_TYPE = 10;
    public static int FILE_TYPE_MID = 11;
    public static int FILE_TYPE_SMF = 12;
    public static int FILE_TYPE_IMY = 13;
    private static int FIRST_MIDI_FILE_TYPE = 11;
    private static int LAST_MIDI_FILE_TYPE = 13;
    public static int FILE_TYPE_MP4 = 21;
    public static int FILE_TYPE_M4V = 22;
    public static int FILE_TYPE_3GPP = 23;
    public static int FILE_TYPE_3GPP2 = 24;
    public static int FILE_TYPE_WMV = 25;
    public static int FILE_TYPE_ASF = 26;
    public static int FILE_TYPE_MKV = 27;
    public static int FILE_TYPE_MP2TS = 28;
    public static int FILE_TYPE_AVI = 29;
    public static int FILE_TYPE_WEBM = 30;
    private static int FIRST_VIDEO_FILE_TYPE = 21;
    private static int LAST_VIDEO_FILE_TYPE = 30;
    public static int FILE_TYPE_MP2PS = 200;
    public static int FILE_TYPE_QT = 201;
    private static int FIRST_VIDEO_FILE_TYPE2 = 200;
    private static int LAST_VIDEO_FILE_TYPE2 = 201;
    public static int FILE_TYPE_JPEG = 31;
    public static int FILE_TYPE_GIF = 32;
    public static int FILE_TYPE_PNG = 33;
    public static int FILE_TYPE_BMP = 34;
    public static int FILE_TYPE_WBMP = 35;
    public static int FILE_TYPE_WEBP = 36;
    public static int FILE_TYPE_HEIF = 37;
    private static int FIRST_IMAGE_FILE_TYPE = 31;
    private static int LAST_IMAGE_FILE_TYPE = 37;
    public static int FILE_TYPE_DNG = 300;
    public static int FILE_TYPE_CR2 = 301;
    public static int FILE_TYPE_NEF = 302;
    public static int FILE_TYPE_NRW = 303;
    public static int FILE_TYPE_ARW = 304;
    public static int FILE_TYPE_RW2 = 305;
    public static int FILE_TYPE_ORF = 306;
    public static int FILE_TYPE_RAF = 307;
    public static int FILE_TYPE_PEF = 308;
    public static int FILE_TYPE_SRW = 309;
    private static int FIRST_RAW_IMAGE_FILE_TYPE = 300;
    private static int LAST_RAW_IMAGE_FILE_TYPE = 309;
    public static int FILE_TYPE_M3U = 41;
    public static int FILE_TYPE_PLS = 42;
    public static int FILE_TYPE_WPL = 43;
    public static int FILE_TYPE_HTTPLIVE = 44;
    private static int FIRST_PLAYLIST_FILE_TYPE = 41;
    private static int LAST_PLAYLIST_FILE_TYPE = 44;
    public static int FILE_TYPE_FL = 51;
    private static int FIRST_DRM_FILE_TYPE = 51;
    private static int LAST_DRM_FILE_TYPE = 51;
    public static int FILE_TYPE_TEXT = 100;
    public static int FILE_TYPE_HTML = 101;
    public static int FILE_TYPE_PDF = 102;
    public static int FILE_TYPE_XML = 103;
    public static int FILE_TYPE_MS_WORD = 104;
    public static int FILE_TYPE_MS_EXCEL = 105;
    public static int FILE_TYPE_MS_POWERPOINT = 106;
    public static int FILE_TYPE_ZIP = 107;
    private static HashMap<String, MediaFileType> sFileTypeMap;
    private static HashMap<String, Integer> sMimeTypeMap;
    private static HashMap<String, Integer> sFileTypeToFormatMap;
    private static HashMap<String, Integer> sMimeTypeToFormatMap;
    private static HashMap<Integer, String> sFormatToMimeTypeMap;

    private void $$robo$$android_media_MediaFile$__constructor__() {
    }

    private static final void $$robo$$android_media_MediaFile$addFileType(String extension, int fileType, String mimeType) {
        sFileTypeMap.put(extension, new MediaFileType(fileType, mimeType));
        sMimeTypeMap.put(mimeType, fileType);
    }

    private static final void $$robo$$android_media_MediaFile$addFileType(String extension, int fileType, String mimeType, int mtpFormatCode, boolean primaryType) {
        MediaFile.addFileType(extension, fileType, mimeType);
        sFileTypeToFormatMap.put(extension, mtpFormatCode);
        sMimeTypeToFormatMap.put(mimeType, mtpFormatCode);
        if (primaryType) {
            Preconditions.checkArgument(!sFormatToMimeTypeMap.containsKey(mtpFormatCode));
            sFormatToMimeTypeMap.put(mtpFormatCode, mimeType);
        }
    }

    private static final boolean $$robo$$android_media_MediaFile$isWMAEnabled() {
        List<DecoderCapabilities.AudioDecoder> decoders = DecoderCapabilities.getAudioDecoders();
        int count = decoders.size();
        for (int i = 0; i < count; ++i) {
            DecoderCapabilities.AudioDecoder decoder = decoders.get(i);
            if (decoder != DecoderCapabilities.AudioDecoder.AUDIO_DECODER_WMA) continue;
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_media_MediaFile$isWMVEnabled() {
        List<DecoderCapabilities.VideoDecoder> decoders = DecoderCapabilities.getVideoDecoders();
        int count = decoders.size();
        for (int i = 0; i < count; ++i) {
            DecoderCapabilities.VideoDecoder decoder = decoders.get(i);
            if (decoder != DecoderCapabilities.VideoDecoder.VIDEO_DECODER_WMV) continue;
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_media_MediaFile$isAudioFileType(int fileType) {
        return fileType >= 1 && fileType <= 10 || fileType >= 11 && fileType <= 13;
    }

    private static final boolean $$robo$$android_media_MediaFile$isVideoFileType(int fileType) {
        return fileType >= 21 && fileType <= 30 || fileType >= 200 && fileType <= 201;
    }

    private static final boolean $$robo$$android_media_MediaFile$isImageFileType(int fileType) {
        return fileType >= 31 && fileType <= 37 || fileType >= 300 && fileType <= 309;
    }

    private static final boolean $$robo$$android_media_MediaFile$isRawImageFileType(int fileType) {
        return fileType >= 300 && fileType <= 309;
    }

    private static final boolean $$robo$$android_media_MediaFile$isPlayListFileType(int fileType) {
        return fileType >= 41 && fileType <= 44;
    }

    private static final boolean $$robo$$android_media_MediaFile$isDrmFileType(int fileType) {
        return fileType >= 51 && fileType <= 51;
    }

    private static final MediaFileType $$robo$$android_media_MediaFile$getFileType(String path) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        return sFileTypeMap.get(path.substring(lastDot + 1).toUpperCase(Locale.ROOT));
    }

    private static final boolean $$robo$$android_media_MediaFile$isMimeTypeMedia(String mimeType) {
        int fileType = MediaFile.getFileTypeForMimeType(mimeType);
        return MediaFile.isAudioFileType(fileType) || MediaFile.isVideoFileType(fileType) || MediaFile.isImageFileType(fileType) || MediaFile.isPlayListFileType(fileType);
    }

    private static final String $$robo$$android_media_MediaFile$getFileTitle(String path) {
        int lastDot;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0 && ++lastSlash < path.length()) {
            path = path.substring(lastSlash);
        }
        if ((lastDot = path.lastIndexOf(46)) > 0) {
            path = path.substring(0, lastDot);
        }
        return path;
    }

    private static final int $$robo$$android_media_MediaFile$getFileTypeForMimeType(String mimeType) {
        Integer value = sMimeTypeMap.get(mimeType);
        return value == null ? 0 : value;
    }

    private static final String $$robo$$android_media_MediaFile$getMimeTypeForFile(String path) {
        MediaFileType mediaFileType = MediaFile.getFileType(path);
        return mediaFileType == null ? null : mediaFileType.mimeType;
    }

    private static final int $$robo$$android_media_MediaFile$getFormatCode(String fileName, String mimeType) {
        String extension;
        Integer value;
        Integer value2;
        if (mimeType != null && (value2 = sMimeTypeToFormatMap.get(mimeType)) != null) {
            return value2;
        }
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot > 0 && (value = sFileTypeToFormatMap.get(extension = fileName.substring(lastDot + 1).toUpperCase(Locale.ROOT))) != null) {
            return value;
        }
        return 12288;
    }

    private static final String $$robo$$android_media_MediaFile$getMimeTypeForFormatCode(int formatCode) {
        return sFormatToMimeTypeMap.get(formatCode);
    }

    static void __staticInitializer__() {
        sFileTypeMap = new HashMap();
        sMimeTypeMap = new HashMap();
        sFileTypeToFormatMap = new HashMap();
        sMimeTypeToFormatMap = new HashMap();
        sFormatToMimeTypeMap = new HashMap();
        MediaFile.addFileType("MP3", 1, "audio/mpeg", 12297, true);
        MediaFile.addFileType("MPGA", 1, "audio/mpeg", 12297, false);
        MediaFile.addFileType("M4A", 2, "audio/mp4", 12299, false);
        MediaFile.addFileType("WAV", 3, "audio/x-wav", 12296, true);
        MediaFile.addFileType("AMR", 4, "audio/amr");
        MediaFile.addFileType("AWB", 5, "audio/amr-wb");
        if (MediaFile.isWMAEnabled()) {
            MediaFile.addFileType("WMA", 6, "audio/x-ms-wma", 47361, true);
        }
        MediaFile.addFileType("OGG", 7, "audio/ogg", 47362, false);
        MediaFile.addFileType("OGG", 7, "application/ogg", 47362, true);
        MediaFile.addFileType("OGA", 7, "application/ogg", 47362, false);
        MediaFile.addFileType("AAC", 8, "audio/aac", 47363, true);
        MediaFile.addFileType("AAC", 8, "audio/aac-adts", 47363, false);
        MediaFile.addFileType("MKA", 9, "audio/x-matroska");
        MediaFile.addFileType("MID", 11, "audio/midi");
        MediaFile.addFileType("MIDI", 11, "audio/midi");
        MediaFile.addFileType("XMF", 11, "audio/midi");
        MediaFile.addFileType("RTTTL", 11, "audio/midi");
        MediaFile.addFileType("SMF", 12, "audio/sp-midi");
        MediaFile.addFileType("IMY", 13, "audio/imelody");
        MediaFile.addFileType("RTX", 11, "audio/midi");
        MediaFile.addFileType("OTA", 11, "audio/midi");
        MediaFile.addFileType("MXMF", 11, "audio/midi");
        MediaFile.addFileType("MPEG", 21, "video/mpeg", 12299, true);
        MediaFile.addFileType("MPG", 21, "video/mpeg", 12299, false);
        MediaFile.addFileType("MP4", 21, "video/mp4", 12299, false);
        MediaFile.addFileType("M4V", 22, "video/mp4", 12299, false);
        MediaFile.addFileType("MOV", 201, "video/quicktime", 12299, false);
        MediaFile.addFileType("3GP", 23, "video/3gpp", 47492, true);
        MediaFile.addFileType("3GPP", 23, "video/3gpp", 47492, false);
        MediaFile.addFileType("3G2", 24, "video/3gpp2", 47492, false);
        MediaFile.addFileType("3GPP2", 24, "video/3gpp2", 47492, false);
        MediaFile.addFileType("MKV", 27, "video/x-matroska");
        MediaFile.addFileType("WEBM", 30, "video/webm");
        MediaFile.addFileType("TS", 28, "video/mp2ts");
        MediaFile.addFileType("AVI", 29, "video/avi");
        if (MediaFile.isWMVEnabled()) {
            MediaFile.addFileType("WMV", 25, "video/x-ms-wmv", 47489, true);
            MediaFile.addFileType("ASF", 26, "video/x-ms-asf");
        }
        MediaFile.addFileType("JPG", 31, "image/jpeg", 14337, true);
        MediaFile.addFileType("JPEG", 31, "image/jpeg", 14337, false);
        MediaFile.addFileType("GIF", 32, "image/gif", 14343, true);
        MediaFile.addFileType("PNG", 33, "image/png", 14347, true);
        MediaFile.addFileType("BMP", 34, "image/x-ms-bmp", 14340, true);
        MediaFile.addFileType("WBMP", 35, "image/vnd.wap.wbmp", 14336, false);
        MediaFile.addFileType("WEBP", 36, "image/webp", 14336, false);
        MediaFile.addFileType("HEIC", 37, "image/heif", 14354, true);
        MediaFile.addFileType("HEIF", 37, "image/heif", 14354, false);
        MediaFile.addFileType("DNG", 300, "image/x-adobe-dng", 14353, true);
        MediaFile.addFileType("CR2", 301, "image/x-canon-cr2", 14349, false);
        MediaFile.addFileType("NEF", 302, "image/x-nikon-nef", 14338, false);
        MediaFile.addFileType("NRW", 303, "image/x-nikon-nrw", 14349, false);
        MediaFile.addFileType("ARW", 304, "image/x-sony-arw", 14349, false);
        MediaFile.addFileType("RW2", 305, "image/x-panasonic-rw2", 14349, false);
        MediaFile.addFileType("ORF", 306, "image/x-olympus-orf", 14349, false);
        MediaFile.addFileType("RAF", 307, "image/x-fuji-raf", 14336, false);
        MediaFile.addFileType("PEF", 308, "image/x-pentax-pef", 14349, false);
        MediaFile.addFileType("SRW", 309, "image/x-samsung-srw", 14349, false);
        MediaFile.addFileType("M3U", 41, "audio/x-mpegurl", 47633, true);
        MediaFile.addFileType("M3U", 41, "application/x-mpegurl", 47633, false);
        MediaFile.addFileType("PLS", 42, "audio/x-scpls", 47636, true);
        MediaFile.addFileType("WPL", 43, "application/vnd.ms-wpl", 47632, true);
        MediaFile.addFileType("M3U8", 44, "application/vnd.apple.mpegurl");
        MediaFile.addFileType("M3U8", 44, "audio/mpegurl");
        MediaFile.addFileType("M3U8", 44, "audio/x-mpegurl");
        MediaFile.addFileType("FL", 51, "application/x-android-drm-fl");
        MediaFile.addFileType("TXT", 100, "text/plain", 12292, true);
        MediaFile.addFileType("HTM", 101, "text/html", 12293, true);
        MediaFile.addFileType("HTML", 101, "text/html", 12293, false);
        MediaFile.addFileType("PDF", 102, "application/pdf");
        MediaFile.addFileType("DOC", 104, "application/msword", 47747, true);
        MediaFile.addFileType("XLS", 105, "application/vnd.ms-excel", 47749, true);
        MediaFile.addFileType("PPT", 106, "application/mspowerpoint", 47750, true);
        MediaFile.addFileType("FLAC", 10, "audio/flac", 47366, true);
        MediaFile.addFileType("ZIP", 107, "application/zip");
        MediaFile.addFileType("MPG", 200, "video/mp2p");
        MediaFile.addFileType("MPEG", 200, "video/mp2p");
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaFile$__constructor__();
    }

    public MediaFile() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFile$__constructor__(), 0, this);
    }

    static void addFileType(String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrapStatic("addFileType", $$robo$$android_media_MediaFile$addFileType(java.lang.String int java.lang.String ), 0, (String)string2, (int)n, (String)string3);
    }

    private static void addFileType(String string2, int n, String string3, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("addFileType", $$robo$$android_media_MediaFile$addFileType(java.lang.String int java.lang.String int boolean ), 0, (String)string2, (int)n, (String)string3, (int)n2, (boolean)bl);
    }

    private static boolean isWMAEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWMAEnabled", $$robo$$android_media_MediaFile$isWMAEnabled(), 0);
    }

    private static boolean isWMVEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWMVEnabled", $$robo$$android_media_MediaFile$isWMVEnabled(), 0);
    }

    public static boolean isAudioFileType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAudioFileType", $$robo$$android_media_MediaFile$isAudioFileType(int ), 0, (int)n);
    }

    public static boolean isVideoFileType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVideoFileType", $$robo$$android_media_MediaFile$isVideoFileType(int ), 0, (int)n);
    }

    public static boolean isImageFileType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isImageFileType", $$robo$$android_media_MediaFile$isImageFileType(int ), 0, (int)n);
    }

    public static boolean isRawImageFileType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRawImageFileType", $$robo$$android_media_MediaFile$isRawImageFileType(int ), 0, (int)n);
    }

    public static boolean isPlayListFileType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPlayListFileType", $$robo$$android_media_MediaFile$isPlayListFileType(int ), 0, (int)n);
    }

    public static boolean isDrmFileType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDrmFileType", $$robo$$android_media_MediaFile$isDrmFileType(int ), 0, (int)n);
    }

    public static MediaFileType getFileType(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getFileType", $$robo$$android_media_MediaFile$getFileType(java.lang.String ), 0, (String)string2);
    }

    public static boolean isMimeTypeMedia(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMimeTypeMedia", $$robo$$android_media_MediaFile$isMimeTypeMedia(java.lang.String ), 0, (String)string2);
    }

    public static String getFileTitle(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getFileTitle", $$robo$$android_media_MediaFile$getFileTitle(java.lang.String ), 0, (String)string2);
    }

    public static int getFileTypeForMimeType(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getFileTypeForMimeType", $$robo$$android_media_MediaFile$getFileTypeForMimeType(java.lang.String ), 0, (String)string2);
    }

    public static String getMimeTypeForFile(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getMimeTypeForFile", $$robo$$android_media_MediaFile$getMimeTypeForFile(java.lang.String ), 0, (String)string2);
    }

    public static int getFormatCode(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getFormatCode", $$robo$$android_media_MediaFile$getFormatCode(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getMimeTypeForFormatCode(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getMimeTypeForFormatCode", $$robo$$android_media_MediaFile$getMimeTypeForFormatCode(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(MediaFile.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaFile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MediaFileType
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int fileType;
        public String mimeType;

        private void $$robo$$android_media_MediaFile_MediaFileType$__constructor__(int fileType, String mimeType) {
            this.fileType = fileType;
            this.mimeType = mimeType;
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_media_MediaFile_MediaFileType$__constructor__(n, string2);
        }

        MediaFileType(int n, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFile_MediaFileType$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        public /* synthetic */ MediaFileType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaFileType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

