/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TtmlNode;
import com.google.errorprone.annotations.DoNotMock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TtmlUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG_TT = "tt";
    public static String TAG_HEAD = "head";
    public static String TAG_BODY = "body";
    public static String TAG_DIV = "div";
    public static String TAG_P = "p";
    public static String TAG_SPAN = "span";
    public static String TAG_BR = "br";
    public static String TAG_STYLE = "style";
    public static String TAG_STYLING = "styling";
    public static String TAG_LAYOUT = "layout";
    public static String TAG_REGION = "region";
    public static String TAG_METADATA = "metadata";
    public static String TAG_SMPTE_IMAGE = "smpte:image";
    public static String TAG_SMPTE_DATA = "smpte:data";
    public static String TAG_SMPTE_INFORMATION = "smpte:information";
    public static String PCDATA = "#pcdata";
    public static String ATTR_BEGIN = "begin";
    public static String ATTR_DURATION = "dur";
    public static String ATTR_END = "end";
    public static long INVALID_TIMESTAMP = Long.MAX_VALUE;
    private static Pattern CLOCK_TIME;
    private static Pattern OFFSET_TIME;

    private void $$robo$$android_media_TtmlUtils$__constructor__() {
    }

    private static final long $$robo$$android_media_TtmlUtils$parseTimeExpression(String time, int frameRate, int subframeRate, int tickRate) throws NumberFormatException {
        Matcher matcher = CLOCK_TIME.matcher(time);
        if (matcher.matches()) {
            String hours = matcher.group(1);
            double durationSeconds = Long.parseLong(hours) * 3600L;
            String minutes = matcher.group(2);
            durationSeconds += (double)(Long.parseLong(minutes) * 60L);
            String seconds = matcher.group(3);
            durationSeconds += (double)Long.parseLong(seconds);
            String fraction2 = matcher.group(4);
            durationSeconds += fraction2 != null ? Double.parseDouble(fraction2) : 0.0;
            String frames = matcher.group(5);
            durationSeconds += frames != null ? (double)Long.parseLong(frames) / (double)frameRate : 0.0;
            String subframes = matcher.group(6);
            return (long)((durationSeconds += subframes != null ? (double)Long.parseLong(subframes) / (double)subframeRate / (double)frameRate : 0.0) * 1000.0);
        }
        matcher = OFFSET_TIME.matcher(time);
        if (matcher.matches()) {
            String timeValue = matcher.group(1);
            double value = Double.parseDouble(timeValue);
            String unit = matcher.group(2);
            if (unit.equals("h")) {
                value *= 3.6E9;
            } else if (unit.equals("m")) {
                value *= 6.0E7;
            } else if (unit.equals("s")) {
                value *= 1000000.0;
            } else if (unit.equals("ms")) {
                value *= 1000.0;
            } else if (unit.equals("f")) {
                value = value / (double)frameRate * 1000000.0;
            } else if (unit.equals("t")) {
                value = value / (double)tickRate * 1000000.0;
            }
            return (long)value;
        }
        throw new NumberFormatException("Malformed time expression : " + time);
    }

    private static final String $$robo$$android_media_TtmlUtils$applyDefaultSpacePolicy(String in) {
        return TtmlUtils.applySpacePolicy(in, true);
    }

    private static final String $$robo$$android_media_TtmlUtils$applySpacePolicy(String in, boolean treatLfAsSpace) {
        String crRemoved = in.replaceAll("\r\n", "\n");
        String spacesNeighboringLfRemoved = crRemoved.replaceAll(" *\n *", "\n");
        String lfToSpace = treatLfAsSpace ? spacesNeighboringLfRemoved.replaceAll("\n", " ") : spacesNeighboringLfRemoved;
        String spacesCollapsed = lfToSpace.replaceAll("[ \t\\x0B\f\r]+", " ");
        return spacesCollapsed;
    }

    private static final String $$robo$$android_media_TtmlUtils$extractText(TtmlNode root, long startUs, long endUs) {
        StringBuilder text = new StringBuilder();
        TtmlUtils.extractText(root, startUs, endUs, text, false);
        return text.toString().replaceAll("\n$", "");
    }

    private static final void $$robo$$android_media_TtmlUtils$extractText(TtmlNode node, long startUs, long endUs, StringBuilder out, boolean inPTag) {
        if (node.mName.equals("#pcdata") && inPTag) {
            out.append(node.mText);
        } else if (node.mName.equals("br") && inPTag) {
            out.append("\n");
        } else if (!node.mName.equals("metadata") && node.isActive(startUs, endUs)) {
            boolean pTag = node.mName.equals("p");
            int length = out.length();
            for (int i = 0; i < node.mChildren.size(); ++i) {
                TtmlUtils.extractText(node.mChildren.get(i), startUs, endUs, out, pTag || inPTag);
            }
            if (pTag && length != out.length()) {
                out.append("\n");
            }
        }
    }

    private static final String $$robo$$android_media_TtmlUtils$extractTtmlFragment(TtmlNode root, long startUs, long endUs) {
        StringBuilder fragment = new StringBuilder();
        TtmlUtils.extractTtmlFragment(root, startUs, endUs, fragment);
        return fragment.toString();
    }

    private static final void $$robo$$android_media_TtmlUtils$extractTtmlFragment(TtmlNode node, long startUs, long endUs, StringBuilder out) {
        if (node.mName.equals("#pcdata")) {
            out.append(node.mText);
        } else if (node.mName.equals("br")) {
            out.append("<br/>");
        } else if (node.isActive(startUs, endUs)) {
            out.append("<");
            out.append(node.mName);
            out.append(node.mAttributes);
            out.append(">");
            for (int i = 0; i < node.mChildren.size(); ++i) {
                TtmlUtils.extractTtmlFragment(node.mChildren.get(i), startUs, endUs, out);
            }
            out.append("</");
            out.append(node.mName);
            out.append(">");
        }
    }

    static void __staticInitializer__() {
        CLOCK_TIME = Pattern.compile("^([0-9][0-9]+):([0-9][0-9]):([0-9][0-9])(?:(\\.[0-9]+)|:([0-9][0-9])(?:\\.([0-9]+))?)?$");
        OFFSET_TIME = Pattern.compile("^([0-9]+(?:\\.[0-9]+)?)(h|m|s|ms|f|t)$");
    }

    private void __constructor__() {
        this.$$robo$$android_media_TtmlUtils$__constructor__();
    }

    private TtmlUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TtmlUtils$__constructor__(), 0, this);
    }

    public static long parseTimeExpression(String string2, int n, int n2, int n3) throws NumberFormatException {
        return (long)InvokeDynamicSupport.bootstrapStatic("parseTimeExpression", $$robo$$android_media_TtmlUtils$parseTimeExpression(java.lang.String int int int ), 0, (String)string2, (int)n, (int)n2, (int)n3);
    }

    public static String applyDefaultSpacePolicy(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("applyDefaultSpacePolicy", $$robo$$android_media_TtmlUtils$applyDefaultSpacePolicy(java.lang.String ), 0, (String)string2);
    }

    public static String applySpacePolicy(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("applySpacePolicy", $$robo$$android_media_TtmlUtils$applySpacePolicy(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    public static String extractText(TtmlNode ttmlNode, long l, long l2) {
        return InvokeDynamicSupport.bootstrapStatic("extractText", $$robo$$android_media_TtmlUtils$extractText(android.media.TtmlNode long long ), 0, (TtmlNode)ttmlNode, (long)l, (long)l2);
    }

    private static void extractText(TtmlNode ttmlNode, long l, long l2, StringBuilder stringBuilder, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("extractText", $$robo$$android_media_TtmlUtils$extractText(android.media.TtmlNode long long java.lang.StringBuilder boolean ), 0, (TtmlNode)ttmlNode, (long)l, (long)l2, (StringBuilder)stringBuilder, (boolean)bl);
    }

    public static String extractTtmlFragment(TtmlNode ttmlNode, long l, long l2) {
        return InvokeDynamicSupport.bootstrapStatic("extractTtmlFragment", $$robo$$android_media_TtmlUtils$extractTtmlFragment(android.media.TtmlNode long long ), 0, (TtmlNode)ttmlNode, (long)l, (long)l2);
    }

    private static void extractTtmlFragment(TtmlNode ttmlNode, long l, long l2, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("extractTtmlFragment", $$robo$$android_media_TtmlUtils$extractTtmlFragment(android.media.TtmlNode long long java.lang.StringBuilder ), 0, (TtmlNode)ttmlNode, (long)l, (long)l2, (StringBuilder)stringBuilder);
    }

    static {
        RobolectricInternals.classInitializing(TtmlUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TtmlUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

