/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.IMidiDeviceServer;
import android.media.midi.IMidiManager;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiDeviceStatus;
import android.media.midi.MidiInputPort;
import android.media.midi.MidiOutputPort;
import android.media.midi.MidiReceiver;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.midi.MidiDispatcher;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MidiDeviceServer
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MidiDeviceServer";
    private IMidiManager mMidiManager;
    private MidiDeviceInfo mDeviceInfo;
    private int mInputPortCount;
    private int mOutputPortCount;
    private MidiReceiver[] mInputPortReceivers;
    private MidiDispatcher[] mOutputPortDispatchers;
    private MidiOutputPort[] mInputPortOutputPorts;
    private CopyOnWriteArrayList<MidiInputPort> mInputPorts;
    private boolean[] mInputPortOpen;
    private int[] mOutputPortOpenCount;
    private CloseGuard mGuard;
    private boolean mIsClosed;
    private Callback mCallback;
    private HashMap<IBinder, PortClient> mPortClients;
    private HashMap<MidiInputPort, PortClient> mInputPortClients;
    private IMidiDeviceServer mServer;
    private MidiDispatcher.MidiReceiverFailureHandler mInputPortFailureHandler;

    private static final FileDescriptor[] $$robo$$android_media_midi_MidiDeviceServer$createSeqPacketSocketPair() throws IOException {
        try {
            FileDescriptor fd0 = new FileDescriptor();
            FileDescriptor fd1 = new FileDescriptor();
            Os.socketpair(OsConstants.AF_UNIX, OsConstants.SOCK_SEQPACKET, 0, fd0, fd1);
            return new FileDescriptor[]{fd0, fd1};
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private void $$robo$$android_media_midi_MidiDeviceServer$__constructor__(IMidiManager midiManager, MidiReceiver[] inputPortReceivers, int numOutputPorts, Callback callback) {
        this.mInputPorts = new CopyOnWriteArrayList();
        this.mGuard = CloseGuard.get();
        this.mPortClients = new HashMap();
        this.mInputPortClients = new HashMap();
        this.mServer = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MidiDeviceServer this$0;

            private void $$robo$$android_media_midi_MidiDeviceServer_1$__constructor__(MidiDeviceServer this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final FileDescriptor $$robo$$android_media_midi_MidiDeviceServer_1$openInputPort(IBinder token, int portNumber) {
                if (this.this$0.mDeviceInfo.isPrivate() && Binder.getCallingUid() != Process.myUid()) {
                    throw new SecurityException("Can't access private device from different UID");
                }
                if (portNumber < 0 || portNumber >= this.this$0.mInputPortCount) {
                    Log.e("MidiDeviceServer", "portNumber out of range in openInputPort: " + portNumber);
                    return null;
                }
                MidiOutputPort[] midiOutputPortArray = this.this$0.mInputPortOutputPorts;
                synchronized (midiOutputPortArray) {
                    if (this.this$0.mInputPortOutputPorts[portNumber] != null) {
                        Log.d("MidiDeviceServer", "port " + portNumber + " already open");
                        return null;
                    }
                    try {
                        MidiOutputPort outputPort;
                        FileDescriptor[] pair = MidiDeviceServer.createSeqPacketSocketPair();
                        ((MidiDeviceServer)this.this$0).mInputPortOutputPorts[portNumber] = outputPort = new MidiOutputPort(pair[0], portNumber);
                        outputPort.connect(this.this$0.mInputPortReceivers[portNumber]);
                        InputPortClient client = new InputPortClient(this.this$0, token, outputPort);
                        HashMap hashMap = this.this$0.mPortClients;
                        synchronized (hashMap) {
                            this.this$0.mPortClients.put(token, client);
                        }
                        ((MidiDeviceServer)this.this$0).mInputPortOpen[portNumber] = true;
                        this.this$0.updateDeviceStatus();
                        return pair[1];
                    }
                    catch (IOException e) {
                        Log.e("MidiDeviceServer", "unable to create FileDescriptors in openInputPort");
                        return null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final FileDescriptor $$robo$$android_media_midi_MidiDeviceServer_1$openOutputPort(IBinder token, int portNumber) {
                if (this.this$0.mDeviceInfo.isPrivate() && Binder.getCallingUid() != Process.myUid()) {
                    throw new SecurityException("Can't access private device from different UID");
                }
                if (portNumber < 0 || portNumber >= this.this$0.mOutputPortCount) {
                    Log.e("MidiDeviceServer", "portNumber out of range in openOutputPort: " + portNumber);
                    return null;
                }
                try {
                    MidiDispatcher dispatcher;
                    FileDescriptor[] pair = MidiDeviceServer.createSeqPacketSocketPair();
                    MidiInputPort inputPort = new MidiInputPort(pair[0], portNumber);
                    if (this.this$0.mDeviceInfo.getType() != 2) {
                        IoUtils.setBlocking(pair[0], false);
                    }
                    MidiDispatcher midiDispatcher = dispatcher = this.this$0.mOutputPortDispatchers[portNumber];
                    synchronized (midiDispatcher) {
                        int openCount;
                        dispatcher.getSender().connect(inputPort);
                        ((MidiDeviceServer)this.this$0).mOutputPortOpenCount[portNumber] = openCount = dispatcher.getReceiverCount();
                        this.this$0.updateDeviceStatus();
                    }
                    this.this$0.mInputPorts.add(inputPort);
                    OutputPortClient client = new OutputPortClient(this.this$0, token, inputPort);
                    HashMap hashMap = this.this$0.mPortClients;
                    synchronized (hashMap) {
                        this.this$0.mPortClients.put(token, client);
                    }
                    hashMap = this.this$0.mInputPortClients;
                    synchronized (hashMap) {
                        this.this$0.mInputPortClients.put(inputPort, client);
                    }
                    return pair[1];
                }
                catch (IOException e) {
                    Log.e("MidiDeviceServer", "unable to create FileDescriptors in openOutputPort");
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_midi_MidiDeviceServer_1$closePort(IBinder token) {
                MidiInputPort inputPort = null;
                HashMap hashMap = this.this$0.mPortClients;
                synchronized (hashMap) {
                    PortClient client = (PortClient)this.this$0.mPortClients.remove(token);
                    if (client != null) {
                        inputPort = client.getInputPort();
                        client.close();
                    }
                }
                if (inputPort != null) {
                    hashMap = this.this$0.mInputPortClients;
                    synchronized (hashMap) {
                        this.this$0.mInputPortClients.remove(inputPort);
                    }
                }
            }

            private final void $$robo$$android_media_midi_MidiDeviceServer_1$closeDevice() {
                if (this.this$0.mCallback != null) {
                    this.this$0.mCallback.onClose();
                }
                IoUtils.closeQuietly(this.this$0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_media_midi_MidiDeviceServer_1$connectPorts(IBinder token, FileDescriptor fd, int outputPortNumber) {
                MidiDispatcher dispatcher;
                MidiInputPort inputPort = new MidiInputPort(fd, outputPortNumber);
                MidiDispatcher midiDispatcher = dispatcher = this.this$0.mOutputPortDispatchers[outputPortNumber];
                synchronized (midiDispatcher) {
                    int openCount;
                    dispatcher.getSender().connect(inputPort);
                    ((MidiDeviceServer)this.this$0).mOutputPortOpenCount[outputPortNumber] = openCount = dispatcher.getReceiverCount();
                    this.this$0.updateDeviceStatus();
                }
                this.this$0.mInputPorts.add(inputPort);
                OutputPortClient client = new OutputPortClient(this.this$0, token, inputPort);
                HashMap hashMap = this.this$0.mPortClients;
                synchronized (hashMap) {
                    this.this$0.mPortClients.put(token, client);
                }
                hashMap = this.this$0.mInputPortClients;
                synchronized (hashMap) {
                    this.this$0.mInputPortClients.put(inputPort, client);
                }
                return Process.myPid();
            }

            private final MidiDeviceInfo $$robo$$android_media_midi_MidiDeviceServer_1$getDeviceInfo() {
                return this.this$0.mDeviceInfo;
            }

            private final void $$robo$$android_media_midi_MidiDeviceServer_1$setDeviceInfo(MidiDeviceInfo deviceInfo) {
                if (Binder.getCallingUid() != 1000) {
                    throw new SecurityException("setDeviceInfo should only be called by MidiService");
                }
                if (this.this$0.mDeviceInfo != null) {
                    throw new IllegalStateException("setDeviceInfo should only be called once");
                }
                this.this$0.mDeviceInfo = deviceInfo;
            }

            private void __constructor__(MidiDeviceServer midiDeviceServer) {
                this.$$robo$$android_media_midi_MidiDeviceServer_1$__constructor__(midiDeviceServer);
            }
            {
                this.this$0 = midiDeviceServer;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiDeviceServer_1$__constructor__(android.media.midi.MidiDeviceServer ), 0, this, midiDeviceServer);
            }

            @Override
            public FileDescriptor openInputPort(IBinder iBinder, int n) {
                return InvokeDynamicSupport.bootstrap("openInputPort", $$robo$$android_media_midi_MidiDeviceServer_1$openInputPort(android.os.IBinder int ), 0, this, iBinder, n);
            }

            @Override
            public FileDescriptor openOutputPort(IBinder iBinder, int n) {
                return InvokeDynamicSupport.bootstrap("openOutputPort", $$robo$$android_media_midi_MidiDeviceServer_1$openOutputPort(android.os.IBinder int ), 0, this, iBinder, n);
            }

            @Override
            public void closePort(IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("closePort", $$robo$$android_media_midi_MidiDeviceServer_1$closePort(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public void closeDevice() {
                InvokeDynamicSupport.bootstrap("closeDevice", $$robo$$android_media_midi_MidiDeviceServer_1$closeDevice(), 0, this);
            }

            @Override
            public int connectPorts(IBinder iBinder, FileDescriptor fileDescriptor, int n) {
                return (int)InvokeDynamicSupport.bootstrap("connectPorts", $$robo$$android_media_midi_MidiDeviceServer_1$connectPorts(android.os.IBinder java.io.FileDescriptor int ), 0, this, iBinder, fileDescriptor, n);
            }

            @Override
            public MidiDeviceInfo getDeviceInfo() {
                return InvokeDynamicSupport.bootstrap("getDeviceInfo", $$robo$$android_media_midi_MidiDeviceServer_1$getDeviceInfo(), 0, this);
            }

            @Override
            public void setDeviceInfo(MidiDeviceInfo midiDeviceInfo) {
                InvokeDynamicSupport.bootstrap("setDeviceInfo", $$robo$$android_media_midi_MidiDeviceServer_1$setDeviceInfo(android.media.midi.MidiDeviceInfo ), 0, this, midiDeviceInfo);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mInputPortFailureHandler = new MidiDispatcher.MidiReceiverFailureHandler(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MidiDeviceServer this$0;

            private void $$robo$$android_media_midi_MidiDeviceServer_2$__constructor__(MidiDeviceServer this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_midi_MidiDeviceServer_2$onReceiverFailure(MidiReceiver receiver, IOException failure) {
                Log.e("MidiDeviceServer", "MidiInputPort failed to send data", failure);
                PortClient client = null;
                HashMap hashMap = this.this$0.mInputPortClients;
                synchronized (hashMap) {
                    client = (PortClient)this.this$0.mInputPortClients.remove(receiver);
                }
                if (client != null) {
                    client.close();
                }
            }

            private void __constructor__(MidiDeviceServer midiDeviceServer) {
                this.$$robo$$android_media_midi_MidiDeviceServer_2$__constructor__(midiDeviceServer);
            }
            {
                this.this$0 = midiDeviceServer;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiDeviceServer_2$__constructor__(android.media.midi.MidiDeviceServer ), 0, this, midiDeviceServer);
            }

            @Override
            public void onReceiverFailure(MidiReceiver midiReceiver, IOException iOException) {
                InvokeDynamicSupport.bootstrap("onReceiverFailure", $$robo$$android_media_midi_MidiDeviceServer_2$onReceiverFailure(android.media.midi.MidiReceiver java.io.IOException ), 0, this, midiReceiver, iOException);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mMidiManager = midiManager;
        this.mInputPortReceivers = inputPortReceivers;
        this.mInputPortCount = inputPortReceivers.length;
        this.mOutputPortCount = numOutputPorts;
        this.mCallback = callback;
        this.mInputPortOutputPorts = new MidiOutputPort[this.mInputPortCount];
        this.mOutputPortDispatchers = new MidiDispatcher[numOutputPorts];
        for (int i = 0; i < numOutputPorts; ++i) {
            this.mOutputPortDispatchers[i] = new MidiDispatcher(this.mInputPortFailureHandler);
        }
        this.mInputPortOpen = new boolean[this.mInputPortCount];
        this.mOutputPortOpenCount = new int[numOutputPorts];
        this.mGuard.open("close");
    }

    private void $$robo$$android_media_midi_MidiDeviceServer$__constructor__(IMidiManager midiManager, MidiReceiver[] inputPortReceivers, MidiDeviceInfo deviceInfo, Callback callback) {
        this.mDeviceInfo = deviceInfo;
    }

    private final IMidiDeviceServer $$robo$$android_media_midi_MidiDeviceServer$getBinderInterface() {
        return this.mServer;
    }

    private final IBinder $$robo$$android_media_midi_MidiDeviceServer$asBinder() {
        return this.mServer.asBinder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_midi_MidiDeviceServer$updateDeviceStatus() {
        long identityToken = Binder.clearCallingIdentity();
        MidiDeviceStatus status = new MidiDeviceStatus(this.mDeviceInfo, this.mInputPortOpen, this.mOutputPortOpenCount);
        if (this.mCallback != null) {
            this.mCallback.onDeviceStatusChanged(this, status);
        }
        try {
            this.mMidiManager.setDeviceStatus(this.mServer, status);
        }
        catch (RemoteException e) {
            Log.e("MidiDeviceServer", "RemoteException in updateDeviceStatus");
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_midi_MidiDeviceServer$close() throws IOException {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            if (this.mIsClosed) {
                return;
            }
            this.mGuard.close();
            for (int i = 0; i < this.mInputPortCount; ++i) {
                MidiOutputPort outputPort = this.mInputPortOutputPorts[i];
                if (outputPort == null) continue;
                IoUtils.closeQuietly(outputPort);
                this.mInputPortOutputPorts[i] = null;
            }
            for (MidiInputPort inputPort : this.mInputPorts) {
                IoUtils.closeQuietly(inputPort);
            }
            this.mInputPorts.clear();
            try {
                this.mMidiManager.unregisterDeviceServer(this.mServer);
            }
            catch (RemoteException e) {
                Log.e("MidiDeviceServer", "RemoteException in unregisterDeviceServer");
            }
            this.mIsClosed = true;
        }
    }

    private final void $$robo$$android_media_midi_MidiDeviceServer$finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final MidiReceiver[] $$robo$$android_media_midi_MidiDeviceServer$getOutputPortReceivers() {
        MidiReceiver[] receivers = new MidiReceiver[this.mOutputPortCount];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mOutputPortDispatchers, (int)0, (Object)receivers, (int)0, (int)this.mOutputPortCount);
        return receivers;
    }

    private static FileDescriptor[] createSeqPacketSocketPair() throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createSeqPacketSocketPair", $$robo$$android_media_midi_MidiDeviceServer$createSeqPacketSocketPair(), 0);
    }

    private void __constructor__(IMidiManager iMidiManager, MidiReceiver[] midiReceiverArray, int n, Callback callback) {
        this.$$robo$$android_media_midi_MidiDeviceServer$__constructor__(iMidiManager, midiReceiverArray, n, callback);
    }

    MidiDeviceServer(IMidiManager iMidiManager, MidiReceiver[] midiReceiverArray, int n, Callback callback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiDeviceServer$__constructor__(android.media.midi.IMidiManager android.media.midi.MidiReceiver[] int android.media.midi.MidiDeviceServer$Callback ), 0, this, iMidiManager, midiReceiverArray, n, callback);
    }

    private void __constructor__(IMidiManager iMidiManager, MidiReceiver[] midiReceiverArray, MidiDeviceInfo midiDeviceInfo, Callback callback) {
        this.$$robo$$android_media_midi_MidiDeviceServer$__constructor__(iMidiManager, midiReceiverArray, midiDeviceInfo, callback);
    }

    MidiDeviceServer(IMidiManager iMidiManager, MidiReceiver[] midiReceiverArray, MidiDeviceInfo midiDeviceInfo, Callback callback) {
        this(iMidiManager, midiReceiverArray, midiDeviceInfo.getOutputPortCount(), callback);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiDeviceServer$__constructor__(android.media.midi.IMidiManager android.media.midi.MidiReceiver[] android.media.midi.MidiDeviceInfo android.media.midi.MidiDeviceServer$Callback ), 0, this, iMidiManager, midiReceiverArray, midiDeviceInfo, callback);
    }

    IMidiDeviceServer getBinderInterface() {
        return InvokeDynamicSupport.bootstrap("getBinderInterface", $$robo$$android_media_midi_MidiDeviceServer$getBinderInterface(), 0, this);
    }

    public IBinder asBinder() {
        return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_media_midi_MidiDeviceServer$asBinder(), 0, this);
    }

    private void updateDeviceStatus() {
        InvokeDynamicSupport.bootstrap("updateDeviceStatus", $$robo$$android_media_midi_MidiDeviceServer$updateDeviceStatus(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_midi_MidiDeviceServer$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_midi_MidiDeviceServer$finalize(), 0, this);
    }

    public MidiReceiver[] getOutputPortReceivers() {
        return InvokeDynamicSupport.bootstrap("getOutputPortReceivers", $$robo$$android_media_midi_MidiDeviceServer$getOutputPortReceivers(), 0, this);
    }

    public /* synthetic */ MidiDeviceServer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MidiDeviceServer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class OutputPortClient
    extends PortClient
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MidiInputPort mInputPort;
        /* synthetic */ MidiDeviceServer this$0;

        private void $$robo$$android_media_midi_MidiDeviceServer_OutputPortClient$__constructor__(MidiDeviceServer midiDeviceServer, IBinder token, MidiInputPort inputPort) {
            this.mInputPort = inputPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_midi_MidiDeviceServer_OutputPortClient$close() {
            MidiDispatcher dispatcher;
            this.mToken.unlinkToDeath(this, 0);
            int portNumber = this.mInputPort.getPortNumber();
            MidiDispatcher midiDispatcher = dispatcher = this.this$0.mOutputPortDispatchers[portNumber];
            synchronized (midiDispatcher) {
                int openCount;
                dispatcher.getSender().disconnect(this.mInputPort);
                ((MidiDeviceServer)this.this$0).mOutputPortOpenCount[portNumber] = openCount = dispatcher.getReceiverCount();
                this.this$0.updateDeviceStatus();
            }
            this.this$0.mInputPorts.remove(this.mInputPort);
            IoUtils.closeQuietly(this.mInputPort);
        }

        private final MidiInputPort $$robo$$android_media_midi_MidiDeviceServer_OutputPortClient$getInputPort() {
            return this.mInputPort;
        }

        private void __constructor__(MidiDeviceServer midiDeviceServer, IBinder iBinder, MidiInputPort midiInputPort) {
            this.$$robo$$android_media_midi_MidiDeviceServer_OutputPortClient$__constructor__(midiDeviceServer, iBinder, midiInputPort);
        }

        OutputPortClient(MidiDeviceServer midiDeviceServer, IBinder iBinder, MidiInputPort midiInputPort) {
            this.this$0 = midiDeviceServer;
            super(midiDeviceServer, iBinder);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiDeviceServer_OutputPortClient$__constructor__(android.media.midi.MidiDeviceServer android.os.IBinder android.media.midi.MidiInputPort ), 0, this, midiDeviceServer, iBinder, midiInputPort);
        }

        @Override
        void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_midi_MidiDeviceServer_OutputPortClient$close(), 0, this);
        }

        @Override
        MidiInputPort getInputPort() {
            return InvokeDynamicSupport.bootstrap("getInputPort", $$robo$$android_media_midi_MidiDeviceServer_OutputPortClient$getInputPort(), 0, this);
        }

        public /* synthetic */ OutputPortClient() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OutputPortClient)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class InputPortClient
    extends PortClient
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MidiOutputPort mOutputPort;
        /* synthetic */ MidiDeviceServer this$0;

        private void $$robo$$android_media_midi_MidiDeviceServer_InputPortClient$__constructor__(MidiDeviceServer midiDeviceServer, IBinder token, MidiOutputPort outputPort) {
            this.mOutputPort = outputPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_midi_MidiDeviceServer_InputPortClient$close() {
            this.mToken.unlinkToDeath(this, 0);
            MidiOutputPort[] midiOutputPortArray = this.this$0.mInputPortOutputPorts;
            synchronized (midiOutputPortArray) {
                int portNumber = this.mOutputPort.getPortNumber();
                ((MidiDeviceServer)this.this$0).mInputPortOutputPorts[portNumber] = null;
                ((MidiDeviceServer)this.this$0).mInputPortOpen[portNumber] = false;
                this.this$0.updateDeviceStatus();
            }
            IoUtils.closeQuietly(this.mOutputPort);
        }

        private void __constructor__(MidiDeviceServer midiDeviceServer, IBinder iBinder, MidiOutputPort midiOutputPort) {
            this.$$robo$$android_media_midi_MidiDeviceServer_InputPortClient$__constructor__(midiDeviceServer, iBinder, midiOutputPort);
        }

        InputPortClient(MidiDeviceServer midiDeviceServer, IBinder iBinder, MidiOutputPort midiOutputPort) {
            this.this$0 = midiDeviceServer;
            super(midiDeviceServer, iBinder);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiDeviceServer_InputPortClient$__constructor__(android.media.midi.MidiDeviceServer android.os.IBinder android.media.midi.MidiOutputPort ), 0, this, midiDeviceServer, iBinder, midiOutputPort);
        }

        @Override
        void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_midi_MidiDeviceServer_InputPortClient$close(), 0, this);
        }

        public /* synthetic */ InputPortClient() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputPortClient)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private abstract class PortClient
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        IBinder mToken;
        /* synthetic */ MidiDeviceServer this$0;

        private void $$robo$$android_media_midi_MidiDeviceServer_PortClient$__constructor__(MidiDeviceServer midiDeviceServer, IBinder token) {
            this.mToken = token;
            try {
                token.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.close();
            }
        }

        abstract void close();

        private final MidiInputPort $$robo$$android_media_midi_MidiDeviceServer_PortClient$getInputPort() {
            return null;
        }

        private final void $$robo$$android_media_midi_MidiDeviceServer_PortClient$binderDied() {
            this.close();
        }

        private void __constructor__(MidiDeviceServer midiDeviceServer, IBinder iBinder) {
            this.$$robo$$android_media_midi_MidiDeviceServer_PortClient$__constructor__(midiDeviceServer, iBinder);
        }

        PortClient(MidiDeviceServer midiDeviceServer, IBinder iBinder) {
            this.this$0 = midiDeviceServer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiDeviceServer_PortClient$__constructor__(android.media.midi.MidiDeviceServer android.os.IBinder ), 0, this, midiDeviceServer, iBinder);
        }

        MidiInputPort getInputPort() {
            return InvokeDynamicSupport.bootstrap("getInputPort", $$robo$$android_media_midi_MidiDeviceServer_PortClient$getInputPort(), 0, this);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_midi_MidiDeviceServer_PortClient$binderDied(), 0, this);
        }

        public /* synthetic */ PortClient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PortClient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Callback
    extends InstrumentedInterface {
        public void onDeviceStatusChanged(MidiDeviceServer var1, MidiDeviceStatus var2);

        public void onClose();
    }
}

