/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.Context;
import android.graphics.Rect;
import android.media.PlaybackParams;
import android.media.tv.ITvInputSession;
import android.media.tv.TvInputService;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.Surface;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.invoke.CallSite;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ITvInputSessionWrapper
extends ITvInputSession.Stub
implements HandlerCaller.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TvInputSessionWrapper";
    private static int EXECUTE_MESSAGE_TIMEOUT_SHORT_MILLIS = 50;
    private static int EXECUTE_MESSAGE_TUNE_TIMEOUT_MILLIS = 2000;
    private static int EXECUTE_MESSAGE_TIMEOUT_LONG_MILLIS = 5000;
    private static int DO_RELEASE = 1;
    private static int DO_SET_MAIN = 2;
    private static int DO_SET_SURFACE = 3;
    private static int DO_DISPATCH_SURFACE_CHANGED = 4;
    private static int DO_SET_STREAM_VOLUME = 5;
    private static int DO_TUNE = 6;
    private static int DO_SET_CAPTION_ENABLED = 7;
    private static int DO_SELECT_TRACK = 8;
    private static int DO_APP_PRIVATE_COMMAND = 9;
    private static int DO_CREATE_OVERLAY_VIEW = 10;
    private static int DO_RELAYOUT_OVERLAY_VIEW = 11;
    private static int DO_REMOVE_OVERLAY_VIEW = 12;
    private static int DO_UNBLOCK_CONTENT = 13;
    private static int DO_TIME_SHIFT_PLAY = 14;
    private static int DO_TIME_SHIFT_PAUSE = 15;
    private static int DO_TIME_SHIFT_RESUME = 16;
    private static int DO_TIME_SHIFT_SEEK_TO = 17;
    private static int DO_TIME_SHIFT_SET_PLAYBACK_PARAMS = 18;
    private static int DO_TIME_SHIFT_ENABLE_POSITION_TRACKING = 19;
    private static int DO_START_RECORDING = 20;
    private static int DO_STOP_RECORDING = 21;
    private boolean mIsRecordingSession;
    private HandlerCaller mCaller;
    private TvInputService.Session mTvInputSessionImpl;
    private TvInputService.RecordingSession mTvInputRecordingSessionImpl;
    private InputChannel mChannel;
    private TvInputEventReceiver mReceiver;

    private void $$robo$$android_media_tv_ITvInputSessionWrapper$__constructor__(Context context, TvInputService.Session sessionImpl, InputChannel channel) {
        this.mIsRecordingSession = false;
        this.mCaller = new HandlerCaller(context, null, this, true);
        this.mTvInputSessionImpl = sessionImpl;
        this.mChannel = channel;
        if (channel != null) {
            this.mReceiver = new TvInputEventReceiver(this, channel, context.getMainLooper());
        }
    }

    private void $$robo$$android_media_tv_ITvInputSessionWrapper$__constructor__(Context context, TvInputService.RecordingSession recordingSessionImpl) {
        this.mIsRecordingSession = true;
        this.mCaller = new HandlerCaller(context, null, this, true);
        this.mTvInputRecordingSessionImpl = recordingSessionImpl;
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$executeMessage(Message msg) {
        if (this.mIsRecordingSession && this.mTvInputRecordingSessionImpl == null || !this.mIsRecordingSession && this.mTvInputSessionImpl == null) {
            return;
        }
        CallSite startTime = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
        switch (msg.what) {
            case 1: {
                if (this.mIsRecordingSession) {
                    this.mTvInputRecordingSessionImpl.release();
                    this.mTvInputRecordingSessionImpl = null;
                    break;
                }
                this.mTvInputSessionImpl.release();
                this.mTvInputSessionImpl = null;
                if (this.mReceiver != null) {
                    this.mReceiver.dispose();
                    this.mReceiver = null;
                }
                if (this.mChannel == null) break;
                this.mChannel.dispose();
                this.mChannel = null;
                break;
            }
            case 2: {
                this.mTvInputSessionImpl.setMain((Boolean)msg.obj);
                break;
            }
            case 3: {
                this.mTvInputSessionImpl.setSurface((Surface)msg.obj);
                break;
            }
            case 4: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.dispatchSurfaceChanged(args.argi1, args.argi2, args.argi3);
                args.recycle();
                break;
            }
            case 5: {
                this.mTvInputSessionImpl.setStreamVolume(((Float)msg.obj).floatValue());
                break;
            }
            case 6: {
                SomeArgs args = (SomeArgs)msg.obj;
                if (this.mIsRecordingSession) {
                    this.mTvInputRecordingSessionImpl.tune((Uri)args.arg1, (Bundle)args.arg2);
                } else {
                    this.mTvInputSessionImpl.tune((Uri)args.arg1, (Bundle)args.arg2);
                }
                args.recycle();
                break;
            }
            case 7: {
                this.mTvInputSessionImpl.setCaptionEnabled((Boolean)msg.obj);
                break;
            }
            case 8: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.selectTrack((Integer)args.arg1, (String)args.arg2);
                args.recycle();
                break;
            }
            case 9: {
                SomeArgs args = (SomeArgs)msg.obj;
                if (this.mIsRecordingSession) {
                    this.mTvInputRecordingSessionImpl.appPrivateCommand((String)args.arg1, (Bundle)args.arg2);
                } else {
                    this.mTvInputSessionImpl.appPrivateCommand((String)args.arg1, (Bundle)args.arg2);
                }
                args.recycle();
                break;
            }
            case 10: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.createOverlayView((IBinder)args.arg1, (Rect)args.arg2);
                args.recycle();
                break;
            }
            case 11: {
                this.mTvInputSessionImpl.relayoutOverlayView((Rect)msg.obj);
                break;
            }
            case 12: {
                this.mTvInputSessionImpl.removeOverlayView(true);
                break;
            }
            case 13: {
                this.mTvInputSessionImpl.unblockContent((String)msg.obj);
                break;
            }
            case 14: {
                this.mTvInputSessionImpl.timeShiftPlay((Uri)msg.obj);
                break;
            }
            case 15: {
                this.mTvInputSessionImpl.timeShiftPause();
                break;
            }
            case 16: {
                this.mTvInputSessionImpl.timeShiftResume();
                break;
            }
            case 17: {
                this.mTvInputSessionImpl.timeShiftSeekTo((Long)msg.obj);
                break;
            }
            case 18: {
                this.mTvInputSessionImpl.timeShiftSetPlaybackParams((PlaybackParams)msg.obj);
                break;
            }
            case 19: {
                this.mTvInputSessionImpl.timeShiftEnablePositionTracking((Boolean)msg.obj);
                break;
            }
            case 20: {
                this.mTvInputRecordingSessionImpl.startRecording((Uri)msg.obj);
                break;
            }
            case 21: {
                this.mTvInputRecordingSessionImpl.stopRecording();
                break;
            }
            default: {
                Log.w("TvInputSessionWrapper", "Unhandled message code: " + msg.what);
            }
        }
        reference var5_8 = (InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System") - startTime) / 1000000L;
        if (var5_8 > 50L) {
            Log.w("TvInputSessionWrapper", "Handling message (" + msg.what + ") took too long time (duration=" + (long)var5_8 + "ms)");
            if (msg.what == 6 && var5_8 > 2000L) {
                throw new RuntimeException("Too much time to handle tune request. (" + (long)var5_8 + "ms > " + 2000 + "ms) " + "Consider handling the tune request in a separate thread.");
            }
            if (var5_8 > 5000L) {
                throw new RuntimeException("Too much time to handle a request. (type=" + msg.what + ", " + (long)var5_8 + "ms > " + 5000 + "ms).");
            }
        }
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$release() {
        if (!this.mIsRecordingSession) {
            this.mTvInputSessionImpl.scheduleOverlayViewCleanup();
        }
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(1));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$setMain(boolean isMain) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(2, isMain));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$setSurface(Surface surface) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(3, surface));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$dispatchSurfaceChanged(int format, int width, int height) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIII(4, format, width, height, 0));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$setVolume(float volume) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(5, Float.valueOf(volume)));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$tune(Uri channelUri, Bundle params) {
        this.mCaller.removeMessages(6);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(6, channelUri, params));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$setCaptionEnabled(boolean enabled) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(7, enabled));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$selectTrack(int type, String trackId) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(8, type, trackId));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$appPrivateCommand(String action, Bundle data) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(9, action, data));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$createOverlayView(IBinder windowToken, Rect frame) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(10, windowToken, frame));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$relayoutOverlayView(Rect frame) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(11, frame));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$removeOverlayView() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(12));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$unblockContent(String unblockedRating) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(13, unblockedRating));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftPlay(Uri recordedProgramUri) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(14, recordedProgramUri));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftPause() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(15));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftResume() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(16));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftSeekTo(long timeMs) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(17, timeMs));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftSetPlaybackParams(PlaybackParams params) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(18, params));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftEnablePositionTracking(boolean enable) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(19, enable));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$startRecording(Uri programUri) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(20, programUri));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$stopRecording() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(21));
    }

    private void __constructor__(Context context, TvInputService.Session session, InputChannel inputChannel) {
        this.$$robo$$android_media_tv_ITvInputSessionWrapper$__constructor__(context, session, inputChannel);
    }

    public ITvInputSessionWrapper(Context context, TvInputService.Session session, InputChannel inputChannel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_ITvInputSessionWrapper$__constructor__(android.content.Context android.media.tv.TvInputService$Session android.view.InputChannel ), 0, this, context, session, inputChannel);
    }

    private void __constructor__(Context context, TvInputService.RecordingSession recordingSession) {
        this.$$robo$$android_media_tv_ITvInputSessionWrapper$__constructor__(context, recordingSession);
    }

    public ITvInputSessionWrapper(Context context, TvInputService.RecordingSession recordingSession) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_ITvInputSessionWrapper$__constructor__(android.content.Context android.media.tv.TvInputService$RecordingSession ), 0, this, context, recordingSession);
    }

    @Override
    public void executeMessage(Message message) {
        InvokeDynamicSupport.bootstrap("executeMessage", $$robo$$android_media_tv_ITvInputSessionWrapper$executeMessage(android.os.Message ), 0, this, message);
    }

    @Override
    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_tv_ITvInputSessionWrapper$release(), 0, this);
    }

    @Override
    public void setMain(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMain", $$robo$$android_media_tv_ITvInputSessionWrapper$setMain(boolean ), 0, this, bl);
    }

    @Override
    public void setSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_media_tv_ITvInputSessionWrapper$setSurface(android.view.Surface ), 0, this, surface);
    }

    @Override
    public void dispatchSurfaceChanged(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("dispatchSurfaceChanged", $$robo$$android_media_tv_ITvInputSessionWrapper$dispatchSurfaceChanged(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void setVolume(float f) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_tv_ITvInputSessionWrapper$setVolume(float ), 0, this, f);
    }

    @Override
    public void tune(Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_ITvInputSessionWrapper$tune(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
    }

    @Override
    public void setCaptionEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCaptionEnabled", $$robo$$android_media_tv_ITvInputSessionWrapper$setCaptionEnabled(boolean ), 0, this, bl);
    }

    @Override
    public void selectTrack(int n, String string2) {
        InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_tv_ITvInputSessionWrapper$selectTrack(int java.lang.String ), 0, this, n, string2);
    }

    @Override
    public void appPrivateCommand(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("appPrivateCommand", $$robo$$android_media_tv_ITvInputSessionWrapper$appPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    @Override
    public void createOverlayView(IBinder iBinder, Rect rect) {
        InvokeDynamicSupport.bootstrap("createOverlayView", $$robo$$android_media_tv_ITvInputSessionWrapper$createOverlayView(android.os.IBinder android.graphics.Rect ), 0, this, iBinder, rect);
    }

    @Override
    public void relayoutOverlayView(Rect rect) {
        InvokeDynamicSupport.bootstrap("relayoutOverlayView", $$robo$$android_media_tv_ITvInputSessionWrapper$relayoutOverlayView(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void removeOverlayView() {
        InvokeDynamicSupport.bootstrap("removeOverlayView", $$robo$$android_media_tv_ITvInputSessionWrapper$removeOverlayView(), 0, this);
    }

    @Override
    public void unblockContent(String string2) {
        InvokeDynamicSupport.bootstrap("unblockContent", $$robo$$android_media_tv_ITvInputSessionWrapper$unblockContent(java.lang.String ), 0, this, string2);
    }

    @Override
    public void timeShiftPlay(Uri uri) {
        InvokeDynamicSupport.bootstrap("timeShiftPlay", $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftPlay(android.net.Uri ), 0, this, uri);
    }

    @Override
    public void timeShiftPause() {
        InvokeDynamicSupport.bootstrap("timeShiftPause", $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftPause(), 0, this);
    }

    @Override
    public void timeShiftResume() {
        InvokeDynamicSupport.bootstrap("timeShiftResume", $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftResume(), 0, this);
    }

    @Override
    public void timeShiftSeekTo(long l) {
        InvokeDynamicSupport.bootstrap("timeShiftSeekTo", $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftSeekTo(long ), 0, this, l);
    }

    @Override
    public void timeShiftSetPlaybackParams(PlaybackParams playbackParams) {
        InvokeDynamicSupport.bootstrap("timeShiftSetPlaybackParams", $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftSetPlaybackParams(android.media.PlaybackParams ), 0, this, playbackParams);
    }

    @Override
    public void timeShiftEnablePositionTracking(boolean bl) {
        InvokeDynamicSupport.bootstrap("timeShiftEnablePositionTracking", $$robo$$android_media_tv_ITvInputSessionWrapper$timeShiftEnablePositionTracking(boolean ), 0, this, bl);
    }

    @Override
    public void startRecording(Uri uri) {
        InvokeDynamicSupport.bootstrap("startRecording", $$robo$$android_media_tv_ITvInputSessionWrapper$startRecording(android.net.Uri ), 0, this, uri);
    }

    @Override
    public void stopRecording() {
        InvokeDynamicSupport.bootstrap("stopRecording", $$robo$$android_media_tv_ITvInputSessionWrapper$stopRecording(), 0, this);
    }

    public /* synthetic */ ITvInputSessionWrapper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ITvInputSessionWrapper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class TvInputEventReceiver
    extends InputEventReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ITvInputSessionWrapper this$0;

        private void $$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$__constructor__(ITvInputSessionWrapper iTvInputSessionWrapper, InputChannel inputChannel, Looper looper) {
        }

        private final void $$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$onInputEvent(InputEvent event, int displayId) {
            if (this.this$0.mTvInputSessionImpl == null) {
                this.finishInputEvent(event, false);
                return;
            }
            int handled = this.this$0.mTvInputSessionImpl.dispatchInputEvent(event, this);
            if (handled != -1) {
                this.finishInputEvent(event, handled == 1);
            }
        }

        private void __constructor__(ITvInputSessionWrapper iTvInputSessionWrapper, InputChannel inputChannel, Looper looper) {
            this.$$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$__constructor__(iTvInputSessionWrapper, inputChannel, looper);
        }

        public TvInputEventReceiver(ITvInputSessionWrapper iTvInputSessionWrapper, InputChannel inputChannel, Looper looper) {
            this.this$0 = iTvInputSessionWrapper;
            super(inputChannel, looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$__constructor__(android.media.tv.ITvInputSessionWrapper android.view.InputChannel android.os.Looper ), 0, this, iTvInputSessionWrapper, inputChannel, looper);
        }

        @Override
        public void onInputEvent(InputEvent inputEvent, int n) {
            InvokeDynamicSupport.bootstrap("onInputEvent", $$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$onInputEvent(android.view.InputEvent int ), 0, this, inputEvent, n);
        }

        public /* synthetic */ TvInputEventReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputEventReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

