/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.Intent;
import android.graphics.Rect;
import android.media.PlaybackParams;
import android.media.tv.DvbDeviceInfo;
import android.media.tv.ITvInputClient;
import android.media.tv.ITvInputHardware;
import android.media.tv.ITvInputHardwareCallback;
import android.media.tv.ITvInputManager;
import android.media.tv.ITvInputManagerCallback;
import android.media.tv.TvContentRating;
import android.media.tv.TvContentRatingSystemInfo;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvStreamConfig;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pools;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.View;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TvInputManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TvInputManager";
    static int DVB_DEVICE_START = 0;
    static int DVB_DEVICE_END = 2;
    public static int DVB_DEVICE_DEMUX = 0;
    public static int DVB_DEVICE_DVR = 1;
    public static int DVB_DEVICE_FRONTEND = 2;
    static int VIDEO_UNAVAILABLE_REASON_START = 0;
    static int VIDEO_UNAVAILABLE_REASON_END = 4;
    public static int VIDEO_UNAVAILABLE_REASON_UNKNOWN = 0;
    public static int VIDEO_UNAVAILABLE_REASON_TUNING = 1;
    public static int VIDEO_UNAVAILABLE_REASON_WEAK_SIGNAL = 2;
    public static int VIDEO_UNAVAILABLE_REASON_BUFFERING = 3;
    public static int VIDEO_UNAVAILABLE_REASON_AUDIO_ONLY = 4;
    public static int TIME_SHIFT_STATUS_UNKNOWN = 0;
    public static int TIME_SHIFT_STATUS_UNSUPPORTED = 1;
    public static int TIME_SHIFT_STATUS_UNAVAILABLE = 2;
    public static int TIME_SHIFT_STATUS_AVAILABLE = 3;
    public static long TIME_SHIFT_INVALID_TIME = Long.MIN_VALUE;
    static int RECORDING_ERROR_START = 0;
    static int RECORDING_ERROR_END = 2;
    public static int RECORDING_ERROR_UNKNOWN = 0;
    public static int RECORDING_ERROR_INSUFFICIENT_SPACE = 1;
    public static int RECORDING_ERROR_RESOURCE_BUSY = 2;
    public static int INPUT_STATE_CONNECTED = 0;
    public static int INPUT_STATE_CONNECTED_STANDBY = 1;
    public static int INPUT_STATE_DISCONNECTED = 2;
    public static String ACTION_BLOCKED_RATINGS_CHANGED = "android.media.tv.action.BLOCKED_RATINGS_CHANGED";
    public static String ACTION_PARENTAL_CONTROLS_ENABLED_CHANGED = "android.media.tv.action.PARENTAL_CONTROLS_ENABLED_CHANGED";
    public static String ACTION_QUERY_CONTENT_RATING_SYSTEMS = "android.media.tv.action.QUERY_CONTENT_RATING_SYSTEMS";
    public static String META_DATA_CONTENT_RATING_SYSTEMS = "android.media.tv.metadata.CONTENT_RATING_SYSTEMS";
    public static String ACTION_SETUP_INPUTS = "android.media.tv.action.SETUP_INPUTS";
    public static String ACTION_VIEW_RECORDING_SCHEDULES = "android.media.tv.action.VIEW_RECORDING_SCHEDULES";
    private ITvInputManager mService;
    private Object mLock;
    private List<TvInputCallbackRecord> mCallbackRecords;
    private Map<String, Integer> mStateMap;
    private SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap;
    private int mNextSeq;
    private ITvInputClient mClient;
    private int mUserId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_media_tv_TvInputManager$__constructor__(ITvInputManager service, int userId) {
        block6: {
            this.mLock = new Object();
            this.mCallbackRecords = new LinkedList<TvInputCallbackRecord>();
            this.mStateMap = new ArrayMap<String, Integer>();
            this.mSessionCallbackRecordMap = new SparseArray();
            this.mService = service;
            this.mUserId = userId;
            this.mClient = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TvInputManager this$0;

                private void $$robo$$android_media_tv_TvInputManager_1$__constructor__(TvInputManager this$0) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onSessionCreated(String inputId, IBinder token, InputChannel channel, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for " + token);
                            return;
                        }
                        Session session = null;
                        if (token != null) {
                            session = new Session(token, channel, this.this$0.mService, this.this$0.mUserId, seq, this.this$0.mSessionCallbackRecordMap);
                        }
                        record.postSessionCreated(session);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onSessionReleased(int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        this.this$0.mSessionCallbackRecordMap.delete(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq:" + seq);
                            return;
                        }
                        record.mSession.releaseInternal();
                        record.postSessionReleased();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onChannelRetuned(Uri channelUri, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postChannelRetuned(channelUri);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onTracksChanged(List<TvTrackInfo> tracks, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        if (record.mSession.updateTracks(tracks)) {
                            record.postTracksChanged(tracks);
                            this.postVideoSizeChangedIfNeededLocked(record);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onTrackSelected(int type, String trackId, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        if (record.mSession.updateTrackSelection(type, trackId)) {
                            record.postTrackSelected(type, trackId);
                            this.postVideoSizeChangedIfNeededLocked(record);
                        }
                    }
                }

                private final void $$robo$$android_media_tv_TvInputManager_1$postVideoSizeChangedIfNeededLocked(SessionCallbackRecord record) {
                    TvTrackInfo track = record.mSession.getVideoTrackToNotify();
                    if (track != null) {
                        record.postVideoSizeChanged(track.getVideoWidth(), track.getVideoHeight());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onVideoAvailable(int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postVideoAvailable();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onVideoUnavailable(int reason, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postVideoUnavailable(reason);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onContentAllowed(int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postContentAllowed();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onContentBlocked(String rating, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postContentBlocked(TvContentRating.unflattenFromString(rating));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onLayoutSurface(int left, int top, int right, int bottom, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postLayoutSurface(left, top, right, bottom);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onSessionEvent(String eventType, Bundle eventArgs, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postSessionEvent(eventType, eventArgs);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onTimeShiftStatusChanged(int status, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTimeShiftStatusChanged(status);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onTimeShiftStartPositionChanged(long timeMs, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTimeShiftStartPositionChanged(timeMs);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onTimeShiftCurrentPositionChanged(long timeMs, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTimeShiftCurrentPositionChanged(timeMs);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onTuned(int seq, Uri channelUri) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTuned(channelUri);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onRecordingStopped(Uri recordedProgramUri, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postRecordingStopped(recordedProgramUri);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_1$onError(int error, int seq) {
                    SparseArray sparseArray = this.this$0.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = (SessionCallbackRecord)this.this$0.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e("TvInputManager", "Callback not found for seq " + seq);
                            return;
                        }
                        record.postError(error);
                    }
                }

                private void __constructor__(TvInputManager tvInputManager) {
                    this.$$robo$$android_media_tv_TvInputManager_1$__constructor__(tvInputManager);
                }
                {
                    this.this$0 = tvInputManager;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_1$__constructor__(android.media.tv.TvInputManager ), 0, this, tvInputManager);
                }

                @Override
                public void onSessionCreated(String string2, IBinder iBinder, InputChannel inputChannel, int n) {
                    InvokeDynamicSupport.bootstrap("onSessionCreated", $$robo$$android_media_tv_TvInputManager_1$onSessionCreated(java.lang.String android.os.IBinder android.view.InputChannel int ), 0, this, string2, iBinder, inputChannel, n);
                }

                @Override
                public void onSessionReleased(int n) {
                    InvokeDynamicSupport.bootstrap("onSessionReleased", $$robo$$android_media_tv_TvInputManager_1$onSessionReleased(int ), 0, this, n);
                }

                @Override
                public void onChannelRetuned(Uri uri, int n) {
                    InvokeDynamicSupport.bootstrap("onChannelRetuned", $$robo$$android_media_tv_TvInputManager_1$onChannelRetuned(android.net.Uri int ), 0, this, uri, n);
                }

                @Override
                public void onTracksChanged(List<TvTrackInfo> list, int n) {
                    InvokeDynamicSupport.bootstrap("onTracksChanged", $$robo$$android_media_tv_TvInputManager_1$onTracksChanged(java.util.List<android.media.tv.TvTrackInfo> int ), 0, this, list, n);
                }

                @Override
                public void onTrackSelected(int n, String string2, int n2) {
                    InvokeDynamicSupport.bootstrap("onTrackSelected", $$robo$$android_media_tv_TvInputManager_1$onTrackSelected(int java.lang.String int ), 0, this, n, string2, n2);
                }

                private void postVideoSizeChangedIfNeededLocked(SessionCallbackRecord sessionCallbackRecord) {
                    InvokeDynamicSupport.bootstrap("postVideoSizeChangedIfNeededLocked", $$robo$$android_media_tv_TvInputManager_1$postVideoSizeChangedIfNeededLocked(android.media.tv.TvInputManager$SessionCallbackRecord ), 0, this, sessionCallbackRecord);
                }

                @Override
                public void onVideoAvailable(int n) {
                    InvokeDynamicSupport.bootstrap("onVideoAvailable", $$robo$$android_media_tv_TvInputManager_1$onVideoAvailable(int ), 0, this, n);
                }

                @Override
                public void onVideoUnavailable(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("onVideoUnavailable", $$robo$$android_media_tv_TvInputManager_1$onVideoUnavailable(int int ), 0, this, n, n2);
                }

                @Override
                public void onContentAllowed(int n) {
                    InvokeDynamicSupport.bootstrap("onContentAllowed", $$robo$$android_media_tv_TvInputManager_1$onContentAllowed(int ), 0, this, n);
                }

                @Override
                public void onContentBlocked(String string2, int n) {
                    InvokeDynamicSupport.bootstrap("onContentBlocked", $$robo$$android_media_tv_TvInputManager_1$onContentBlocked(java.lang.String int ), 0, this, string2, n);
                }

                @Override
                public void onLayoutSurface(int n, int n2, int n3, int n4, int n5) {
                    InvokeDynamicSupport.bootstrap("onLayoutSurface", $$robo$$android_media_tv_TvInputManager_1$onLayoutSurface(int int int int int ), 0, this, n, n2, n3, n4, n5);
                }

                @Override
                public void onSessionEvent(String string2, Bundle bundle, int n) {
                    InvokeDynamicSupport.bootstrap("onSessionEvent", $$robo$$android_media_tv_TvInputManager_1$onSessionEvent(java.lang.String android.os.Bundle int ), 0, this, string2, bundle, n);
                }

                @Override
                public void onTimeShiftStatusChanged(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("onTimeShiftStatusChanged", $$robo$$android_media_tv_TvInputManager_1$onTimeShiftStatusChanged(int int ), 0, this, n, n2);
                }

                @Override
                public void onTimeShiftStartPositionChanged(long l, int n) {
                    InvokeDynamicSupport.bootstrap("onTimeShiftStartPositionChanged", $$robo$$android_media_tv_TvInputManager_1$onTimeShiftStartPositionChanged(long int ), 0, this, l, n);
                }

                @Override
                public void onTimeShiftCurrentPositionChanged(long l, int n) {
                    InvokeDynamicSupport.bootstrap("onTimeShiftCurrentPositionChanged", $$robo$$android_media_tv_TvInputManager_1$onTimeShiftCurrentPositionChanged(long int ), 0, this, l, n);
                }

                @Override
                public void onTuned(int n, Uri uri) {
                    InvokeDynamicSupport.bootstrap("onTuned", $$robo$$android_media_tv_TvInputManager_1$onTuned(int android.net.Uri ), 0, this, n, uri);
                }

                @Override
                public void onRecordingStopped(Uri uri, int n) {
                    InvokeDynamicSupport.bootstrap("onRecordingStopped", $$robo$$android_media_tv_TvInputManager_1$onRecordingStopped(android.net.Uri int ), 0, this, uri, n);
                }

                @Override
                public void onError(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_tv_TvInputManager_1$onError(int int ), 0, this, n, n2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            ShadowedObject managerCallback = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TvInputManager this$0;

                private void $$robo$$android_media_tv_TvInputManager_2$__constructor__(TvInputManager this$0) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_2$onInputAdded(String inputId) {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        this.this$0.mStateMap.put(inputId, 0);
                        for (TvInputCallbackRecord record : this.this$0.mCallbackRecords) {
                            record.postInputAdded(inputId);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_2$onInputRemoved(String inputId) {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        this.this$0.mStateMap.remove(inputId);
                        for (TvInputCallbackRecord record : this.this$0.mCallbackRecords) {
                            record.postInputRemoved(inputId);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_2$onInputUpdated(String inputId) {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        for (TvInputCallbackRecord record : this.this$0.mCallbackRecords) {
                            record.postInputUpdated(inputId);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_2$onInputStateChanged(String inputId, int state) {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        this.this$0.mStateMap.put(inputId, state);
                        for (TvInputCallbackRecord record : this.this$0.mCallbackRecords) {
                            record.postInputStateChanged(inputId, state);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_tv_TvInputManager_2$onTvInputInfoUpdated(TvInputInfo inputInfo) {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        for (TvInputCallbackRecord record : this.this$0.mCallbackRecords) {
                            record.postTvInputInfoUpdated(inputInfo);
                        }
                    }
                }

                private void __constructor__(TvInputManager tvInputManager) {
                    this.$$robo$$android_media_tv_TvInputManager_2$__constructor__(tvInputManager);
                }
                {
                    this.this$0 = tvInputManager;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_2$__constructor__(android.media.tv.TvInputManager ), 0, this, tvInputManager);
                }

                @Override
                public void onInputAdded(String string2) {
                    InvokeDynamicSupport.bootstrap("onInputAdded", $$robo$$android_media_tv_TvInputManager_2$onInputAdded(java.lang.String ), 0, this, string2);
                }

                @Override
                public void onInputRemoved(String string2) {
                    InvokeDynamicSupport.bootstrap("onInputRemoved", $$robo$$android_media_tv_TvInputManager_2$onInputRemoved(java.lang.String ), 0, this, string2);
                }

                @Override
                public void onInputUpdated(String string2) {
                    InvokeDynamicSupport.bootstrap("onInputUpdated", $$robo$$android_media_tv_TvInputManager_2$onInputUpdated(java.lang.String ), 0, this, string2);
                }

                @Override
                public void onInputStateChanged(String string2, int n) {
                    InvokeDynamicSupport.bootstrap("onInputStateChanged", $$robo$$android_media_tv_TvInputManager_2$onInputStateChanged(java.lang.String int ), 0, this, string2, n);
                }

                @Override
                public void onTvInputInfoUpdated(TvInputInfo tvInputInfo) {
                    InvokeDynamicSupport.bootstrap("onTvInputInfoUpdated", $$robo$$android_media_tv_TvInputManager_2$onTvInputInfoUpdated(android.media.tv.TvInputInfo ), 0, this, tvInputInfo);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            try {
                if (this.mService == null) break block6;
                this.mService.registerCallback((ITvInputManagerCallback)managerCallback, this.mUserId);
                List<TvInputInfo> infos = this.mService.getTvInputList(this.mUserId);
                Object object = this.mLock;
                synchronized (object) {
                    for (TvInputInfo info : infos) {
                        String inputId = info.getId();
                        this.mStateMap.put(inputId, this.mService.getTvInputState(inputId, this.mUserId));
                    }
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final List<TvInputInfo> $$robo$$android_media_tv_TvInputManager$getTvInputList() {
        try {
            return this.mService.getTvInputList(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final TvInputInfo $$robo$$android_media_tv_TvInputManager$getTvInputInfo(String inputId) {
        Preconditions.checkNotNull(inputId);
        try {
            return this.mService.getTvInputInfo(inputId, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$updateTvInputInfo(TvInputInfo inputInfo) {
        Preconditions.checkNotNull(inputInfo);
        try {
            this.mService.updateTvInputInfo(inputInfo, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_tv_TvInputManager$getInputState(String inputId) {
        Preconditions.checkNotNull(inputId);
        Object object = this.mLock;
        synchronized (object) {
            Integer state = this.mStateMap.get(inputId);
            if (state == null) {
                Log.w("TvInputManager", "Unrecognized input ID: " + inputId);
                return 2;
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_tv_TvInputManager$registerCallback(TvInputCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(handler);
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackRecords.add(new TvInputCallbackRecord(callback, handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_tv_TvInputManager$unregisterCallback(TvInputCallback callback) {
        Preconditions.checkNotNull(callback);
        Object object = this.mLock;
        synchronized (object) {
            Iterator<TvInputCallbackRecord> it = this.mCallbackRecords.iterator();
            while (it.hasNext()) {
                TvInputCallbackRecord record = it.next();
                if (record.getCallback() != callback) continue;
                it.remove();
                break;
            }
        }
    }

    private final boolean $$robo$$android_media_tv_TvInputManager$isParentalControlsEnabled() {
        try {
            return this.mService.isParentalControlsEnabled(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$setParentalControlsEnabled(boolean enabled) {
        try {
            this.mService.setParentalControlsEnabled(enabled, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_tv_TvInputManager$isRatingBlocked(TvContentRating rating) {
        Preconditions.checkNotNull(rating);
        try {
            return this.mService.isRatingBlocked(rating.flattenToString(), this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<TvContentRating> $$robo$$android_media_tv_TvInputManager$getBlockedRatings() {
        try {
            ArrayList<TvContentRating> ratings = new ArrayList<TvContentRating>();
            for (String rating : this.mService.getBlockedRatings(this.mUserId)) {
                ratings.add(TvContentRating.unflattenFromString(rating));
            }
            return ratings;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$addBlockedRating(TvContentRating rating) {
        Preconditions.checkNotNull(rating);
        try {
            this.mService.addBlockedRating(rating.flattenToString(), this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$removeBlockedRating(TvContentRating rating) {
        Preconditions.checkNotNull(rating);
        try {
            this.mService.removeBlockedRating(rating.flattenToString(), this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<TvContentRatingSystemInfo> $$robo$$android_media_tv_TvInputManager$getTvContentRatingSystemList() {
        try {
            return this.mService.getTvContentRatingSystemList(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$notifyPreviewProgramBrowsableDisabled(String packageName, long programId) {
        Intent intent = new Intent();
        intent.setAction("android.media.tv.action.PREVIEW_PROGRAM_BROWSABLE_DISABLED");
        intent.putExtra("android.media.tv.extra.PREVIEW_PROGRAM_ID", programId);
        intent.setPackage(packageName);
        try {
            this.mService.sendTvInputNotifyIntent(intent, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$notifyWatchNextProgramBrowsableDisabled(String packageName, long programId) {
        Intent intent = new Intent();
        intent.setAction("android.media.tv.action.WATCH_NEXT_PROGRAM_BROWSABLE_DISABLED");
        intent.putExtra("android.media.tv.extra.WATCH_NEXT_PROGRAM_ID", programId);
        intent.setPackage(packageName);
        try {
            this.mService.sendTvInputNotifyIntent(intent, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$notifyPreviewProgramAddedToWatchNext(String packageName, long previewProgramId, long watchNextProgramId) {
        Intent intent = new Intent();
        intent.setAction("android.media.tv.action.PREVIEW_PROGRAM_ADDED_TO_WATCH_NEXT");
        intent.putExtra("android.media.tv.extra.PREVIEW_PROGRAM_ID", previewProgramId);
        intent.putExtra("android.media.tv.extra.WATCH_NEXT_PROGRAM_ID", watchNextProgramId);
        intent.setPackage(packageName);
        try {
            this.mService.sendTvInputNotifyIntent(intent, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$createSession(String inputId, SessionCallback callback, Handler handler) {
        this.createSessionInternal(inputId, false, callback, handler);
    }

    private final void $$robo$$android_media_tv_TvInputManager$createRecordingSession(String inputId, SessionCallback callback, Handler handler) {
        this.createSessionInternal(inputId, true, callback, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_tv_TvInputManager$createSessionInternal(String inputId, boolean isRecordingSession, SessionCallback callback, Handler handler) {
        Preconditions.checkNotNull(inputId);
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(handler);
        SessionCallbackRecord record = new SessionCallbackRecord(callback, handler);
        SparseArray<SessionCallbackRecord> sparseArray = this.mSessionCallbackRecordMap;
        synchronized (sparseArray) {
            int seq = this.mNextSeq++;
            this.mSessionCallbackRecordMap.put(seq, record);
            try {
                this.mService.createSession(this.mClient, inputId, isRecordingSession, seq, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final List<TvStreamConfig> $$robo$$android_media_tv_TvInputManager$getAvailableTvStreamConfigList(String inputId) {
        try {
            return this.mService.getAvailableTvStreamConfigList(inputId, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_tv_TvInputManager$captureFrame(String inputId, Surface surface, TvStreamConfig config) {
        try {
            return this.mService.captureFrame(inputId, surface, config, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_tv_TvInputManager$isSingleSessionActive() {
        try {
            return this.mService.isSingleSessionActive(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<TvInputHardwareInfo> $$robo$$android_media_tv_TvInputManager$getHardwareList() {
        try {
            return this.mService.getHardwareList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Hardware $$robo$$android_media_tv_TvInputManager$acquireTvInputHardware(int deviceId, HardwareCallback callback, TvInputInfo info) {
        return this.acquireTvInputHardware(deviceId, info, callback);
    }

    private final Hardware $$robo$$android_media_tv_TvInputManager$acquireTvInputHardware(int deviceId, TvInputInfo info, HardwareCallback callback) {
        try {
            return new Hardware(this.mService.acquireTvInputHardware(deviceId, (ITvInputHardwareCallback)new ShadowedObject(this, callback){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ HardwareCallback val$callback;
                /* synthetic */ TvInputManager this$0;

                private void $$robo$$android_media_tv_TvInputManager_3$__constructor__(TvInputManager this$0, HardwareCallback hardwareCallback) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_3$onReleased() {
                    this.val$callback.onReleased();
                }

                private final void $$robo$$android_media_tv_TvInputManager_3$onStreamConfigChanged(TvStreamConfig[] configs) {
                    this.val$callback.onStreamConfigChanged(configs);
                }

                private void __constructor__(TvInputManager tvInputManager, HardwareCallback hardwareCallback) {
                    this.$$robo$$android_media_tv_TvInputManager_3$__constructor__(tvInputManager, hardwareCallback);
                }
                {
                    this.this$0 = tvInputManager;
                    this.val$callback = hardwareCallback;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_3$__constructor__(android.media.tv.TvInputManager android.media.tv.TvInputManager$HardwareCallback ), 0, this, tvInputManager, hardwareCallback);
                }

                @Override
                public void onReleased() {
                    InvokeDynamicSupport.bootstrap("onReleased", $$robo$$android_media_tv_TvInputManager_3$onReleased(), 0, this);
                }

                @Override
                public void onStreamConfigChanged(TvStreamConfig[] tvStreamConfigArray) {
                    InvokeDynamicSupport.bootstrap("onStreamConfigChanged", $$robo$$android_media_tv_TvInputManager_3$onStreamConfigChanged(android.media.tv.TvStreamConfig[] ), 0, this, tvStreamConfigArray);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }, info, this.mUserId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$releaseTvInputHardware(int deviceId, Hardware hardware) {
        try {
            this.mService.releaseTvInputHardware(deviceId, hardware.getInterface(), this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<DvbDeviceInfo> $$robo$$android_media_tv_TvInputManager$getDvbDeviceList() {
        try {
            return this.mService.getDvbDeviceList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ParcelFileDescriptor $$robo$$android_media_tv_TvInputManager$openDvbDevice(DvbDeviceInfo info, int device) {
        try {
            if (0 > device || 2 < device) {
                throw new IllegalArgumentException("Invalid DVB device: " + device);
            }
            return this.mService.openDvbDevice(info, device);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_tv_TvInputManager$requestChannelBrowsable(Uri channelUri) {
        try {
            this.mService.requestChannelBrowsable(channelUri, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void __constructor__(ITvInputManager iTvInputManager, int n) {
        this.$$robo$$android_media_tv_TvInputManager$__constructor__(iTvInputManager, n);
    }

    public TvInputManager(ITvInputManager iTvInputManager, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager$__constructor__(android.media.tv.ITvInputManager int ), 0, this, iTvInputManager, n);
    }

    public List<TvInputInfo> getTvInputList() {
        return InvokeDynamicSupport.bootstrap("getTvInputList", $$robo$$android_media_tv_TvInputManager$getTvInputList(), 0, this);
    }

    public TvInputInfo getTvInputInfo(String string2) {
        return InvokeDynamicSupport.bootstrap("getTvInputInfo", $$robo$$android_media_tv_TvInputManager$getTvInputInfo(java.lang.String ), 0, this, string2);
    }

    public void updateTvInputInfo(TvInputInfo tvInputInfo) {
        InvokeDynamicSupport.bootstrap("updateTvInputInfo", $$robo$$android_media_tv_TvInputManager$updateTvInputInfo(android.media.tv.TvInputInfo ), 0, this, tvInputInfo);
    }

    public int getInputState(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getInputState", $$robo$$android_media_tv_TvInputManager$getInputState(java.lang.String ), 0, this, string2);
    }

    public void registerCallback(TvInputCallback tvInputCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_media_tv_TvInputManager$registerCallback(android.media.tv.TvInputManager$TvInputCallback android.os.Handler ), 0, this, tvInputCallback, handler);
    }

    public void unregisterCallback(TvInputCallback tvInputCallback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_media_tv_TvInputManager$unregisterCallback(android.media.tv.TvInputManager$TvInputCallback ), 0, this, tvInputCallback);
    }

    public boolean isParentalControlsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isParentalControlsEnabled", $$robo$$android_media_tv_TvInputManager$isParentalControlsEnabled(), 0, this);
    }

    public void setParentalControlsEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParentalControlsEnabled", $$robo$$android_media_tv_TvInputManager$setParentalControlsEnabled(boolean ), 0, this, bl);
    }

    public boolean isRatingBlocked(TvContentRating tvContentRating) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRatingBlocked", $$robo$$android_media_tv_TvInputManager$isRatingBlocked(android.media.tv.TvContentRating ), 0, this, tvContentRating);
    }

    public List<TvContentRating> getBlockedRatings() {
        return InvokeDynamicSupport.bootstrap("getBlockedRatings", $$robo$$android_media_tv_TvInputManager$getBlockedRatings(), 0, this);
    }

    public void addBlockedRating(TvContentRating tvContentRating) {
        InvokeDynamicSupport.bootstrap("addBlockedRating", $$robo$$android_media_tv_TvInputManager$addBlockedRating(android.media.tv.TvContentRating ), 0, this, tvContentRating);
    }

    public void removeBlockedRating(TvContentRating tvContentRating) {
        InvokeDynamicSupport.bootstrap("removeBlockedRating", $$robo$$android_media_tv_TvInputManager$removeBlockedRating(android.media.tv.TvContentRating ), 0, this, tvContentRating);
    }

    public List<TvContentRatingSystemInfo> getTvContentRatingSystemList() {
        return InvokeDynamicSupport.bootstrap("getTvContentRatingSystemList", $$robo$$android_media_tv_TvInputManager$getTvContentRatingSystemList(), 0, this);
    }

    public void notifyPreviewProgramBrowsableDisabled(String string2, long l) {
        InvokeDynamicSupport.bootstrap("notifyPreviewProgramBrowsableDisabled", $$robo$$android_media_tv_TvInputManager$notifyPreviewProgramBrowsableDisabled(java.lang.String long ), 0, this, string2, l);
    }

    public void notifyWatchNextProgramBrowsableDisabled(String string2, long l) {
        InvokeDynamicSupport.bootstrap("notifyWatchNextProgramBrowsableDisabled", $$robo$$android_media_tv_TvInputManager$notifyWatchNextProgramBrowsableDisabled(java.lang.String long ), 0, this, string2, l);
    }

    public void notifyPreviewProgramAddedToWatchNext(String string2, long l, long l2) {
        InvokeDynamicSupport.bootstrap("notifyPreviewProgramAddedToWatchNext", $$robo$$android_media_tv_TvInputManager$notifyPreviewProgramAddedToWatchNext(java.lang.String long long ), 0, this, string2, l, l2);
    }

    public void createSession(String string2, SessionCallback sessionCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("createSession", $$robo$$android_media_tv_TvInputManager$createSession(java.lang.String android.media.tv.TvInputManager$SessionCallback android.os.Handler ), 0, this, string2, sessionCallback, handler);
    }

    public void createRecordingSession(String string2, SessionCallback sessionCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("createRecordingSession", $$robo$$android_media_tv_TvInputManager$createRecordingSession(java.lang.String android.media.tv.TvInputManager$SessionCallback android.os.Handler ), 0, this, string2, sessionCallback, handler);
    }

    private void createSessionInternal(String string2, boolean bl, SessionCallback sessionCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("createSessionInternal", $$robo$$android_media_tv_TvInputManager$createSessionInternal(java.lang.String boolean android.media.tv.TvInputManager$SessionCallback android.os.Handler ), 0, this, string2, bl, sessionCallback, handler);
    }

    public List<TvStreamConfig> getAvailableTvStreamConfigList(String string2) {
        return InvokeDynamicSupport.bootstrap("getAvailableTvStreamConfigList", $$robo$$android_media_tv_TvInputManager$getAvailableTvStreamConfigList(java.lang.String ), 0, this, string2);
    }

    public boolean captureFrame(String string2, Surface surface, TvStreamConfig tvStreamConfig) {
        return (boolean)InvokeDynamicSupport.bootstrap("captureFrame", $$robo$$android_media_tv_TvInputManager$captureFrame(java.lang.String android.view.Surface android.media.tv.TvStreamConfig ), 0, this, string2, surface, tvStreamConfig);
    }

    public boolean isSingleSessionActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSingleSessionActive", $$robo$$android_media_tv_TvInputManager$isSingleSessionActive(), 0, this);
    }

    public List<TvInputHardwareInfo> getHardwareList() {
        return InvokeDynamicSupport.bootstrap("getHardwareList", $$robo$$android_media_tv_TvInputManager$getHardwareList(), 0, this);
    }

    public Hardware acquireTvInputHardware(int n, HardwareCallback hardwareCallback, TvInputInfo tvInputInfo) {
        return InvokeDynamicSupport.bootstrap("acquireTvInputHardware", $$robo$$android_media_tv_TvInputManager$acquireTvInputHardware(int android.media.tv.TvInputManager$HardwareCallback android.media.tv.TvInputInfo ), 0, this, n, hardwareCallback, tvInputInfo);
    }

    public Hardware acquireTvInputHardware(int n, TvInputInfo tvInputInfo, HardwareCallback hardwareCallback) {
        return InvokeDynamicSupport.bootstrap("acquireTvInputHardware", $$robo$$android_media_tv_TvInputManager$acquireTvInputHardware(int android.media.tv.TvInputInfo android.media.tv.TvInputManager$HardwareCallback ), 0, this, n, tvInputInfo, hardwareCallback);
    }

    public void releaseTvInputHardware(int n, Hardware hardware) {
        InvokeDynamicSupport.bootstrap("releaseTvInputHardware", $$robo$$android_media_tv_TvInputManager$releaseTvInputHardware(int android.media.tv.TvInputManager$Hardware ), 0, this, n, hardware);
    }

    public List<DvbDeviceInfo> getDvbDeviceList() {
        return InvokeDynamicSupport.bootstrap("getDvbDeviceList", $$robo$$android_media_tv_TvInputManager$getDvbDeviceList(), 0, this);
    }

    public ParcelFileDescriptor openDvbDevice(DvbDeviceInfo dvbDeviceInfo, int n) {
        return InvokeDynamicSupport.bootstrap("openDvbDevice", $$robo$$android_media_tv_TvInputManager$openDvbDevice(android.media.tv.DvbDeviceInfo int ), 0, this, dvbDeviceInfo, n);
    }

    public void requestChannelBrowsable(Uri uri) {
        InvokeDynamicSupport.bootstrap("requestChannelBrowsable", $$robo$$android_media_tv_TvInputManager$requestChannelBrowsable(android.net.Uri ), 0, this, uri);
    }

    public /* synthetic */ TvInputManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Hardware
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ITvInputHardware mInterface;

        private void $$robo$$android_media_tv_TvInputManager_Hardware$__constructor__(ITvInputHardware hardwareInterface) {
            this.mInterface = hardwareInterface;
        }

        private final ITvInputHardware $$robo$$android_media_tv_TvInputManager_Hardware$getInterface() {
            return this.mInterface;
        }

        private final boolean $$robo$$android_media_tv_TvInputManager_Hardware$setSurface(Surface surface, TvStreamConfig config) {
            try {
                return this.mInterface.setSurface(surface, config);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Hardware$setStreamVolume(float volume) {
            try {
                this.mInterface.setStreamVolume(volume);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        private final boolean $$robo$$android_media_tv_TvInputManager_Hardware$dispatchKeyEventToHdmi(KeyEvent event) {
            try {
                return this.mInterface.dispatchKeyEventToHdmi(event);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Hardware$overrideAudioSink(int audioType, String audioAddress, int samplingRate, int channelMask, int format) {
            try {
                this.mInterface.overrideAudioSink(audioType, audioAddress, samplingRate, channelMask, format);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        private /* synthetic */ void $$robo$$android_media_tv_TvInputManager_Hardware$__constructor__(ITvInputHardware x0, 1 x1) {
        }

        private void __constructor__(ITvInputHardware iTvInputHardware) {
            this.$$robo$$android_media_tv_TvInputManager_Hardware$__constructor__(iTvInputHardware);
        }

        private Hardware(ITvInputHardware iTvInputHardware) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_Hardware$__constructor__(android.media.tv.ITvInputHardware ), 0, this, iTvInputHardware);
        }

        private ITvInputHardware getInterface() {
            return InvokeDynamicSupport.bootstrap("getInterface", $$robo$$android_media_tv_TvInputManager_Hardware$getInterface(), 0, this);
        }

        public boolean setSurface(Surface surface, TvStreamConfig tvStreamConfig) {
            return (boolean)InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_media_tv_TvInputManager_Hardware$setSurface(android.view.Surface android.media.tv.TvStreamConfig ), 0, this, surface, tvStreamConfig);
        }

        public void setStreamVolume(float f) {
            InvokeDynamicSupport.bootstrap("setStreamVolume", $$robo$$android_media_tv_TvInputManager_Hardware$setStreamVolume(float ), 0, this, f);
        }

        public boolean dispatchKeyEventToHdmi(KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEventToHdmi", $$robo$$android_media_tv_TvInputManager_Hardware$dispatchKeyEventToHdmi(android.view.KeyEvent ), 0, this, keyEvent);
        }

        public void overrideAudioSink(int n, String string2, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("overrideAudioSink", $$robo$$android_media_tv_TvInputManager_Hardware$overrideAudioSink(int java.lang.String int int int ), 0, this, n, string2, n2, n3, n4);
        }

        private /* synthetic */ void __constructor__(ITvInputHardware iTvInputHardware, 1 var2_2) {
            this.$$robo$$android_media_tv_TvInputManager_Hardware$__constructor__(iTvInputHardware, var2_2);
        }

        public /* synthetic */ Hardware() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Hardware)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Session
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int DISPATCH_IN_PROGRESS = -1;
        static int DISPATCH_NOT_HANDLED = 0;
        static int DISPATCH_HANDLED = 1;
        private static long INPUT_SESSION_NOT_RESPONDING_TIMEOUT = 2500L;
        private ITvInputManager mService;
        private int mUserId;
        private int mSeq;
        private InputEventHandler mHandler;
        private Pools.Pool<PendingEvent> mPendingEventPool;
        private SparseArray<PendingEvent> mPendingEvents;
        private SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap;
        private IBinder mToken;
        private TvInputEventSender mSender;
        private InputChannel mChannel;
        private Object mMetadataLock;
        private List<TvTrackInfo> mAudioTracks;
        private List<TvTrackInfo> mVideoTracks;
        private List<TvTrackInfo> mSubtitleTracks;
        private String mSelectedAudioTrackId;
        private String mSelectedVideoTrackId;
        private String mSelectedSubtitleTrackId;
        private int mVideoWidth;
        private int mVideoHeight;

        private void $$robo$$android_media_tv_TvInputManager_Session$__constructor__(IBinder token, InputChannel channel, ITvInputManager service, int userId, int seq, SparseArray<SessionCallbackRecord> sessionCallbackRecordMap) {
            this.mHandler = new InputEventHandler(this, Looper.getMainLooper());
            this.mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
            this.mPendingEvents = new SparseArray(20);
            this.mMetadataLock = new Object();
            this.mAudioTracks = new ArrayList<TvTrackInfo>();
            this.mVideoTracks = new ArrayList<TvTrackInfo>();
            this.mSubtitleTracks = new ArrayList<TvTrackInfo>();
            this.mToken = token;
            this.mChannel = channel;
            this.mService = service;
            this.mUserId = userId;
            this.mSeq = seq;
            this.mSessionCallbackRecordMap = sessionCallbackRecordMap;
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$release() {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.releaseSession(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.releaseInternal();
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$setMain() {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.setMainSession(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$setSurface(Surface surface) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.setSurface(this.mToken, surface, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$dispatchSurfaceChanged(int format, int width, int height) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.dispatchSurfaceChanged(this.mToken, format, width, height, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$setStreamVolume(float volume) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                if (volume < 0.0f || volume > 1.0f) {
                    throw new IllegalArgumentException("volume should be between 0.0f and 1.0f");
                }
                this.mService.setVolume(this.mToken, volume, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$tune(Uri channelUri) {
            this.tune(channelUri, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputManager_Session$tune(Uri channelUri, Bundle params) {
            Preconditions.checkNotNull(channelUri);
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            Object object = this.mMetadataLock;
            synchronized (object) {
                this.mAudioTracks.clear();
                this.mVideoTracks.clear();
                this.mSubtitleTracks.clear();
                this.mSelectedAudioTrackId = null;
                this.mSelectedVideoTrackId = null;
                this.mSelectedSubtitleTrackId = null;
                this.mVideoWidth = 0;
                this.mVideoHeight = 0;
            }
            try {
                this.mService.tune(this.mToken, channelUri, params, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$setCaptionEnabled(boolean enabled) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.setCaptionEnabled(this.mToken, enabled, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputManager_Session$selectTrack(int type, String trackId) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (type == 0) {
                    if (trackId != null && !this.containsTrack(this.mAudioTracks, trackId)) {
                        Log.w("TvInputManager", "Invalid audio trackId: " + trackId);
                        return;
                    }
                } else if (type == 1) {
                    if (trackId != null && !this.containsTrack(this.mVideoTracks, trackId)) {
                        Log.w("TvInputManager", "Invalid video trackId: " + trackId);
                        return;
                    }
                } else if (type == 2) {
                    if (trackId != null && !this.containsTrack(this.mSubtitleTracks, trackId)) {
                        Log.w("TvInputManager", "Invalid subtitle trackId: " + trackId);
                        return;
                    }
                } else {
                    throw new IllegalArgumentException("invalid type: " + type);
                }
            }
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.selectTrack(this.mToken, type, trackId, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final boolean $$robo$$android_media_tv_TvInputManager_Session$containsTrack(List<TvTrackInfo> tracks, String trackId) {
            for (TvTrackInfo track : tracks) {
                if (!track.getId().equals(trackId)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<TvTrackInfo> $$robo$$android_media_tv_TvInputManager_Session$getTracks(int type) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (type == 0) {
                    if (this.mAudioTracks == null) {
                        return null;
                    }
                    return new ArrayList<TvTrackInfo>(this.mAudioTracks);
                }
                if (type == 1) {
                    if (this.mVideoTracks == null) {
                        return null;
                    }
                    return new ArrayList<TvTrackInfo>(this.mVideoTracks);
                }
                if (type == 2) {
                    if (this.mSubtitleTracks == null) {
                        return null;
                    }
                    return new ArrayList<TvTrackInfo>(this.mSubtitleTracks);
                }
            }
            throw new IllegalArgumentException("invalid type: " + type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String $$robo$$android_media_tv_TvInputManager_Session$getSelectedTrack(int type) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (type == 0) {
                    return this.mSelectedAudioTrackId;
                }
                if (type == 1) {
                    return this.mSelectedVideoTrackId;
                }
                if (type == 2) {
                    return this.mSelectedSubtitleTrackId;
                }
            }
            throw new IllegalArgumentException("invalid type: " + type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_media_tv_TvInputManager_Session$updateTracks(List<TvTrackInfo> tracks) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                this.mAudioTracks.clear();
                this.mVideoTracks.clear();
                this.mSubtitleTracks.clear();
                for (TvTrackInfo track : tracks) {
                    if (track.getType() == 0) {
                        this.mAudioTracks.add(track);
                        continue;
                    }
                    if (track.getType() == 1) {
                        this.mVideoTracks.add(track);
                        continue;
                    }
                    if (track.getType() != 2) continue;
                    this.mSubtitleTracks.add(track);
                }
                return !this.mAudioTracks.isEmpty() || !this.mVideoTracks.isEmpty() || !this.mSubtitleTracks.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_media_tv_TvInputManager_Session$updateTrackSelection(int type, String trackId) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (type == 0 && !TextUtils.equals(trackId, this.mSelectedAudioTrackId)) {
                    this.mSelectedAudioTrackId = trackId;
                    return true;
                }
                if (type == 1 && !TextUtils.equals(trackId, this.mSelectedVideoTrackId)) {
                    this.mSelectedVideoTrackId = trackId;
                    return true;
                }
                if (type == 2 && !TextUtils.equals(trackId, this.mSelectedSubtitleTrackId)) {
                    this.mSelectedSubtitleTrackId = trackId;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final TvTrackInfo $$robo$$android_media_tv_TvInputManager_Session$getVideoTrackToNotify() {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (!this.mVideoTracks.isEmpty() && this.mSelectedVideoTrackId != null) {
                    for (TvTrackInfo track : this.mVideoTracks) {
                        if (!track.getId().equals(this.mSelectedVideoTrackId)) continue;
                        int videoWidth = track.getVideoWidth();
                        int videoHeight = track.getVideoHeight();
                        if (this.mVideoWidth == videoWidth && this.mVideoHeight == videoHeight) continue;
                        this.mVideoWidth = videoWidth;
                        this.mVideoHeight = videoHeight;
                        return track;
                    }
                }
            }
            return null;
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$timeShiftPlay(Uri recordedProgramUri) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftPlay(this.mToken, recordedProgramUri, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$timeShiftPause() {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftPause(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$timeShiftResume() {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftResume(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$timeShiftSeekTo(long timeMs) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftSeekTo(this.mToken, timeMs, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$timeShiftSetPlaybackParams(PlaybackParams params) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftSetPlaybackParams(this.mToken, params, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$timeShiftEnablePositionTracking(boolean enable) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftEnablePositionTracking(this.mToken, enable, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$startRecording(Uri programUri) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.startRecording(this.mToken, programUri, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$stopRecording() {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.stopRecording(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$sendAppPrivateCommand(String action, Bundle data) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.sendAppPrivateCommand(this.mToken, action, data, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$createOverlayView(View view, Rect frame) {
            Preconditions.checkNotNull(view);
            Preconditions.checkNotNull(frame);
            if (view.getWindowToken() == null) {
                throw new IllegalStateException("view must be attached to a window");
            }
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.createOverlayView(this.mToken, view.getWindowToken(), frame, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$relayoutOverlayView(Rect frame) {
            Preconditions.checkNotNull(frame);
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.relayoutOverlayView(this.mToken, frame, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$removeOverlayView() {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.removeOverlayView(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$unblockContent(TvContentRating unblockedRating) {
            Preconditions.checkNotNull(unblockedRating);
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            try {
                this.mService.unblockContent(this.mToken, unblockedRating.flattenToString(), this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_media_tv_TvInputManager_Session$dispatchInputEvent(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
            Preconditions.checkNotNull(event);
            Preconditions.checkNotNull(callback);
            Preconditions.checkNotNull(handler);
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                if (this.mChannel == null) {
                    return 0;
                }
                PendingEvent p = this.obtainPendingEventLocked(event, token, callback, handler);
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    return this.sendInputEventOnMainLooperLocked(p);
                }
                Message msg = this.mHandler.obtainMessage(1, p);
                msg.setAsynchronous(true);
                this.mHandler.sendMessage(msg);
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputManager_Session$sendInputEventAndReportResultOnMainLooper(PendingEvent p) {
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                int result = this.sendInputEventOnMainLooperLocked(p);
                if (result == -1) {
                    return;
                }
            }
            this.invokeFinishedInputEventCallback(p, false);
        }

        private final int $$robo$$android_media_tv_TvInputManager_Session$sendInputEventOnMainLooperLocked(PendingEvent p) {
            if (this.mChannel != null) {
                InputEvent event;
                int seq;
                if (this.mSender == null) {
                    this.mSender = new TvInputEventSender(this, this.mChannel, this.mHandler.getLooper());
                }
                if (this.mSender.sendInputEvent(seq = (event = p.mEvent).getSequenceNumber(), event)) {
                    this.mPendingEvents.put(seq, p);
                    Message msg = this.mHandler.obtainMessage(2, p);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageDelayed(msg, 2500L);
                    return -1;
                }
                Log.w("TvInputManager", "Unable to send input event to session: " + this.mToken + " dropping:" + event);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputManager_Session$finishedInputEvent(int seq, boolean handled, boolean timeout) {
            PendingEvent p;
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                int index = this.mPendingEvents.indexOfKey(seq);
                if (index < 0) {
                    return;
                }
                p = this.mPendingEvents.valueAt(index);
                this.mPendingEvents.removeAt(index);
                if (timeout) {
                    Log.w("TvInputManager", "Timeout waiting for session to handle input event after 2500 ms: " + this.mToken);
                } else {
                    this.mHandler.removeMessages(2, p);
                }
            }
            this.invokeFinishedInputEventCallback(p, handled);
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$invokeFinishedInputEventCallback(PendingEvent p, boolean handled) {
            p.mHandled = handled;
            if (p.mEventHandler.getLooper().isCurrentThread()) {
                p.run();
            } else {
                Message msg = Message.obtain(p.mEventHandler, p);
                msg.setAsynchronous(true);
                msg.sendToTarget();
            }
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$flushPendingEventsLocked() {
            this.mHandler.removeMessages(3);
            int count = this.mPendingEvents.size();
            for (int i = 0; i < count; ++i) {
                int seq = this.mPendingEvents.keyAt(i);
                Message msg = this.mHandler.obtainMessage(3, seq, 0);
                msg.setAsynchronous(true);
                msg.sendToTarget();
            }
        }

        private final PendingEvent $$robo$$android_media_tv_TvInputManager_Session$obtainPendingEventLocked(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
            PendingEvent p = this.mPendingEventPool.acquire();
            if (p == null) {
                p = new PendingEvent(this);
            }
            p.mEvent = event;
            p.mEventToken = token;
            p.mCallback = callback;
            p.mEventHandler = handler;
            return p;
        }

        private final void $$robo$$android_media_tv_TvInputManager_Session$recyclePendingEventLocked(PendingEvent p) {
            p.recycle();
            this.mPendingEventPool.release(p);
        }

        private final IBinder $$robo$$android_media_tv_TvInputManager_Session$getToken() {
            return this.mToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvInputManager_Session$releaseInternal() {
            this.mToken = null;
            Object object = this.mHandler;
            synchronized (object) {
                if (this.mChannel != null) {
                    if (this.mSender != null) {
                        this.flushPendingEventsLocked();
                        this.mSender.dispose();
                        this.mSender = null;
                    }
                    this.mChannel.dispose();
                    this.mChannel = null;
                }
            }
            object = this.mSessionCallbackRecordMap;
            synchronized (object) {
                this.mSessionCallbackRecordMap.remove(this.mSeq);
            }
        }

        private /* synthetic */ void $$robo$$android_media_tv_TvInputManager_Session$__constructor__(IBinder x0, InputChannel x1, ITvInputManager x2, int x3, int x4, SparseArray x5, 1 x6) {
        }

        private void __constructor__(IBinder iBinder, InputChannel inputChannel, ITvInputManager iTvInputManager, int n, int n2, SparseArray<SessionCallbackRecord> sparseArray) {
            this.$$robo$$android_media_tv_TvInputManager_Session$__constructor__(iBinder, inputChannel, iTvInputManager, n, n2, sparseArray);
        }

        private Session(IBinder iBinder, InputChannel inputChannel, ITvInputManager iTvInputManager, int n, int n2, SparseArray<SessionCallbackRecord> sparseArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_Session$__constructor__(android.os.IBinder android.view.InputChannel android.media.tv.ITvInputManager int int android.util.SparseArray<android.media.tv.TvInputManager$SessionCallbackRecord> ), 0, this, iBinder, inputChannel, iTvInputManager, n, n2, sparseArray);
        }

        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_tv_TvInputManager_Session$release(), 0, this);
        }

        void setMain() {
            InvokeDynamicSupport.bootstrap("setMain", $$robo$$android_media_tv_TvInputManager_Session$setMain(), 0, this);
        }

        public void setSurface(Surface surface) {
            InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_media_tv_TvInputManager_Session$setSurface(android.view.Surface ), 0, this, surface);
        }

        public void dispatchSurfaceChanged(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("dispatchSurfaceChanged", $$robo$$android_media_tv_TvInputManager_Session$dispatchSurfaceChanged(int int int ), 0, this, n, n2, n3);
        }

        public void setStreamVolume(float f) {
            InvokeDynamicSupport.bootstrap("setStreamVolume", $$robo$$android_media_tv_TvInputManager_Session$setStreamVolume(float ), 0, this, f);
        }

        public void tune(Uri uri) {
            InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_TvInputManager_Session$tune(android.net.Uri ), 0, this, uri);
        }

        public void tune(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_TvInputManager_Session$tune(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
        }

        public void setCaptionEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setCaptionEnabled", $$robo$$android_media_tv_TvInputManager_Session$setCaptionEnabled(boolean ), 0, this, bl);
        }

        public void selectTrack(int n, String string2) {
            InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_tv_TvInputManager_Session$selectTrack(int java.lang.String ), 0, this, n, string2);
        }

        private boolean containsTrack(List<TvTrackInfo> list, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("containsTrack", $$robo$$android_media_tv_TvInputManager_Session$containsTrack(java.util.List<android.media.tv.TvTrackInfo> java.lang.String ), 0, this, list, string2);
        }

        public List<TvTrackInfo> getTracks(int n) {
            return InvokeDynamicSupport.bootstrap("getTracks", $$robo$$android_media_tv_TvInputManager_Session$getTracks(int ), 0, this, n);
        }

        public String getSelectedTrack(int n) {
            return InvokeDynamicSupport.bootstrap("getSelectedTrack", $$robo$$android_media_tv_TvInputManager_Session$getSelectedTrack(int ), 0, this, n);
        }

        boolean updateTracks(List<TvTrackInfo> list) {
            return (boolean)InvokeDynamicSupport.bootstrap("updateTracks", $$robo$$android_media_tv_TvInputManager_Session$updateTracks(java.util.List<android.media.tv.TvTrackInfo> ), 0, this, list);
        }

        boolean updateTrackSelection(int n, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("updateTrackSelection", $$robo$$android_media_tv_TvInputManager_Session$updateTrackSelection(int java.lang.String ), 0, this, n, string2);
        }

        TvTrackInfo getVideoTrackToNotify() {
            return InvokeDynamicSupport.bootstrap("getVideoTrackToNotify", $$robo$$android_media_tv_TvInputManager_Session$getVideoTrackToNotify(), 0, this);
        }

        void timeShiftPlay(Uri uri) {
            InvokeDynamicSupport.bootstrap("timeShiftPlay", $$robo$$android_media_tv_TvInputManager_Session$timeShiftPlay(android.net.Uri ), 0, this, uri);
        }

        void timeShiftPause() {
            InvokeDynamicSupport.bootstrap("timeShiftPause", $$robo$$android_media_tv_TvInputManager_Session$timeShiftPause(), 0, this);
        }

        void timeShiftResume() {
            InvokeDynamicSupport.bootstrap("timeShiftResume", $$robo$$android_media_tv_TvInputManager_Session$timeShiftResume(), 0, this);
        }

        void timeShiftSeekTo(long l) {
            InvokeDynamicSupport.bootstrap("timeShiftSeekTo", $$robo$$android_media_tv_TvInputManager_Session$timeShiftSeekTo(long ), 0, this, l);
        }

        void timeShiftSetPlaybackParams(PlaybackParams playbackParams) {
            InvokeDynamicSupport.bootstrap("timeShiftSetPlaybackParams", $$robo$$android_media_tv_TvInputManager_Session$timeShiftSetPlaybackParams(android.media.PlaybackParams ), 0, this, playbackParams);
        }

        void timeShiftEnablePositionTracking(boolean bl) {
            InvokeDynamicSupport.bootstrap("timeShiftEnablePositionTracking", $$robo$$android_media_tv_TvInputManager_Session$timeShiftEnablePositionTracking(boolean ), 0, this, bl);
        }

        void startRecording(Uri uri) {
            InvokeDynamicSupport.bootstrap("startRecording", $$robo$$android_media_tv_TvInputManager_Session$startRecording(android.net.Uri ), 0, this, uri);
        }

        void stopRecording() {
            InvokeDynamicSupport.bootstrap("stopRecording", $$robo$$android_media_tv_TvInputManager_Session$stopRecording(), 0, this);
        }

        public void sendAppPrivateCommand(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("sendAppPrivateCommand", $$robo$$android_media_tv_TvInputManager_Session$sendAppPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        void createOverlayView(View view, Rect rect) {
            InvokeDynamicSupport.bootstrap("createOverlayView", $$robo$$android_media_tv_TvInputManager_Session$createOverlayView(android.view.View android.graphics.Rect ), 0, this, view, rect);
        }

        void relayoutOverlayView(Rect rect) {
            InvokeDynamicSupport.bootstrap("relayoutOverlayView", $$robo$$android_media_tv_TvInputManager_Session$relayoutOverlayView(android.graphics.Rect ), 0, this, rect);
        }

        void removeOverlayView() {
            InvokeDynamicSupport.bootstrap("removeOverlayView", $$robo$$android_media_tv_TvInputManager_Session$removeOverlayView(), 0, this);
        }

        void unblockContent(TvContentRating tvContentRating) {
            InvokeDynamicSupport.bootstrap("unblockContent", $$robo$$android_media_tv_TvInputManager_Session$unblockContent(android.media.tv.TvContentRating ), 0, this, tvContentRating);
        }

        public int dispatchInputEvent(InputEvent inputEvent, Object object, FinishedInputEventCallback finishedInputEventCallback, Handler handler) {
            return (int)InvokeDynamicSupport.bootstrap("dispatchInputEvent", $$robo$$android_media_tv_TvInputManager_Session$dispatchInputEvent(android.view.InputEvent java.lang.Object android.media.tv.TvInputManager$Session$FinishedInputEventCallback android.os.Handler ), 0, this, inputEvent, object, finishedInputEventCallback, handler);
        }

        private void sendInputEventAndReportResultOnMainLooper(PendingEvent pendingEvent) {
            InvokeDynamicSupport.bootstrap("sendInputEventAndReportResultOnMainLooper", $$robo$$android_media_tv_TvInputManager_Session$sendInputEventAndReportResultOnMainLooper(android.media.tv.TvInputManager$Session$PendingEvent ), 0, this, pendingEvent);
        }

        private int sendInputEventOnMainLooperLocked(PendingEvent pendingEvent) {
            return (int)InvokeDynamicSupport.bootstrap("sendInputEventOnMainLooperLocked", $$robo$$android_media_tv_TvInputManager_Session$sendInputEventOnMainLooperLocked(android.media.tv.TvInputManager$Session$PendingEvent ), 0, this, pendingEvent);
        }

        void finishedInputEvent(int n, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("finishedInputEvent", $$robo$$android_media_tv_TvInputManager_Session$finishedInputEvent(int boolean boolean ), 0, this, n, bl, bl2);
        }

        void invokeFinishedInputEventCallback(PendingEvent pendingEvent, boolean bl) {
            InvokeDynamicSupport.bootstrap("invokeFinishedInputEventCallback", $$robo$$android_media_tv_TvInputManager_Session$invokeFinishedInputEventCallback(android.media.tv.TvInputManager$Session$PendingEvent boolean ), 0, this, pendingEvent, bl);
        }

        private void flushPendingEventsLocked() {
            InvokeDynamicSupport.bootstrap("flushPendingEventsLocked", $$robo$$android_media_tv_TvInputManager_Session$flushPendingEventsLocked(), 0, this);
        }

        private PendingEvent obtainPendingEventLocked(InputEvent inputEvent, Object object, FinishedInputEventCallback finishedInputEventCallback, Handler handler) {
            return InvokeDynamicSupport.bootstrap("obtainPendingEventLocked", $$robo$$android_media_tv_TvInputManager_Session$obtainPendingEventLocked(android.view.InputEvent java.lang.Object android.media.tv.TvInputManager$Session$FinishedInputEventCallback android.os.Handler ), 0, this, inputEvent, object, finishedInputEventCallback, handler);
        }

        private void recyclePendingEventLocked(PendingEvent pendingEvent) {
            InvokeDynamicSupport.bootstrap("recyclePendingEventLocked", $$robo$$android_media_tv_TvInputManager_Session$recyclePendingEventLocked(android.media.tv.TvInputManager$Session$PendingEvent ), 0, this, pendingEvent);
        }

        IBinder getToken() {
            return InvokeDynamicSupport.bootstrap("getToken", $$robo$$android_media_tv_TvInputManager_Session$getToken(), 0, this);
        }

        private void releaseInternal() {
            InvokeDynamicSupport.bootstrap("releaseInternal", $$robo$$android_media_tv_TvInputManager_Session$releaseInternal(), 0, this);
        }

        private /* synthetic */ void __constructor__(IBinder iBinder, InputChannel inputChannel, ITvInputManager iTvInputManager, int n, int n2, SparseArray sparseArray, 1 var7_7) {
            this.$$robo$$android_media_tv_TvInputManager_Session$__constructor__(iBinder, inputChannel, iTvInputManager, n, n2, sparseArray, var7_7);
        }

        public /* synthetic */ Session() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Session)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private final class PendingEvent
        implements Runnable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public InputEvent mEvent;
            public Object mEventToken;
            public FinishedInputEventCallback mCallback;
            public Handler mEventHandler;
            public boolean mHandled;
            /* synthetic */ Session this$0;

            private void $$robo$$android_media_tv_TvInputManager_Session_PendingEvent$__constructor__(Session session) {
            }

            private final void $$robo$$android_media_tv_TvInputManager_Session_PendingEvent$recycle() {
                this.mEvent = null;
                this.mEventToken = null;
                this.mCallback = null;
                this.mEventHandler = null;
                this.mHandled = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_TvInputManager_Session_PendingEvent$run() {
                this.mCallback.onFinishedInputEvent(this.mEventToken, this.mHandled);
                Handler handler = this.mEventHandler;
                synchronized (handler) {
                    this.this$0.recyclePendingEventLocked(this);
                }
            }

            private /* synthetic */ void $$robo$$android_media_tv_TvInputManager_Session_PendingEvent$__constructor__(Session x0, 1 x1) {
            }

            private void __constructor__(Session session) {
                this.$$robo$$android_media_tv_TvInputManager_Session_PendingEvent$__constructor__(session);
            }

            private PendingEvent(Session session) {
                this.this$0 = session;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_Session_PendingEvent$__constructor__(android.media.tv.TvInputManager$Session ), 0, this, session);
            }

            public void recycle() {
                InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_media_tv_TvInputManager_Session_PendingEvent$recycle(), 0, this);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_Session_PendingEvent$run(), 0, this);
            }

            private /* synthetic */ void __constructor__(Session session, 1 var2_2) {
                this.$$robo$$android_media_tv_TvInputManager_Session_PendingEvent$__constructor__(session, var2_2);
            }

            public /* synthetic */ PendingEvent() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PendingEvent)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private final class TvInputEventSender
        extends InputEventSender
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Session this$0;

            private void $$robo$$android_media_tv_TvInputManager_Session_TvInputEventSender$__constructor__(Session session, InputChannel inputChannel, Looper looper) {
            }

            private final void $$robo$$android_media_tv_TvInputManager_Session_TvInputEventSender$onInputEventFinished(int seq, boolean handled) {
                this.this$0.finishedInputEvent(seq, handled, false);
            }

            private void __constructor__(Session session, InputChannel inputChannel, Looper looper) {
                this.$$robo$$android_media_tv_TvInputManager_Session_TvInputEventSender$__constructor__(session, inputChannel, looper);
            }

            public TvInputEventSender(Session session, InputChannel inputChannel, Looper looper) {
                this.this$0 = session;
                super(inputChannel, looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_Session_TvInputEventSender$__constructor__(android.media.tv.TvInputManager$Session android.view.InputChannel android.os.Looper ), 0, this, session, inputChannel, looper);
            }

            @Override
            public void onInputEventFinished(int n, boolean bl) {
                InvokeDynamicSupport.bootstrap("onInputEventFinished", $$robo$$android_media_tv_TvInputManager_Session_TvInputEventSender$onInputEventFinished(int boolean ), 0, this, n, bl);
            }

            public /* synthetic */ TvInputEventSender() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputEventSender)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private final class InputEventHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static int MSG_SEND_INPUT_EVENT = 1;
            public static int MSG_TIMEOUT_INPUT_EVENT = 2;
            public static int MSG_FLUSH_INPUT_EVENT = 3;
            /* synthetic */ Session this$0;

            private void $$robo$$android_media_tv_TvInputManager_Session_InputEventHandler$__constructor__(Session session, Looper looper) {
            }

            private final void $$robo$$android_media_tv_TvInputManager_Session_InputEventHandler$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.sendInputEventAndReportResultOnMainLooper((PendingEvent)msg.obj);
                        return;
                    }
                    case 2: {
                        this.this$0.finishedInputEvent(msg.arg1, false, true);
                        return;
                    }
                    case 3: {
                        this.this$0.finishedInputEvent(msg.arg1, false, false);
                        return;
                    }
                }
            }

            private void __constructor__(Session session, Looper looper) {
                this.$$robo$$android_media_tv_TvInputManager_Session_InputEventHandler$__constructor__(session, looper);
            }

            InputEventHandler(Session session, Looper looper) {
                this.this$0 = session;
                super(looper, null, true);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_Session_InputEventHandler$__constructor__(android.media.tv.TvInputManager$Session android.os.Looper ), 0, this, session, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_tv_TvInputManager_Session_InputEventHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ InputEventHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputEventHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static interface FinishedInputEventCallback
        extends InstrumentedInterface {
            public void onFinishedInputEvent(Object var1, boolean var2);
        }
    }

    public static abstract class HardwareCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_tv_TvInputManager_HardwareCallback$__constructor__() {
        }

        public abstract void onReleased();

        public abstract void onStreamConfigChanged(TvStreamConfig[] var1);

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvInputManager_HardwareCallback$__constructor__();
        }

        public HardwareCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_HardwareCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HardwareCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class TvInputCallbackRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private TvInputCallback mCallback;
        private Handler mHandler;

        private void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$__constructor__(TvInputCallback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        private final TvInputCallback $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$getCallback() {
            return this.mCallback;
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postInputAdded(String inputId) {
            this.mHandler.post(new Runnable(this, inputId){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$inputId;
                /* synthetic */ TvInputCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_1$__constructor__(TvInputCallbackRecord this$0, String string2) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_1$run() {
                    this.this$0.mCallback.onInputAdded(this.val$inputId);
                }

                private void __constructor__(TvInputCallbackRecord tvInputCallbackRecord, String string2) {
                    this.$$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_1$__constructor__(tvInputCallbackRecord, string2);
                }
                {
                    this.this$0 = tvInputCallbackRecord;
                    this.val$inputId = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_1$__constructor__(android.media.tv.TvInputManager$TvInputCallbackRecord java.lang.String ), 0, this, tvInputCallbackRecord, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postInputRemoved(String inputId) {
            this.mHandler.post(new Runnable(this, inputId){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$inputId;
                /* synthetic */ TvInputCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_2$__constructor__(TvInputCallbackRecord this$0, String string2) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_2$run() {
                    this.this$0.mCallback.onInputRemoved(this.val$inputId);
                }

                private void __constructor__(TvInputCallbackRecord tvInputCallbackRecord, String string2) {
                    this.$$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_2$__constructor__(tvInputCallbackRecord, string2);
                }
                {
                    this.this$0 = tvInputCallbackRecord;
                    this.val$inputId = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_2$__constructor__(android.media.tv.TvInputManager$TvInputCallbackRecord java.lang.String ), 0, this, tvInputCallbackRecord, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postInputUpdated(String inputId) {
            this.mHandler.post(new Runnable(this, inputId){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$inputId;
                /* synthetic */ TvInputCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_3$__constructor__(TvInputCallbackRecord this$0, String string2) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_3$run() {
                    this.this$0.mCallback.onInputUpdated(this.val$inputId);
                }

                private void __constructor__(TvInputCallbackRecord tvInputCallbackRecord, String string2) {
                    this.$$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_3$__constructor__(tvInputCallbackRecord, string2);
                }
                {
                    this.this$0 = tvInputCallbackRecord;
                    this.val$inputId = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_3$__constructor__(android.media.tv.TvInputManager$TvInputCallbackRecord java.lang.String ), 0, this, tvInputCallbackRecord, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postInputStateChanged(String inputId, int state) {
            this.mHandler.post(new Runnable(this, inputId, state){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$inputId;
                /* synthetic */ int val$state;
                /* synthetic */ TvInputCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_4$__constructor__(TvInputCallbackRecord this$0, String string2, int n) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_4$run() {
                    this.this$0.mCallback.onInputStateChanged(this.val$inputId, this.val$state);
                }

                private void __constructor__(TvInputCallbackRecord tvInputCallbackRecord, String string2, int n) {
                    this.$$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_4$__constructor__(tvInputCallbackRecord, string2, n);
                }
                {
                    this.this$0 = tvInputCallbackRecord;
                    this.val$inputId = string2;
                    this.val$state = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_4$__constructor__(android.media.tv.TvInputManager$TvInputCallbackRecord java.lang.String int ), 0, this, tvInputCallbackRecord, string2, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_4$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postTvInputInfoUpdated(TvInputInfo inputInfo) {
            this.mHandler.post(new Runnable(this, inputInfo){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TvInputInfo val$inputInfo;
                /* synthetic */ TvInputCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_5$__constructor__(TvInputCallbackRecord this$0, TvInputInfo tvInputInfo) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_5$run() {
                    this.this$0.mCallback.onTvInputInfoUpdated(this.val$inputInfo);
                }

                private void __constructor__(TvInputCallbackRecord tvInputCallbackRecord, TvInputInfo tvInputInfo) {
                    this.$$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_5$__constructor__(tvInputCallbackRecord, tvInputInfo);
                }
                {
                    this.this$0 = tvInputCallbackRecord;
                    this.val$inputInfo = tvInputInfo;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_5$__constructor__(android.media.tv.TvInputManager$TvInputCallbackRecord android.media.tv.TvInputInfo ), 0, this, tvInputCallbackRecord, tvInputInfo);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord_5$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void __constructor__(TvInputCallback tvInputCallback, Handler handler) {
            this.$$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$__constructor__(tvInputCallback, handler);
        }

        public TvInputCallbackRecord(TvInputCallback tvInputCallback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$__constructor__(android.media.tv.TvInputManager$TvInputCallback android.os.Handler ), 0, this, tvInputCallback, handler);
        }

        public TvInputCallback getCallback() {
            return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$getCallback(), 0, this);
        }

        public void postInputAdded(String string2) {
            InvokeDynamicSupport.bootstrap("postInputAdded", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postInputAdded(java.lang.String ), 0, this, string2);
        }

        public void postInputRemoved(String string2) {
            InvokeDynamicSupport.bootstrap("postInputRemoved", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postInputRemoved(java.lang.String ), 0, this, string2);
        }

        public void postInputUpdated(String string2) {
            InvokeDynamicSupport.bootstrap("postInputUpdated", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postInputUpdated(java.lang.String ), 0, this, string2);
        }

        public void postInputStateChanged(String string2, int n) {
            InvokeDynamicSupport.bootstrap("postInputStateChanged", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postInputStateChanged(java.lang.String int ), 0, this, string2, n);
        }

        public void postTvInputInfoUpdated(TvInputInfo tvInputInfo) {
            InvokeDynamicSupport.bootstrap("postTvInputInfoUpdated", $$robo$$android_media_tv_TvInputManager_TvInputCallbackRecord$postTvInputInfoUpdated(android.media.tv.TvInputInfo ), 0, this, tvInputInfo);
        }

        public /* synthetic */ TvInputCallbackRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputCallbackRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class TvInputCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_tv_TvInputManager_TvInputCallback$__constructor__() {
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallback$onInputStateChanged(String inputId, int state) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallback$onInputAdded(String inputId) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallback$onInputRemoved(String inputId) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallback$onInputUpdated(String inputId) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_TvInputCallback$onTvInputInfoUpdated(TvInputInfo inputInfo) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvInputManager_TvInputCallback$__constructor__();
        }

        public TvInputCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_TvInputCallback$__constructor__(), 0, this);
        }

        public void onInputStateChanged(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onInputStateChanged", $$robo$$android_media_tv_TvInputManager_TvInputCallback$onInputStateChanged(java.lang.String int ), 0, this, string2, n);
        }

        public void onInputAdded(String string2) {
            InvokeDynamicSupport.bootstrap("onInputAdded", $$robo$$android_media_tv_TvInputManager_TvInputCallback$onInputAdded(java.lang.String ), 0, this, string2);
        }

        public void onInputRemoved(String string2) {
            InvokeDynamicSupport.bootstrap("onInputRemoved", $$robo$$android_media_tv_TvInputManager_TvInputCallback$onInputRemoved(java.lang.String ), 0, this, string2);
        }

        public void onInputUpdated(String string2) {
            InvokeDynamicSupport.bootstrap("onInputUpdated", $$robo$$android_media_tv_TvInputManager_TvInputCallback$onInputUpdated(java.lang.String ), 0, this, string2);
        }

        public void onTvInputInfoUpdated(TvInputInfo tvInputInfo) {
            InvokeDynamicSupport.bootstrap("onTvInputInfoUpdated", $$robo$$android_media_tv_TvInputManager_TvInputCallback$onTvInputInfoUpdated(android.media.tv.TvInputInfo ), 0, this, tvInputInfo);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class SessionCallbackRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SessionCallback mSessionCallback;
        private Handler mHandler;
        private Session mSession;

        private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$__constructor__(SessionCallback sessionCallback, Handler handler) {
            this.mSessionCallback = sessionCallback;
            this.mHandler = handler;
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postSessionCreated(Session session) {
            this.mSession = session;
            this.mHandler.post(new Runnable(this, session){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Session val$session;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_1$__constructor__(SessionCallbackRecord this$0, Session session) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_1$run() {
                    this.this$0.mSessionCallback.onSessionCreated(this.val$session);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, Session session) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_1$__constructor__(sessionCallbackRecord, session);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$session = session;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_1$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord android.media.tv.TvInputManager$Session ), 0, this, sessionCallbackRecord, session);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postSessionReleased() {
            this.mHandler.post(new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_2$__constructor__(SessionCallbackRecord this$0) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_2$run() {
                    this.this$0.mSessionCallback.onSessionReleased(this.this$0.mSession);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_2$__constructor__(sessionCallbackRecord);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_2$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord ), 0, this, sessionCallbackRecord);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postChannelRetuned(Uri channelUri) {
            this.mHandler.post(new Runnable(this, channelUri){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Uri val$channelUri;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_3$__constructor__(SessionCallbackRecord this$0, Uri uri) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_3$run() {
                    this.this$0.mSessionCallback.onChannelRetuned(this.this$0.mSession, this.val$channelUri);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, Uri uri) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_3$__constructor__(sessionCallbackRecord, uri);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$channelUri = uri;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_3$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord android.net.Uri ), 0, this, sessionCallbackRecord, uri);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTracksChanged(List<TvTrackInfo> tracks) {
            this.mHandler.post(new Runnable(this, tracks){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ List val$tracks;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_4$__constructor__(SessionCallbackRecord this$0, List list) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_4$run() {
                    this.this$0.mSessionCallback.onTracksChanged(this.this$0.mSession, this.val$tracks);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, List list) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_4$__constructor__(sessionCallbackRecord, list);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$tracks = list;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_4$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord java.util.List ), 0, this, sessionCallbackRecord, list);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_4$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTrackSelected(int type, String trackId) {
            this.mHandler.post(new Runnable(this, type, trackId){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$type;
                /* synthetic */ String val$trackId;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_5$__constructor__(SessionCallbackRecord this$0, int n, String string2) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_5$run() {
                    this.this$0.mSessionCallback.onTrackSelected(this.this$0.mSession, this.val$type, this.val$trackId);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, int n, String string2) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_5$__constructor__(sessionCallbackRecord, n, string2);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$type = n;
                    this.val$trackId = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_5$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord int java.lang.String ), 0, this, sessionCallbackRecord, n, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_5$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postVideoSizeChanged(int width, int height) {
            this.mHandler.post(new Runnable(this, width, height){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$width;
                /* synthetic */ int val$height;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_6$__constructor__(SessionCallbackRecord this$0, int n, int n2) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_6$run() {
                    this.this$0.mSessionCallback.onVideoSizeChanged(this.this$0.mSession, this.val$width, this.val$height);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, int n, int n2) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_6$__constructor__(sessionCallbackRecord, n, n2);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$width = n;
                    this.val$height = n2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_6$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord int int ), 0, this, sessionCallbackRecord, n, n2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_6$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postVideoAvailable() {
            this.mHandler.post(new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_7$__constructor__(SessionCallbackRecord this$0) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_7$run() {
                    this.this$0.mSessionCallback.onVideoAvailable(this.this$0.mSession);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_7$__constructor__(sessionCallbackRecord);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_7$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord ), 0, this, sessionCallbackRecord);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_7$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postVideoUnavailable(int reason) {
            this.mHandler.post(new Runnable(this, reason){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$reason;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_8$__constructor__(SessionCallbackRecord this$0, int n) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_8$run() {
                    this.this$0.mSessionCallback.onVideoUnavailable(this.this$0.mSession, this.val$reason);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, int n) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_8$__constructor__(sessionCallbackRecord, n);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$reason = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_8$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord int ), 0, this, sessionCallbackRecord, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_8$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postContentAllowed() {
            this.mHandler.post(new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_9$__constructor__(SessionCallbackRecord this$0) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_9$run() {
                    this.this$0.mSessionCallback.onContentAllowed(this.this$0.mSession);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_9$__constructor__(sessionCallbackRecord);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_9$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord ), 0, this, sessionCallbackRecord);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_9$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postContentBlocked(TvContentRating rating) {
            this.mHandler.post(new Runnable(this, rating){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TvContentRating val$rating;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_10$__constructor__(SessionCallbackRecord this$0, TvContentRating tvContentRating) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_10$run() {
                    this.this$0.mSessionCallback.onContentBlocked(this.this$0.mSession, this.val$rating);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, TvContentRating tvContentRating) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_10$__constructor__(sessionCallbackRecord, tvContentRating);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$rating = tvContentRating;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_10$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord android.media.tv.TvContentRating ), 0, this, sessionCallbackRecord, tvContentRating);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_10$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postLayoutSurface(int left, int top, int right, int bottom) {
            this.mHandler.post(new Runnable(this, left, top, right, bottom){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$left;
                /* synthetic */ int val$top;
                /* synthetic */ int val$right;
                /* synthetic */ int val$bottom;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_11$__constructor__(SessionCallbackRecord this$0, int n, int n2, int n3, int n4) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_11$run() {
                    this.this$0.mSessionCallback.onLayoutSurface(this.this$0.mSession, this.val$left, this.val$top, this.val$right, this.val$bottom);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, int n, int n2, int n3, int n4) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_11$__constructor__(sessionCallbackRecord, n, n2, n3, n4);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$left = n;
                    this.val$top = n2;
                    this.val$right = n3;
                    this.val$bottom = n4;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_11$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord int int int int ), 0, this, sessionCallbackRecord, n, n2, n3, n4);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_11$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postSessionEvent(String eventType, Bundle eventArgs) {
            this.mHandler.post(new Runnable(this, eventType, eventArgs){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$eventType;
                /* synthetic */ Bundle val$eventArgs;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_12$__constructor__(SessionCallbackRecord this$0, String string2, Bundle bundle) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_12$run() {
                    this.this$0.mSessionCallback.onSessionEvent(this.this$0.mSession, this.val$eventType, this.val$eventArgs);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, String string2, Bundle bundle) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_12$__constructor__(sessionCallbackRecord, string2, bundle);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$eventType = string2;
                    this.val$eventArgs = bundle;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_12$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord java.lang.String android.os.Bundle ), 0, this, sessionCallbackRecord, string2, bundle);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_12$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTimeShiftStatusChanged(int status) {
            this.mHandler.post(new Runnable(this, status){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$status;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_13$__constructor__(SessionCallbackRecord this$0, int n) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_13$run() {
                    this.this$0.mSessionCallback.onTimeShiftStatusChanged(this.this$0.mSession, this.val$status);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, int n) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_13$__constructor__(sessionCallbackRecord, n);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$status = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_13$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord int ), 0, this, sessionCallbackRecord, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_13$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTimeShiftStartPositionChanged(long timeMs) {
            this.mHandler.post(new Runnable(this, timeMs){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ long val$timeMs;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_14$__constructor__(SessionCallbackRecord this$0, long l) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_14$run() {
                    this.this$0.mSessionCallback.onTimeShiftStartPositionChanged(this.this$0.mSession, this.val$timeMs);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, long l) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_14$__constructor__(sessionCallbackRecord, l);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$timeMs = l;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_14$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord long ), 0, this, sessionCallbackRecord, l);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_14$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTimeShiftCurrentPositionChanged(long timeMs) {
            this.mHandler.post(new Runnable(this, timeMs){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ long val$timeMs;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_15$__constructor__(SessionCallbackRecord this$0, long l) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_15$run() {
                    this.this$0.mSessionCallback.onTimeShiftCurrentPositionChanged(this.this$0.mSession, this.val$timeMs);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, long l) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_15$__constructor__(sessionCallbackRecord, l);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$timeMs = l;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_15$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord long ), 0, this, sessionCallbackRecord, l);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_15$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTuned(Uri channelUri) {
            this.mHandler.post(new Runnable(this, channelUri){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Uri val$channelUri;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_16$__constructor__(SessionCallbackRecord this$0, Uri uri) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_16$run() {
                    this.this$0.mSessionCallback.onTuned(this.this$0.mSession, this.val$channelUri);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, Uri uri) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_16$__constructor__(sessionCallbackRecord, uri);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$channelUri = uri;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_16$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord android.net.Uri ), 0, this, sessionCallbackRecord, uri);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_16$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postRecordingStopped(Uri recordedProgramUri) {
            this.mHandler.post(new Runnable(this, recordedProgramUri){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Uri val$recordedProgramUri;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_17$__constructor__(SessionCallbackRecord this$0, Uri uri) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_17$run() {
                    this.this$0.mSessionCallback.onRecordingStopped(this.this$0.mSession, this.val$recordedProgramUri);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, Uri uri) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_17$__constructor__(sessionCallbackRecord, uri);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$recordedProgramUri = uri;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_17$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord android.net.Uri ), 0, this, sessionCallbackRecord, uri);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_17$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postError(int error) {
            this.mHandler.post(new Runnable(this, error){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$error;
                /* synthetic */ SessionCallbackRecord this$0;

                private void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_18$__constructor__(SessionCallbackRecord this$0, int n) {
                }

                private final void $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_18$run() {
                    this.this$0.mSessionCallback.onError(this.this$0.mSession, this.val$error);
                }

                private void __constructor__(SessionCallbackRecord sessionCallbackRecord, int n) {
                    this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_18$__constructor__(sessionCallbackRecord, n);
                }
                {
                    this.this$0 = sessionCallbackRecord;
                    this.val$error = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_18$__constructor__(android.media.tv.TvInputManager$SessionCallbackRecord int ), 0, this, sessionCallbackRecord, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord_18$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void __constructor__(SessionCallback sessionCallback, Handler handler) {
            this.$$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$__constructor__(sessionCallback, handler);
        }

        SessionCallbackRecord(SessionCallback sessionCallback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$__constructor__(android.media.tv.TvInputManager$SessionCallback android.os.Handler ), 0, this, sessionCallback, handler);
        }

        void postSessionCreated(Session session) {
            InvokeDynamicSupport.bootstrap("postSessionCreated", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postSessionCreated(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        void postSessionReleased() {
            InvokeDynamicSupport.bootstrap("postSessionReleased", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postSessionReleased(), 0, this);
        }

        void postChannelRetuned(Uri uri) {
            InvokeDynamicSupport.bootstrap("postChannelRetuned", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postChannelRetuned(android.net.Uri ), 0, this, uri);
        }

        void postTracksChanged(List<TvTrackInfo> list) {
            InvokeDynamicSupport.bootstrap("postTracksChanged", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTracksChanged(java.util.List<android.media.tv.TvTrackInfo> ), 0, this, list);
        }

        void postTrackSelected(int n, String string2) {
            InvokeDynamicSupport.bootstrap("postTrackSelected", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTrackSelected(int java.lang.String ), 0, this, n, string2);
        }

        void postVideoSizeChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("postVideoSizeChanged", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postVideoSizeChanged(int int ), 0, this, n, n2);
        }

        void postVideoAvailable() {
            InvokeDynamicSupport.bootstrap("postVideoAvailable", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postVideoAvailable(), 0, this);
        }

        void postVideoUnavailable(int n) {
            InvokeDynamicSupport.bootstrap("postVideoUnavailable", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postVideoUnavailable(int ), 0, this, n);
        }

        void postContentAllowed() {
            InvokeDynamicSupport.bootstrap("postContentAllowed", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postContentAllowed(), 0, this);
        }

        void postContentBlocked(TvContentRating tvContentRating) {
            InvokeDynamicSupport.bootstrap("postContentBlocked", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postContentBlocked(android.media.tv.TvContentRating ), 0, this, tvContentRating);
        }

        void postLayoutSurface(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("postLayoutSurface", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postLayoutSurface(int int int int ), 0, this, n, n2, n3, n4);
        }

        void postSessionEvent(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("postSessionEvent", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postSessionEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        void postTimeShiftStatusChanged(int n) {
            InvokeDynamicSupport.bootstrap("postTimeShiftStatusChanged", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTimeShiftStatusChanged(int ), 0, this, n);
        }

        void postTimeShiftStartPositionChanged(long l) {
            InvokeDynamicSupport.bootstrap("postTimeShiftStartPositionChanged", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTimeShiftStartPositionChanged(long ), 0, this, l);
        }

        void postTimeShiftCurrentPositionChanged(long l) {
            InvokeDynamicSupport.bootstrap("postTimeShiftCurrentPositionChanged", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTimeShiftCurrentPositionChanged(long ), 0, this, l);
        }

        void postTuned(Uri uri) {
            InvokeDynamicSupport.bootstrap("postTuned", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postTuned(android.net.Uri ), 0, this, uri);
        }

        void postRecordingStopped(Uri uri) {
            InvokeDynamicSupport.bootstrap("postRecordingStopped", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postRecordingStopped(android.net.Uri ), 0, this, uri);
        }

        void postError(int n) {
            InvokeDynamicSupport.bootstrap("postError", $$robo$$android_media_tv_TvInputManager_SessionCallbackRecord$postError(int ), 0, this, n);
        }

        public /* synthetic */ SessionCallbackRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionCallbackRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class SessionCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_tv_TvInputManager_SessionCallback$__constructor__() {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onSessionCreated(Session session) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onSessionReleased(Session session) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onChannelRetuned(Session session, Uri channelUri) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onTracksChanged(Session session, List<TvTrackInfo> tracks) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onTrackSelected(Session session, int type, String trackId) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onVideoSizeChanged(Session session, int width, int height) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onVideoAvailable(Session session) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onVideoUnavailable(Session session, int reason) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onContentAllowed(Session session) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onContentBlocked(Session session, TvContentRating rating) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onLayoutSurface(Session session, int left, int top, int right, int bottom) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onSessionEvent(Session session, String eventType, Bundle eventArgs) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onTimeShiftStatusChanged(Session session, int status) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onTimeShiftStartPositionChanged(Session session, long timeMs) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onTimeShiftCurrentPositionChanged(Session session, long timeMs) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onTuned(Session session, Uri channelUri) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onRecordingStopped(Session session, Uri recordedProgramUri) {
        }

        private final void $$robo$$android_media_tv_TvInputManager_SessionCallback$onError(Session session, int error) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvInputManager_SessionCallback$__constructor__();
        }

        public SessionCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputManager_SessionCallback$__constructor__(), 0, this);
        }

        public void onSessionCreated(Session session) {
            InvokeDynamicSupport.bootstrap("onSessionCreated", $$robo$$android_media_tv_TvInputManager_SessionCallback$onSessionCreated(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        public void onSessionReleased(Session session) {
            InvokeDynamicSupport.bootstrap("onSessionReleased", $$robo$$android_media_tv_TvInputManager_SessionCallback$onSessionReleased(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        public void onChannelRetuned(Session session, Uri uri) {
            InvokeDynamicSupport.bootstrap("onChannelRetuned", $$robo$$android_media_tv_TvInputManager_SessionCallback$onChannelRetuned(android.media.tv.TvInputManager$Session android.net.Uri ), 0, this, session, uri);
        }

        public void onTracksChanged(Session session, List<TvTrackInfo> list) {
            InvokeDynamicSupport.bootstrap("onTracksChanged", $$robo$$android_media_tv_TvInputManager_SessionCallback$onTracksChanged(android.media.tv.TvInputManager$Session java.util.List<android.media.tv.TvTrackInfo> ), 0, this, session, list);
        }

        public void onTrackSelected(Session session, int n, String string2) {
            InvokeDynamicSupport.bootstrap("onTrackSelected", $$robo$$android_media_tv_TvInputManager_SessionCallback$onTrackSelected(android.media.tv.TvInputManager$Session int java.lang.String ), 0, this, session, n, string2);
        }

        public void onVideoSizeChanged(Session session, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onVideoSizeChanged", $$robo$$android_media_tv_TvInputManager_SessionCallback$onVideoSizeChanged(android.media.tv.TvInputManager$Session int int ), 0, this, session, n, n2);
        }

        public void onVideoAvailable(Session session) {
            InvokeDynamicSupport.bootstrap("onVideoAvailable", $$robo$$android_media_tv_TvInputManager_SessionCallback$onVideoAvailable(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        public void onVideoUnavailable(Session session, int n) {
            InvokeDynamicSupport.bootstrap("onVideoUnavailable", $$robo$$android_media_tv_TvInputManager_SessionCallback$onVideoUnavailable(android.media.tv.TvInputManager$Session int ), 0, this, session, n);
        }

        public void onContentAllowed(Session session) {
            InvokeDynamicSupport.bootstrap("onContentAllowed", $$robo$$android_media_tv_TvInputManager_SessionCallback$onContentAllowed(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        public void onContentBlocked(Session session, TvContentRating tvContentRating) {
            InvokeDynamicSupport.bootstrap("onContentBlocked", $$robo$$android_media_tv_TvInputManager_SessionCallback$onContentBlocked(android.media.tv.TvInputManager$Session android.media.tv.TvContentRating ), 0, this, session, tvContentRating);
        }

        public void onLayoutSurface(Session session, int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("onLayoutSurface", $$robo$$android_media_tv_TvInputManager_SessionCallback$onLayoutSurface(android.media.tv.TvInputManager$Session int int int int ), 0, this, session, n, n2, n3, n4);
        }

        public void onSessionEvent(Session session, String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onSessionEvent", $$robo$$android_media_tv_TvInputManager_SessionCallback$onSessionEvent(android.media.tv.TvInputManager$Session java.lang.String android.os.Bundle ), 0, this, session, string2, bundle);
        }

        public void onTimeShiftStatusChanged(Session session, int n) {
            InvokeDynamicSupport.bootstrap("onTimeShiftStatusChanged", $$robo$$android_media_tv_TvInputManager_SessionCallback$onTimeShiftStatusChanged(android.media.tv.TvInputManager$Session int ), 0, this, session, n);
        }

        public void onTimeShiftStartPositionChanged(Session session, long l) {
            InvokeDynamicSupport.bootstrap("onTimeShiftStartPositionChanged", $$robo$$android_media_tv_TvInputManager_SessionCallback$onTimeShiftStartPositionChanged(android.media.tv.TvInputManager$Session long ), 0, this, session, l);
        }

        public void onTimeShiftCurrentPositionChanged(Session session, long l) {
            InvokeDynamicSupport.bootstrap("onTimeShiftCurrentPositionChanged", $$robo$$android_media_tv_TvInputManager_SessionCallback$onTimeShiftCurrentPositionChanged(android.media.tv.TvInputManager$Session long ), 0, this, session, l);
        }

        void onTuned(Session session, Uri uri) {
            InvokeDynamicSupport.bootstrap("onTuned", $$robo$$android_media_tv_TvInputManager_SessionCallback$onTuned(android.media.tv.TvInputManager$Session android.net.Uri ), 0, this, session, uri);
        }

        void onRecordingStopped(Session session, Uri uri) {
            InvokeDynamicSupport.bootstrap("onRecordingStopped", $$robo$$android_media_tv_TvInputManager_SessionCallback$onRecordingStopped(android.media.tv.TvInputManager$Session android.net.Uri ), 0, this, session, uri);
        }

        void onError(Session session, int n) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_tv_TvInputManager_SessionCallback$onError(android.media.tv.TvInputManager$Session int ), 0, this, session, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InputState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecordingError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeShiftStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoUnavailableReason {
    }
}

