/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import com.google.errorprone.annotations.DoNotMock;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class IpPrefix
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private byte[] address;
    private int prefixLength;
    public static Parcelable.Creator<IpPrefix> CREATOR;

    private final void $$robo$$android_net_IpPrefix$checkAndMaskAddressAndPrefixLength() {
        if (this.address.length != 4 && this.address.length != 16) {
            throw new IllegalArgumentException("IpPrefix has " + this.address.length + " bytes which is neither 4 nor 16");
        }
        NetworkUtils.maskRawAddress(this.address, this.prefixLength);
    }

    private void $$robo$$android_net_IpPrefix$__constructor__(byte[] address, int prefixLength) {
        this.address = (byte[])address.clone();
        this.prefixLength = prefixLength;
        this.checkAndMaskAddressAndPrefixLength();
    }

    private void $$robo$$android_net_IpPrefix$__constructor__(InetAddress address, int prefixLength) {
        this.address = address.getAddress();
        this.prefixLength = prefixLength;
        this.checkAndMaskAddressAndPrefixLength();
    }

    private void $$robo$$android_net_IpPrefix$__constructor__(String prefix) {
        Pair<InetAddress, Integer> ipAndMask = NetworkUtils.parseIpAndMask(prefix);
        this.address = ((InetAddress)ipAndMask.first).getAddress();
        this.prefixLength = (Integer)ipAndMask.second;
        this.checkAndMaskAddressAndPrefixLength();
    }

    private final boolean $$robo$$android_net_IpPrefix$equals(Object obj) {
        if (!(obj instanceof IpPrefix)) {
            return false;
        }
        IpPrefix that = (IpPrefix)obj;
        return Arrays.equals(this.address, that.address) && this.prefixLength == that.prefixLength;
    }

    private final int $$robo$$android_net_IpPrefix$hashCode() {
        return Arrays.hashCode(this.address) + 11 * this.prefixLength;
    }

    private final InetAddress $$robo$$android_net_IpPrefix$getAddress() {
        try {
            return InetAddress.getByAddress(this.address);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private final byte[] $$robo$$android_net_IpPrefix$getRawAddress() {
        return (byte[])this.address.clone();
    }

    private final int $$robo$$android_net_IpPrefix$getPrefixLength() {
        return this.prefixLength;
    }

    private final boolean $$robo$$android_net_IpPrefix$contains(InetAddress address) {
        byte[] addrBytes;
        byte[] byArray = addrBytes = address == null ? null : address.getAddress();
        if (addrBytes == null || addrBytes.length != this.address.length) {
            return false;
        }
        NetworkUtils.maskRawAddress(addrBytes, this.prefixLength);
        return Arrays.equals(this.address, addrBytes);
    }

    private final boolean $$robo$$android_net_IpPrefix$isIPv6() {
        return this.getAddress() instanceof Inet6Address;
    }

    private final boolean $$robo$$android_net_IpPrefix$isIPv4() {
        return this.getAddress() instanceof Inet4Address;
    }

    private final String $$robo$$android_net_IpPrefix$toString() {
        try {
            return InetAddress.getByAddress(this.address).getHostAddress() + "/" + this.prefixLength;
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("IpPrefix with invalid address! Shouldn't happen.", e);
        }
    }

    private final int $$robo$$android_net_IpPrefix$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_IpPrefix$writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.address);
        dest.writeInt(this.prefixLength);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<IpPrefix>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_IpPrefix_1$__constructor__() {
            }

            private final IpPrefix $$robo$$android_net_IpPrefix_1$createFromParcel(Parcel in) {
                byte[] address = in.createByteArray();
                int prefixLength = in.readInt();
                return new IpPrefix(address, prefixLength);
            }

            private final IpPrefix[] $$robo$$android_net_IpPrefix_1$newArray(int size) {
                return new IpPrefix[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_IpPrefix_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpPrefix_1$__constructor__(), 0, this);
            }

            @Override
            public IpPrefix createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_IpPrefix_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public IpPrefix[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_IpPrefix_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void checkAndMaskAddressAndPrefixLength() {
        InvokeDynamicSupport.bootstrap("checkAndMaskAddressAndPrefixLength", $$robo$$android_net_IpPrefix$checkAndMaskAddressAndPrefixLength(), 0, this);
    }

    private void __constructor__(byte[] byArray, int n) {
        this.$$robo$$android_net_IpPrefix$__constructor__(byArray, n);
    }

    public IpPrefix(byte[] byArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpPrefix$__constructor__(byte[] int ), 0, this, byArray, n);
    }

    private void __constructor__(InetAddress inetAddress, int n) {
        this.$$robo$$android_net_IpPrefix$__constructor__(inetAddress, n);
    }

    public IpPrefix(InetAddress inetAddress, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpPrefix$__constructor__(java.net.InetAddress int ), 0, this, inetAddress, n);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_net_IpPrefix$__constructor__(string2);
    }

    public IpPrefix(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpPrefix$__constructor__(java.lang.String ), 0, this, string2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_IpPrefix$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_IpPrefix$hashCode(), 0, this);
    }

    public InetAddress getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_net_IpPrefix$getAddress(), 0, this);
    }

    public byte[] getRawAddress() {
        return InvokeDynamicSupport.bootstrap("getRawAddress", $$robo$$android_net_IpPrefix$getRawAddress(), 0, this);
    }

    public int getPrefixLength() {
        return (int)InvokeDynamicSupport.bootstrap("getPrefixLength", $$robo$$android_net_IpPrefix$getPrefixLength(), 0, this);
    }

    public boolean contains(InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_net_IpPrefix$contains(java.net.InetAddress ), 0, this, inetAddress);
    }

    public boolean isIPv6() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIPv6", $$robo$$android_net_IpPrefix$isIPv6(), 0, this);
    }

    public boolean isIPv4() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIPv4", $$robo$$android_net_IpPrefix$isIPv4(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_IpPrefix$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_IpPrefix$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_IpPrefix$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(IpPrefix.class);
    }

    public /* synthetic */ IpPrefix() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpPrefix)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

