/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IIpSecService;
import android.net.IpSecSpiResponse;
import android.net.IpSecTransform;
import android.net.IpSecUdpEncapResponse;
import android.net.Network;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.AndroidException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class IpSecManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "IpSecManager";
    public static int INVALID_SECURITY_PARAMETER_INDEX = 0;
    public static int INVALID_RESOURCE_ID = 0;
    private IIpSecService mService;

    private final SecurityParameterIndex $$robo$$android_net_IpSecManager$reserveSecurityParameterIndex(int direction, InetAddress remoteAddress) throws ResourceUnavailableException {
        try {
            return new SecurityParameterIndex(this.mService, direction, remoteAddress, 0);
        }
        catch (SpiUnavailableException unlikely) {
            throw new ResourceUnavailableException("No SPIs available");
        }
    }

    private final SecurityParameterIndex $$robo$$android_net_IpSecManager$reserveSecurityParameterIndex(int direction, InetAddress remoteAddress, int requestedSpi) throws SpiUnavailableException, ResourceUnavailableException {
        if (requestedSpi == 0) {
            throw new IllegalArgumentException("Requested SPI must be a valid (non-zero) SPI");
        }
        return new SecurityParameterIndex(this.mService, direction, remoteAddress, requestedSpi);
    }

    private final void $$robo$$android_net_IpSecManager$applyTransportModeTransform(Socket socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.fromSocket(socket);){
            this.applyTransportModeTransform(pfd, transform);
        }
    }

    private final void $$robo$$android_net_IpSecManager$applyTransportModeTransform(DatagramSocket socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.fromDatagramSocket(socket);){
            this.applyTransportModeTransform(pfd, transform);
        }
    }

    private final void $$robo$$android_net_IpSecManager$applyTransportModeTransform(FileDescriptor socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.applyTransportModeTransform(pfd, transform);
        }
    }

    private final void $$robo$$android_net_IpSecManager$applyTransportModeTransform(ParcelFileDescriptor pfd, IpSecTransform transform) {
        try {
            this.mService.applyTransportModeTransform(pfd, transform.getResourceId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_IpSecManager$applyTunnelModeTransform(Network net, IpSecTransform transform) {
    }

    private final void $$robo$$android_net_IpSecManager$removeTransportModeTransform(Socket socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.fromSocket(socket);){
            this.removeTransportModeTransform(pfd, transform);
        }
    }

    private final void $$robo$$android_net_IpSecManager$removeTransportModeTransform(DatagramSocket socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.fromDatagramSocket(socket);){
            this.removeTransportModeTransform(pfd, transform);
        }
    }

    private final void $$robo$$android_net_IpSecManager$removeTransportModeTransform(FileDescriptor socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.removeTransportModeTransform(pfd, transform);
        }
    }

    private final void $$robo$$android_net_IpSecManager$removeTransportModeTransform(ParcelFileDescriptor pfd, IpSecTransform transform) {
        try {
            this.mService.removeTransportModeTransform(pfd, transform.getResourceId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_IpSecManager$removeTunnelModeTransform(Network net, IpSecTransform transform) {
    }

    private final UdpEncapsulationSocket $$robo$$android_net_IpSecManager$openUdpEncapsulationSocket(int port) throws IOException, ResourceUnavailableException {
        if (port == 0) {
            throw new IllegalArgumentException("Specified port must be a valid port number!");
        }
        return new UdpEncapsulationSocket(this.mService, port);
    }

    private final UdpEncapsulationSocket $$robo$$android_net_IpSecManager$openUdpEncapsulationSocket() throws IOException, ResourceUnavailableException {
        return new UdpEncapsulationSocket(this.mService, 0);
    }

    private void $$robo$$android_net_IpSecManager$__constructor__(IIpSecService service) {
        this.mService = Preconditions.checkNotNull(service, "missing service");
    }

    public SecurityParameterIndex reserveSecurityParameterIndex(int n, InetAddress inetAddress) throws ResourceUnavailableException {
        return InvokeDynamicSupport.bootstrap("reserveSecurityParameterIndex", $$robo$$android_net_IpSecManager$reserveSecurityParameterIndex(int java.net.InetAddress ), 0, this, n, inetAddress);
    }

    public SecurityParameterIndex reserveSecurityParameterIndex(int n, InetAddress inetAddress, int n2) throws SpiUnavailableException, ResourceUnavailableException {
        return InvokeDynamicSupport.bootstrap("reserveSecurityParameterIndex", $$robo$$android_net_IpSecManager$reserveSecurityParameterIndex(int java.net.InetAddress int ), 0, this, n, inetAddress, n2);
    }

    public void applyTransportModeTransform(Socket socket, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("applyTransportModeTransform", $$robo$$android_net_IpSecManager$applyTransportModeTransform(java.net.Socket android.net.IpSecTransform ), 0, this, socket, ipSecTransform);
    }

    public void applyTransportModeTransform(DatagramSocket datagramSocket, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("applyTransportModeTransform", $$robo$$android_net_IpSecManager$applyTransportModeTransform(java.net.DatagramSocket android.net.IpSecTransform ), 0, this, datagramSocket, ipSecTransform);
    }

    public void applyTransportModeTransform(FileDescriptor fileDescriptor, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("applyTransportModeTransform", $$robo$$android_net_IpSecManager$applyTransportModeTransform(java.io.FileDescriptor android.net.IpSecTransform ), 0, this, fileDescriptor, ipSecTransform);
    }

    private void applyTransportModeTransform(ParcelFileDescriptor parcelFileDescriptor, IpSecTransform ipSecTransform) {
        InvokeDynamicSupport.bootstrap("applyTransportModeTransform", $$robo$$android_net_IpSecManager$applyTransportModeTransform(android.os.ParcelFileDescriptor android.net.IpSecTransform ), 0, this, parcelFileDescriptor, ipSecTransform);
    }

    public void applyTunnelModeTransform(Network network, IpSecTransform ipSecTransform) {
        InvokeDynamicSupport.bootstrap("applyTunnelModeTransform", $$robo$$android_net_IpSecManager$applyTunnelModeTransform(android.net.Network android.net.IpSecTransform ), 0, this, network, ipSecTransform);
    }

    public void removeTransportModeTransform(Socket socket, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("removeTransportModeTransform", $$robo$$android_net_IpSecManager$removeTransportModeTransform(java.net.Socket android.net.IpSecTransform ), 0, this, socket, ipSecTransform);
    }

    public void removeTransportModeTransform(DatagramSocket datagramSocket, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("removeTransportModeTransform", $$robo$$android_net_IpSecManager$removeTransportModeTransform(java.net.DatagramSocket android.net.IpSecTransform ), 0, this, datagramSocket, ipSecTransform);
    }

    public void removeTransportModeTransform(FileDescriptor fileDescriptor, IpSecTransform ipSecTransform) throws IOException {
        InvokeDynamicSupport.bootstrap("removeTransportModeTransform", $$robo$$android_net_IpSecManager$removeTransportModeTransform(java.io.FileDescriptor android.net.IpSecTransform ), 0, this, fileDescriptor, ipSecTransform);
    }

    private void removeTransportModeTransform(ParcelFileDescriptor parcelFileDescriptor, IpSecTransform ipSecTransform) {
        InvokeDynamicSupport.bootstrap("removeTransportModeTransform", $$robo$$android_net_IpSecManager$removeTransportModeTransform(android.os.ParcelFileDescriptor android.net.IpSecTransform ), 0, this, parcelFileDescriptor, ipSecTransform);
    }

    public void removeTunnelModeTransform(Network network, IpSecTransform ipSecTransform) {
        InvokeDynamicSupport.bootstrap("removeTunnelModeTransform", $$robo$$android_net_IpSecManager$removeTunnelModeTransform(android.net.Network android.net.IpSecTransform ), 0, this, network, ipSecTransform);
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket(int n) throws IOException, ResourceUnavailableException {
        return InvokeDynamicSupport.bootstrap("openUdpEncapsulationSocket", $$robo$$android_net_IpSecManager$openUdpEncapsulationSocket(int ), 0, this, n);
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket() throws IOException, ResourceUnavailableException {
        return InvokeDynamicSupport.bootstrap("openUdpEncapsulationSocket", $$robo$$android_net_IpSecManager$openUdpEncapsulationSocket(), 0, this);
    }

    private void __constructor__(IIpSecService iIpSecService) {
        this.$$robo$$android_net_IpSecManager$__constructor__(iIpSecService);
    }

    public IpSecManager(IIpSecService iIpSecService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager$__constructor__(android.net.IIpSecService ), 0, this, iIpSecService);
    }

    public /* synthetic */ IpSecManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpSecManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class UdpEncapsulationSocket
    implements AutoCloseable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ParcelFileDescriptor mPfd;
        private IIpSecService mService;
        private int mResourceId;
        private int mPort;
        private CloseGuard mCloseGuard;

        private void $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(IIpSecService service, int port) throws ResourceUnavailableException, IOException {
            this.mCloseGuard = CloseGuard.get();
            this.mService = service;
            try {
                IpSecUdpEncapResponse result = this.mService.openUdpEncapsulationSocket(port, new Binder());
                switch (result.status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more Sockets may be allocated by this requester.");
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + result.status);
                    }
                }
                this.mResourceId = result.resourceId;
                this.mPort = result.port;
                this.mPfd = result.fileDescriptor;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("constructor");
        }

        private final FileDescriptor $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getSocket() {
            if (this.mPfd == null) {
                return null;
            }
            return this.mPfd.getFileDescriptor();
        }

        private final int $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getPort() {
            return this.mPort;
        }

        private final void $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$close() throws IOException {
            try {
                this.mService.closeUdpEncapsulationSocket(this.mResourceId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            try {
                this.mPfd.close();
            }
            catch (IOException e) {
                Log.e("IpSecManager", "Failed to close UDP Encapsulation Socket with Port= " + this.mPort);
                throw e;
            }
            this.mCloseGuard.close();
        }

        private final void $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        private final int $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getResourceId() {
            return this.mResourceId;
        }

        private /* synthetic */ void $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(IIpSecService x0, int x1, 1 x2) throws ResourceUnavailableException, IOException {
        }

        private void __constructor__(IIpSecService iIpSecService, int n) throws ResourceUnavailableException, IOException {
            this.$$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(iIpSecService, n);
        }

        private UdpEncapsulationSocket(IIpSecService iIpSecService, int n) throws ResourceUnavailableException, IOException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(android.net.IIpSecService int ), 0, this, iIpSecService, n);
        }

        public FileDescriptor getSocket() {
            return InvokeDynamicSupport.bootstrap("getSocket", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getSocket(), 0, this);
        }

        public int getPort() {
            return (int)InvokeDynamicSupport.bootstrap("getPort", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getPort(), 0, this);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$close(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$finalize(), 0, this);
        }

        int getResourceId() {
            return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_net_IpSecManager_UdpEncapsulationSocket$getResourceId(), 0, this);
        }

        private /* synthetic */ void __constructor__(IIpSecService iIpSecService, int n, 1 var3_3) throws ResourceUnavailableException, IOException {
            this.$$robo$$android_net_IpSecManager_UdpEncapsulationSocket$__constructor__(iIpSecService, n, var3_3);
        }

        public /* synthetic */ UdpEncapsulationSocket() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UdpEncapsulationSocket)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SecurityParameterIndex
    implements AutoCloseable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IIpSecService mService;
        private InetAddress mRemoteAddress;
        private CloseGuard mCloseGuard;
        private int mSpi;
        private int mResourceId;

        private final int $$robo$$android_net_IpSecManager_SecurityParameterIndex$getSpi() {
            return this.mSpi;
        }

        private final void $$robo$$android_net_IpSecManager_SecurityParameterIndex$close() {
            try {
                this.mService.releaseSecurityParameterIndex(this.mResourceId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.close();
        }

        private final void $$robo$$android_net_IpSecManager_SecurityParameterIndex$finalize() {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        private void $$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(IIpSecService service, int direction, InetAddress remoteAddress, int spi) throws ResourceUnavailableException, SpiUnavailableException {
            this.mCloseGuard = CloseGuard.get();
            this.mSpi = 0;
            this.mService = service;
            this.mRemoteAddress = remoteAddress;
            try {
                IpSecSpiResponse result = this.mService.reserveSecurityParameterIndex(direction, remoteAddress.getHostAddress(), spi, new Binder());
                if (result == null) {
                    throw new NullPointerException("Received null response from IpSecService");
                }
                int status = result.status;
                switch (status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more SPIs may be allocated by this requester.");
                    }
                    case 2: {
                        throw new SpiUnavailableException("Requested SPI is unavailable", spi);
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + status);
                    }
                }
                this.mSpi = result.spi;
                this.mResourceId = result.resourceId;
                if (this.mSpi == 0) {
                    throw new RuntimeException("Invalid SPI returned by IpSecService: " + status);
                }
                if (this.mResourceId == 0) {
                    throw new RuntimeException("Invalid Resource ID returned by IpSecService: " + status);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("open");
        }

        private final int $$robo$$android_net_IpSecManager_SecurityParameterIndex$getResourceId() {
            return this.mResourceId;
        }

        private /* synthetic */ void $$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(IIpSecService x0, int x1, InetAddress x2, int x3, 1 x4) throws ResourceUnavailableException, SpiUnavailableException {
        }

        public int getSpi() {
            return (int)InvokeDynamicSupport.bootstrap("getSpi", $$robo$$android_net_IpSecManager_SecurityParameterIndex$getSpi(), 0, this);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_IpSecManager_SecurityParameterIndex$close(), 0, this);
        }

        protected void finalize() {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_IpSecManager_SecurityParameterIndex$finalize(), 0, this);
        }

        private void __constructor__(IIpSecService iIpSecService, int n, InetAddress inetAddress, int n2) throws ResourceUnavailableException, SpiUnavailableException {
            this.$$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(iIpSecService, n, inetAddress, n2);
        }

        private SecurityParameterIndex(IIpSecService iIpSecService, int n, InetAddress inetAddress, int n2) throws ResourceUnavailableException, SpiUnavailableException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(android.net.IIpSecService int java.net.InetAddress int ), 0, this, iIpSecService, n, inetAddress, n2);
        }

        int getResourceId() {
            return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_net_IpSecManager_SecurityParameterIndex$getResourceId(), 0, this);
        }

        private /* synthetic */ void __constructor__(IIpSecService iIpSecService, int n, InetAddress inetAddress, int n2, 1 var5_5) throws ResourceUnavailableException, SpiUnavailableException {
            this.$$robo$$android_net_IpSecManager_SecurityParameterIndex$__constructor__(iIpSecService, n, inetAddress, n2, var5_5);
        }

        public /* synthetic */ SecurityParameterIndex() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SecurityParameterIndex)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ResourceUnavailableException
    extends AndroidException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_IpSecManager_ResourceUnavailableException$__constructor__(String msg) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_net_IpSecManager_ResourceUnavailableException$__constructor__(string2);
        }

        ResourceUnavailableException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_ResourceUnavailableException$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ ResourceUnavailableException() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourceUnavailableException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SpiUnavailableException
    extends AndroidException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mSpi;

        private void $$robo$$android_net_IpSecManager_SpiUnavailableException$__constructor__(String msg, int spi) {
            this.mSpi = spi;
        }

        private final int $$robo$$android_net_IpSecManager_SpiUnavailableException$getSpi() {
            return this.mSpi;
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_net_IpSecManager_SpiUnavailableException$__constructor__(string2, n);
        }

        SpiUnavailableException(String string2, int n) {
            super(string2 + "(spi: " + n + ")");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecManager_SpiUnavailableException$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public int getSpi() {
            return (int)InvokeDynamicSupport.bootstrap("getSpi", $$robo$$android_net_IpSecManager_SpiUnavailableException$getSpi(), 0, this);
        }

        public /* synthetic */ SpiUnavailableException() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpiUnavailableException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Status
    extends InstrumentedInterface {
        public static final int OK = 0;
        public static final int RESOURCE_UNAVAILABLE = 1;
        public static final int SPI_UNAVAILABLE = 2;
    }
}

