/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.IIpSecService;
import android.net.IpSecAlgorithm;
import android.net.IpSecConfig;
import android.net.IpSecManager;
import android.net.IpSecTransformResponse;
import android.net.Network;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class IpSecTransform
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "IpSecTransform";
    public static int DIRECTION_IN = 0;
    public static int DIRECTION_OUT = 1;
    private static int MODE_TUNNEL = 0;
    private static int MODE_TRANSPORT = 1;
    public static int ENCAP_NONE = 0;
    public static int ENCAP_ESPINUDP_NON_IKE = 1;
    public static int ENCAP_ESPINUDP = 2;
    private IpSecConfig mConfig;
    private int mResourceId;
    private Context mContext;
    private CloseGuard mCloseGuard;
    private ConnectivityManager.PacketKeepalive mKeepalive;
    private int mKeepaliveStatus;
    private Object mKeepaliveSyncLock;
    private ConnectivityManager.PacketKeepaliveCallback mKeepaliveCallback;

    private void $$robo$$android_net_IpSecTransform$__constructor__(Context context, IpSecConfig config) {
        this.mCloseGuard = CloseGuard.get();
        this.mKeepaliveStatus = -1;
        this.mKeepaliveSyncLock = new Object();
        this.mKeepaliveCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IpSecTransform this$0;

            private void $$robo$$android_net_IpSecTransform_1$__constructor__(IpSecTransform this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_IpSecTransform_1$onStarted() {
                Object object = this.this$0.mKeepaliveSyncLock;
                synchronized (object) {
                    this.this$0.mKeepaliveStatus = 0;
                    this.this$0.mKeepaliveSyncLock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_IpSecTransform_1$onStopped() {
                Object object = this.this$0.mKeepaliveSyncLock;
                synchronized (object) {
                    this.this$0.mKeepaliveStatus = -1;
                    this.this$0.mKeepaliveSyncLock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_IpSecTransform_1$onError(int error) {
                Object object = this.this$0.mKeepaliveSyncLock;
                synchronized (object) {
                    this.this$0.mKeepaliveStatus = error;
                    this.this$0.mKeepaliveSyncLock.notifyAll();
                }
            }

            private void __constructor__(IpSecTransform ipSecTransform) {
                this.$$robo$$android_net_IpSecTransform_1$__constructor__(ipSecTransform);
            }
            {
                this.this$0 = ipSecTransform;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecTransform_1$__constructor__(android.net.IpSecTransform ), 0, this, ipSecTransform);
            }

            @Override
            public void onStarted() {
                InvokeDynamicSupport.bootstrap("onStarted", $$robo$$android_net_IpSecTransform_1$onStarted(), 0, this);
            }

            @Override
            public void onStopped() {
                InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_net_IpSecTransform_1$onStopped(), 0, this);
            }

            @Override
            public void onError(int n) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_net_IpSecTransform_1$onError(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mConfig = config;
        this.mResourceId = 0;
    }

    private final IIpSecService $$robo$$android_net_IpSecTransform$getIpSecService() {
        IBinder b = ServiceManager.getService("ipsec");
        if (b == null) {
            throw new RemoteException("Failed to connect to IpSecService").rethrowAsRuntimeException();
        }
        return IIpSecService.Stub.asInterface(b);
    }

    private final void $$robo$$android_net_IpSecTransform$checkResultStatusAndThrow(int status) throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        switch (status) {
            case 0: {
                return;
            }
            case 1: {
                throw new IpSecManager.ResourceUnavailableException("Failed to allocate a new IpSecTransform");
            }
            case 2: {
                Log.wtf("IpSecTransform", "Attempting to use an SPI that was somehow not reserved");
            }
        }
        throw new IllegalStateException("Failed to Create a Transform with status code " + status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IpSecTransform $$robo$$android_net_IpSecTransform$activate() throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        IpSecTransform ipSecTransform = this;
        synchronized (ipSecTransform) {
            try {
                IIpSecService svc = this.getIpSecService();
                IpSecTransformResponse result = svc.createTransportModeTransform(this.mConfig, new Binder());
                int status = result.status;
                this.checkResultStatusAndThrow(status);
                this.mResourceId = result.resourceId;
                this.startKeepalive(this.mContext);
                Log.d("IpSecTransform", "Added Transform with Id " + this.mResourceId);
                this.mCloseGuard.open("build");
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
        return this;
    }

    private final void $$robo$$android_net_IpSecTransform$close() {
        Log.d("IpSecTransform", "Removing Transform with Id " + this.mResourceId);
        if (this.mResourceId == 0) {
            this.mCloseGuard.close();
            return;
        }
        try {
            IIpSecService svc = this.getIpSecService();
            svc.deleteTransportModeTransform(this.mResourceId);
            this.stopKeepalive();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        finally {
            this.mResourceId = 0;
            this.mCloseGuard.close();
        }
    }

    private final void $$robo$$android_net_IpSecTransform$finalize() throws Throwable {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    private final IpSecConfig $$robo$$android_net_IpSecTransform$getConfig() {
        return this.mConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_IpSecTransform$startKeepalive(Context c) {
        if (this.mConfig.getNattKeepaliveInterval() == 0) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)c.getSystemService("connectivity");
        if (this.mKeepalive != null) {
            Log.wtf("IpSecTransform", "Keepalive already started for this IpSecTransform.");
            return;
        }
        Object object = this.mKeepaliveSyncLock;
        synchronized (object) {
            this.mKeepalive = cm.startNattKeepalive(this.mConfig.getNetwork(), this.mConfig.getNattKeepaliveInterval(), this.mKeepaliveCallback, this.mConfig.getLocalAddress(), 4660, this.mConfig.getRemoteAddress());
            try {
                this.mKeepaliveSyncLock.wait(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.mKeepaliveStatus != 0) {
            throw new UnsupportedOperationException("Packet Keepalive cannot be started");
        }
    }

    private final int $$robo$$android_net_IpSecTransform$getResourceId() {
        return this.mResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_IpSecTransform$stopKeepalive() {
        if (this.mKeepalive == null) {
            return;
        }
        this.mKeepalive.stop();
        Object object = this.mKeepaliveSyncLock;
        synchronized (object) {
            if (this.mKeepaliveStatus == 0) {
                try {
                    this.mKeepaliveSyncLock.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private /* synthetic */ void $$robo$$android_net_IpSecTransform$__constructor__(Context x0, IpSecConfig x1, 1 x2) {
    }

    private void __constructor__(Context context, IpSecConfig ipSecConfig) {
        this.$$robo$$android_net_IpSecTransform$__constructor__(context, ipSecConfig);
    }

    private IpSecTransform(Context context, IpSecConfig ipSecConfig) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecTransform$__constructor__(android.content.Context android.net.IpSecConfig ), 0, this, context, ipSecConfig);
    }

    private IIpSecService getIpSecService() {
        return InvokeDynamicSupport.bootstrap("getIpSecService", $$robo$$android_net_IpSecTransform$getIpSecService(), 0, this);
    }

    private void checkResultStatusAndThrow(int n) throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        InvokeDynamicSupport.bootstrap("checkResultStatusAndThrow", $$robo$$android_net_IpSecTransform$checkResultStatusAndThrow(int ), 0, this, n);
    }

    private IpSecTransform activate() throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        return InvokeDynamicSupport.bootstrap("activate", $$robo$$android_net_IpSecTransform$activate(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_IpSecTransform$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_IpSecTransform$finalize(), 0, this);
    }

    IpSecConfig getConfig() {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$android_net_IpSecTransform$getConfig(), 0, this);
    }

    void startKeepalive(Context context) {
        InvokeDynamicSupport.bootstrap("startKeepalive", $$robo$$android_net_IpSecTransform$startKeepalive(android.content.Context ), 0, this, context);
    }

    int getResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_net_IpSecTransform$getResourceId(), 0, this);
    }

    void stopKeepalive() {
        InvokeDynamicSupport.bootstrap("stopKeepalive", $$robo$$android_net_IpSecTransform$stopKeepalive(), 0, this);
    }

    private /* synthetic */ void __constructor__(Context context, IpSecConfig ipSecConfig, 1 var3_3) {
        this.$$robo$$android_net_IpSecTransform$__constructor__(context, ipSecConfig, var3_3);
    }

    public /* synthetic */ IpSecTransform() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpSecTransform)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContext;
        private IpSecConfig mConfig;

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setEncryption(int direction, IpSecAlgorithm algo) {
            this.mConfig.flow[direction].encryption = algo;
            return this;
        }

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setAuthentication(int direction, IpSecAlgorithm algo) {
            this.mConfig.flow[direction].authentication = algo;
            return this;
        }

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setSpi(int direction, IpSecManager.SecurityParameterIndex spi) {
            this.mConfig.flow[direction].spiResourceId = spi.getResourceId();
            return this;
        }

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setUnderlyingNetwork(Network net) {
            this.mConfig.network = net;
            return this;
        }

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setIpv4Encapsulation(IpSecManager.UdpEncapsulationSocket localSocket, int remotePort) {
            this.mConfig.encapType = 2;
            this.mConfig.encapLocalPortResourceId = localSocket.getResourceId();
            this.mConfig.encapRemotePort = remotePort;
            return this;
        }

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setNattKeepalive(int intervalSeconds) {
            this.mConfig.nattKeepaliveInterval = intervalSeconds;
            return this;
        }

        private final IpSecTransform $$robo$$android_net_IpSecTransform_Builder$buildTransportModeTransform(InetAddress remoteAddress) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            this.mConfig.mode = 1;
            this.mConfig.remoteAddress = remoteAddress;
            return new IpSecTransform(this.mContext, this.mConfig).activate();
        }

        private final IpSecTransform $$robo$$android_net_IpSecTransform_Builder$buildTunnelModeTransform(InetAddress localAddress, InetAddress remoteAddress) {
            this.mConfig.localAddress = localAddress;
            this.mConfig.remoteAddress = remoteAddress;
            this.mConfig.mode = 0;
            return new IpSecTransform(this.mContext, this.mConfig);
        }

        private void $$robo$$android_net_IpSecTransform_Builder$__constructor__(Context context) {
            Preconditions.checkNotNull(context);
            this.mContext = context;
            this.mConfig = new IpSecConfig();
        }

        public Builder setEncryption(int n, IpSecAlgorithm ipSecAlgorithm) {
            return InvokeDynamicSupport.bootstrap("setEncryption", $$robo$$android_net_IpSecTransform_Builder$setEncryption(int android.net.IpSecAlgorithm ), 0, this, n, ipSecAlgorithm);
        }

        public Builder setAuthentication(int n, IpSecAlgorithm ipSecAlgorithm) {
            return InvokeDynamicSupport.bootstrap("setAuthentication", $$robo$$android_net_IpSecTransform_Builder$setAuthentication(int android.net.IpSecAlgorithm ), 0, this, n, ipSecAlgorithm);
        }

        public Builder setSpi(int n, IpSecManager.SecurityParameterIndex securityParameterIndex) {
            return InvokeDynamicSupport.bootstrap("setSpi", $$robo$$android_net_IpSecTransform_Builder$setSpi(int android.net.IpSecManager$SecurityParameterIndex ), 0, this, n, securityParameterIndex);
        }

        public Builder setUnderlyingNetwork(Network network) {
            return InvokeDynamicSupport.bootstrap("setUnderlyingNetwork", $$robo$$android_net_IpSecTransform_Builder$setUnderlyingNetwork(android.net.Network ), 0, this, network);
        }

        public Builder setIpv4Encapsulation(IpSecManager.UdpEncapsulationSocket udpEncapsulationSocket, int n) {
            return InvokeDynamicSupport.bootstrap("setIpv4Encapsulation", $$robo$$android_net_IpSecTransform_Builder$setIpv4Encapsulation(android.net.IpSecManager$UdpEncapsulationSocket int ), 0, this, udpEncapsulationSocket, n);
        }

        public Builder setNattKeepalive(int n) {
            return InvokeDynamicSupport.bootstrap("setNattKeepalive", $$robo$$android_net_IpSecTransform_Builder$setNattKeepalive(int ), 0, this, n);
        }

        public IpSecTransform buildTransportModeTransform(InetAddress inetAddress) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            return InvokeDynamicSupport.bootstrap("buildTransportModeTransform", $$robo$$android_net_IpSecTransform_Builder$buildTransportModeTransform(java.net.InetAddress ), 0, this, inetAddress);
        }

        public IpSecTransform buildTunnelModeTransform(InetAddress inetAddress, InetAddress inetAddress2) {
            return InvokeDynamicSupport.bootstrap("buildTunnelModeTransform", $$robo$$android_net_IpSecTransform_Builder$buildTunnelModeTransform(java.net.InetAddress java.net.InetAddress ), 0, this, inetAddress, inetAddress2);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_net_IpSecTransform_Builder$__constructor__(context);
        }

        public Builder(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecTransform_Builder$__constructor__(android.content.Context ), 0, this, context);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncapType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransformDirection {
    }
}

