/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkErrorMessage;
import android.net.netlink.NetlinkMessage;
import android.system.ErrnoException;
import android.system.NetlinkSocketAddress;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructTimeval;
import android.util.Log;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetlinkSocket
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NetlinkSocket";
    private static int SOCKET_RECV_BUFSIZE = 65536;
    private static int DEFAULT_RECV_BUFSIZE = 8192;
    private FileDescriptor mDescriptor;
    private NetlinkSocketAddress mAddr;
    private long mLastRecvTimeoutMs;
    private long mLastSendTimeoutMs;

    private static final void $$robo$$android_net_netlink_NetlinkSocket$sendOneShotKernelMessage(int nlProto, byte[] msg) throws ErrnoException {
        block19: {
            String errPrefix = "Error in NetlinkSocket.sendOneShotKernelMessage";
            try (NetlinkSocket nlSocket = new NetlinkSocket(nlProto);){
                String errmsg;
                long IO_TIMEOUT = 300L;
                nlSocket.connectToKernel();
                nlSocket.sendMessage(msg, 0, msg.length, 300L);
                ByteBuffer bytes = nlSocket.recvMessage(300L);
                NetlinkMessage response = NetlinkMessage.parse(bytes);
                if (response != null && response instanceof NetlinkErrorMessage && ((NetlinkErrorMessage)response).getNlMsgError() != null) {
                    int errno = ((NetlinkErrorMessage)response).getNlMsgError().error;
                    if (errno != 0) {
                        Log.e("NetlinkSocket", "Error in NetlinkSocket.sendOneShotKernelMessage, errmsg=" + response.toString());
                        throw new ErrnoException(response.toString(), Math.abs(errno));
                    }
                    break block19;
                }
                if (response == null) {
                    bytes.position(0);
                    errmsg = "raw bytes: " + NetlinkConstants.hexify(bytes);
                } else {
                    errmsg = response.toString();
                }
                Log.e("NetlinkSocket", "Error in NetlinkSocket.sendOneShotKernelMessage, errmsg=" + errmsg);
                throw new ErrnoException(errmsg, OsConstants.EPROTO);
            }
            catch (InterruptedIOException e) {
                Log.e("NetlinkSocket", "Error in NetlinkSocket.sendOneShotKernelMessage", e);
                throw new ErrnoException("Error in NetlinkSocket.sendOneShotKernelMessage", OsConstants.ETIMEDOUT, e);
            }
            catch (SocketException e) {
                Log.e("NetlinkSocket", "Error in NetlinkSocket.sendOneShotKernelMessage", e);
                throw new ErrnoException("Error in NetlinkSocket.sendOneShotKernelMessage", OsConstants.EIO, e);
            }
        }
    }

    private void $$robo$$android_net_netlink_NetlinkSocket$__constructor__(int nlProto) throws ErrnoException {
        this.mDescriptor = Os.socket(OsConstants.AF_NETLINK, OsConstants.SOCK_DGRAM, nlProto);
        Libcore.os.setsockoptInt(this.mDescriptor, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF, 65536);
    }

    private final NetlinkSocketAddress $$robo$$android_net_netlink_NetlinkSocket$getLocalAddress() throws ErrnoException {
        return (NetlinkSocketAddress)Os.getsockname(this.mDescriptor);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$bind(NetlinkSocketAddress localAddr) throws ErrnoException, SocketException {
        Os.bind(this.mDescriptor, localAddr);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$connectTo(NetlinkSocketAddress peerAddr) throws ErrnoException, SocketException {
        Os.connect(this.mDescriptor, peerAddr);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$connectToKernel() throws ErrnoException, SocketException {
        this.connectTo(new NetlinkSocketAddress(0, 0));
    }

    private final ByteBuffer $$robo$$android_net_netlink_NetlinkSocket$recvMessage() throws ErrnoException, InterruptedIOException {
        return this.recvMessage(8192, 0L);
    }

    private final ByteBuffer $$robo$$android_net_netlink_NetlinkSocket$recvMessage(long timeoutMs) throws ErrnoException, InterruptedIOException {
        return this.recvMessage(8192, timeoutMs);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$checkTimeout(long timeoutMs) {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Negative timeouts not permitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer $$robo$$android_net_netlink_NetlinkSocket$recvMessage(int bufsize, long timeoutMs) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        this.checkTimeout(timeoutMs);
        FileDescriptor fileDescriptor = this.mDescriptor;
        synchronized (fileDescriptor) {
            if (this.mLastRecvTimeoutMs != timeoutMs) {
                Os.setsockoptTimeval(this.mDescriptor, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, StructTimeval.fromMillis(timeoutMs));
                this.mLastRecvTimeoutMs = timeoutMs;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufsize);
        int length = Os.read(this.mDescriptor, byteBuffer);
        if (length == bufsize) {
            Log.w("NetlinkSocket", "maximum read");
        }
        byteBuffer.position(0);
        byteBuffer.limit(length);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    private final boolean $$robo$$android_net_netlink_NetlinkSocket$sendMessage(byte[] bytes, int offset, int count) throws ErrnoException, InterruptedIOException {
        return this.sendMessage(bytes, offset, count, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_netlink_NetlinkSocket$sendMessage(byte[] bytes, int offset, int count, long timeoutMs) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        this.checkTimeout(timeoutMs);
        FileDescriptor fileDescriptor = this.mDescriptor;
        synchronized (fileDescriptor) {
            if (this.mLastSendTimeoutMs != timeoutMs) {
                Os.setsockoptTimeval(this.mDescriptor, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, StructTimeval.fromMillis(timeoutMs));
                this.mLastSendTimeoutMs = timeoutMs;
            }
        }
        return count == Os.write(this.mDescriptor, bytes, offset, count);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$close() {
        IoUtils.closeQuietly(this.mDescriptor);
    }

    public static void sendOneShotKernelMessage(int n, byte[] byArray) throws ErrnoException {
        InvokeDynamicSupport.bootstrapStatic("sendOneShotKernelMessage", $$robo$$android_net_netlink_NetlinkSocket$sendOneShotKernelMessage(int byte[] ), 0, (int)n, (byte[])byArray);
    }

    private void __constructor__(int n) throws ErrnoException {
        this.$$robo$$android_net_netlink_NetlinkSocket$__constructor__(n);
    }

    public NetlinkSocket(int n) throws ErrnoException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_netlink_NetlinkSocket$__constructor__(int ), 0, this, n);
    }

    public NetlinkSocketAddress getLocalAddress() throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("getLocalAddress", $$robo$$android_net_netlink_NetlinkSocket$getLocalAddress(), 0, this);
    }

    public void bind(NetlinkSocketAddress netlinkSocketAddress) throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrap("bind", $$robo$$android_net_netlink_NetlinkSocket$bind(android.system.NetlinkSocketAddress ), 0, this, netlinkSocketAddress);
    }

    public void connectTo(NetlinkSocketAddress netlinkSocketAddress) throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrap("connectTo", $$robo$$android_net_netlink_NetlinkSocket$connectTo(android.system.NetlinkSocketAddress ), 0, this, netlinkSocketAddress);
    }

    public void connectToKernel() throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrap("connectToKernel", $$robo$$android_net_netlink_NetlinkSocket$connectToKernel(), 0, this);
    }

    public ByteBuffer recvMessage() throws ErrnoException, InterruptedIOException {
        return InvokeDynamicSupport.bootstrap("recvMessage", $$robo$$android_net_netlink_NetlinkSocket$recvMessage(), 0, this);
    }

    public ByteBuffer recvMessage(long l) throws ErrnoException, InterruptedIOException {
        return InvokeDynamicSupport.bootstrap("recvMessage", $$robo$$android_net_netlink_NetlinkSocket$recvMessage(long ), 0, this, l);
    }

    private void checkTimeout(long l) {
        InvokeDynamicSupport.bootstrap("checkTimeout", $$robo$$android_net_netlink_NetlinkSocket$checkTimeout(long ), 0, this, l);
    }

    public ByteBuffer recvMessage(int n, long l) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        return InvokeDynamicSupport.bootstrap("recvMessage", $$robo$$android_net_netlink_NetlinkSocket$recvMessage(int long ), 0, this, n, l);
    }

    public boolean sendMessage(byte[] byArray, int n, int n2) throws ErrnoException, InterruptedIOException {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_net_netlink_NetlinkSocket$sendMessage(byte[] int int ), 0, this, byArray, n, n2);
    }

    public boolean sendMessage(byte[] byArray, int n, int n2, long l) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_net_netlink_NetlinkSocket$sendMessage(byte[] int int long ), 0, this, byArray, n, n2, l);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_netlink_NetlinkSocket$close(), 0, this);
    }

    public /* synthetic */ NetlinkSocket() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetlinkSocket)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

