/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.IoBridge;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BlockingSocketReader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int DEFAULT_RECV_BUF_SIZE = 2048;
    private byte[] mPacket;
    private Thread mThread;
    private volatile FileDescriptor mSocket;
    private volatile boolean mRunning;
    private volatile long mPacketsReceived;

    private static final void $$robo$$android_net_util_BlockingSocketReader$closeSocket(FileDescriptor fd) {
        try {
            IoBridge.closeAndSignalBlockedThreads(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void $$robo$$android_net_util_BlockingSocketReader$__constructor__() {
    }

    private void $$robo$$android_net_util_BlockingSocketReader$__constructor__(int recvbufsize) {
        if (recvbufsize < 2048) {
            recvbufsize = 2048;
        }
        this.mPacket = new byte[recvbufsize];
        this.mThread = new Thread(() -> this.mainLoop());
    }

    private final boolean $$robo$$android_net_util_BlockingSocketReader$start() {
        if (this.mSocket != null) {
            return false;
        }
        try {
            this.mSocket = this.createSocket();
        }
        catch (Exception e) {
            this.logError("Failed to create socket: ", e);
            return false;
        }
        if (this.mSocket == null) {
            return false;
        }
        this.mRunning = true;
        this.mThread.start();
        return true;
    }

    private final void $$robo$$android_net_util_BlockingSocketReader$stop() {
        this.mRunning = false;
        BlockingSocketReader.closeSocket(this.mSocket);
        this.mSocket = null;
    }

    private final boolean $$robo$$android_net_util_BlockingSocketReader$isRunning() {
        return this.mRunning;
    }

    private final long $$robo$$android_net_util_BlockingSocketReader$numPacketsReceived() {
        return this.mPacketsReceived;
    }

    protected abstract FileDescriptor createSocket();

    private final void $$robo$$android_net_util_BlockingSocketReader$handlePacket(byte[] recvbuf, int length) {
    }

    private final void $$robo$$android_net_util_BlockingSocketReader$logError(String msg, Exception e) {
    }

    private final void $$robo$$android_net_util_BlockingSocketReader$onExit() {
    }

    private final void $$robo$$android_net_util_BlockingSocketReader$mainLoop() {
        while (this.isRunning()) {
            int bytesRead;
            try {
                bytesRead = Os.read(this.mSocket, this.mPacket, 0, this.mPacket.length);
                if (bytesRead < 1) {
                    if (!this.isRunning()) break;
                    this.logError("Socket closed, exiting", null);
                    break;
                }
                ++this.mPacketsReceived;
            }
            catch (ErrnoException e) {
                if (e.errno == OsConstants.EINTR) continue;
                if (!this.isRunning()) break;
                this.logError("read error: ", e);
                break;
            }
            catch (IOException ioe) {
                if (!this.isRunning()) continue;
                this.logError("read error: ", ioe);
                continue;
            }
            try {
                this.handlePacket(this.mPacket, bytesRead);
            }
            catch (Exception e) {
                this.logError("Unexpected exception: ", e);
                break;
            }
        }
        this.stop();
        this.onExit();
    }

    public static void closeSocket(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("closeSocket", $$robo$$android_net_util_BlockingSocketReader$closeSocket(java.io.FileDescriptor ), 0, (FileDescriptor)fileDescriptor);
    }

    private void __constructor__() {
        this.$$robo$$android_net_util_BlockingSocketReader$__constructor__();
    }

    protected BlockingSocketReader() {
        this(2048);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_BlockingSocketReader$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_net_util_BlockingSocketReader$__constructor__(n);
    }

    protected BlockingSocketReader(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_BlockingSocketReader$__constructor__(int ), 0, this, n);
    }

    public boolean start() {
        return (boolean)InvokeDynamicSupport.bootstrap("start", $$robo$$android_net_util_BlockingSocketReader$start(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_net_util_BlockingSocketReader$stop(), 0, this);
    }

    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_net_util_BlockingSocketReader$isRunning(), 0, this);
    }

    public long numPacketsReceived() {
        return (long)InvokeDynamicSupport.bootstrap("numPacketsReceived", $$robo$$android_net_util_BlockingSocketReader$numPacketsReceived(), 0, this);
    }

    protected void handlePacket(byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("handlePacket", $$robo$$android_net_util_BlockingSocketReader$handlePacket(byte[] int ), 0, this, byArray, n);
    }

    protected void logError(String string2, Exception exception) {
        InvokeDynamicSupport.bootstrap("logError", $$robo$$android_net_util_BlockingSocketReader$logError(java.lang.String java.lang.Exception ), 0, this, string2, exception);
    }

    protected void onExit() {
        InvokeDynamicSupport.bootstrap("onExit", $$robo$$android_net_util_BlockingSocketReader$onExit(), 0, this);
    }

    private void mainLoop() {
        InvokeDynamicSupport.bootstrap("mainLoop", $$robo$$android_net_util_BlockingSocketReader$mainLoop(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BlockingSocketReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

