/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Slog;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MultinetworkPolicyTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private Context mContext;
    private Handler mHandler;
    private Runnable mReevaluateRunnable;
    private List<Uri> mSettingsUris;
    private ContentResolver mResolver;
    private SettingObserver mSettingObserver;
    private BroadcastReceiver mBroadcastReceiver;
    private volatile boolean mAvoidBadWifi;
    private volatile int mMeteredMultipathPreference;

    private void $$robo$$android_net_util_MultinetworkPolicyTracker$__constructor__(Context ctx, Handler handler) {
    }

    private void $$robo$$android_net_util_MultinetworkPolicyTracker$__constructor__(Context ctx, Handler handler, Runnable avoidBadWifiCallback) {
        this.mAvoidBadWifi = true;
        this.mContext = ctx;
        this.mHandler = handler;
        this.mReevaluateRunnable = () -> {
            if (this.updateAvoidBadWifi() && avoidBadWifiCallback != null) {
                avoidBadWifiCallback.run();
            }
            this.updateMeteredMultipathPreference();
        };
        this.mSettingsUris = Arrays.asList(Settings.Global.getUriFor("network_avoid_bad_wifi"), Settings.Global.getUriFor("network_metered_multipath_preference"));
        this.mResolver = this.mContext.getContentResolver();
        this.mSettingObserver = new SettingObserver(this);
        this.mBroadcastReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MultinetworkPolicyTracker this$0;

            private void $$robo$$android_net_util_MultinetworkPolicyTracker_1$__constructor__(MultinetworkPolicyTracker this$0) {
            }

            private final void $$robo$$android_net_util_MultinetworkPolicyTracker_1$onReceive(Context context, Intent intent) {
                this.this$0.reevaluate();
            }

            private void __constructor__(MultinetworkPolicyTracker multinetworkPolicyTracker) {
                this.$$robo$$android_net_util_MultinetworkPolicyTracker_1$__constructor__(multinetworkPolicyTracker);
            }
            {
                this.this$0 = multinetworkPolicyTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_MultinetworkPolicyTracker_1$__constructor__(android.net.util.MultinetworkPolicyTracker ), 0, this, multinetworkPolicyTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_net_util_MultinetworkPolicyTracker_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.updateAvoidBadWifi();
        this.updateMeteredMultipathPreference();
    }

    private final void $$robo$$android_net_util_MultinetworkPolicyTracker$start() {
        for (Uri uri : this.mSettingsUris) {
            this.mResolver.registerContentObserver(uri, false, this.mSettingObserver);
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, intentFilter, null, null);
        this.reevaluate();
    }

    private final void $$robo$$android_net_util_MultinetworkPolicyTracker$shutdown() {
        this.mResolver.unregisterContentObserver(this.mSettingObserver);
        this.mContext.unregisterReceiver(this.mBroadcastReceiver);
    }

    private final boolean $$robo$$android_net_util_MultinetworkPolicyTracker$getAvoidBadWifi() {
        return this.mAvoidBadWifi;
    }

    private final int $$robo$$android_net_util_MultinetworkPolicyTracker$getMeteredMultipathPreference() {
        return this.mMeteredMultipathPreference;
    }

    private final boolean $$robo$$android_net_util_MultinetworkPolicyTracker$configRestrictsAvoidBadWifi() {
        return this.mContext.getResources().getInteger(17694814) == 0;
    }

    private final boolean $$robo$$android_net_util_MultinetworkPolicyTracker$shouldNotifyWifiUnvalidated() {
        return this.configRestrictsAvoidBadWifi() && this.getAvoidBadWifiSetting() == null;
    }

    private final String $$robo$$android_net_util_MultinetworkPolicyTracker$getAvoidBadWifiSetting() {
        return Settings.Global.getString(this.mResolver, "network_avoid_bad_wifi");
    }

    private final void $$robo$$android_net_util_MultinetworkPolicyTracker$reevaluate() {
        this.mHandler.post(this.mReevaluateRunnable);
    }

    private final boolean $$robo$$android_net_util_MultinetworkPolicyTracker$updateAvoidBadWifi() {
        boolean settingAvoidBadWifi = "1".equals(this.getAvoidBadWifiSetting());
        boolean prev = this.mAvoidBadWifi;
        this.mAvoidBadWifi = settingAvoidBadWifi || !this.configRestrictsAvoidBadWifi();
        return this.mAvoidBadWifi != prev;
    }

    private final int $$robo$$android_net_util_MultinetworkPolicyTracker$configMeteredMultipathPreference() {
        return this.mContext.getResources().getInteger(17694815);
    }

    private final void $$robo$$android_net_util_MultinetworkPolicyTracker$updateMeteredMultipathPreference() {
        String setting = Settings.Global.getString(this.mResolver, "network_metered_multipath_preference");
        try {
            this.mMeteredMultipathPreference = Integer.parseInt(setting);
        }
        catch (NumberFormatException e) {
            this.mMeteredMultipathPreference = this.configMeteredMultipathPreference();
        }
    }

    static void __staticInitializer__() {
        TAG = MultinetworkPolicyTracker.class.getSimpleName();
    }

    private void __constructor__(Context context, Handler handler) {
        this.$$robo$$android_net_util_MultinetworkPolicyTracker$__constructor__(context, handler);
    }

    public MultinetworkPolicyTracker(Context context, Handler handler) {
        this(context, handler, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_MultinetworkPolicyTracker$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    private void __constructor__(Context context, Handler handler, Runnable runnable) {
        this.$$robo$$android_net_util_MultinetworkPolicyTracker$__constructor__(context, handler, runnable);
    }

    public MultinetworkPolicyTracker(Context context, Handler handler, Runnable runnable) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_MultinetworkPolicyTracker$__constructor__(android.content.Context android.os.Handler java.lang.Runnable ), 0, this, context, handler, runnable);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_net_util_MultinetworkPolicyTracker$start(), 0, this);
    }

    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_net_util_MultinetworkPolicyTracker$shutdown(), 0, this);
    }

    public boolean getAvoidBadWifi() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAvoidBadWifi", $$robo$$android_net_util_MultinetworkPolicyTracker$getAvoidBadWifi(), 0, this);
    }

    public int getMeteredMultipathPreference() {
        return (int)InvokeDynamicSupport.bootstrap("getMeteredMultipathPreference", $$robo$$android_net_util_MultinetworkPolicyTracker$getMeteredMultipathPreference(), 0, this);
    }

    public boolean configRestrictsAvoidBadWifi() {
        return (boolean)InvokeDynamicSupport.bootstrap("configRestrictsAvoidBadWifi", $$robo$$android_net_util_MultinetworkPolicyTracker$configRestrictsAvoidBadWifi(), 0, this);
    }

    public boolean shouldNotifyWifiUnvalidated() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldNotifyWifiUnvalidated", $$robo$$android_net_util_MultinetworkPolicyTracker$shouldNotifyWifiUnvalidated(), 0, this);
    }

    public String getAvoidBadWifiSetting() {
        return InvokeDynamicSupport.bootstrap("getAvoidBadWifiSetting", $$robo$$android_net_util_MultinetworkPolicyTracker$getAvoidBadWifiSetting(), 0, this);
    }

    public void reevaluate() {
        InvokeDynamicSupport.bootstrap("reevaluate", $$robo$$android_net_util_MultinetworkPolicyTracker$reevaluate(), 0, this);
    }

    public boolean updateAvoidBadWifi() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateAvoidBadWifi", $$robo$$android_net_util_MultinetworkPolicyTracker$updateAvoidBadWifi(), 0, this);
    }

    public int configMeteredMultipathPreference() {
        return (int)InvokeDynamicSupport.bootstrap("configMeteredMultipathPreference", $$robo$$android_net_util_MultinetworkPolicyTracker$configMeteredMultipathPreference(), 0, this);
    }

    public void updateMeteredMultipathPreference() {
        InvokeDynamicSupport.bootstrap("updateMeteredMultipathPreference", $$robo$$android_net_util_MultinetworkPolicyTracker$updateMeteredMultipathPreference(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MultinetworkPolicyTracker.class);
    }

    public /* synthetic */ MultinetworkPolicyTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultinetworkPolicyTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SettingObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MultinetworkPolicyTracker this$0;

        private void $$robo$$android_net_util_MultinetworkPolicyTracker_SettingObserver$__constructor__(MultinetworkPolicyTracker multinetworkPolicyTracker) {
        }

        private final void $$robo$$android_net_util_MultinetworkPolicyTracker_SettingObserver$onChange(boolean selfChange) {
            Slog.wtf(TAG, "Should never be reached.");
        }

        private final void $$robo$$android_net_util_MultinetworkPolicyTracker_SettingObserver$onChange(boolean selfChange, Uri uri) {
            if (!this.this$0.mSettingsUris.contains(uri)) {
                Slog.wtf(TAG, "Unexpected settings observation: " + uri);
            }
            this.this$0.reevaluate();
        }

        private void __constructor__(MultinetworkPolicyTracker multinetworkPolicyTracker) {
            this.$$robo$$android_net_util_MultinetworkPolicyTracker_SettingObserver$__constructor__(multinetworkPolicyTracker);
        }

        public SettingObserver(MultinetworkPolicyTracker multinetworkPolicyTracker) {
            this.this$0 = multinetworkPolicyTracker;
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_MultinetworkPolicyTracker_SettingObserver$__constructor__(android.net.util.MultinetworkPolicyTracker ), 0, this, multinetworkPolicyTracker);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_net_util_MultinetworkPolicyTracker_SettingObserver$onChange(boolean ), 0, this, bl);
        }

        @Override
        public void onChange(boolean bl, Uri uri) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_net_util_MultinetworkPolicyTracker_SettingObserver$onChange(boolean android.net.Uri ), 0, this, bl, uri);
        }

        public /* synthetic */ SettingObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

