/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.IRttManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RttManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "RttManager";
    @Deprecated
    public static int RTT_TYPE_UNSPECIFIED = 0;
    public static int RTT_TYPE_ONE_SIDED = 1;
    public static int RTT_TYPE_TWO_SIDED = 2;
    @Deprecated
    public static int RTT_TYPE_11_V = 2;
    @Deprecated
    public static int RTT_TYPE_11_MC = 4;
    @Deprecated
    public static int RTT_PEER_TYPE_UNSPECIFIED = 0;
    public static int RTT_PEER_TYPE_AP = 1;
    public static int RTT_PEER_TYPE_STA = 2;
    public static int RTT_PEER_P2P_GO = 3;
    public static int RTT_PEER_P2P_CLIENT = 4;
    public static int RTT_PEER_NAN = 5;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_20 = 0;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_40 = 1;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_80 = 2;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_160 = 3;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_80P80 = 4;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_5 = 5;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_10 = 6;
    @Deprecated
    public static int RTT_CHANNEL_WIDTH_UNSPECIFIED = -1;
    public static int RTT_STATUS_SUCCESS = 0;
    public static int RTT_STATUS_FAILURE = 1;
    public static int RTT_STATUS_FAIL_NO_RSP = 2;
    public static int RTT_STATUS_FAIL_REJECTED = 3;
    public static int RTT_STATUS_FAIL_NOT_SCHEDULED_YET = 4;
    public static int RTT_STATUS_FAIL_TM_TIMEOUT = 5;
    public static int RTT_STATUS_FAIL_AP_ON_DIFF_CHANNEL = 6;
    public static int RTT_STATUS_FAIL_NO_CAPABILITY = 7;
    public static int RTT_STATUS_ABORTED = 8;
    public static int RTT_STATUS_FAIL_INVALID_TS = 9;
    public static int RTT_STATUS_FAIL_PROTOCOL = 10;
    public static int RTT_STATUS_FAIL_SCHEDULE = 11;
    public static int RTT_STATUS_FAIL_BUSY_TRY_LATER = 12;
    public static int RTT_STATUS_INVALID_REQ = 13;
    public static int RTT_STATUS_NO_WIFI = 14;
    public static int RTT_STATUS_FAIL_FTM_PARAM_OVERRIDE = 15;
    public static int REASON_UNSPECIFIED = -1;
    public static int REASON_NOT_AVAILABLE = -2;
    public static int REASON_INVALID_LISTENER = -3;
    public static int REASON_INVALID_REQUEST = -4;
    public static int REASON_PERMISSION_DENIED = -5;
    public static int REASON_INITIATOR_NOT_ALLOWED_WHEN_RESPONDER_ON = -6;
    public static String DESCRIPTION_KEY = "android.net.wifi.RttManager.Description";
    public static int RTT_BW_5_SUPPORT = 1;
    public static int RTT_BW_10_SUPPORT = 2;
    public static int RTT_BW_20_SUPPORT = 4;
    public static int RTT_BW_40_SUPPORT = 8;
    public static int RTT_BW_80_SUPPORT = 16;
    public static int RTT_BW_160_SUPPORT = 32;
    public static int PREAMBLE_LEGACY = 1;
    public static int PREAMBLE_HT = 2;
    public static int PREAMBLE_VHT = 4;
    public static int BASE = 160256;
    public static int CMD_OP_START_RANGING = 160256;
    public static int CMD_OP_STOP_RANGING = 160257;
    public static int CMD_OP_FAILED = 160258;
    public static int CMD_OP_SUCCEEDED = 160259;
    public static int CMD_OP_ABORTED = 160260;
    public static int CMD_OP_ENABLE_RESPONDER = 160261;
    public static int CMD_OP_DISABLE_RESPONDER = 160262;
    public static int CMD_OP_ENALBE_RESPONDER_SUCCEEDED = 160263;
    public static int CMD_OP_ENALBE_RESPONDER_FAILED = 160264;
    public static int CMD_OP_REG_BINDER = 160265;
    private static int INVALID_KEY = 0;
    private Context mContext;
    private IRttManager mService;
    private SparseArray mListenerMap;
    private Object mListenerMapLock;
    private Object mCapabilitiesLock;
    private RttCapabilities mRttCapabilities;
    private int mListenerKey;
    private AsyncChannel mAsyncChannel;

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final Capabilities $$robo$$android_net_wifi_RttManager$getCapabilities() {
        return new Capabilities(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RttCapabilities $$robo$$android_net_wifi_RttManager$getRttCapabilities() {
        Object object = this.mCapabilitiesLock;
        synchronized (object) {
            if (this.mRttCapabilities == null) {
                try {
                    this.mRttCapabilities = this.mService.getRttCapabilities();
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return this.mRttCapabilities;
        }
    }

    private final boolean $$robo$$android_net_wifi_RttManager$rttParamSanity(RttParams params, int index) {
        if (this.mRttCapabilities == null && this.getRttCapabilities() == null) {
            Log.e("RttManager", "Can not get RTT capabilities");
            throw new IllegalStateException("RTT chip is not working");
        }
        if (params.deviceType != 1) {
            return false;
        }
        if (params.requestType != 1 && params.requestType != 2) {
            Log.e("RttManager", "Request " + index + ": Illegal Request Type: " + params.requestType);
            return false;
        }
        if (params.requestType == 1 && !this.mRttCapabilities.oneSidedRttSupported) {
            Log.e("RttManager", "Request " + index + ": One side RTT is not supported");
            return false;
        }
        if (params.requestType == 2 && !this.mRttCapabilities.twoSided11McRttSupported) {
            Log.e("RttManager", "Request " + index + ": two side RTT is not supported");
            return false;
        }
        if (params.bssid == null || params.bssid.isEmpty()) {
            Log.e("RttManager", "No BSSID in params");
            return false;
        }
        if (params.numberBurst != 0) {
            Log.e("RttManager", "Request " + index + ": Illegal number of burst: " + params.numberBurst);
            return false;
        }
        if (params.numSamplesPerBurst <= 0 || params.numSamplesPerBurst > 31) {
            Log.e("RttManager", "Request " + index + ": Illegal sample number per burst: " + params.numSamplesPerBurst);
            return false;
        }
        if (params.numRetriesPerMeasurementFrame < 0 || params.numRetriesPerMeasurementFrame > 3) {
            Log.e("RttManager", "Request " + index + ": Illegal measurement frame retry number:" + params.numRetriesPerMeasurementFrame);
            return false;
        }
        if (params.numRetriesPerFTMR < 0 || params.numRetriesPerFTMR > 3) {
            Log.e("RttManager", "Request " + index + ": Illegal FTMR frame retry number:" + params.numRetriesPerFTMR);
            return false;
        }
        if (params.LCIRequest && !this.mRttCapabilities.lciSupported) {
            Log.e("RttManager", "Request " + index + ": LCI is not supported");
            return false;
        }
        if (params.LCRRequest && !this.mRttCapabilities.lcrSupported) {
            Log.e("RttManager", "Request " + index + ": LCR is not supported");
            return false;
        }
        if (params.burstTimeout < 1 || params.burstTimeout > 11 && params.burstTimeout != 15) {
            Log.e("RttManager", "Request " + index + ": Illegal burst timeout: " + params.burstTimeout);
            return false;
        }
        if ((params.preamble & this.mRttCapabilities.preambleSupported) == 0) {
            Log.e("RttManager", "Request " + index + ": Do not support this preamble: " + params.preamble);
            return false;
        }
        if ((params.bandwidth & this.mRttCapabilities.bwSupported) == 0) {
            Log.e("RttManager", "Request " + index + ": Do not support this bandwidth: " + params.bandwidth);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_net_wifi_RttManager$startRanging(RttParams[] params, RttListener listener) {
        int index = 0;
        for (RttParams rttParam : params) {
            if (!this.rttParamSanity(rttParam, index)) {
                throw new IllegalArgumentException("RTT Request Parameter Illegal");
            }
            ++index;
        }
        this.validateChannel();
        ParcelableRttParams parcelableParams = new ParcelableRttParams(params);
        Log.i("RttManager", "Send RTT request to RTT Service");
        this.mAsyncChannel.sendMessage(160256, 0, this.putListener(listener), parcelableParams);
    }

    private final void $$robo$$android_net_wifi_RttManager$stopRanging(RttListener listener) {
        this.validateChannel();
        this.mAsyncChannel.sendMessage(160257, 0, this.removeListener(listener));
    }

    private final void $$robo$$android_net_wifi_RttManager$enableResponder(ResponderCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.validateChannel();
        int key = this.putListenerIfAbsent(callback);
        this.mAsyncChannel.sendMessage(160261, 0, key);
    }

    private final void $$robo$$android_net_wifi_RttManager$disableResponder(ResponderCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.validateChannel();
        int key = this.removeListener(callback);
        if (key == 0) {
            Log.e("RttManager", "responder not enabled yet");
            return;
        }
        this.mAsyncChannel.sendMessage(160262, 0, key);
    }

    private void $$robo$$android_net_wifi_RttManager$__constructor__(Context context, IRttManager service, Looper looper) {
        this.mListenerMap = new SparseArray();
        this.mListenerMapLock = new Object();
        this.mCapabilitiesLock = new Object();
        this.mListenerKey = 1;
        this.mContext = context;
        this.mService = service;
        Messenger messenger = null;
        int[] key = new int[1];
        try {
            Log.d("RttManager", "Get the messenger from " + this.mService);
            messenger = this.mService.getMessenger(new Binder(), key);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (messenger == null) {
            throw new IllegalStateException("getMessenger() returned null!  This is invalid.");
        }
        this.mAsyncChannel = new AsyncChannel();
        ServiceHandler handler = new ServiceHandler(this, looper);
        this.mAsyncChannel.connectSync(this.mContext, (Handler)handler, messenger);
        this.mAsyncChannel.sendMessage(69633, new RttClient(context.getPackageName()));
        this.mAsyncChannel.sendMessage(160265, key[0]);
    }

    private final void $$robo$$android_net_wifi_RttManager$validateChannel() {
        if (this.mAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_wifi_RttManager$putListener(Object listener) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            do {
                ++this.mListenerKey;
            } while (key == 0);
            this.mListenerMap.put(key, listener);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_wifi_RttManager$putListenerIfAbsent(Object listener) {
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            int key = this.getListenerKey(listener);
            if (key != 0) {
                return key;
            }
            do {
                ++this.mListenerKey;
            } while (key == 0);
            this.mListenerMap.put(key, listener);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object $$robo$$android_net_wifi_RttManager$getListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            Object listener = this.mListenerMap.get(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_wifi_RttManager$getListenerKey(Object listener) {
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            int index = this.mListenerMap.indexOfValue(listener);
            if (index == -1) {
                return 0;
            }
            return this.mListenerMap.keyAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object $$robo$$android_net_wifi_RttManager$removeListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            Object listener = this.mListenerMap.get(key);
            this.mListenerMap.remove(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_wifi_RttManager$removeListener(Object listener) {
        int key = this.getListenerKey(listener);
        if (key == 0) {
            return key;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            this.mListenerMap.remove(key);
            return key;
        }
    }

    @Deprecated
    public Capabilities getCapabilities() {
        return InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_net_wifi_RttManager$getCapabilities(), 0, this);
    }

    public RttCapabilities getRttCapabilities() {
        return InvokeDynamicSupport.bootstrap("getRttCapabilities", $$robo$$android_net_wifi_RttManager$getRttCapabilities(), 0, this);
    }

    private boolean rttParamSanity(RttParams rttParams, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("rttParamSanity", $$robo$$android_net_wifi_RttManager$rttParamSanity(android.net.wifi.RttManager$RttParams int ), 0, this, rttParams, n);
    }

    public void startRanging(RttParams[] rttParamsArray, RttListener rttListener) {
        InvokeDynamicSupport.bootstrap("startRanging", $$robo$$android_net_wifi_RttManager$startRanging(android.net.wifi.RttManager$RttParams[] android.net.wifi.RttManager$RttListener ), 0, this, rttParamsArray, rttListener);
    }

    public void stopRanging(RttListener rttListener) {
        InvokeDynamicSupport.bootstrap("stopRanging", $$robo$$android_net_wifi_RttManager$stopRanging(android.net.wifi.RttManager$RttListener ), 0, this, rttListener);
    }

    public void enableResponder(ResponderCallback responderCallback) {
        InvokeDynamicSupport.bootstrap("enableResponder", $$robo$$android_net_wifi_RttManager$enableResponder(android.net.wifi.RttManager$ResponderCallback ), 0, this, responderCallback);
    }

    public void disableResponder(ResponderCallback responderCallback) {
        InvokeDynamicSupport.bootstrap("disableResponder", $$robo$$android_net_wifi_RttManager$disableResponder(android.net.wifi.RttManager$ResponderCallback ), 0, this, responderCallback);
    }

    private void __constructor__(Context context, IRttManager iRttManager, Looper looper) {
        this.$$robo$$android_net_wifi_RttManager$__constructor__(context, iRttManager, looper);
    }

    public RttManager(Context context, IRttManager iRttManager, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager$__constructor__(android.content.Context android.net.wifi.IRttManager android.os.Looper ), 0, this, context, iRttManager, looper);
    }

    private void validateChannel() {
        InvokeDynamicSupport.bootstrap("validateChannel", $$robo$$android_net_wifi_RttManager$validateChannel(), 0, this);
    }

    private int putListener(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("putListener", $$robo$$android_net_wifi_RttManager$putListener(java.lang.Object ), 0, this, object);
    }

    private int putListenerIfAbsent(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("putListenerIfAbsent", $$robo$$android_net_wifi_RttManager$putListenerIfAbsent(java.lang.Object ), 0, this, object);
    }

    private Object getListener(int n) {
        return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_net_wifi_RttManager$getListener(int ), 0, this, n);
    }

    private int getListenerKey(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getListenerKey", $$robo$$android_net_wifi_RttManager$getListenerKey(java.lang.Object ), 0, this, object);
    }

    private Object removeListener(int n) {
        return InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_net_wifi_RttManager$removeListener(int ), 0, this, n);
    }

    private int removeListener(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_net_wifi_RttManager$removeListener(java.lang.Object ), 0, this, object);
    }

    public /* synthetic */ RttManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ServiceHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RttManager this$0;

        private void $$robo$$android_net_wifi_RttManager_ServiceHandler$__constructor__(RttManager rttManager, Looper looper) {
        }

        private final void $$robo$$android_net_wifi_RttManager_ServiceHandler$handleMessage(Message msg) {
            Log.i("RttManager", "RTT manager get message: " + msg.what);
            switch (msg.what) {
                case 69634: {
                    return;
                }
                case 69636: {
                    Log.e("RttManager", "Channel connection lost");
                    this.this$0.mAsyncChannel = null;
                    this.getLooper().quit();
                    return;
                }
            }
            Object listener = this.this$0.getListener(msg.arg2);
            if (listener == null) {
                Log.e("RttManager", "invalid listener key = " + msg.arg2);
                return;
            }
            Log.i("RttManager", "listener key = " + msg.arg2);
            switch (msg.what) {
                case 160259: {
                    this.reportSuccess(listener, msg);
                    this.this$0.removeListener(msg.arg2);
                    break;
                }
                case 160258: {
                    this.reportFailure(listener, msg);
                    this.this$0.removeListener(msg.arg2);
                    break;
                }
                case 160260: {
                    ((RttListener)listener).onAborted();
                    this.this$0.removeListener(msg.arg2);
                    break;
                }
                case 160263: {
                    ResponderConfig config = (ResponderConfig)msg.obj;
                    ((ResponderCallback)listener).onResponderEnabled(config);
                    break;
                }
                case 160264: {
                    ((ResponderCallback)listener).onResponderEnableFailure(msg.arg1);
                    this.this$0.removeListener(msg.arg2);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private final void $$robo$$android_net_wifi_RttManager_ServiceHandler$reportSuccess(Object listener, Message msg) {
            RttListener rttListener = (RttListener)listener;
            ParcelableRttResults parcelableResults = (ParcelableRttResults)msg.obj;
            ((RttListener)listener).onSuccess(parcelableResults.mResults);
        }

        private final void $$robo$$android_net_wifi_RttManager_ServiceHandler$reportFailure(Object listener, Message msg) {
            RttListener rttListener = (RttListener)listener;
            Bundle bundle = (Bundle)msg.obj;
            ((RttListener)listener).onFailure(msg.arg1, bundle.getString("android.net.wifi.RttManager.Description"));
        }

        private void __constructor__(RttManager rttManager, Looper looper) {
            this.$$robo$$android_net_wifi_RttManager_ServiceHandler$__constructor__(rttManager, looper);
        }

        ServiceHandler(RttManager rttManager, Looper looper) {
            this.this$0 = rttManager;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ServiceHandler$__constructor__(android.net.wifi.RttManager android.os.Looper ), 0, this, rttManager, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_RttManager_ServiceHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        void reportSuccess(Object object, Message message) {
            InvokeDynamicSupport.bootstrap("reportSuccess", $$robo$$android_net_wifi_RttManager_ServiceHandler$reportSuccess(java.lang.Object android.os.Message ), 0, this, object, message);
        }

        void reportFailure(Object object, Message message) {
            InvokeDynamicSupport.bootstrap("reportFailure", $$robo$$android_net_wifi_RttManager_ServiceHandler$reportFailure(java.lang.Object android.os.Message ), 0, this, object, message);
        }

        public /* synthetic */ ServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ResponderConfig
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String macAddress;
        public int frequency;
        public int centerFreq0;
        public int centerFreq1;
        public int channelWidth;
        public int preamble;
        public static Parcelable.Creator<ResponderConfig> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_ResponderConfig$__constructor__() {
            this.macAddress = "";
        }

        private final String $$robo$$android_net_wifi_RttManager_ResponderConfig$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("macAddress = ").append(this.macAddress).append(" frequency = ").append(this.frequency).append(" centerFreq0 = ").append(this.centerFreq0).append(" centerFreq1 = ").append(this.centerFreq1).append(" channelWidth = ").append(this.channelWidth).append(" preamble = ").append(this.preamble);
            return builder.toString();
        }

        private final int $$robo$$android_net_wifi_RttManager_ResponderConfig$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_ResponderConfig$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.macAddress);
            dest.writeInt(this.frequency);
            dest.writeInt(this.centerFreq0);
            dest.writeInt(this.centerFreq1);
            dest.writeInt(this.channelWidth);
            dest.writeInt(this.preamble);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ResponderConfig>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_ResponderConfig_1$__constructor__() {
                }

                private final ResponderConfig $$robo$$android_net_wifi_RttManager_ResponderConfig_1$createFromParcel(Parcel in) {
                    ResponderConfig config = new ResponderConfig();
                    config.macAddress = in.readString();
                    config.frequency = in.readInt();
                    config.centerFreq0 = in.readInt();
                    config.centerFreq1 = in.readInt();
                    config.channelWidth = in.readInt();
                    config.preamble = in.readInt();
                    return config;
                }

                private final ResponderConfig[] $$robo$$android_net_wifi_RttManager_ResponderConfig_1$newArray(int size) {
                    return new ResponderConfig[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_ResponderConfig_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ResponderConfig_1$__constructor__(), 0, this);
                }

                @Override
                public ResponderConfig createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_ResponderConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ResponderConfig[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_ResponderConfig_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_ResponderConfig$__constructor__();
        }

        public ResponderConfig() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ResponderConfig$__constructor__(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_RttManager_ResponderConfig$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_ResponderConfig$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_ResponderConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ResponderConfig.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResponderConfig)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ResponderCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_wifi_RttManager_ResponderCallback$__constructor__() {
        }

        public abstract void onResponderEnabled(ResponderConfig var1);

        public abstract void onResponderEnableFailure(int var1);

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_ResponderCallback$__constructor__();
        }

        public ResponderCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ResponderCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResponderCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RttClient
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mPackageName;
        public static Parcelable.Creator<RttClient> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_RttClient$__constructor__(String packageName) {
            this.mPackageName = packageName;
        }

        private void $$robo$$android_net_wifi_RttManager_RttClient$__constructor__(Parcel in) {
            this.mPackageName = in.readString();
        }

        private final int $$robo$$android_net_wifi_RttManager_RttClient$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_RttClient$writeToParcel(Parcel parcel, int i) {
            parcel.writeString(this.mPackageName);
        }

        private final String $$robo$$android_net_wifi_RttManager_RttClient$getPackageName() {
            return this.mPackageName;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RttClient>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_RttClient_1$__constructor__() {
                }

                private final RttClient $$robo$$android_net_wifi_RttManager_RttClient_1$createFromParcel(Parcel in) {
                    return new RttClient(in);
                }

                private final RttClient[] $$robo$$android_net_wifi_RttManager_RttClient_1$newArray(int size) {
                    return new RttClient[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_RttClient_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttClient_1$__constructor__(), 0, this);
                }

                @Override
                public RttClient createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_RttClient_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public RttClient[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_RttClient_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_net_wifi_RttManager_RttClient$__constructor__(string2);
        }

        public RttClient(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttClient$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_net_wifi_RttManager_RttClient$__constructor__(parcel);
        }

        protected RttClient(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttClient$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_RttClient$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_RttClient$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String getPackageName() {
            return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_net_wifi_RttManager_RttClient$getPackageName(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(RttClient.class);
        }

        public /* synthetic */ RttClient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttClient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface RttListener
    extends InstrumentedInterface {
        public void onSuccess(RttResult[] var1);

        public void onFailure(int var1, String var2);

        public void onAborted();
    }

    public static class ParcelableRttResults
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public RttResult[] mResults;
        public static Parcelable.Creator<ParcelableRttResults> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_ParcelableRttResults$__constructor__(RttResult[] results) {
            this.mResults = results;
        }

        private final String $$robo$$android_net_wifi_RttManager_ParcelableRttResults$toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.mResults.length; ++i) {
                sb.append("[" + i + "]: ");
                sb.append("bssid=" + this.mResults[i].bssid);
                sb.append(", burstNumber=" + this.mResults[i].burstNumber);
                sb.append(", measurementFrameNumber=" + this.mResults[i].measurementFrameNumber);
                sb.append(", successMeasurementFrameNumber=" + this.mResults[i].successMeasurementFrameNumber);
                sb.append(", frameNumberPerBurstPeer=" + this.mResults[i].frameNumberPerBurstPeer);
                sb.append(", status=" + this.mResults[i].status);
                sb.append(", requestType=" + this.mResults[i].requestType);
                sb.append(", measurementType=" + this.mResults[i].measurementType);
                sb.append(", retryAfterDuration=" + this.mResults[i].retryAfterDuration);
                sb.append(", ts=" + this.mResults[i].ts);
                sb.append(", rssi=" + this.mResults[i].rssi);
                sb.append(", rssi_spread=" + this.mResults[i].rssi_spread);
                sb.append(", rssiSpread=" + this.mResults[i].rssiSpread);
                sb.append(", tx_rate=" + this.mResults[i].tx_rate);
                sb.append(", txRate=" + this.mResults[i].txRate);
                sb.append(", rxRate=" + this.mResults[i].rxRate);
                sb.append(", rtt_ns=" + this.mResults[i].rtt_ns);
                sb.append(", rtt=" + this.mResults[i].rtt);
                sb.append(", rtt_sd_ns=" + this.mResults[i].rtt_sd_ns);
                sb.append(", rttStandardDeviation=" + this.mResults[i].rttStandardDeviation);
                sb.append(", rtt_spread_ns=" + this.mResults[i].rtt_spread_ns);
                sb.append(", rttSpread=" + this.mResults[i].rttSpread);
                sb.append(", distance_cm=" + this.mResults[i].distance_cm);
                sb.append(", distance=" + this.mResults[i].distance);
                sb.append(", distance_sd_cm=" + this.mResults[i].distance_sd_cm);
                sb.append(", distanceStandardDeviation=" + this.mResults[i].distanceStandardDeviation);
                sb.append(", distance_spread_cm=" + this.mResults[i].distance_spread_cm);
                sb.append(", distanceSpread=" + this.mResults[i].distanceSpread);
                sb.append(", burstDuration=" + this.mResults[i].burstDuration);
                sb.append(", negotiatedBurstNum=" + this.mResults[i].negotiatedBurstNum);
                sb.append(", LCI=" + this.mResults[i].LCI);
                sb.append(", LCR=" + this.mResults[i].LCR);
                sb.append(", secure=" + this.mResults[i].secure);
            }
            return sb.toString();
        }

        private final int $$robo$$android_net_wifi_RttManager_ParcelableRttResults$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_ParcelableRttResults$writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (RttResult result : this.mResults) {
                    dest.writeString(result.bssid);
                    dest.writeInt(result.burstNumber);
                    dest.writeInt(result.measurementFrameNumber);
                    dest.writeInt(result.successMeasurementFrameNumber);
                    dest.writeInt(result.frameNumberPerBurstPeer);
                    dest.writeInt(result.status);
                    dest.writeInt(result.measurementType);
                    dest.writeInt(result.retryAfterDuration);
                    dest.writeLong(result.ts);
                    dest.writeInt(result.rssi);
                    dest.writeInt(result.rssiSpread);
                    dest.writeInt(result.txRate);
                    dest.writeLong(result.rtt);
                    dest.writeLong(result.rttStandardDeviation);
                    dest.writeLong(result.rttSpread);
                    dest.writeInt(result.distance);
                    dest.writeInt(result.distanceStandardDeviation);
                    dest.writeInt(result.distanceSpread);
                    dest.writeInt(result.burstDuration);
                    dest.writeInt(result.negotiatedBurstNum);
                    dest.writeByte(result.LCI.id);
                    if (result.LCI.id != -1) {
                        dest.writeByte((byte)result.LCI.data.length);
                        dest.writeByteArray(result.LCI.data);
                    }
                    dest.writeByte(result.LCR.id);
                    if (result.LCR.id != -1) {
                        dest.writeByte((byte)result.LCR.data.length);
                        dest.writeByteArray(result.LCR.data);
                    }
                    dest.writeByte(result.secure ? (byte)1 : 0);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableRttResults>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$__constructor__() {
                }

                private final ParcelableRttResults $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$createFromParcel(Parcel in) {
                    int num = in.readInt();
                    if (num == 0) {
                        return new ParcelableRttResults(null);
                    }
                    RttResult[] results = new RttResult[num];
                    for (int i = 0; i < num; ++i) {
                        byte length;
                        results[i] = new RttResult();
                        results[i].bssid = in.readString();
                        results[i].burstNumber = in.readInt();
                        results[i].measurementFrameNumber = in.readInt();
                        results[i].successMeasurementFrameNumber = in.readInt();
                        results[i].frameNumberPerBurstPeer = in.readInt();
                        results[i].status = in.readInt();
                        results[i].measurementType = in.readInt();
                        results[i].retryAfterDuration = in.readInt();
                        results[i].ts = in.readLong();
                        results[i].rssi = in.readInt();
                        results[i].rssiSpread = in.readInt();
                        results[i].txRate = in.readInt();
                        results[i].rtt = in.readLong();
                        results[i].rttStandardDeviation = in.readLong();
                        results[i].rttSpread = in.readLong();
                        results[i].distance = in.readInt();
                        results[i].distanceStandardDeviation = in.readInt();
                        results[i].distanceSpread = in.readInt();
                        results[i].burstDuration = in.readInt();
                        results[i].negotiatedBurstNum = in.readInt();
                        results[i].LCI = new WifiInformationElement();
                        results[i].LCI.id = in.readByte();
                        if (results[i].LCI.id != -1) {
                            length = in.readByte();
                            results[i].LCI.data = new byte[length];
                            in.readByteArray(results[i].LCI.data);
                        }
                        results[i].LCR = new WifiInformationElement();
                        results[i].LCR.id = in.readByte();
                        if (results[i].LCR.id != -1) {
                            length = in.readByte();
                            results[i].LCR.data = new byte[length];
                            in.readByteArray(results[i].LCR.data);
                        }
                        results[i].secure = in.readByte() != 0;
                    }
                    ParcelableRttResults parcelableResults = new ParcelableRttResults(results);
                    return parcelableResults;
                }

                private final ParcelableRttResults[] $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$newArray(int size) {
                    return new ParcelableRttResults[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$__constructor__(), 0, this);
                }

                @Override
                public ParcelableRttResults createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ParcelableRttResults[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(RttResult[] rttResultArray) {
            this.$$robo$$android_net_wifi_RttManager_ParcelableRttResults$__constructor__(rttResultArray);
        }

        public ParcelableRttResults(RttResult[] rttResultArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$__constructor__(android.net.wifi.RttManager$RttResult[] ), 0, this, rttResultArray);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableRttResults.class);
        }

        public /* synthetic */ ParcelableRttResults() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableRttResults)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RttResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String bssid;
        public int burstNumber;
        public int measurementFrameNumber;
        public int successMeasurementFrameNumber;
        public int frameNumberPerBurstPeer;
        public int status;
        @Deprecated
        public int requestType;
        public int measurementType;
        public int retryAfterDuration;
        public long ts;
        public int rssi;
        @Deprecated
        public int rssi_spread;
        public int rssiSpread;
        @Deprecated
        public int tx_rate;
        public int txRate;
        public int rxRate;
        @Deprecated
        public long rtt_ns;
        public long rtt;
        @Deprecated
        public long rtt_sd_ns;
        public long rttStandardDeviation;
        @Deprecated
        public long rtt_spread_ns;
        public long rttSpread;
        @Deprecated
        public int distance_cm;
        public int distance;
        @Deprecated
        public int distance_sd_cm;
        public int distanceStandardDeviation;
        @Deprecated
        public int distance_spread_cm;
        public int distanceSpread;
        public int burstDuration;
        public int negotiatedBurstNum;
        public WifiInformationElement LCI;
        public WifiInformationElement LCR;
        public boolean secure;

        private void $$robo$$android_net_wifi_RttManager_RttResult$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_RttResult$__constructor__();
        }

        public RttResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttResult$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class WifiInformationElement
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public byte id;
        public byte[] data;

        private void $$robo$$android_net_wifi_RttManager_WifiInformationElement$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_WifiInformationElement$__constructor__();
        }

        public WifiInformationElement() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_WifiInformationElement$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiInformationElement)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParcelableRttParams
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public RttParams[] mParams;
        public static Parcelable.Creator<ParcelableRttParams> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_ParcelableRttParams$__constructor__(RttParams[] params) {
            this.mParams = params == null ? new RttParams[]{} : params;
        }

        private final int $$robo$$android_net_wifi_RttManager_ParcelableRttParams$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_ParcelableRttParams$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mParams.length);
            for (RttParams params : this.mParams) {
                dest.writeInt(params.deviceType);
                dest.writeInt(params.requestType);
                dest.writeByte(params.secure ? (byte)1 : 0);
                dest.writeString(params.bssid);
                dest.writeInt(params.channelWidth);
                dest.writeInt(params.frequency);
                dest.writeInt(params.centerFreq0);
                dest.writeInt(params.centerFreq1);
                dest.writeInt(params.numberBurst);
                dest.writeInt(params.interval);
                dest.writeInt(params.numSamplesPerBurst);
                dest.writeInt(params.numRetriesPerMeasurementFrame);
                dest.writeInt(params.numRetriesPerFTMR);
                dest.writeInt(params.LCIRequest ? 1 : 0);
                dest.writeInt(params.LCRRequest ? 1 : 0);
                dest.writeInt(params.burstTimeout);
                dest.writeInt(params.preamble);
                dest.writeInt(params.bandwidth);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableRttParams>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$__constructor__() {
                }

                private final ParcelableRttParams $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$createFromParcel(Parcel in) {
                    int num = in.readInt();
                    RttParams[] params = new RttParams[num];
                    for (int i = 0; i < num; ++i) {
                        params[i] = new RttParams();
                        params[i].deviceType = in.readInt();
                        params[i].requestType = in.readInt();
                        params[i].secure = in.readByte() != 0;
                        params[i].bssid = in.readString();
                        params[i].channelWidth = in.readInt();
                        params[i].frequency = in.readInt();
                        params[i].centerFreq0 = in.readInt();
                        params[i].centerFreq1 = in.readInt();
                        params[i].numberBurst = in.readInt();
                        params[i].interval = in.readInt();
                        params[i].numSamplesPerBurst = in.readInt();
                        params[i].numRetriesPerMeasurementFrame = in.readInt();
                        params[i].numRetriesPerFTMR = in.readInt();
                        params[i].LCIRequest = in.readInt() == 1;
                        params[i].LCRRequest = in.readInt() == 1;
                        params[i].burstTimeout = in.readInt();
                        params[i].preamble = in.readInt();
                        params[i].bandwidth = in.readInt();
                    }
                    ParcelableRttParams parcelableParams = new ParcelableRttParams(params);
                    return parcelableParams;
                }

                private final ParcelableRttParams[] $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$newArray(int size) {
                    return new ParcelableRttParams[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$__constructor__(), 0, this);
                }

                @Override
                public ParcelableRttParams createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ParcelableRttParams[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(RttParams[] rttParamsArray) {
            this.$$robo$$android_net_wifi_RttManager_ParcelableRttParams$__constructor__(rttParamsArray);
        }

        public ParcelableRttParams(RttParams[] rttParamsArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttParams$__constructor__(android.net.wifi.RttManager$RttParams[] ), 0, this, rttParamsArray);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_ParcelableRttParams$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttParams$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableRttParams.class);
        }

        public /* synthetic */ ParcelableRttParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableRttParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RttParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int deviceType;
        public int requestType;
        public boolean secure;
        public String bssid;
        public int frequency;
        public int channelWidth;
        public int centerFreq0;
        public int centerFreq1;
        @Deprecated
        public int num_samples;
        @Deprecated
        public int num_retries;
        public int numberBurst;
        public int interval;
        public int numSamplesPerBurst;
        public int numRetriesPerMeasurementFrame;
        public int numRetriesPerFTMR;
        public boolean LCIRequest;
        public boolean LCRRequest;
        public int burstTimeout;
        public int preamble;
        public int bandwidth;

        private void $$robo$$android_net_wifi_RttManager_RttParams$__constructor__() {
            this.deviceType = 1;
            this.requestType = 1;
            this.numberBurst = 0;
            this.numSamplesPerBurst = 8;
            this.numRetriesPerMeasurementFrame = 0;
            this.numRetriesPerFTMR = 0;
            this.burstTimeout = 15;
            this.preamble = 2;
            this.bandwidth = 4;
        }

        private final String $$robo$$android_net_wifi_RttManager_RttParams$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("deviceType=" + this.deviceType);
            sb.append(", requestType=" + this.requestType);
            sb.append(", secure=" + this.secure);
            sb.append(", bssid=" + this.bssid);
            sb.append(", frequency=" + this.frequency);
            sb.append(", channelWidth=" + this.channelWidth);
            sb.append(", centerFreq0=" + this.centerFreq0);
            sb.append(", centerFreq1=" + this.centerFreq1);
            sb.append(", num_samples=" + this.num_samples);
            sb.append(", num_retries=" + this.num_retries);
            sb.append(", numberBurst=" + this.numberBurst);
            sb.append(", interval=" + this.interval);
            sb.append(", numSamplesPerBurst=" + this.numSamplesPerBurst);
            sb.append(", numRetriesPerMeasurementFrame=" + this.numRetriesPerMeasurementFrame);
            sb.append(", numRetriesPerFTMR=" + this.numRetriesPerFTMR);
            sb.append(", LCIRequest=" + this.LCIRequest);
            sb.append(", LCRRequest=" + this.LCRRequest);
            sb.append(", burstTimeout=" + this.burstTimeout);
            sb.append(", preamble=" + this.preamble);
            sb.append(", bandwidth=" + this.bandwidth);
            return sb.toString();
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_RttParams$__constructor__();
        }

        public RttParams() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttParams$__constructor__(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_RttManager_RttParams$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RttCapabilities
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        @Deprecated
        public boolean supportedType;
        @Deprecated
        public boolean supportedPeerType;
        public boolean oneSidedRttSupported;
        public boolean twoSided11McRttSupported;
        public boolean lciSupported;
        public boolean lcrSupported;
        public int preambleSupported;
        public int bwSupported;
        public boolean responderSupported;
        public boolean secureRttSupported;
        public int mcVersion;
        public static Parcelable.Creator<RttCapabilities> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_RttCapabilities$__constructor__() {
        }

        private final String $$robo$$android_net_wifi_RttManager_RttCapabilities$toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("oneSidedRtt ").append(this.oneSidedRttSupported ? "is Supported. " : "is not supported. ").append("twoSided11McRtt ").append(this.twoSided11McRttSupported ? "is Supported. " : "is not supported. ").append("lci ").append(this.lciSupported ? "is Supported. " : "is not supported. ").append("lcr ").append(this.lcrSupported ? "is Supported. " : "is not supported. ");
            if ((this.preambleSupported & 1) != 0) {
                sb.append("Legacy ");
            }
            if ((this.preambleSupported & 2) != 0) {
                sb.append("HT ");
            }
            if ((this.preambleSupported & 4) != 0) {
                sb.append("VHT ");
            }
            sb.append("is supported. ");
            if ((this.bwSupported & 1) != 0) {
                sb.append("5 MHz ");
            }
            if ((this.bwSupported & 2) != 0) {
                sb.append("10 MHz ");
            }
            if ((this.bwSupported & 4) != 0) {
                sb.append("20 MHz ");
            }
            if ((this.bwSupported & 8) != 0) {
                sb.append("40 MHz ");
            }
            if ((this.bwSupported & 0x10) != 0) {
                sb.append("80 MHz ");
            }
            if ((this.bwSupported & 0x20) != 0) {
                sb.append("160 MHz ");
            }
            sb.append("is supported.");
            sb.append(" STA responder role is ").append(this.responderSupported ? "supported" : "not supported");
            sb.append(" Secure RTT protocol is ").append(this.secureRttSupported ? "supported" : "not supported");
            sb.append(" 11mc version is " + this.mcVersion);
            return sb.toString();
        }

        private final int $$robo$$android_net_wifi_RttManager_RttCapabilities$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_RttCapabilities$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.oneSidedRttSupported ? 1 : 0);
            dest.writeInt(this.twoSided11McRttSupported ? 1 : 0);
            dest.writeInt(this.lciSupported ? 1 : 0);
            dest.writeInt(this.lcrSupported ? 1 : 0);
            dest.writeInt(this.preambleSupported);
            dest.writeInt(this.bwSupported);
            dest.writeInt(this.responderSupported ? 1 : 0);
            dest.writeInt(this.secureRttSupported ? 1 : 0);
            dest.writeInt(this.mcVersion);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RttCapabilities>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_RttCapabilities_1$__constructor__() {
                }

                private final RttCapabilities $$robo$$android_net_wifi_RttManager_RttCapabilities_1$createFromParcel(Parcel in) {
                    RttCapabilities capabilities = new RttCapabilities();
                    capabilities.oneSidedRttSupported = in.readInt() == 1;
                    capabilities.twoSided11McRttSupported = in.readInt() == 1;
                    capabilities.lciSupported = in.readInt() == 1;
                    capabilities.lcrSupported = in.readInt() == 1;
                    capabilities.preambleSupported = in.readInt();
                    capabilities.bwSupported = in.readInt();
                    capabilities.responderSupported = in.readInt() == 1;
                    capabilities.secureRttSupported = in.readInt() == 1;
                    capabilities.mcVersion = in.readInt();
                    return capabilities;
                }

                private final RttCapabilities[] $$robo$$android_net_wifi_RttManager_RttCapabilities_1$newArray(int size) {
                    return new RttCapabilities[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_RttCapabilities_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttCapabilities_1$__constructor__(), 0, this);
                }

                @Override
                public RttCapabilities createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_RttCapabilities_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public RttCapabilities[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_RttCapabilities_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_RttCapabilities$__constructor__();
        }

        public RttCapabilities() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttCapabilities$__constructor__(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_RttManager_RttCapabilities$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_RttCapabilities$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_RttCapabilities$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(RttCapabilities.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttCapabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public class Capabilities
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int supportedType;
        public int supportedPeerType;
        /* synthetic */ RttManager this$0;

        private void $$robo$$android_net_wifi_RttManager_Capabilities$__constructor__(RttManager this$0) {
        }

        private void __constructor__(RttManager rttManager) {
            this.$$robo$$android_net_wifi_RttManager_Capabilities$__constructor__(rttManager);
        }

        public Capabilities(RttManager rttManager) {
            this.this$0 = rttManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_Capabilities$__constructor__(android.net.wifi.RttManager ), 0, this, rttManager);
        }

        public /* synthetic */ Capabilities() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Capabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

