/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ConfigRequest
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int CLUSTER_ID_MIN = 0;
    public static int CLUSTER_ID_MAX = 65535;
    public static int NAN_BAND_24GHZ = 0;
    public static int NAN_BAND_5GHZ = 1;
    public static int DW_INTERVAL_NOT_INIT = -1;
    public static int DW_DISABLE = 0;
    public boolean mSupport5gBand;
    public int mMasterPreference;
    public int mClusterLow;
    public int mClusterHigh;
    public int[] mDiscoveryWindowInterval;
    public static Parcelable.Creator<ConfigRequest> CREATOR;

    private void $$robo$$android_net_wifi_aware_ConfigRequest$__constructor__(boolean support5gBand, int masterPreference, int clusterLow, int clusterHigh, int[] discoveryWindowInterval) {
        this.mSupport5gBand = support5gBand;
        this.mMasterPreference = masterPreference;
        this.mClusterLow = clusterLow;
        this.mClusterHigh = clusterHigh;
        this.mDiscoveryWindowInterval = discoveryWindowInterval;
    }

    private final String $$robo$$android_net_wifi_aware_ConfigRequest$toString() {
        return "ConfigRequest [mSupport5gBand=" + this.mSupport5gBand + ", mMasterPreference=" + this.mMasterPreference + ", mClusterLow=" + this.mClusterLow + ", mClusterHigh=" + this.mClusterHigh + ", mDiscoveryWindowInterval=" + Arrays.toString(this.mDiscoveryWindowInterval) + "]";
    }

    private final int $$robo$$android_net_wifi_aware_ConfigRequest$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_aware_ConfigRequest$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSupport5gBand ? 1 : 0);
        dest.writeInt(this.mMasterPreference);
        dest.writeInt(this.mClusterLow);
        dest.writeInt(this.mClusterHigh);
        dest.writeIntArray(this.mDiscoveryWindowInterval);
    }

    private final boolean $$robo$$android_net_wifi_aware_ConfigRequest$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigRequest)) {
            return false;
        }
        ConfigRequest lhs = (ConfigRequest)o;
        return this.mSupport5gBand == lhs.mSupport5gBand && this.mMasterPreference == lhs.mMasterPreference && this.mClusterLow == lhs.mClusterLow && this.mClusterHigh == lhs.mClusterHigh && Arrays.equals(this.mDiscoveryWindowInterval, lhs.mDiscoveryWindowInterval);
    }

    private final int $$robo$$android_net_wifi_aware_ConfigRequest$hashCode() {
        int result = 17;
        result = 31 * result + (this.mSupport5gBand ? 1 : 0);
        result = 31 * result + this.mMasterPreference;
        result = 31 * result + this.mClusterLow;
        result = 31 * result + this.mClusterHigh;
        result = 31 * result + Arrays.hashCode(this.mDiscoveryWindowInterval);
        return result;
    }

    private final void $$robo$$android_net_wifi_aware_ConfigRequest$validate() throws IllegalArgumentException {
        if (this.mMasterPreference < 0) {
            throw new IllegalArgumentException("Master Preference specification must be non-negative");
        }
        if (this.mMasterPreference == 1 || this.mMasterPreference == 255 || this.mMasterPreference > 255) {
            throw new IllegalArgumentException("Master Preference specification must not exceed 255 or use 1 or 255 (reserved values)");
        }
        if (this.mClusterLow < 0) {
            throw new IllegalArgumentException("Cluster specification must be non-negative");
        }
        if (this.mClusterLow > 65535) {
            throw new IllegalArgumentException("Cluster specification must not exceed 0xFFFF");
        }
        if (this.mClusterHigh < 0) {
            throw new IllegalArgumentException("Cluster specification must be non-negative");
        }
        if (this.mClusterHigh > 65535) {
            throw new IllegalArgumentException("Cluster specification must not exceed 0xFFFF");
        }
        if (this.mClusterLow > this.mClusterHigh) {
            throw new IllegalArgumentException("Invalid argument combination - must have Cluster Low <= Cluster High");
        }
        if (this.mDiscoveryWindowInterval.length != 2) {
            throw new IllegalArgumentException("Invalid discovery window interval: must have 2 elements (2.4 & 5");
        }
        if (this.mDiscoveryWindowInterval[0] != -1 && (this.mDiscoveryWindowInterval[0] < 1 || this.mDiscoveryWindowInterval[0] > 5)) {
            throw new IllegalArgumentException("Invalid discovery window interval for 2.4GHz: valid is UNSET or [1,5]");
        }
        if (this.mDiscoveryWindowInterval[1] != -1 && (this.mDiscoveryWindowInterval[1] < 0 || this.mDiscoveryWindowInterval[1] > 5)) {
            throw new IllegalArgumentException("Invalid discovery window interval for 5GHz: valid is UNSET or [0,5]");
        }
    }

    private /* synthetic */ void $$robo$$android_net_wifi_aware_ConfigRequest$__constructor__(boolean x0, int x1, int x2, int x3, int[] x4, 1 x5) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ConfigRequest>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_aware_ConfigRequest_1$__constructor__() {
            }

            private final ConfigRequest[] $$robo$$android_net_wifi_aware_ConfigRequest_1$newArray(int size) {
                return new ConfigRequest[size];
            }

            private final ConfigRequest $$robo$$android_net_wifi_aware_ConfigRequest_1$createFromParcel(Parcel in) {
                boolean support5gBand = in.readInt() != 0;
                int masterPreference = in.readInt();
                int clusterLow = in.readInt();
                int clusterHigh = in.readInt();
                int[] discoveryWindowInterval = in.createIntArray();
                return new ConfigRequest(support5gBand, masterPreference, clusterLow, clusterHigh, discoveryWindowInterval);
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_aware_ConfigRequest_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_ConfigRequest_1$__constructor__(), 0, this);
            }

            public ConfigRequest[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_aware_ConfigRequest_1$newArray(int ), 0, this, n);
            }

            @Override
            public ConfigRequest createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_aware_ConfigRequest_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(boolean bl, int n, int n2, int n3, int[] nArray) {
        this.$$robo$$android_net_wifi_aware_ConfigRequest$__constructor__(bl, n, n2, n3, nArray);
    }

    private ConfigRequest(boolean bl, int n, int n2, int n3, int[] nArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_ConfigRequest$__constructor__(boolean int int int int[] ), 0, this, bl, n, n2, n3, nArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_aware_ConfigRequest$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_aware_ConfigRequest$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_aware_ConfigRequest$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_aware_ConfigRequest$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_aware_ConfigRequest$hashCode(), 0, this);
    }

    public void validate() throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$android_net_wifi_aware_ConfigRequest$validate(), 0, this);
    }

    private /* synthetic */ void __constructor__(boolean bl, int n, int n2, int n3, int[] nArray, 1 var6_6) {
        this.$$robo$$android_net_wifi_aware_ConfigRequest$__constructor__(bl, n, n2, n3, nArray, var6_6);
    }

    static {
        RobolectricInternals.classInitializing(ConfigRequest.class);
    }

    public /* synthetic */ ConfigRequest() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfigRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mSupport5gBand;
        private int mMasterPreference;
        private int mClusterLow;
        private int mClusterHigh;
        private int[] mDiscoveryWindowInterval;

        private void $$robo$$android_net_wifi_aware_ConfigRequest_Builder$__constructor__() {
            this.mSupport5gBand = false;
            this.mMasterPreference = 0;
            this.mClusterLow = 0;
            this.mClusterHigh = 65535;
            this.mDiscoveryWindowInterval = new int[]{-1, -1};
        }

        private final Builder $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setSupport5gBand(boolean support5gBand) {
            this.mSupport5gBand = support5gBand;
            return this;
        }

        private final Builder $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setMasterPreference(int masterPreference) {
            if (masterPreference < 0) {
                throw new IllegalArgumentException("Master Preference specification must be non-negative");
            }
            if (masterPreference == 1 || masterPreference == 255 || masterPreference > 255) {
                throw new IllegalArgumentException("Master Preference specification must not exceed 255 or use 1 or 255 (reserved values)");
            }
            this.mMasterPreference = masterPreference;
            return this;
        }

        private final Builder $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setClusterLow(int clusterLow) {
            if (clusterLow < 0) {
                throw new IllegalArgumentException("Cluster specification must be non-negative");
            }
            if (clusterLow > 65535) {
                throw new IllegalArgumentException("Cluster specification must not exceed 0xFFFF");
            }
            this.mClusterLow = clusterLow;
            return this;
        }

        private final Builder $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setClusterHigh(int clusterHigh) {
            if (clusterHigh < 0) {
                throw new IllegalArgumentException("Cluster specification must be non-negative");
            }
            if (clusterHigh > 65535) {
                throw new IllegalArgumentException("Cluster specification must not exceed 0xFFFF");
            }
            this.mClusterHigh = clusterHigh;
            return this;
        }

        private final Builder $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setDiscoveryWindowInterval(int band, int interval) {
            if (band != 0 && band != 1) {
                throw new IllegalArgumentException("Invalid band value");
            }
            if (band == 0 && (interval < 1 || interval > 5) || band == 1 && (interval < 0 || interval > 5)) {
                throw new IllegalArgumentException("Invalid interval value: 2.4 GHz [1,5] or 5GHz [0,5]");
            }
            this.mDiscoveryWindowInterval[band] = interval;
            return this;
        }

        private final ConfigRequest $$robo$$android_net_wifi_aware_ConfigRequest_Builder$build() {
            if (this.mClusterLow > this.mClusterHigh) {
                throw new IllegalArgumentException("Invalid argument combination - must have Cluster Low <= Cluster High");
            }
            return new ConfigRequest(this.mSupport5gBand, this.mMasterPreference, this.mClusterLow, this.mClusterHigh, this.mDiscoveryWindowInterval);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_aware_ConfigRequest_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_ConfigRequest_Builder$__constructor__(), 0, this);
        }

        public Builder setSupport5gBand(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setSupport5gBand", $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setSupport5gBand(boolean ), 0, this, bl);
        }

        public Builder setMasterPreference(int n) {
            return InvokeDynamicSupport.bootstrap("setMasterPreference", $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setMasterPreference(int ), 0, this, n);
        }

        public Builder setClusterLow(int n) {
            return InvokeDynamicSupport.bootstrap("setClusterLow", $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setClusterLow(int ), 0, this, n);
        }

        public Builder setClusterHigh(int n) {
            return InvokeDynamicSupport.bootstrap("setClusterHigh", $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setClusterHigh(int ), 0, this, n);
        }

        public Builder setDiscoveryWindowInterval(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("setDiscoveryWindowInterval", $$robo$$android_net_wifi_aware_ConfigRequest_Builder$setDiscoveryWindowInterval(int int ), 0, this, n, n2);
        }

        public ConfigRequest build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_net_wifi_aware_ConfigRequest_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

