/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.content.Context;
import android.net.NetworkSpecifier;
import android.net.wifi.RttManager;
import android.net.wifi.aware.AttachCallback;
import android.net.wifi.aware.Characteristics;
import android.net.wifi.aware.ConfigRequest;
import android.net.wifi.aware.DiscoverySession;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.IWifiAwareDiscoverySessionCallback;
import android.net.wifi.aware.IWifiAwareEventCallback;
import android.net.wifi.aware.IWifiAwareManager;
import android.net.wifi.aware.IdentityChangedListener;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.PublishDiscoverySession;
import android.net.wifi.aware.SubscribeConfig;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.TlvBufferUtils;
import android.net.wifi.aware.WifiAwareNetworkSpecifier;
import android.net.wifi.aware.WifiAwareSession;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.util.List;
import libcore.util.HexEncoding;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiAwareManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiAwareManager";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    public static String ACTION_WIFI_AWARE_STATE_CHANGED = "android.net.wifi.aware.action.WIFI_AWARE_STATE_CHANGED";
    public static int WIFI_AWARE_DATA_PATH_ROLE_INITIATOR = 0;
    public static int WIFI_AWARE_DATA_PATH_ROLE_RESPONDER = 1;
    private Context mContext;
    private IWifiAwareManager mService;
    private Object mLock;
    @GuardedBy(value="mLock")
    private SparseArray<RttManager.RttListener> mRangingListeners;

    private void $$robo$$android_net_wifi_aware_WifiAwareManager$__constructor__(Context context, IWifiAwareManager service) {
        this.mLock = new Object();
        this.mRangingListeners = new SparseArray();
        this.mContext = context;
        this.mService = service;
    }

    private final boolean $$robo$$android_net_wifi_aware_WifiAwareManager$isAvailable() {
        try {
            return this.mService.isUsageEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Characteristics $$robo$$android_net_wifi_aware_WifiAwareManager$getCharacteristics() {
        try {
            return this.mService.getCharacteristics();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$attach(AttachCallback attachCallback, Handler handler) {
        this.attach(handler, null, attachCallback, null);
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$attach(AttachCallback attachCallback, IdentityChangedListener identityChangedListener, Handler handler) {
        this.attach(handler, null, attachCallback, identityChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$attach(Handler handler, ConfigRequest configRequest, AttachCallback attachCallback, IdentityChangedListener identityChangedListener) {
        Object object = this.mLock;
        synchronized (object) {
            Looper looper = handler == null ? Looper.getMainLooper() : handler.getLooper();
            try {
                Binder binder = new Binder();
                this.mService.connect(binder, this.mContext.getOpPackageName(), new WifiAwareEventCallbackProxy(this, looper, binder, attachCallback, identityChangedListener), configRequest, identityChangedListener != null);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$disconnect(int clientId, Binder binder) {
        try {
            this.mService.disconnect(clientId, binder);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$publish(int clientId, Looper looper, PublishConfig publishConfig, DiscoverySessionCallback callback) {
        try {
            this.mService.publish(clientId, publishConfig, new WifiAwareDiscoverySessionCallbackProxy(this, looper, true, callback, clientId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$updatePublish(int clientId, int sessionId, PublishConfig publishConfig) {
        try {
            this.mService.updatePublish(clientId, sessionId, publishConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$subscribe(int clientId, Looper looper, SubscribeConfig subscribeConfig, DiscoverySessionCallback callback) {
        try {
            this.mService.subscribe(clientId, subscribeConfig, new WifiAwareDiscoverySessionCallbackProxy(this, looper, false, callback, clientId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$updateSubscribe(int clientId, int sessionId, SubscribeConfig subscribeConfig) {
        try {
            this.mService.updateSubscribe(clientId, sessionId, subscribeConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$terminateSession(int clientId, int sessionId) {
        try {
            this.mService.terminateSession(clientId, sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$sendMessage(int clientId, int sessionId, PeerHandle peerHandle, byte[] message, int messageId, int retryCount) {
        if (peerHandle == null) {
            throw new IllegalArgumentException("sendMessage: invalid peerHandle - must be non-null");
        }
        try {
            this.mService.sendMessage(clientId, sessionId, peerHandle.peerId, message, messageId, retryCount);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_aware_WifiAwareManager$startRanging(int clientId, int sessionId, RttManager.RttParams[] params, RttManager.RttListener listener) {
        int rangingKey = 0;
        try {
            rangingKey = this.mService.startRanging(clientId, sessionId, new RttManager.ParcelableRttParams(params));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mRangingListeners.put(rangingKey, listener);
        }
    }

    private final NetworkSpecifier $$robo$$android_net_wifi_aware_WifiAwareManager$createNetworkSpecifier(int clientId, int role, int sessionId, PeerHandle peerHandle, byte[] pmk, String passphrase) {
        if (role != 0 && role != 1) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid 'role' argument when creating a network specifier");
        }
        if (role == 0 && peerHandle == null) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid peer handle (value of null) - not permitted on INITIATOR");
        }
        return new WifiAwareNetworkSpecifier(peerHandle == null ? 1 : 0, role, clientId, sessionId, peerHandle != null ? peerHandle.peerId : 0, null, pmk, passphrase, Process.myUid());
    }

    private final NetworkSpecifier $$robo$$android_net_wifi_aware_WifiAwareManager$createNetworkSpecifier(int clientId, int role, byte[] peer, byte[] pmk, String passphrase) {
        if (role != 0 && role != 1) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid 'role' argument when creating a network specifier");
        }
        if (role == 0 && peer == null) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid peer MAC address - null not permitted on INITIATOR");
        }
        if (peer != null && peer.length != 6) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid peer MAC address");
        }
        return new WifiAwareNetworkSpecifier(peer == null ? 3 : 2, role, clientId, 0, 0, peer, pmk, passphrase, Process.myUid());
    }

    private void __constructor__(Context context, IWifiAwareManager iWifiAwareManager) {
        this.$$robo$$android_net_wifi_aware_WifiAwareManager$__constructor__(context, iWifiAwareManager);
    }

    public WifiAwareManager(Context context, IWifiAwareManager iWifiAwareManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_WifiAwareManager$__constructor__(android.content.Context android.net.wifi.aware.IWifiAwareManager ), 0, this, context, iWifiAwareManager);
    }

    public boolean isAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAvailable", $$robo$$android_net_wifi_aware_WifiAwareManager$isAvailable(), 0, this);
    }

    public Characteristics getCharacteristics() {
        return InvokeDynamicSupport.bootstrap("getCharacteristics", $$robo$$android_net_wifi_aware_WifiAwareManager$getCharacteristics(), 0, this);
    }

    public void attach(AttachCallback attachCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$android_net_wifi_aware_WifiAwareManager$attach(android.net.wifi.aware.AttachCallback android.os.Handler ), 0, this, attachCallback, handler);
    }

    public void attach(AttachCallback attachCallback, IdentityChangedListener identityChangedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$android_net_wifi_aware_WifiAwareManager$attach(android.net.wifi.aware.AttachCallback android.net.wifi.aware.IdentityChangedListener android.os.Handler ), 0, this, attachCallback, identityChangedListener, handler);
    }

    public void attach(Handler handler, ConfigRequest configRequest, AttachCallback attachCallback, IdentityChangedListener identityChangedListener) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$android_net_wifi_aware_WifiAwareManager$attach(android.os.Handler android.net.wifi.aware.ConfigRequest android.net.wifi.aware.AttachCallback android.net.wifi.aware.IdentityChangedListener ), 0, this, handler, configRequest, attachCallback, identityChangedListener);
    }

    public void disconnect(int n, Binder binder) {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_net_wifi_aware_WifiAwareManager$disconnect(int android.os.Binder ), 0, this, n, binder);
    }

    public void publish(int n, Looper looper, PublishConfig publishConfig, DiscoverySessionCallback discoverySessionCallback) {
        InvokeDynamicSupport.bootstrap("publish", $$robo$$android_net_wifi_aware_WifiAwareManager$publish(int android.os.Looper android.net.wifi.aware.PublishConfig android.net.wifi.aware.DiscoverySessionCallback ), 0, this, n, looper, publishConfig, discoverySessionCallback);
    }

    public void updatePublish(int n, int n2, PublishConfig publishConfig) {
        InvokeDynamicSupport.bootstrap("updatePublish", $$robo$$android_net_wifi_aware_WifiAwareManager$updatePublish(int int android.net.wifi.aware.PublishConfig ), 0, this, n, n2, publishConfig);
    }

    public void subscribe(int n, Looper looper, SubscribeConfig subscribeConfig, DiscoverySessionCallback discoverySessionCallback) {
        InvokeDynamicSupport.bootstrap("subscribe", $$robo$$android_net_wifi_aware_WifiAwareManager$subscribe(int android.os.Looper android.net.wifi.aware.SubscribeConfig android.net.wifi.aware.DiscoverySessionCallback ), 0, this, n, looper, subscribeConfig, discoverySessionCallback);
    }

    public void updateSubscribe(int n, int n2, SubscribeConfig subscribeConfig) {
        InvokeDynamicSupport.bootstrap("updateSubscribe", $$robo$$android_net_wifi_aware_WifiAwareManager$updateSubscribe(int int android.net.wifi.aware.SubscribeConfig ), 0, this, n, n2, subscribeConfig);
    }

    public void terminateSession(int n, int n2) {
        InvokeDynamicSupport.bootstrap("terminateSession", $$robo$$android_net_wifi_aware_WifiAwareManager$terminateSession(int int ), 0, this, n, n2);
    }

    public void sendMessage(int n, int n2, PeerHandle peerHandle, byte[] byArray, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_net_wifi_aware_WifiAwareManager$sendMessage(int int android.net.wifi.aware.PeerHandle byte[] int int ), 0, this, n, n2, peerHandle, byArray, n3, n4);
    }

    public void startRanging(int n, int n2, RttManager.RttParams[] rttParamsArray, RttManager.RttListener rttListener) {
        InvokeDynamicSupport.bootstrap("startRanging", $$robo$$android_net_wifi_aware_WifiAwareManager$startRanging(int int android.net.wifi.RttManager$RttParams[] android.net.wifi.RttManager$RttListener ), 0, this, n, n2, rttParamsArray, rttListener);
    }

    public NetworkSpecifier createNetworkSpecifier(int n, int n2, int n3, PeerHandle peerHandle, byte[] byArray, String string2) {
        return InvokeDynamicSupport.bootstrap("createNetworkSpecifier", $$robo$$android_net_wifi_aware_WifiAwareManager$createNetworkSpecifier(int int int android.net.wifi.aware.PeerHandle byte[] java.lang.String ), 0, this, n, n2, n3, peerHandle, byArray, string2);
    }

    public NetworkSpecifier createNetworkSpecifier(int n, int n2, byte[] byArray, byte[] byArray2, String string2) {
        return InvokeDynamicSupport.bootstrap("createNetworkSpecifier", $$robo$$android_net_wifi_aware_WifiAwareManager$createNetworkSpecifier(int int byte[] byte[] java.lang.String ), 0, this, n, n2, byArray, byArray2, string2);
    }

    public /* synthetic */ WifiAwareManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiAwareManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class WifiAwareDiscoverySessionCallbackProxy
    extends IWifiAwareDiscoverySessionCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int CALLBACK_SESSION_STARTED = 0;
        private static int CALLBACK_SESSION_CONFIG_SUCCESS = 1;
        private static int CALLBACK_SESSION_CONFIG_FAIL = 2;
        private static int CALLBACK_SESSION_TERMINATED = 3;
        private static int CALLBACK_MATCH = 4;
        private static int CALLBACK_MESSAGE_SEND_SUCCESS = 5;
        private static int CALLBACK_MESSAGE_SEND_FAIL = 6;
        private static int CALLBACK_MESSAGE_RECEIVED = 7;
        private static String MESSAGE_BUNDLE_KEY_MESSAGE = "message";
        private static String MESSAGE_BUNDLE_KEY_MESSAGE2 = "message2";
        private WeakReference<WifiAwareManager> mAwareManager;
        private boolean mIsPublish;
        private DiscoverySessionCallback mOriginalCallback;
        private int mClientId;
        private Handler mHandler;
        private DiscoverySession mSession;

        private void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$__constructor__(WifiAwareManager mgr, Looper looper, boolean isPublish, DiscoverySessionCallback originalCallback, int clientId) {
            this.mAwareManager = new WeakReference<WifiAwareManager>(mgr);
            this.mIsPublish = isPublish;
            this.mOriginalCallback = originalCallback;
            this.mClientId = clientId;
            this.mHandler = new ShadowedObject(this, looper){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ WifiAwareDiscoverySessionCallbackProxy this$0;

                private void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy_1$__constructor__(WifiAwareDiscoverySessionCallbackProxy this$0, Looper looper) {
                }

                private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy_1$handleMessage(Message msg) {
                    if (this.this$0.mAwareManager.get() == null) {
                        Log.w("WifiAwareManager", "WifiAwareDiscoverySessionCallbackProxy: handleMessage post GC");
                        return;
                    }
                    switch (msg.what) {
                        case 0: {
                            this.this$0.onProxySessionStarted(msg.arg1);
                            break;
                        }
                        case 1: {
                            this.this$0.mOriginalCallback.onSessionConfigUpdated();
                            break;
                        }
                        case 2: {
                            this.this$0.mOriginalCallback.onSessionConfigFailed();
                            if (this.this$0.mSession != null) break;
                            this.this$0.mAwareManager.clear();
                            break;
                        }
                        case 3: {
                            this.this$0.onProxySessionTerminated(msg.arg1);
                            break;
                        }
                        case 4: {
                            List<byte[]> matchFilter = null;
                            byte[] arg = msg.getData().getByteArray("message2");
                            try {
                                matchFilter = new TlvBufferUtils.TlvIterable(0, 1, arg).toList();
                            }
                            catch (BufferOverflowException e) {
                                matchFilter = null;
                                Log.e("WifiAwareManager", "onServiceDiscovered: invalid match filter byte array '" + new String(HexEncoding.encode(arg)) + "' - cannot be parsed: e=" + e);
                            }
                            this.this$0.mOriginalCallback.onServiceDiscovered(new PeerHandle(msg.arg1), msg.getData().getByteArray("message"), matchFilter);
                            break;
                        }
                        case 5: {
                            this.this$0.mOriginalCallback.onMessageSendSucceeded(msg.arg1);
                            break;
                        }
                        case 6: {
                            this.this$0.mOriginalCallback.onMessageSendFailed(msg.arg1);
                            break;
                        }
                        case 7: {
                            this.this$0.mOriginalCallback.onMessageReceived(new PeerHandle(msg.arg1), (byte[])msg.obj);
                        }
                    }
                }

                private void __constructor__(WifiAwareDiscoverySessionCallbackProxy wifiAwareDiscoverySessionCallbackProxy, Looper looper) {
                    this.$$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy_1$__constructor__(wifiAwareDiscoverySessionCallbackProxy, looper);
                }
                {
                    this.this$0 = wifiAwareDiscoverySessionCallbackProxy;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy_1$__constructor__(android.net.wifi.aware.WifiAwareManager$WifiAwareDiscoverySessionCallbackProxy android.os.Looper ), 0, this, wifiAwareDiscoverySessionCallbackProxy, looper);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onSessionStarted(int sessionId) {
            Message msg = this.mHandler.obtainMessage(0);
            msg.arg1 = sessionId;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onSessionConfigSuccess() {
            Message msg = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onSessionConfigFail(int reason) {
            Message msg = this.mHandler.obtainMessage(2);
            msg.arg1 = reason;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onSessionTerminated(int reason) {
            Message msg = this.mHandler.obtainMessage(3);
            msg.arg1 = reason;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onMatch(int peerId, byte[] serviceSpecificInfo, byte[] matchFilter) {
            Bundle data = new Bundle();
            data.putByteArray("message", serviceSpecificInfo);
            data.putByteArray("message2", matchFilter);
            Message msg = this.mHandler.obtainMessage(4);
            msg.arg1 = peerId;
            msg.setData(data);
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onMessageSendSuccess(int messageId) {
            Message msg = this.mHandler.obtainMessage(5);
            msg.arg1 = messageId;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onMessageSendFail(int messageId, int reason) {
            Message msg = this.mHandler.obtainMessage(6);
            msg.arg1 = messageId;
            msg.arg2 = reason;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onMessageReceived(int peerId, byte[] message) {
            Message msg = this.mHandler.obtainMessage(7);
            msg.arg1 = peerId;
            msg.obj = message;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onProxySessionStarted(int sessionId) {
            if (this.mSession != null) {
                Log.e("WifiAwareManager", "onSessionStarted: sessionId=" + sessionId + ": session already created!?");
                throw new IllegalStateException("onSessionStarted: sessionId=" + sessionId + ": session already created!?");
            }
            WifiAwareManager mgr = (WifiAwareManager)this.mAwareManager.get();
            if (mgr == null) {
                Log.w("WifiAwareManager", "onProxySessionStarted: mgr GC'd");
                return;
            }
            if (this.mIsPublish) {
                PublishDiscoverySession session = new PublishDiscoverySession(mgr, this.mClientId, sessionId);
                this.mSession = session;
                this.mOriginalCallback.onPublishStarted(session);
            } else {
                SubscribeDiscoverySession session = new SubscribeDiscoverySession(mgr, this.mClientId, sessionId);
                this.mSession = session;
                this.mOriginalCallback.onSubscribeStarted(session);
            }
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onProxySessionTerminated(int reason) {
            if (this.mSession != null) {
                this.mSession.setTerminated();
                this.mSession = null;
            } else {
                Log.w("WifiAwareManager", "Proxy: onSessionTerminated called but mSession is null!?");
            }
            this.mAwareManager.clear();
            this.mOriginalCallback.onSessionTerminated();
        }

        private void __constructor__(WifiAwareManager wifiAwareManager, Looper looper, boolean bl, DiscoverySessionCallback discoverySessionCallback, int n) {
            this.$$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$__constructor__(wifiAwareManager, looper, bl, discoverySessionCallback, n);
        }

        WifiAwareDiscoverySessionCallbackProxy(WifiAwareManager wifiAwareManager, Looper looper, boolean bl, DiscoverySessionCallback discoverySessionCallback, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$__constructor__(android.net.wifi.aware.WifiAwareManager android.os.Looper boolean android.net.wifi.aware.DiscoverySessionCallback int ), 0, this, wifiAwareManager, looper, bl, discoverySessionCallback, n);
        }

        @Override
        public void onSessionStarted(int n) {
            InvokeDynamicSupport.bootstrap("onSessionStarted", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onSessionStarted(int ), 0, this, n);
        }

        @Override
        public void onSessionConfigSuccess() {
            InvokeDynamicSupport.bootstrap("onSessionConfigSuccess", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onSessionConfigSuccess(), 0, this);
        }

        @Override
        public void onSessionConfigFail(int n) {
            InvokeDynamicSupport.bootstrap("onSessionConfigFail", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onSessionConfigFail(int ), 0, this, n);
        }

        @Override
        public void onSessionTerminated(int n) {
            InvokeDynamicSupport.bootstrap("onSessionTerminated", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onSessionTerminated(int ), 0, this, n);
        }

        @Override
        public void onMatch(int n, byte[] byArray, byte[] byArray2) {
            InvokeDynamicSupport.bootstrap("onMatch", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onMatch(int byte[] byte[] ), 0, this, n, byArray, byArray2);
        }

        @Override
        public void onMessageSendSuccess(int n) {
            InvokeDynamicSupport.bootstrap("onMessageSendSuccess", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onMessageSendSuccess(int ), 0, this, n);
        }

        @Override
        public void onMessageSendFail(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onMessageSendFail", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onMessageSendFail(int int ), 0, this, n, n2);
        }

        @Override
        public void onMessageReceived(int n, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onMessageReceived", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onMessageReceived(int byte[] ), 0, this, n, byArray);
        }

        public void onProxySessionStarted(int n) {
            InvokeDynamicSupport.bootstrap("onProxySessionStarted", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onProxySessionStarted(int ), 0, this, n);
        }

        public void onProxySessionTerminated(int n) {
            InvokeDynamicSupport.bootstrap("onProxySessionTerminated", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareDiscoverySessionCallbackProxy$onProxySessionTerminated(int ), 0, this, n);
        }

        public /* synthetic */ WifiAwareDiscoverySessionCallbackProxy() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiAwareDiscoverySessionCallbackProxy)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class WifiAwareEventCallbackProxy
    extends IWifiAwareEventCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int CALLBACK_CONNECT_SUCCESS = 0;
        private static int CALLBACK_CONNECT_FAIL = 1;
        private static int CALLBACK_IDENTITY_CHANGED = 2;
        private static int CALLBACK_RANGING_SUCCESS = 3;
        private static int CALLBACK_RANGING_FAILURE = 4;
        private static int CALLBACK_RANGING_ABORTED = 5;
        private Handler mHandler;
        private WeakReference<WifiAwareManager> mAwareManager;
        private Binder mBinder;
        private Looper mLooper;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final RttManager.RttListener $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$getAndRemoveRangingListener(int rangingId) {
            WifiAwareManager mgr = (WifiAwareManager)this.mAwareManager.get();
            if (mgr == null) {
                Log.w("WifiAwareManager", "getAndRemoveRangingListener: called post GC");
                return null;
            }
            Object object = mgr.mLock;
            synchronized (object) {
                RttManager.RttListener listener = (RttManager.RttListener)mgr.mRangingListeners.get(rangingId);
                mgr.mRangingListeners.delete(rangingId);
                return listener;
            }
        }

        private void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$__constructor__(WifiAwareManager mgr, Looper looper, Binder binder, AttachCallback attachCallback, IdentityChangedListener identityChangedListener) {
            this.mAwareManager = new WeakReference<WifiAwareManager>(mgr);
            this.mLooper = looper;
            this.mBinder = binder;
            this.mHandler = new ShadowedObject(this, looper, attachCallback, identityChangedListener){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AttachCallback val$attachCallback;
                /* synthetic */ IdentityChangedListener val$identityChangedListener;
                /* synthetic */ WifiAwareEventCallbackProxy this$0;

                private void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy_1$__constructor__(WifiAwareEventCallbackProxy this$0, Looper looper, AttachCallback attachCallback, IdentityChangedListener identityChangedListener) {
                }

                private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy_1$handleMessage(Message msg) {
                    WifiAwareManager mgr = (WifiAwareManager)this.this$0.mAwareManager.get();
                    if (mgr == null) {
                        Log.w("WifiAwareManager", "WifiAwareEventCallbackProxy: handleMessage post GC");
                        return;
                    }
                    switch (msg.what) {
                        case 0: {
                            this.val$attachCallback.onAttached(new WifiAwareSession(mgr, this.this$0.mBinder, msg.arg1));
                            break;
                        }
                        case 1: {
                            this.this$0.mAwareManager.clear();
                            this.val$attachCallback.onAttachFailed();
                            break;
                        }
                        case 2: {
                            if (this.val$identityChangedListener == null) {
                                Log.e("WifiAwareManager", "CALLBACK_IDENTITY_CHANGED: null listener.");
                                break;
                            }
                            this.val$identityChangedListener.onIdentityChanged((byte[])msg.obj);
                            break;
                        }
                        case 3: {
                            RttManager.RttListener listener = this.this$0.getAndRemoveRangingListener(msg.arg1);
                            if (listener == null) {
                                Log.e("WifiAwareManager", "CALLBACK_RANGING_SUCCESS rangingId=" + msg.arg1 + ": no listener registered (anymore)");
                                break;
                            }
                            listener.onSuccess(((RttManager.ParcelableRttResults)msg.obj).mResults);
                            break;
                        }
                        case 4: {
                            RttManager.RttListener listener = this.this$0.getAndRemoveRangingListener(msg.arg1);
                            if (listener == null) {
                                Log.e("WifiAwareManager", "CALLBACK_RANGING_SUCCESS rangingId=" + msg.arg1 + ": no listener registered (anymore)");
                                break;
                            }
                            listener.onFailure(msg.arg2, (String)msg.obj);
                            break;
                        }
                        case 5: {
                            RttManager.RttListener listener = this.this$0.getAndRemoveRangingListener(msg.arg1);
                            if (listener == null) {
                                Log.e("WifiAwareManager", "CALLBACK_RANGING_SUCCESS rangingId=" + msg.arg1 + ": no listener registered (anymore)");
                                break;
                            }
                            listener.onAborted();
                            break;
                        }
                    }
                }

                private void __constructor__(WifiAwareEventCallbackProxy wifiAwareEventCallbackProxy, Looper looper, AttachCallback attachCallback, IdentityChangedListener identityChangedListener) {
                    this.$$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy_1$__constructor__(wifiAwareEventCallbackProxy, looper, attachCallback, identityChangedListener);
                }
                {
                    this.this$0 = wifiAwareEventCallbackProxy;
                    this.val$attachCallback = attachCallback;
                    this.val$identityChangedListener = identityChangedListener;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy_1$__constructor__(android.net.wifi.aware.WifiAwareManager$WifiAwareEventCallbackProxy android.os.Looper android.net.wifi.aware.AttachCallback android.net.wifi.aware.IdentityChangedListener ), 0, this, wifiAwareEventCallbackProxy, looper, attachCallback, identityChangedListener);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onConnectSuccess(int clientId) {
            Message msg = this.mHandler.obtainMessage(0);
            msg.arg1 = clientId;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onConnectFail(int reason) {
            Message msg = this.mHandler.obtainMessage(1);
            msg.arg1 = reason;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onIdentityChanged(byte[] mac) {
            Message msg = this.mHandler.obtainMessage(2);
            msg.obj = mac;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onRangingSuccess(int rangingId, RttManager.ParcelableRttResults results) {
            Message msg = this.mHandler.obtainMessage(3);
            msg.arg1 = rangingId;
            msg.obj = results;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onRangingFailure(int rangingId, int reason, String description) {
            Message msg = this.mHandler.obtainMessage(4);
            msg.arg1 = rangingId;
            msg.arg2 = reason;
            msg.obj = description;
            this.mHandler.sendMessage(msg);
        }

        private final void $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onRangingAborted(int rangingId) {
            Message msg = this.mHandler.obtainMessage(5);
            msg.arg1 = rangingId;
            this.mHandler.sendMessage(msg);
        }

        RttManager.RttListener getAndRemoveRangingListener(int n) {
            return InvokeDynamicSupport.bootstrap("getAndRemoveRangingListener", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$getAndRemoveRangingListener(int ), 0, this, n);
        }

        private void __constructor__(WifiAwareManager wifiAwareManager, Looper looper, Binder binder, AttachCallback attachCallback, IdentityChangedListener identityChangedListener) {
            this.$$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$__constructor__(wifiAwareManager, looper, binder, attachCallback, identityChangedListener);
        }

        WifiAwareEventCallbackProxy(WifiAwareManager wifiAwareManager, Looper looper, Binder binder, AttachCallback attachCallback, IdentityChangedListener identityChangedListener) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$__constructor__(android.net.wifi.aware.WifiAwareManager android.os.Looper android.os.Binder android.net.wifi.aware.AttachCallback android.net.wifi.aware.IdentityChangedListener ), 0, this, wifiAwareManager, looper, binder, attachCallback, identityChangedListener);
        }

        @Override
        public void onConnectSuccess(int n) {
            InvokeDynamicSupport.bootstrap("onConnectSuccess", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onConnectSuccess(int ), 0, this, n);
        }

        @Override
        public void onConnectFail(int n) {
            InvokeDynamicSupport.bootstrap("onConnectFail", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onConnectFail(int ), 0, this, n);
        }

        @Override
        public void onIdentityChanged(byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onIdentityChanged", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onIdentityChanged(byte[] ), 0, this, byArray);
        }

        @Override
        public void onRangingSuccess(int n, RttManager.ParcelableRttResults parcelableRttResults) {
            InvokeDynamicSupport.bootstrap("onRangingSuccess", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onRangingSuccess(int android.net.wifi.RttManager$ParcelableRttResults ), 0, this, n, parcelableRttResults);
        }

        @Override
        public void onRangingFailure(int n, int n2, String string2) {
            InvokeDynamicSupport.bootstrap("onRangingFailure", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onRangingFailure(int int java.lang.String ), 0, this, n, n2, string2);
        }

        @Override
        public void onRangingAborted(int n) {
            InvokeDynamicSupport.bootstrap("onRangingAborted", $$robo$$android_net_wifi_aware_WifiAwareManager_WifiAwareEventCallbackProxy$onRangingAborted(int ), 0, this, n);
        }

        public /* synthetic */ WifiAwareEventCallbackProxy() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiAwareEventCallbackProxy)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataPathRole {
    }
}

