/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2;

import android.net.wifi.hotspot2.PasspointConfiguration;
import android.net.wifi.hotspot2.omadm.PpsMoParser;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ConfigParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ConfigParser";
    private static String CONTENT_TYPE = "Content-Type";
    private static String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static String TYPE_MULTIPART_MIXED = "multipart/mixed";
    private static String TYPE_WIFI_CONFIG = "application/x-wifi-config";
    private static String TYPE_PASSPOINT_PROFILE = "application/x-passpoint-profile";
    private static String TYPE_CA_CERT = "application/x-x509-ca-cert";
    private static String TYPE_PKCS12 = "application/x-pkcs12";
    private static String ENCODING_BASE64 = "base64";
    private static String BOUNDARY = "boundary=";

    private void $$robo$$android_net_wifi_hotspot2_ConfigParser$__constructor__() {
    }

    private static final PasspointConfiguration $$robo$$android_net_wifi_hotspot2_ConfigParser$parsePasspointConfig(String mimeType, byte[] data) {
        if (!TextUtils.equals(mimeType, "application/x-wifi-config")) {
            Log.e("ConfigParser", "Unexpected MIME type: " + mimeType);
            return null;
        }
        try {
            byte[] decodedData = Base64.decode(new String(data, StandardCharsets.ISO_8859_1), 0);
            Map<String, byte[]> mimeParts = ConfigParser.parseMimeMultipartMessage(new LineNumberReader(new InputStreamReader((InputStream)new ByteArrayInputStream(decodedData), StandardCharsets.ISO_8859_1)));
            return ConfigParser.createPasspointConfig(mimeParts);
        }
        catch (IOException | IllegalArgumentException e) {
            Log.e("ConfigParser", "Failed to parse installation file: " + e.getMessage());
            return null;
        }
    }

    private static final PasspointConfiguration $$robo$$android_net_wifi_hotspot2_ConfigParser$createPasspointConfig(Map<String, byte[]> mimeParts) throws IOException {
        byte[] pkcs12Data;
        byte[] profileData = mimeParts.get("application/x-passpoint-profile");
        if (profileData == null) {
            throw new IOException("Missing Passpoint Profile");
        }
        PasspointConfiguration config = PpsMoParser.parseMoText(new String(profileData));
        if (config == null) {
            throw new IOException("Failed to parse Passpoint profile");
        }
        if (config.getCredential() == null) {
            throw new IOException("Passpoint profile missing credential");
        }
        byte[] caCertData = mimeParts.get("application/x-x509-ca-cert");
        if (caCertData != null) {
            try {
                config.getCredential().setCaCertificate(ConfigParser.parseCACert(caCertData));
            }
            catch (CertificateException e) {
                throw new IOException("Failed to parse CA Certificate");
            }
        }
        if ((pkcs12Data = mimeParts.get("application/x-pkcs12")) != null) {
            try {
                Pair<PrivateKey, List<X509Certificate>> clientKey = ConfigParser.parsePkcs12(pkcs12Data);
                config.getCredential().setClientPrivateKey((PrivateKey)clientKey.first);
                config.getCredential().setClientCertificateChain(((List)clientKey.second).toArray(new X509Certificate[((List)clientKey.second).size()]));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IOException("Failed to parse PCKS12 string");
            }
        }
        return config;
    }

    private static final Map<String, byte[]> $$robo$$android_net_wifi_hotspot2_ConfigParser$parseMimeMultipartMessage(LineNumberReader in) throws IOException {
        MimePart mimePart;
        String line;
        MimeHeader header = ConfigParser.parseHeaders(in);
        if (!TextUtils.equals(header.contentType, "multipart/mixed")) {
            throw new IOException("Invalid content type: " + header.contentType);
        }
        if (TextUtils.isEmpty(header.boundary)) {
            throw new IOException("Missing boundary string");
        }
        if (!TextUtils.equals(header.encodingType, "base64")) {
            throw new IOException("Unexpected encoding: " + header.encodingType);
        }
        do {
            if ((line = in.readLine()) != null) continue;
            throw new IOException("Unexpected EOF before first boundary @ " + in.getLineNumber());
        } while (!line.equals("--" + header.boundary));
        HashMap<String, byte[]> mimeParts = new HashMap<String, byte[]>();
        boolean isLast = false;
        do {
            mimePart = ConfigParser.parseMimePart(in, header.boundary);
            mimeParts.put(mimePart.type, mimePart.data);
        } while (!(isLast = mimePart.isLast));
        return mimeParts;
    }

    private static final MimePart $$robo$$android_net_wifi_hotspot2_ConfigParser$parseMimePart(LineNumberReader in, String boundary) throws IOException {
        MimeHeader header = ConfigParser.parseHeaders(in);
        if (!TextUtils.equals(header.encodingType, "base64")) {
            throw new IOException("Unexpected encoding type: " + header.encodingType);
        }
        if (!(TextUtils.equals(header.contentType, "application/x-passpoint-profile") || TextUtils.equals(header.contentType, "application/x-x509-ca-cert") || TextUtils.equals(header.contentType, "application/x-pkcs12"))) {
            throw new IOException("Unexpected content type: " + header.contentType);
        }
        StringBuilder text = new StringBuilder();
        boolean isLast = false;
        String partBoundary = "--" + boundary;
        String endBoundary = partBoundary + "--";
        while (true) {
            String line;
            if ((line = in.readLine()) == null) {
                throw new IOException("Unexpected EOF file in body @ " + in.getLineNumber());
            }
            if (line.startsWith(partBoundary)) {
                if (!line.equals(endBoundary)) break;
                isLast = true;
                break;
            }
            text.append(line);
        }
        MimePart part = new MimePart();
        part.type = header.contentType;
        part.data = Base64.decode(text.toString(), 0);
        part.isLast = isLast;
        return part;
    }

    private static final MimeHeader $$robo$$android_net_wifi_hotspot2_ConfigParser$parseHeaders(LineNumberReader in) throws IOException {
        MimeHeader header = new MimeHeader();
        Map<String, String> headers = ConfigParser.readHeaders(in);
        block8: for (Map.Entry<String, String> entry : headers.entrySet()) {
            switch (entry.getKey()) {
                case "Content-Type": {
                    Pair<String, String> value = ConfigParser.parseContentType(entry.getValue());
                    header.contentType = (String)value.first;
                    header.boundary = (String)value.second;
                    continue block8;
                }
                case "Content-Transfer-Encoding": {
                    header.encodingType = entry.getValue();
                    continue block8;
                }
            }
            Log.d("ConfigParser", "Ignore header: " + entry.getKey());
        }
        return header;
    }

    private static final Pair<String, String> $$robo$$android_net_wifi_hotspot2_ConfigParser$parseContentType(String contentType) throws IOException {
        String[] attributes = contentType.split(";");
        String type = null;
        String boundary = null;
        if (attributes.length < 1) {
            throw new IOException("Invalid Content-Type: " + contentType);
        }
        type = attributes[0].trim();
        for (int i = 1; i < attributes.length; ++i) {
            String attribute = attributes[i].trim();
            if (!attribute.startsWith("boundary=")) {
                Log.d("ConfigParser", "Ignore Content-Type attribute: " + attributes[i]);
                continue;
            }
            boundary = attribute.substring("boundary=".length());
            if (boundary.length() <= 1 || !boundary.startsWith("\"") || !boundary.endsWith("\"")) continue;
            boundary = boundary.substring(1, boundary.length() - 1);
        }
        return new Pair<String, Object>(type, boundary);
    }

    private static final Map<String, String> $$robo$$android_net_wifi_hotspot2_ConfigParser$readHeaders(LineNumberReader in) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String name = null;
        StringBuilder value = null;
        while (true) {
            String line;
            if ((line = in.readLine()) == null) {
                throw new IOException("Missing line @ " + in.getLineNumber());
            }
            if (line.length() == 0 || line.trim().length() == 0) {
                if (name == null) break;
                headers.put(name, value.toString());
                break;
            }
            int nameEnd = line.indexOf(58);
            if (nameEnd < 0) {
                if (value != null) {
                    value.append(' ').append(line.trim());
                    continue;
                }
                throw new IOException("Bad header line: '" + line + "' @ " + in.getLineNumber());
            }
            if (Character.isWhitespace(line.charAt(0))) {
                throw new IOException("Illegal blank prefix in header line '" + line + "' @ " + in.getLineNumber());
            }
            if (name != null) {
                headers.put(name, value.toString());
            }
            name = line.substring(0, nameEnd).trim();
            value = new StringBuilder();
            value.append(line.substring(nameEnd + 1).trim());
        }
        return headers;
    }

    private static final X509Certificate $$robo$$android_net_wifi_hotspot2_ConfigParser$parseCACert(byte[] octets) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(octets));
    }

    private static final Pair<PrivateKey, List<X509Certificate>> $$robo$$android_net_wifi_hotspot2_ConfigParser$parsePkcs12(byte[] octets) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ByteArrayInputStream in = new ByteArrayInputStream(octets);
        ks.load(in, new char[0]);
        in.close();
        if (ks.size() != 1) {
            throw new IOException("Unexpected key size: " + ks.size());
        }
        String alias = ks.aliases().nextElement();
        if (alias == null) {
            throw new IOException("No alias found");
        }
        PrivateKey clientKey = (PrivateKey)ks.getKey(alias, null);
        ArrayList<X509Certificate> clientCertificateChain = null;
        Certificate[] chain = ks.getCertificateChain(alias);
        if (chain != null) {
            clientCertificateChain = new ArrayList<X509Certificate>();
            for (Certificate certificate : chain) {
                if (!(certificate instanceof X509Certificate)) {
                    throw new IOException("Unexpceted certificate type: " + certificate.getClass());
                }
                clientCertificateChain.add((X509Certificate)certificate);
            }
        }
        return new Pair<PrivateKey, List<X509Certificate>>(clientKey, clientCertificateChain);
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_hotspot2_ConfigParser$__constructor__();
    }

    public ConfigParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_ConfigParser$__constructor__(), 0, this);
    }

    public static PasspointConfiguration parsePasspointConfig(String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("parsePasspointConfig", $$robo$$android_net_wifi_hotspot2_ConfigParser$parsePasspointConfig(java.lang.String byte[] ), 0, (String)string2, (byte[])byArray);
    }

    private static PasspointConfiguration createPasspointConfig(Map<String, byte[]> map) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createPasspointConfig", $$robo$$android_net_wifi_hotspot2_ConfigParser$createPasspointConfig(java.util.Map<java.lang.String, byte[]> ), 0, map);
    }

    private static Map<String, byte[]> parseMimeMultipartMessage(LineNumberReader lineNumberReader) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("parseMimeMultipartMessage", $$robo$$android_net_wifi_hotspot2_ConfigParser$parseMimeMultipartMessage(java.io.LineNumberReader ), 0, (LineNumberReader)lineNumberReader);
    }

    private static MimePart parseMimePart(LineNumberReader lineNumberReader, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("parseMimePart", $$robo$$android_net_wifi_hotspot2_ConfigParser$parseMimePart(java.io.LineNumberReader java.lang.String ), 0, (LineNumberReader)lineNumberReader, (String)string2);
    }

    private static MimeHeader parseHeaders(LineNumberReader lineNumberReader) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("parseHeaders", $$robo$$android_net_wifi_hotspot2_ConfigParser$parseHeaders(java.io.LineNumberReader ), 0, (LineNumberReader)lineNumberReader);
    }

    private static Pair<String, String> parseContentType(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("parseContentType", $$robo$$android_net_wifi_hotspot2_ConfigParser$parseContentType(java.lang.String ), 0, (String)string2);
    }

    private static Map<String, String> readHeaders(LineNumberReader lineNumberReader) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readHeaders", $$robo$$android_net_wifi_hotspot2_ConfigParser$readHeaders(java.io.LineNumberReader ), 0, (LineNumberReader)lineNumberReader);
    }

    private static X509Certificate parseCACert(byte[] byArray) throws CertificateException {
        return InvokeDynamicSupport.bootstrapStatic("parseCACert", $$robo$$android_net_wifi_hotspot2_ConfigParser$parseCACert(byte[] ), 0, (byte[])byArray);
    }

    private static Pair<PrivateKey, List<X509Certificate>> parsePkcs12(byte[] byArray) throws GeneralSecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("parsePkcs12", $$robo$$android_net_wifi_hotspot2_ConfigParser$parsePkcs12(byte[] ), 0, (byte[])byArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfigParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class MimeHeader
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String contentType;
        public String boundary;
        public String encodingType;

        private void $$robo$$android_net_wifi_hotspot2_ConfigParser_MimeHeader$__constructor__() {
            this.contentType = null;
            this.boundary = null;
            this.encodingType = null;
        }

        private /* synthetic */ void $$robo$$android_net_wifi_hotspot2_ConfigParser_MimeHeader$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_hotspot2_ConfigParser_MimeHeader$__constructor__();
        }

        private MimeHeader() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_ConfigParser_MimeHeader$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_net_wifi_hotspot2_ConfigParser_MimeHeader$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MimeHeader)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class MimePart
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String type;
        public byte[] data;
        public boolean isLast;

        private void $$robo$$android_net_wifi_hotspot2_ConfigParser_MimePart$__constructor__() {
            this.type = null;
            this.data = null;
            this.isLast = false;
        }

        private /* synthetic */ void $$robo$$android_net_wifi_hotspot2_ConfigParser_MimePart$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_hotspot2_ConfigParser_MimePart$__constructor__();
        }

        private MimePart() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_ConfigParser_MimePart$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_net_wifi_hotspot2_ConfigParser_MimePart$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MimePart)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

