/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2.pps;

import android.net.wifi.ParcelUtil;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class Credential
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Credential";
    private static int MAX_REALM_BYTES = 253;
    private long mCreationTimeInMillis;
    private long mExpirationTimeInMillis;
    private String mRealm;
    private boolean mCheckAaaServerCertStatus;
    private UserCredential mUserCredential;
    private CertificateCredential mCertCredential;
    private SimCredential mSimCredential;
    private X509Certificate mCaCertificate;
    private X509Certificate[] mClientCertificateChain;
    private PrivateKey mClientPrivateKey;
    public static Parcelable.Creator<Credential> CREATOR;

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setCreationTimeInMillis(long creationTimeInMillis) {
        this.mCreationTimeInMillis = creationTimeInMillis;
    }

    private final long $$robo$$android_net_wifi_hotspot2_pps_Credential$getCreationTimeInMillis() {
        return this.mCreationTimeInMillis;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setExpirationTimeInMillis(long expirationTimeInMillis) {
        this.mExpirationTimeInMillis = expirationTimeInMillis;
    }

    private final long $$robo$$android_net_wifi_hotspot2_pps_Credential$getExpirationTimeInMillis() {
        return this.mExpirationTimeInMillis;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setRealm(String realm) {
        this.mRealm = realm;
    }

    private final String $$robo$$android_net_wifi_hotspot2_pps_Credential$getRealm() {
        return this.mRealm;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setCheckAaaServerCertStatus(boolean checkAaaServerCertStatus) {
        this.mCheckAaaServerCertStatus = checkAaaServerCertStatus;
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$getCheckAaaServerCertStatus() {
        return this.mCheckAaaServerCertStatus;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setUserCredential(UserCredential userCredential) {
        this.mUserCredential = userCredential;
    }

    private final UserCredential $$robo$$android_net_wifi_hotspot2_pps_Credential$getUserCredential() {
        return this.mUserCredential;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setCertCredential(CertificateCredential certCredential) {
        this.mCertCredential = certCredential;
    }

    private final CertificateCredential $$robo$$android_net_wifi_hotspot2_pps_Credential$getCertCredential() {
        return this.mCertCredential;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setSimCredential(SimCredential simCredential) {
        this.mSimCredential = simCredential;
    }

    private final SimCredential $$robo$$android_net_wifi_hotspot2_pps_Credential$getSimCredential() {
        return this.mSimCredential;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setCaCertificate(X509Certificate caCertificate) {
        this.mCaCertificate = caCertificate;
    }

    private final X509Certificate $$robo$$android_net_wifi_hotspot2_pps_Credential$getCaCertificate() {
        return this.mCaCertificate;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setClientCertificateChain(X509Certificate[] certificateChain) {
        this.mClientCertificateChain = certificateChain;
    }

    private final X509Certificate[] $$robo$$android_net_wifi_hotspot2_pps_Credential$getClientCertificateChain() {
        return this.mClientCertificateChain;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$setClientPrivateKey(PrivateKey clientPrivateKey) {
        this.mClientPrivateKey = clientPrivateKey;
    }

    private final PrivateKey $$robo$$android_net_wifi_hotspot2_pps_Credential$getClientPrivateKey() {
        return this.mClientPrivateKey;
    }

    private void $$robo$$android_net_wifi_hotspot2_pps_Credential$__constructor__() {
        this.mCreationTimeInMillis = Long.MIN_VALUE;
        this.mExpirationTimeInMillis = Long.MIN_VALUE;
        this.mRealm = null;
        this.mCheckAaaServerCertStatus = false;
        this.mUserCredential = null;
        this.mCertCredential = null;
        this.mSimCredential = null;
        this.mCaCertificate = null;
        this.mClientCertificateChain = null;
        this.mClientPrivateKey = null;
    }

    private void $$robo$$android_net_wifi_hotspot2_pps_Credential$__constructor__(Credential source) {
        this.mCreationTimeInMillis = Long.MIN_VALUE;
        this.mExpirationTimeInMillis = Long.MIN_VALUE;
        this.mRealm = null;
        this.mCheckAaaServerCertStatus = false;
        this.mUserCredential = null;
        this.mCertCredential = null;
        this.mSimCredential = null;
        this.mCaCertificate = null;
        this.mClientCertificateChain = null;
        this.mClientPrivateKey = null;
        if (source != null) {
            this.mCreationTimeInMillis = source.mCreationTimeInMillis;
            this.mExpirationTimeInMillis = source.mExpirationTimeInMillis;
            this.mRealm = source.mRealm;
            this.mCheckAaaServerCertStatus = source.mCheckAaaServerCertStatus;
            if (source.mUserCredential != null) {
                this.mUserCredential = new UserCredential(source.mUserCredential);
            }
            if (source.mCertCredential != null) {
                this.mCertCredential = new CertificateCredential(source.mCertCredential);
            }
            if (source.mSimCredential != null) {
                this.mSimCredential = new SimCredential(source.mSimCredential);
            }
            if (source.mClientCertificateChain != null) {
                this.mClientCertificateChain = Arrays.copyOf(source.mClientCertificateChain, source.mClientCertificateChain.length);
            }
            this.mCaCertificate = source.mCaCertificate;
            this.mClientPrivateKey = source.mClientPrivateKey;
        }
    }

    private final int $$robo$$android_net_wifi_hotspot2_pps_Credential$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_hotspot2_pps_Credential$writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mCreationTimeInMillis);
        dest.writeLong(this.mExpirationTimeInMillis);
        dest.writeString(this.mRealm);
        dest.writeInt(this.mCheckAaaServerCertStatus ? 1 : 0);
        dest.writeParcelable(this.mUserCredential, flags);
        dest.writeParcelable(this.mCertCredential, flags);
        dest.writeParcelable(this.mSimCredential, flags);
        ParcelUtil.writeCertificate(dest, this.mCaCertificate);
        ParcelUtil.writeCertificates(dest, this.mClientCertificateChain);
        ParcelUtil.writePrivateKey(dest, this.mClientPrivateKey);
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Credential)) {
            return false;
        }
        Credential that = (Credential)thatObject;
        return TextUtils.equals(this.mRealm, that.mRealm) && this.mCreationTimeInMillis == that.mCreationTimeInMillis && this.mExpirationTimeInMillis == that.mExpirationTimeInMillis && this.mCheckAaaServerCertStatus == that.mCheckAaaServerCertStatus && (this.mUserCredential == null ? that.mUserCredential == null : this.mUserCredential.equals(that.mUserCredential)) && (this.mCertCredential == null ? that.mCertCredential == null : this.mCertCredential.equals(that.mCertCredential)) && (this.mSimCredential == null ? that.mSimCredential == null : this.mSimCredential.equals(that.mSimCredential)) && Credential.isX509CertificateEquals(this.mCaCertificate, that.mCaCertificate) && Credential.isX509CertificatesEquals(this.mClientCertificateChain, that.mClientCertificateChain) && Credential.isPrivateKeyEquals(this.mClientPrivateKey, that.mClientPrivateKey);
    }

    private final int $$robo$$android_net_wifi_hotspot2_pps_Credential$hashCode() {
        return Objects.hash(this.mRealm, this.mCreationTimeInMillis, this.mExpirationTimeInMillis, this.mCheckAaaServerCertStatus, this.mUserCredential, this.mCertCredential, this.mSimCredential, this.mCaCertificate, this.mClientCertificateChain, this.mClientPrivateKey);
    }

    private final String $$robo$$android_net_wifi_hotspot2_pps_Credential$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Realm: ").append(this.mRealm).append("\n");
        builder.append("CreationTime: ").append(this.mCreationTimeInMillis != Long.MIN_VALUE ? new Date(this.mCreationTimeInMillis) : "Not specified").append("\n");
        builder.append("ExpirationTime: ").append(this.mExpirationTimeInMillis != Long.MIN_VALUE ? new Date(this.mExpirationTimeInMillis) : "Not specified").append("\n");
        builder.append("CheckAAAServerStatus: ").append(this.mCheckAaaServerCertStatus).append("\n");
        if (this.mUserCredential != null) {
            builder.append("UserCredential Begin ---\n");
            builder.append(this.mUserCredential);
            builder.append("UserCredential End ---\n");
        }
        if (this.mCertCredential != null) {
            builder.append("CertificateCredential Begin ---\n");
            builder.append(this.mCertCredential);
            builder.append("CertificateCredential End ---\n");
        }
        if (this.mSimCredential != null) {
            builder.append("SIMCredential Begin ---\n");
            builder.append(this.mSimCredential);
            builder.append("SIMCredential End ---\n");
        }
        return builder.toString();
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$validate() {
        if (TextUtils.isEmpty(this.mRealm)) {
            Log.d("Credential", "Missing realm");
            return false;
        }
        if (this.mRealm.getBytes(StandardCharsets.UTF_8).length > 253) {
            Log.d("Credential", "realm exceeding maximum length: " + this.mRealm.getBytes(StandardCharsets.UTF_8).length);
            return false;
        }
        if (this.mUserCredential != null) {
            if (!this.verifyUserCredential()) {
                return false;
            }
        } else if (this.mCertCredential != null) {
            if (!this.verifyCertCredential()) {
                return false;
            }
        } else if (this.mSimCredential != null) {
            if (!this.verifySimCredential()) {
                return false;
            }
        } else {
            Log.d("Credential", "Missing required credential");
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$verifyUserCredential() {
        if (this.mUserCredential == null) {
            Log.d("Credential", "Missing user credential");
            return false;
        }
        if (this.mCertCredential != null || this.mSimCredential != null) {
            Log.d("Credential", "Contained more than one type of credential");
            return false;
        }
        if (!this.mUserCredential.validate()) {
            return false;
        }
        if (this.mCaCertificate == null) {
            Log.d("Credential", "Missing CA Certificate for user credential");
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$verifyCertCredential() {
        if (this.mCertCredential == null) {
            Log.d("Credential", "Missing certificate credential");
            return false;
        }
        if (this.mUserCredential != null || this.mSimCredential != null) {
            Log.d("Credential", "Contained more than one type of credential");
            return false;
        }
        if (!this.mCertCredential.validate()) {
            return false;
        }
        if (this.mCaCertificate == null) {
            Log.d("Credential", "Missing CA Certificate for certificate credential");
            return false;
        }
        if (this.mClientPrivateKey == null) {
            Log.d("Credential", "Missing client private key for certificate credential");
            return false;
        }
        try {
            if (!Credential.verifySha256Fingerprint(this.mClientCertificateChain, this.mCertCredential.getCertSha256Fingerprint())) {
                Log.d("Credential", "SHA-256 fingerprint mismatch");
                return false;
            }
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            Log.d("Credential", "Failed to verify SHA-256 fingerprint: " + e.getMessage());
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$verifySimCredential() {
        if (this.mSimCredential == null) {
            Log.d("Credential", "Missing SIM credential");
            return false;
        }
        if (this.mUserCredential != null || this.mCertCredential != null) {
            Log.d("Credential", "Contained more than one type of credential");
            return false;
        }
        return this.mSimCredential.validate();
    }

    private static final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$isPrivateKeyEquals(PrivateKey key1, PrivateKey key2) {
        if (key1 == null && key2 == null) {
            return true;
        }
        if (key1 == null || key2 == null) {
            return false;
        }
        return TextUtils.equals(key1.getAlgorithm(), key2.getAlgorithm()) && Arrays.equals(key1.getEncoded(), key2.getEncoded());
    }

    private static final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$isX509CertificateEquals(X509Certificate cert1, X509Certificate cert2) {
        if (cert1 == null && cert2 == null) {
            return true;
        }
        if (cert1 == null || cert2 == null) {
            return false;
        }
        boolean result = false;
        try {
            result = Arrays.equals(cert1.getEncoded(), cert2.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return result;
    }

    private static final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$isX509CertificatesEquals(X509Certificate[] certs1, X509Certificate[] certs2) {
        if (certs1 == null && certs2 == null) {
            return true;
        }
        if (certs1 == null || certs2 == null) {
            return false;
        }
        if (certs1.length != certs2.length) {
            return false;
        }
        for (int i = 0; i < certs1.length; ++i) {
            if (Credential.isX509CertificateEquals(certs1[i], certs2[i])) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential$verifySha256Fingerprint(X509Certificate[] certChain, byte[] expectedFingerprint) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (certChain == null) {
            return false;
        }
        MessageDigest digester = MessageDigest.getInstance("SHA-256");
        for (X509Certificate certificate : certChain) {
            digester.reset();
            byte[] fingerprint = digester.digest(certificate.getEncoded());
            if (!Arrays.equals(expectedFingerprint, fingerprint)) continue;
            return true;
        }
        return false;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Credential>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_hotspot2_pps_Credential_1$__constructor__() {
            }

            private final Credential $$robo$$android_net_wifi_hotspot2_pps_Credential_1$createFromParcel(Parcel in) {
                Credential credential = new Credential();
                credential.setCreationTimeInMillis(in.readLong());
                credential.setExpirationTimeInMillis(in.readLong());
                credential.setRealm(in.readString());
                credential.setCheckAaaServerCertStatus(in.readInt() != 0);
                credential.setUserCredential((UserCredential)in.readParcelable(null));
                credential.setCertCredential((CertificateCredential)in.readParcelable(null));
                credential.setSimCredential((SimCredential)in.readParcelable(null));
                credential.setCaCertificate(ParcelUtil.readCertificate(in));
                credential.setClientCertificateChain(ParcelUtil.readCertificates(in));
                credential.setClientPrivateKey(ParcelUtil.readPrivateKey(in));
                return credential;
            }

            private final Credential[] $$robo$$android_net_wifi_hotspot2_pps_Credential_1$newArray(int size) {
                return new Credential[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_hotspot2_pps_Credential_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_1$__constructor__(), 0, this);
            }

            @Override
            public Credential createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_hotspot2_pps_Credential_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Credential[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_hotspot2_pps_Credential_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public void setCreationTimeInMillis(long l) {
        InvokeDynamicSupport.bootstrap("setCreationTimeInMillis", $$robo$$android_net_wifi_hotspot2_pps_Credential$setCreationTimeInMillis(long ), 0, this, l);
    }

    public long getCreationTimeInMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getCreationTimeInMillis", $$robo$$android_net_wifi_hotspot2_pps_Credential$getCreationTimeInMillis(), 0, this);
    }

    public void setExpirationTimeInMillis(long l) {
        InvokeDynamicSupport.bootstrap("setExpirationTimeInMillis", $$robo$$android_net_wifi_hotspot2_pps_Credential$setExpirationTimeInMillis(long ), 0, this, l);
    }

    public long getExpirationTimeInMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getExpirationTimeInMillis", $$robo$$android_net_wifi_hotspot2_pps_Credential$getExpirationTimeInMillis(), 0, this);
    }

    public void setRealm(String string2) {
        InvokeDynamicSupport.bootstrap("setRealm", $$robo$$android_net_wifi_hotspot2_pps_Credential$setRealm(java.lang.String ), 0, this, string2);
    }

    public String getRealm() {
        return InvokeDynamicSupport.bootstrap("getRealm", $$robo$$android_net_wifi_hotspot2_pps_Credential$getRealm(), 0, this);
    }

    public void setCheckAaaServerCertStatus(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCheckAaaServerCertStatus", $$robo$$android_net_wifi_hotspot2_pps_Credential$setCheckAaaServerCertStatus(boolean ), 0, this, bl);
    }

    public boolean getCheckAaaServerCertStatus() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCheckAaaServerCertStatus", $$robo$$android_net_wifi_hotspot2_pps_Credential$getCheckAaaServerCertStatus(), 0, this);
    }

    public void setUserCredential(UserCredential userCredential) {
        InvokeDynamicSupport.bootstrap("setUserCredential", $$robo$$android_net_wifi_hotspot2_pps_Credential$setUserCredential(android.net.wifi.hotspot2.pps.Credential$UserCredential ), 0, this, userCredential);
    }

    public UserCredential getUserCredential() {
        return InvokeDynamicSupport.bootstrap("getUserCredential", $$robo$$android_net_wifi_hotspot2_pps_Credential$getUserCredential(), 0, this);
    }

    public void setCertCredential(CertificateCredential certificateCredential) {
        InvokeDynamicSupport.bootstrap("setCertCredential", $$robo$$android_net_wifi_hotspot2_pps_Credential$setCertCredential(android.net.wifi.hotspot2.pps.Credential$CertificateCredential ), 0, this, certificateCredential);
    }

    public CertificateCredential getCertCredential() {
        return InvokeDynamicSupport.bootstrap("getCertCredential", $$robo$$android_net_wifi_hotspot2_pps_Credential$getCertCredential(), 0, this);
    }

    public void setSimCredential(SimCredential simCredential) {
        InvokeDynamicSupport.bootstrap("setSimCredential", $$robo$$android_net_wifi_hotspot2_pps_Credential$setSimCredential(android.net.wifi.hotspot2.pps.Credential$SimCredential ), 0, this, simCredential);
    }

    public SimCredential getSimCredential() {
        return InvokeDynamicSupport.bootstrap("getSimCredential", $$robo$$android_net_wifi_hotspot2_pps_Credential$getSimCredential(), 0, this);
    }

    public void setCaCertificate(X509Certificate x509Certificate) {
        InvokeDynamicSupport.bootstrap("setCaCertificate", $$robo$$android_net_wifi_hotspot2_pps_Credential$setCaCertificate(java.security.cert.X509Certificate ), 0, this, x509Certificate);
    }

    public X509Certificate getCaCertificate() {
        return InvokeDynamicSupport.bootstrap("getCaCertificate", $$robo$$android_net_wifi_hotspot2_pps_Credential$getCaCertificate(), 0, this);
    }

    public void setClientCertificateChain(X509Certificate[] x509CertificateArray) {
        InvokeDynamicSupport.bootstrap("setClientCertificateChain", $$robo$$android_net_wifi_hotspot2_pps_Credential$setClientCertificateChain(java.security.cert.X509Certificate[] ), 0, this, x509CertificateArray);
    }

    public X509Certificate[] getClientCertificateChain() {
        return InvokeDynamicSupport.bootstrap("getClientCertificateChain", $$robo$$android_net_wifi_hotspot2_pps_Credential$getClientCertificateChain(), 0, this);
    }

    public void setClientPrivateKey(PrivateKey privateKey) {
        InvokeDynamicSupport.bootstrap("setClientPrivateKey", $$robo$$android_net_wifi_hotspot2_pps_Credential$setClientPrivateKey(java.security.PrivateKey ), 0, this, privateKey);
    }

    public PrivateKey getClientPrivateKey() {
        return InvokeDynamicSupport.bootstrap("getClientPrivateKey", $$robo$$android_net_wifi_hotspot2_pps_Credential$getClientPrivateKey(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_hotspot2_pps_Credential$__constructor__();
    }

    public Credential() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential$__constructor__(), 0, this);
    }

    private void __constructor__(Credential credential) {
        this.$$robo$$android_net_wifi_hotspot2_pps_Credential$__constructor__(credential);
    }

    public Credential(Credential credential) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential$__constructor__(android.net.wifi.hotspot2.pps.Credential ), 0, this, credential);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_hotspot2_pps_Credential$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_hotspot2_pps_Credential$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_hotspot2_pps_Credential$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_hotspot2_pps_Credential$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_hotspot2_pps_Credential$toString(), 0, this);
    }

    public boolean validate() {
        return (boolean)InvokeDynamicSupport.bootstrap("validate", $$robo$$android_net_wifi_hotspot2_pps_Credential$validate(), 0, this);
    }

    private boolean verifyUserCredential() {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyUserCredential", $$robo$$android_net_wifi_hotspot2_pps_Credential$verifyUserCredential(), 0, this);
    }

    private boolean verifyCertCredential() {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyCertCredential", $$robo$$android_net_wifi_hotspot2_pps_Credential$verifyCertCredential(), 0, this);
    }

    private boolean verifySimCredential() {
        return (boolean)InvokeDynamicSupport.bootstrap("verifySimCredential", $$robo$$android_net_wifi_hotspot2_pps_Credential$verifySimCredential(), 0, this);
    }

    private static boolean isPrivateKeyEquals(PrivateKey privateKey, PrivateKey privateKey2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrivateKeyEquals", $$robo$$android_net_wifi_hotspot2_pps_Credential$isPrivateKeyEquals(java.security.PrivateKey java.security.PrivateKey ), 0, (PrivateKey)privateKey, (PrivateKey)privateKey2);
    }

    private static boolean isX509CertificateEquals(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isX509CertificateEquals", $$robo$$android_net_wifi_hotspot2_pps_Credential$isX509CertificateEquals(java.security.cert.X509Certificate java.security.cert.X509Certificate ), 0, (X509Certificate)x509Certificate, (X509Certificate)x509Certificate2);
    }

    private static boolean isX509CertificatesEquals(X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isX509CertificatesEquals", $$robo$$android_net_wifi_hotspot2_pps_Credential$isX509CertificatesEquals(java.security.cert.X509Certificate[] java.security.cert.X509Certificate[] ), 0, (X509Certificate[])x509CertificateArray, (X509Certificate[])x509CertificateArray2);
    }

    private static boolean verifySha256Fingerprint(X509Certificate[] x509CertificateArray, byte[] byArray) throws NoSuchAlgorithmException, CertificateEncodingException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifySha256Fingerprint", $$robo$$android_net_wifi_hotspot2_pps_Credential$verifySha256Fingerprint(java.security.cert.X509Certificate[] byte[] ), 0, (X509Certificate[])x509CertificateArray, (byte[])byArray);
    }

    static {
        RobolectricInternals.classInitializing(Credential.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Credential)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SimCredential
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_IMSI_LENGTH = 15;
        private String mImsi;
        private int mEapType;
        public static Parcelable.Creator<SimCredential> CREATOR;

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$setImsi(String imsi) {
            this.mImsi = imsi;
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$getImsi() {
            return this.mImsi;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$setEapType(int eapType) {
            this.mEapType = eapType;
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$getEapType() {
            return this.mEapType;
        }

        private void $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$__constructor__() {
            this.mImsi = null;
            this.mEapType = Integer.MIN_VALUE;
        }

        private void $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$__constructor__(SimCredential source) {
            this.mImsi = null;
            this.mEapType = Integer.MIN_VALUE;
            if (source != null) {
                this.mImsi = source.mImsi;
                this.mEapType = source.mEapType;
            }
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$describeContents() {
            return 0;
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$equals(Object thatObject) {
            if (this == thatObject) {
                return true;
            }
            if (!(thatObject instanceof SimCredential)) {
                return false;
            }
            SimCredential that = (SimCredential)thatObject;
            return TextUtils.equals(this.mImsi, that.mImsi) && this.mEapType == that.mEapType;
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$hashCode() {
            return Objects.hash(this.mImsi, this.mEapType);
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IMSI: ").append(this.mImsi).append("\n");
            builder.append("EAPType: ").append(this.mEapType).append("\n");
            return builder.toString();
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mImsi);
            dest.writeInt(this.mEapType);
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$validate() {
            if (!this.verifyImsi()) {
                return false;
            }
            if (this.mEapType != 18 && this.mEapType != 23 && this.mEapType != 50) {
                Log.d("Credential", "Invalid EAP Type for SIM credential: " + this.mEapType);
                return false;
            }
            return true;
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$verifyImsi() {
            int nonDigit;
            if (TextUtils.isEmpty(this.mImsi)) {
                Log.d("Credential", "Missing IMSI");
                return false;
            }
            if (this.mImsi.length() > 15) {
                Log.d("Credential", "IMSI exceeding maximum length: " + this.mImsi.length());
                return false;
            }
            char stopChar = '\u0000';
            for (nonDigit = 0; nonDigit < this.mImsi.length() && (stopChar = this.mImsi.charAt(nonDigit)) >= '0' && stopChar <= '9'; ++nonDigit) {
            }
            if (nonDigit == this.mImsi.length()) {
                return true;
            }
            return nonDigit == this.mImsi.length() - 1 && stopChar == '*';
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SimCredential>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential_1$__constructor__() {
                }

                private final SimCredential $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential_1$createFromParcel(Parcel in) {
                    SimCredential simCredential = new SimCredential();
                    simCredential.setImsi(in.readString());
                    simCredential.setEapType(in.readInt());
                    return simCredential;
                }

                private final SimCredential[] $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential_1$newArray(int size) {
                    return new SimCredential[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential_1$__constructor__(), 0, this);
                }

                @Override
                public SimCredential createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SimCredential[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public void setImsi(String string2) {
            InvokeDynamicSupport.bootstrap("setImsi", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$setImsi(java.lang.String ), 0, this, string2);
        }

        public String getImsi() {
            return InvokeDynamicSupport.bootstrap("getImsi", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$getImsi(), 0, this);
        }

        public void setEapType(int n) {
            InvokeDynamicSupport.bootstrap("setEapType", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$setEapType(int ), 0, this, n);
        }

        public int getEapType() {
            return (int)InvokeDynamicSupport.bootstrap("getEapType", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$getEapType(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$__constructor__();
        }

        public SimCredential() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$__constructor__(), 0, this);
        }

        private void __constructor__(SimCredential simCredential) {
            this.$$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$__constructor__(simCredential);
        }

        public SimCredential(SimCredential simCredential) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$__constructor__(android.net.wifi.hotspot2.pps.Credential$SimCredential ), 0, this, simCredential);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$describeContents(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$toString(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public boolean validate() {
            return (boolean)InvokeDynamicSupport.bootstrap("validate", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$validate(), 0, this);
        }

        private boolean verifyImsi() {
            return (boolean)InvokeDynamicSupport.bootstrap("verifyImsi", $$robo$$android_net_wifi_hotspot2_pps_Credential_SimCredential$verifyImsi(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(SimCredential.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimCredential)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CertificateCredential
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String CERT_TYPE_X509V3 = "x509v3";
        private static int CERT_SHA256_FINGER_PRINT_LENGTH = 32;
        private String mCertType;
        private byte[] mCertSha256Fingerprint;
        public static Parcelable.Creator<CertificateCredential> CREATOR;

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$setCertType(String certType) {
            this.mCertType = certType;
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$getCertType() {
            return this.mCertType;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$setCertSha256Fingerprint(byte[] certSha256Fingerprint) {
            this.mCertSha256Fingerprint = certSha256Fingerprint;
        }

        private final byte[] $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$getCertSha256Fingerprint() {
            return this.mCertSha256Fingerprint;
        }

        private void $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$__constructor__() {
            this.mCertType = null;
            this.mCertSha256Fingerprint = null;
        }

        private void $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$__constructor__(CertificateCredential source) {
            this.mCertType = null;
            this.mCertSha256Fingerprint = null;
            if (source != null) {
                this.mCertType = source.mCertType;
                if (source.mCertSha256Fingerprint != null) {
                    this.mCertSha256Fingerprint = Arrays.copyOf(source.mCertSha256Fingerprint, source.mCertSha256Fingerprint.length);
                }
            }
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mCertType);
            dest.writeByteArray(this.mCertSha256Fingerprint);
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$equals(Object thatObject) {
            if (this == thatObject) {
                return true;
            }
            if (!(thatObject instanceof CertificateCredential)) {
                return false;
            }
            CertificateCredential that = (CertificateCredential)thatObject;
            return TextUtils.equals(this.mCertType, that.mCertType) && Arrays.equals(this.mCertSha256Fingerprint, that.mCertSha256Fingerprint);
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$hashCode() {
            return Objects.hash(this.mCertType, this.mCertSha256Fingerprint);
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$toString() {
            return "CertificateType: " + this.mCertType + "\n";
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$validate() {
            if (!TextUtils.equals("x509v3", this.mCertType)) {
                Log.d("Credential", "Unsupported certificate type: " + this.mCertType);
                return false;
            }
            if (this.mCertSha256Fingerprint == null || this.mCertSha256Fingerprint.length != 32) {
                Log.d("Credential", "Invalid SHA-256 fingerprint");
                return false;
            }
            return true;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<CertificateCredential>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential_1$__constructor__() {
                }

                private final CertificateCredential $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential_1$createFromParcel(Parcel in) {
                    CertificateCredential certCredential = new CertificateCredential();
                    certCredential.setCertType(in.readString());
                    certCredential.setCertSha256Fingerprint(in.createByteArray());
                    return certCredential;
                }

                private final CertificateCredential[] $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential_1$newArray(int size) {
                    return new CertificateCredential[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential_1$__constructor__(), 0, this);
                }

                @Override
                public CertificateCredential createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public CertificateCredential[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public void setCertType(String string2) {
            InvokeDynamicSupport.bootstrap("setCertType", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$setCertType(java.lang.String ), 0, this, string2);
        }

        public String getCertType() {
            return InvokeDynamicSupport.bootstrap("getCertType", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$getCertType(), 0, this);
        }

        public void setCertSha256Fingerprint(byte[] byArray) {
            InvokeDynamicSupport.bootstrap("setCertSha256Fingerprint", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$setCertSha256Fingerprint(byte[] ), 0, this, byArray);
        }

        public byte[] getCertSha256Fingerprint() {
            return InvokeDynamicSupport.bootstrap("getCertSha256Fingerprint", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$getCertSha256Fingerprint(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$__constructor__();
        }

        public CertificateCredential() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$__constructor__(), 0, this);
        }

        private void __constructor__(CertificateCredential certificateCredential) {
            this.$$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$__constructor__(certificateCredential);
        }

        public CertificateCredential(CertificateCredential certificateCredential) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$__constructor__(android.net.wifi.hotspot2.pps.Credential$CertificateCredential ), 0, this, certificateCredential);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$toString(), 0, this);
        }

        public boolean validate() {
            return (boolean)InvokeDynamicSupport.bootstrap("validate", $$robo$$android_net_wifi_hotspot2_pps_Credential_CertificateCredential$validate(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(CertificateCredential.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CertificateCredential)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class UserCredential
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_USERNAME_BYTES = 63;
        private static int MAX_PASSWORD_BYTES = 255;
        public static String AUTH_METHOD_PAP = "PAP";
        public static String AUTH_METHOD_MSCHAP = "MS-CHAP";
        public static String AUTH_METHOD_MSCHAPV2 = "MS-CHAP-V2";
        private static Set<String> SUPPORTED_AUTH;
        private String mUsername;
        private String mPassword;
        private boolean mMachineManaged;
        private String mSoftTokenApp;
        private boolean mAbleToShare;
        private int mEapType;
        private String mNonEapInnerMethod;
        public static Parcelable.Creator<UserCredential> CREATOR;

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setUsername(String username) {
            this.mUsername = username;
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getUsername() {
            return this.mUsername;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setPassword(String password) {
            this.mPassword = password;
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getPassword() {
            return this.mPassword;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setMachineManaged(boolean machineManaged) {
            this.mMachineManaged = machineManaged;
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getMachineManaged() {
            return this.mMachineManaged;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setSoftTokenApp(String softTokenApp) {
            this.mSoftTokenApp = softTokenApp;
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getSoftTokenApp() {
            return this.mSoftTokenApp;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setAbleToShare(boolean ableToShare) {
            this.mAbleToShare = ableToShare;
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getAbleToShare() {
            return this.mAbleToShare;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setEapType(int eapType) {
            this.mEapType = eapType;
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getEapType() {
            return this.mEapType;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setNonEapInnerMethod(String nonEapInnerMethod) {
            this.mNonEapInnerMethod = nonEapInnerMethod;
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getNonEapInnerMethod() {
            return this.mNonEapInnerMethod;
        }

        private void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$__constructor__() {
            this.mUsername = null;
            this.mPassword = null;
            this.mMachineManaged = false;
            this.mSoftTokenApp = null;
            this.mAbleToShare = false;
            this.mEapType = Integer.MIN_VALUE;
            this.mNonEapInnerMethod = null;
        }

        private void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$__constructor__(UserCredential source) {
            this.mUsername = null;
            this.mPassword = null;
            this.mMachineManaged = false;
            this.mSoftTokenApp = null;
            this.mAbleToShare = false;
            this.mEapType = Integer.MIN_VALUE;
            this.mNonEapInnerMethod = null;
            if (source != null) {
                this.mUsername = source.mUsername;
                this.mPassword = source.mPassword;
                this.mMachineManaged = source.mMachineManaged;
                this.mSoftTokenApp = source.mSoftTokenApp;
                this.mAbleToShare = source.mAbleToShare;
                this.mEapType = source.mEapType;
                this.mNonEapInnerMethod = source.mNonEapInnerMethod;
            }
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mUsername);
            dest.writeString(this.mPassword);
            dest.writeInt(this.mMachineManaged ? 1 : 0);
            dest.writeString(this.mSoftTokenApp);
            dest.writeInt(this.mAbleToShare ? 1 : 0);
            dest.writeInt(this.mEapType);
            dest.writeString(this.mNonEapInnerMethod);
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$equals(Object thatObject) {
            if (this == thatObject) {
                return true;
            }
            if (!(thatObject instanceof UserCredential)) {
                return false;
            }
            UserCredential that = (UserCredential)thatObject;
            return TextUtils.equals(this.mUsername, that.mUsername) && TextUtils.equals(this.mPassword, that.mPassword) && this.mMachineManaged == that.mMachineManaged && TextUtils.equals(this.mSoftTokenApp, that.mSoftTokenApp) && this.mAbleToShare == that.mAbleToShare && this.mEapType == that.mEapType && TextUtils.equals(this.mNonEapInnerMethod, that.mNonEapInnerMethod);
        }

        private final int $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$hashCode() {
            return Objects.hash(this.mUsername, this.mPassword, this.mMachineManaged, this.mSoftTokenApp, this.mAbleToShare, this.mEapType, this.mNonEapInnerMethod);
        }

        private final String $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Username: ").append(this.mUsername).append("\n");
            builder.append("MachineManaged: ").append(this.mMachineManaged).append("\n");
            builder.append("SoftTokenApp: ").append(this.mSoftTokenApp).append("\n");
            builder.append("AbleToShare: ").append(this.mAbleToShare).append("\n");
            builder.append("EAPType: ").append(this.mEapType).append("\n");
            builder.append("AuthMethod: ").append(this.mNonEapInnerMethod).append("\n");
            return builder.toString();
        }

        private final boolean $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$validate() {
            if (TextUtils.isEmpty(this.mUsername)) {
                Log.d("Credential", "Missing username");
                return false;
            }
            if (this.mUsername.getBytes(StandardCharsets.UTF_8).length > 63) {
                Log.d("Credential", "username exceeding maximum length: " + this.mUsername.getBytes(StandardCharsets.UTF_8).length);
                return false;
            }
            if (TextUtils.isEmpty(this.mPassword)) {
                Log.d("Credential", "Missing password");
                return false;
            }
            if (this.mPassword.getBytes(StandardCharsets.UTF_8).length > 255) {
                Log.d("Credential", "password exceeding maximum length: " + this.mPassword.getBytes(StandardCharsets.UTF_8).length);
                return false;
            }
            if (this.mEapType != 21) {
                Log.d("Credential", "Invalid EAP Type for user credential: " + this.mEapType);
                return false;
            }
            if (!SUPPORTED_AUTH.contains(this.mNonEapInnerMethod)) {
                Log.d("Credential", "Invalid non-EAP inner method for EAP-TTLS: " + this.mNonEapInnerMethod);
                return false;
            }
            return true;
        }

        static void __staticInitializer__() {
            SUPPORTED_AUTH = new HashSet<String>(Arrays.asList("PAP", "MS-CHAP", "MS-CHAP-V2"));
            CREATOR = new Parcelable.Creator<UserCredential>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential_1$__constructor__() {
                }

                private final UserCredential $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential_1$createFromParcel(Parcel in) {
                    UserCredential userCredential = new UserCredential();
                    userCredential.setUsername(in.readString());
                    userCredential.setPassword(in.readString());
                    userCredential.setMachineManaged(in.readInt() != 0);
                    userCredential.setSoftTokenApp(in.readString());
                    userCredential.setAbleToShare(in.readInt() != 0);
                    userCredential.setEapType(in.readInt());
                    userCredential.setNonEapInnerMethod(in.readString());
                    return userCredential;
                }

                private final UserCredential[] $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential_1$newArray(int size) {
                    return new UserCredential[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential_1$__constructor__(), 0, this);
                }

                @Override
                public UserCredential createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public UserCredential[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public void setUsername(String string2) {
            InvokeDynamicSupport.bootstrap("setUsername", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setUsername(java.lang.String ), 0, this, string2);
        }

        public String getUsername() {
            return InvokeDynamicSupport.bootstrap("getUsername", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getUsername(), 0, this);
        }

        public void setPassword(String string2) {
            InvokeDynamicSupport.bootstrap("setPassword", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setPassword(java.lang.String ), 0, this, string2);
        }

        public String getPassword() {
            return InvokeDynamicSupport.bootstrap("getPassword", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getPassword(), 0, this);
        }

        public void setMachineManaged(boolean bl) {
            InvokeDynamicSupport.bootstrap("setMachineManaged", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setMachineManaged(boolean ), 0, this, bl);
        }

        public boolean getMachineManaged() {
            return (boolean)InvokeDynamicSupport.bootstrap("getMachineManaged", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getMachineManaged(), 0, this);
        }

        public void setSoftTokenApp(String string2) {
            InvokeDynamicSupport.bootstrap("setSoftTokenApp", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setSoftTokenApp(java.lang.String ), 0, this, string2);
        }

        public String getSoftTokenApp() {
            return InvokeDynamicSupport.bootstrap("getSoftTokenApp", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getSoftTokenApp(), 0, this);
        }

        public void setAbleToShare(boolean bl) {
            InvokeDynamicSupport.bootstrap("setAbleToShare", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setAbleToShare(boolean ), 0, this, bl);
        }

        public boolean getAbleToShare() {
            return (boolean)InvokeDynamicSupport.bootstrap("getAbleToShare", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getAbleToShare(), 0, this);
        }

        public void setEapType(int n) {
            InvokeDynamicSupport.bootstrap("setEapType", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setEapType(int ), 0, this, n);
        }

        public int getEapType() {
            return (int)InvokeDynamicSupport.bootstrap("getEapType", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getEapType(), 0, this);
        }

        public void setNonEapInnerMethod(String string2) {
            InvokeDynamicSupport.bootstrap("setNonEapInnerMethod", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$setNonEapInnerMethod(java.lang.String ), 0, this, string2);
        }

        public String getNonEapInnerMethod() {
            return InvokeDynamicSupport.bootstrap("getNonEapInnerMethod", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$getNonEapInnerMethod(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$__constructor__();
        }

        public UserCredential() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$__constructor__(), 0, this);
        }

        private void __constructor__(UserCredential userCredential) {
            this.$$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$__constructor__(userCredential);
        }

        public UserCredential(UserCredential userCredential) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$__constructor__(android.net.wifi.hotspot2.pps.Credential$UserCredential ), 0, this, userCredential);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$toString(), 0, this);
        }

        public boolean validate() {
            return (boolean)InvokeDynamicSupport.bootstrap("validate", $$robo$$android_net_wifi_hotspot2_pps_Credential_UserCredential$validate(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(UserCredential.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserCredential)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

