/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.content.Context;
import android.net.wifi.WpsInfo;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pGroupList;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pWfdInfo;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import android.net.wifi.p2p.nsd.WifiP2pServiceRequest;
import android.net.wifi.p2p.nsd.WifiP2pServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pUpnpServiceResponse;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import dalvik.system.CloseGuard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiP2pManager";
    public static String WIFI_P2P_STATE_CHANGED_ACTION = "android.net.wifi.p2p.STATE_CHANGED";
    public static String EXTRA_WIFI_STATE = "wifi_p2p_state";
    public static int WIFI_P2P_STATE_DISABLED = 1;
    public static int WIFI_P2P_STATE_ENABLED = 2;
    public static String WIFI_P2P_CONNECTION_CHANGED_ACTION = "android.net.wifi.p2p.CONNECTION_STATE_CHANGE";
    public static String EXTRA_WIFI_P2P_INFO = "wifiP2pInfo";
    public static String EXTRA_NETWORK_INFO = "networkInfo";
    public static String EXTRA_WIFI_P2P_GROUP = "p2pGroupInfo";
    public static String WIFI_P2P_PEERS_CHANGED_ACTION = "android.net.wifi.p2p.PEERS_CHANGED";
    public static String EXTRA_P2P_DEVICE_LIST = "wifiP2pDeviceList";
    public static String WIFI_P2P_DISCOVERY_CHANGED_ACTION = "android.net.wifi.p2p.DISCOVERY_STATE_CHANGE";
    public static String EXTRA_DISCOVERY_STATE = "discoveryState";
    public static int WIFI_P2P_DISCOVERY_STOPPED = 1;
    public static int WIFI_P2P_DISCOVERY_STARTED = 2;
    public static String WIFI_P2P_THIS_DEVICE_CHANGED_ACTION = "android.net.wifi.p2p.THIS_DEVICE_CHANGED";
    public static String EXTRA_WIFI_P2P_DEVICE = "wifiP2pDevice";
    public static String WIFI_P2P_PERSISTENT_GROUPS_CHANGED_ACTION = "android.net.wifi.p2p.PERSISTENT_GROUPS_CHANGED";
    public static String EXTRA_HANDOVER_MESSAGE = "android.net.wifi.p2p.EXTRA_HANDOVER_MESSAGE";
    public static String CALLING_PACKAGE = "android.net.wifi.p2p.CALLING_PACKAGE";
    IWifiP2pManager mService;
    private static int BASE = 139264;
    public static int DISCOVER_PEERS = 139265;
    public static int DISCOVER_PEERS_FAILED = 139266;
    public static int DISCOVER_PEERS_SUCCEEDED = 139267;
    public static int STOP_DISCOVERY = 139268;
    public static int STOP_DISCOVERY_FAILED = 139269;
    public static int STOP_DISCOVERY_SUCCEEDED = 139270;
    public static int CONNECT = 139271;
    public static int CONNECT_FAILED = 139272;
    public static int CONNECT_SUCCEEDED = 139273;
    public static int CANCEL_CONNECT = 139274;
    public static int CANCEL_CONNECT_FAILED = 139275;
    public static int CANCEL_CONNECT_SUCCEEDED = 139276;
    public static int CREATE_GROUP = 139277;
    public static int CREATE_GROUP_FAILED = 139278;
    public static int CREATE_GROUP_SUCCEEDED = 139279;
    public static int REMOVE_GROUP = 139280;
    public static int REMOVE_GROUP_FAILED = 139281;
    public static int REMOVE_GROUP_SUCCEEDED = 139282;
    public static int REQUEST_PEERS = 139283;
    public static int RESPONSE_PEERS = 139284;
    public static int REQUEST_CONNECTION_INFO = 139285;
    public static int RESPONSE_CONNECTION_INFO = 139286;
    public static int REQUEST_GROUP_INFO = 139287;
    public static int RESPONSE_GROUP_INFO = 139288;
    public static int ADD_LOCAL_SERVICE = 139292;
    public static int ADD_LOCAL_SERVICE_FAILED = 139293;
    public static int ADD_LOCAL_SERVICE_SUCCEEDED = 139294;
    public static int REMOVE_LOCAL_SERVICE = 139295;
    public static int REMOVE_LOCAL_SERVICE_FAILED = 139296;
    public static int REMOVE_LOCAL_SERVICE_SUCCEEDED = 139297;
    public static int CLEAR_LOCAL_SERVICES = 139298;
    public static int CLEAR_LOCAL_SERVICES_FAILED = 139299;
    public static int CLEAR_LOCAL_SERVICES_SUCCEEDED = 139300;
    public static int ADD_SERVICE_REQUEST = 139301;
    public static int ADD_SERVICE_REQUEST_FAILED = 139302;
    public static int ADD_SERVICE_REQUEST_SUCCEEDED = 139303;
    public static int REMOVE_SERVICE_REQUEST = 139304;
    public static int REMOVE_SERVICE_REQUEST_FAILED = 139305;
    public static int REMOVE_SERVICE_REQUEST_SUCCEEDED = 139306;
    public static int CLEAR_SERVICE_REQUESTS = 139307;
    public static int CLEAR_SERVICE_REQUESTS_FAILED = 139308;
    public static int CLEAR_SERVICE_REQUESTS_SUCCEEDED = 139309;
    public static int DISCOVER_SERVICES = 139310;
    public static int DISCOVER_SERVICES_FAILED = 139311;
    public static int DISCOVER_SERVICES_SUCCEEDED = 139312;
    public static int PING = 139313;
    public static int RESPONSE_SERVICE = 139314;
    public static int SET_DEVICE_NAME = 139315;
    public static int SET_DEVICE_NAME_FAILED = 139316;
    public static int SET_DEVICE_NAME_SUCCEEDED = 139317;
    public static int DELETE_PERSISTENT_GROUP = 139318;
    public static int DELETE_PERSISTENT_GROUP_FAILED = 139319;
    public static int DELETE_PERSISTENT_GROUP_SUCCEEDED = 139320;
    public static int REQUEST_PERSISTENT_GROUP_INFO = 139321;
    public static int RESPONSE_PERSISTENT_GROUP_INFO = 139322;
    public static int SET_WFD_INFO = 139323;
    public static int SET_WFD_INFO_FAILED = 139324;
    public static int SET_WFD_INFO_SUCCEEDED = 139325;
    public static int START_WPS = 139326;
    public static int START_WPS_FAILED = 139327;
    public static int START_WPS_SUCCEEDED = 139328;
    public static int START_LISTEN = 139329;
    public static int START_LISTEN_FAILED = 139330;
    public static int START_LISTEN_SUCCEEDED = 139331;
    public static int STOP_LISTEN = 139332;
    public static int STOP_LISTEN_FAILED = 139333;
    public static int STOP_LISTEN_SUCCEEDED = 139334;
    public static int SET_CHANNEL = 139335;
    public static int SET_CHANNEL_FAILED = 139336;
    public static int SET_CHANNEL_SUCCEEDED = 139337;
    public static int GET_HANDOVER_REQUEST = 139339;
    public static int GET_HANDOVER_SELECT = 139340;
    public static int RESPONSE_GET_HANDOVER_MESSAGE = 139341;
    public static int INITIATOR_REPORT_NFC_HANDOVER = 139342;
    public static int RESPONDER_REPORT_NFC_HANDOVER = 139343;
    public static int REPORT_NFC_HANDOVER_SUCCEEDED = 139344;
    public static int REPORT_NFC_HANDOVER_FAILED = 139345;
    public static int ERROR = 0;
    public static int P2P_UNSUPPORTED = 1;
    public static int BUSY = 2;
    public static int NO_SERVICE_REQUESTS = 3;
    public static int MIRACAST_DISABLED = 0;
    public static int MIRACAST_SOURCE = 1;
    public static int MIRACAST_SINK = 2;

    private void $$robo$$android_net_wifi_p2p_WifiP2pManager$__constructor__(IWifiP2pManager service) {
        this.mService = service;
    }

    private static final void $$robo$$android_net_wifi_p2p_WifiP2pManager$checkChannel(Channel c) {
        if (c == null) {
            throw new IllegalArgumentException("Channel needs to be initialized");
        }
    }

    private static final void $$robo$$android_net_wifi_p2p_WifiP2pManager$checkServiceInfo(WifiP2pServiceInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("service info is null");
        }
    }

    private static final void $$robo$$android_net_wifi_p2p_WifiP2pManager$checkServiceRequest(WifiP2pServiceRequest req) {
        if (req == null) {
            throw new IllegalArgumentException("service request is null");
        }
    }

    private static final void $$robo$$android_net_wifi_p2p_WifiP2pManager$checkP2pConfig(WifiP2pConfig c) {
        if (c == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        if (TextUtils.isEmpty(c.deviceAddress)) {
            throw new IllegalArgumentException("deviceAddress cannot be empty");
        }
    }

    private final Channel $$robo$$android_net_wifi_p2p_WifiP2pManager$initialize(Context srcContext, Looper srcLooper, ChannelListener listener) {
        Binder binder = new Binder();
        Channel channel = this.initalizeChannel(srcContext, srcLooper, listener, this.getMessenger(binder), binder);
        return channel;
    }

    private final Channel $$robo$$android_net_wifi_p2p_WifiP2pManager$initializeInternal(Context srcContext, Looper srcLooper, ChannelListener listener) {
        return this.initalizeChannel(srcContext, srcLooper, listener, this.getP2pStateMachineMessenger(), null);
    }

    private final Channel $$robo$$android_net_wifi_p2p_WifiP2pManager$initalizeChannel(Context srcContext, Looper srcLooper, ChannelListener listener, Messenger messenger, Binder binder) {
        if (messenger == null) {
            return null;
        }
        Channel c = new Channel(srcContext, srcLooper, listener, binder, this);
        if (c.mAsyncChannel.connectSync(srcContext, (Handler)c.mHandler, messenger) == 0) {
            return c;
        }
        c.close();
        return null;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$discoverPeers(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139265, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$stopPeerDiscovery(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139268, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$connect(Channel c, WifiP2pConfig config, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkP2pConfig(config);
        c.mAsyncChannel.sendMessage(139271, 0, c.putListener(listener), config);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$cancelConnect(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139274, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$createGroup(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139277, -2, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$removeGroup(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139280, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$listen(Channel c, boolean enable, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(enable ? 139329 : 139332, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$setWifiP2pChannels(Channel c, int lc, int oc, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        Bundle p2pChannels = new Bundle();
        p2pChannels.putInt("lc", lc);
        p2pChannels.putInt("oc", oc);
        c.mAsyncChannel.sendMessage(139335, 0, c.putListener(listener), p2pChannels);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$startWps(Channel c, WpsInfo wps, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139326, 0, c.putListener(listener), wps);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$addLocalService(Channel c, WifiP2pServiceInfo servInfo, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkServiceInfo(servInfo);
        c.mAsyncChannel.sendMessage(139292, 0, c.putListener(listener), servInfo);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$removeLocalService(Channel c, WifiP2pServiceInfo servInfo, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkServiceInfo(servInfo);
        c.mAsyncChannel.sendMessage(139295, 0, c.putListener(listener), servInfo);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$clearLocalServices(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139298, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$setServiceResponseListener(Channel c, ServiceResponseListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mServRspListener = listener;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$setDnsSdResponseListeners(Channel c, DnsSdServiceResponseListener servListener, DnsSdTxtRecordListener txtListener) {
        WifiP2pManager.checkChannel(c);
        c.mDnsSdServRspListener = servListener;
        c.mDnsSdTxtListener = txtListener;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$setUpnpServiceResponseListener(Channel c, UpnpServiceResponseListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mUpnpServRspListener = listener;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$discoverServices(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139310, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$addServiceRequest(Channel c, WifiP2pServiceRequest req, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkServiceRequest(req);
        c.mAsyncChannel.sendMessage(139301, 0, c.putListener(listener), req);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$removeServiceRequest(Channel c, WifiP2pServiceRequest req, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkServiceRequest(req);
        c.mAsyncChannel.sendMessage(139304, 0, c.putListener(listener), req);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$clearServiceRequests(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139307, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$requestPeers(Channel c, PeerListListener listener) {
        WifiP2pManager.checkChannel(c);
        Bundle callingPackage = new Bundle();
        callingPackage.putString("android.net.wifi.p2p.CALLING_PACKAGE", c.mContext.getOpPackageName());
        c.mAsyncChannel.sendMessage(139283, 0, c.putListener(listener), callingPackage);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$requestConnectionInfo(Channel c, ConnectionInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139285, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$requestGroupInfo(Channel c, GroupInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139287, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$setDeviceName(Channel c, String devName, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pDevice d = new WifiP2pDevice();
        d.deviceName = devName;
        c.mAsyncChannel.sendMessage(139315, 0, c.putListener(listener), d);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$setWFDInfo(Channel c, WifiP2pWfdInfo wfdInfo, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        try {
            this.mService.checkConfigureWifiDisplayPermission();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        c.mAsyncChannel.sendMessage(139323, 0, c.putListener(listener), wfdInfo);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$deletePersistentGroup(Channel c, int netId, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139318, netId, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$requestPersistentGroupInfo(Channel c, PersistentGroupInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139321, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$setMiracastMode(int mode) {
        try {
            this.mService.setMiracastMode(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Messenger $$robo$$android_net_wifi_p2p_WifiP2pManager$getMessenger(Binder binder) {
        try {
            return this.mService.getMessenger(binder);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Messenger $$robo$$android_net_wifi_p2p_WifiP2pManager$getP2pStateMachineMessenger() {
        try {
            return this.mService.getP2pStateMachineMessenger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$getNfcHandoverRequest(Channel c, HandoverMessageListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139339, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$getNfcHandoverSelect(Channel c, HandoverMessageListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139340, 0, c.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$initiatorReportNfcHandover(Channel c, String handoverSelect, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        Bundle bundle = new Bundle();
        bundle.putString("android.net.wifi.p2p.EXTRA_HANDOVER_MESSAGE", handoverSelect);
        c.mAsyncChannel.sendMessage(139342, 0, c.putListener(listener), bundle);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pManager$responderReportNfcHandover(Channel c, String handoverRequest, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        Bundle bundle = new Bundle();
        bundle.putString("android.net.wifi.p2p.EXTRA_HANDOVER_MESSAGE", handoverRequest);
        c.mAsyncChannel.sendMessage(139343, 0, c.putListener(listener), bundle);
    }

    private void __constructor__(IWifiP2pManager iWifiP2pManager) {
        this.$$robo$$android_net_wifi_p2p_WifiP2pManager$__constructor__(iWifiP2pManager);
    }

    public WifiP2pManager(IWifiP2pManager iWifiP2pManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pManager$__constructor__(android.net.wifi.p2p.IWifiP2pManager ), 0, this, iWifiP2pManager);
    }

    private static void checkChannel(Channel channel) {
        InvokeDynamicSupport.bootstrapStatic("checkChannel", $$robo$$android_net_wifi_p2p_WifiP2pManager$checkChannel(android.net.wifi.p2p.WifiP2pManager$Channel ), 0, (Channel)channel);
    }

    private static void checkServiceInfo(WifiP2pServiceInfo wifiP2pServiceInfo) {
        InvokeDynamicSupport.bootstrapStatic("checkServiceInfo", $$robo$$android_net_wifi_p2p_WifiP2pManager$checkServiceInfo(android.net.wifi.p2p.nsd.WifiP2pServiceInfo ), 0, (WifiP2pServiceInfo)wifiP2pServiceInfo);
    }

    private static void checkServiceRequest(WifiP2pServiceRequest wifiP2pServiceRequest) {
        InvokeDynamicSupport.bootstrapStatic("checkServiceRequest", $$robo$$android_net_wifi_p2p_WifiP2pManager$checkServiceRequest(android.net.wifi.p2p.nsd.WifiP2pServiceRequest ), 0, (WifiP2pServiceRequest)wifiP2pServiceRequest);
    }

    private static void checkP2pConfig(WifiP2pConfig wifiP2pConfig) {
        InvokeDynamicSupport.bootstrapStatic("checkP2pConfig", $$robo$$android_net_wifi_p2p_WifiP2pManager$checkP2pConfig(android.net.wifi.p2p.WifiP2pConfig ), 0, (WifiP2pConfig)wifiP2pConfig);
    }

    public Channel initialize(Context context, Looper looper, ChannelListener channelListener) {
        return InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_net_wifi_p2p_WifiP2pManager$initialize(android.content.Context android.os.Looper android.net.wifi.p2p.WifiP2pManager$ChannelListener ), 0, this, context, looper, channelListener);
    }

    public Channel initializeInternal(Context context, Looper looper, ChannelListener channelListener) {
        return InvokeDynamicSupport.bootstrap("initializeInternal", $$robo$$android_net_wifi_p2p_WifiP2pManager$initializeInternal(android.content.Context android.os.Looper android.net.wifi.p2p.WifiP2pManager$ChannelListener ), 0, this, context, looper, channelListener);
    }

    private Channel initalizeChannel(Context context, Looper looper, ChannelListener channelListener, Messenger messenger, Binder binder) {
        return InvokeDynamicSupport.bootstrap("initalizeChannel", $$robo$$android_net_wifi_p2p_WifiP2pManager$initalizeChannel(android.content.Context android.os.Looper android.net.wifi.p2p.WifiP2pManager$ChannelListener android.os.Messenger android.os.Binder ), 0, this, context, looper, channelListener, messenger, binder);
    }

    public void discoverPeers(Channel channel, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("discoverPeers", $$robo$$android_net_wifi_p2p_WifiP2pManager$discoverPeers(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, actionListener);
    }

    public void stopPeerDiscovery(Channel channel, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("stopPeerDiscovery", $$robo$$android_net_wifi_p2p_WifiP2pManager$stopPeerDiscovery(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, actionListener);
    }

    public void connect(Channel channel, WifiP2pConfig wifiP2pConfig, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_net_wifi_p2p_WifiP2pManager$connect(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pConfig android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, wifiP2pConfig, actionListener);
    }

    public void cancelConnect(Channel channel, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("cancelConnect", $$robo$$android_net_wifi_p2p_WifiP2pManager$cancelConnect(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, actionListener);
    }

    public void createGroup(Channel channel, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("createGroup", $$robo$$android_net_wifi_p2p_WifiP2pManager$createGroup(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, actionListener);
    }

    public void removeGroup(Channel channel, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("removeGroup", $$robo$$android_net_wifi_p2p_WifiP2pManager$removeGroup(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, actionListener);
    }

    public void listen(Channel channel, boolean bl, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("listen", $$robo$$android_net_wifi_p2p_WifiP2pManager$listen(android.net.wifi.p2p.WifiP2pManager$Channel boolean android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, bl, actionListener);
    }

    public void setWifiP2pChannels(Channel channel, int n, int n2, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("setWifiP2pChannels", $$robo$$android_net_wifi_p2p_WifiP2pManager$setWifiP2pChannels(android.net.wifi.p2p.WifiP2pManager$Channel int int android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, n, n2, actionListener);
    }

    public void startWps(Channel channel, WpsInfo wpsInfo, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("startWps", $$robo$$android_net_wifi_p2p_WifiP2pManager$startWps(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.WpsInfo android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, wpsInfo, actionListener);
    }

    public void addLocalService(Channel channel, WifiP2pServiceInfo wifiP2pServiceInfo, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("addLocalService", $$robo$$android_net_wifi_p2p_WifiP2pManager$addLocalService(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.nsd.WifiP2pServiceInfo android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, wifiP2pServiceInfo, actionListener);
    }

    public void removeLocalService(Channel channel, WifiP2pServiceInfo wifiP2pServiceInfo, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("removeLocalService", $$robo$$android_net_wifi_p2p_WifiP2pManager$removeLocalService(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.nsd.WifiP2pServiceInfo android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, wifiP2pServiceInfo, actionListener);
    }

    public void clearLocalServices(Channel channel, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("clearLocalServices", $$robo$$android_net_wifi_p2p_WifiP2pManager$clearLocalServices(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, actionListener);
    }

    public void setServiceResponseListener(Channel channel, ServiceResponseListener serviceResponseListener) {
        InvokeDynamicSupport.bootstrap("setServiceResponseListener", $$robo$$android_net_wifi_p2p_WifiP2pManager$setServiceResponseListener(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ServiceResponseListener ), 0, this, channel, serviceResponseListener);
    }

    public void setDnsSdResponseListeners(Channel channel, DnsSdServiceResponseListener dnsSdServiceResponseListener, DnsSdTxtRecordListener dnsSdTxtRecordListener) {
        InvokeDynamicSupport.bootstrap("setDnsSdResponseListeners", $$robo$$android_net_wifi_p2p_WifiP2pManager$setDnsSdResponseListeners(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$DnsSdServiceResponseListener android.net.wifi.p2p.WifiP2pManager$DnsSdTxtRecordListener ), 0, this, channel, dnsSdServiceResponseListener, dnsSdTxtRecordListener);
    }

    public void setUpnpServiceResponseListener(Channel channel, UpnpServiceResponseListener upnpServiceResponseListener) {
        InvokeDynamicSupport.bootstrap("setUpnpServiceResponseListener", $$robo$$android_net_wifi_p2p_WifiP2pManager$setUpnpServiceResponseListener(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$UpnpServiceResponseListener ), 0, this, channel, upnpServiceResponseListener);
    }

    public void discoverServices(Channel channel, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("discoverServices", $$robo$$android_net_wifi_p2p_WifiP2pManager$discoverServices(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, actionListener);
    }

    public void addServiceRequest(Channel channel, WifiP2pServiceRequest wifiP2pServiceRequest, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("addServiceRequest", $$robo$$android_net_wifi_p2p_WifiP2pManager$addServiceRequest(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.nsd.WifiP2pServiceRequest android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, wifiP2pServiceRequest, actionListener);
    }

    public void removeServiceRequest(Channel channel, WifiP2pServiceRequest wifiP2pServiceRequest, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("removeServiceRequest", $$robo$$android_net_wifi_p2p_WifiP2pManager$removeServiceRequest(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.nsd.WifiP2pServiceRequest android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, wifiP2pServiceRequest, actionListener);
    }

    public void clearServiceRequests(Channel channel, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("clearServiceRequests", $$robo$$android_net_wifi_p2p_WifiP2pManager$clearServiceRequests(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, actionListener);
    }

    public void requestPeers(Channel channel, PeerListListener peerListListener) {
        InvokeDynamicSupport.bootstrap("requestPeers", $$robo$$android_net_wifi_p2p_WifiP2pManager$requestPeers(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$PeerListListener ), 0, this, channel, peerListListener);
    }

    public void requestConnectionInfo(Channel channel, ConnectionInfoListener connectionInfoListener) {
        InvokeDynamicSupport.bootstrap("requestConnectionInfo", $$robo$$android_net_wifi_p2p_WifiP2pManager$requestConnectionInfo(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$ConnectionInfoListener ), 0, this, channel, connectionInfoListener);
    }

    public void requestGroupInfo(Channel channel, GroupInfoListener groupInfoListener) {
        InvokeDynamicSupport.bootstrap("requestGroupInfo", $$robo$$android_net_wifi_p2p_WifiP2pManager$requestGroupInfo(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$GroupInfoListener ), 0, this, channel, groupInfoListener);
    }

    public void setDeviceName(Channel channel, String string2, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("setDeviceName", $$robo$$android_net_wifi_p2p_WifiP2pManager$setDeviceName(android.net.wifi.p2p.WifiP2pManager$Channel java.lang.String android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, string2, actionListener);
    }

    public void setWFDInfo(Channel channel, WifiP2pWfdInfo wifiP2pWfdInfo, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("setWFDInfo", $$robo$$android_net_wifi_p2p_WifiP2pManager$setWFDInfo(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pWfdInfo android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, wifiP2pWfdInfo, actionListener);
    }

    public void deletePersistentGroup(Channel channel, int n, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("deletePersistentGroup", $$robo$$android_net_wifi_p2p_WifiP2pManager$deletePersistentGroup(android.net.wifi.p2p.WifiP2pManager$Channel int android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, n, actionListener);
    }

    public void requestPersistentGroupInfo(Channel channel, PersistentGroupInfoListener persistentGroupInfoListener) {
        InvokeDynamicSupport.bootstrap("requestPersistentGroupInfo", $$robo$$android_net_wifi_p2p_WifiP2pManager$requestPersistentGroupInfo(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$PersistentGroupInfoListener ), 0, this, channel, persistentGroupInfoListener);
    }

    public void setMiracastMode(int n) {
        InvokeDynamicSupport.bootstrap("setMiracastMode", $$robo$$android_net_wifi_p2p_WifiP2pManager$setMiracastMode(int ), 0, this, n);
    }

    public Messenger getMessenger(Binder binder) {
        return InvokeDynamicSupport.bootstrap("getMessenger", $$robo$$android_net_wifi_p2p_WifiP2pManager$getMessenger(android.os.Binder ), 0, this, binder);
    }

    public Messenger getP2pStateMachineMessenger() {
        return InvokeDynamicSupport.bootstrap("getP2pStateMachineMessenger", $$robo$$android_net_wifi_p2p_WifiP2pManager$getP2pStateMachineMessenger(), 0, this);
    }

    public void getNfcHandoverRequest(Channel channel, HandoverMessageListener handoverMessageListener) {
        InvokeDynamicSupport.bootstrap("getNfcHandoverRequest", $$robo$$android_net_wifi_p2p_WifiP2pManager$getNfcHandoverRequest(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$HandoverMessageListener ), 0, this, channel, handoverMessageListener);
    }

    public void getNfcHandoverSelect(Channel channel, HandoverMessageListener handoverMessageListener) {
        InvokeDynamicSupport.bootstrap("getNfcHandoverSelect", $$robo$$android_net_wifi_p2p_WifiP2pManager$getNfcHandoverSelect(android.net.wifi.p2p.WifiP2pManager$Channel android.net.wifi.p2p.WifiP2pManager$HandoverMessageListener ), 0, this, channel, handoverMessageListener);
    }

    public void initiatorReportNfcHandover(Channel channel, String string2, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("initiatorReportNfcHandover", $$robo$$android_net_wifi_p2p_WifiP2pManager$initiatorReportNfcHandover(android.net.wifi.p2p.WifiP2pManager$Channel java.lang.String android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, string2, actionListener);
    }

    public void responderReportNfcHandover(Channel channel, String string2, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("responderReportNfcHandover", $$robo$$android_net_wifi_p2p_WifiP2pManager$responderReportNfcHandover(android.net.wifi.p2p.WifiP2pManager$Channel java.lang.String android.net.wifi.p2p.WifiP2pManager$ActionListener ), 0, this, channel, string2, actionListener);
    }

    public /* synthetic */ WifiP2pManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Channel
    implements AutoCloseable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int INVALID_LISTENER_KEY = 0;
        private WifiP2pManager mP2pManager;
        private ChannelListener mChannelListener;
        private ServiceResponseListener mServRspListener;
        private DnsSdServiceResponseListener mDnsSdServRspListener;
        private DnsSdTxtRecordListener mDnsSdTxtListener;
        private UpnpServiceResponseListener mUpnpServRspListener;
        private HashMap<Integer, Object> mListenerMap;
        private Object mListenerMapLock;
        private int mListenerKey;
        private CloseGuard mCloseGuard;
        Binder mBinder;
        private AsyncChannel mAsyncChannel;
        private P2pHandler mHandler;
        Context mContext;

        private void $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$__constructor__(Context context, Looper looper, ChannelListener l, Binder binder, WifiP2pManager p2pManager) {
            this.mListenerMap = new HashMap();
            this.mListenerMapLock = new Object();
            this.mListenerKey = 0;
            this.mCloseGuard = CloseGuard.get();
            this.mAsyncChannel = new AsyncChannel();
            this.mHandler = new P2pHandler(this, looper);
            this.mChannelListener = l;
            this.mContext = context;
            this.mBinder = binder;
            this.mP2pManager = p2pManager;
            this.mCloseGuard.open("close");
        }

        private final void $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$close() {
            if (this.mP2pManager == null) {
                Log.w("WifiP2pManager", "Channel.close(): Null mP2pManager!?");
            } else {
                try {
                    this.mP2pManager.mService.close(this.mBinder);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mAsyncChannel.disconnect();
            this.mCloseGuard.close();
        }

        private final void $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private final void $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$handleServiceResponse(WifiP2pServiceResponse resp) {
            if (resp instanceof WifiP2pDnsSdServiceResponse) {
                this.handleDnsSdServiceResponse((WifiP2pDnsSdServiceResponse)resp);
            } else if (resp instanceof WifiP2pUpnpServiceResponse) {
                if (this.mUpnpServRspListener != null) {
                    this.handleUpnpServiceResponse((WifiP2pUpnpServiceResponse)resp);
                }
            } else if (this.mServRspListener != null) {
                this.mServRspListener.onServiceAvailable(resp.getServiceType(), resp.getRawData(), resp.getSrcDevice());
            }
        }

        private final void $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$handleUpnpServiceResponse(WifiP2pUpnpServiceResponse resp) {
            this.mUpnpServRspListener.onUpnpServiceAvailable(resp.getUniqueServiceNames(), resp.getSrcDevice());
        }

        private final void $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$handleDnsSdServiceResponse(WifiP2pDnsSdServiceResponse resp) {
            if (resp.getDnsType() == 12) {
                if (this.mDnsSdServRspListener != null) {
                    this.mDnsSdServRspListener.onDnsSdServiceAvailable(resp.getInstanceName(), resp.getDnsQueryName(), resp.getSrcDevice());
                }
            } else if (resp.getDnsType() == 16) {
                if (this.mDnsSdTxtListener != null) {
                    this.mDnsSdTxtListener.onDnsSdTxtRecordAvailable(resp.getDnsQueryName(), resp.getTxtRecord(), resp.getSrcDevice());
                }
            } else {
                Log.e("WifiP2pManager", "Unhandled resp " + resp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$putListener(Object listener) {
            int key;
            if (listener == null) {
                return 0;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                do {
                    ++this.mListenerKey;
                } while (key == 0);
                this.mListenerMap.put(key, listener);
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Object $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$getListener(int key) {
            if (key == 0) {
                return null;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                return this.mListenerMap.remove(key);
            }
        }

        private void __constructor__(Context context, Looper looper, ChannelListener channelListener, Binder binder, WifiP2pManager wifiP2pManager) {
            this.$$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$__constructor__(context, looper, channelListener, binder, wifiP2pManager);
        }

        public Channel(Context context, Looper looper, ChannelListener channelListener, Binder binder, WifiP2pManager wifiP2pManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$__constructor__(android.content.Context android.os.Looper android.net.wifi.p2p.WifiP2pManager$ChannelListener android.os.Binder android.net.wifi.p2p.WifiP2pManager ), 0, this, context, looper, channelListener, binder, wifiP2pManager);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$close(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$finalize(), 0, this);
        }

        private void handleServiceResponse(WifiP2pServiceResponse wifiP2pServiceResponse) {
            InvokeDynamicSupport.bootstrap("handleServiceResponse", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$handleServiceResponse(android.net.wifi.p2p.nsd.WifiP2pServiceResponse ), 0, this, wifiP2pServiceResponse);
        }

        private void handleUpnpServiceResponse(WifiP2pUpnpServiceResponse wifiP2pUpnpServiceResponse) {
            InvokeDynamicSupport.bootstrap("handleUpnpServiceResponse", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$handleUpnpServiceResponse(android.net.wifi.p2p.nsd.WifiP2pUpnpServiceResponse ), 0, this, wifiP2pUpnpServiceResponse);
        }

        private void handleDnsSdServiceResponse(WifiP2pDnsSdServiceResponse wifiP2pDnsSdServiceResponse) {
            InvokeDynamicSupport.bootstrap("handleDnsSdServiceResponse", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$handleDnsSdServiceResponse(android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceResponse ), 0, this, wifiP2pDnsSdServiceResponse);
        }

        private int putListener(Object object) {
            return (int)InvokeDynamicSupport.bootstrap("putListener", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$putListener(java.lang.Object ), 0, this, object);
        }

        private Object getListener(int n) {
            return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel$getListener(int ), 0, this, n);
        }

        public /* synthetic */ Channel() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Channel)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public class P2pHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Channel this$0;

            private void $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel_P2pHandler$__constructor__(Channel this$0, Looper looper) {
            }

            private final void $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel_P2pHandler$handleMessage(Message message) {
                Object listener = this.this$0.getListener(message.arg2);
                switch (message.what) {
                    case 69636: {
                        if (this.this$0.mChannelListener == null) break;
                        this.this$0.mChannelListener.onChannelDisconnected();
                        this.this$0.mChannelListener = null;
                        break;
                    }
                    case 139266: 
                    case 139269: 
                    case 139272: 
                    case 139275: 
                    case 139278: 
                    case 139281: 
                    case 139293: 
                    case 139296: 
                    case 139299: 
                    case 139302: 
                    case 139305: 
                    case 139308: 
                    case 139311: 
                    case 139316: 
                    case 139319: 
                    case 139324: 
                    case 139327: 
                    case 139330: 
                    case 139333: 
                    case 139336: 
                    case 139345: {
                        if (listener == null) break;
                        ((ActionListener)listener).onFailure(message.arg1);
                        break;
                    }
                    case 139267: 
                    case 139270: 
                    case 139273: 
                    case 139276: 
                    case 139279: 
                    case 139282: 
                    case 139294: 
                    case 139297: 
                    case 139300: 
                    case 139303: 
                    case 139306: 
                    case 139309: 
                    case 139312: 
                    case 139317: 
                    case 139320: 
                    case 139325: 
                    case 139328: 
                    case 139331: 
                    case 139334: 
                    case 139337: 
                    case 139344: {
                        if (listener == null) break;
                        ((ActionListener)listener).onSuccess();
                        break;
                    }
                    case 139284: {
                        WifiP2pDeviceList peers = (WifiP2pDeviceList)message.obj;
                        if (listener == null) break;
                        ((PeerListListener)listener).onPeersAvailable(peers);
                        break;
                    }
                    case 139286: {
                        WifiP2pInfo wifiP2pInfo = (WifiP2pInfo)message.obj;
                        if (listener == null) break;
                        ((ConnectionInfoListener)listener).onConnectionInfoAvailable(wifiP2pInfo);
                        break;
                    }
                    case 139288: {
                        WifiP2pGroup group = (WifiP2pGroup)message.obj;
                        if (listener == null) break;
                        ((GroupInfoListener)listener).onGroupInfoAvailable(group);
                        break;
                    }
                    case 139314: {
                        WifiP2pServiceResponse resp = (WifiP2pServiceResponse)message.obj;
                        this.this$0.handleServiceResponse(resp);
                        break;
                    }
                    case 139322: {
                        WifiP2pGroupList groups = (WifiP2pGroupList)message.obj;
                        if (listener == null) break;
                        ((PersistentGroupInfoListener)listener).onPersistentGroupInfoAvailable(groups);
                        break;
                    }
                    case 139341: {
                        Bundle handoverBundle = (Bundle)message.obj;
                        if (listener == null) break;
                        String handoverMessage = handoverBundle != null ? handoverBundle.getString("android.net.wifi.p2p.EXTRA_HANDOVER_MESSAGE") : null;
                        ((HandoverMessageListener)listener).onHandoverMessageAvailable(handoverMessage);
                        break;
                    }
                    default: {
                        Log.d("WifiP2pManager", "Ignored " + message);
                    }
                }
            }

            private void __constructor__(Channel channel, Looper looper) {
                this.$$robo$$android_net_wifi_p2p_WifiP2pManager_Channel_P2pHandler$__constructor__(channel, looper);
            }

            P2pHandler(Channel channel, Looper looper) {
                this.this$0 = channel;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel_P2pHandler$__constructor__(android.net.wifi.p2p.WifiP2pManager$Channel android.os.Looper ), 0, this, channel, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_p2p_WifiP2pManager_Channel_P2pHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ P2pHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (P2pHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static interface HandoverMessageListener
    extends InstrumentedInterface {
        public void onHandoverMessageAvailable(String var1);
    }

    public static interface PersistentGroupInfoListener
    extends InstrumentedInterface {
        public void onPersistentGroupInfoAvailable(WifiP2pGroupList var1);
    }

    public static interface UpnpServiceResponseListener
    extends InstrumentedInterface {
        public void onUpnpServiceAvailable(List<String> var1, WifiP2pDevice var2);
    }

    public static interface DnsSdTxtRecordListener
    extends InstrumentedInterface {
        public void onDnsSdTxtRecordAvailable(String var1, Map<String, String> var2, WifiP2pDevice var3);
    }

    public static interface DnsSdServiceResponseListener
    extends InstrumentedInterface {
        public void onDnsSdServiceAvailable(String var1, String var2, WifiP2pDevice var3);
    }

    public static interface ServiceResponseListener
    extends InstrumentedInterface {
        public void onServiceAvailable(int var1, byte[] var2, WifiP2pDevice var3);
    }

    public static interface GroupInfoListener
    extends InstrumentedInterface {
        public void onGroupInfoAvailable(WifiP2pGroup var1);
    }

    public static interface ConnectionInfoListener
    extends InstrumentedInterface {
        public void onConnectionInfoAvailable(WifiP2pInfo var1);
    }

    public static interface PeerListListener
    extends InstrumentedInterface {
        public void onPeersAvailable(WifiP2pDeviceList var1);
    }

    public static interface ActionListener
    extends InstrumentedInterface {
        public void onSuccess();

        public void onFailure(int var1);
    }

    public static interface ChannelListener
    extends InstrumentedInterface {
        public void onChannelDisconnected();
    }
}

