/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.OnActivityPausedListener;
import android.app.PendingIntent;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.net.Uri;
import android.nfc.BeamShareData;
import android.nfc.INfcAdapter;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcCardEmulation;
import android.nfc.INfcDta;
import android.nfc.INfcFCardEmulation;
import android.nfc.INfcTag;
import android.nfc.INfcUnlockHandler;
import android.nfc.ITagRemovedCallback;
import android.nfc.NdefMessage;
import android.nfc.NfcActivityManager;
import android.nfc.NfcEvent;
import android.nfc.NfcManager;
import android.nfc.Tag;
import android.nfc.TechListParcel;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class NfcAdapter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "NFC";
    public static String ACTION_NDEF_DISCOVERED = "android.nfc.action.NDEF_DISCOVERED";
    public static String ACTION_TECH_DISCOVERED = "android.nfc.action.TECH_DISCOVERED";
    public static String ACTION_TAG_DISCOVERED = "android.nfc.action.TAG_DISCOVERED";
    public static String ACTION_TAG_LEFT_FIELD = "android.nfc.action.TAG_LOST";
    public static String EXTRA_TAG = "android.nfc.extra.TAG";
    public static String EXTRA_NDEF_MESSAGES = "android.nfc.extra.NDEF_MESSAGES";
    public static String EXTRA_ID = "android.nfc.extra.ID";
    public static String ACTION_ADAPTER_STATE_CHANGED = "android.nfc.action.ADAPTER_STATE_CHANGED";
    public static String EXTRA_ADAPTER_STATE = "android.nfc.extra.ADAPTER_STATE";
    public static int STATE_OFF = 1;
    public static int STATE_TURNING_ON = 2;
    public static int STATE_ON = 3;
    public static int STATE_TURNING_OFF = 4;
    public static int FLAG_READER_NFC_A = 1;
    public static int FLAG_READER_NFC_B = 2;
    public static int FLAG_READER_NFC_F = 4;
    public static int FLAG_READER_NFC_V = 8;
    public static int FLAG_READER_NFC_BARCODE = 16;
    public static int FLAG_READER_SKIP_NDEF_CHECK = 128;
    public static int FLAG_READER_NO_PLATFORM_SOUNDS = 256;
    public static String EXTRA_READER_PRESENCE_CHECK_DELAY = "presence";
    public static int FLAG_NDEF_PUSH_NO_CONFIRM = 1;
    public static String ACTION_HANDOVER_TRANSFER_STARTED = "android.nfc.action.HANDOVER_TRANSFER_STARTED";
    public static String ACTION_HANDOVER_TRANSFER_DONE = "android.nfc.action.HANDOVER_TRANSFER_DONE";
    public static String EXTRA_HANDOVER_TRANSFER_STATUS = "android.nfc.extra.HANDOVER_TRANSFER_STATUS";
    public static int HANDOVER_TRANSFER_STATUS_SUCCESS = 0;
    public static int HANDOVER_TRANSFER_STATUS_FAILURE = 1;
    public static String EXTRA_HANDOVER_TRANSFER_URI = "android.nfc.extra.HANDOVER_TRANSFER_URI";
    static boolean sIsInitialized;
    static boolean sHasNfcFeature;
    static INfcAdapter sService;
    static INfcTag sTagService;
    static INfcCardEmulation sCardEmulationService;
    static INfcFCardEmulation sNfcFCardEmulationService;
    static HashMap<Context, NfcAdapter> sNfcAdapters;
    static NfcAdapter sNullContextNfcAdapter;
    NfcActivityManager mNfcActivityManager;
    Context mContext;
    HashMap<NfcUnlockHandler, INfcUnlockHandler> mNfcUnlockHandlers;
    Object mLock;
    ITagRemovedCallback mTagRemovedListener;
    OnActivityPausedListener mForegroundDispatchListener;

    private static final boolean $$robo$$android_nfc_NfcAdapter$hasNfcFeature() {
        IPackageManager pm = ActivityThread.getPackageManager();
        if (pm == null) {
            Log.e("NFC", "Cannot get package manager, assuming no NFC feature");
            return false;
        }
        try {
            return pm.hasSystemFeature("android.hardware.nfc", 0);
        }
        catch (RemoteException e) {
            Log.e("NFC", "Package manager query failed, assuming no NFC feature", e);
            return false;
        }
    }

    private static final boolean $$robo$$android_nfc_NfcAdapter$hasNfcHceFeature() {
        IPackageManager pm = ActivityThread.getPackageManager();
        if (pm == null) {
            Log.e("NFC", "Cannot get package manager, assuming no NFC feature");
            return false;
        }
        try {
            return pm.hasSystemFeature("android.hardware.nfc.hce", 0) || pm.hasSystemFeature("android.hardware.nfc.hcef", 0);
        }
        catch (RemoteException e) {
            Log.e("NFC", "Package manager query failed, assuming no NFC feature", e);
            return false;
        }
    }

    private static final synchronized NfcAdapter $$robo$$android_nfc_NfcAdapter$getNfcAdapter(Context context) {
        if (!sIsInitialized) {
            sHasNfcFeature = NfcAdapter.hasNfcFeature();
            boolean hasHceFeature = NfcAdapter.hasNfcHceFeature();
            if (!sHasNfcFeature && !hasHceFeature) {
                Log.v("NFC", "this device does not have NFC support");
                throw new UnsupportedOperationException();
            }
            sService = NfcAdapter.getServiceInterface();
            if (sService == null) {
                Log.e("NFC", "could not retrieve NFC service");
                throw new UnsupportedOperationException();
            }
            if (sHasNfcFeature) {
                try {
                    sTagService = sService.getNfcTagInterface();
                }
                catch (RemoteException e) {
                    Log.e("NFC", "could not retrieve NFC Tag service");
                    throw new UnsupportedOperationException();
                }
            }
            if (hasHceFeature) {
                try {
                    sNfcFCardEmulationService = sService.getNfcFCardEmulationInterface();
                }
                catch (RemoteException e) {
                    Log.e("NFC", "could not retrieve NFC-F card emulation service");
                    throw new UnsupportedOperationException();
                }
                try {
                    sCardEmulationService = sService.getNfcCardEmulationInterface();
                }
                catch (RemoteException e) {
                    Log.e("NFC", "could not retrieve card emulation service");
                    throw new UnsupportedOperationException();
                }
            }
            sIsInitialized = true;
        }
        if (context == null) {
            if (sNullContextNfcAdapter == null) {
                sNullContextNfcAdapter = new NfcAdapter(null);
            }
            return sNullContextNfcAdapter;
        }
        NfcAdapter adapter = sNfcAdapters.get(context);
        if (adapter == null) {
            adapter = new NfcAdapter(context);
            sNfcAdapters.put(context, adapter);
        }
        return adapter;
    }

    private static final INfcAdapter $$robo$$android_nfc_NfcAdapter$getServiceInterface() {
        IBinder b = ServiceManager.getService("nfc");
        if (b == null) {
            return null;
        }
        return INfcAdapter.Stub.asInterface(b);
    }

    private static final NfcAdapter $$robo$$android_nfc_NfcAdapter$getDefaultAdapter(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if ((context = context.getApplicationContext()) == null) {
            throw new IllegalArgumentException("context not associated with any application (using a mock context?)");
        }
        NfcManager manager = (NfcManager)context.getSystemService("nfc");
        if (manager == null) {
            return null;
        }
        return manager.getDefaultAdapter();
    }

    @Deprecated
    private static final NfcAdapter $$robo$$android_nfc_NfcAdapter$getDefaultAdapter() {
        Log.w("NFC", "WARNING: NfcAdapter.getDefaultAdapter() is deprecated, use NfcAdapter.getDefaultAdapter(Context) instead", new Exception());
        return NfcAdapter.getNfcAdapter(null);
    }

    private void $$robo$$android_nfc_NfcAdapter$__constructor__(Context context) {
        this.mForegroundDispatchListener = new OnActivityPausedListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ NfcAdapter this$0;

            private void $$robo$$android_nfc_NfcAdapter_1$__constructor__(NfcAdapter this$0) {
            }

            private final void $$robo$$android_nfc_NfcAdapter_1$onPaused(Activity activity) {
                this.this$0.disableForegroundDispatchInternal(activity, true);
            }

            private void __constructor__(NfcAdapter nfcAdapter) {
                this.$$robo$$android_nfc_NfcAdapter_1$__constructor__(nfcAdapter);
            }
            {
                this.this$0 = nfcAdapter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NfcAdapter_1$__constructor__(android.nfc.NfcAdapter ), 0, this, nfcAdapter);
            }

            @Override
            public void onPaused(Activity activity) {
                InvokeDynamicSupport.bootstrap("onPaused", $$robo$$android_nfc_NfcAdapter_1$onPaused(android.app.Activity ), 0, this, activity);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mNfcActivityManager = new NfcActivityManager(this);
        this.mNfcUnlockHandlers = new HashMap();
        this.mTagRemovedListener = null;
        this.mLock = new Object();
    }

    private final Context $$robo$$android_nfc_NfcAdapter$getContext() {
        return this.mContext;
    }

    private final INfcAdapter $$robo$$android_nfc_NfcAdapter$getService() {
        this.isEnabled();
        return sService;
    }

    private final INfcTag $$robo$$android_nfc_NfcAdapter$getTagService() {
        this.isEnabled();
        return sTagService;
    }

    private final INfcCardEmulation $$robo$$android_nfc_NfcAdapter$getCardEmulationService() {
        this.isEnabled();
        return sCardEmulationService;
    }

    private final INfcFCardEmulation $$robo$$android_nfc_NfcAdapter$getNfcFCardEmulationService() {
        this.isEnabled();
        return sNfcFCardEmulationService;
    }

    private final INfcDta $$robo$$android_nfc_NfcAdapter$getNfcDtaInterface() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  NFC extras APIs");
        }
        try {
            return sService.getNfcDtaInterface(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return null;
        }
    }

    private final void $$robo$$android_nfc_NfcAdapter$attemptDeadServiceRecovery(Exception e) {
        Log.e("NFC", "NFC service dead - attempting to recover", e);
        INfcAdapter service = NfcAdapter.getServiceInterface();
        if (service == null) {
            Log.e("NFC", "could not retrieve NFC service during service recovery");
            return;
        }
        sService = service;
        try {
            sTagService = service.getNfcTagInterface();
        }
        catch (RemoteException ee) {
            Log.e("NFC", "could not retrieve NFC tag service during service recovery");
            return;
        }
        try {
            sCardEmulationService = service.getNfcCardEmulationInterface();
        }
        catch (RemoteException ee) {
            Log.e("NFC", "could not retrieve NFC card emulation service during service recovery");
        }
        try {
            sNfcFCardEmulationService = service.getNfcFCardEmulationInterface();
        }
        catch (RemoteException ee) {
            Log.e("NFC", "could not retrieve NFC-F card emulation service during service recovery");
        }
    }

    private final boolean $$robo$$android_nfc_NfcAdapter$isEnabled() {
        try {
            return sService.getState() == 3;
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    private final int $$robo$$android_nfc_NfcAdapter$getAdapterState() {
        try {
            return sService.getState();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return 1;
        }
    }

    private final boolean $$robo$$android_nfc_NfcAdapter$enable() {
        try {
            return sService.enable();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    private final boolean $$robo$$android_nfc_NfcAdapter$disable() {
        try {
            return sService.disable(true);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    private final boolean $$robo$$android_nfc_NfcAdapter$disable(boolean persist) {
        try {
            return sService.disable(persist);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    private final void $$robo$$android_nfc_NfcAdapter$pausePolling(int timeoutInMs) {
        try {
            sService.pausePolling(timeoutInMs);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    private final void $$robo$$android_nfc_NfcAdapter$resumePolling() {
        try {
            sService.resumePolling();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$setBeamPushUris(Uri[] uris, Activity activity) {
        Uri[] uriArray = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (activity == null) {
                throw new NullPointerException("activity cannot be null");
            }
            if (uris != null) {
                for (Uri uri : uris) {
                    if (uri == null) {
                        throw new NullPointerException("Uri not allowed to be null");
                    }
                    String scheme = uri.getScheme();
                    if (scheme != null && (scheme.equalsIgnoreCase("file") || scheme.equalsIgnoreCase("content"))) continue;
                    throw new IllegalArgumentException("URI needs to have either scheme file or scheme content");
                }
            }
            this.mNfcActivityManager.setNdefPushContentUri(activity, uris);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$setBeamPushUrisCallback(CreateBeamUrisCallback callback, Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (activity == null) {
                throw new NullPointerException("activity cannot be null");
            }
            this.mNfcActivityManager.setNdefPushContentUriCallback(activity, callback);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$setNdefPushMessage(NdefMessage message, Activity activity, Activity ... activities) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            int targetSdkVersion = this.getSdkVersion();
            try {
                if (activity == null) {
                    throw new NullPointerException("activity cannot be null");
                }
                this.mNfcActivityManager.setNdefPushMessage(activity, message, 0);
                for (Activity a : activities) {
                    if (a == null) {
                        throw new NullPointerException("activities cannot contain null");
                    }
                    this.mNfcActivityManager.setNdefPushMessage(a, message, 0);
                }
            }
            catch (IllegalStateException e) {
                if (targetSdkVersion < 16) {
                    Log.e("NFC", "Cannot call API with Activity that has already been destroyed", e);
                }
                throw e;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$setNdefPushMessage(NdefMessage message, Activity activity, int flags) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (activity == null) {
                throw new NullPointerException("activity cannot be null");
            }
            this.mNfcActivityManager.setNdefPushMessage(activity, message, flags);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$setNdefPushMessageCallback(CreateNdefMessageCallback callback, Activity activity, Activity ... activities) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            int targetSdkVersion = this.getSdkVersion();
            try {
                if (activity == null) {
                    throw new NullPointerException("activity cannot be null");
                }
                this.mNfcActivityManager.setNdefPushMessageCallback(activity, callback, 0);
                for (Activity a : activities) {
                    if (a == null) {
                        throw new NullPointerException("activities cannot contain null");
                    }
                    this.mNfcActivityManager.setNdefPushMessageCallback(a, callback, 0);
                }
            }
            catch (IllegalStateException e) {
                if (targetSdkVersion < 16) {
                    Log.e("NFC", "Cannot call API with Activity that has already been destroyed", e);
                }
                throw e;
            }
            return;
        }
    }

    private final void $$robo$$android_nfc_NfcAdapter$setNdefPushMessageCallback(CreateNdefMessageCallback callback, Activity activity, int flags) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        this.mNfcActivityManager.setNdefPushMessageCallback(activity, callback, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$setOnNdefPushCompleteCallback(OnNdefPushCompleteCallback callback, Activity activity, Activity ... activities) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            int targetSdkVersion = this.getSdkVersion();
            try {
                if (activity == null) {
                    throw new NullPointerException("activity cannot be null");
                }
                this.mNfcActivityManager.setOnNdefPushCompleteCallback(activity, callback);
                for (Activity a : activities) {
                    if (a == null) {
                        throw new NullPointerException("activities cannot contain null");
                    }
                    this.mNfcActivityManager.setOnNdefPushCompleteCallback(a, callback);
                }
            }
            catch (IllegalStateException e) {
                if (targetSdkVersion < 16) {
                    Log.e("NFC", "Cannot call API with Activity that has already been destroyed", e);
                }
                throw e;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$enableForegroundDispatch(Activity activity, PendingIntent intent, IntentFilter[] filters, String[][] techLists) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (activity == null || intent == null) {
                throw new NullPointerException();
            }
            if (!activity.isResumed()) {
                throw new IllegalStateException("Foreground dispatch can only be enabled when your activity is resumed");
            }
            try {
                TechListParcel parcel = null;
                if (techLists != null && techLists.length > 0) {
                    parcel = new TechListParcel(techLists);
                }
                ActivityThread.currentActivityThread().registerOnActivityPausedListener(activity, this.mForegroundDispatchListener);
                sService.setForegroundDispatch(intent, filters, parcel);
            }
            catch (RemoteException e) {
                this.attemptDeadServiceRecovery(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$disableForegroundDispatch(Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ActivityThread.currentActivityThread().unregisterOnActivityPausedListener(activity, this.mForegroundDispatchListener);
            this.disableForegroundDispatchInternal(activity, false);
            return;
        }
    }

    private final void $$robo$$android_nfc_NfcAdapter$disableForegroundDispatchInternal(Activity activity, boolean force) {
        try {
            sService.setForegroundDispatch(null, null, null);
            if (!force && !activity.isResumed()) {
                throw new IllegalStateException("You must disable foreground dispatching while your activity is still resumed");
            }
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$enableReaderMode(Activity activity, ReaderCallback callback, int flags, Bundle extras) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.mNfcActivityManager.enableReaderMode(activity, callback, flags, extras);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcAdapter$disableReaderMode(Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mNfcActivityManager.disableReaderMode(activity);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_nfc_NfcAdapter$invokeBeam(Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (activity == null) {
                throw new NullPointerException("activity may not be null.");
            }
            this.enforceResumed(activity);
            try {
                sService.invokeBeam();
                return true;
            }
            catch (RemoteException e) {
                Log.e("NFC", "invokeBeam: NFC process has died.");
                this.attemptDeadServiceRecovery(e);
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_NfcAdapter$invokeBeam(BeamShareData shareData) {
        try {
            Log.e("NFC", "invokeBeamInternal()");
            sService.invokeBeamInternal(shareData);
            return true;
        }
        catch (RemoteException e) {
            Log.e("NFC", "invokeBeam: NFC process has died.");
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final void $$robo$$android_nfc_NfcAdapter$enableForegroundNdefPush(Activity activity, NdefMessage message) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (activity == null || message == null) {
                throw new NullPointerException();
            }
            this.enforceResumed(activity);
            this.mNfcActivityManager.setNdefPushMessage(activity, message, 0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final void $$robo$$android_nfc_NfcAdapter$disableForegroundNdefPush(Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (activity == null) {
                throw new NullPointerException();
            }
            this.enforceResumed(activity);
            this.mNfcActivityManager.setNdefPushMessage(activity, null, 0);
            this.mNfcActivityManager.setNdefPushMessageCallback(activity, null, 0);
            this.mNfcActivityManager.setOnNdefPushCompleteCallback(activity, null);
            return;
        }
    }

    private final boolean $$robo$$android_nfc_NfcAdapter$enableNdefPush() {
        if (!sHasNfcFeature) {
            throw new UnsupportedOperationException();
        }
        try {
            return sService.enableNdefPush();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_nfc_NfcAdapter$disableNdefPush() {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                return sService.disableNdefPush();
            }
            catch (RemoteException e) {
                this.attemptDeadServiceRecovery(e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_nfc_NfcAdapter$isNdefPushEnabled() {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                return sService.isNdefPushEnabled();
            }
            catch (RemoteException e) {
                this.attemptDeadServiceRecovery(e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_nfc_NfcAdapter$ignore(Tag tag, int debounceMs, OnTagRemovedListener tagRemovedListener, Handler handler) {
        ShadowedObject iListener = null;
        if (tagRemovedListener != null) {
            iListener = new ShadowedObject(this, handler, tagRemovedListener){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Handler val$handler;
                /* synthetic */ OnTagRemovedListener val$tagRemovedListener;
                /* synthetic */ NfcAdapter this$0;

                private void $$robo$$android_nfc_NfcAdapter_2$__constructor__(NfcAdapter this$0, Handler handler, OnTagRemovedListener onTagRemovedListener) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_nfc_NfcAdapter_2$onTagRemoved() throws RemoteException {
                    if (this.val$handler != null) {
                        this.val$handler.post(new Runnable(this){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ 2 this$1;

                            private void $$robo$$android_nfc_NfcAdapter_2_1$__constructor__(2 this$1) {
                            }

                            private final void $$robo$$android_nfc_NfcAdapter_2_1$run() {
                                this.this$1.val$tagRemovedListener.onTagRemoved();
                            }

                            private void __constructor__(2 var1_1) {
                                this.$$robo$$android_nfc_NfcAdapter_2_1$__constructor__(var1_1);
                            }
                            {
                                this.this$1 = var1_1;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NfcAdapter_2_1$__constructor__(android.nfc.NfcAdapter$2 ), 0, this, var1_1);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_nfc_NfcAdapter_2_1$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    } else {
                        this.val$tagRemovedListener.onTagRemoved();
                    }
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        this.this$0.mTagRemovedListener = null;
                    }
                }

                private void __constructor__(NfcAdapter nfcAdapter, Handler handler, OnTagRemovedListener onTagRemovedListener) {
                    this.$$robo$$android_nfc_NfcAdapter_2$__constructor__(nfcAdapter, handler, onTagRemovedListener);
                }
                {
                    this.this$0 = nfcAdapter;
                    this.val$handler = handler;
                    this.val$tagRemovedListener = onTagRemovedListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NfcAdapter_2$__constructor__(android.nfc.NfcAdapter android.os.Handler android.nfc.NfcAdapter$OnTagRemovedListener ), 0, this, nfcAdapter, handler, onTagRemovedListener);
                }

                @Override
                public void onTagRemoved() throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onTagRemoved", $$robo$$android_nfc_NfcAdapter_2$onTagRemoved(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mTagRemovedListener = iListener;
        }
        try {
            return sService.ignore(tag.getServiceHandle(), debounceMs, (ITagRemovedCallback)iListener);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final void $$robo$$android_nfc_NfcAdapter$dispatch(Tag tag) {
        if (tag == null) {
            throw new NullPointerException("tag cannot be null");
        }
        try {
            sService.dispatch(tag);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    private final void $$robo$$android_nfc_NfcAdapter$setP2pModes(int initiatorModes, int targetModes) {
        try {
            sService.setP2pModes(initiatorModes, targetModes);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_nfc_NfcAdapter$addNfcUnlockHandler(NfcUnlockHandler unlockHandler, String[] tagTechnologies) {
        Object object = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (tagTechnologies.length == 0) {
                return false;
            }
            try {
                object = this.mLock;
                synchronized (object) {
                    if (this.mNfcUnlockHandlers.containsKey(unlockHandler)) {
                        sService.removeNfcUnlockHandler(this.mNfcUnlockHandlers.get(unlockHandler));
                        this.mNfcUnlockHandlers.remove(unlockHandler);
                    }
                    ShadowedObject iHandler = new ShadowedObject(this, unlockHandler){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ NfcUnlockHandler val$unlockHandler;
                        /* synthetic */ NfcAdapter this$0;

                        private void $$robo$$android_nfc_NfcAdapter_3$__constructor__(NfcAdapter this$0, NfcUnlockHandler nfcUnlockHandler) {
                        }

                        private final boolean $$robo$$android_nfc_NfcAdapter_3$onUnlockAttempted(Tag tag) throws RemoteException {
                            return this.val$unlockHandler.onUnlockAttempted(tag);
                        }

                        private void __constructor__(NfcAdapter nfcAdapter, NfcUnlockHandler nfcUnlockHandler) {
                            this.$$robo$$android_nfc_NfcAdapter_3$__constructor__(nfcAdapter, nfcUnlockHandler);
                        }
                        {
                            this.this$0 = nfcAdapter;
                            this.val$unlockHandler = nfcUnlockHandler;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NfcAdapter_3$__constructor__(android.nfc.NfcAdapter android.nfc.NfcAdapter$NfcUnlockHandler ), 0, this, nfcAdapter, nfcUnlockHandler);
                        }

                        @Override
                        public boolean onUnlockAttempted(Tag tag) throws RemoteException {
                            return (boolean)InvokeDynamicSupport.bootstrap("onUnlockAttempted", $$robo$$android_nfc_NfcAdapter_3$onUnlockAttempted(android.nfc.Tag ), 0, this, tag);
                        }
                        {
                            this.$$robo$init();
                        }

                        @Override
                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        @Override
                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    sService.addNfcUnlockHandler((INfcUnlockHandler)iHandler, Tag.getTechCodesFromStrings(tagTechnologies));
                    this.mNfcUnlockHandlers.put(unlockHandler, (INfcUnlockHandler)iHandler);
                }
            }
            catch (RemoteException e) {
                this.attemptDeadServiceRecovery(e);
                return false;
            }
            catch (IllegalArgumentException e) {
                Log.e("NFC", "Unable to register LockscreenDispatch", e);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_nfc_NfcAdapter$removeNfcUnlockHandler(NfcUnlockHandler unlockHandler) {
        Object object = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                object = this.mLock;
                synchronized (object) {
                    if (this.mNfcUnlockHandlers.containsKey(unlockHandler)) {
                        sService.removeNfcUnlockHandler(this.mNfcUnlockHandlers.remove(unlockHandler));
                    }
                    return true;
                }
            }
            catch (RemoteException e) {
                this.attemptDeadServiceRecovery(e);
                return false;
            }
        }
    }

    private final INfcAdapterExtras $$robo$$android_nfc_NfcAdapter$getNfcAdapterExtrasInterface() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  NFC extras APIs");
        }
        try {
            return sService.getNfcAdapterExtrasInterface(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return null;
        }
    }

    private final void $$robo$$android_nfc_NfcAdapter$enforceResumed(Activity activity) {
        if (!activity.isResumed()) {
            throw new IllegalStateException("API cannot be called while activity is paused");
        }
    }

    private final int $$robo$$android_nfc_NfcAdapter$getSdkVersion() {
        if (this.mContext == null) {
            return 9;
        }
        return this.mContext.getApplicationInfo().targetSdkVersion;
    }

    static void __staticInitializer__() {
        sIsInitialized = false;
        sNfcAdapters = new HashMap();
    }

    private static boolean hasNfcFeature() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasNfcFeature", $$robo$$android_nfc_NfcAdapter$hasNfcFeature(), 0);
    }

    private static boolean hasNfcHceFeature() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasNfcHceFeature", $$robo$$android_nfc_NfcAdapter$hasNfcHceFeature(), 0);
    }

    public static synchronized NfcAdapter getNfcAdapter(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getNfcAdapter", $$robo$$android_nfc_NfcAdapter$getNfcAdapter(android.content.Context ), 0, (Context)context);
    }

    private static INfcAdapter getServiceInterface() {
        return InvokeDynamicSupport.bootstrapStatic("getServiceInterface", $$robo$$android_nfc_NfcAdapter$getServiceInterface(), 0);
    }

    public static NfcAdapter getDefaultAdapter(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultAdapter", $$robo$$android_nfc_NfcAdapter$getDefaultAdapter(android.content.Context ), 0, (Context)context);
    }

    @Deprecated
    public static NfcAdapter getDefaultAdapter() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultAdapter", $$robo$$android_nfc_NfcAdapter$getDefaultAdapter(), 0);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_nfc_NfcAdapter$__constructor__(context);
    }

    NfcAdapter(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NfcAdapter$__constructor__(android.content.Context ), 0, this, context);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_nfc_NfcAdapter$getContext(), 0, this);
    }

    public INfcAdapter getService() {
        return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_nfc_NfcAdapter$getService(), 0, this);
    }

    public INfcTag getTagService() {
        return InvokeDynamicSupport.bootstrap("getTagService", $$robo$$android_nfc_NfcAdapter$getTagService(), 0, this);
    }

    public INfcCardEmulation getCardEmulationService() {
        return InvokeDynamicSupport.bootstrap("getCardEmulationService", $$robo$$android_nfc_NfcAdapter$getCardEmulationService(), 0, this);
    }

    public INfcFCardEmulation getNfcFCardEmulationService() {
        return InvokeDynamicSupport.bootstrap("getNfcFCardEmulationService", $$robo$$android_nfc_NfcAdapter$getNfcFCardEmulationService(), 0, this);
    }

    public INfcDta getNfcDtaInterface() {
        return InvokeDynamicSupport.bootstrap("getNfcDtaInterface", $$robo$$android_nfc_NfcAdapter$getNfcDtaInterface(), 0, this);
    }

    public void attemptDeadServiceRecovery(Exception exception) {
        InvokeDynamicSupport.bootstrap("attemptDeadServiceRecovery", $$robo$$android_nfc_NfcAdapter$attemptDeadServiceRecovery(java.lang.Exception ), 0, this, exception);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_nfc_NfcAdapter$isEnabled(), 0, this);
    }

    public int getAdapterState() {
        return (int)InvokeDynamicSupport.bootstrap("getAdapterState", $$robo$$android_nfc_NfcAdapter$getAdapterState(), 0, this);
    }

    public boolean enable() {
        return (boolean)InvokeDynamicSupport.bootstrap("enable", $$robo$$android_nfc_NfcAdapter$enable(), 0, this);
    }

    public boolean disable() {
        return (boolean)InvokeDynamicSupport.bootstrap("disable", $$robo$$android_nfc_NfcAdapter$disable(), 0, this);
    }

    public boolean disable(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("disable", $$robo$$android_nfc_NfcAdapter$disable(boolean ), 0, this, bl);
    }

    public void pausePolling(int n) {
        InvokeDynamicSupport.bootstrap("pausePolling", $$robo$$android_nfc_NfcAdapter$pausePolling(int ), 0, this, n);
    }

    public void resumePolling() {
        InvokeDynamicSupport.bootstrap("resumePolling", $$robo$$android_nfc_NfcAdapter$resumePolling(), 0, this);
    }

    public void setBeamPushUris(Uri[] uriArray, Activity activity) {
        InvokeDynamicSupport.bootstrap("setBeamPushUris", $$robo$$android_nfc_NfcAdapter$setBeamPushUris(android.net.Uri[] android.app.Activity ), 0, this, uriArray, activity);
    }

    public void setBeamPushUrisCallback(CreateBeamUrisCallback createBeamUrisCallback, Activity activity) {
        InvokeDynamicSupport.bootstrap("setBeamPushUrisCallback", $$robo$$android_nfc_NfcAdapter$setBeamPushUrisCallback(android.nfc.NfcAdapter$CreateBeamUrisCallback android.app.Activity ), 0, this, createBeamUrisCallback, activity);
    }

    public void setNdefPushMessage(NdefMessage ndefMessage, Activity activity, Activity ... activityArray) {
        InvokeDynamicSupport.bootstrap("setNdefPushMessage", $$robo$$android_nfc_NfcAdapter$setNdefPushMessage(android.nfc.NdefMessage android.app.Activity android.app.Activity[] ), 0, this, ndefMessage, activity, activityArray);
    }

    public void setNdefPushMessage(NdefMessage ndefMessage, Activity activity, int n) {
        InvokeDynamicSupport.bootstrap("setNdefPushMessage", $$robo$$android_nfc_NfcAdapter$setNdefPushMessage(android.nfc.NdefMessage android.app.Activity int ), 0, this, ndefMessage, activity, n);
    }

    public void setNdefPushMessageCallback(CreateNdefMessageCallback createNdefMessageCallback, Activity activity, Activity ... activityArray) {
        InvokeDynamicSupport.bootstrap("setNdefPushMessageCallback", $$robo$$android_nfc_NfcAdapter$setNdefPushMessageCallback(android.nfc.NfcAdapter$CreateNdefMessageCallback android.app.Activity android.app.Activity[] ), 0, this, createNdefMessageCallback, activity, activityArray);
    }

    public void setNdefPushMessageCallback(CreateNdefMessageCallback createNdefMessageCallback, Activity activity, int n) {
        InvokeDynamicSupport.bootstrap("setNdefPushMessageCallback", $$robo$$android_nfc_NfcAdapter$setNdefPushMessageCallback(android.nfc.NfcAdapter$CreateNdefMessageCallback android.app.Activity int ), 0, this, createNdefMessageCallback, activity, n);
    }

    public void setOnNdefPushCompleteCallback(OnNdefPushCompleteCallback onNdefPushCompleteCallback, Activity activity, Activity ... activityArray) {
        InvokeDynamicSupport.bootstrap("setOnNdefPushCompleteCallback", $$robo$$android_nfc_NfcAdapter$setOnNdefPushCompleteCallback(android.nfc.NfcAdapter$OnNdefPushCompleteCallback android.app.Activity android.app.Activity[] ), 0, this, onNdefPushCompleteCallback, activity, activityArray);
    }

    public void enableForegroundDispatch(Activity activity, PendingIntent pendingIntent, IntentFilter[] intentFilterArray, String[][] stringArray) {
        InvokeDynamicSupport.bootstrap("enableForegroundDispatch", $$robo$$android_nfc_NfcAdapter$enableForegroundDispatch(android.app.Activity android.app.PendingIntent android.content.IntentFilter[] java.lang.String[][] ), 0, this, activity, pendingIntent, intentFilterArray, stringArray);
    }

    public void disableForegroundDispatch(Activity activity) {
        InvokeDynamicSupport.bootstrap("disableForegroundDispatch", $$robo$$android_nfc_NfcAdapter$disableForegroundDispatch(android.app.Activity ), 0, this, activity);
    }

    void disableForegroundDispatchInternal(Activity activity, boolean bl) {
        InvokeDynamicSupport.bootstrap("disableForegroundDispatchInternal", $$robo$$android_nfc_NfcAdapter$disableForegroundDispatchInternal(android.app.Activity boolean ), 0, this, activity, bl);
    }

    public void enableReaderMode(Activity activity, ReaderCallback readerCallback, int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("enableReaderMode", $$robo$$android_nfc_NfcAdapter$enableReaderMode(android.app.Activity android.nfc.NfcAdapter$ReaderCallback int android.os.Bundle ), 0, this, activity, readerCallback, n, bundle);
    }

    public void disableReaderMode(Activity activity) {
        InvokeDynamicSupport.bootstrap("disableReaderMode", $$robo$$android_nfc_NfcAdapter$disableReaderMode(android.app.Activity ), 0, this, activity);
    }

    public boolean invokeBeam(Activity activity) {
        return (boolean)InvokeDynamicSupport.bootstrap("invokeBeam", $$robo$$android_nfc_NfcAdapter$invokeBeam(android.app.Activity ), 0, this, activity);
    }

    public boolean invokeBeam(BeamShareData beamShareData) {
        return (boolean)InvokeDynamicSupport.bootstrap("invokeBeam", $$robo$$android_nfc_NfcAdapter$invokeBeam(android.nfc.BeamShareData ), 0, this, beamShareData);
    }

    @Deprecated
    public void enableForegroundNdefPush(Activity activity, NdefMessage ndefMessage) {
        InvokeDynamicSupport.bootstrap("enableForegroundNdefPush", $$robo$$android_nfc_NfcAdapter$enableForegroundNdefPush(android.app.Activity android.nfc.NdefMessage ), 0, this, activity, ndefMessage);
    }

    @Deprecated
    public void disableForegroundNdefPush(Activity activity) {
        InvokeDynamicSupport.bootstrap("disableForegroundNdefPush", $$robo$$android_nfc_NfcAdapter$disableForegroundNdefPush(android.app.Activity ), 0, this, activity);
    }

    public boolean enableNdefPush() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableNdefPush", $$robo$$android_nfc_NfcAdapter$enableNdefPush(), 0, this);
    }

    public boolean disableNdefPush() {
        return (boolean)InvokeDynamicSupport.bootstrap("disableNdefPush", $$robo$$android_nfc_NfcAdapter$disableNdefPush(), 0, this);
    }

    public boolean isNdefPushEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNdefPushEnabled", $$robo$$android_nfc_NfcAdapter$isNdefPushEnabled(), 0, this);
    }

    public boolean ignore(Tag tag, int n, OnTagRemovedListener onTagRemovedListener, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("ignore", $$robo$$android_nfc_NfcAdapter$ignore(android.nfc.Tag int android.nfc.NfcAdapter$OnTagRemovedListener android.os.Handler ), 0, this, tag, n, onTagRemovedListener, handler);
    }

    public void dispatch(Tag tag) {
        InvokeDynamicSupport.bootstrap("dispatch", $$robo$$android_nfc_NfcAdapter$dispatch(android.nfc.Tag ), 0, this, tag);
    }

    public void setP2pModes(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setP2pModes", $$robo$$android_nfc_NfcAdapter$setP2pModes(int int ), 0, this, n, n2);
    }

    public boolean addNfcUnlockHandler(NfcUnlockHandler nfcUnlockHandler, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("addNfcUnlockHandler", $$robo$$android_nfc_NfcAdapter$addNfcUnlockHandler(android.nfc.NfcAdapter$NfcUnlockHandler java.lang.String[] ), 0, this, nfcUnlockHandler, stringArray);
    }

    public boolean removeNfcUnlockHandler(NfcUnlockHandler nfcUnlockHandler) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeNfcUnlockHandler", $$robo$$android_nfc_NfcAdapter$removeNfcUnlockHandler(android.nfc.NfcAdapter$NfcUnlockHandler ), 0, this, nfcUnlockHandler);
    }

    public INfcAdapterExtras getNfcAdapterExtrasInterface() {
        return InvokeDynamicSupport.bootstrap("getNfcAdapterExtrasInterface", $$robo$$android_nfc_NfcAdapter$getNfcAdapterExtrasInterface(), 0, this);
    }

    void enforceResumed(Activity activity) {
        InvokeDynamicSupport.bootstrap("enforceResumed", $$robo$$android_nfc_NfcAdapter$enforceResumed(android.app.Activity ), 0, this, activity);
    }

    int getSdkVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getSdkVersion", $$robo$$android_nfc_NfcAdapter$getSdkVersion(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(NfcAdapter.class);
    }

    public /* synthetic */ NfcAdapter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NfcAdapter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface NfcUnlockHandler
    extends InstrumentedInterface {
        public boolean onUnlockAttempted(Tag var1);
    }

    public static interface OnTagRemovedListener
    extends InstrumentedInterface {
        public void onTagRemoved();
    }

    public static interface CreateBeamUrisCallback
    extends InstrumentedInterface {
        public Uri[] createBeamUris(NfcEvent var1);
    }

    public static interface CreateNdefMessageCallback
    extends InstrumentedInterface {
        public NdefMessage createNdefMessage(NfcEvent var1);
    }

    public static interface OnNdefPushCompleteCallback
    extends InstrumentedInterface {
        public void onNdefPushComplete(NfcEvent var1);
    }

    public static interface ReaderCallback
    extends InstrumentedInterface {
        public void onTagDiscovered(Tag var1);
    }
}

