/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.app.Activity;
import android.app.ActivityThread;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.IPackageManager;
import android.nfc.INfcFCardEmulation;
import android.nfc.NfcAdapter;
import android.nfc.cardemulation.NfcFServiceInfo;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class NfcFCardEmulation
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "NfcFCardEmulation";
    static boolean sIsInitialized;
    static HashMap<Context, NfcFCardEmulation> sCardEmus;
    static INfcFCardEmulation sService;
    Context mContext;

    private void $$robo$$android_nfc_cardemulation_NfcFCardEmulation$__constructor__(Context context, INfcFCardEmulation service) {
        this.mContext = context.getApplicationContext();
        sService = service;
    }

    private static final synchronized NfcFCardEmulation $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getInstance(NfcAdapter adapter) {
        NfcFCardEmulation manager;
        if (adapter == null) {
            throw new NullPointerException("NfcAdapter is null");
        }
        Context context = adapter.getContext();
        if (context == null) {
            Log.e("NfcFCardEmulation", "NfcAdapter context is null.");
            throw new UnsupportedOperationException();
        }
        if (!sIsInitialized) {
            IPackageManager pm = ActivityThread.getPackageManager();
            if (pm == null) {
                Log.e("NfcFCardEmulation", "Cannot get PackageManager");
                throw new UnsupportedOperationException();
            }
            try {
                if (!pm.hasSystemFeature("android.hardware.nfc.hcef", 0)) {
                    Log.e("NfcFCardEmulation", "This device does not support NFC-F card emulation");
                    throw new UnsupportedOperationException();
                }
            }
            catch (RemoteException e) {
                Log.e("NfcFCardEmulation", "PackageManager query failed.");
                throw new UnsupportedOperationException();
            }
            sIsInitialized = true;
        }
        if ((manager = sCardEmus.get(context)) == null) {
            INfcFCardEmulation service = adapter.getNfcFCardEmulationService();
            if (service == null) {
                Log.e("NfcFCardEmulation", "This device does not implement the INfcFCardEmulation interface.");
                throw new UnsupportedOperationException();
            }
            manager = new NfcFCardEmulation(context, service);
            sCardEmus.put(context, manager);
        }
        return manager;
    }

    private final String $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getSystemCodeForService(ComponentName service) throws RuntimeException {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        try {
            return sService.getSystemCodeForService(UserHandle.myUserId(), service);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("NfcFCardEmulation", "Failed to recover CardEmulationService.");
                return null;
            }
            try {
                return sService.getSystemCodeForService(UserHandle.myUserId(), service);
            }
            catch (RemoteException ee) {
                Log.e("NfcFCardEmulation", "Failed to reach CardEmulationService.");
                ee.rethrowAsRuntimeException();
                return null;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_NfcFCardEmulation$registerSystemCodeForService(ComponentName service, String systemCode) throws RuntimeException {
        if (service == null || systemCode == null) {
            throw new NullPointerException("service or systemCode is null");
        }
        try {
            return sService.registerSystemCodeForService(UserHandle.myUserId(), service, systemCode);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("NfcFCardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.registerSystemCodeForService(UserHandle.myUserId(), service, systemCode);
            }
            catch (RemoteException ee) {
                Log.e("NfcFCardEmulation", "Failed to reach CardEmulationService.");
                ee.rethrowAsRuntimeException();
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_NfcFCardEmulation$unregisterSystemCodeForService(ComponentName service) throws RuntimeException {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        try {
            return sService.removeSystemCodeForService(UserHandle.myUserId(), service);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("NfcFCardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.removeSystemCodeForService(UserHandle.myUserId(), service);
            }
            catch (RemoteException ee) {
                Log.e("NfcFCardEmulation", "Failed to reach CardEmulationService.");
                ee.rethrowAsRuntimeException();
                return false;
            }
        }
    }

    private final String $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getNfcid2ForService(ComponentName service) throws RuntimeException {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        try {
            return sService.getNfcid2ForService(UserHandle.myUserId(), service);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("NfcFCardEmulation", "Failed to recover CardEmulationService.");
                return null;
            }
            try {
                return sService.getNfcid2ForService(UserHandle.myUserId(), service);
            }
            catch (RemoteException ee) {
                Log.e("NfcFCardEmulation", "Failed to reach CardEmulationService.");
                ee.rethrowAsRuntimeException();
                return null;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_NfcFCardEmulation$setNfcid2ForService(ComponentName service, String nfcid2) throws RuntimeException {
        if (service == null || nfcid2 == null) {
            throw new NullPointerException("service or nfcid2 is null");
        }
        try {
            return sService.setNfcid2ForService(UserHandle.myUserId(), service, nfcid2);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("NfcFCardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.setNfcid2ForService(UserHandle.myUserId(), service, nfcid2);
            }
            catch (RemoteException ee) {
                Log.e("NfcFCardEmulation", "Failed to reach CardEmulationService.");
                ee.rethrowAsRuntimeException();
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_NfcFCardEmulation$enableService(Activity activity, ComponentName service) throws RuntimeException {
        if (activity == null || service == null) {
            throw new NullPointerException("activity or service is null");
        }
        if (!activity.isResumed()) {
            throw new IllegalArgumentException("Activity must be resumed.");
        }
        try {
            return sService.enableNfcFForegroundService(service);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("NfcFCardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.enableNfcFForegroundService(service);
            }
            catch (RemoteException ee) {
                Log.e("NfcFCardEmulation", "Failed to reach CardEmulationService.");
                ee.rethrowAsRuntimeException();
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_NfcFCardEmulation$disableService(Activity activity) throws RuntimeException {
        if (activity == null) {
            throw new NullPointerException("activity is null");
        }
        if (!activity.isResumed()) {
            throw new IllegalArgumentException("Activity must be resumed.");
        }
        try {
            return sService.disableNfcFForegroundService();
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("NfcFCardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.disableNfcFForegroundService();
            }
            catch (RemoteException ee) {
                Log.e("NfcFCardEmulation", "Failed to reach CardEmulationService.");
                ee.rethrowAsRuntimeException();
                return false;
            }
        }
    }

    private final List<NfcFServiceInfo> $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getNfcFServices() {
        try {
            return sService.getNfcFServices(UserHandle.myUserId());
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("NfcFCardEmulation", "Failed to recover CardEmulationService.");
                return null;
            }
            try {
                return sService.getNfcFServices(UserHandle.myUserId());
            }
            catch (RemoteException ee) {
                Log.e("NfcFCardEmulation", "Failed to reach CardEmulationService.");
                return null;
            }
        }
    }

    private final int $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getMaxNumOfRegisterableSystemCodes() {
        try {
            return sService.getMaxNumOfRegisterableSystemCodes();
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("NfcFCardEmulation", "Failed to recover CardEmulationService.");
                return -1;
            }
            try {
                return sService.getMaxNumOfRegisterableSystemCodes();
            }
            catch (RemoteException ee) {
                Log.e("NfcFCardEmulation", "Failed to reach CardEmulationService.");
                return -1;
            }
        }
    }

    private static final boolean $$robo$$android_nfc_cardemulation_NfcFCardEmulation$isValidSystemCode(String systemCode) {
        if (systemCode == null) {
            return false;
        }
        if (systemCode.length() != 4) {
            Log.e("NfcFCardEmulation", "System Code " + systemCode + " is not a valid System Code.");
            return false;
        }
        if (!systemCode.startsWith("4") || systemCode.toUpperCase().endsWith("FF")) {
            Log.e("NfcFCardEmulation", "System Code " + systemCode + " is not a valid System Code.");
            return false;
        }
        try {
            Integer.parseInt(systemCode, 16);
        }
        catch (NumberFormatException e) {
            Log.e("NfcFCardEmulation", "System Code " + systemCode + " is not a valid System Code.");
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_nfc_cardemulation_NfcFCardEmulation$isValidNfcid2(String nfcid2) {
        if (nfcid2 == null) {
            return false;
        }
        if (nfcid2.length() != 16) {
            Log.e("NfcFCardEmulation", "NFCID2 " + nfcid2 + " is not a valid NFCID2.");
            return false;
        }
        if (!nfcid2.toUpperCase().startsWith("02FE")) {
            Log.e("NfcFCardEmulation", "NFCID2 " + nfcid2 + " is not a valid NFCID2.");
            return false;
        }
        try {
            Long.parseLong(nfcid2, 16);
        }
        catch (NumberFormatException e) {
            Log.e("NfcFCardEmulation", "NFCID2 " + nfcid2 + " is not a valid NFCID2.");
            return false;
        }
        return true;
    }

    private final void $$robo$$android_nfc_cardemulation_NfcFCardEmulation$recoverService() {
        NfcAdapter adapter = NfcAdapter.getDefaultAdapter(this.mContext);
        sService = adapter.getNfcFCardEmulationService();
    }

    static void __staticInitializer__() {
        sIsInitialized = false;
        sCardEmus = new HashMap();
    }

    private void __constructor__(Context context, INfcFCardEmulation iNfcFCardEmulation) {
        this.$$robo$$android_nfc_cardemulation_NfcFCardEmulation$__constructor__(context, iNfcFCardEmulation);
    }

    private NfcFCardEmulation(Context context, INfcFCardEmulation iNfcFCardEmulation) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$__constructor__(android.content.Context android.nfc.INfcFCardEmulation ), 0, this, context, iNfcFCardEmulation);
    }

    public static synchronized NfcFCardEmulation getInstance(NfcAdapter nfcAdapter) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getInstance(android.nfc.NfcAdapter ), 0, (NfcAdapter)nfcAdapter);
    }

    public String getSystemCodeForService(ComponentName componentName) throws RuntimeException {
        return InvokeDynamicSupport.bootstrap("getSystemCodeForService", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getSystemCodeForService(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean registerSystemCodeForService(ComponentName componentName, String string2) throws RuntimeException {
        return (boolean)InvokeDynamicSupport.bootstrap("registerSystemCodeForService", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$registerSystemCodeForService(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean unregisterSystemCodeForService(ComponentName componentName) throws RuntimeException {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterSystemCodeForService", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$unregisterSystemCodeForService(android.content.ComponentName ), 0, this, componentName);
    }

    public String getNfcid2ForService(ComponentName componentName) throws RuntimeException {
        return InvokeDynamicSupport.bootstrap("getNfcid2ForService", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getNfcid2ForService(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean setNfcid2ForService(ComponentName componentName, String string2) throws RuntimeException {
        return (boolean)InvokeDynamicSupport.bootstrap("setNfcid2ForService", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$setNfcid2ForService(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean enableService(Activity activity, ComponentName componentName) throws RuntimeException {
        return (boolean)InvokeDynamicSupport.bootstrap("enableService", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$enableService(android.app.Activity android.content.ComponentName ), 0, this, activity, componentName);
    }

    public boolean disableService(Activity activity) throws RuntimeException {
        return (boolean)InvokeDynamicSupport.bootstrap("disableService", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$disableService(android.app.Activity ), 0, this, activity);
    }

    public List<NfcFServiceInfo> getNfcFServices() {
        return InvokeDynamicSupport.bootstrap("getNfcFServices", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getNfcFServices(), 0, this);
    }

    public int getMaxNumOfRegisterableSystemCodes() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxNumOfRegisterableSystemCodes", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$getMaxNumOfRegisterableSystemCodes(), 0, this);
    }

    public static boolean isValidSystemCode(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSystemCode", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$isValidSystemCode(java.lang.String ), 0, (String)string2);
    }

    public static boolean isValidNfcid2(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidNfcid2", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$isValidNfcid2(java.lang.String ), 0, (String)string2);
    }

    void recoverService() {
        InvokeDynamicSupport.bootstrap("recoverService", $$robo$$android_nfc_cardemulation_NfcFCardEmulation$recoverService(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(NfcFCardEmulation.class);
    }

    public /* synthetic */ NfcFCardEmulation() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NfcFCardEmulation)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

