/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.nfc.cardemulation.NfcFCardEmulation;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class NfcFServiceInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "NfcFServiceInfo";
    private static String DEFAULT_T3T_PMM = "FFFFFFFFFFFFFFFF";
    ResolveInfo mService;
    String mDescription;
    String mSystemCode;
    String mDynamicSystemCode;
    String mNfcid2;
    String mDynamicNfcid2;
    int mUid;
    String mT3tPmm;
    public static Parcelable.Creator<NfcFServiceInfo> CREATOR;

    private void $$robo$$android_nfc_cardemulation_NfcFServiceInfo$__constructor__(ResolveInfo info, String description, String systemCode, String dynamicSystemCode, String nfcid2, String dynamicNfcid2, int uid, String t3tPmm) {
        this.mService = info;
        this.mDescription = description;
        this.mSystemCode = systemCode;
        this.mDynamicSystemCode = dynamicSystemCode;
        this.mNfcid2 = nfcid2;
        this.mDynamicNfcid2 = dynamicNfcid2;
        this.mUid = uid;
        this.mT3tPmm = t3tPmm;
    }

    private void $$robo$$android_nfc_cardemulation_NfcFServiceInfo$__constructor__(PackageManager pm, ResolveInfo info) throws XmlPullParserException, IOException {
        ServiceInfo si = info.serviceInfo;
        try (XmlResourceParser parser = null;){
            parser = si.loadXmlMetaData(pm, "android.nfc.cardemulation.host_nfcf_service");
            if (parser == null) {
                throw new XmlPullParserException("No android.nfc.cardemulation.host_nfcf_service meta-data");
            }
            int eventType = parser.getEventType();
            while (eventType != 2 && eventType != 1) {
                eventType = parser.next();
            }
            String tagName = parser.getName();
            if (!"host-nfcf-service".equals(tagName)) {
                throw new XmlPullParserException("Meta-data does not start with <host-nfcf-service> tag");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.HostNfcFService);
            this.mService = info;
            this.mDescription = sa.getString(0);
            this.mDynamicSystemCode = null;
            this.mDynamicNfcid2 = null;
            sa.recycle();
            String systemCode = null;
            String nfcid2 = null;
            String t3tPmm = null;
            int depth = parser.getDepth();
            while (((eventType = parser.next()) != 3 || parser.getDepth() > depth) && eventType != 1) {
                TypedArray a;
                tagName = parser.getName();
                if (eventType == 2 && "system-code-filter".equals(tagName) && systemCode == null) {
                    a = res.obtainAttributes(attrs, R.styleable.SystemCodeFilter);
                    systemCode = a.getString(0).toUpperCase();
                    if (!NfcFCardEmulation.isValidSystemCode(systemCode) && !systemCode.equalsIgnoreCase("NULL")) {
                        Log.e("NfcFServiceInfo", "Invalid System Code: " + systemCode);
                        systemCode = null;
                    }
                    a.recycle();
                    continue;
                }
                if (eventType == 2 && "nfcid2-filter".equals(tagName) && nfcid2 == null) {
                    a = res.obtainAttributes(attrs, R.styleable.Nfcid2Filter);
                    nfcid2 = a.getString(0).toUpperCase();
                    if (!(nfcid2.equalsIgnoreCase("RANDOM") || nfcid2.equalsIgnoreCase("NULL") || NfcFCardEmulation.isValidNfcid2(nfcid2))) {
                        Log.e("NfcFServiceInfo", "Invalid NFCID2: " + nfcid2);
                        nfcid2 = null;
                    }
                    a.recycle();
                    continue;
                }
                if (eventType != 2 || !tagName.equals("t3tPmm-filter") || t3tPmm != null) continue;
                a = res.obtainAttributes(attrs, R.styleable.T3tPmmFilter);
                t3tPmm = a.getString(0).toUpperCase();
                a.recycle();
            }
            this.mSystemCode = systemCode == null ? "NULL" : systemCode;
            this.mNfcid2 = nfcid2 == null ? "NULL" : nfcid2;
            this.mT3tPmm = t3tPmm == null ? "FFFFFFFFFFFFFFFF" : t3tPmm;
        }
        this.mUid = si.applicationInfo.uid;
    }

    private final ComponentName $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    private final String $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getSystemCode() {
        return this.mDynamicSystemCode == null ? this.mSystemCode : this.mDynamicSystemCode;
    }

    private final void $$robo$$android_nfc_cardemulation_NfcFServiceInfo$setOrReplaceDynamicSystemCode(String systemCode) {
        this.mDynamicSystemCode = systemCode;
    }

    private final String $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getNfcid2() {
        return this.mDynamicNfcid2 == null ? this.mNfcid2 : this.mDynamicNfcid2;
    }

    private final void $$robo$$android_nfc_cardemulation_NfcFServiceInfo$setOrReplaceDynamicNfcid2(String nfcid2) {
        this.mDynamicNfcid2 = nfcid2;
    }

    private final String $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getDescription() {
        return this.mDescription;
    }

    private final int $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getUid() {
        return this.mUid;
    }

    private final String $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getT3tPmm() {
        return this.mT3tPmm;
    }

    private final CharSequence $$robo$$android_nfc_cardemulation_NfcFServiceInfo$loadLabel(PackageManager pm) {
        return this.mService.loadLabel(pm);
    }

    private final Drawable $$robo$$android_nfc_cardemulation_NfcFServiceInfo$loadIcon(PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    private final String $$robo$$android_nfc_cardemulation_NfcFServiceInfo$toString() {
        StringBuilder out = new StringBuilder("NfcFService: ");
        out.append(this.getComponent());
        out.append(", description: " + this.mDescription);
        out.append(", System Code: " + this.mSystemCode);
        if (this.mDynamicSystemCode != null) {
            out.append(", dynamic System Code: " + this.mDynamicSystemCode);
        }
        out.append(", NFCID2: " + this.mNfcid2);
        if (this.mDynamicNfcid2 != null) {
            out.append(", dynamic NFCID2: " + this.mDynamicNfcid2);
        }
        out.append(", T3T PMM:" + this.mT3tPmm);
        return out.toString();
    }

    private final boolean $$robo$$android_nfc_cardemulation_NfcFServiceInfo$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NfcFServiceInfo)) {
            return false;
        }
        NfcFServiceInfo thatService = (NfcFServiceInfo)o;
        if (!thatService.getComponent().equals(this.getComponent())) {
            return false;
        }
        if (!thatService.mSystemCode.equalsIgnoreCase(this.mSystemCode)) {
            return false;
        }
        if (!thatService.mNfcid2.equalsIgnoreCase(this.mNfcid2)) {
            return false;
        }
        return thatService.mT3tPmm.equalsIgnoreCase(this.mT3tPmm);
    }

    private final int $$robo$$android_nfc_cardemulation_NfcFServiceInfo$hashCode() {
        return this.getComponent().hashCode();
    }

    private final int $$robo$$android_nfc_cardemulation_NfcFServiceInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_nfc_cardemulation_NfcFServiceInfo$writeToParcel(Parcel dest, int flags) {
        this.mService.writeToParcel(dest, flags);
        dest.writeString(this.mDescription);
        dest.writeString(this.mSystemCode);
        dest.writeInt(this.mDynamicSystemCode != null ? 1 : 0);
        if (this.mDynamicSystemCode != null) {
            dest.writeString(this.mDynamicSystemCode);
        }
        dest.writeString(this.mNfcid2);
        dest.writeInt(this.mDynamicNfcid2 != null ? 1 : 0);
        if (this.mDynamicNfcid2 != null) {
            dest.writeString(this.mDynamicNfcid2);
        }
        dest.writeInt(this.mUid);
        dest.writeString(this.mT3tPmm);
    }

    private final void $$robo$$android_nfc_cardemulation_NfcFServiceInfo$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("    " + this.getComponent() + " (Description: " + this.getDescription() + ")");
        pw.println("    System Code: " + this.getSystemCode());
        pw.println("    NFCID2: " + this.getNfcid2());
        pw.println("    T3tPmm: " + this.getT3tPmm());
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<NfcFServiceInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_nfc_cardemulation_NfcFServiceInfo_1$__constructor__() {
            }

            private final NfcFServiceInfo $$robo$$android_nfc_cardemulation_NfcFServiceInfo_1$createFromParcel(Parcel source) {
                ResolveInfo info = ResolveInfo.CREATOR.createFromParcel(source);
                String description = source.readString();
                String systemCode = source.readString();
                String dynamicSystemCode = null;
                if (source.readInt() != 0) {
                    dynamicSystemCode = source.readString();
                }
                String nfcid2 = source.readString();
                String dynamicNfcid2 = null;
                if (source.readInt() != 0) {
                    dynamicNfcid2 = source.readString();
                }
                int uid = source.readInt();
                String t3tPmm = source.readString();
                NfcFServiceInfo service = new NfcFServiceInfo(info, description, systemCode, dynamicSystemCode, nfcid2, dynamicNfcid2, uid, t3tPmm);
                return service;
            }

            private final NfcFServiceInfo[] $$robo$$android_nfc_cardemulation_NfcFServiceInfo_1$newArray(int size) {
                return new NfcFServiceInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_nfc_cardemulation_NfcFServiceInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_NfcFServiceInfo_1$__constructor__(), 0, this);
            }

            @Override
            public NfcFServiceInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_nfc_cardemulation_NfcFServiceInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public NfcFServiceInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_nfc_cardemulation_NfcFServiceInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(ResolveInfo resolveInfo, String string2, String string3, String string4, String string5, String string6, int n, String string7) {
        this.$$robo$$android_nfc_cardemulation_NfcFServiceInfo$__constructor__(resolveInfo, string2, string3, string4, string5, string6, n, string7);
    }

    public NfcFServiceInfo(ResolveInfo resolveInfo, String string2, String string3, String string4, String string5, String string6, int n, String string7) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$__constructor__(android.content.pm.ResolveInfo java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String int java.lang.String ), 0, this, resolveInfo, string2, string3, string4, string5, string6, n, string7);
    }

    private void __constructor__(PackageManager packageManager, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this.$$robo$$android_nfc_cardemulation_NfcFServiceInfo$__constructor__(packageManager, resolveInfo);
    }

    public NfcFServiceInfo(PackageManager packageManager, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$__constructor__(android.content.pm.PackageManager android.content.pm.ResolveInfo ), 0, this, packageManager, resolveInfo);
    }

    public ComponentName getComponent() {
        return InvokeDynamicSupport.bootstrap("getComponent", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getComponent(), 0, this);
    }

    public String getSystemCode() {
        return InvokeDynamicSupport.bootstrap("getSystemCode", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getSystemCode(), 0, this);
    }

    public void setOrReplaceDynamicSystemCode(String string2) {
        InvokeDynamicSupport.bootstrap("setOrReplaceDynamicSystemCode", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$setOrReplaceDynamicSystemCode(java.lang.String ), 0, this, string2);
    }

    public String getNfcid2() {
        return InvokeDynamicSupport.bootstrap("getNfcid2", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getNfcid2(), 0, this);
    }

    public void setOrReplaceDynamicNfcid2(String string2) {
        InvokeDynamicSupport.bootstrap("setOrReplaceDynamicNfcid2", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$setOrReplaceDynamicNfcid2(java.lang.String ), 0, this, string2);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getDescription(), 0, this);
    }

    public int getUid() {
        return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getUid(), 0, this);
    }

    public String getT3tPmm() {
        return InvokeDynamicSupport.bootstrap("getT3tPmm", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$getT3tPmm(), 0, this);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadLabel", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$loadLabel(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$loadIcon(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_nfc_cardemulation_NfcFServiceInfo$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(NfcFServiceInfo.class);
    }

    public /* synthetic */ NfcFServiceInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NfcFServiceInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

