/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.BasicTagTechnology;
import android.nfc.tech.NfcA;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MifareClassic
extends BasicTagTechnology
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NFC";
    public static byte[] KEY_DEFAULT;
    public static byte[] KEY_MIFARE_APPLICATION_DIRECTORY;
    public static byte[] KEY_NFC_FORUM;
    public static int TYPE_UNKNOWN = -1;
    public static int TYPE_CLASSIC = 0;
    public static int TYPE_PLUS = 1;
    public static int TYPE_PRO = 2;
    public static int SIZE_1K = 1024;
    public static int SIZE_2K = 2048;
    public static int SIZE_4K = 4096;
    public static int SIZE_MINI = 320;
    public static int BLOCK_SIZE = 16;
    private static int MAX_BLOCK_COUNT = 256;
    private static int MAX_SECTOR_COUNT = 40;
    private boolean mIsEmulated;
    private int mType;
    private int mSize;

    private static final MifareClassic $$robo$$android_nfc_tech_MifareClassic$get(Tag tag) {
        if (!tag.hasTech(8)) {
            return null;
        }
        try {
            return new MifareClassic(tag);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private void $$robo$$android_nfc_tech_MifareClassic$__constructor__(Tag tag) throws RemoteException {
        NfcA a = NfcA.get(tag);
        this.mIsEmulated = false;
        switch (a.getSak()) {
            case 1: 
            case 8: {
                this.mType = 0;
                this.mSize = 1024;
                break;
            }
            case 9: {
                this.mType = 0;
                this.mSize = 320;
                break;
            }
            case 16: {
                this.mType = 1;
                this.mSize = 2048;
                break;
            }
            case 17: {
                this.mType = 1;
                this.mSize = 4096;
                break;
            }
            case 24: {
                this.mType = 0;
                this.mSize = 4096;
                break;
            }
            case 40: {
                this.mType = 0;
                this.mSize = 1024;
                this.mIsEmulated = true;
                break;
            }
            case 56: {
                this.mType = 0;
                this.mSize = 4096;
                this.mIsEmulated = true;
                break;
            }
            case 136: {
                this.mType = 0;
                this.mSize = 1024;
                break;
            }
            case 152: 
            case 184: {
                this.mType = 2;
                this.mSize = 4096;
                break;
            }
            default: {
                throw new RuntimeException("Tag incorrectly enumerated as MIFARE Classic, SAK = " + a.getSak());
            }
        }
    }

    private final int $$robo$$android_nfc_tech_MifareClassic$getType() {
        return this.mType;
    }

    private final int $$robo$$android_nfc_tech_MifareClassic$getSize() {
        return this.mSize;
    }

    private final boolean $$robo$$android_nfc_tech_MifareClassic$isEmulated() {
        return this.mIsEmulated;
    }

    private final int $$robo$$android_nfc_tech_MifareClassic$getSectorCount() {
        switch (this.mSize) {
            case 1024: {
                return 16;
            }
            case 2048: {
                return 32;
            }
            case 4096: {
                return 40;
            }
            case 320: {
                return 5;
            }
        }
        return 0;
    }

    private final int $$robo$$android_nfc_tech_MifareClassic$getBlockCount() {
        return this.mSize / 16;
    }

    private final int $$robo$$android_nfc_tech_MifareClassic$getBlockCountInSector(int sectorIndex) {
        MifareClassic.validateSector(sectorIndex);
        if (sectorIndex < 32) {
            return 4;
        }
        return 16;
    }

    private final int $$robo$$android_nfc_tech_MifareClassic$blockToSector(int blockIndex) {
        MifareClassic.validateBlock(blockIndex);
        if (blockIndex < 128) {
            return blockIndex / 4;
        }
        return 32 + (blockIndex - 128) / 16;
    }

    private final int $$robo$$android_nfc_tech_MifareClassic$sectorToBlock(int sectorIndex) {
        if (sectorIndex < 32) {
            return sectorIndex * 4;
        }
        return 128 + (sectorIndex - 32) * 16;
    }

    private final boolean $$robo$$android_nfc_tech_MifareClassic$authenticateSectorWithKeyA(int sectorIndex, byte[] key) throws IOException {
        return this.authenticate(sectorIndex, key, true);
    }

    private final boolean $$robo$$android_nfc_tech_MifareClassic$authenticateSectorWithKeyB(int sectorIndex, byte[] key) throws IOException {
        return this.authenticate(sectorIndex, key, false);
    }

    private final boolean $$robo$$android_nfc_tech_MifareClassic$authenticate(int sector, byte[] key, boolean keyA) throws IOException {
        MifareClassic.validateSector(sector);
        this.checkConnected();
        byte[] cmd = new byte[12];
        cmd[0] = keyA ? 96 : 97;
        cmd[1] = (byte)this.sectorToBlock(sector);
        byte[] uid = this.getTag().getId();
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])uid, (int)(uid.length - 4), (byte[])cmd, (int)2, (int)4);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])key, (int)0, (byte[])cmd, (int)6, (int)6);
        try {
            if (this.transceive(cmd, false) != null) {
                return true;
            }
        }
        catch (TagLostException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private final byte[] $$robo$$android_nfc_tech_MifareClassic$readBlock(int blockIndex) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        this.checkConnected();
        byte[] cmd = new byte[]{48, (byte)blockIndex};
        return this.transceive(cmd, false);
    }

    private final void $$robo$$android_nfc_tech_MifareClassic$writeBlock(int blockIndex, byte[] data) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        this.checkConnected();
        if (data.length != 16) {
            throw new IllegalArgumentException("must write 16-bytes");
        }
        byte[] cmd = new byte[data.length + 2];
        cmd[0] = -96;
        cmd[1] = (byte)blockIndex;
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)0, (byte[])cmd, (int)2, (int)data.length);
        this.transceive(cmd, false);
    }

    private final void $$robo$$android_nfc_tech_MifareClassic$increment(int blockIndex, int value) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        MifareClassic.validateValueOperand(value);
        this.checkConnected();
        ByteBuffer cmd = ByteBuffer.allocate(6);
        cmd.order(ByteOrder.LITTLE_ENDIAN);
        cmd.put((byte)-63);
        cmd.put((byte)blockIndex);
        cmd.putInt(value);
        this.transceive(cmd.array(), false);
    }

    private final void $$robo$$android_nfc_tech_MifareClassic$decrement(int blockIndex, int value) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        MifareClassic.validateValueOperand(value);
        this.checkConnected();
        ByteBuffer cmd = ByteBuffer.allocate(6);
        cmd.order(ByteOrder.LITTLE_ENDIAN);
        cmd.put((byte)-64);
        cmd.put((byte)blockIndex);
        cmd.putInt(value);
        this.transceive(cmd.array(), false);
    }

    private final void $$robo$$android_nfc_tech_MifareClassic$transfer(int blockIndex) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        this.checkConnected();
        byte[] cmd = new byte[]{-80, (byte)blockIndex};
        this.transceive(cmd, false);
    }

    private final void $$robo$$android_nfc_tech_MifareClassic$restore(int blockIndex) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        this.checkConnected();
        byte[] cmd = new byte[]{-62, (byte)blockIndex};
        this.transceive(cmd, false);
    }

    private final byte[] $$robo$$android_nfc_tech_MifareClassic$transceive(byte[] data) throws IOException {
        return this.transceive(data, true);
    }

    private final int $$robo$$android_nfc_tech_MifareClassic$getMaxTransceiveLength() {
        return this.getMaxTransceiveLengthInternal();
    }

    private final void $$robo$$android_nfc_tech_MifareClassic$setTimeout(int timeout) {
        try {
            int err = this.mTag.getTagService().setTimeout(8, timeout);
            if (err != 0) {
                throw new IllegalArgumentException("The supplied timeout is not valid");
            }
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
        }
    }

    private final int $$robo$$android_nfc_tech_MifareClassic$getTimeout() {
        try {
            return this.mTag.getTagService().getTimeout(8);
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
            return 0;
        }
    }

    private static final void $$robo$$android_nfc_tech_MifareClassic$validateSector(int sector) {
        if (sector < 0 || sector >= 40) {
            throw new IndexOutOfBoundsException("sector out of bounds: " + sector);
        }
    }

    private static final void $$robo$$android_nfc_tech_MifareClassic$validateBlock(int block) {
        if (block < 0 || block >= 256) {
            throw new IndexOutOfBoundsException("block out of bounds: " + block);
        }
    }

    private static final void $$robo$$android_nfc_tech_MifareClassic$validateValueOperand(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value operand negative");
        }
    }

    static void __staticInitializer__() {
        KEY_DEFAULT = new byte[]{-1, -1, -1, -1, -1, -1};
        KEY_MIFARE_APPLICATION_DIRECTORY = new byte[]{-96, -95, -94, -93, -92, -91};
        KEY_NFC_FORUM = new byte[]{-45, -9, -45, -9, -45, -9};
    }

    public static MifareClassic get(Tag tag) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_nfc_tech_MifareClassic$get(android.nfc.Tag ), 0, (Tag)tag);
    }

    private void __constructor__(Tag tag) throws RemoteException {
        this.$$robo$$android_nfc_tech_MifareClassic$__constructor__(tag);
    }

    public MifareClassic(Tag tag) throws RemoteException {
        super(tag, 8);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_tech_MifareClassic$__constructor__(android.nfc.Tag ), 0, this, tag);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_nfc_tech_MifareClassic$getType(), 0, this);
    }

    public int getSize() {
        return (int)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_nfc_tech_MifareClassic$getSize(), 0, this);
    }

    public boolean isEmulated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmulated", $$robo$$android_nfc_tech_MifareClassic$isEmulated(), 0, this);
    }

    public int getSectorCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSectorCount", $$robo$$android_nfc_tech_MifareClassic$getSectorCount(), 0, this);
    }

    public int getBlockCount() {
        return (int)InvokeDynamicSupport.bootstrap("getBlockCount", $$robo$$android_nfc_tech_MifareClassic$getBlockCount(), 0, this);
    }

    public int getBlockCountInSector(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getBlockCountInSector", $$robo$$android_nfc_tech_MifareClassic$getBlockCountInSector(int ), 0, this, n);
    }

    public int blockToSector(int n) {
        return (int)InvokeDynamicSupport.bootstrap("blockToSector", $$robo$$android_nfc_tech_MifareClassic$blockToSector(int ), 0, this, n);
    }

    public int sectorToBlock(int n) {
        return (int)InvokeDynamicSupport.bootstrap("sectorToBlock", $$robo$$android_nfc_tech_MifareClassic$sectorToBlock(int ), 0, this, n);
    }

    public boolean authenticateSectorWithKeyA(int n, byte[] byArray) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("authenticateSectorWithKeyA", $$robo$$android_nfc_tech_MifareClassic$authenticateSectorWithKeyA(int byte[] ), 0, this, n, byArray);
    }

    public boolean authenticateSectorWithKeyB(int n, byte[] byArray) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("authenticateSectorWithKeyB", $$robo$$android_nfc_tech_MifareClassic$authenticateSectorWithKeyB(int byte[] ), 0, this, n, byArray);
    }

    private boolean authenticate(int n, byte[] byArray, boolean bl) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_nfc_tech_MifareClassic$authenticate(int byte[] boolean ), 0, this, n, byArray, bl);
    }

    public byte[] readBlock(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("readBlock", $$robo$$android_nfc_tech_MifareClassic$readBlock(int ), 0, this, n);
    }

    public void writeBlock(int n, byte[] byArray) throws IOException {
        InvokeDynamicSupport.bootstrap("writeBlock", $$robo$$android_nfc_tech_MifareClassic$writeBlock(int byte[] ), 0, this, n, byArray);
    }

    public void increment(int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("increment", $$robo$$android_nfc_tech_MifareClassic$increment(int int ), 0, this, n, n2);
    }

    public void decrement(int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("decrement", $$robo$$android_nfc_tech_MifareClassic$decrement(int int ), 0, this, n, n2);
    }

    public void transfer(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("transfer", $$robo$$android_nfc_tech_MifareClassic$transfer(int ), 0, this, n);
    }

    public void restore(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("restore", $$robo$$android_nfc_tech_MifareClassic$restore(int ), 0, this, n);
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return InvokeDynamicSupport.bootstrap("transceive", $$robo$$android_nfc_tech_MifareClassic$transceive(byte[] ), 0, this, byArray);
    }

    public int getMaxTransceiveLength() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxTransceiveLength", $$robo$$android_nfc_tech_MifareClassic$getMaxTransceiveLength(), 0, this);
    }

    public void setTimeout(int n) {
        InvokeDynamicSupport.bootstrap("setTimeout", $$robo$$android_nfc_tech_MifareClassic$setTimeout(int ), 0, this, n);
    }

    public int getTimeout() {
        return (int)InvokeDynamicSupport.bootstrap("getTimeout", $$robo$$android_nfc_tech_MifareClassic$getTimeout(), 0, this);
    }

    private static void validateSector(int n) {
        InvokeDynamicSupport.bootstrapStatic("validateSector", $$robo$$android_nfc_tech_MifareClassic$validateSector(int ), 0, (int)n);
    }

    private static void validateBlock(int n) {
        InvokeDynamicSupport.bootstrapStatic("validateBlock", $$robo$$android_nfc_tech_MifareClassic$validateBlock(int ), 0, (int)n);
    }

    private static void validateValueOperand(int n) {
        InvokeDynamicSupport.bootstrapStatic("validateValueOperand", $$robo$$android_nfc_tech_MifareClassic$validateValueOperand(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(MifareClassic.class);
    }

    public /* synthetic */ MifareClassic() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MifareClassic)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

