/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IMessenger;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean FIND_POTENTIAL_LEAKS = false;
    private static String TAG = "Handler";
    private static Handler MAIN_THREAD_HANDLER;
    Looper mLooper;
    MessageQueue mQueue;
    Callback mCallback;
    boolean mAsynchronous;
    IMessenger mMessenger;

    private final void $$robo$$android_os_Handler$handleMessage(Message msg) {
    }

    private final void $$robo$$android_os_Handler$dispatchMessage(Message msg) {
        if (msg.callback != null) {
            Handler.handleCallback(msg);
        } else {
            if (this.mCallback != null && this.mCallback.handleMessage(msg)) {
                return;
            }
            this.handleMessage(msg);
        }
    }

    private void $$robo$$android_os_Handler$__constructor__() {
    }

    private void $$robo$$android_os_Handler$__constructor__(Callback callback) {
    }

    private void $$robo$$android_os_Handler$__constructor__(Looper looper) {
    }

    private void $$robo$$android_os_Handler$__constructor__(Looper looper, Callback callback) {
    }

    private void $$robo$$android_os_Handler$__constructor__(boolean async) {
    }

    private void $$robo$$android_os_Handler$__constructor__(Callback callback, boolean async) {
        this.mLooper = Looper.myLooper();
        if (this.mLooper == null) {
            throw new RuntimeException("Can't create handler inside thread that has not called Looper.prepare()");
        }
        this.mQueue = this.mLooper.mQueue;
        this.mCallback = callback;
        this.mAsynchronous = async;
    }

    private void $$robo$$android_os_Handler$__constructor__(Looper looper, Callback callback, boolean async) {
        this.mLooper = looper;
        this.mQueue = looper.mQueue;
        this.mCallback = callback;
        this.mAsynchronous = async;
    }

    private static final Handler $$robo$$android_os_Handler$getMain() {
        if (MAIN_THREAD_HANDLER == null) {
            MAIN_THREAD_HANDLER = new Handler(Looper.getMainLooper());
        }
        return MAIN_THREAD_HANDLER;
    }

    private static final Handler $$robo$$android_os_Handler$mainIfNull(Handler handler) {
        return handler == null ? Handler.getMain() : handler;
    }

    private final String $$robo$$android_os_Handler$getTraceName(Message message) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(": ");
        if (message.callback != null) {
            sb.append(message.callback.getClass().getName());
        } else {
            sb.append("#").append(message.what);
        }
        return sb.toString();
    }

    private final String $$robo$$android_os_Handler$getMessageName(Message message) {
        if (message.callback != null) {
            return message.callback.getClass().getName();
        }
        return "0x" + Integer.toHexString(message.what);
    }

    private final Message $$robo$$android_os_Handler$obtainMessage() {
        return Message.obtain(this);
    }

    private final Message $$robo$$android_os_Handler$obtainMessage(int what) {
        return Message.obtain(this, what);
    }

    private final Message $$robo$$android_os_Handler$obtainMessage(int what, Object obj) {
        return Message.obtain(this, what, obj);
    }

    private final Message $$robo$$android_os_Handler$obtainMessage(int what, int arg1, int arg2) {
        return Message.obtain(this, what, arg1, arg2);
    }

    private final Message $$robo$$android_os_Handler$obtainMessage(int what, int arg1, int arg2, Object obj) {
        return Message.obtain(this, what, arg1, arg2, obj);
    }

    private final boolean $$robo$$android_os_Handler$post(Runnable r) {
        return this.sendMessageDelayed(Handler.getPostMessage(r), 0L);
    }

    private final boolean $$robo$$android_os_Handler$postAtTime(Runnable r, long uptimeMillis) {
        return this.sendMessageAtTime(Handler.getPostMessage(r), uptimeMillis);
    }

    private final boolean $$robo$$android_os_Handler$postAtTime(Runnable r, Object token, long uptimeMillis) {
        return this.sendMessageAtTime(Handler.getPostMessage(r, token), uptimeMillis);
    }

    private final boolean $$robo$$android_os_Handler$postDelayed(Runnable r, long delayMillis) {
        return this.sendMessageDelayed(Handler.getPostMessage(r), delayMillis);
    }

    private final boolean $$robo$$android_os_Handler$postAtFrontOfQueue(Runnable r) {
        return this.sendMessageAtFrontOfQueue(Handler.getPostMessage(r));
    }

    private final boolean $$robo$$android_os_Handler$runWithScissors(Runnable r, long timeout) {
        if (r == null) {
            throw new IllegalArgumentException("runnable must not be null");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        if (Looper.myLooper() == this.mLooper) {
            r.run();
            return true;
        }
        BlockingRunnable br = new BlockingRunnable(r);
        return br.postAndWait(this, timeout);
    }

    private final void $$robo$$android_os_Handler$removeCallbacks(Runnable r) {
        this.mQueue.removeMessages(this, r, null);
    }

    private final void $$robo$$android_os_Handler$removeCallbacks(Runnable r, Object token) {
        this.mQueue.removeMessages(this, r, token);
    }

    private final boolean $$robo$$android_os_Handler$sendMessage(Message msg) {
        return this.sendMessageDelayed(msg, 0L);
    }

    private final boolean $$robo$$android_os_Handler$sendEmptyMessage(int what) {
        return this.sendEmptyMessageDelayed(what, 0L);
    }

    private final boolean $$robo$$android_os_Handler$sendEmptyMessageDelayed(int what, long delayMillis) {
        Message msg = Message.obtain();
        msg.what = what;
        return this.sendMessageDelayed(msg, delayMillis);
    }

    private final boolean $$robo$$android_os_Handler$sendEmptyMessageAtTime(int what, long uptimeMillis) {
        Message msg = Message.obtain();
        msg.what = what;
        return this.sendMessageAtTime(msg, uptimeMillis);
    }

    private final boolean $$robo$$android_os_Handler$sendMessageDelayed(Message msg, long delayMillis) {
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        return this.sendMessageAtTime(msg, SystemClock.uptimeMillis() + delayMillis);
    }

    private final boolean $$robo$$android_os_Handler$sendMessageAtTime(Message msg, long uptimeMillis) {
        MessageQueue queue = this.mQueue;
        if (queue == null) {
            RuntimeException e = new RuntimeException(this + " sendMessageAtTime() called with no mQueue");
            Log.w("Looper", e.getMessage(), e);
            return false;
        }
        return this.enqueueMessage(queue, msg, uptimeMillis);
    }

    private final boolean $$robo$$android_os_Handler$sendMessageAtFrontOfQueue(Message msg) {
        MessageQueue queue = this.mQueue;
        if (queue == null) {
            RuntimeException e = new RuntimeException(this + " sendMessageAtTime() called with no mQueue");
            Log.w("Looper", e.getMessage(), e);
            return false;
        }
        return this.enqueueMessage(queue, msg, 0L);
    }

    private final boolean $$robo$$android_os_Handler$enqueueMessage(MessageQueue queue, Message msg, long uptimeMillis) {
        msg.target = this;
        if (this.mAsynchronous) {
            msg.setAsynchronous(true);
        }
        return queue.enqueueMessage(msg, uptimeMillis);
    }

    private final void $$robo$$android_os_Handler$removeMessages(int what) {
        this.mQueue.removeMessages(this, what, null);
    }

    private final void $$robo$$android_os_Handler$removeMessages(int what, Object object) {
        this.mQueue.removeMessages(this, what, object);
    }

    private final void $$robo$$android_os_Handler$removeCallbacksAndMessages(Object token) {
        this.mQueue.removeCallbacksAndMessages(this, token);
    }

    private final boolean $$robo$$android_os_Handler$hasMessages(int what) {
        return this.mQueue.hasMessages(this, what, null);
    }

    private final boolean $$robo$$android_os_Handler$hasMessagesOrCallbacks() {
        return this.mQueue.hasMessages(this);
    }

    private final boolean $$robo$$android_os_Handler$hasMessages(int what, Object object) {
        return this.mQueue.hasMessages(this, what, object);
    }

    private final boolean $$robo$$android_os_Handler$hasCallbacks(Runnable r) {
        return this.mQueue.hasMessages(this, r, null);
    }

    private final Looper $$robo$$android_os_Handler$getLooper() {
        return this.mLooper;
    }

    private final void $$robo$$android_os_Handler$dump(Printer pw, String prefix) {
        pw.println(prefix + this + " @ " + SystemClock.uptimeMillis());
        if (this.mLooper == null) {
            pw.println(prefix + "looper uninitialized");
        } else {
            this.mLooper.dump(pw, prefix + "  ");
        }
    }

    private final void $$robo$$android_os_Handler$dumpMine(Printer pw, String prefix) {
        pw.println(prefix + this + " @ " + SystemClock.uptimeMillis());
        if (this.mLooper == null) {
            pw.println(prefix + "looper uninitialized");
        } else {
            this.mLooper.dump(pw, prefix + "  ", this);
        }
    }

    private final String $$robo$$android_os_Handler$toString() {
        return "Handler (" + this.getClass().getName() + ") {" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IMessenger $$robo$$android_os_Handler$getIMessenger() {
        MessageQueue messageQueue = this.mQueue;
        synchronized (messageQueue) {
            if (this.mMessenger != null) {
                return this.mMessenger;
            }
            this.mMessenger = new MessengerImpl(this);
            return this.mMessenger;
        }
    }

    private static final Message $$robo$$android_os_Handler$getPostMessage(Runnable r) {
        Message m = Message.obtain();
        m.callback = r;
        return m;
    }

    private static final Message $$robo$$android_os_Handler$getPostMessage(Runnable r, Object token) {
        Message m = Message.obtain();
        m.obj = token;
        m.callback = r;
        return m;
    }

    private static final void $$robo$$android_os_Handler$handleCallback(Message message) {
        message.callback.run();
    }

    static void __staticInitializer__() {
        MAIN_THREAD_HANDLER = null;
    }

    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_os_Handler$handleMessage(android.os.Message ), 0, this, message);
    }

    public void dispatchMessage(Message message) {
        InvokeDynamicSupport.bootstrap("dispatchMessage", $$robo$$android_os_Handler$dispatchMessage(android.os.Message ), 0, this, message);
    }

    private void __constructor__() {
        this.$$robo$$android_os_Handler$__constructor__();
    }

    public Handler() {
        this(null, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Handler$__constructor__(), 0, this);
    }

    private void __constructor__(Callback callback) {
        this.$$robo$$android_os_Handler$__constructor__(callback);
    }

    public Handler(Callback callback) {
        this(callback, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Handler$__constructor__(android.os.Handler$Callback ), 0, this, callback);
    }

    private void __constructor__(Looper looper) {
        this.$$robo$$android_os_Handler$__constructor__(looper);
    }

    public Handler(Looper looper) {
        this(looper, null, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Handler$__constructor__(android.os.Looper ), 0, this, looper);
    }

    private void __constructor__(Looper looper, Callback callback) {
        this.$$robo$$android_os_Handler$__constructor__(looper, callback);
    }

    public Handler(Looper looper, Callback callback) {
        this(looper, callback, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Handler$__constructor__(android.os.Looper android.os.Handler$Callback ), 0, this, looper, callback);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_os_Handler$__constructor__(bl);
    }

    public Handler(boolean bl) {
        this(null, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Handler$__constructor__(boolean ), 0, this, bl);
    }

    private void __constructor__(Callback callback, boolean bl) {
        this.$$robo$$android_os_Handler$__constructor__(callback, bl);
    }

    public Handler(Callback callback, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Handler$__constructor__(android.os.Handler$Callback boolean ), 0, this, callback, bl);
    }

    private void __constructor__(Looper looper, Callback callback, boolean bl) {
        this.$$robo$$android_os_Handler$__constructor__(looper, callback, bl);
    }

    public Handler(Looper looper, Callback callback, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Handler$__constructor__(android.os.Looper android.os.Handler$Callback boolean ), 0, this, looper, callback, bl);
    }

    public static Handler getMain() {
        return InvokeDynamicSupport.bootstrapStatic("getMain", $$robo$$android_os_Handler$getMain(), 0);
    }

    public static Handler mainIfNull(Handler handler) {
        return InvokeDynamicSupport.bootstrapStatic("mainIfNull", $$robo$$android_os_Handler$mainIfNull(android.os.Handler ), 0, (Handler)handler);
    }

    public String getTraceName(Message message) {
        return InvokeDynamicSupport.bootstrap("getTraceName", $$robo$$android_os_Handler$getTraceName(android.os.Message ), 0, this, message);
    }

    public String getMessageName(Message message) {
        return InvokeDynamicSupport.bootstrap("getMessageName", $$robo$$android_os_Handler$getMessageName(android.os.Message ), 0, this, message);
    }

    public Message obtainMessage() {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$android_os_Handler$obtainMessage(), 0, this);
    }

    public Message obtainMessage(int n) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$android_os_Handler$obtainMessage(int ), 0, this, n);
    }

    public Message obtainMessage(int n, Object object) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$android_os_Handler$obtainMessage(int java.lang.Object ), 0, this, n, object);
    }

    public Message obtainMessage(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$android_os_Handler$obtainMessage(int int int ), 0, this, n, n2, n3);
    }

    public Message obtainMessage(int n, int n2, int n3, Object object) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$android_os_Handler$obtainMessage(int int int java.lang.Object ), 0, this, n, n2, n3, object);
    }

    public boolean post(Runnable runnable) {
        return (boolean)InvokeDynamicSupport.bootstrap("post", $$robo$$android_os_Handler$post(java.lang.Runnable ), 0, this, runnable);
    }

    public boolean postAtTime(Runnable runnable, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("postAtTime", $$robo$$android_os_Handler$postAtTime(java.lang.Runnable long ), 0, this, runnable, l);
    }

    public boolean postAtTime(Runnable runnable, Object object, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("postAtTime", $$robo$$android_os_Handler$postAtTime(java.lang.Runnable java.lang.Object long ), 0, this, runnable, object, l);
    }

    public boolean postDelayed(Runnable runnable, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("postDelayed", $$robo$$android_os_Handler$postDelayed(java.lang.Runnable long ), 0, this, runnable, l);
    }

    public boolean postAtFrontOfQueue(Runnable runnable) {
        return (boolean)InvokeDynamicSupport.bootstrap("postAtFrontOfQueue", $$robo$$android_os_Handler$postAtFrontOfQueue(java.lang.Runnable ), 0, this, runnable);
    }

    public boolean runWithScissors(Runnable runnable, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("runWithScissors", $$robo$$android_os_Handler$runWithScissors(java.lang.Runnable long ), 0, this, runnable, l);
    }

    public void removeCallbacks(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("removeCallbacks", $$robo$$android_os_Handler$removeCallbacks(java.lang.Runnable ), 0, this, runnable);
    }

    public void removeCallbacks(Runnable runnable, Object object) {
        InvokeDynamicSupport.bootstrap("removeCallbacks", $$robo$$android_os_Handler$removeCallbacks(java.lang.Runnable java.lang.Object ), 0, this, runnable, object);
    }

    public boolean sendMessage(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_os_Handler$sendMessage(android.os.Message ), 0, this, message);
    }

    public boolean sendEmptyMessage(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendEmptyMessage", $$robo$$android_os_Handler$sendEmptyMessage(int ), 0, this, n);
    }

    public boolean sendEmptyMessageDelayed(int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendEmptyMessageDelayed", $$robo$$android_os_Handler$sendEmptyMessageDelayed(int long ), 0, this, n, l);
    }

    public boolean sendEmptyMessageAtTime(int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendEmptyMessageAtTime", $$robo$$android_os_Handler$sendEmptyMessageAtTime(int long ), 0, this, n, l);
    }

    public boolean sendMessageDelayed(Message message, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMessageDelayed", $$robo$$android_os_Handler$sendMessageDelayed(android.os.Message long ), 0, this, message, l);
    }

    public boolean sendMessageAtTime(Message message, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMessageAtTime", $$robo$$android_os_Handler$sendMessageAtTime(android.os.Message long ), 0, this, message, l);
    }

    public boolean sendMessageAtFrontOfQueue(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMessageAtFrontOfQueue", $$robo$$android_os_Handler$sendMessageAtFrontOfQueue(android.os.Message ), 0, this, message);
    }

    private boolean enqueueMessage(MessageQueue messageQueue, Message message, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("enqueueMessage", $$robo$$android_os_Handler$enqueueMessage(android.os.MessageQueue android.os.Message long ), 0, this, messageQueue, message, l);
    }

    public void removeMessages(int n) {
        InvokeDynamicSupport.bootstrap("removeMessages", $$robo$$android_os_Handler$removeMessages(int ), 0, this, n);
    }

    public void removeMessages(int n, Object object) {
        InvokeDynamicSupport.bootstrap("removeMessages", $$robo$$android_os_Handler$removeMessages(int java.lang.Object ), 0, this, n, object);
    }

    public void removeCallbacksAndMessages(Object object) {
        InvokeDynamicSupport.bootstrap("removeCallbacksAndMessages", $$robo$$android_os_Handler$removeCallbacksAndMessages(java.lang.Object ), 0, this, object);
    }

    public boolean hasMessages(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$android_os_Handler$hasMessages(int ), 0, this, n);
    }

    public boolean hasMessagesOrCallbacks() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessagesOrCallbacks", $$robo$$android_os_Handler$hasMessagesOrCallbacks(), 0, this);
    }

    public boolean hasMessages(int n, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$android_os_Handler$hasMessages(int java.lang.Object ), 0, this, n, object);
    }

    public boolean hasCallbacks(Runnable runnable) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCallbacks", $$robo$$android_os_Handler$hasCallbacks(java.lang.Runnable ), 0, this, runnable);
    }

    public Looper getLooper() {
        return InvokeDynamicSupport.bootstrap("getLooper", $$robo$$android_os_Handler$getLooper(), 0, this);
    }

    public void dump(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_Handler$dump(android.util.Printer java.lang.String ), 0, this, printer, string2);
    }

    public void dumpMine(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dumpMine", $$robo$$android_os_Handler$dumpMine(android.util.Printer java.lang.String ), 0, this, printer, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_Handler$toString(), 0, this);
    }

    IMessenger getIMessenger() {
        return InvokeDynamicSupport.bootstrap("getIMessenger", $$robo$$android_os_Handler$getIMessenger(), 0, this);
    }

    private static Message getPostMessage(Runnable runnable) {
        return InvokeDynamicSupport.bootstrapStatic("getPostMessage", $$robo$$android_os_Handler$getPostMessage(java.lang.Runnable ), 0, (Runnable)runnable);
    }

    private static Message getPostMessage(Runnable runnable, Object object) {
        return InvokeDynamicSupport.bootstrapStatic("getPostMessage", $$robo$$android_os_Handler$getPostMessage(java.lang.Runnable java.lang.Object ), 0, (Runnable)runnable, (Object)object);
    }

    private static void handleCallback(Message message) {
        InvokeDynamicSupport.bootstrapStatic("handleCallback", $$robo$$android_os_Handler$handleCallback(android.os.Message ), 0, (Message)message);
    }

    static {
        RobolectricInternals.classInitializing(Handler.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Handler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class BlockingRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Runnable mTask;
        private boolean mDone;

        private void $$robo$$android_os_Handler_BlockingRunnable$__constructor__(Runnable task) {
            this.mTask = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_Handler_BlockingRunnable$run() {
            try {
                this.mTask.run();
            }
            finally {
                BlockingRunnable blockingRunnable = this;
                synchronized (blockingRunnable) {
                    this.mDone = true;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_os_Handler_BlockingRunnable$postAndWait(Handler handler, long timeout) {
            if (!handler.post(this)) {
                return false;
            }
            BlockingRunnable blockingRunnable = this;
            synchronized (blockingRunnable) {
                if (timeout > 0L) {
                    long expirationTime = SystemClock.uptimeMillis() + timeout;
                    while (!this.mDone) {
                        long delay = expirationTime - SystemClock.uptimeMillis();
                        if (delay <= 0L) {
                            return false;
                        }
                        try {
                            this.wait(delay);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    while (!this.mDone) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            return true;
        }

        private void __constructor__(Runnable runnable) {
            this.$$robo$$android_os_Handler_BlockingRunnable$__constructor__(runnable);
        }

        public BlockingRunnable(Runnable runnable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Handler_BlockingRunnable$__constructor__(java.lang.Runnable ), 0, this, runnable);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_Handler_BlockingRunnable$run(), 0, this);
        }

        public boolean postAndWait(Handler handler, long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("postAndWait", $$robo$$android_os_Handler_BlockingRunnable$postAndWait(android.os.Handler long ), 0, this, handler, l);
        }

        public /* synthetic */ BlockingRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BlockingRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class MessengerImpl
    extends IMessenger.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ Handler this$0;

        private void $$robo$$android_os_Handler_MessengerImpl$__constructor__(Handler handler) {
        }

        private final void $$robo$$android_os_Handler_MessengerImpl$send(Message msg) {
            msg.sendingUid = Binder.getCallingUid();
            this.this$0.sendMessage(msg);
        }

        private /* synthetic */ void $$robo$$android_os_Handler_MessengerImpl$__constructor__(Handler x0, 1 x1) {
        }

        private void __constructor__(Handler handler) {
            this.$$robo$$android_os_Handler_MessengerImpl$__constructor__(handler);
        }

        private MessengerImpl(Handler handler) {
            this.this$0 = handler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Handler_MessengerImpl$__constructor__(android.os.Handler ), 0, this, handler);
        }

        @Override
        public void send(Message message) {
            InvokeDynamicSupport.bootstrap("send", $$robo$$android_os_Handler_MessengerImpl$send(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(Handler handler, 1 var2_2) {
            this.$$robo$$android_os_Handler_MessengerImpl$__constructor__(handler, var2_2);
        }

        public /* synthetic */ MessengerImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessengerImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Callback
    extends InstrumentedInterface {
        public boolean handleMessage(Message var1);
    }
}

