/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SharedMemory;
import android.system.ErrnoException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MemoryFile
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private SharedMemory mSharedMemory;
    private ByteBuffer mMapping;
    private boolean mAllowPurging;

    private static final boolean $$robo$$android_os_MemoryFile$native_pin(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        return false;
    }

    private static final int $$robo$$android_os_MemoryFile$native_get_size(FileDescriptor fileDescriptor) throws IOException {
        return 0;
    }

    private void $$robo$$android_os_MemoryFile$__constructor__(String name, int length) throws IOException {
        this.mAllowPurging = false;
        try {
            this.mSharedMemory = SharedMemory.create(name, length);
            this.mMapping = this.mSharedMemory.mapReadWrite();
        }
        catch (ErrnoException ex) {
            ex.rethrowAsIOException();
        }
    }

    private final void $$robo$$android_os_MemoryFile$close() {
        this.deactivate();
        this.mSharedMemory.close();
    }

    private final void $$robo$$android_os_MemoryFile$deactivate() {
        if (this.mMapping != null) {
            SharedMemory.unmap(this.mMapping);
            this.mMapping = null;
        }
    }

    private final void $$robo$$android_os_MemoryFile$checkActive() throws IOException {
        if (this.mMapping == null) {
            throw new IOException("MemoryFile has been deactivated");
        }
    }

    private final void $$robo$$android_os_MemoryFile$beginAccess() throws IOException {
        this.checkActive();
        if (this.mAllowPurging && MemoryFile.native_pin(this.mSharedMemory.getFileDescriptor(), true)) {
            throw new IOException("MemoryFile has been purged");
        }
    }

    private final void $$robo$$android_os_MemoryFile$endAccess() throws IOException {
        if (this.mAllowPurging) {
            MemoryFile.native_pin(this.mSharedMemory.getFileDescriptor(), false);
        }
    }

    private final int $$robo$$android_os_MemoryFile$length() {
        return this.mSharedMemory.getSize();
    }

    @Deprecated
    private final boolean $$robo$$android_os_MemoryFile$isPurgingAllowed() {
        return this.mAllowPurging;
    }

    @Deprecated
    private final synchronized boolean $$robo$$android_os_MemoryFile$allowPurging(boolean allowPurging) throws IOException {
        boolean oldValue = this.mAllowPurging;
        if (oldValue != allowPurging) {
            MemoryFile.native_pin(this.mSharedMemory.getFileDescriptor(), !allowPurging);
            this.mAllowPurging = allowPurging;
        }
        return oldValue;
    }

    private final InputStream $$robo$$android_os_MemoryFile$getInputStream() {
        return new MemoryInputStream(this);
    }

    private final OutputStream $$robo$$android_os_MemoryFile$getOutputStream() {
        return new MemoryOutputStream(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_os_MemoryFile$readBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        this.beginAccess();
        try {
            this.mMapping.position(srcOffset);
            this.mMapping.get(buffer, destOffset, count);
        }
        finally {
            this.endAccess();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MemoryFile$writeBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        this.beginAccess();
        try {
            this.mMapping.position(destOffset);
            this.mMapping.put(buffer, srcOffset, count);
        }
        finally {
            this.endAccess();
        }
    }

    private final FileDescriptor $$robo$$android_os_MemoryFile$getFileDescriptor() throws IOException {
        return this.mSharedMemory.getFileDescriptor();
    }

    private static final int $$robo$$android_os_MemoryFile$getSize(FileDescriptor fd) throws IOException {
        return MemoryFile.native_get_size(fd);
    }

    static void __staticInitializer__() {
        TAG = "MemoryFile";
    }

    private static final native /* synthetic */ boolean $$robo$$native_pin$nativeBinding(FileDescriptor var0, boolean var1) throws IOException;

    private static boolean native_pin(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_pin", $$robo$$android_os_MemoryFile$native_pin(java.io.FileDescriptor boolean ), 1, (FileDescriptor)fileDescriptor, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$native_get_size$nativeBinding(FileDescriptor var0) throws IOException;

    private static int native_get_size(FileDescriptor fileDescriptor) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_size", $$robo$$android_os_MemoryFile$native_get_size(java.io.FileDescriptor ), 1, (FileDescriptor)fileDescriptor);
    }

    private void __constructor__(String string2, int n) throws IOException {
        this.$$robo$$android_os_MemoryFile$__constructor__(string2, n);
    }

    public MemoryFile(String string2, int n) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_MemoryFile$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_MemoryFile$close(), 0, this);
    }

    void deactivate() {
        InvokeDynamicSupport.bootstrap("deactivate", $$robo$$android_os_MemoryFile$deactivate(), 0, this);
    }

    private void checkActive() throws IOException {
        InvokeDynamicSupport.bootstrap("checkActive", $$robo$$android_os_MemoryFile$checkActive(), 0, this);
    }

    private void beginAccess() throws IOException {
        InvokeDynamicSupport.bootstrap("beginAccess", $$robo$$android_os_MemoryFile$beginAccess(), 0, this);
    }

    private void endAccess() throws IOException {
        InvokeDynamicSupport.bootstrap("endAccess", $$robo$$android_os_MemoryFile$endAccess(), 0, this);
    }

    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_os_MemoryFile$length(), 0, this);
    }

    @Deprecated
    public boolean isPurgingAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPurgingAllowed", $$robo$$android_os_MemoryFile$isPurgingAllowed(), 0, this);
    }

    @Deprecated
    public synchronized boolean allowPurging(boolean bl) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("allowPurging", $$robo$$android_os_MemoryFile$allowPurging(boolean ), 0, this, bl);
    }

    public InputStream getInputStream() {
        return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$android_os_MemoryFile$getInputStream(), 0, this);
    }

    public OutputStream getOutputStream() {
        return InvokeDynamicSupport.bootstrap("getOutputStream", $$robo$$android_os_MemoryFile$getOutputStream(), 0, this);
    }

    public int readBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("readBytes", $$robo$$android_os_MemoryFile$readBytes(byte[] int int int ), 0, this, byArray, n, n2, n3);
    }

    public void writeBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        InvokeDynamicSupport.bootstrap("writeBytes", $$robo$$android_os_MemoryFile$writeBytes(byte[] int int int ), 0, this, byArray, n, n2, n3);
    }

    public FileDescriptor getFileDescriptor() throws IOException {
        return InvokeDynamicSupport.bootstrap("getFileDescriptor", $$robo$$android_os_MemoryFile$getFileDescriptor(), 0, this);
    }

    public static int getSize(FileDescriptor fileDescriptor) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSize", $$robo$$android_os_MemoryFile$getSize(java.io.FileDescriptor ), 0, (FileDescriptor)fileDescriptor);
    }

    static {
        RobolectricInternals.classInitializing(MemoryFile.class);
    }

    public /* synthetic */ MemoryFile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryFile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MemoryOutputStream
    extends OutputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mOffset;
        private byte[] mSingleByte;
        /* synthetic */ MemoryFile this$0;

        private void $$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(MemoryFile memoryFile) {
            this.mOffset = 0;
        }

        private final void $$robo$$android_os_MemoryFile_MemoryOutputStream$write(byte[] buffer, int offset, int count) throws IOException {
            this.this$0.writeBytes(buffer, offset, this.mOffset, count);
            this.mOffset += count;
        }

        private final void $$robo$$android_os_MemoryFile_MemoryOutputStream$write(int oneByte) throws IOException {
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            this.mSingleByte[0] = (byte)oneByte;
            this.write(this.mSingleByte, 0, 1);
        }

        private /* synthetic */ void $$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(MemoryFile x0, 1 x1) {
        }

        private void __constructor__(MemoryFile memoryFile) {
            this.$$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(memoryFile);
        }

        private MemoryOutputStream(MemoryFile memoryFile) {
            this.this$0 = memoryFile;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(android.os.MemoryFile ), 0, this, memoryFile);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_os_MemoryFile_MemoryOutputStream$write(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_os_MemoryFile_MemoryOutputStream$write(int ), 0, this, n);
        }

        private /* synthetic */ void __constructor__(MemoryFile memoryFile, 1 var2_2) {
            this.$$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(memoryFile, var2_2);
        }

        public /* synthetic */ MemoryOutputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryOutputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MemoryInputStream
    extends InputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mMark;
        private int mOffset;
        private byte[] mSingleByte;
        /* synthetic */ MemoryFile this$0;

        private void $$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(MemoryFile memoryFile) {
            this.mMark = 0;
            this.mOffset = 0;
        }

        private final int $$robo$$android_os_MemoryFile_MemoryInputStream$available() throws IOException {
            if (this.mOffset >= this.this$0.mSharedMemory.getSize()) {
                return 0;
            }
            return this.this$0.mSharedMemory.getSize() - this.mOffset;
        }

        private final boolean $$robo$$android_os_MemoryFile_MemoryInputStream$markSupported() {
            return true;
        }

        private final void $$robo$$android_os_MemoryFile_MemoryInputStream$mark(int readlimit) {
            this.mMark = this.mOffset;
        }

        private final void $$robo$$android_os_MemoryFile_MemoryInputStream$reset() throws IOException {
            this.mOffset = this.mMark;
        }

        private final int $$robo$$android_os_MemoryFile_MemoryInputStream$read() throws IOException {
            int result;
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            if ((result = this.read(this.mSingleByte, 0, 1)) != 1) {
                return -1;
            }
            return this.mSingleByte[0];
        }

        private final int $$robo$$android_os_MemoryFile_MemoryInputStream$read(byte[] buffer, int offset, int count) throws IOException {
            if (offset < 0 || count < 0 || offset + count > buffer.length) {
                throw new IndexOutOfBoundsException();
            }
            if ((count = Math.min(count, this.available())) < 1) {
                return -1;
            }
            int result = this.this$0.readBytes(buffer, this.mOffset, offset, count);
            if (result > 0) {
                this.mOffset += result;
            }
            return result;
        }

        private final long $$robo$$android_os_MemoryFile_MemoryInputStream$skip(long n) throws IOException {
            if ((long)this.mOffset + n > (long)this.this$0.mSharedMemory.getSize()) {
                n = this.this$0.mSharedMemory.getSize() - this.mOffset;
            }
            this.mOffset = (int)((long)this.mOffset + n);
            return n;
        }

        private /* synthetic */ void $$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(MemoryFile x0, 1 x1) {
        }

        private void __constructor__(MemoryFile memoryFile) {
            this.$$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(memoryFile);
        }

        private MemoryInputStream(MemoryFile memoryFile) {
            this.this$0 = memoryFile;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(android.os.MemoryFile ), 0, this, memoryFile);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_os_MemoryFile_MemoryInputStream$available(), 0, this);
        }

        @Override
        public boolean markSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("markSupported", $$robo$$android_os_MemoryFile_MemoryInputStream$markSupported(), 0, this);
        }

        @Override
        public void mark(int n) {
            InvokeDynamicSupport.bootstrap("mark", $$robo$$android_os_MemoryFile_MemoryInputStream$mark(int ), 0, this, n);
        }

        @Override
        public void reset() throws IOException {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_os_MemoryFile_MemoryInputStream$reset(), 0, this);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_os_MemoryFile_MemoryInputStream$read(), 0, this);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_os_MemoryFile_MemoryInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("skip", $$robo$$android_os_MemoryFile_MemoryInputStream$skip(long ), 0, this, l);
        }

        private /* synthetic */ void __constructor__(MemoryFile memoryFile, 1 var2_2) {
            this.$$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(memoryFile, var2_2);
        }

        public /* synthetic */ MemoryInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

