/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Debug;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.util.function.Consumer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RemoteCallbackList<E extends IInterface> {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RemoteCallbackList";
    ArrayMap<IBinder, Callback> mCallbacks;
    private Object[] mActiveBroadcast;
    private int mBroadcastCount;
    private boolean mKilled;
    private StringBuilder mRecentCallers;

    private void $$robo$$android_os_RemoteCallbackList$__constructor__() {
        this.mCallbacks = new ArrayMap();
        this.mBroadcastCount = -1;
        this.mKilled = false;
    }

    private final boolean $$robo$$android_os_RemoteCallbackList$register(E callback) {
        return this.register(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_RemoteCallbackList$register(E callback, Object cookie) {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            if (this.mKilled) {
                return false;
            }
            this.logExcessiveCallbacks();
            IBinder binder = callback.asBinder();
            try {
                Callback cb = new Callback(this, callback, cookie);
                binder.linkToDeath(cb, 0);
                this.mCallbacks.put(binder, cb);
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_RemoteCallbackList$unregister(E callback) {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            Callback cb = this.mCallbacks.remove(callback.asBinder());
            if (cb != null) {
                cb.mCallback.asBinder().unlinkToDeath(cb, 0);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_RemoteCallbackList$kill() {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            for (int cbi = this.mCallbacks.size() - 1; cbi >= 0; --cbi) {
                Callback cb = this.mCallbacks.valueAt(cbi);
                cb.mCallback.asBinder().unlinkToDeath(cb, 0);
            }
            this.mCallbacks.clear();
            this.mKilled = true;
        }
    }

    private final void $$robo$$android_os_RemoteCallbackList$onCallbackDied(E callback) {
    }

    private final void $$robo$$android_os_RemoteCallbackList$onCallbackDied(E callback, Object cookie) {
        this.onCallbackDied(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_os_RemoteCallbackList$beginBroadcast() {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            if (this.mBroadcastCount > 0) {
                throw new IllegalStateException("beginBroadcast() called while already in a broadcast");
            }
            this.mBroadcastCount = this.mCallbacks.size();
            int N = this.mBroadcastCount;
            if (N <= 0) {
                return 0;
            }
            Object[] active = this.mActiveBroadcast;
            if (active == null || active.length < N) {
                this.mActiveBroadcast = active = new Object[N];
            }
            for (int i = 0; i < N; ++i) {
                active[i] = this.mCallbacks.valueAt(i);
            }
            return N;
        }
    }

    private final E $$robo$$android_os_RemoteCallbackList$getBroadcastItem(int index) {
        return ((Callback)this.mActiveBroadcast[index]).mCallback;
    }

    private final Object $$robo$$android_os_RemoteCallbackList$getBroadcastCookie(int index) {
        return ((Callback)this.mActiveBroadcast[index]).mCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_RemoteCallbackList$finishBroadcast() {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            if (this.mBroadcastCount < 0) {
                throw new IllegalStateException("finishBroadcast() called outside of a broadcast");
            }
            Object[] active = this.mActiveBroadcast;
            if (active != null) {
                int N = this.mBroadcastCount;
                for (int i = 0; i < N; ++i) {
                    active[i] = null;
                }
            }
            this.mBroadcastCount = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_RemoteCallbackList$broadcast(Consumer<E> action) {
        int itemCount = this.beginBroadcast();
        try {
            for (int i = 0; i < itemCount; ++i) {
                action.accept(this.getBroadcastItem(i));
            }
        }
        finally {
            this.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_os_RemoteCallbackList$getRegisteredCallbackCount() {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            if (this.mKilled) {
                return 0;
            }
            return this.mCallbacks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final E $$robo$$android_os_RemoteCallbackList$getRegisteredCallbackItem(int index) {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            if (this.mKilled) {
                return null;
            }
            return this.mCallbacks.valueAt((int)index).mCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object $$robo$$android_os_RemoteCallbackList$getRegisteredCallbackCookie(int index) {
        ArrayMap<IBinder, Callback> arrayMap = this.mCallbacks;
        synchronized (arrayMap) {
            if (this.mKilled) {
                return null;
            }
            return this.mCallbacks.valueAt((int)index).mCookie;
        }
    }

    private final void $$robo$$android_os_RemoteCallbackList$logExcessiveCallbacks() {
        long size = this.mCallbacks.size();
        long TOO_MANY = 3000L;
        long MAX_CHARS = 1000L;
        if (size >= 3000L) {
            if (size == 3000L && this.mRecentCallers == null) {
                this.mRecentCallers = new StringBuilder();
            }
            if (this.mRecentCallers != null && (long)this.mRecentCallers.length() < 1000L) {
                this.mRecentCallers.append(Debug.getCallers(5));
                this.mRecentCallers.append('\n');
                if ((long)this.mRecentCallers.length() >= 1000L) {
                    Slog.wtf("RemoteCallbackList", "More than 3000 remote callbacks registered. Recent callers:\n" + this.mRecentCallers.toString());
                    this.mRecentCallers = null;
                }
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$android_os_RemoteCallbackList$__constructor__();
    }

    public RemoteCallbackList() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_RemoteCallbackList$__constructor__(), 0, this);
    }

    public boolean register(E e) {
        return (boolean)InvokeDynamicSupport.bootstrap("register", $$robo$$android_os_RemoteCallbackList$register(E ), 0, this, e);
    }

    public boolean register(E e, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("register", $$robo$$android_os_RemoteCallbackList$register(E java.lang.Object ), 0, this, e, object);
    }

    public boolean unregister(E e) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregister", $$robo$$android_os_RemoteCallbackList$unregister(E ), 0, this, e);
    }

    public void kill() {
        InvokeDynamicSupport.bootstrap("kill", $$robo$$android_os_RemoteCallbackList$kill(), 0, this);
    }

    public void onCallbackDied(E e) {
        InvokeDynamicSupport.bootstrap("onCallbackDied", $$robo$$android_os_RemoteCallbackList$onCallbackDied(E ), 0, this, e);
    }

    public void onCallbackDied(E e, Object object) {
        InvokeDynamicSupport.bootstrap("onCallbackDied", $$robo$$android_os_RemoteCallbackList$onCallbackDied(E java.lang.Object ), 0, this, e, object);
    }

    public int beginBroadcast() {
        return (int)InvokeDynamicSupport.bootstrap("beginBroadcast", $$robo$$android_os_RemoteCallbackList$beginBroadcast(), 0, this);
    }

    public E getBroadcastItem(int n) {
        return (E)InvokeDynamicSupport.bootstrap("getBroadcastItem", $$robo$$android_os_RemoteCallbackList$getBroadcastItem(int ), 0, this, n);
    }

    public Object getBroadcastCookie(int n) {
        return InvokeDynamicSupport.bootstrap("getBroadcastCookie", $$robo$$android_os_RemoteCallbackList$getBroadcastCookie(int ), 0, this, n);
    }

    public void finishBroadcast() {
        InvokeDynamicSupport.bootstrap("finishBroadcast", $$robo$$android_os_RemoteCallbackList$finishBroadcast(), 0, this);
    }

    public void broadcast(Consumer<E> consumer) {
        InvokeDynamicSupport.bootstrap("broadcast", $$robo$$android_os_RemoteCallbackList$broadcast(java.util.function.Consumer<E> ), 0, this, consumer);
    }

    public int getRegisteredCallbackCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRegisteredCallbackCount", $$robo$$android_os_RemoteCallbackList$getRegisteredCallbackCount(), 0, this);
    }

    public E getRegisteredCallbackItem(int n) {
        return (E)InvokeDynamicSupport.bootstrap("getRegisteredCallbackItem", $$robo$$android_os_RemoteCallbackList$getRegisteredCallbackItem(int ), 0, this, n);
    }

    public Object getRegisteredCallbackCookie(int n) {
        return InvokeDynamicSupport.bootstrap("getRegisteredCallbackCookie", $$robo$$android_os_RemoteCallbackList$getRegisteredCallbackCookie(int ), 0, this, n);
    }

    private void logExcessiveCallbacks() {
        InvokeDynamicSupport.bootstrap("logExcessiveCallbacks", $$robo$$android_os_RemoteCallbackList$logExcessiveCallbacks(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteCallbackList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class Callback
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        E mCallback;
        Object mCookie;
        /* synthetic */ RemoteCallbackList this$0;

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_os_RemoteCallbackList_Callback$__constructor__(RemoteCallbackList remoteCallbackList, IInterface callback, Object cookie) {
            this.mCallback = callback;
            this.mCookie = cookie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_RemoteCallbackList_Callback$binderDied() {
            ArrayMap<IBinder, Callback> arrayMap = this.this$0.mCallbacks;
            synchronized (arrayMap) {
                this.this$0.mCallbacks.remove(this.mCallback.asBinder());
            }
            this.this$0.onCallbackDied(this.mCallback, this.mCookie);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(RemoteCallbackList remoteCallbackList, IInterface iInterface, Object object) {
            this.$$robo$$android_os_RemoteCallbackList_Callback$__constructor__(remoteCallbackList, iInterface, object);
        }

        Callback(E e, Object object) {
            this.this$0 = var1_1;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_RemoteCallbackList_Callback$__constructor__(android.os.RemoteCallbackList android.os.IInterface java.lang.Object ), 0, this, var1_1, e, object);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_os_RemoteCallbackList_Callback$binderDied(), 0, this);
        }

        public /* synthetic */ Callback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

