/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class SharedMemory
implements Parcelable,
Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private FileDescriptor mFileDescriptor;
    private int mSize;
    private MemoryRegistration mMemoryRegistration;
    private Cleaner.Cleanable mCleaner;
    private static int PROT_MASK;
    public static Parcelable.Creator<SharedMemory> CREATOR;

    private void $$robo$$android_os_SharedMemory$__constructor__(FileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("Unable to create SharedMemory from a null FileDescriptor");
        }
        if (!fd.valid()) {
            throw new IllegalArgumentException("Unable to create SharedMemory from closed FileDescriptor");
        }
        this.mFileDescriptor = fd;
        this.mSize = SharedMemory.nGetSize(this.mFileDescriptor);
        if (this.mSize <= 0) {
            throw new IllegalArgumentException("FileDescriptor is not a valid ashmem fd");
        }
        this.mMemoryRegistration = new MemoryRegistration(this.mSize);
        this.mCleaner = InvokeDynamicSupport.bootstrapIntrinsic("create", "sun.misc.Cleaner", (Object)this.mFileDescriptor, (Runnable)new Closer(this.mFileDescriptor, this.mMemoryRegistration));
    }

    private static final SharedMemory $$robo$$android_os_SharedMemory$create(String name, int size) throws ErrnoException {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        return new SharedMemory(SharedMemory.nCreate(name, size));
    }

    private final void $$robo$$android_os_SharedMemory$checkOpen() {
        if (!this.mFileDescriptor.valid()) {
            throw new IllegalStateException("SharedMemory is closed");
        }
    }

    private static final void $$robo$$android_os_SharedMemory$validateProt(int prot) {
        if ((prot & ~PROT_MASK) != 0) {
            throw new IllegalArgumentException("Invalid prot value");
        }
    }

    private final boolean $$robo$$android_os_SharedMemory$setProtect(int prot) {
        this.checkOpen();
        SharedMemory.validateProt(prot);
        int errno = SharedMemory.nSetProt(this.mFileDescriptor, prot);
        return errno == 0;
    }

    private final FileDescriptor $$robo$$android_os_SharedMemory$getFileDescriptor() {
        return this.mFileDescriptor;
    }

    private final int $$robo$$android_os_SharedMemory$getFd() {
        return (int)InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)this.mFileDescriptor);
    }

    private final int $$robo$$android_os_SharedMemory$getSize() {
        this.checkOpen();
        return this.mSize;
    }

    private final ByteBuffer $$robo$$android_os_SharedMemory$mapReadWrite() throws ErrnoException {
        return this.map(OsConstants.PROT_READ | OsConstants.PROT_WRITE, 0, this.mSize);
    }

    private final ByteBuffer $$robo$$android_os_SharedMemory$mapReadOnly() throws ErrnoException {
        return this.map(OsConstants.PROT_READ, 0, this.mSize);
    }

    private final ByteBuffer $$robo$$android_os_SharedMemory$map(int prot, int offset, int length) throws ErrnoException {
        this.checkOpen();
        SharedMemory.validateProt(prot);
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be >= 0");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        if (offset + length > this.mSize) {
            throw new IllegalArgumentException("offset + length must not exceed getSize()");
        }
        long address = Os.mmap(0L, length, prot, OsConstants.MAP_SHARED, this.mFileDescriptor, offset);
        boolean readOnly = (prot & OsConstants.PROT_WRITE) == 0;
        Unmapper unmapper = new Unmapper(address, length, this.mMemoryRegistration.acquire());
        return new DirectByteBuffer(length, address, this.mFileDescriptor, (Runnable)unmapper, readOnly);
    }

    private static final void $$robo$$android_os_SharedMemory$unmap(ByteBuffer buffer) {
        if (!(buffer instanceof DirectByteBuffer)) {
            throw new IllegalArgumentException("ByteBuffer wasn't created by #map(int, int, int); can't unmap");
        }
        InvokeDynamicSupport.bootstrapIntrinsic("freeDirectBuffer", "java.nio.NioUtils", (ByteBuffer)buffer);
    }

    private final void $$robo$$android_os_SharedMemory$close() {
        if (this.mCleaner != null) {
            InvokeDynamicSupport.bootstrapIntrinsic("clean", "sun.misc.Cleaner", (Cleaner.Cleanable)this.mCleaner);
            this.mCleaner = null;
        }
    }

    private final int $$robo$$android_os_SharedMemory$describeContents() {
        return 1;
    }

    private final void $$robo$$android_os_SharedMemory$writeToParcel(Parcel dest, int flags) {
        this.checkOpen();
        dest.writeFileDescriptor(this.mFileDescriptor);
    }

    private static final FileDescriptor $$robo$$android_os_SharedMemory$nCreate(String string2, int n) throws ErrnoException {
        return null;
    }

    private static final int $$robo$$android_os_SharedMemory$nGetSize(FileDescriptor fileDescriptor) {
        return 0;
    }

    private static final int $$robo$$android_os_SharedMemory$nSetProt(FileDescriptor fileDescriptor, int n) {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_os_SharedMemory$__constructor__(FileDescriptor x0, 1 x1) {
    }

    static void __staticInitializer__() {
        PROT_MASK = OsConstants.PROT_READ | OsConstants.PROT_WRITE | OsConstants.PROT_EXEC | OsConstants.PROT_NONE;
        CREATOR = new Parcelable.Creator<SharedMemory>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_SharedMemory_1$__constructor__() {
            }

            private final SharedMemory $$robo$$android_os_SharedMemory_1$createFromParcel(Parcel source) {
                FileDescriptor descriptor = source.readRawFileDescriptor();
                return new SharedMemory(descriptor);
            }

            private final SharedMemory[] $$robo$$android_os_SharedMemory_1$newArray(int size) {
                return new SharedMemory[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_SharedMemory_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SharedMemory_1$__constructor__(), 0, this);
            }

            @Override
            public SharedMemory createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_SharedMemory_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public SharedMemory[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_SharedMemory_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(FileDescriptor fileDescriptor) {
        this.$$robo$$android_os_SharedMemory$__constructor__(fileDescriptor);
    }

    private SharedMemory(FileDescriptor fileDescriptor) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SharedMemory$__constructor__(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    public static SharedMemory create(String string2, int n) throws ErrnoException {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_os_SharedMemory$create(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private void checkOpen() {
        InvokeDynamicSupport.bootstrap("checkOpen", $$robo$$android_os_SharedMemory$checkOpen(), 0, this);
    }

    private static void validateProt(int n) {
        InvokeDynamicSupport.bootstrapStatic("validateProt", $$robo$$android_os_SharedMemory$validateProt(int ), 0, (int)n);
    }

    public boolean setProtect(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setProtect", $$robo$$android_os_SharedMemory$setProtect(int ), 0, this, n);
    }

    public FileDescriptor getFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getFileDescriptor", $$robo$$android_os_SharedMemory$getFileDescriptor(), 0, this);
    }

    public int getFd() {
        return (int)InvokeDynamicSupport.bootstrap("getFd", $$robo$$android_os_SharedMemory$getFd(), 0, this);
    }

    public int getSize() {
        return (int)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_os_SharedMemory$getSize(), 0, this);
    }

    public ByteBuffer mapReadWrite() throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("mapReadWrite", $$robo$$android_os_SharedMemory$mapReadWrite(), 0, this);
    }

    public ByteBuffer mapReadOnly() throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("mapReadOnly", $$robo$$android_os_SharedMemory$mapReadOnly(), 0, this);
    }

    public ByteBuffer map(int n, int n2, int n3) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("map", $$robo$$android_os_SharedMemory$map(int int int ), 0, this, n, n2, n3);
    }

    public static void unmap(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrapStatic("unmap", $$robo$$android_os_SharedMemory$unmap(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_SharedMemory$close(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_SharedMemory$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_SharedMemory$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private static final native /* synthetic */ FileDescriptor $$robo$$nCreate$nativeBinding(String var0, int var1) throws ErrnoException;

    private static FileDescriptor nCreate(String string2, int n) throws ErrnoException {
        return InvokeDynamicSupport.bootstrapStatic("nCreate", $$robo$$android_os_SharedMemory$nCreate(java.lang.String int ), 1, (String)string2, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nGetSize$nativeBinding(FileDescriptor var0);

    private static int nGetSize(FileDescriptor fileDescriptor) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetSize", $$robo$$android_os_SharedMemory$nGetSize(java.io.FileDescriptor ), 1, (FileDescriptor)fileDescriptor);
    }

    private static final native /* synthetic */ int $$robo$$nSetProt$nativeBinding(FileDescriptor var0, int var1);

    private static int nSetProt(FileDescriptor fileDescriptor, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nSetProt", $$robo$$android_os_SharedMemory$nSetProt(java.io.FileDescriptor int ), 1, (FileDescriptor)fileDescriptor, (int)n);
    }

    private /* synthetic */ void __constructor__(FileDescriptor fileDescriptor, 1 var2_2) {
        this.$$robo$$android_os_SharedMemory$__constructor__(fileDescriptor, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(SharedMemory.class);
    }

    public /* synthetic */ SharedMemory() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SharedMemory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class MemoryRegistration
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mSize;
        private int mReferenceCount;

        private void $$robo$$android_os_SharedMemory_MemoryRegistration$__constructor__(int size) {
            this.mSize = size;
            this.mReferenceCount = 1;
            VMRuntime.getRuntime().registerNativeAllocation(this.mSize);
        }

        private final synchronized MemoryRegistration $$robo$$android_os_SharedMemory_MemoryRegistration$acquire() {
            ++this.mReferenceCount;
            return this;
        }

        private final synchronized void $$robo$$android_os_SharedMemory_MemoryRegistration$release() {
            --this.mReferenceCount;
            if (this.mReferenceCount == 0) {
                VMRuntime.getRuntime().registerNativeFree(this.mSize);
            }
        }

        private /* synthetic */ void $$robo$$android_os_SharedMemory_MemoryRegistration$__constructor__(int x0, 1 x1) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_SharedMemory_MemoryRegistration$__constructor__(n);
        }

        private MemoryRegistration(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SharedMemory_MemoryRegistration$__constructor__(int ), 0, this, n);
        }

        public synchronized MemoryRegistration acquire() {
            return InvokeDynamicSupport.bootstrap("acquire", $$robo$$android_os_SharedMemory_MemoryRegistration$acquire(), 0, this);
        }

        public synchronized void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_os_SharedMemory_MemoryRegistration$release(), 0, this);
        }

        private /* synthetic */ void __constructor__(int n, 1 var2_2) {
            this.$$robo$$android_os_SharedMemory_MemoryRegistration$__constructor__(n, var2_2);
        }

        public /* synthetic */ MemoryRegistration() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryRegistration)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Unmapper
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mAddress;
        private int mSize;
        private MemoryRegistration mMemoryReference;

        private void $$robo$$android_os_SharedMemory_Unmapper$__constructor__(long address, int size, MemoryRegistration memoryReference) {
            this.mAddress = address;
            this.mSize = size;
            this.mMemoryReference = memoryReference;
        }

        private final void $$robo$$android_os_SharedMemory_Unmapper$run() {
            try {
                Os.munmap(this.mAddress, this.mSize);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.mMemoryReference.release();
            this.mMemoryReference = null;
        }

        private /* synthetic */ void $$robo$$android_os_SharedMemory_Unmapper$__constructor__(long x0, int x1, MemoryRegistration x2, 1 x3) {
        }

        private void __constructor__(long l, int n, MemoryRegistration memoryRegistration) {
            this.$$robo$$android_os_SharedMemory_Unmapper$__constructor__(l, n, memoryRegistration);
        }

        private Unmapper(long l, int n, MemoryRegistration memoryRegistration) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SharedMemory_Unmapper$__constructor__(long int android.os.SharedMemory$MemoryRegistration ), 0, this, l, n, memoryRegistration);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_SharedMemory_Unmapper$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(long l, int n, MemoryRegistration memoryRegistration, 1 var5_4) {
            this.$$robo$$android_os_SharedMemory_Unmapper$__constructor__(l, n, memoryRegistration, var5_4);
        }

        public /* synthetic */ Unmapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Unmapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Closer
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private FileDescriptor mFd;
        private MemoryRegistration mMemoryReference;

        private void $$robo$$android_os_SharedMemory_Closer$__constructor__(FileDescriptor fd, MemoryRegistration memoryReference) {
            this.mFd = fd;
            this.mMemoryReference = memoryReference;
        }

        private final void $$robo$$android_os_SharedMemory_Closer$run() {
            try {
                Os.close(this.mFd);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.mMemoryReference.release();
            this.mMemoryReference = null;
        }

        private /* synthetic */ void $$robo$$android_os_SharedMemory_Closer$__constructor__(FileDescriptor x0, MemoryRegistration x1, 1 x2) {
        }

        private void __constructor__(FileDescriptor fileDescriptor, MemoryRegistration memoryRegistration) {
            this.$$robo$$android_os_SharedMemory_Closer$__constructor__(fileDescriptor, memoryRegistration);
        }

        private Closer(FileDescriptor fileDescriptor, MemoryRegistration memoryRegistration) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SharedMemory_Closer$__constructor__(java.io.FileDescriptor android.os.SharedMemory$MemoryRegistration ), 0, this, fileDescriptor, memoryRegistration);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_SharedMemory_Closer$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(FileDescriptor fileDescriptor, MemoryRegistration memoryRegistration, 1 var3_3) {
            this.$$robo$$android_os_SharedMemory_Closer$__constructor__(fileDescriptor, memoryRegistration, var3_3);
        }

        public /* synthetic */ Closer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Closer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

