/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.accounts.AccountManager;
import android.app.ActivityManager;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.IUserManager;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.android.internal.os.RoSystemProperties;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UserManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "UserManager";
    private IUserManager mService;
    private Context mContext;
    private Boolean mIsManagedProfileCached;
    public static int RESTRICTION_NOT_SET = 0;
    public static int RESTRICTION_SOURCE_SYSTEM = 1;
    public static int RESTRICTION_SOURCE_DEVICE_OWNER = 2;
    public static int RESTRICTION_SOURCE_PROFILE_OWNER = 4;
    public static String DISALLOW_MODIFY_ACCOUNTS = "no_modify_accounts";
    public static String DISALLOW_CONFIG_WIFI = "no_config_wifi";
    public static String DISALLOW_INSTALL_APPS = "no_install_apps";
    public static String DISALLOW_UNINSTALL_APPS = "no_uninstall_apps";
    public static String DISALLOW_SHARE_LOCATION = "no_share_location";
    public static String DISALLOW_INSTALL_UNKNOWN_SOURCES = "no_install_unknown_sources";
    public static String DISALLOW_CONFIG_BLUETOOTH = "no_config_bluetooth";
    public static String DISALLOW_BLUETOOTH = "no_bluetooth";
    public static String DISALLOW_BLUETOOTH_SHARING = "no_bluetooth_sharing";
    public static String DISALLOW_USB_FILE_TRANSFER = "no_usb_file_transfer";
    public static String DISALLOW_CONFIG_CREDENTIALS = "no_config_credentials";
    public static String DISALLOW_REMOVE_USER = "no_remove_user";
    public static String DISALLOW_REMOVE_MANAGED_PROFILE = "no_remove_managed_profile";
    public static String DISALLOW_DEBUGGING_FEATURES = "no_debugging_features";
    public static String DISALLOW_CONFIG_VPN = "no_config_vpn";
    public static String DISALLOW_CONFIG_TETHERING = "no_config_tethering";
    public static String DISALLOW_NETWORK_RESET = "no_network_reset";
    public static String DISALLOW_FACTORY_RESET = "no_factory_reset";
    public static String DISALLOW_ADD_USER = "no_add_user";
    public static String DISALLOW_ADD_MANAGED_PROFILE = "no_add_managed_profile";
    public static String ENSURE_VERIFY_APPS = "ensure_verify_apps";
    public static String DISALLOW_CONFIG_CELL_BROADCASTS = "no_config_cell_broadcasts";
    public static String DISALLOW_CONFIG_MOBILE_NETWORKS = "no_config_mobile_networks";
    public static String DISALLOW_APPS_CONTROL = "no_control_apps";
    public static String DISALLOW_MOUNT_PHYSICAL_MEDIA = "no_physical_media";
    public static String DISALLOW_UNMUTE_MICROPHONE = "no_unmute_microphone";
    public static String DISALLOW_ADJUST_VOLUME = "no_adjust_volume";
    public static String DISALLOW_OUTGOING_CALLS = "no_outgoing_calls";
    public static String DISALLOW_SMS = "no_sms";
    public static String DISALLOW_FUN = "no_fun";
    public static String DISALLOW_CREATE_WINDOWS = "no_create_windows";
    public static String DISALLOW_CROSS_PROFILE_COPY_PASTE = "no_cross_profile_copy_paste";
    public static String DISALLOW_OUTGOING_BEAM = "no_outgoing_beam";
    public static String DISALLOW_WALLPAPER = "no_wallpaper";
    public static String DISALLOW_SET_WALLPAPER = "no_set_wallpaper";
    public static String DISALLOW_SAFE_BOOT = "no_safe_boot";
    public static String DISALLOW_RECORD_AUDIO = "no_record_audio";
    public static String DISALLOW_RUN_IN_BACKGROUND = "no_run_in_background";
    public static String DISALLOW_CAMERA = "no_camera";
    public static String DISALLOW_UNMUTE_DEVICE = "disallow_unmute_device";
    public static String DISALLOW_DATA_ROAMING = "no_data_roaming";
    public static String DISALLOW_SET_USER_ICON = "no_set_user_icon";
    @Deprecated
    public static String DISALLOW_OEM_UNLOCK = "no_oem_unlock";
    public static String ALLOW_PARENT_PROFILE_APP_LINKING = "allow_parent_profile_app_linking";
    public static String DISALLOW_AUTOFILL = "no_autofill";
    public static String KEY_RESTRICTIONS_PENDING = "restrictions_pending";
    private static String ACTION_CREATE_USER = "android.os.action.CREATE_USER";
    public static String EXTRA_USER_NAME = "android.os.extra.USER_NAME";
    public static String EXTRA_USER_ACCOUNT_NAME = "android.os.extra.USER_ACCOUNT_NAME";
    public static String EXTRA_USER_ACCOUNT_TYPE = "android.os.extra.USER_ACCOUNT_TYPE";
    public static String EXTRA_USER_ACCOUNT_OPTIONS = "android.os.extra.USER_ACCOUNT_OPTIONS";
    public static int PIN_VERIFICATION_FAILED_INCORRECT = -3;
    public static int PIN_VERIFICATION_FAILED_NOT_SET = -2;
    public static int PIN_VERIFICATION_SUCCESS = -1;
    public static String ACTION_USER_RESTRICTIONS_CHANGED = "android.os.action.USER_RESTRICTIONS_CHANGED";
    public static int USER_CREATION_FAILED_NOT_PERMITTED = 1;
    public static int USER_CREATION_FAILED_NO_MORE_USERS = 2;

    private static final UserManager $$robo$$android_os_UserManager$get(Context context) {
        return (UserManager)context.getSystemService("user");
    }

    private void $$robo$$android_os_UserManager$__constructor__(Context context, IUserManager service) {
        this.mService = service;
        this.mContext = context.getApplicationContext();
    }

    private static final boolean $$robo$$android_os_UserManager$supportsMultipleUsers() {
        return UserManager.getMaxSupportedUsers() > 1 && SystemProperties.getBoolean("fw.show_multiuserui", Resources.getSystem().getBoolean(17956956));
    }

    private static final boolean $$robo$$android_os_UserManager$isSplitSystemUser() {
        return RoSystemProperties.FW_SYSTEM_USER_SPLIT;
    }

    private static final boolean $$robo$$android_os_UserManager$isGuestUserEphemeral() {
        return Resources.getSystem().getBoolean(17956971);
    }

    private final boolean $$robo$$android_os_UserManager$canSwitchUsers() {
        boolean allowUserSwitchingWhenSystemUserLocked = Settings.Global.getInt(this.mContext.getContentResolver(), "allow_user_switching_when_system_user_locked", 0) != 0;
        boolean isSystemUserUnlocked = this.isUserUnlocked(UserHandle.SYSTEM);
        boolean inCall = TelephonyManager.getDefault().getCallState() != 0;
        return (allowUserSwitchingWhenSystemUserLocked || isSystemUserUnlocked) && !inCall;
    }

    private final int $$robo$$android_os_UserManager$getUserHandle() {
        return UserHandle.myUserId();
    }

    private final String $$robo$$android_os_UserManager$getUserName() {
        UserInfo user = this.getUserInfo(this.getUserHandle());
        return user == null ? "" : user.name;
    }

    private final boolean $$robo$$android_os_UserManager$isUserNameSet() {
        try {
            return this.mService.isUserNameSet(this.getUserHandle());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isUserAGoat() {
        return this.mContext.getPackageManager().isPackageAvailable("com.coffeestainstudios.goatsimulator");
    }

    private final boolean $$robo$$android_os_UserManager$isPrimaryUser() {
        UserInfo user = this.getUserInfo(UserHandle.myUserId());
        return user != null && user.isPrimary();
    }

    private final boolean $$robo$$android_os_UserManager$isSystemUser() {
        return UserHandle.myUserId() == 0;
    }

    private final boolean $$robo$$android_os_UserManager$isAdminUser() {
        return this.isUserAdmin(UserHandle.myUserId());
    }

    private final boolean $$robo$$android_os_UserManager$isUserAdmin(int userId) {
        UserInfo user = this.getUserInfo(userId);
        return user != null && user.isAdmin();
    }

    private final boolean $$robo$$android_os_UserManager$isLinkedUser() {
        try {
            return this.mService.isRestricted();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$canHaveRestrictedProfile(int userId) {
        try {
            return this.mService.canHaveRestrictedProfile(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isGuestUser(int id2) {
        UserInfo user = this.getUserInfo(id2);
        return user != null && user.isGuest();
    }

    private final boolean $$robo$$android_os_UserManager$isGuestUser() {
        UserInfo user = this.getUserInfo(UserHandle.myUserId());
        return user != null && user.isGuest();
    }

    private final boolean $$robo$$android_os_UserManager$isDemoUser() {
        try {
            return this.mService.isDemoUser(UserHandle.myUserId());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isManagedProfile() {
        if (this.mIsManagedProfileCached != null) {
            return this.mIsManagedProfileCached;
        }
        try {
            this.mIsManagedProfileCached = this.mService.isManagedProfile(UserHandle.myUserId());
            return this.mIsManagedProfileCached;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isManagedProfile(int userId) {
        if (userId == UserHandle.myUserId()) {
            return this.isManagedProfile();
        }
        try {
            return this.mService.isManagedProfile(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_os_UserManager$getManagedProfileBadge(int userId) {
        try {
            return this.mService.getManagedProfileBadge(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isEphemeralUser() {
        return this.isUserEphemeral(UserHandle.myUserId());
    }

    private final boolean $$robo$$android_os_UserManager$isUserEphemeral(int userId) {
        UserInfo user = this.getUserInfo(userId);
        return user != null && user.isEphemeral();
    }

    private final boolean $$robo$$android_os_UserManager$isUserRunning(UserHandle user) {
        return this.isUserRunning(user.getIdentifier());
    }

    private final boolean $$robo$$android_os_UserManager$isUserRunning(int userId) {
        try {
            return this.mService.isUserRunning(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isUserRunningOrStopping(UserHandle user) {
        try {
            return ActivityManager.getService().isUserRunning(user.getIdentifier(), 1);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isUserUnlocked() {
        return this.isUserUnlocked(Process.myUserHandle());
    }

    private final boolean $$robo$$android_os_UserManager$isUserUnlocked(UserHandle user) {
        return this.isUserUnlocked(user.getIdentifier());
    }

    private final boolean $$robo$$android_os_UserManager$isUserUnlocked(int userId) {
        try {
            return this.mService.isUserUnlocked(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isUserUnlockingOrUnlocked(UserHandle user) {
        return this.isUserUnlockingOrUnlocked(user.getIdentifier());
    }

    private final boolean $$robo$$android_os_UserManager$isUserUnlockingOrUnlocked(int userId) {
        try {
            return this.mService.isUserUnlockingOrUnlocked(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final UserInfo $$robo$$android_os_UserManager$getUserInfo(int userHandle) {
        try {
            return this.mService.getUserInfo(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final int $$robo$$android_os_UserManager$getUserRestrictionSource(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictionSource(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<EnforcingUser> $$robo$$android_os_UserManager$getUserRestrictionSources(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictionSources(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final Bundle $$robo$$android_os_UserManager$getUserRestrictions() {
        return this.getUserRestrictions(Process.myUserHandle());
    }

    private final Bundle $$robo$$android_os_UserManager$getUserRestrictions(UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictions(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$hasBaseUserRestriction(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.hasBaseUserRestriction(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_os_UserManager$setUserRestrictions(Bundle restrictions) {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    @Deprecated
    private final void $$robo$$android_os_UserManager$setUserRestrictions(Bundle restrictions, UserHandle userHandle) {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    @Deprecated
    private final void $$robo$$android_os_UserManager$setUserRestriction(String key, boolean value) {
        this.setUserRestriction(key, value, Process.myUserHandle());
    }

    @Deprecated
    private final void $$robo$$android_os_UserManager$setUserRestriction(String key, boolean value, UserHandle userHandle) {
        try {
            this.mService.setUserRestriction(key, value, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$hasUserRestriction(String restrictionKey) {
        return this.hasUserRestriction(restrictionKey, Process.myUserHandle());
    }

    private final boolean $$robo$$android_os_UserManager$hasUserRestriction(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.hasUserRestriction(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_os_UserManager$getSerialNumberForUser(UserHandle user) {
        return this.getUserSerialNumber(user.getIdentifier());
    }

    private final UserHandle $$robo$$android_os_UserManager$getUserForSerialNumber(long serialNumber) {
        int ident = this.getUserHandle((int)serialNumber);
        return ident >= 0 ? new UserHandle(ident) : null;
    }

    private final UserInfo $$robo$$android_os_UserManager$createUser(String name, int flags) {
        UserInfo user = null;
        try {
            user = this.mService.createUser(name, flags);
            if (user != null && !user.isAdmin() && !user.isDemo()) {
                this.mService.setUserRestriction("no_sms", true, user.id);
                this.mService.setUserRestriction("no_outgoing_calls", true, user.id);
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return user;
    }

    private final UserInfo $$robo$$android_os_UserManager$createGuest(Context context, String name) {
        UserInfo guest = null;
        try {
            guest = this.mService.createUser(name, 4);
            if (guest != null) {
                Settings.Secure.putStringForUser(context.getContentResolver(), "skip_first_use_hints", "1", guest.id);
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return guest;
    }

    private final UserInfo $$robo$$android_os_UserManager$createProfileForUser(String name, int flags, int userHandle) {
        return this.createProfileForUser(name, flags, userHandle, null);
    }

    private final UserInfo $$robo$$android_os_UserManager$createProfileForUser(String name, int flags, int userHandle, String[] disallowedPackages) {
        try {
            return this.mService.createProfileForUser(name, flags, userHandle, disallowedPackages);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final UserInfo $$robo$$android_os_UserManager$createProfileForUserEvenWhenDisallowed(String name, int flags, int userHandle, String[] disallowedPackages) {
        try {
            return this.mService.createProfileForUserEvenWhenDisallowed(name, flags, userHandle, disallowedPackages);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final UserInfo $$robo$$android_os_UserManager$createRestrictedProfile(String name) {
        try {
            UserHandle parentUserHandle = Process.myUserHandle();
            UserInfo user = this.mService.createRestrictedProfile(name, parentUserHandle.getIdentifier());
            if (user != null) {
                AccountManager.get(this.mContext).addSharedAccountsFromParentUser(parentUserHandle, UserHandle.of(user.id));
            }
            return user;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private static final Intent $$robo$$android_os_UserManager$createUserCreationIntent(String userName, String accountName, String accountType, PersistableBundle accountOptions) {
        Intent intent = new Intent("android.os.action.CREATE_USER");
        if (userName != null) {
            intent.putExtra("android.os.extra.USER_NAME", userName);
        }
        if (accountName != null && accountType == null) {
            throw new IllegalArgumentException("accountType must be specified if accountName is specified");
        }
        if (accountName != null) {
            intent.putExtra("android.os.extra.USER_ACCOUNT_NAME", accountName);
        }
        if (accountType != null) {
            intent.putExtra("android.os.extra.USER_ACCOUNT_TYPE", accountType);
        }
        if (accountOptions != null) {
            intent.putExtra("android.os.extra.USER_ACCOUNT_OPTIONS", accountOptions);
        }
        return intent;
    }

    private final String $$robo$$android_os_UserManager$getSeedAccountName() {
        try {
            return this.mService.getSeedAccountName();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_os_UserManager$getSeedAccountType() {
        try {
            return this.mService.getSeedAccountType();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final PersistableBundle $$robo$$android_os_UserManager$getSeedAccountOptions() {
        try {
            return this.mService.getSeedAccountOptions();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_UserManager$setSeedAccountData(int userId, String accountName, String accountType, PersistableBundle accountOptions) {
        try {
            this.mService.setSeedAccountData(userId, accountName, accountType, accountOptions, true);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_UserManager$clearSeedAccountData() {
        try {
            this.mService.clearSeedAccountData();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$markGuestForDeletion(int userHandle) {
        try {
            return this.mService.markGuestForDeletion(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_UserManager$setUserEnabled(int userHandle) {
        try {
            this.mService.setUserEnabled(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_UserManager$evictCredentialEncryptionKey(int userHandle) {
        try {
            this.mService.evictCredentialEncryptionKey(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_os_UserManager$getUserCount() {
        List<UserInfo> users = this.getUsers();
        return users != null ? users.size() : 1;
    }

    private final List<UserInfo> $$robo$$android_os_UserManager$getUsers() {
        try {
            return this.mService.getUsers(false);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final long[] $$robo$$android_os_UserManager$getSerialNumbersOfUsers(boolean excludeDying) {
        try {
            List<UserInfo> users = this.mService.getUsers(excludeDying);
            long[] result = new long[users.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = users.get((int)i).serialNumber;
            }
            return result;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_os_UserManager$getUserAccount(int userHandle) {
        try {
            return this.mService.getUserAccount(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_UserManager$setUserAccount(int userHandle, String accountName) {
        try {
            this.mService.setUserAccount(userHandle, accountName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final UserInfo $$robo$$android_os_UserManager$getPrimaryUser() {
        try {
            return this.mService.getPrimaryUser();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$canAddMoreUsers() {
        List<UserInfo> users = this.getUsers(true);
        int totalUserCount = users.size();
        int aliveUserCount = 0;
        for (int i = 0; i < totalUserCount; ++i) {
            UserInfo user = users.get(i);
            if (user.isGuest()) continue;
            ++aliveUserCount;
        }
        return aliveUserCount < UserManager.getMaxSupportedUsers();
    }

    private final boolean $$robo$$android_os_UserManager$canAddMoreManagedProfiles(int userId, boolean allowedToRemoveOne) {
        try {
            return this.mService.canAddMoreManagedProfiles(userId, allowedToRemoveOne);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<UserInfo> $$robo$$android_os_UserManager$getProfiles(int userHandle) {
        try {
            return this.mService.getProfiles(userHandle, false);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isSameProfileGroup(int userId, int otherUserId) {
        try {
            return this.mService.isSameProfileGroup(userId, otherUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<UserInfo> $$robo$$android_os_UserManager$getEnabledProfiles(int userHandle) {
        try {
            return this.mService.getProfiles(userHandle, true);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<UserHandle> $$robo$$android_os_UserManager$getUserProfiles() {
        int[] userIds = this.getProfileIds(UserHandle.myUserId(), true);
        ArrayList<UserHandle> result = new ArrayList<UserHandle>(userIds.length);
        for (int userId : userIds) {
            result.add(UserHandle.of(userId));
        }
        return result;
    }

    private final int[] $$robo$$android_os_UserManager$getProfileIds(int userId, boolean enabledOnly) {
        try {
            return this.mService.getProfileIds(userId, enabledOnly);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int[] $$robo$$android_os_UserManager$getProfileIdsWithDisabled(int userId) {
        return this.getProfileIds(userId, false);
    }

    private final int[] $$robo$$android_os_UserManager$getEnabledProfileIds(int userId) {
        return this.getProfileIds(userId, true);
    }

    private final int $$robo$$android_os_UserManager$getCredentialOwnerProfile(int userHandle) {
        try {
            return this.mService.getCredentialOwnerProfile(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final UserInfo $$robo$$android_os_UserManager$getProfileParent(int userHandle) {
        try {
            return this.mService.getProfileParent(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_UserManager$setQuietModeEnabled(int userHandle, boolean enableQuietMode) {
        try {
            this.mService.setQuietModeEnabled(userHandle, enableQuietMode);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$isQuietModeEnabled(UserHandle userHandle) {
        try {
            return this.mService.isQuietModeEnabled(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$trySetQuietModeDisabled(int userHandle, IntentSender target) {
        try {
            return this.mService.trySetQuietModeDisabled(userHandle, target);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final Drawable $$robo$$android_os_UserManager$getBadgedIconForUser(Drawable icon, UserHandle user) {
        return this.mContext.getPackageManager().getUserBadgedIcon(icon, user);
    }

    private final Drawable $$robo$$android_os_UserManager$getBadgedDrawableForUser(Drawable badgedDrawable, UserHandle user, Rect badgeLocation, int badgeDensity) {
        return this.mContext.getPackageManager().getUserBadgedDrawableForDensity(badgedDrawable, user, badgeLocation, badgeDensity);
    }

    private final CharSequence $$robo$$android_os_UserManager$getBadgedLabelForUser(CharSequence label, UserHandle user) {
        return this.mContext.getPackageManager().getUserBadgedLabel(label, user);
    }

    private final List<UserInfo> $$robo$$android_os_UserManager$getUsers(boolean excludeDying) {
        try {
            return this.mService.getUsers(excludeDying);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$removeUser(int userHandle) {
        try {
            return this.mService.removeUser(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$removeUserEvenWhenDisallowed(int userHandle) {
        try {
            return this.mService.removeUserEvenWhenDisallowed(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_UserManager$setUserName(int userHandle, String name) {
        try {
            this.mService.setUserName(userHandle, name);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_UserManager$setUserIcon(int userHandle, Bitmap icon) {
        try {
            this.mService.setUserIcon(userHandle, icon);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap $$robo$$android_os_UserManager$getUserIcon(int userHandle) {
        block9: {
            Bitmap bitmap;
            ParcelFileDescriptor fd = this.mService.getUserIcon(userHandle);
            if (fd == null) break block9;
            try {
                bitmap = BitmapFactory.decodeFileDescriptor(fd.getFileDescriptor());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fd.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (RemoteException re) {
                    throw re.rethrowFromSystemServer();
                }
            }
            try {
                fd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bitmap;
        }
        return null;
    }

    private static final int $$robo$$android_os_UserManager$getMaxSupportedUsers() {
        if (Build.ID.startsWith("JVP")) {
            return 1;
        }
        if (ActivityManager.isLowRamDeviceStatic()) {
            return 1;
        }
        return SystemProperties.getInt("fw.max_users", Resources.getSystem().getInteger(17694812));
    }

    private final boolean $$robo$$android_os_UserManager$isUserSwitcherEnabled() {
        if (!UserManager.supportsMultipleUsers()) {
            return false;
        }
        if (UserManager.isDeviceInDemoMode(this.mContext)) {
            return false;
        }
        List<UserInfo> users = this.getUsers(true);
        if (users == null) {
            return false;
        }
        int switchableUserCount = 0;
        for (UserInfo user : users) {
            if (!user.supportsSwitchToByUser()) continue;
            ++switchableUserCount;
        }
        boolean guestEnabled = !this.mContext.getSystemService(DevicePolicyManager.class).getGuestUserDisabled(null);
        return switchableUserCount > 1 || guestEnabled;
    }

    private static final boolean $$robo$$android_os_UserManager$isDeviceInDemoMode(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "device_demo_mode", 0) > 0;
    }

    private final int $$robo$$android_os_UserManager$getUserSerialNumber(int userHandle) {
        try {
            return this.mService.getUserSerialNumber(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_os_UserManager$getUserHandle(int userSerialNumber) {
        try {
            return this.mService.getUserHandle(userSerialNumber);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final Bundle $$robo$$android_os_UserManager$getApplicationRestrictions(String packageName) {
        try {
            return this.mService.getApplicationRestrictions(packageName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final Bundle $$robo$$android_os_UserManager$getApplicationRestrictions(String packageName, UserHandle user) {
        try {
            return this.mService.getApplicationRestrictionsForUser(packageName, user.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_UserManager$setApplicationRestrictions(String packageName, Bundle restrictions, UserHandle user) {
        try {
            this.mService.setApplicationRestrictions(packageName, restrictions, user.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_os_UserManager$setRestrictionsChallenge(String newPin) {
        return false;
    }

    private final void $$robo$$android_os_UserManager$setDefaultGuestRestrictions(Bundle restrictions) {
        try {
            this.mService.setDefaultGuestRestrictions(restrictions);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final Bundle $$robo$$android_os_UserManager$getDefaultGuestRestrictions() {
        try {
            return this.mService.getDefaultGuestRestrictions();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_os_UserManager$getUserCreationTime(UserHandle userHandle) {
        try {
            return this.mService.getUserCreationTime(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_UserManager$someUserHasSeedAccount(String accountName, String accountType) {
        try {
            return this.mService.someUserHasSeedAccount(accountName, accountType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public static UserManager get(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_os_UserManager$get(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context, IUserManager iUserManager) {
        this.$$robo$$android_os_UserManager$__constructor__(context, iUserManager);
    }

    public UserManager(Context context, IUserManager iUserManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_UserManager$__constructor__(android.content.Context android.os.IUserManager ), 0, this, context, iUserManager);
    }

    public static boolean supportsMultipleUsers() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("supportsMultipleUsers", $$robo$$android_os_UserManager$supportsMultipleUsers(), 0);
    }

    public static boolean isSplitSystemUser() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSplitSystemUser", $$robo$$android_os_UserManager$isSplitSystemUser(), 0);
    }

    public static boolean isGuestUserEphemeral() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGuestUserEphemeral", $$robo$$android_os_UserManager$isGuestUserEphemeral(), 0);
    }

    public boolean canSwitchUsers() {
        return (boolean)InvokeDynamicSupport.bootstrap("canSwitchUsers", $$robo$$android_os_UserManager$canSwitchUsers(), 0, this);
    }

    public int getUserHandle() {
        return (int)InvokeDynamicSupport.bootstrap("getUserHandle", $$robo$$android_os_UserManager$getUserHandle(), 0, this);
    }

    public String getUserName() {
        return InvokeDynamicSupport.bootstrap("getUserName", $$robo$$android_os_UserManager$getUserName(), 0, this);
    }

    public boolean isUserNameSet() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserNameSet", $$robo$$android_os_UserManager$isUserNameSet(), 0, this);
    }

    public boolean isUserAGoat() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAGoat", $$robo$$android_os_UserManager$isUserAGoat(), 0, this);
    }

    public boolean isPrimaryUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrimaryUser", $$robo$$android_os_UserManager$isPrimaryUser(), 0, this);
    }

    public boolean isSystemUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSystemUser", $$robo$$android_os_UserManager$isSystemUser(), 0, this);
    }

    public boolean isAdminUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAdminUser", $$robo$$android_os_UserManager$isAdminUser(), 0, this);
    }

    public boolean isUserAdmin(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAdmin", $$robo$$android_os_UserManager$isUserAdmin(int ), 0, this, n);
    }

    public boolean isLinkedUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLinkedUser", $$robo$$android_os_UserManager$isLinkedUser(), 0, this);
    }

    public boolean canHaveRestrictedProfile(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("canHaveRestrictedProfile", $$robo$$android_os_UserManager$canHaveRestrictedProfile(int ), 0, this, n);
    }

    public boolean isGuestUser(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGuestUser", $$robo$$android_os_UserManager$isGuestUser(int ), 0, this, n);
    }

    public boolean isGuestUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGuestUser", $$robo$$android_os_UserManager$isGuestUser(), 0, this);
    }

    public boolean isDemoUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDemoUser", $$robo$$android_os_UserManager$isDemoUser(), 0, this);
    }

    public boolean isManagedProfile() {
        return (boolean)InvokeDynamicSupport.bootstrap("isManagedProfile", $$robo$$android_os_UserManager$isManagedProfile(), 0, this);
    }

    public boolean isManagedProfile(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isManagedProfile", $$robo$$android_os_UserManager$isManagedProfile(int ), 0, this, n);
    }

    public int getManagedProfileBadge(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getManagedProfileBadge", $$robo$$android_os_UserManager$getManagedProfileBadge(int ), 0, this, n);
    }

    public boolean isEphemeralUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEphemeralUser", $$robo$$android_os_UserManager$isEphemeralUser(), 0, this);
    }

    public boolean isUserEphemeral(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserEphemeral", $$robo$$android_os_UserManager$isUserEphemeral(int ), 0, this, n);
    }

    public boolean isUserRunning(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserRunning", $$robo$$android_os_UserManager$isUserRunning(android.os.UserHandle ), 0, this, userHandle);
    }

    public boolean isUserRunning(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserRunning", $$robo$$android_os_UserManager$isUserRunning(int ), 0, this, n);
    }

    public boolean isUserRunningOrStopping(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserRunningOrStopping", $$robo$$android_os_UserManager$isUserRunningOrStopping(android.os.UserHandle ), 0, this, userHandle);
    }

    public boolean isUserUnlocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserUnlocked", $$robo$$android_os_UserManager$isUserUnlocked(), 0, this);
    }

    public boolean isUserUnlocked(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserUnlocked", $$robo$$android_os_UserManager$isUserUnlocked(android.os.UserHandle ), 0, this, userHandle);
    }

    public boolean isUserUnlocked(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserUnlocked", $$robo$$android_os_UserManager$isUserUnlocked(int ), 0, this, n);
    }

    public boolean isUserUnlockingOrUnlocked(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserUnlockingOrUnlocked", $$robo$$android_os_UserManager$isUserUnlockingOrUnlocked(android.os.UserHandle ), 0, this, userHandle);
    }

    public boolean isUserUnlockingOrUnlocked(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserUnlockingOrUnlocked", $$robo$$android_os_UserManager$isUserUnlockingOrUnlocked(int ), 0, this, n);
    }

    public UserInfo getUserInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getUserInfo", $$robo$$android_os_UserManager$getUserInfo(int ), 0, this, n);
    }

    @Deprecated
    public int getUserRestrictionSource(String string2, UserHandle userHandle) {
        return (int)InvokeDynamicSupport.bootstrap("getUserRestrictionSource", $$robo$$android_os_UserManager$getUserRestrictionSource(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public List<EnforcingUser> getUserRestrictionSources(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getUserRestrictionSources", $$robo$$android_os_UserManager$getUserRestrictionSources(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public Bundle getUserRestrictions() {
        return InvokeDynamicSupport.bootstrap("getUserRestrictions", $$robo$$android_os_UserManager$getUserRestrictions(), 0, this);
    }

    public Bundle getUserRestrictions(UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getUserRestrictions", $$robo$$android_os_UserManager$getUserRestrictions(android.os.UserHandle ), 0, this, userHandle);
    }

    public boolean hasBaseUserRestriction(String string2, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBaseUserRestriction", $$robo$$android_os_UserManager$hasBaseUserRestriction(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    @Deprecated
    public void setUserRestrictions(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setUserRestrictions", $$robo$$android_os_UserManager$setUserRestrictions(android.os.Bundle ), 0, this, bundle);
    }

    @Deprecated
    public void setUserRestrictions(Bundle bundle, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("setUserRestrictions", $$robo$$android_os_UserManager$setUserRestrictions(android.os.Bundle android.os.UserHandle ), 0, this, bundle, userHandle);
    }

    @Deprecated
    public void setUserRestriction(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setUserRestriction", $$robo$$android_os_UserManager$setUserRestriction(java.lang.String boolean ), 0, this, string2, bl);
    }

    @Deprecated
    public void setUserRestriction(String string2, boolean bl, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("setUserRestriction", $$robo$$android_os_UserManager$setUserRestriction(java.lang.String boolean android.os.UserHandle ), 0, this, string2, bl, userHandle);
    }

    public boolean hasUserRestriction(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUserRestriction", $$robo$$android_os_UserManager$hasUserRestriction(java.lang.String ), 0, this, string2);
    }

    public boolean hasUserRestriction(String string2, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUserRestriction", $$robo$$android_os_UserManager$hasUserRestriction(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public long getSerialNumberForUser(UserHandle userHandle) {
        return (long)InvokeDynamicSupport.bootstrap("getSerialNumberForUser", $$robo$$android_os_UserManager$getSerialNumberForUser(android.os.UserHandle ), 0, this, userHandle);
    }

    public UserHandle getUserForSerialNumber(long l) {
        return InvokeDynamicSupport.bootstrap("getUserForSerialNumber", $$robo$$android_os_UserManager$getUserForSerialNumber(long ), 0, this, l);
    }

    public UserInfo createUser(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("createUser", $$robo$$android_os_UserManager$createUser(java.lang.String int ), 0, this, string2, n);
    }

    public UserInfo createGuest(Context context, String string2) {
        return InvokeDynamicSupport.bootstrap("createGuest", $$robo$$android_os_UserManager$createGuest(android.content.Context java.lang.String ), 0, this, context, string2);
    }

    public UserInfo createProfileForUser(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createProfileForUser", $$robo$$android_os_UserManager$createProfileForUser(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public UserInfo createProfileForUser(String string2, int n, int n2, String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("createProfileForUser", $$robo$$android_os_UserManager$createProfileForUser(java.lang.String int int java.lang.String[] ), 0, this, string2, n, n2, stringArray);
    }

    public UserInfo createProfileForUserEvenWhenDisallowed(String string2, int n, int n2, String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("createProfileForUserEvenWhenDisallowed", $$robo$$android_os_UserManager$createProfileForUserEvenWhenDisallowed(java.lang.String int int java.lang.String[] ), 0, this, string2, n, n2, stringArray);
    }

    public UserInfo createRestrictedProfile(String string2) {
        return InvokeDynamicSupport.bootstrap("createRestrictedProfile", $$robo$$android_os_UserManager$createRestrictedProfile(java.lang.String ), 0, this, string2);
    }

    public static Intent createUserCreationIntent(String string2, String string3, String string4, PersistableBundle persistableBundle) {
        return InvokeDynamicSupport.bootstrapStatic("createUserCreationIntent", $$robo$$android_os_UserManager$createUserCreationIntent(java.lang.String java.lang.String java.lang.String android.os.PersistableBundle ), 0, (String)string2, (String)string3, (String)string4, (PersistableBundle)persistableBundle);
    }

    public String getSeedAccountName() {
        return InvokeDynamicSupport.bootstrap("getSeedAccountName", $$robo$$android_os_UserManager$getSeedAccountName(), 0, this);
    }

    public String getSeedAccountType() {
        return InvokeDynamicSupport.bootstrap("getSeedAccountType", $$robo$$android_os_UserManager$getSeedAccountType(), 0, this);
    }

    public PersistableBundle getSeedAccountOptions() {
        return InvokeDynamicSupport.bootstrap("getSeedAccountOptions", $$robo$$android_os_UserManager$getSeedAccountOptions(), 0, this);
    }

    public void setSeedAccountData(int n, String string2, String string3, PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("setSeedAccountData", $$robo$$android_os_UserManager$setSeedAccountData(int java.lang.String java.lang.String android.os.PersistableBundle ), 0, this, n, string2, string3, persistableBundle);
    }

    public void clearSeedAccountData() {
        InvokeDynamicSupport.bootstrap("clearSeedAccountData", $$robo$$android_os_UserManager$clearSeedAccountData(), 0, this);
    }

    public boolean markGuestForDeletion(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("markGuestForDeletion", $$robo$$android_os_UserManager$markGuestForDeletion(int ), 0, this, n);
    }

    public void setUserEnabled(int n) {
        InvokeDynamicSupport.bootstrap("setUserEnabled", $$robo$$android_os_UserManager$setUserEnabled(int ), 0, this, n);
    }

    public void evictCredentialEncryptionKey(int n) {
        InvokeDynamicSupport.bootstrap("evictCredentialEncryptionKey", $$robo$$android_os_UserManager$evictCredentialEncryptionKey(int ), 0, this, n);
    }

    public int getUserCount() {
        return (int)InvokeDynamicSupport.bootstrap("getUserCount", $$robo$$android_os_UserManager$getUserCount(), 0, this);
    }

    public List<UserInfo> getUsers() {
        return InvokeDynamicSupport.bootstrap("getUsers", $$robo$$android_os_UserManager$getUsers(), 0, this);
    }

    public long[] getSerialNumbersOfUsers(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getSerialNumbersOfUsers", $$robo$$android_os_UserManager$getSerialNumbersOfUsers(boolean ), 0, this, bl);
    }

    public String getUserAccount(int n) {
        return InvokeDynamicSupport.bootstrap("getUserAccount", $$robo$$android_os_UserManager$getUserAccount(int ), 0, this, n);
    }

    public void setUserAccount(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setUserAccount", $$robo$$android_os_UserManager$setUserAccount(int java.lang.String ), 0, this, n, string2);
    }

    public UserInfo getPrimaryUser() {
        return InvokeDynamicSupport.bootstrap("getPrimaryUser", $$robo$$android_os_UserManager$getPrimaryUser(), 0, this);
    }

    public boolean canAddMoreUsers() {
        return (boolean)InvokeDynamicSupport.bootstrap("canAddMoreUsers", $$robo$$android_os_UserManager$canAddMoreUsers(), 0, this);
    }

    public boolean canAddMoreManagedProfiles(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("canAddMoreManagedProfiles", $$robo$$android_os_UserManager$canAddMoreManagedProfiles(int boolean ), 0, this, n, bl);
    }

    public List<UserInfo> getProfiles(int n) {
        return InvokeDynamicSupport.bootstrap("getProfiles", $$robo$$android_os_UserManager$getProfiles(int ), 0, this, n);
    }

    public boolean isSameProfileGroup(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSameProfileGroup", $$robo$$android_os_UserManager$isSameProfileGroup(int int ), 0, this, n, n2);
    }

    public List<UserInfo> getEnabledProfiles(int n) {
        return InvokeDynamicSupport.bootstrap("getEnabledProfiles", $$robo$$android_os_UserManager$getEnabledProfiles(int ), 0, this, n);
    }

    public List<UserHandle> getUserProfiles() {
        return InvokeDynamicSupport.bootstrap("getUserProfiles", $$robo$$android_os_UserManager$getUserProfiles(), 0, this);
    }

    public int[] getProfileIds(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getProfileIds", $$robo$$android_os_UserManager$getProfileIds(int boolean ), 0, this, n, bl);
    }

    public int[] getProfileIdsWithDisabled(int n) {
        return InvokeDynamicSupport.bootstrap("getProfileIdsWithDisabled", $$robo$$android_os_UserManager$getProfileIdsWithDisabled(int ), 0, this, n);
    }

    public int[] getEnabledProfileIds(int n) {
        return InvokeDynamicSupport.bootstrap("getEnabledProfileIds", $$robo$$android_os_UserManager$getEnabledProfileIds(int ), 0, this, n);
    }

    public int getCredentialOwnerProfile(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCredentialOwnerProfile", $$robo$$android_os_UserManager$getCredentialOwnerProfile(int ), 0, this, n);
    }

    public UserInfo getProfileParent(int n) {
        return InvokeDynamicSupport.bootstrap("getProfileParent", $$robo$$android_os_UserManager$getProfileParent(int ), 0, this, n);
    }

    public void setQuietModeEnabled(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setQuietModeEnabled", $$robo$$android_os_UserManager$setQuietModeEnabled(int boolean ), 0, this, n, bl);
    }

    public boolean isQuietModeEnabled(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isQuietModeEnabled", $$robo$$android_os_UserManager$isQuietModeEnabled(android.os.UserHandle ), 0, this, userHandle);
    }

    public boolean trySetQuietModeDisabled(int n, IntentSender intentSender) {
        return (boolean)InvokeDynamicSupport.bootstrap("trySetQuietModeDisabled", $$robo$$android_os_UserManager$trySetQuietModeDisabled(int android.content.IntentSender ), 0, this, n, intentSender);
    }

    public Drawable getBadgedIconForUser(Drawable drawable2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getBadgedIconForUser", $$robo$$android_os_UserManager$getBadgedIconForUser(android.graphics.drawable.Drawable android.os.UserHandle ), 0, this, drawable2, userHandle);
    }

    public Drawable getBadgedDrawableForUser(Drawable drawable2, UserHandle userHandle, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("getBadgedDrawableForUser", $$robo$$android_os_UserManager$getBadgedDrawableForUser(android.graphics.drawable.Drawable android.os.UserHandle android.graphics.Rect int ), 0, this, drawable2, userHandle, rect, n);
    }

    public CharSequence getBadgedLabelForUser(CharSequence charSequence, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getBadgedLabelForUser", $$robo$$android_os_UserManager$getBadgedLabelForUser(java.lang.CharSequence android.os.UserHandle ), 0, this, charSequence, userHandle);
    }

    public List<UserInfo> getUsers(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getUsers", $$robo$$android_os_UserManager$getUsers(boolean ), 0, this, bl);
    }

    public boolean removeUser(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeUser", $$robo$$android_os_UserManager$removeUser(int ), 0, this, n);
    }

    public boolean removeUserEvenWhenDisallowed(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeUserEvenWhenDisallowed", $$robo$$android_os_UserManager$removeUserEvenWhenDisallowed(int ), 0, this, n);
    }

    public void setUserName(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setUserName", $$robo$$android_os_UserManager$setUserName(int java.lang.String ), 0, this, n, string2);
    }

    public void setUserIcon(int n, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setUserIcon", $$robo$$android_os_UserManager$setUserIcon(int android.graphics.Bitmap ), 0, this, n, bitmap);
    }

    public Bitmap getUserIcon(int n) {
        return InvokeDynamicSupport.bootstrap("getUserIcon", $$robo$$android_os_UserManager$getUserIcon(int ), 0, this, n);
    }

    public static int getMaxSupportedUsers() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxSupportedUsers", $$robo$$android_os_UserManager$getMaxSupportedUsers(), 0);
    }

    public boolean isUserSwitcherEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserSwitcherEnabled", $$robo$$android_os_UserManager$isUserSwitcherEnabled(), 0, this);
    }

    public static boolean isDeviceInDemoMode(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDeviceInDemoMode", $$robo$$android_os_UserManager$isDeviceInDemoMode(android.content.Context ), 0, (Context)context);
    }

    public int getUserSerialNumber(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getUserSerialNumber", $$robo$$android_os_UserManager$getUserSerialNumber(int ), 0, this, n);
    }

    public int getUserHandle(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getUserHandle", $$robo$$android_os_UserManager$getUserHandle(int ), 0, this, n);
    }

    public Bundle getApplicationRestrictions(String string2) {
        return InvokeDynamicSupport.bootstrap("getApplicationRestrictions", $$robo$$android_os_UserManager$getApplicationRestrictions(java.lang.String ), 0, this, string2);
    }

    public Bundle getApplicationRestrictions(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getApplicationRestrictions", $$robo$$android_os_UserManager$getApplicationRestrictions(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public void setApplicationRestrictions(String string2, Bundle bundle, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("setApplicationRestrictions", $$robo$$android_os_UserManager$setApplicationRestrictions(java.lang.String android.os.Bundle android.os.UserHandle ), 0, this, string2, bundle, userHandle);
    }

    @Deprecated
    public boolean setRestrictionsChallenge(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRestrictionsChallenge", $$robo$$android_os_UserManager$setRestrictionsChallenge(java.lang.String ), 0, this, string2);
    }

    public void setDefaultGuestRestrictions(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setDefaultGuestRestrictions", $$robo$$android_os_UserManager$setDefaultGuestRestrictions(android.os.Bundle ), 0, this, bundle);
    }

    public Bundle getDefaultGuestRestrictions() {
        return InvokeDynamicSupport.bootstrap("getDefaultGuestRestrictions", $$robo$$android_os_UserManager$getDefaultGuestRestrictions(), 0, this);
    }

    public long getUserCreationTime(UserHandle userHandle) {
        return (long)InvokeDynamicSupport.bootstrap("getUserCreationTime", $$robo$$android_os_UserManager$getUserCreationTime(android.os.UserHandle ), 0, this, userHandle);
    }

    public boolean someUserHasSeedAccount(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("someUserHasSeedAccount", $$robo$$android_os_UserManager$someUserHasSeedAccount(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public /* synthetic */ UserManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class EnforcingUser
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int userId;
        private int userRestrictionSource;
        public static Parcelable.Creator<EnforcingUser> CREATOR;

        private void $$robo$$android_os_UserManager_EnforcingUser$__constructor__(int userId, int userRestrictionSource) {
            this.userId = userId;
            this.userRestrictionSource = userRestrictionSource;
        }

        private void $$robo$$android_os_UserManager_EnforcingUser$__constructor__(Parcel in) {
            this.userId = in.readInt();
            this.userRestrictionSource = in.readInt();
        }

        private final int $$robo$$android_os_UserManager_EnforcingUser$describeContents() {
            return 0;
        }

        private final void $$robo$$android_os_UserManager_EnforcingUser$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.userId);
            dest.writeInt(this.userRestrictionSource);
        }

        private final UserHandle $$robo$$android_os_UserManager_EnforcingUser$getUserHandle() {
            return UserHandle.of(this.userId);
        }

        private final int $$robo$$android_os_UserManager_EnforcingUser$getUserRestrictionSource() {
            return this.userRestrictionSource;
        }

        private /* synthetic */ void $$robo$$android_os_UserManager_EnforcingUser$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<EnforcingUser>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_UserManager_EnforcingUser_1$__constructor__() {
                }

                private final EnforcingUser $$robo$$android_os_UserManager_EnforcingUser_1$createFromParcel(Parcel in) {
                    return new EnforcingUser(in);
                }

                private final EnforcingUser[] $$robo$$android_os_UserManager_EnforcingUser_1$newArray(int size) {
                    return new EnforcingUser[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_os_UserManager_EnforcingUser_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_UserManager_EnforcingUser_1$__constructor__(), 0, this);
                }

                @Override
                public EnforcingUser createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_UserManager_EnforcingUser_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public EnforcingUser[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_UserManager_EnforcingUser_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_os_UserManager_EnforcingUser$__constructor__(n, n2);
        }

        public EnforcingUser(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_UserManager_EnforcingUser$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_os_UserManager_EnforcingUser$__constructor__(parcel);
        }

        private EnforcingUser(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_UserManager_EnforcingUser$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_UserManager_EnforcingUser$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_UserManager_EnforcingUser$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public UserHandle getUserHandle() {
            return InvokeDynamicSupport.bootstrap("getUserHandle", $$robo$$android_os_UserManager_EnforcingUser$getUserHandle(), 0, this);
        }

        public int getUserRestrictionSource() {
            return (int)InvokeDynamicSupport.bootstrap("getUserRestrictionSource", $$robo$$android_os_UserManager_EnforcingUser$getUserRestrictionSource(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_os_UserManager_EnforcingUser$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(EnforcingUser.class);
        }

        public /* synthetic */ EnforcingUser() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EnforcingUser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserRestrictionSource {
    }
}

