/*
 * Decompiled with CFR 0.152.
 */
package android.os.health;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.health.HealthKeys;
import android.os.health.TimerStat;
import android.util.ArrayMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HealthStatsWriter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HealthKeys.Constants mConstants;
    private boolean[] mTimerFields;
    private int[] mTimerCounts;
    private long[] mTimerTimes;
    private boolean[] mMeasurementFields;
    private long[] mMeasurementValues;
    private ArrayMap<String, HealthStatsWriter>[] mStatsValues;
    private ArrayMap<String, TimerStat>[] mTimersValues;
    private ArrayMap<String, Long>[] mMeasurementsValues;

    private void $$robo$$android_os_health_HealthStatsWriter$__constructor__(HealthKeys.Constants constants) {
        this.mConstants = constants;
        int timerCount = constants.getSize(0);
        this.mTimerFields = new boolean[timerCount];
        this.mTimerCounts = new int[timerCount];
        this.mTimerTimes = new long[timerCount];
        int measurementCount = constants.getSize(1);
        this.mMeasurementFields = new boolean[measurementCount];
        this.mMeasurementValues = new long[measurementCount];
        int statsCount = constants.getSize(2);
        this.mStatsValues = new ArrayMap[statsCount];
        int timersCount = constants.getSize(3);
        this.mTimersValues = new ArrayMap[timersCount];
        int measurementsCount = constants.getSize(4);
        this.mMeasurementsValues = new ArrayMap[measurementsCount];
    }

    private final void $$robo$$android_os_health_HealthStatsWriter$addTimer(int timerId, int count, long time) {
        int index = this.mConstants.getIndex(0, timerId);
        this.mTimerFields[index] = true;
        this.mTimerCounts[index] = count;
        this.mTimerTimes[index] = time;
    }

    private final void $$robo$$android_os_health_HealthStatsWriter$addMeasurement(int measurementId, long value) {
        int index = this.mConstants.getIndex(1, measurementId);
        this.mMeasurementFields[index] = true;
        this.mMeasurementValues[index] = value;
    }

    private final void $$robo$$android_os_health_HealthStatsWriter$addStats(int key, String name, HealthStatsWriter value) {
        int index = this.mConstants.getIndex(2, key);
        ArrayMap<String, HealthStatsWriter> map = this.mStatsValues[index];
        if (map == null) {
            map = this.mStatsValues[index] = new ArrayMap(1);
        }
        map.put(name, value);
    }

    private final void $$robo$$android_os_health_HealthStatsWriter$addTimers(int key, String name, TimerStat value) {
        int index = this.mConstants.getIndex(3, key);
        ArrayMap<String, TimerStat> map = this.mTimersValues[index];
        if (map == null) {
            map = this.mTimersValues[index] = new ArrayMap(1);
        }
        map.put(name, value);
    }

    private final void $$robo$$android_os_health_HealthStatsWriter$addMeasurements(int key, String name, long value) {
        int index = this.mConstants.getIndex(4, key);
        ArrayMap<String, Long> map = this.mMeasurementsValues[index];
        if (map == null) {
            map = this.mMeasurementsValues[index] = new ArrayMap(1);
        }
        map.put(name, value);
    }

    private final void $$robo$$android_os_health_HealthStatsWriter$flattenToParcel(Parcel out) {
        int i;
        out.writeString(this.mConstants.getDataType());
        out.writeInt(HealthStatsWriter.countBooleanArray(this.mTimerFields));
        int[] keys = this.mConstants.getKeys(0);
        for (i = 0; i < keys.length; ++i) {
            if (!this.mTimerFields[i]) continue;
            out.writeInt(keys[i]);
            out.writeInt(this.mTimerCounts[i]);
            out.writeLong(this.mTimerTimes[i]);
        }
        out.writeInt(HealthStatsWriter.countBooleanArray(this.mMeasurementFields));
        keys = this.mConstants.getKeys(1);
        for (i = 0; i < keys.length; ++i) {
            if (!this.mMeasurementFields[i]) continue;
            out.writeInt(keys[i]);
            out.writeLong(this.mMeasurementValues[i]);
        }
        out.writeInt(HealthStatsWriter.countObjectArray(this.mStatsValues));
        keys = this.mConstants.getKeys(2);
        for (i = 0; i < keys.length; ++i) {
            if (this.mStatsValues[i] == null) continue;
            out.writeInt(keys[i]);
            HealthStatsWriter.writeHealthStatsWriterMap(out, this.mStatsValues[i]);
        }
        out.writeInt(HealthStatsWriter.countObjectArray(this.mTimersValues));
        keys = this.mConstants.getKeys(3);
        for (i = 0; i < keys.length; ++i) {
            if (this.mTimersValues[i] == null) continue;
            out.writeInt(keys[i]);
            HealthStatsWriter.writeParcelableMap(out, this.mTimersValues[i]);
        }
        out.writeInt(HealthStatsWriter.countObjectArray(this.mMeasurementsValues));
        keys = this.mConstants.getKeys(4);
        for (i = 0; i < keys.length; ++i) {
            if (this.mMeasurementsValues[i] == null) continue;
            out.writeInt(keys[i]);
            HealthStatsWriter.writeLongsMap(out, this.mMeasurementsValues[i]);
        }
    }

    private static final int $$robo$$android_os_health_HealthStatsWriter$countBooleanArray(boolean[] fields) {
        int count = 0;
        int N = fields.length;
        for (int i = 0; i < N; ++i) {
            if (!fields[i]) continue;
            ++count;
        }
        return count;
    }

    private static final <T> int $$robo$$android_os_health_HealthStatsWriter$countObjectArray(T[] fields) {
        int count = 0;
        int N = fields.length;
        for (int i = 0; i < N; ++i) {
            if (fields[i] == null) continue;
            ++count;
        }
        return count;
    }

    private static final void $$robo$$android_os_health_HealthStatsWriter$writeHealthStatsWriterMap(Parcel out, ArrayMap<String, HealthStatsWriter> map) {
        int N = map.size();
        out.writeInt(N);
        for (int i = 0; i < N; ++i) {
            out.writeString(map.keyAt(i));
            map.valueAt(i).flattenToParcel(out);
        }
    }

    private static final <T extends Parcelable> void $$robo$$android_os_health_HealthStatsWriter$writeParcelableMap(Parcel out, ArrayMap<String, T> map) {
        int N = map.size();
        out.writeInt(N);
        for (int i = 0; i < N; ++i) {
            out.writeString(map.keyAt(i));
            ((Parcelable)map.valueAt(i)).writeToParcel(out, 0);
        }
    }

    private static final void $$robo$$android_os_health_HealthStatsWriter$writeLongsMap(Parcel out, ArrayMap<String, Long> map) {
        int N = map.size();
        out.writeInt(N);
        for (int i = 0; i < N; ++i) {
            out.writeString(map.keyAt(i));
            out.writeLong(map.valueAt(i));
        }
    }

    private void __constructor__(HealthKeys.Constants constants) {
        this.$$robo$$android_os_health_HealthStatsWriter$__constructor__(constants);
    }

    public HealthStatsWriter(HealthKeys.Constants constants) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_health_HealthStatsWriter$__constructor__(android.os.health.HealthKeys$Constants ), 0, this, constants);
    }

    public void addTimer(int n, int n2, long l) {
        InvokeDynamicSupport.bootstrap("addTimer", $$robo$$android_os_health_HealthStatsWriter$addTimer(int int long ), 0, this, n, n2, l);
    }

    public void addMeasurement(int n, long l) {
        InvokeDynamicSupport.bootstrap("addMeasurement", $$robo$$android_os_health_HealthStatsWriter$addMeasurement(int long ), 0, this, n, l);
    }

    public void addStats(int n, String string2, HealthStatsWriter healthStatsWriter) {
        InvokeDynamicSupport.bootstrap("addStats", $$robo$$android_os_health_HealthStatsWriter$addStats(int java.lang.String android.os.health.HealthStatsWriter ), 0, this, n, string2, healthStatsWriter);
    }

    public void addTimers(int n, String string2, TimerStat timerStat) {
        InvokeDynamicSupport.bootstrap("addTimers", $$robo$$android_os_health_HealthStatsWriter$addTimers(int java.lang.String android.os.health.TimerStat ), 0, this, n, string2, timerStat);
    }

    public void addMeasurements(int n, String string2, long l) {
        InvokeDynamicSupport.bootstrap("addMeasurements", $$robo$$android_os_health_HealthStatsWriter$addMeasurements(int java.lang.String long ), 0, this, n, string2, l);
    }

    public void flattenToParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("flattenToParcel", $$robo$$android_os_health_HealthStatsWriter$flattenToParcel(android.os.Parcel ), 0, this, parcel);
    }

    private static int countBooleanArray(boolean[] blArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countBooleanArray", $$robo$$android_os_health_HealthStatsWriter$countBooleanArray(boolean[] ), 0, (boolean[])blArray);
    }

    private static <T> int countObjectArray(T[] TArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countObjectArray", $$robo$$android_os_health_HealthStatsWriter$countObjectArray(T[] ), 0, (Object[])TArray);
    }

    private static void writeHealthStatsWriterMap(Parcel parcel, ArrayMap<String, HealthStatsWriter> arrayMap) {
        InvokeDynamicSupport.bootstrapStatic("writeHealthStatsWriterMap", $$robo$$android_os_health_HealthStatsWriter$writeHealthStatsWriterMap(android.os.Parcel android.util.ArrayMap<java.lang.String, android.os.health.HealthStatsWriter> ), 0, (Parcel)parcel, arrayMap);
    }

    private static <T extends Parcelable> void writeParcelableMap(Parcel parcel, ArrayMap<String, T> arrayMap) {
        InvokeDynamicSupport.bootstrapStatic("writeParcelableMap", $$robo$$android_os_health_HealthStatsWriter$writeParcelableMap(android.os.Parcel android.util.ArrayMap<java.lang.String, T> ), 0, (Parcel)parcel, arrayMap);
    }

    private static void writeLongsMap(Parcel parcel, ArrayMap<String, Long> arrayMap) {
        InvokeDynamicSupport.bootstrapStatic("writeLongsMap", $$robo$$android_os_health_HealthStatsWriter$writeLongsMap(android.os.Parcel android.util.ArrayMap<java.lang.String, java.lang.Long> ), 0, (Parcel)parcel, arrayMap);
    }

    public /* synthetic */ HealthStatsWriter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HealthStatsWriter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

