/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriPermission;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteException;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.MiniThumbFile;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.provider.BaseColumns;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MediaStore
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaStore";
    public static String AUTHORITY = "media";
    private static String CONTENT_AUTHORITY_SLASH = "content://media/";
    public static String ACTION_MTP_SESSION_END = "android.provider.action.MTP_SESSION_END";
    public static String UNHIDE_CALL = "unhide";
    public static String PARAM_DELETE_DATA = "deletedata";
    @Deprecated
    public static String INTENT_ACTION_MUSIC_PLAYER = "android.intent.action.MUSIC_PLAYER";
    public static String INTENT_ACTION_MEDIA_SEARCH = "android.intent.action.MEDIA_SEARCH";
    public static String INTENT_ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";
    public static String INTENT_ACTION_TEXT_OPEN_FROM_SEARCH = "android.media.action.TEXT_OPEN_FROM_SEARCH";
    public static String INTENT_ACTION_VIDEO_PLAY_FROM_SEARCH = "android.media.action.VIDEO_PLAY_FROM_SEARCH";
    public static String EXTRA_MEDIA_ARTIST = "android.intent.extra.artist";
    public static String EXTRA_MEDIA_ALBUM = "android.intent.extra.album";
    public static String EXTRA_MEDIA_TITLE = "android.intent.extra.title";
    public static String EXTRA_MEDIA_GENRE = "android.intent.extra.genre";
    public static String EXTRA_MEDIA_PLAYLIST = "android.intent.extra.playlist";
    public static String EXTRA_MEDIA_RADIO_CHANNEL = "android.intent.extra.radio_channel";
    public static String EXTRA_MEDIA_FOCUS = "android.intent.extra.focus";
    public static String EXTRA_SCREEN_ORIENTATION = "android.intent.extra.screenOrientation";
    public static String EXTRA_FULL_SCREEN = "android.intent.extra.fullScreen";
    public static String EXTRA_SHOW_ACTION_ICONS = "android.intent.extra.showActionIcons";
    public static String EXTRA_FINISH_ON_COMPLETION = "android.intent.extra.finishOnCompletion";
    public static String INTENT_ACTION_STILL_IMAGE_CAMERA = "android.media.action.STILL_IMAGE_CAMERA";
    public static String META_DATA_STILL_IMAGE_CAMERA_PREWARM_SERVICE = "android.media.still_image_camera_preview_service";
    public static String INTENT_ACTION_STILL_IMAGE_CAMERA_SECURE = "android.media.action.STILL_IMAGE_CAMERA_SECURE";
    public static String INTENT_ACTION_VIDEO_CAMERA = "android.media.action.VIDEO_CAMERA";
    public static String ACTION_IMAGE_CAPTURE = "android.media.action.IMAGE_CAPTURE";
    public static String ACTION_IMAGE_CAPTURE_SECURE = "android.media.action.IMAGE_CAPTURE_SECURE";
    public static String ACTION_VIDEO_CAPTURE = "android.media.action.VIDEO_CAPTURE";
    public static String EXTRA_VIDEO_QUALITY = "android.intent.extra.videoQuality";
    public static String EXTRA_SIZE_LIMIT = "android.intent.extra.sizeLimit";
    public static String EXTRA_DURATION_LIMIT = "android.intent.extra.durationLimit";
    public static String EXTRA_OUTPUT = "output";
    public static String UNKNOWN_STRING = "<unknown>";
    public static String MEDIA_SCANNER_VOLUME = "volume";
    public static String MEDIA_IGNORE_FILENAME = ".nomedia";

    private void $$robo$$android_provider_MediaStore$__constructor__() {
    }

    private static final Uri $$robo$$android_provider_MediaStore$getMediaScannerUri() {
        return Uri.parse("content://media/none/media_scanner");
    }

    private static final String $$robo$$android_provider_MediaStore$getVersion(Context context) {
        Cursor c = context.getContentResolver().query(Uri.parse("content://media/none/version"), null, null, null, null);
        if (c != null) {
            try {
                if (c.moveToFirst()) {
                    String string2 = c.getString(0);
                    return string2;
                }
            }
            finally {
                c.close();
            }
        }
        return null;
    }

    private static final Uri $$robo$$android_provider_MediaStore$getDocumentUri(Context context, Uri mediaUri) {
        try {
            ContentResolver resolver = context.getContentResolver();
            String path = MediaStore.getFilePath(resolver, mediaUri);
            List<UriPermission> uriPermissions = resolver.getPersistedUriPermissions();
            return MediaStore.getDocumentUri(resolver, path, uriPermissions);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_provider_MediaStore$getFilePath(ContentResolver resolver, Uri mediaUri) throws RemoteException {
        try (ContentProviderClient client = resolver.acquireUnstableContentProviderClient("media");){
            String path;
            Cursor c = client.query(mediaUri, new String[]{"_data"}, null, null, null);
            try {
                if (c.getCount() == 0) {
                    throw new IllegalStateException("Not found media file under URI: " + mediaUri);
                }
                if (!c.moveToFirst()) {
                    throw new IllegalStateException("Failed to move cursor to the first item.");
                }
                path = c.getString(0);
            }
            finally {
                IoUtils.closeQuietly(c);
            }
            String string2 = path;
            return string2;
        }
    }

    private static final Uri $$robo$$android_provider_MediaStore$getDocumentUri(ContentResolver resolver, String path, List<UriPermission> uriPermissions) throws RemoteException {
        try (ContentProviderClient client = resolver.acquireUnstableContentProviderClient("com.android.externalstorage.documents");){
            Bundle in = new Bundle();
            in.putParcelableList("com.android.externalstorage.documents.extra.uriPermissions", uriPermissions);
            Bundle out = client.call("getDocumentId", path, in);
            Uri uri = (Uri)out.getParcelable("uri");
            return uri;
        }
    }

    private void __constructor__() {
        this.$$robo$$android_provider_MediaStore$__constructor__();
    }

    public MediaStore() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore$__constructor__(), 0, this);
    }

    public static Uri getMediaScannerUri() {
        return InvokeDynamicSupport.bootstrapStatic("getMediaScannerUri", $$robo$$android_provider_MediaStore$getMediaScannerUri(), 0);
    }

    public static String getVersion(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getVersion", $$robo$$android_provider_MediaStore$getVersion(android.content.Context ), 0, (Context)context);
    }

    public static Uri getDocumentUri(Context context, Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getDocumentUri", $$robo$$android_provider_MediaStore$getDocumentUri(android.content.Context android.net.Uri ), 0, (Context)context, (Uri)uri);
    }

    private static String getFilePath(ContentResolver contentResolver, Uri uri) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("getFilePath", $$robo$$android_provider_MediaStore$getFilePath(android.content.ContentResolver android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri);
    }

    private static Uri getDocumentUri(ContentResolver contentResolver, String string2, List<UriPermission> list) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("getDocumentUri", $$robo$$android_provider_MediaStore$getDocumentUri(android.content.ContentResolver java.lang.String java.util.List<android.content.UriPermission> ), 0, (ContentResolver)contentResolver, (String)string2, list);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaStore)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Video
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String DEFAULT_SORT_ORDER = "_display_name";

        private void $$robo$$android_provider_MediaStore_Video$__constructor__() {
        }

        private static final Cursor $$robo$$android_provider_MediaStore_Video$query(ContentResolver cr, Uri uri, String[] projection) {
            return cr.query(uri, projection, null, null, "_display_name");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_MediaStore_Video$__constructor__();
        }

        public Video() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Video$__constructor__(), 0, this);
        }

        public static Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray) {
            return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_MediaStore_Video$query(android.content.ContentResolver android.net.Uri java.lang.String[] ), 0, (ContentResolver)contentResolver, (Uri)uri, (String[])stringArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Video)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Thumbnails
        implements BaseColumns,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static Uri INTERNAL_CONTENT_URI;
            public static Uri EXTERNAL_CONTENT_URI;
            public static String DEFAULT_SORT_ORDER = "video_id ASC";
            public static String DATA = "_data";
            public static String VIDEO_ID = "video_id";
            public static String KIND = "kind";
            public static int MINI_KIND = 1;
            public static int FULL_SCREEN_KIND = 2;
            public static int MICRO_KIND = 3;
            public static String WIDTH = "width";
            public static String HEIGHT = "height";

            private void $$robo$$android_provider_MediaStore_Video_Thumbnails$__constructor__() {
            }

            private static final void $$robo$$android_provider_MediaStore_Video_Thumbnails$cancelThumbnailRequest(ContentResolver cr, long origId) {
                InternalThumbnails.cancelThumbnailRequest(cr, origId, EXTERNAL_CONTENT_URI, 0L);
            }

            private static final Bitmap $$robo$$android_provider_MediaStore_Video_Thumbnails$getThumbnail(ContentResolver cr, long origId, int kind, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(cr, origId, 0L, kind, options, EXTERNAL_CONTENT_URI, true);
            }

            private static final Bitmap $$robo$$android_provider_MediaStore_Video_Thumbnails$getThumbnail(ContentResolver cr, long origId, long groupId, int kind, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(cr, origId, groupId, kind, options, EXTERNAL_CONTENT_URI, true);
            }

            private static final void $$robo$$android_provider_MediaStore_Video_Thumbnails$cancelThumbnailRequest(ContentResolver cr, long origId, long groupId) {
                InternalThumbnails.cancelThumbnailRequest(cr, origId, EXTERNAL_CONTENT_URI, groupId);
            }

            private static final Uri $$robo$$android_provider_MediaStore_Video_Thumbnails$getContentUri(String volumeName) {
                return Uri.parse("content://media/" + volumeName + "/video/thumbnails");
            }

            static void __staticInitializer__() {
                INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Video_Thumbnails$__constructor__();
            }

            public Thumbnails() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Video_Thumbnails$__constructor__(), 0, this);
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l) {
                InvokeDynamicSupport.bootstrapStatic("cancelThumbnailRequest", $$robo$$android_provider_MediaStore_Video_Thumbnails$cancelThumbnailRequest(android.content.ContentResolver long ), 0, (ContentResolver)contentResolver, (long)l);
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, int n, BitmapFactory.Options options) {
                return InvokeDynamicSupport.bootstrapStatic("getThumbnail", $$robo$$android_provider_MediaStore_Video_Thumbnails$getThumbnail(android.content.ContentResolver long int android.graphics.BitmapFactory$Options ), 0, (ContentResolver)contentResolver, (long)l, (int)n, (BitmapFactory.Options)options);
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, long l2, int n, BitmapFactory.Options options) {
                return InvokeDynamicSupport.bootstrapStatic("getThumbnail", $$robo$$android_provider_MediaStore_Video_Thumbnails$getThumbnail(android.content.ContentResolver long long int android.graphics.BitmapFactory$Options ), 0, (ContentResolver)contentResolver, (long)l, (long)l2, (int)n, (BitmapFactory.Options)options);
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l, long l2) {
                InvokeDynamicSupport.bootstrapStatic("cancelThumbnailRequest", $$robo$$android_provider_MediaStore_Video_Thumbnails$cancelThumbnailRequest(android.content.ContentResolver long long ), 0, (ContentResolver)contentResolver, (long)l, (long)l2);
            }

            public static Uri getContentUri(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Video_Thumbnails$getContentUri(java.lang.String ), 0, (String)string2);
            }

            static {
                RobolectricInternals.classInitializing(Thumbnails.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Thumbnails)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Media
        implements VideoColumns,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static Uri INTERNAL_CONTENT_URI;
            public static Uri EXTERNAL_CONTENT_URI;
            public static String CONTENT_TYPE = "vnd.android.cursor.dir/video";
            public static String DEFAULT_SORT_ORDER = "title";

            private void $$robo$$android_provider_MediaStore_Video_Media$__constructor__() {
            }

            private static final Uri $$robo$$android_provider_MediaStore_Video_Media$getContentUri(String volumeName) {
                return Uri.parse("content://media/" + volumeName + "/video/media");
            }

            static void __staticInitializer__() {
                INTERNAL_CONTENT_URI = Media.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Video_Media$__constructor__();
            }

            public Media() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Video_Media$__constructor__(), 0, this);
            }

            public static Uri getContentUri(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Video_Media$getContentUri(java.lang.String ), 0, (String)string2);
            }

            static {
                RobolectricInternals.classInitializing(Media.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Media)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static interface VideoColumns
        extends MediaColumns,
        InstrumentedInterface {
            public static final String DURATION = "duration";
            public static final String ARTIST = "artist";
            public static final String ALBUM = "album";
            public static final String RESOLUTION = "resolution";
            public static final String DESCRIPTION = "description";
            public static final String IS_PRIVATE = "isprivate";
            public static final String TAGS = "tags";
            public static final String CATEGORY = "category";
            public static final String LANGUAGE = "language";
            public static final String LATITUDE = "latitude";
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String BOOKMARK = "bookmark";
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Audio
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_provider_MediaStore_Audio$__constructor__() {
        }

        private static final String $$robo$$android_provider_MediaStore_Audio$keyFor(String name) {
            if (name != null) {
                boolean sortfirst = false;
                if (name.equals("<unknown>")) {
                    return "\u0001";
                }
                if (name.startsWith("\u0001")) {
                    sortfirst = true;
                }
                if ((name = name.trim().toLowerCase()).startsWith("the ")) {
                    name = name.substring(4);
                }
                if (name.startsWith("an ")) {
                    name = name.substring(3);
                }
                if (name.startsWith("a ")) {
                    name = name.substring(2);
                }
                if (name.endsWith(", the") || name.endsWith(",the") || name.endsWith(", an") || name.endsWith(",an") || name.endsWith(", a") || name.endsWith(",a")) {
                    name = name.substring(0, name.lastIndexOf(44));
                }
                if ((name = name.replaceAll("[\\[\\]\\(\\)\"'.,?!]", "").trim()).length() > 0) {
                    StringBuilder b = new StringBuilder();
                    b.append('.');
                    int nl = name.length();
                    for (int i = 0; i < nl; ++i) {
                        b.append(name.charAt(i));
                        b.append('.');
                    }
                    name = b.toString();
                    String key = DatabaseUtils.getCollationKey(name);
                    if (sortfirst) {
                        key = "\u0001" + key;
                    }
                    return key;
                }
                return "";
            }
            return null;
        }

        private void __constructor__() {
            this.$$robo$$android_provider_MediaStore_Audio$__constructor__();
        }

        public Audio() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio$__constructor__(), 0, this);
        }

        public static String keyFor(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("keyFor", $$robo$$android_provider_MediaStore_Audio$keyFor(java.lang.String ), 0, (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Audio)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Radio
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/radio";

            private void $$robo$$android_provider_MediaStore_Audio_Radio$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Audio_Radio$__constructor__();
            }

            private Radio() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio_Radio$__constructor__(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Radio)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Albums
        implements BaseColumns,
        AlbumColumns,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static Uri INTERNAL_CONTENT_URI;
            public static Uri EXTERNAL_CONTENT_URI;
            public static String CONTENT_TYPE = "vnd.android.cursor.dir/albums";
            public static String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/album";
            public static String DEFAULT_SORT_ORDER = "album_key";

            private void $$robo$$android_provider_MediaStore_Audio_Albums$__constructor__() {
            }

            private static final Uri $$robo$$android_provider_MediaStore_Audio_Albums$getContentUri(String volumeName) {
                return Uri.parse("content://media/" + volumeName + "/audio/albums");
            }

            static void __staticInitializer__() {
                INTERNAL_CONTENT_URI = Albums.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Albums.getContentUri("external");
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Audio_Albums$__constructor__();
            }

            public Albums() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio_Albums$__constructor__(), 0, this);
            }

            public static Uri getContentUri(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Audio_Albums$getContentUri(java.lang.String ), 0, (String)string2);
            }

            static {
                RobolectricInternals.classInitializing(Albums.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Albums)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static interface AlbumColumns
        extends InstrumentedInterface {
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM = "album";
            public static final String ARTIST = "artist";
            public static final String NUMBER_OF_SONGS = "numsongs";
            public static final String NUMBER_OF_SONGS_FOR_ARTIST = "numsongs_by_artist";
            public static final String FIRST_YEAR = "minyear";
            public static final String LAST_YEAR = "maxyear";
            public static final String ALBUM_KEY = "album_key";
            public static final String ALBUM_ART = "album_art";
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Artists
        implements BaseColumns,
        ArtistColumns,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static Uri INTERNAL_CONTENT_URI;
            public static Uri EXTERNAL_CONTENT_URI;
            public static String CONTENT_TYPE = "vnd.android.cursor.dir/artists";
            public static String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/artist";
            public static String DEFAULT_SORT_ORDER = "artist_key";

            private void $$robo$$android_provider_MediaStore_Audio_Artists$__constructor__() {
            }

            private static final Uri $$robo$$android_provider_MediaStore_Audio_Artists$getContentUri(String volumeName) {
                return Uri.parse("content://media/" + volumeName + "/audio/artists");
            }

            static void __staticInitializer__() {
                INTERNAL_CONTENT_URI = Artists.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Artists.getContentUri("external");
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Audio_Artists$__constructor__();
            }

            public Artists() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio_Artists$__constructor__(), 0, this);
            }

            public static Uri getContentUri(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Audio_Artists$getContentUri(java.lang.String ), 0, (String)string2);
            }

            static {
                RobolectricInternals.classInitializing(Artists.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Artists)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }

            @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
            public static final class Albums
            implements AlbumColumns,
            ShadowedObject {
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_provider_MediaStore_Audio_Artists_Albums$__constructor__() {
                }

                private static final Uri $$robo$$android_provider_MediaStore_Audio_Artists_Albums$getContentUri(String volumeName, long artistId) {
                    return Uri.parse("content://media/" + volumeName + "/audio/artists/" + artistId + "/albums");
                }

                private void __constructor__() {
                    this.$$robo$$android_provider_MediaStore_Audio_Artists_Albums$__constructor__();
                }

                public Albums() {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio_Artists_Albums$__constructor__(), 0, this);
                }

                public static Uri getContentUri(String string2, long l) {
                    return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Audio_Artists_Albums$getContentUri(java.lang.String long ), 0, (String)string2, (long)l);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Albums)this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }
        }

        public static interface ArtistColumns
        extends InstrumentedInterface {
            public static final String ARTIST = "artist";
            public static final String ARTIST_KEY = "artist_key";
            public static final String NUMBER_OF_ALBUMS = "number_of_albums";
            public static final String NUMBER_OF_TRACKS = "number_of_tracks";
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Playlists
        implements BaseColumns,
        PlaylistsColumns,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static Uri INTERNAL_CONTENT_URI;
            public static Uri EXTERNAL_CONTENT_URI;
            public static String CONTENT_TYPE = "vnd.android.cursor.dir/playlist";
            public static String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/playlist";
            public static String DEFAULT_SORT_ORDER = "name";

            private void $$robo$$android_provider_MediaStore_Audio_Playlists$__constructor__() {
            }

            private static final Uri $$robo$$android_provider_MediaStore_Audio_Playlists$getContentUri(String volumeName) {
                return Uri.parse("content://media/" + volumeName + "/audio/playlists");
            }

            static void __staticInitializer__() {
                INTERNAL_CONTENT_URI = Playlists.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Playlists.getContentUri("external");
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Audio_Playlists$__constructor__();
            }

            public Playlists() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio_Playlists$__constructor__(), 0, this);
            }

            public static Uri getContentUri(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Audio_Playlists$getContentUri(java.lang.String ), 0, (String)string2);
            }

            static {
                RobolectricInternals.classInitializing(Playlists.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Playlists)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }

            @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
            public static final class Members
            implements AudioColumns,
            ShadowedObject {
                public transient /* synthetic */ Object __robo_data__;
                public static String _ID = "_id";
                public static String CONTENT_DIRECTORY = "members";
                public static String AUDIO_ID = "audio_id";
                public static String PLAYLIST_ID = "playlist_id";
                public static String PLAY_ORDER = "play_order";
                public static String DEFAULT_SORT_ORDER = "play_order";

                private void $$robo$$android_provider_MediaStore_Audio_Playlists_Members$__constructor__() {
                }

                private static final Uri $$robo$$android_provider_MediaStore_Audio_Playlists_Members$getContentUri(String volumeName, long playlistId) {
                    return Uri.parse("content://media/" + volumeName + "/audio/playlists/" + playlistId + "/members");
                }

                private static final boolean $$robo$$android_provider_MediaStore_Audio_Playlists_Members$moveItem(ContentResolver res, long playlistId, int from, int to) {
                    Uri uri = Members.getContentUri("external", playlistId).buildUpon().appendEncodedPath(String.valueOf(from)).appendQueryParameter("move", "true").build();
                    ContentValues values = new ContentValues();
                    values.put("play_order", to);
                    return res.update(uri, values, null, null) != 0;
                }

                private void __constructor__() {
                    this.$$robo$$android_provider_MediaStore_Audio_Playlists_Members$__constructor__();
                }

                public Members() {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio_Playlists_Members$__constructor__(), 0, this);
                }

                public static Uri getContentUri(String string2, long l) {
                    return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Audio_Playlists_Members$getContentUri(java.lang.String long ), 0, (String)string2, (long)l);
                }

                public static boolean moveItem(ContentResolver contentResolver, long l, int n, int n2) {
                    return (boolean)InvokeDynamicSupport.bootstrapStatic("moveItem", $$robo$$android_provider_MediaStore_Audio_Playlists_Members$moveItem(android.content.ContentResolver long int int ), 0, (ContentResolver)contentResolver, (long)l, (int)n, (int)n2);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Members)this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }
        }

        public static interface PlaylistsColumns
        extends InstrumentedInterface {
            public static final String NAME = "name";
            public static final String DATA = "_data";
            public static final String DATE_ADDED = "date_added";
            public static final String DATE_MODIFIED = "date_modified";
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Genres
        implements BaseColumns,
        GenresColumns,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static Uri INTERNAL_CONTENT_URI;
            public static Uri EXTERNAL_CONTENT_URI;
            public static String CONTENT_TYPE = "vnd.android.cursor.dir/genre";
            public static String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/genre";
            public static String DEFAULT_SORT_ORDER = "name";

            private void $$robo$$android_provider_MediaStore_Audio_Genres$__constructor__() {
            }

            private static final Uri $$robo$$android_provider_MediaStore_Audio_Genres$getContentUri(String volumeName) {
                return Uri.parse("content://media/" + volumeName + "/audio/genres");
            }

            private static final Uri $$robo$$android_provider_MediaStore_Audio_Genres$getContentUriForAudioId(String volumeName, int audioId) {
                return Uri.parse("content://media/" + volumeName + "/audio/media/" + audioId + "/genres");
            }

            static void __staticInitializer__() {
                INTERNAL_CONTENT_URI = Genres.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Genres.getContentUri("external");
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Audio_Genres$__constructor__();
            }

            public Genres() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio_Genres$__constructor__(), 0, this);
            }

            public static Uri getContentUri(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Audio_Genres$getContentUri(java.lang.String ), 0, (String)string2);
            }

            public static Uri getContentUriForAudioId(String string2, int n) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUriForAudioId", $$robo$$android_provider_MediaStore_Audio_Genres$getContentUriForAudioId(java.lang.String int ), 0, (String)string2, (int)n);
            }

            static {
                RobolectricInternals.classInitializing(Genres.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Genres)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }

            @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
            public static final class Members
            implements AudioColumns,
            ShadowedObject {
                public transient /* synthetic */ Object __robo_data__;
                public static String CONTENT_DIRECTORY = "members";
                public static String DEFAULT_SORT_ORDER = "title_key";
                public static String AUDIO_ID = "audio_id";
                public static String GENRE_ID = "genre_id";

                private void $$robo$$android_provider_MediaStore_Audio_Genres_Members$__constructor__() {
                }

                private static final Uri $$robo$$android_provider_MediaStore_Audio_Genres_Members$getContentUri(String volumeName, long genreId) {
                    return Uri.parse("content://media/" + volumeName + "/audio/genres/" + genreId + "/members");
                }

                private void __constructor__() {
                    this.$$robo$$android_provider_MediaStore_Audio_Genres_Members$__constructor__();
                }

                public Members() {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio_Genres_Members$__constructor__(), 0, this);
                }

                public static Uri getContentUri(String string2, long l) {
                    return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Audio_Genres_Members$getContentUri(java.lang.String long ), 0, (String)string2, (long)l);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Members)this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }
        }

        public static interface GenresColumns
        extends InstrumentedInterface {
            public static final String NAME = "name";
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Media
        implements AudioColumns,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private static String[] EXTERNAL_PATHS;
            public static Uri INTERNAL_CONTENT_URI;
            public static Uri EXTERNAL_CONTENT_URI;
            public static String CONTENT_TYPE = "vnd.android.cursor.dir/audio";
            public static String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/audio";
            public static String DEFAULT_SORT_ORDER = "title_key";
            public static String RECORD_SOUND_ACTION = "android.provider.MediaStore.RECORD_SOUND";
            public static String EXTRA_MAX_BYTES = "android.provider.MediaStore.extra.MAX_BYTES";

            private void $$robo$$android_provider_MediaStore_Audio_Media$__constructor__() {
            }

            private static final Uri $$robo$$android_provider_MediaStore_Audio_Media$getContentUri(String volumeName) {
                return Uri.parse("content://media/" + volumeName + "/audio/media");
            }

            private static final Uri $$robo$$android_provider_MediaStore_Audio_Media$getContentUriForPath(String path) {
                for (String ep : EXTERNAL_PATHS) {
                    if (!path.startsWith(ep)) continue;
                    return EXTERNAL_CONTENT_URI;
                }
                return path.startsWith(Environment.getExternalStorageDirectory().getPath()) ? EXTERNAL_CONTENT_URI : INTERNAL_CONTENT_URI;
            }

            static void __staticInitializer__() {
                String secondary_storage = System.getenv("SECONDARY_STORAGE");
                EXTERNAL_PATHS = secondary_storage != null ? secondary_storage.split(":") : new String[0];
                INTERNAL_CONTENT_URI = Media.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Audio_Media$__constructor__();
            }

            public Media() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Audio_Media$__constructor__(), 0, this);
            }

            public static Uri getContentUri(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Audio_Media$getContentUri(java.lang.String ), 0, (String)string2);
            }

            public static Uri getContentUriForPath(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUriForPath", $$robo$$android_provider_MediaStore_Audio_Media$getContentUriForPath(java.lang.String ), 0, (String)string2);
            }

            static {
                RobolectricInternals.classInitializing(Media.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Media)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static interface AudioColumns
        extends MediaColumns,
        InstrumentedInterface {
            public static final String TITLE_KEY = "title_key";
            public static final String DURATION = "duration";
            public static final String BOOKMARK = "bookmark";
            public static final String ARTIST_ID = "artist_id";
            public static final String ARTIST = "artist";
            public static final String ALBUM_ARTIST = "album_artist";
            public static final String COMPILATION = "compilation";
            public static final String ARTIST_KEY = "artist_key";
            public static final String COMPOSER = "composer";
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM = "album";
            public static final String ALBUM_KEY = "album_key";
            public static final String TRACK = "track";
            public static final String YEAR = "year";
            public static final String IS_MUSIC = "is_music";
            public static final String IS_PODCAST = "is_podcast";
            public static final String IS_RINGTONE = "is_ringtone";
            public static final String IS_ALARM = "is_alarm";
            public static final String IS_NOTIFICATION = "is_notification";
            public static final String GENRE = "genre";
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Images
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_provider_MediaStore_Images$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_MediaStore_Images$__constructor__();
        }

        public Images() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Images$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Images)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Thumbnails
        implements BaseColumns,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static Uri INTERNAL_CONTENT_URI;
            public static Uri EXTERNAL_CONTENT_URI;
            public static String DEFAULT_SORT_ORDER = "image_id ASC";
            public static String DATA = "_data";
            public static String IMAGE_ID = "image_id";
            public static String KIND = "kind";
            public static int MINI_KIND = 1;
            public static int FULL_SCREEN_KIND = 2;
            public static int MICRO_KIND = 3;
            public static String THUMB_DATA = "thumb_data";
            public static String WIDTH = "width";
            public static String HEIGHT = "height";

            private void $$robo$$android_provider_MediaStore_Images_Thumbnails$__constructor__() {
            }

            private static final Cursor $$robo$$android_provider_MediaStore_Images_Thumbnails$query(ContentResolver cr, Uri uri, String[] projection) {
                return cr.query(uri, projection, null, null, "image_id ASC");
            }

            private static final Cursor $$robo$$android_provider_MediaStore_Images_Thumbnails$queryMiniThumbnails(ContentResolver cr, Uri uri, int kind, String[] projection) {
                return cr.query(uri, projection, "kind = " + kind, null, "image_id ASC");
            }

            private static final Cursor $$robo$$android_provider_MediaStore_Images_Thumbnails$queryMiniThumbnail(ContentResolver cr, long origId, int kind, String[] projection) {
                return cr.query(EXTERNAL_CONTENT_URI, projection, "image_id = " + origId + " AND " + "kind" + " = " + kind, null, null);
            }

            private static final void $$robo$$android_provider_MediaStore_Images_Thumbnails$cancelThumbnailRequest(ContentResolver cr, long origId) {
                InternalThumbnails.cancelThumbnailRequest(cr, origId, EXTERNAL_CONTENT_URI, 0L);
            }

            private static final Bitmap $$robo$$android_provider_MediaStore_Images_Thumbnails$getThumbnail(ContentResolver cr, long origId, int kind, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(cr, origId, 0L, kind, options, EXTERNAL_CONTENT_URI, false);
            }

            private static final void $$robo$$android_provider_MediaStore_Images_Thumbnails$cancelThumbnailRequest(ContentResolver cr, long origId, long groupId) {
                InternalThumbnails.cancelThumbnailRequest(cr, origId, EXTERNAL_CONTENT_URI, groupId);
            }

            private static final Bitmap $$robo$$android_provider_MediaStore_Images_Thumbnails$getThumbnail(ContentResolver cr, long origId, long groupId, int kind, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(cr, origId, groupId, kind, options, EXTERNAL_CONTENT_URI, false);
            }

            private static final Uri $$robo$$android_provider_MediaStore_Images_Thumbnails$getContentUri(String volumeName) {
                return Uri.parse("content://media/" + volumeName + "/images/thumbnails");
            }

            static void __staticInitializer__() {
                INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Images_Thumbnails$__constructor__();
            }

            public Thumbnails() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Images_Thumbnails$__constructor__(), 0, this);
            }

            public static Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray) {
                return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_MediaStore_Images_Thumbnails$query(android.content.ContentResolver android.net.Uri java.lang.String[] ), 0, (ContentResolver)contentResolver, (Uri)uri, (String[])stringArray);
            }

            public static Cursor queryMiniThumbnails(ContentResolver contentResolver, Uri uri, int n, String[] stringArray) {
                return InvokeDynamicSupport.bootstrapStatic("queryMiniThumbnails", $$robo$$android_provider_MediaStore_Images_Thumbnails$queryMiniThumbnails(android.content.ContentResolver android.net.Uri int java.lang.String[] ), 0, (ContentResolver)contentResolver, (Uri)uri, (int)n, (String[])stringArray);
            }

            public static Cursor queryMiniThumbnail(ContentResolver contentResolver, long l, int n, String[] stringArray) {
                return InvokeDynamicSupport.bootstrapStatic("queryMiniThumbnail", $$robo$$android_provider_MediaStore_Images_Thumbnails$queryMiniThumbnail(android.content.ContentResolver long int java.lang.String[] ), 0, (ContentResolver)contentResolver, (long)l, (int)n, (String[])stringArray);
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l) {
                InvokeDynamicSupport.bootstrapStatic("cancelThumbnailRequest", $$robo$$android_provider_MediaStore_Images_Thumbnails$cancelThumbnailRequest(android.content.ContentResolver long ), 0, (ContentResolver)contentResolver, (long)l);
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, int n, BitmapFactory.Options options) {
                return InvokeDynamicSupport.bootstrapStatic("getThumbnail", $$robo$$android_provider_MediaStore_Images_Thumbnails$getThumbnail(android.content.ContentResolver long int android.graphics.BitmapFactory$Options ), 0, (ContentResolver)contentResolver, (long)l, (int)n, (BitmapFactory.Options)options);
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l, long l2) {
                InvokeDynamicSupport.bootstrapStatic("cancelThumbnailRequest", $$robo$$android_provider_MediaStore_Images_Thumbnails$cancelThumbnailRequest(android.content.ContentResolver long long ), 0, (ContentResolver)contentResolver, (long)l, (long)l2);
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, long l2, int n, BitmapFactory.Options options) {
                return InvokeDynamicSupport.bootstrapStatic("getThumbnail", $$robo$$android_provider_MediaStore_Images_Thumbnails$getThumbnail(android.content.ContentResolver long long int android.graphics.BitmapFactory$Options ), 0, (ContentResolver)contentResolver, (long)l, (long)l2, (int)n, (BitmapFactory.Options)options);
            }

            public static Uri getContentUri(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Images_Thumbnails$getContentUri(java.lang.String ), 0, (String)string2);
            }

            static {
                RobolectricInternals.classInitializing(Thumbnails.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Thumbnails)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Media
        implements ImageColumns,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static Uri INTERNAL_CONTENT_URI;
            public static Uri EXTERNAL_CONTENT_URI;
            public static String CONTENT_TYPE = "vnd.android.cursor.dir/image";
            public static String DEFAULT_SORT_ORDER = "bucket_display_name";

            private void $$robo$$android_provider_MediaStore_Images_Media$__constructor__() {
            }

            private static final Cursor $$robo$$android_provider_MediaStore_Images_Media$query(ContentResolver cr, Uri uri, String[] projection) {
                return cr.query(uri, projection, null, null, "bucket_display_name");
            }

            private static final Cursor $$robo$$android_provider_MediaStore_Images_Media$query(ContentResolver cr, Uri uri, String[] projection, String where, String orderBy) {
                return cr.query(uri, projection, where, null, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
            }

            private static final Cursor $$robo$$android_provider_MediaStore_Images_Media$query(ContentResolver cr, Uri uri, String[] projection, String selection, String[] selectionArgs, String orderBy) {
                return cr.query(uri, projection, selection, selectionArgs, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
            }

            private static final Bitmap $$robo$$android_provider_MediaStore_Images_Media$getBitmap(ContentResolver cr, Uri url) throws FileNotFoundException, IOException {
                InputStream input = cr.openInputStream(url);
                Bitmap bitmap = BitmapFactory.decodeStream(input);
                input.close();
                return bitmap;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final String $$robo$$android_provider_MediaStore_Images_Media$insertImage(ContentResolver cr, String imagePath, String name, String description) throws FileNotFoundException {
                FileInputStream stream = new FileInputStream(imagePath);
                try {
                    Bitmap bm = BitmapFactory.decodeFile(imagePath);
                    String ret = Media.insertImage(cr, bm, name, description);
                    bm.recycle();
                    String string2 = ret;
                    return string2;
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }

            private static final Bitmap $$robo$$android_provider_MediaStore_Images_Media$StoreThumbnail(ContentResolver cr, Bitmap source, long id2, float width, float height, int kind) {
                Matrix matrix = new Matrix();
                float scaleX = width / (float)source.getWidth();
                float scaleY = height / (float)source.getHeight();
                matrix.setScale(scaleX, scaleY);
                Bitmap thumb = Bitmap.createBitmap(source, 0, 0, source.getWidth(), source.getHeight(), matrix, true);
                ContentValues values = new ContentValues(4);
                values.put("kind", kind);
                values.put("image_id", (int)id2);
                values.put("height", thumb.getHeight());
                values.put("width", thumb.getWidth());
                Uri url = cr.insert(Thumbnails.EXTERNAL_CONTENT_URI, values);
                try {
                    OutputStream thumbOut = cr.openOutputStream(url);
                    thumb.compress(Bitmap.CompressFormat.JPEG, 100, thumbOut);
                    thumbOut.close();
                    return thumb;
                }
                catch (FileNotFoundException ex) {
                    return null;
                }
                catch (IOException ex) {
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final String $$robo$$android_provider_MediaStore_Images_Media$insertImage(ContentResolver cr, Bitmap source, String title, String description) {
                String stringUrl;
                Uri url;
                block8: {
                    ContentValues values = new ContentValues();
                    values.put("title", title);
                    values.put("description", description);
                    values.put("mime_type", "image/jpeg");
                    url = null;
                    stringUrl = null;
                    try {
                        url = cr.insert(EXTERNAL_CONTENT_URI, values);
                        if (source != null) {
                            try (OutputStream imageOut = cr.openOutputStream(url);){
                                source.compress(Bitmap.CompressFormat.JPEG, 50, imageOut);
                            }
                            long id2 = ContentUris.parseId(url);
                            Bitmap miniThumb = Thumbnails.getThumbnail(cr, id2, 1, null);
                            Bitmap bitmap = Media.StoreThumbnail(cr, miniThumb, id2, 50.0f, 50.0f, 3);
                            break block8;
                        }
                        Log.e("MediaStore", "Failed to create thumbnail, removing original");
                        cr.delete(url, null, null);
                        url = null;
                    }
                    catch (Exception e) {
                        Log.e("MediaStore", "Failed to insert image", e);
                        if (url == null) break block8;
                        cr.delete(url, null, null);
                        url = null;
                    }
                }
                if (url != null) {
                    stringUrl = url.toString();
                }
                return stringUrl;
            }

            private static final Uri $$robo$$android_provider_MediaStore_Images_Media$getContentUri(String volumeName) {
                return Uri.parse("content://media/" + volumeName + "/images/media");
            }

            static void __staticInitializer__() {
                INTERNAL_CONTENT_URI = Media.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            }

            private void __constructor__() {
                this.$$robo$$android_provider_MediaStore_Images_Media$__constructor__();
            }

            public Media() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Images_Media$__constructor__(), 0, this);
            }

            public static Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray) {
                return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_MediaStore_Images_Media$query(android.content.ContentResolver android.net.Uri java.lang.String[] ), 0, (ContentResolver)contentResolver, (Uri)uri, (String[])stringArray);
            }

            public static Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray, String string2, String string3) {
                return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_MediaStore_Images_Media$query(android.content.ContentResolver android.net.Uri java.lang.String[] java.lang.String java.lang.String ), 0, (ContentResolver)contentResolver, (Uri)uri, (String[])stringArray, (String)string2, (String)string3);
            }

            public static Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
                return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_MediaStore_Images_Media$query(android.content.ContentResolver android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, (ContentResolver)contentResolver, (Uri)uri, (String[])stringArray, (String)string2, (String[])stringArray2, (String)string3);
            }

            public static Bitmap getBitmap(ContentResolver contentResolver, Uri uri) throws FileNotFoundException, IOException {
                return InvokeDynamicSupport.bootstrapStatic("getBitmap", $$robo$$android_provider_MediaStore_Images_Media$getBitmap(android.content.ContentResolver android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri);
            }

            public static String insertImage(ContentResolver contentResolver, String string2, String string3, String string4) throws FileNotFoundException {
                return InvokeDynamicSupport.bootstrapStatic("insertImage", $$robo$$android_provider_MediaStore_Images_Media$insertImage(android.content.ContentResolver java.lang.String java.lang.String java.lang.String ), 0, (ContentResolver)contentResolver, (String)string2, (String)string3, (String)string4);
            }

            private static Bitmap StoreThumbnail(ContentResolver contentResolver, Bitmap bitmap, long l, float f, float f2, int n) {
                return InvokeDynamicSupport.bootstrapStatic("StoreThumbnail", $$robo$$android_provider_MediaStore_Images_Media$StoreThumbnail(android.content.ContentResolver android.graphics.Bitmap long float float int ), 0, (ContentResolver)contentResolver, (Bitmap)bitmap, (long)l, (float)f, (float)f2, (int)n);
            }

            public static String insertImage(ContentResolver contentResolver, Bitmap bitmap, String string2, String string3) {
                return InvokeDynamicSupport.bootstrapStatic("insertImage", $$robo$$android_provider_MediaStore_Images_Media$insertImage(android.content.ContentResolver android.graphics.Bitmap java.lang.String java.lang.String ), 0, (ContentResolver)contentResolver, (Bitmap)bitmap, (String)string2, (String)string3);
            }

            public static Uri getContentUri(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Images_Media$getContentUri(java.lang.String ), 0, (String)string2);
            }

            static {
                RobolectricInternals.classInitializing(Media.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Media)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static interface ImageColumns
        extends MediaColumns,
        InstrumentedInterface {
            public static final String DESCRIPTION = "description";
            public static final String PICASA_ID = "picasa_id";
            public static final String IS_PRIVATE = "isprivate";
            public static final String LATITUDE = "latitude";
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            public static final String ORIENTATION = "orientation";
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
        }
    }

    private static class InternalThumbnails
    implements BaseColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MINI_KIND = 1;
        private static int FULL_SCREEN_KIND = 2;
        private static int MICRO_KIND = 3;
        private static String[] PROJECTION;
        static int DEFAULT_GROUP_ID = 0;
        private static Object sThumbBufLock;
        private static byte[] sThumbBuf;

        private void $$robo$$android_provider_MediaStore_InternalThumbnails$__constructor__() {
        }

        private static final Bitmap $$robo$$android_provider_MediaStore_InternalThumbnails$getMiniThumbFromFile(Cursor c, Uri baseUri, ContentResolver cr, BitmapFactory.Options options) {
            Bitmap bitmap = null;
            Uri thumbUri = null;
            try {
                long thumbId = c.getLong(0);
                String filePath = c.getString(1);
                thumbUri = ContentUris.withAppendedId(baseUri, thumbId);
                ParcelFileDescriptor pfdInput = cr.openFileDescriptor(thumbUri, "r");
                bitmap = BitmapFactory.decodeFileDescriptor(pfdInput.getFileDescriptor(), null, options);
                pfdInput.close();
            }
            catch (FileNotFoundException ex) {
                Log.e("MediaStore", "couldn't open thumbnail " + thumbUri + "; " + ex);
            }
            catch (IOException ex) {
                Log.e("MediaStore", "couldn't open thumbnail " + thumbUri + "; " + ex);
            }
            catch (OutOfMemoryError ex) {
                Log.e("MediaStore", "failed to allocate memory for thumbnail " + thumbUri + "; " + ex);
            }
            return bitmap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void $$robo$$android_provider_MediaStore_InternalThumbnails$cancelThumbnailRequest(ContentResolver cr, long origId, Uri baseUri, long groupId) {
            Uri cancelUri = baseUri.buildUpon().appendQueryParameter("cancel", "1").appendQueryParameter("orig_id", String.valueOf(origId)).appendQueryParameter("group_id", String.valueOf(groupId)).build();
            try (Cursor c = null;){
                c = cr.query(cancelUri, PROJECTION, null, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Bitmap $$robo$$android_provider_MediaStore_InternalThumbnails$getThumbnail(ContentResolver cr, long origId, long groupId, int kind, BitmapFactory.Options options, Uri baseUri, boolean isVideo) {
            Bitmap bitmap = null;
            MiniThumbFile thumbFile = new MiniThumbFile(isVideo ? Video.Media.EXTERNAL_CONTENT_URI : Images.Media.EXTERNAL_CONTENT_URI);
            Cursor c = null;
            try {
                long magic = thumbFile.getMagic(origId);
                if (magic != 0L) {
                    String column;
                    if (kind == 3) {
                        Object object = sThumbBufLock;
                        synchronized (object) {
                            if (sThumbBuf == null) {
                                sThumbBuf = new byte[10000];
                            }
                            if (thumbFile.getMiniThumbFromFile(origId, sThumbBuf) != null && (bitmap = BitmapFactory.decodeByteArray(sThumbBuf, 0, sThumbBuf.length)) == null) {
                                Log.w("MediaStore", "couldn't decode byte array.");
                            }
                        }
                        object = bitmap;
                        return object;
                    }
                    if (kind == 1 && (c = cr.query(baseUri, PROJECTION, (column = isVideo ? "video_id=" : "image_id=") + origId, null, null)) != null && c.moveToFirst() && (bitmap = InternalThumbnails.getMiniThumbFromFile(c, baseUri, cr, options)) != null) {
                        Bitmap bitmap2 = bitmap;
                        return bitmap2;
                    }
                }
                Uri blockingUri = baseUri.buildUpon().appendQueryParameter("blocking", "1").appendQueryParameter("orig_id", String.valueOf(origId)).appendQueryParameter("group_id", String.valueOf(groupId)).build();
                if (c != null) {
                    c.close();
                }
                if ((c = cr.query(blockingUri, PROJECTION, null, null, null)) == null) {
                    Bitmap bitmap3 = null;
                    return bitmap3;
                }
                if (kind == 3) {
                    Object object = sThumbBufLock;
                    synchronized (object) {
                        if (sThumbBuf == null) {
                            sThumbBuf = new byte[10000];
                        }
                        Arrays.fill(sThumbBuf, (byte)0);
                        if (thumbFile.getMiniThumbFromFile(origId, sThumbBuf) != null && (bitmap = BitmapFactory.decodeByteArray(sThumbBuf, 0, sThumbBuf.length)) == null) {
                            Log.w("MediaStore", "couldn't decode byte array.");
                        }
                    }
                } else if (kind == 1) {
                    if (c.moveToFirst()) {
                        bitmap = InternalThumbnails.getMiniThumbFromFile(c, baseUri, cr, options);
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported kind: " + kind);
                }
                if (bitmap == null) {
                    Log.v("MediaStore", "Create the thumbnail in memory: origId=" + origId + ", kind=" + kind + ", isVideo=" + isVideo);
                    Uri uri = Uri.parse(baseUri.buildUpon().appendPath(String.valueOf(origId)).toString().replaceFirst("thumbnails", "media"));
                    if (c != null) {
                        c.close();
                    }
                    if ((c = cr.query(uri, PROJECTION, null, null, null)) == null || !c.moveToFirst()) {
                        Bitmap bitmap4 = null;
                        return bitmap4;
                    }
                    String filePath = c.getString(1);
                    if (filePath != null) {
                        bitmap = isVideo ? ThumbnailUtils.createVideoThumbnail(filePath, kind) : ThumbnailUtils.createImageThumbnail(filePath, kind);
                    }
                }
            }
            catch (SQLiteException ex) {
                Log.w("MediaStore", ex);
            }
            finally {
                if (c != null) {
                    c.close();
                }
                thumbFile.deactivate();
                thumbFile = null;
            }
            return bitmap;
        }

        static void __staticInitializer__() {
            PROJECTION = new String[]{"_id", "_data"};
            sThumbBufLock = new Object();
        }

        private void __constructor__() {
            this.$$robo$$android_provider_MediaStore_InternalThumbnails$__constructor__();
        }

        private InternalThumbnails() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_InternalThumbnails$__constructor__(), 0, this);
        }

        private static Bitmap getMiniThumbFromFile(Cursor cursor, Uri uri, ContentResolver contentResolver, BitmapFactory.Options options) {
            return InvokeDynamicSupport.bootstrapStatic("getMiniThumbFromFile", $$robo$$android_provider_MediaStore_InternalThumbnails$getMiniThumbFromFile(android.database.Cursor android.net.Uri android.content.ContentResolver android.graphics.BitmapFactory$Options ), 0, (Cursor)cursor, (Uri)uri, (ContentResolver)contentResolver, (BitmapFactory.Options)options);
        }

        static void cancelThumbnailRequest(ContentResolver contentResolver, long l, Uri uri, long l2) {
            InvokeDynamicSupport.bootstrapStatic("cancelThumbnailRequest", $$robo$$android_provider_MediaStore_InternalThumbnails$cancelThumbnailRequest(android.content.ContentResolver long android.net.Uri long ), 0, (ContentResolver)contentResolver, (long)l, (Uri)uri, (long)l2);
        }

        static Bitmap getThumbnail(ContentResolver contentResolver, long l, long l2, int n, BitmapFactory.Options options, Uri uri, boolean bl) {
            return InvokeDynamicSupport.bootstrapStatic("getThumbnail", $$robo$$android_provider_MediaStore_InternalThumbnails$getThumbnail(android.content.ContentResolver long long int android.graphics.BitmapFactory$Options android.net.Uri boolean ), 0, (ContentResolver)contentResolver, (long)l, (long)l2, (int)n, (BitmapFactory.Options)options, (Uri)uri, (boolean)bl);
        }

        static {
            RobolectricInternals.classInitializing(InternalThumbnails.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InternalThumbnails)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Files
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_provider_MediaStore_Files$__constructor__() {
        }

        private static final Uri $$robo$$android_provider_MediaStore_Files$getContentUri(String volumeName) {
            return Uri.parse("content://media/" + volumeName + "/file");
        }

        private static final Uri $$robo$$android_provider_MediaStore_Files$getContentUri(String volumeName, long rowId) {
            return Uri.parse("content://media/" + volumeName + "/file/" + rowId);
        }

        private static final Uri $$robo$$android_provider_MediaStore_Files$getMtpObjectsUri(String volumeName) {
            return Uri.parse("content://media/" + volumeName + "/object");
        }

        private static final Uri $$robo$$android_provider_MediaStore_Files$getMtpObjectsUri(String volumeName, long fileId) {
            return Uri.parse("content://media/" + volumeName + "/object/" + fileId);
        }

        private static final Uri $$robo$$android_provider_MediaStore_Files$getMtpReferencesUri(String volumeName, long fileId) {
            return Uri.parse("content://media/" + volumeName + "/object/" + fileId + "/references");
        }

        private static final Uri $$robo$$android_provider_MediaStore_Files$getDirectoryUri(String volumeName) {
            return Uri.parse("content://media/" + volumeName + "/dir");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_MediaStore_Files$__constructor__();
        }

        public Files() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_MediaStore_Files$__constructor__(), 0, this);
        }

        public static Uri getContentUri(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Files$getContentUri(java.lang.String ), 0, (String)string2);
        }

        public static Uri getContentUri(String string2, long l) {
            return InvokeDynamicSupport.bootstrapStatic("getContentUri", $$robo$$android_provider_MediaStore_Files$getContentUri(java.lang.String long ), 0, (String)string2, (long)l);
        }

        public static Uri getMtpObjectsUri(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getMtpObjectsUri", $$robo$$android_provider_MediaStore_Files$getMtpObjectsUri(java.lang.String ), 0, (String)string2);
        }

        public static Uri getMtpObjectsUri(String string2, long l) {
            return InvokeDynamicSupport.bootstrapStatic("getMtpObjectsUri", $$robo$$android_provider_MediaStore_Files$getMtpObjectsUri(java.lang.String long ), 0, (String)string2, (long)l);
        }

        public static Uri getMtpReferencesUri(String string2, long l) {
            return InvokeDynamicSupport.bootstrapStatic("getMtpReferencesUri", $$robo$$android_provider_MediaStore_Files$getMtpReferencesUri(java.lang.String long ), 0, (String)string2, (long)l);
        }

        public static Uri getDirectoryUri(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getDirectoryUri", $$robo$$android_provider_MediaStore_Files$getDirectoryUri(java.lang.String ), 0, (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Files)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static interface FileColumns
        extends MediaColumns,
        InstrumentedInterface {
            public static final String STORAGE_ID = "storage_id";
            public static final String FORMAT = "format";
            public static final String PARENT = "parent";
            public static final String MIME_TYPE = "mime_type";
            public static final String TITLE = "title";
            public static final String MEDIA_TYPE = "media_type";
            public static final int MEDIA_TYPE_NONE = 0;
            public static final int MEDIA_TYPE_IMAGE = 1;
            public static final int MEDIA_TYPE_AUDIO = 2;
            public static final int MEDIA_TYPE_VIDEO = 3;
            public static final int MEDIA_TYPE_PLAYLIST = 4;
        }
    }

    public static interface MediaColumns
    extends BaseColumns,
    InstrumentedInterface {
        public static final String DATA = "_data";
        public static final String SIZE = "_size";
        public static final String DISPLAY_NAME = "_display_name";
        public static final String TITLE = "title";
        public static final String DATE_ADDED = "date_added";
        public static final String DATE_MODIFIED = "date_modified";
        public static final String MIME_TYPE = "mime_type";
        public static final String MEDIA_SCANNER_NEW_OBJECT_ID = "media_scanner_new_object_id";
        public static final String IS_DRM = "is_drm";
        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
    }
}

