/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AutofillServiceInfo
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AutofillServiceInfo";
    private ServiceInfo mServiceInfo;
    private String mSettingsActivity;

    private static final ServiceInfo $$robo$$android_service_autofill_AutofillServiceInfo$getServiceInfoOrThrow(ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
        try {
            ServiceInfo si = AppGlobals.getPackageManager().getServiceInfo(comp, 128, userHandle);
            if (si != null) {
                return si;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        throw new PackageManager.NameNotFoundException(comp.toString());
    }

    private void $$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(PackageManager pm, ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
    }

    private void $$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(PackageManager pm, ServiceInfo si) {
        this.mServiceInfo = si;
        TypedArray metaDataArray = AutofillServiceInfo.getMetaDataArray(pm, si);
        if (metaDataArray != null) {
            this.mSettingsActivity = metaDataArray.getString(0);
            metaDataArray.recycle();
        } else {
            this.mSettingsActivity = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TypedArray $$robo$$android_service_autofill_AutofillServiceInfo$getMetaDataArray(PackageManager pm, ServiceInfo si) {
        if (!"android.permission.BIND_AUTOFILL_SERVICE".equals(si.permission) && !"android.permission.BIND_AUTOFILL".equals(si.permission)) {
            Log.w("AutofillServiceInfo", "AutofillService from '" + si.packageName + "' does not require permission " + "android.permission.BIND_AUTOFILL_SERVICE");
            throw new SecurityException("Service does not require permission android.permission.BIND_AUTOFILL_SERVICE");
        }
        XmlResourceParser parser = si.loadXmlMetaData(pm, "android.autofill");
        if (parser == null) {
            return null;
        }
        try {
            Resources res;
            try {
                int type;
                while ((type = parser.next()) != 1 && type != 2) {
                }
            }
            catch (IOException | XmlPullParserException e) {
                Log.e("AutofillServiceInfo", "Error parsing auto fill service meta-data", e);
                TypedArray typedArray = null;
                parser.close();
                return typedArray;
            }
            if (!"autofill-service".equals(parser.getName())) {
                Log.e("AutofillServiceInfo", "Meta-data does not start with autofill-service tag");
                TypedArray e = null;
                return e;
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            try {
                res = pm.getResourcesForApplication(si.applicationInfo);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e("AutofillServiceInfo", "Error getting application resources", e);
                TypedArray typedArray = null;
                parser.close();
                return typedArray;
            }
            TypedArray typedArray = res.obtainAttributes(attrs, R.styleable.AutofillService);
            return typedArray;
        }
        finally {
            parser.close();
        }
    }

    private final ServiceInfo $$robo$$android_service_autofill_AutofillServiceInfo$getServiceInfo() {
        return this.mServiceInfo;
    }

    private final String $$robo$$android_service_autofill_AutofillServiceInfo$getSettingsActivity() {
        return this.mSettingsActivity;
    }

    private final String $$robo$$android_service_autofill_AutofillServiceInfo$toString() {
        return this.mServiceInfo == null ? "null" : this.mServiceInfo.toString();
    }

    private static ServiceInfo getServiceInfoOrThrow(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getServiceInfoOrThrow", $$robo$$android_service_autofill_AutofillServiceInfo$getServiceInfoOrThrow(android.content.ComponentName int ), 0, (ComponentName)componentName, (int)n);
    }

    private void __constructor__(PackageManager packageManager, ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        this.$$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(packageManager, componentName, n);
    }

    public AutofillServiceInfo(PackageManager packageManager, ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        this(packageManager, AutofillServiceInfo.getServiceInfoOrThrow(componentName, n));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(android.content.pm.PackageManager android.content.ComponentName int ), 0, this, packageManager, componentName, n);
    }

    private void __constructor__(PackageManager packageManager, ServiceInfo serviceInfo) {
        this.$$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(packageManager, serviceInfo);
    }

    public AutofillServiceInfo(PackageManager packageManager, ServiceInfo serviceInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_AutofillServiceInfo$__constructor__(android.content.pm.PackageManager android.content.pm.ServiceInfo ), 0, this, packageManager, serviceInfo);
    }

    private static TypedArray getMetaDataArray(PackageManager packageManager, ServiceInfo serviceInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getMetaDataArray", $$robo$$android_service_autofill_AutofillServiceInfo$getMetaDataArray(android.content.pm.PackageManager android.content.pm.ServiceInfo ), 0, (PackageManager)packageManager, (ServiceInfo)serviceInfo);
    }

    public ServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_service_autofill_AutofillServiceInfo$getServiceInfo(), 0, this);
    }

    public String getSettingsActivity() {
        return InvokeDynamicSupport.bootstrap("getSettingsActivity", $$robo$$android_service_autofill_AutofillServiceInfo$getSettingsActivity(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_autofill_AutofillServiceInfo$toString(), 0, this);
    }

    public /* synthetic */ AutofillServiceInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillServiceInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

