/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalTransformation;
import android.service.autofill.Transformation;
import android.service.autofill.ValueFinder;
import android.util.Log;
import android.util.Pair;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ImageTransformation
extends InternalTransformation
implements Transformation,
Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ImageTransformation";
    private AutofillId mId;
    private ArrayList<Pair<Pattern, Integer>> mOptions;
    public static Parcelable.Creator<ImageTransformation> CREATOR;

    private void $$robo$$android_service_autofill_ImageTransformation$__constructor__(Builder builder) {
        this.mId = builder.mId;
        this.mOptions = builder.mOptions;
    }

    private final void $$robo$$android_service_autofill_ImageTransformation$apply(ValueFinder finder, RemoteViews parentTemplate, int childViewId) throws Exception {
        String value = finder.findByAutofillId(this.mId);
        if (value == null) {
            Log.w("ImageTransformation", "No view for id " + this.mId);
            return;
        }
        int size = this.mOptions.size();
        if (Helper.sDebug) {
            Log.d("ImageTransformation", size + " multiple options on id " + childViewId + " to compare against");
        }
        for (int i = 0; i < size; ++i) {
            Pair<Pattern, Integer> option = this.mOptions.get(i);
            try {
                if (!((Pattern)option.first).matcher(value).matches()) continue;
                Log.d("ImageTransformation", "Found match at " + i + ": " + option);
                parentTemplate.setImageViewResource(childViewId, (Integer)option.second);
                return;
            }
            catch (Exception e) {
                Log.w("ImageTransformation", "Error matching regex #" + i + "(" + ((Pattern)option.first).pattern() + ") on id " + option.second + ": " + e.getClass());
                throw e;
            }
        }
        if (Helper.sDebug) {
            Log.d("ImageTransformation", "No match for " + value);
        }
    }

    private final String $$robo$$android_service_autofill_ImageTransformation$toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "ImageTransformation: [id=" + this.mId + ", options=" + this.mOptions + "]";
    }

    private final int $$robo$$android_service_autofill_ImageTransformation$describeContents() {
        return 0;
    }

    private final void $$robo$$android_service_autofill_ImageTransformation$writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mId, flags);
        int size = this.mOptions.size();
        Pattern[] regexs = new Pattern[size];
        int[] resIds = new int[size];
        for (int i = 0; i < size; ++i) {
            Pair<Pattern, Integer> regex = this.mOptions.get(i);
            regexs[i] = (Pattern)regex.first;
            resIds[i] = (Integer)regex.second;
        }
        parcel.writeSerializable((Serializable)regexs);
        parcel.writeIntArray(resIds);
    }

    private /* synthetic */ void $$robo$$android_service_autofill_ImageTransformation$__constructor__(Builder x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ImageTransformation>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_service_autofill_ImageTransformation_1$__constructor__() {
            }

            private final ImageTransformation $$robo$$android_service_autofill_ImageTransformation_1$createFromParcel(Parcel parcel) {
                AutofillId id2 = (AutofillId)parcel.readParcelable(null);
                Pattern[] regexs = (Pattern[])parcel.readSerializable();
                int[] resIds = parcel.createIntArray();
                Builder builder = new Builder(id2, regexs[0], resIds[0]);
                int size = regexs.length;
                for (int i = 1; i < size; ++i) {
                    builder.addOption(regexs[i], resIds[i]);
                }
                return builder.build();
            }

            private final ImageTransformation[] $$robo$$android_service_autofill_ImageTransformation_1$newArray(int size) {
                return new ImageTransformation[size];
            }

            private void __constructor__() {
                this.$$robo$$android_service_autofill_ImageTransformation_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_ImageTransformation_1$__constructor__(), 0, this);
            }

            @Override
            public ImageTransformation createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_autofill_ImageTransformation_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ImageTransformation[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_autofill_ImageTransformation_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_service_autofill_ImageTransformation$__constructor__(builder);
    }

    private ImageTransformation(Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_ImageTransformation$__constructor__(android.service.autofill.ImageTransformation$Builder ), 0, this, builder);
    }

    @Override
    public void apply(ValueFinder valueFinder, RemoteViews remoteViews, int n) throws Exception {
        InvokeDynamicSupport.bootstrap("apply", $$robo$$android_service_autofill_ImageTransformation$apply(android.service.autofill.ValueFinder android.widget.RemoteViews int ), 0, this, valueFinder, remoteViews, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_autofill_ImageTransformation$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_autofill_ImageTransformation$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_autofill_ImageTransformation$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_service_autofill_ImageTransformation$__constructor__(builder, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(ImageTransformation.class);
    }

    public /* synthetic */ ImageTransformation() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageTransformation)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AutofillId mId;
        private ArrayList<Pair<Pattern, Integer>> mOptions;
        private boolean mDestroyed;

        private void $$robo$$android_service_autofill_ImageTransformation_Builder$__constructor__(AutofillId id2, Pattern regex, int resId) {
            this.mOptions = new ArrayList();
            this.mId = Preconditions.checkNotNull(id2);
            this.addOption(regex, resId);
        }

        private final Builder $$robo$$android_service_autofill_ImageTransformation_Builder$addOption(Pattern regex, int resId) {
            this.throwIfDestroyed();
            Preconditions.checkNotNull(regex);
            Preconditions.checkArgument(resId != 0);
            this.mOptions.add(new Pair<Pattern, Integer>(regex, resId));
            return this;
        }

        private final ImageTransformation $$robo$$android_service_autofill_ImageTransformation_Builder$build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new ImageTransformation(this);
        }

        private final void $$robo$$android_service_autofill_ImageTransformation_Builder$throwIfDestroyed() {
            Preconditions.checkState(!this.mDestroyed, "Already called build()");
        }

        private void __constructor__(AutofillId autofillId, Pattern pattern, int n) {
            this.$$robo$$android_service_autofill_ImageTransformation_Builder$__constructor__(autofillId, pattern, n);
        }

        public Builder(AutofillId autofillId, Pattern pattern, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_ImageTransformation_Builder$__constructor__(android.view.autofill.AutofillId java.util.regex.Pattern int ), 0, this, autofillId, pattern, n);
        }

        public Builder addOption(Pattern pattern, int n) {
            return InvokeDynamicSupport.bootstrap("addOption", $$robo$$android_service_autofill_ImageTransformation_Builder$addOption(java.util.regex.Pattern int ), 0, this, pattern, n);
        }

        public ImageTransformation build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_service_autofill_ImageTransformation_Builder$build(), 0, this);
        }

        private void throwIfDestroyed() {
            InvokeDynamicSupport.bootstrap("throwIfDestroyed", $$robo$$android_service_autofill_ImageTransformation_Builder$throwIfDestroyed(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

