/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalValidator;
import android.service.autofill.Validator;
import android.service.autofill.ValueFinder;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class LuhnChecksumValidator
extends InternalValidator
implements Validator,
Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "LuhnChecksumValidator";
    private AutofillId[] mIds;
    public static Parcelable.Creator<LuhnChecksumValidator> CREATOR;

    private void $$robo$$android_service_autofill_LuhnChecksumValidator$__constructor__(AutofillId ... ids) {
        this.mIds = Preconditions.checkArrayElementsNotNull(ids, "ids");
    }

    private static final boolean $$robo$$android_service_autofill_LuhnChecksumValidator$isLuhnChecksumValid(String number) {
        int sum = 0;
        boolean isDoubled = false;
        for (int i = number.length() - 1; i >= 0; --i) {
            int addend;
            int digit = number.charAt(i) - 48;
            if (digit < 0 || digit > 9) continue;
            if (isDoubled) {
                addend = digit * 2;
                if (addend > 9) {
                    addend -= 9;
                }
            } else {
                addend = digit;
            }
            sum += addend;
            isDoubled = !isDoubled;
        }
        return sum % 10 == 0;
    }

    private final boolean $$robo$$android_service_autofill_LuhnChecksumValidator$isValid(ValueFinder finder) {
        if (this.mIds == null || this.mIds.length == 0) {
            return false;
        }
        StringBuilder number = new StringBuilder();
        for (AutofillId id2 : this.mIds) {
            String partialNumber = finder.findByAutofillId(id2);
            if (partialNumber == null) {
                if (Helper.sDebug) {
                    Log.d("LuhnChecksumValidator", "No partial number for id " + id2);
                }
                return false;
            }
            number.append(partialNumber);
        }
        return LuhnChecksumValidator.isLuhnChecksumValid(number.toString());
    }

    private final int $$robo$$android_service_autofill_LuhnChecksumValidator$describeContents() {
        return 0;
    }

    private final void $$robo$$android_service_autofill_LuhnChecksumValidator$writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelableArray(this.mIds, flags);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<LuhnChecksumValidator>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_service_autofill_LuhnChecksumValidator_1$__constructor__() {
            }

            private final LuhnChecksumValidator $$robo$$android_service_autofill_LuhnChecksumValidator_1$createFromParcel(Parcel parcel) {
                return new LuhnChecksumValidator((AutofillId[])parcel.readParcelableArray(null, AutofillId.class));
            }

            private final LuhnChecksumValidator[] $$robo$$android_service_autofill_LuhnChecksumValidator_1$newArray(int size) {
                return new LuhnChecksumValidator[size];
            }

            private void __constructor__() {
                this.$$robo$$android_service_autofill_LuhnChecksumValidator_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_LuhnChecksumValidator_1$__constructor__(), 0, this);
            }

            @Override
            public LuhnChecksumValidator createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_autofill_LuhnChecksumValidator_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public LuhnChecksumValidator[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_autofill_LuhnChecksumValidator_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(AutofillId ... autofillIdArray) {
        this.$$robo$$android_service_autofill_LuhnChecksumValidator$__constructor__(autofillIdArray);
    }

    public LuhnChecksumValidator(AutofillId ... autofillIdArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_LuhnChecksumValidator$__constructor__(android.view.autofill.AutofillId[] ), 0, this, autofillIdArray);
    }

    private static boolean isLuhnChecksumValid(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLuhnChecksumValid", $$robo$$android_service_autofill_LuhnChecksumValidator$isLuhnChecksumValid(java.lang.String ), 0, (String)string2);
    }

    @Override
    public boolean isValid(ValueFinder valueFinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_service_autofill_LuhnChecksumValidator$isValid(android.service.autofill.ValueFinder ), 0, this, valueFinder);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_autofill_LuhnChecksumValidator$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_autofill_LuhnChecksumValidator$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(LuhnChecksumValidator.class);
    }

    public /* synthetic */ LuhnChecksumValidator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LuhnChecksumValidator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

