/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.INotificationManager;
import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ConditionProviderService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    private H mHandler;
    private Provider mProvider;
    private INotificationManager mNoMan;
    public static String SERVICE_INTERFACE = "android.service.notification.ConditionProviderService";
    public static String META_DATA_RULE_TYPE = "android.service.zen.automatic.ruleType";
    public static String META_DATA_CONFIGURATION_ACTIVITY = "android.service.zen.automatic.configurationActivity";
    public static String META_DATA_RULE_INSTANCE_LIMIT = "android.service.zen.automatic.ruleInstanceLimit";
    public static String EXTRA_RULE_ID = "android.service.notification.extra.RULE_ID";

    private void $$robo$$android_service_notification_ConditionProviderService$__constructor__() {
        this.TAG = ConditionProviderService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
        this.mHandler = new H(this);
    }

    public abstract void onConnected();

    private final void $$robo$$android_service_notification_ConditionProviderService$onRequestConditions(int relevance) {
    }

    public abstract void onSubscribe(Uri var1);

    public abstract void onUnsubscribe(Uri var1);

    private final INotificationManager $$robo$$android_service_notification_ConditionProviderService$getNotificationInterface() {
        if (this.mNoMan == null) {
            this.mNoMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        }
        return this.mNoMan;
    }

    private static final void $$robo$$android_service_notification_ConditionProviderService$requestRebind(ComponentName componentName) {
        INotificationManager noMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        try {
            noMan.requestBindProvider(componentName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_service_notification_ConditionProviderService$requestUnbind() {
        INotificationManager noMan = this.getNotificationInterface();
        try {
            noMan.requestUnbindProvider(this.mProvider);
            this.mProvider = null;
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_service_notification_ConditionProviderService$notifyCondition(Condition condition) {
        if (condition == null) {
            return;
        }
        this.notifyConditions(condition);
    }

    private final void $$robo$$android_service_notification_ConditionProviderService$notifyConditions(Condition ... conditions) {
        if (!this.isBound() || conditions == null) {
            return;
        }
        try {
            this.getNotificationInterface().notifyConditions(this.getPackageName(), this.mProvider, conditions);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final IBinder $$robo$$android_service_notification_ConditionProviderService$onBind(Intent intent) {
        if (this.mProvider == null) {
            this.mProvider = new Provider(this);
        }
        return this.mProvider;
    }

    private final boolean $$robo$$android_service_notification_ConditionProviderService$isBound() {
        if (this.mProvider == null) {
            Log.w(this.TAG, "Condition provider service not yet bound.");
            return false;
        }
        return true;
    }

    private void __constructor__() {
        this.$$robo$$android_service_notification_ConditionProviderService$__constructor__();
    }

    public ConditionProviderService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ConditionProviderService$__constructor__(), 0, this);
    }

    public void onRequestConditions(int n) {
        InvokeDynamicSupport.bootstrap("onRequestConditions", $$robo$$android_service_notification_ConditionProviderService$onRequestConditions(int ), 0, this, n);
    }

    private INotificationManager getNotificationInterface() {
        return InvokeDynamicSupport.bootstrap("getNotificationInterface", $$robo$$android_service_notification_ConditionProviderService$getNotificationInterface(), 0, this);
    }

    public static void requestRebind(ComponentName componentName) {
        InvokeDynamicSupport.bootstrapStatic("requestRebind", $$robo$$android_service_notification_ConditionProviderService$requestRebind(android.content.ComponentName ), 0, (ComponentName)componentName);
    }

    public void requestUnbind() {
        InvokeDynamicSupport.bootstrap("requestUnbind", $$robo$$android_service_notification_ConditionProviderService$requestUnbind(), 0, this);
    }

    public void notifyCondition(Condition condition) {
        InvokeDynamicSupport.bootstrap("notifyCondition", $$robo$$android_service_notification_ConditionProviderService$notifyCondition(android.service.notification.Condition ), 0, this, condition);
    }

    public void notifyConditions(Condition ... conditionArray) {
        InvokeDynamicSupport.bootstrap("notifyConditions", $$robo$$android_service_notification_ConditionProviderService$notifyConditions(android.service.notification.Condition[] ), 0, this, conditionArray);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_notification_ConditionProviderService$onBind(android.content.Intent ), 0, this, intent);
    }

    private boolean isBound() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBound", $$robo$$android_service_notification_ConditionProviderService$isBound(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConditionProviderService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class H
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int ON_CONNECTED = 1;
        private static int ON_SUBSCRIBE = 3;
        private static int ON_UNSUBSCRIBE = 4;
        /* synthetic */ ConditionProviderService this$0;

        private void $$robo$$android_service_notification_ConditionProviderService_H$__constructor__(ConditionProviderService conditionProviderService) {
        }

        private final void $$robo$$android_service_notification_ConditionProviderService_H$handleMessage(Message msg) {
            String name = null;
            if (!this.this$0.isBound()) {
                return;
            }
            try {
                switch (msg.what) {
                    case 1: {
                        name = "onConnected";
                        this.this$0.onConnected();
                        break;
                    }
                    case 3: {
                        name = "onSubscribe";
                        this.this$0.onSubscribe((Uri)msg.obj);
                        break;
                    }
                    case 4: {
                        name = "onUnsubscribe";
                        this.this$0.onUnsubscribe((Uri)msg.obj);
                    }
                }
            }
            catch (Throwable t) {
                Log.w(this.this$0.TAG, "Error running " + name, t);
            }
        }

        private /* synthetic */ void $$robo$$android_service_notification_ConditionProviderService_H$__constructor__(ConditionProviderService x0, 1 x1) {
        }

        private void __constructor__(ConditionProviderService conditionProviderService) {
            this.$$robo$$android_service_notification_ConditionProviderService_H$__constructor__(conditionProviderService);
        }

        private H(ConditionProviderService conditionProviderService) {
            this.this$0 = conditionProviderService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ConditionProviderService_H$__constructor__(android.service.notification.ConditionProviderService ), 0, this, conditionProviderService);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_service_notification_ConditionProviderService_H$handleMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(ConditionProviderService conditionProviderService, 1 var2_2) {
            this.$$robo$$android_service_notification_ConditionProviderService_H$__constructor__(conditionProviderService, var2_2);
        }

        public /* synthetic */ H() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (H)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class Provider
    extends IConditionProvider.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ConditionProviderService this$0;

        private void $$robo$$android_service_notification_ConditionProviderService_Provider$__constructor__(ConditionProviderService conditionProviderService) {
        }

        private final void $$robo$$android_service_notification_ConditionProviderService_Provider$onConnected() {
            this.this$0.mHandler.obtainMessage(1).sendToTarget();
        }

        private final void $$robo$$android_service_notification_ConditionProviderService_Provider$onSubscribe(Uri conditionId) {
            this.this$0.mHandler.obtainMessage(3, conditionId).sendToTarget();
        }

        private final void $$robo$$android_service_notification_ConditionProviderService_Provider$onUnsubscribe(Uri conditionId) {
            this.this$0.mHandler.obtainMessage(4, conditionId).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_service_notification_ConditionProviderService_Provider$__constructor__(ConditionProviderService x0, 1 x1) {
        }

        private void __constructor__(ConditionProviderService conditionProviderService) {
            this.$$robo$$android_service_notification_ConditionProviderService_Provider$__constructor__(conditionProviderService);
        }

        private Provider(ConditionProviderService conditionProviderService) {
            this.this$0 = conditionProviderService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ConditionProviderService_Provider$__constructor__(android.service.notification.ConditionProviderService ), 0, this, conditionProviderService);
        }

        @Override
        public void onConnected() {
            InvokeDynamicSupport.bootstrap("onConnected", $$robo$$android_service_notification_ConditionProviderService_Provider$onConnected(), 0, this);
        }

        @Override
        public void onSubscribe(Uri uri) {
            InvokeDynamicSupport.bootstrap("onSubscribe", $$robo$$android_service_notification_ConditionProviderService_Provider$onSubscribe(android.net.Uri ), 0, this, uri);
        }

        @Override
        public void onUnsubscribe(Uri uri) {
            InvokeDynamicSupport.bootstrap("onUnsubscribe", $$robo$$android_service_notification_ConditionProviderService_Provider$onUnsubscribe(android.net.Uri ), 0, this, uri);
        }

        private /* synthetic */ void __constructor__(ConditionProviderService conditionProviderService, 1 var2_2) {
            this.$$robo$$android_service_notification_ConditionProviderService_Provider$__constructor__(conditionProviderService, var2_2);
        }

        public /* synthetic */ Provider() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Provider)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

