/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.content.Intent;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.KeyphraseEnrollmentInfo;
import android.hardware.soundtrigger.KeyphraseMetadata;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.AudioFormat;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.service.voice.IVoiceInteractionService;
import android.util.Slog;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AlwaysOnHotwordDetector
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int STATE_INVALID = -3;
    public static int STATE_HARDWARE_UNAVAILABLE = -2;
    public static int STATE_KEYPHRASE_UNSUPPORTED = -1;
    public static int STATE_KEYPHRASE_UNENROLLED = 1;
    public static int STATE_KEYPHRASE_ENROLLED = 2;
    private static int STATE_NOT_READY = 0;
    public static int MANAGE_ACTION_ENROLL = 0;
    public static int MANAGE_ACTION_RE_ENROLL = 1;
    public static int MANAGE_ACTION_UN_ENROLL = 2;
    public static int RECOGNITION_FLAG_NONE = 0;
    public static int RECOGNITION_FLAG_CAPTURE_TRIGGER_AUDIO = 1;
    public static int RECOGNITION_FLAG_ALLOW_MULTIPLE_TRIGGERS = 2;
    public static int RECOGNITION_MODE_VOICE_TRIGGER = 1;
    public static int RECOGNITION_MODE_USER_IDENTIFICATION = 2;
    static String TAG = "AlwaysOnHotwordDetector";
    static boolean DBG = false;
    private static int STATUS_ERROR = Integer.MIN_VALUE;
    private static int STATUS_OK = 0;
    private static int MSG_AVAILABILITY_CHANGED = 1;
    private static int MSG_HOTWORD_DETECTED = 2;
    private static int MSG_DETECTION_ERROR = 3;
    private static int MSG_DETECTION_PAUSE = 4;
    private static int MSG_DETECTION_RESUME = 5;
    private String mText;
    private Locale mLocale;
    private KeyphraseMetadata mKeyphraseMetadata;
    private KeyphraseEnrollmentInfo mKeyphraseEnrollmentInfo;
    private IVoiceInteractionService mVoiceInteractionService;
    private IVoiceInteractionManagerService mModelManagementService;
    private SoundTriggerListener mInternalCallback;
    private Callback mExternalCallback;
    private Object mLock;
    private Handler mHandler;
    private int mAvailability;

    private void $$robo$$android_service_voice_AlwaysOnHotwordDetector$__constructor__(String text, Locale locale, Callback callback, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo, IVoiceInteractionService voiceInteractionService, IVoiceInteractionManagerService modelManagementService) {
        this.mLock = new Object();
        this.mAvailability = 0;
        this.mText = text;
        this.mLocale = locale;
        this.mKeyphraseEnrollmentInfo = keyphraseEnrollmentInfo;
        this.mKeyphraseMetadata = this.mKeyphraseEnrollmentInfo.getKeyphraseMetadata(text, locale);
        this.mExternalCallback = callback;
        this.mHandler = new MyHandler(this);
        this.mInternalCallback = new SoundTriggerListener(this.mHandler);
        this.mVoiceInteractionService = voiceInteractionService;
        this.mModelManagementService = modelManagementService;
        new RefreshAvailabiltyTask(this).execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_service_voice_AlwaysOnHotwordDetector$getSupportedRecognitionModes() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getSupportedRecognitionModesLocked();
        }
    }

    private final int $$robo$$android_service_voice_AlwaysOnHotwordDetector$getSupportedRecognitionModesLocked() {
        if (this.mAvailability == -3) {
            throw new IllegalStateException("getSupportedRecognitionModes called on an invalid detector");
        }
        if (this.mAvailability != 2 && this.mAvailability != 1) {
            throw new UnsupportedOperationException("Getting supported recognition modes for the keyphrase is not supported");
        }
        return this.mKeyphraseMetadata.recognitionModeFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_service_voice_AlwaysOnHotwordDetector$startRecognition(int recognitionFlags) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailability == -3) {
                throw new IllegalStateException("startRecognition called on an invalid detector");
            }
            if (this.mAvailability != 2) {
                throw new UnsupportedOperationException("Recognition for the given keyphrase is not supported");
            }
            return this.startRecognitionLocked(recognitionFlags) == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_service_voice_AlwaysOnHotwordDetector$stopRecognition() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailability == -3) {
                throw new IllegalStateException("stopRecognition called on an invalid detector");
            }
            if (this.mAvailability != 2) {
                throw new UnsupportedOperationException("Recognition for the given keyphrase is not supported");
            }
            return this.stopRecognitionLocked() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Intent $$robo$$android_service_voice_AlwaysOnHotwordDetector$createEnrollIntent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getManageIntentLocked(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Intent $$robo$$android_service_voice_AlwaysOnHotwordDetector$createUnEnrollIntent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getManageIntentLocked(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Intent $$robo$$android_service_voice_AlwaysOnHotwordDetector$createReEnrollIntent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getManageIntentLocked(1);
        }
    }

    private final Intent $$robo$$android_service_voice_AlwaysOnHotwordDetector$getManageIntentLocked(int action) {
        if (this.mAvailability == -3) {
            throw new IllegalStateException("getManageIntent called on an invalid detector");
        }
        if (this.mAvailability != 2 && this.mAvailability != 1) {
            throw new UnsupportedOperationException("Managing the given keyphrase is not supported");
        }
        return this.mKeyphraseEnrollmentInfo.getManageKeyphraseIntent(action, this.mText, this.mLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector$invalidate() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAvailability = -3;
            this.notifyStateChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector$onSoundModelsChanged() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailability == -3 || this.mAvailability == -2 || this.mAvailability == -1) {
                Slog.w("AlwaysOnHotwordDetector", "Received onSoundModelsChanged for an unsupported keyphrase/config");
                return;
            }
            this.stopRecognitionLocked();
            new RefreshAvailabiltyTask(this).execute(new Void[0]);
        }
    }

    private final int $$robo$$android_service_voice_AlwaysOnHotwordDetector$startRecognitionLocked(int recognitionFlags) {
        SoundTrigger.KeyphraseRecognitionExtra[] recognitionExtra = new SoundTrigger.KeyphraseRecognitionExtra[]{new SoundTrigger.KeyphraseRecognitionExtra(this.mKeyphraseMetadata.id, this.mKeyphraseMetadata.recognitionModeFlags, 0, new SoundTrigger.ConfidenceLevel[0])};
        boolean captureTriggerAudio = (recognitionFlags & 1) != 0;
        boolean allowMultipleTriggers = (recognitionFlags & 2) != 0;
        int code = Integer.MIN_VALUE;
        try {
            code = this.mModelManagementService.startRecognition(this.mVoiceInteractionService, this.mKeyphraseMetadata.id, this.mLocale.toLanguageTag(), this.mInternalCallback, new SoundTrigger.RecognitionConfig(captureTriggerAudio, allowMultipleTriggers, recognitionExtra, null));
        }
        catch (RemoteException e) {
            Slog.w("AlwaysOnHotwordDetector", "RemoteException in startRecognition!", e);
        }
        if (code != 0) {
            Slog.w("AlwaysOnHotwordDetector", "startRecognition() failed with error code " + code);
        }
        return code;
    }

    private final int $$robo$$android_service_voice_AlwaysOnHotwordDetector$stopRecognitionLocked() {
        int code = Integer.MIN_VALUE;
        try {
            code = this.mModelManagementService.stopRecognition(this.mVoiceInteractionService, this.mKeyphraseMetadata.id, this.mInternalCallback);
        }
        catch (RemoteException e) {
            Slog.w("AlwaysOnHotwordDetector", "RemoteException in stopRecognition!", e);
        }
        if (code != 0) {
            Slog.w("AlwaysOnHotwordDetector", "stopRecognition() failed with error code " + code);
        }
        return code;
    }

    private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector$notifyStateChangedLocked() {
        Message message = Message.obtain(this.mHandler, 1);
        message.arg1 = this.mAvailability;
        message.sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector$dump(String prefix, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print(prefix);
            pw.print("Text=");
            pw.println(this.mText);
            pw.print(prefix);
            pw.print("Locale=");
            pw.println(this.mLocale);
            pw.print(prefix);
            pw.print("Availability=");
            pw.println(this.mAvailability);
            pw.print(prefix);
            pw.print("KeyphraseMetadata=");
            pw.println(this.mKeyphraseMetadata);
            pw.print(prefix);
            pw.print("EnrollmentInfo=");
            pw.println(this.mKeyphraseEnrollmentInfo);
        }
    }

    private void __constructor__(String string2, Locale locale, Callback callback, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo, IVoiceInteractionService iVoiceInteractionService, IVoiceInteractionManagerService iVoiceInteractionManagerService) {
        this.$$robo$$android_service_voice_AlwaysOnHotwordDetector$__constructor__(string2, locale, callback, keyphraseEnrollmentInfo, iVoiceInteractionService, iVoiceInteractionManagerService);
    }

    public AlwaysOnHotwordDetector(String string2, Locale locale, Callback callback, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo, IVoiceInteractionService iVoiceInteractionService, IVoiceInteractionManagerService iVoiceInteractionManagerService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_AlwaysOnHotwordDetector$__constructor__(java.lang.String java.util.Locale android.service.voice.AlwaysOnHotwordDetector$Callback android.hardware.soundtrigger.KeyphraseEnrollmentInfo android.service.voice.IVoiceInteractionService com.android.internal.app.IVoiceInteractionManagerService ), 0, this, string2, locale, callback, keyphraseEnrollmentInfo, iVoiceInteractionService, iVoiceInteractionManagerService);
    }

    public int getSupportedRecognitionModes() {
        return (int)InvokeDynamicSupport.bootstrap("getSupportedRecognitionModes", $$robo$$android_service_voice_AlwaysOnHotwordDetector$getSupportedRecognitionModes(), 0, this);
    }

    private int getSupportedRecognitionModesLocked() {
        return (int)InvokeDynamicSupport.bootstrap("getSupportedRecognitionModesLocked", $$robo$$android_service_voice_AlwaysOnHotwordDetector$getSupportedRecognitionModesLocked(), 0, this);
    }

    public boolean startRecognition(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("startRecognition", $$robo$$android_service_voice_AlwaysOnHotwordDetector$startRecognition(int ), 0, this, n);
    }

    public boolean stopRecognition() {
        return (boolean)InvokeDynamicSupport.bootstrap("stopRecognition", $$robo$$android_service_voice_AlwaysOnHotwordDetector$stopRecognition(), 0, this);
    }

    public Intent createEnrollIntent() {
        return InvokeDynamicSupport.bootstrap("createEnrollIntent", $$robo$$android_service_voice_AlwaysOnHotwordDetector$createEnrollIntent(), 0, this);
    }

    public Intent createUnEnrollIntent() {
        return InvokeDynamicSupport.bootstrap("createUnEnrollIntent", $$robo$$android_service_voice_AlwaysOnHotwordDetector$createUnEnrollIntent(), 0, this);
    }

    public Intent createReEnrollIntent() {
        return InvokeDynamicSupport.bootstrap("createReEnrollIntent", $$robo$$android_service_voice_AlwaysOnHotwordDetector$createReEnrollIntent(), 0, this);
    }

    private Intent getManageIntentLocked(int n) {
        return InvokeDynamicSupport.bootstrap("getManageIntentLocked", $$robo$$android_service_voice_AlwaysOnHotwordDetector$getManageIntentLocked(int ), 0, this, n);
    }

    void invalidate() {
        InvokeDynamicSupport.bootstrap("invalidate", $$robo$$android_service_voice_AlwaysOnHotwordDetector$invalidate(), 0, this);
    }

    void onSoundModelsChanged() {
        InvokeDynamicSupport.bootstrap("onSoundModelsChanged", $$robo$$android_service_voice_AlwaysOnHotwordDetector$onSoundModelsChanged(), 0, this);
    }

    private int startRecognitionLocked(int n) {
        return (int)InvokeDynamicSupport.bootstrap("startRecognitionLocked", $$robo$$android_service_voice_AlwaysOnHotwordDetector$startRecognitionLocked(int ), 0, this, n);
    }

    private int stopRecognitionLocked() {
        return (int)InvokeDynamicSupport.bootstrap("stopRecognitionLocked", $$robo$$android_service_voice_AlwaysOnHotwordDetector$stopRecognitionLocked(), 0, this);
    }

    private void notifyStateChangedLocked() {
        InvokeDynamicSupport.bootstrap("notifyStateChangedLocked", $$robo$$android_service_voice_AlwaysOnHotwordDetector$notifyStateChangedLocked(), 0, this);
    }

    public void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_service_voice_AlwaysOnHotwordDetector$dump(java.lang.String java.io.PrintWriter ), 0, this, string2, printWriter);
    }

    public /* synthetic */ AlwaysOnHotwordDetector() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlwaysOnHotwordDetector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class RefreshAvailabiltyTask
    extends AsyncTask<Void, Void, Void> {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AlwaysOnHotwordDetector this$0;

        private void $$robo$$android_service_voice_AlwaysOnHotwordDetector_RefreshAvailabiltyTask$__constructor__(AlwaysOnHotwordDetector this$0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Void $$robo$$android_service_voice_AlwaysOnHotwordDetector_RefreshAvailabiltyTask$doInBackground(Void ... params) {
            int availability = this.internalGetInitialAvailability();
            boolean enrolled = false;
            if (availability == 0 || availability == 1 || availability == 2) {
                enrolled = this.internalGetIsEnrolled(((AlwaysOnHotwordDetector)this.this$0).mKeyphraseMetadata.id, this.this$0.mLocale);
                availability = !enrolled ? 1 : 2;
            }
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mAvailability = availability;
                this.this$0.notifyStateChangedLocked();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_service_voice_AlwaysOnHotwordDetector_RefreshAvailabiltyTask$internalGetInitialAvailability() {
            Object object = this.this$0.mLock;
            synchronized (object) {
                if (this.this$0.mAvailability == -3) {
                    return -3;
                }
            }
            SoundTrigger.ModuleProperties dspModuleProperties = null;
            try {
                dspModuleProperties = this.this$0.mModelManagementService.getDspModuleProperties(this.this$0.mVoiceInteractionService);
            }
            catch (RemoteException e) {
                Slog.w("AlwaysOnHotwordDetector", "RemoteException in getDspProperties!", e);
            }
            if (dspModuleProperties == null) {
                return -2;
            }
            if (this.this$0.mKeyphraseMetadata == null) {
                return -1;
            }
            return 0;
        }

        private final boolean $$robo$$android_service_voice_AlwaysOnHotwordDetector_RefreshAvailabiltyTask$internalGetIsEnrolled(int keyphraseId, Locale locale) {
            try {
                return this.this$0.mModelManagementService.isEnrolledForKeyphrase(this.this$0.mVoiceInteractionService, keyphraseId, locale.toLanguageTag());
            }
            catch (RemoteException e) {
                Slog.w("AlwaysOnHotwordDetector", "RemoteException in listRegisteredKeyphraseSoundModels!", e);
                return false;
            }
        }

        private void __constructor__(AlwaysOnHotwordDetector alwaysOnHotwordDetector) {
            this.$$robo$$android_service_voice_AlwaysOnHotwordDetector_RefreshAvailabiltyTask$__constructor__(alwaysOnHotwordDetector);
        }

        RefreshAvailabiltyTask(AlwaysOnHotwordDetector alwaysOnHotwordDetector) {
            this.this$0 = alwaysOnHotwordDetector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_AlwaysOnHotwordDetector_RefreshAvailabiltyTask$__constructor__(android.service.voice.AlwaysOnHotwordDetector ), 0, this, alwaysOnHotwordDetector);
        }

        public Void doInBackground(Void ... voidArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$android_service_voice_AlwaysOnHotwordDetector_RefreshAvailabiltyTask$doInBackground(java.lang.Void[] ), 0, this, voidArray);
        }

        private int internalGetInitialAvailability() {
            return (int)InvokeDynamicSupport.bootstrap("internalGetInitialAvailability", $$robo$$android_service_voice_AlwaysOnHotwordDetector_RefreshAvailabiltyTask$internalGetInitialAvailability(), 0, this);
        }

        private boolean internalGetIsEnrolled(int n, Locale locale) {
            return (boolean)InvokeDynamicSupport.bootstrap("internalGetIsEnrolled", $$robo$$android_service_voice_AlwaysOnHotwordDetector_RefreshAvailabiltyTask$internalGetIsEnrolled(int java.util.Locale ), 0, this, n, locale);
        }

        public /* synthetic */ RefreshAvailabiltyTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RefreshAvailabiltyTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AlwaysOnHotwordDetector this$0;

        private void $$robo$$android_service_voice_AlwaysOnHotwordDetector_MyHandler$__constructor__(AlwaysOnHotwordDetector this$0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector_MyHandler$handleMessage(Message msg) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                if (this.this$0.mAvailability == -3) {
                    Slog.w("AlwaysOnHotwordDetector", "Received message: " + msg.what + " for an invalid detector");
                    return;
                }
            }
            switch (msg.what) {
                case 1: {
                    this.this$0.mExternalCallback.onAvailabilityChanged(msg.arg1);
                    break;
                }
                case 2: {
                    this.this$0.mExternalCallback.onDetected((EventPayload)msg.obj);
                    break;
                }
                case 3: {
                    this.this$0.mExternalCallback.onError();
                    break;
                }
                case 4: {
                    this.this$0.mExternalCallback.onRecognitionPaused();
                    break;
                }
                case 5: {
                    this.this$0.mExternalCallback.onRecognitionResumed();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }

        private void __constructor__(AlwaysOnHotwordDetector alwaysOnHotwordDetector) {
            this.$$robo$$android_service_voice_AlwaysOnHotwordDetector_MyHandler$__constructor__(alwaysOnHotwordDetector);
        }

        MyHandler(AlwaysOnHotwordDetector alwaysOnHotwordDetector) {
            this.this$0 = alwaysOnHotwordDetector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_AlwaysOnHotwordDetector_MyHandler$__constructor__(android.service.voice.AlwaysOnHotwordDetector ), 0, this, alwaysOnHotwordDetector);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_service_voice_AlwaysOnHotwordDetector_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SoundTriggerListener
    extends IRecognitionStatusCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;

        private void $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$__constructor__(Handler handler) {
            this.mHandler = handler;
        }

        private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent event) {
            Slog.i("AlwaysOnHotwordDetector", "onDetected");
            Message.obtain(this.mHandler, 2, new EventPayload(event.triggerInData, event.captureAvailable, event.captureFormat, event.captureSession, event.data)).sendToTarget();
        }

        private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent event) {
            Slog.w("AlwaysOnHotwordDetector", "Generic sound trigger event detected at AOHD: " + event);
        }

        private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onError(int status) {
            Slog.i("AlwaysOnHotwordDetector", "onError: " + status);
            this.mHandler.sendEmptyMessage(3);
        }

        private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onRecognitionPaused() {
            Slog.i("AlwaysOnHotwordDetector", "onRecognitionPaused");
            this.mHandler.sendEmptyMessage(4);
        }

        private final void $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onRecognitionResumed() {
            Slog.i("AlwaysOnHotwordDetector", "onRecognitionResumed");
            this.mHandler.sendEmptyMessage(5);
        }

        private void __constructor__(Handler handler) {
            this.$$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$__constructor__(handler);
        }

        public SoundTriggerListener(Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$__constructor__(android.os.Handler ), 0, this, handler);
        }

        @Override
        public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent keyphraseRecognitionEvent) {
            InvokeDynamicSupport.bootstrap("onKeyphraseDetected", $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onKeyphraseDetected(android.hardware.soundtrigger.SoundTrigger$KeyphraseRecognitionEvent ), 0, this, keyphraseRecognitionEvent);
        }

        @Override
        public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent genericRecognitionEvent) {
            InvokeDynamicSupport.bootstrap("onGenericSoundTriggerDetected", $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onGenericSoundTriggerDetected(android.hardware.soundtrigger.SoundTrigger$GenericRecognitionEvent ), 0, this, genericRecognitionEvent);
        }

        @Override
        public void onError(int n) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onError(int ), 0, this, n);
        }

        @Override
        public void onRecognitionPaused() {
            InvokeDynamicSupport.bootstrap("onRecognitionPaused", $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onRecognitionPaused(), 0, this);
        }

        @Override
        public void onRecognitionResumed() {
            InvokeDynamicSupport.bootstrap("onRecognitionResumed", $$robo$$android_service_voice_AlwaysOnHotwordDetector_SoundTriggerListener$onRecognitionResumed(), 0, this);
        }

        public /* synthetic */ SoundTriggerListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundTriggerListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_service_voice_AlwaysOnHotwordDetector_Callback$__constructor__() {
        }

        public abstract void onAvailabilityChanged(int var1);

        public abstract void onDetected(EventPayload var1);

        public abstract void onError();

        public abstract void onRecognitionPaused();

        public abstract void onRecognitionResumed();

        private void __constructor__() {
            this.$$robo$$android_service_voice_AlwaysOnHotwordDetector_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_AlwaysOnHotwordDetector_Callback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class EventPayload
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mTriggerAvailable;
        private boolean mCaptureAvailable;
        private int mCaptureSession;
        private AudioFormat mAudioFormat;
        private byte[] mData;

        private void $$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$__constructor__(boolean triggerAvailable, boolean captureAvailable, AudioFormat audioFormat, int captureSession, byte[] data) {
            this.mTriggerAvailable = triggerAvailable;
            this.mCaptureAvailable = captureAvailable;
            this.mCaptureSession = captureSession;
            this.mAudioFormat = audioFormat;
            this.mData = data;
        }

        private final AudioFormat $$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$getCaptureAudioFormat() {
            return this.mAudioFormat;
        }

        private final byte[] $$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$getTriggerAudio() {
            if (this.mTriggerAvailable) {
                return this.mData;
            }
            return null;
        }

        private final Integer $$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$getCaptureSession() {
            if (this.mCaptureAvailable) {
                return this.mCaptureSession;
            }
            return null;
        }

        private /* synthetic */ void $$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$__constructor__(boolean x0, boolean x1, AudioFormat x2, int x3, byte[] x4, 1 x5) {
        }

        private void __constructor__(boolean bl, boolean bl2, AudioFormat audioFormat, int n, byte[] byArray) {
            this.$$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$__constructor__(bl, bl2, audioFormat, n, byArray);
        }

        private EventPayload(boolean bl, boolean bl2, AudioFormat audioFormat, int n, byte[] byArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$__constructor__(boolean boolean android.media.AudioFormat int byte[] ), 0, this, bl, bl2, audioFormat, n, byArray);
        }

        public AudioFormat getCaptureAudioFormat() {
            return InvokeDynamicSupport.bootstrap("getCaptureAudioFormat", $$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$getCaptureAudioFormat(), 0, this);
        }

        public byte[] getTriggerAudio() {
            return InvokeDynamicSupport.bootstrap("getTriggerAudio", $$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$getTriggerAudio(), 0, this);
        }

        public Integer getCaptureSession() {
            return InvokeDynamicSupport.bootstrap("getCaptureSession", $$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$getCaptureSession(), 0, this);
        }

        private /* synthetic */ void __constructor__(boolean bl, boolean bl2, AudioFormat audioFormat, int n, byte[] byArray, 1 var6_6) {
            this.$$robo$$android_service_voice_AlwaysOnHotwordDetector_EventPayload$__constructor__(bl, bl2, audioFormat, n, byArray, var6_6);
        }

        public /* synthetic */ EventPayload() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventPayload)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecognitionModes {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecognitionFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ManageActions {
    }
}

