/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.hardware.soundtrigger.KeyphraseEnrollmentInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.voice.AlwaysOnHotwordDetector;
import android.service.voice.IVoiceInteractionService;
import com.android.internal.app.IVoiceInteractionManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VoiceInteractionService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String SERVICE_INTERFACE = "android.service.voice.VoiceInteractionService";
    public static String SERVICE_META_DATA = "android.voice_interaction";
    IVoiceInteractionService mInterface;
    MyHandler mHandler;
    IVoiceInteractionManagerService mSystemService;
    private Object mLock;
    private KeyphraseEnrollmentInfo mKeyphraseEnrollmentInfo;
    private AlwaysOnHotwordDetector mHotwordDetector;
    static int MSG_READY = 1;
    static int MSG_SHUTDOWN = 2;
    static int MSG_SOUND_MODELS_CHANGED = 3;
    static int MSG_LAUNCH_VOICE_ASSIST_FROM_KEYGUARD = 4;

    private void $$robo$$android_service_voice_VoiceInteractionService$__constructor__() {
        this.mInterface = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ VoiceInteractionService this$0;

            private void $$robo$$android_service_voice_VoiceInteractionService_1$__constructor__(VoiceInteractionService this$0) {
            }

            private final void $$robo$$android_service_voice_VoiceInteractionService_1$ready() {
                this.this$0.mHandler.sendEmptyMessage(1);
            }

            private final void $$robo$$android_service_voice_VoiceInteractionService_1$shutdown() {
                this.this$0.mHandler.sendEmptyMessage(2);
            }

            private final void $$robo$$android_service_voice_VoiceInteractionService_1$soundModelsChanged() {
                this.this$0.mHandler.sendEmptyMessage(3);
            }

            private final void $$robo$$android_service_voice_VoiceInteractionService_1$launchVoiceAssistFromKeyguard() throws RemoteException {
                this.this$0.mHandler.sendEmptyMessage(4);
            }

            private void __constructor__(VoiceInteractionService voiceInteractionService) {
                this.$$robo$$android_service_voice_VoiceInteractionService_1$__constructor__(voiceInteractionService);
            }
            {
                this.this$0 = voiceInteractionService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_VoiceInteractionService_1$__constructor__(android.service.voice.VoiceInteractionService ), 0, this, voiceInteractionService);
            }

            @Override
            public void ready() {
                InvokeDynamicSupport.bootstrap("ready", $$robo$$android_service_voice_VoiceInteractionService_1$ready(), 0, this);
            }

            @Override
            public void shutdown() {
                InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_service_voice_VoiceInteractionService_1$shutdown(), 0, this);
            }

            @Override
            public void soundModelsChanged() {
                InvokeDynamicSupport.bootstrap("soundModelsChanged", $$robo$$android_service_voice_VoiceInteractionService_1$soundModelsChanged(), 0, this);
            }

            @Override
            public void launchVoiceAssistFromKeyguard() throws RemoteException {
                InvokeDynamicSupport.bootstrap("launchVoiceAssistFromKeyguard", $$robo$$android_service_voice_VoiceInteractionService_1$launchVoiceAssistFromKeyguard(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mLock = new Object();
    }

    private final void $$robo$$android_service_voice_VoiceInteractionService$onLaunchVoiceAssistFromKeyguard() {
    }

    private static final boolean $$robo$$android_service_voice_VoiceInteractionService$isActiveService(Context context, ComponentName service) {
        String cur = Settings.Secure.getString(context.getContentResolver(), "voice_interaction_service");
        if (cur == null || cur.isEmpty()) {
            return false;
        }
        ComponentName curComp = ComponentName.unflattenFromString(cur);
        if (curComp == null) {
            return false;
        }
        return curComp.equals(service);
    }

    private final void $$robo$$android_service_voice_VoiceInteractionService$setDisabledShowContext(int flags) {
        try {
            this.mSystemService.setDisabledShowContext(flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final int $$robo$$android_service_voice_VoiceInteractionService$getDisabledShowContext() {
        try {
            return this.mSystemService.getDisabledShowContext();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    private final void $$robo$$android_service_voice_VoiceInteractionService$showSession(Bundle args, int flags) {
        if (this.mSystemService == null) {
            throw new IllegalStateException("Not available until onReady() is called");
        }
        try {
            this.mSystemService.showSession(this.mInterface, args, flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_service_voice_VoiceInteractionService$onCreate() {
        super.onCreate();
        this.mHandler = new MyHandler(this);
    }

    private final IBinder $$robo$$android_service_voice_VoiceInteractionService$onBind(Intent intent) {
        if ("android.service.voice.VoiceInteractionService".equals(intent.getAction())) {
            return this.mInterface.asBinder();
        }
        return null;
    }

    private final void $$robo$$android_service_voice_VoiceInteractionService$onReady() {
        this.mSystemService = IVoiceInteractionManagerService.Stub.asInterface(ServiceManager.getService("voiceinteraction"));
        this.mKeyphraseEnrollmentInfo = new KeyphraseEnrollmentInfo(this.getPackageManager());
    }

    private final void $$robo$$android_service_voice_VoiceInteractionService$onShutdownInternal() {
        this.onShutdown();
        this.safelyShutdownHotwordDetector();
    }

    private final void $$robo$$android_service_voice_VoiceInteractionService$onShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_service_voice_VoiceInteractionService$onSoundModelsChangedInternal() {
        VoiceInteractionService voiceInteractionService = this;
        synchronized (voiceInteractionService) {
            if (this.mHotwordDetector != null) {
                this.mHotwordDetector.onSoundModelsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AlwaysOnHotwordDetector $$robo$$android_service_voice_VoiceInteractionService$createAlwaysOnHotwordDetector(String keyphrase, Locale locale, AlwaysOnHotwordDetector.Callback callback) {
        if (this.mSystemService == null) {
            throw new IllegalStateException("Not available until onReady() is called");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.safelyShutdownHotwordDetector();
            this.mHotwordDetector = new AlwaysOnHotwordDetector(keyphrase, locale, callback, this.mKeyphraseEnrollmentInfo, this.mInterface, this.mSystemService);
        }
        return this.mHotwordDetector;
    }

    private final KeyphraseEnrollmentInfo $$robo$$android_service_voice_VoiceInteractionService$getKeyphraseEnrollmentInfo() {
        return this.mKeyphraseEnrollmentInfo;
    }

    private final boolean $$robo$$android_service_voice_VoiceInteractionService$isKeyphraseAndLocaleSupportedForHotword(String keyphrase, Locale locale) {
        if (this.mKeyphraseEnrollmentInfo == null) {
            return false;
        }
        return this.mKeyphraseEnrollmentInfo.getKeyphraseMetadata(keyphrase, locale) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_service_voice_VoiceInteractionService$safelyShutdownHotwordDetector() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHotwordDetector != null) {
                    this.mHotwordDetector.stopRecognition();
                    this.mHotwordDetector.invalidate();
                    this.mHotwordDetector = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_service_voice_VoiceInteractionService$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("VOICE INTERACTION");
        Object object = this.mLock;
        synchronized (object) {
            pw.println("  AlwaysOnHotwordDetector");
            if (this.mHotwordDetector == null) {
                pw.println("    NULL");
            } else {
                this.mHotwordDetector.dump("    ", pw);
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$android_service_voice_VoiceInteractionService$__constructor__();
    }

    public VoiceInteractionService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_VoiceInteractionService$__constructor__(), 0, this);
    }

    public void onLaunchVoiceAssistFromKeyguard() {
        InvokeDynamicSupport.bootstrap("onLaunchVoiceAssistFromKeyguard", $$robo$$android_service_voice_VoiceInteractionService$onLaunchVoiceAssistFromKeyguard(), 0, this);
    }

    public static boolean isActiveService(Context context, ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isActiveService", $$robo$$android_service_voice_VoiceInteractionService$isActiveService(android.content.Context android.content.ComponentName ), 0, (Context)context, (ComponentName)componentName);
    }

    public void setDisabledShowContext(int n) {
        InvokeDynamicSupport.bootstrap("setDisabledShowContext", $$robo$$android_service_voice_VoiceInteractionService$setDisabledShowContext(int ), 0, this, n);
    }

    public int getDisabledShowContext() {
        return (int)InvokeDynamicSupport.bootstrap("getDisabledShowContext", $$robo$$android_service_voice_VoiceInteractionService$getDisabledShowContext(), 0, this);
    }

    public void showSession(Bundle bundle, int n) {
        InvokeDynamicSupport.bootstrap("showSession", $$robo$$android_service_voice_VoiceInteractionService$showSession(android.os.Bundle int ), 0, this, bundle, n);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_service_voice_VoiceInteractionService$onCreate(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_voice_VoiceInteractionService$onBind(android.content.Intent ), 0, this, intent);
    }

    public void onReady() {
        InvokeDynamicSupport.bootstrap("onReady", $$robo$$android_service_voice_VoiceInteractionService$onReady(), 0, this);
    }

    private void onShutdownInternal() {
        InvokeDynamicSupport.bootstrap("onShutdownInternal", $$robo$$android_service_voice_VoiceInteractionService$onShutdownInternal(), 0, this);
    }

    public void onShutdown() {
        InvokeDynamicSupport.bootstrap("onShutdown", $$robo$$android_service_voice_VoiceInteractionService$onShutdown(), 0, this);
    }

    private void onSoundModelsChangedInternal() {
        InvokeDynamicSupport.bootstrap("onSoundModelsChangedInternal", $$robo$$android_service_voice_VoiceInteractionService$onSoundModelsChangedInternal(), 0, this);
    }

    public AlwaysOnHotwordDetector createAlwaysOnHotwordDetector(String string2, Locale locale, AlwaysOnHotwordDetector.Callback callback) {
        return InvokeDynamicSupport.bootstrap("createAlwaysOnHotwordDetector", $$robo$$android_service_voice_VoiceInteractionService$createAlwaysOnHotwordDetector(java.lang.String java.util.Locale android.service.voice.AlwaysOnHotwordDetector$Callback ), 0, this, string2, locale, callback);
    }

    protected KeyphraseEnrollmentInfo getKeyphraseEnrollmentInfo() {
        return InvokeDynamicSupport.bootstrap("getKeyphraseEnrollmentInfo", $$robo$$android_service_voice_VoiceInteractionService$getKeyphraseEnrollmentInfo(), 0, this);
    }

    public boolean isKeyphraseAndLocaleSupportedForHotword(String string2, Locale locale) {
        return (boolean)InvokeDynamicSupport.bootstrap("isKeyphraseAndLocaleSupportedForHotword", $$robo$$android_service_voice_VoiceInteractionService$isKeyphraseAndLocaleSupportedForHotword(java.lang.String java.util.Locale ), 0, this, string2, locale);
    }

    private void safelyShutdownHotwordDetector() {
        InvokeDynamicSupport.bootstrap("safelyShutdownHotwordDetector", $$robo$$android_service_voice_VoiceInteractionService$safelyShutdownHotwordDetector(), 0, this);
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_service_voice_VoiceInteractionService$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VoiceInteractionService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ VoiceInteractionService this$0;

        private void $$robo$$android_service_voice_VoiceInteractionService_MyHandler$__constructor__(VoiceInteractionService this$0) {
        }

        private final void $$robo$$android_service_voice_VoiceInteractionService_MyHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.this$0.onReady();
                    break;
                }
                case 2: {
                    this.this$0.onShutdownInternal();
                    break;
                }
                case 3: {
                    this.this$0.onSoundModelsChangedInternal();
                    break;
                }
                case 4: {
                    this.this$0.onLaunchVoiceAssistFromKeyguard();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }

        private void __constructor__(VoiceInteractionService voiceInteractionService) {
            this.$$robo$$android_service_voice_VoiceInteractionService_MyHandler$__constructor__(voiceInteractionService);
        }

        MyHandler(VoiceInteractionService voiceInteractionService) {
            this.this$0 = voiceInteractionService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_VoiceInteractionService_MyHandler$__constructor__(android.service.voice.VoiceInteractionService ), 0, this, voiceInteractionService);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_service_voice_VoiceInteractionService_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

